const tests = [
  [-0x10000000000000001n, 0n, -0x10000000000000001n],
  [-0x10000000000000000n, 0n, -0x10000000000000000n],
  [-0xffffffffffffffffn, 0n, -0xffffffffffffffffn],
  [-0xfffffffffffffffen, 0n, -0xfffffffffffffffen],
  [-0x8000000000000001n, 0n, -0x8000000000000001n],
  [-0x8000000000000000n, 0n, -0x8000000000000000n],
  [-0x7fffffffffffffffn, 0n, -0x7fffffffffffffffn],
  [-0x7ffffffffffffffen, 0n, -0x7ffffffffffffffen],
  [-0x100000001n, 0n, -0x100000001n],
  [-0x100000000n, 0n, -0x100000000n],
  [-0xffffffffn, 0n, -0xffffffffn],
  [-0xfffffffen, 0n, -0xfffffffen],
  [-0x80000001n, 0n, -0x80000001n],
  [-0x80000000n, 0n, -0x80000000n],
  [-0x7fffffffn, 0n, -0x7fffffffn],
  [-0x7ffffffen, 0n, -0x7ffffffen],
  [-9n, 0n, -9n],
  [-8n, 0n, -8n],
  [-7n, 0n, -7n],
  [-6n, 0n, -6n],
  [-5n, 0n, -5n],
  [-4n, 0n, -4n],
  [-3n, 0n, -3n],
  [-2n, 0n, -2n],
  [-1n, 0n, -1n],
  [0n, 0n, 0n],
  [1n, 0n, 1n],
  [2n, 0n, 2n],
  [3n, 0n, 3n],
  [4n, 0n, 4n],
  [5n, 0n, 5n],
  [6n, 0n, 6n],
  [7n, 0n, 7n],
  [8n, 0n, 8n],
  [9n, 0n, 9n],
  [0x7ffffffen, 0n, 0x7ffffffen],
  [0x7fffffffn, 0n, 0x7fffffffn],
  [0x80000000n, 0n, 0x80000000n],
  [0x80000001n, 0n, 0x80000001n],
  [0xfffffffen, 0n, 0xfffffffen],
  [0xffffffffn, 0n, 0xffffffffn],
  [0x100000000n, 0n, 0x100000000n],
  [0x100000001n, 0n, 0x100000001n],
  [0x7ffffffffffffffen, 0n, 0x7ffffffffffffffen],
  [0x7fffffffffffffffn, 0n, 0x7fffffffffffffffn],
  [0x8000000000000000n, 0n, 0x8000000000000000n],
  [0x8000000000000001n, 0n, 0x8000000000000001n],
  [0xfffffffffffffffen, 0n, 0xfffffffffffffffen],
  [0xffffffffffffffffn, 0n, 0xffffffffffffffffn],
  [0x10000000000000000n, 0n, 0x10000000000000000n],
  [0x10000000000000001n, 0n, 0x10000000000000001n],
  [-0x10000000000000001n, 1n, -0x20000000000000002n],
  [-0x10000000000000000n, 1n, -0x20000000000000000n],
  [-0xffffffffffffffffn, 1n, -0x1fffffffffffffffen],
  [-0xfffffffffffffffen, 1n, -0x1fffffffffffffffcn],
  [-0x8000000000000001n, 1n, -0x10000000000000002n],
  [-0x8000000000000000n, 1n, -0x10000000000000000n],
  [-0x7fffffffffffffffn, 1n, -0xfffffffffffffffen],
  [-0x7ffffffffffffffen, 1n, -0xfffffffffffffffcn],
  [-0x100000001n, 1n, -0x200000002n],
  [-0x100000000n, 1n, -0x200000000n],
  [-0xffffffffn, 1n, -0x1fffffffen],
  [-0xfffffffen, 1n, -0x1fffffffcn],
  [-0x80000001n, 1n, -0x100000002n],
  [-0x80000000n, 1n, -0x100000000n],
  [-0x7fffffffn, 1n, -0xfffffffen],
  [-0x7ffffffen, 1n, -0xfffffffcn],
  [-9n, 1n, -18n],
  [-8n, 1n, -16n],
  [-7n, 1n, -14n],
  [-6n, 1n, -12n],
  [-5n, 1n, -10n],
  [-4n, 1n, -8n],
  [-3n, 1n, -6n],
  [-2n, 1n, -4n],
  [-1n, 1n, -2n],
  [0n, 1n, 0n],
  [1n, 1n, 2n],
  [2n, 1n, 4n],
  [3n, 1n, 6n],
  [4n, 1n, 8n],
  [5n, 1n, 10n],
  [6n, 1n, 12n],
  [7n, 1n, 14n],
  [8n, 1n, 16n],
  [9n, 1n, 18n],
  [0x7ffffffen, 1n, 0xfffffffcn],
  [0x7fffffffn, 1n, 0xfffffffen],
  [0x80000000n, 1n, 0x100000000n],
  [0x80000001n, 1n, 0x100000002n],
  [0xfffffffen, 1n, 0x1fffffffcn],
  [0xffffffffn, 1n, 0x1fffffffen],
  [0x100000000n, 1n, 0x200000000n],
  [0x100000001n, 1n, 0x200000002n],
  [0x7ffffffffffffffen, 1n, 0xfffffffffffffffcn],
  [0x7fffffffffffffffn, 1n, 0xfffffffffffffffen],
  [0x8000000000000000n, 1n, 0x10000000000000000n],
  [0x8000000000000001n, 1n, 0x10000000000000002n],
  [0xfffffffffffffffen, 1n, 0x1fffffffffffffffcn],
  [0xffffffffffffffffn, 1n, 0x1fffffffffffffffen],
  [0x10000000000000000n, 1n, 0x20000000000000000n],
  [0x10000000000000001n, 1n, 0x20000000000000002n],
  [-0x10000000000000001n, 2n, -0x40000000000000004n],
  [-0x10000000000000000n, 2n, -0x40000000000000000n],
  [-0xffffffffffffffffn, 2n, -0x3fffffffffffffffcn],
  [-0xfffffffffffffffen, 2n, -0x3fffffffffffffff8n],
  [-0x8000000000000001n, 2n, -0x20000000000000004n],
  [-0x8000000000000000n, 2n, -0x20000000000000000n],
  [-0x7fffffffffffffffn, 2n, -0x1fffffffffffffffcn],
  [-0x7ffffffffffffffen, 2n, -0x1fffffffffffffff8n],
  [-0x100000001n, 2n, -0x400000004n],
  [-0x100000000n, 2n, -0x400000000n],
  [-0xffffffffn, 2n, -0x3fffffffcn],
  [-0xfffffffen, 2n, -0x3fffffff8n],
  [-0x80000001n, 2n, -0x200000004n],
  [-0x80000000n, 2n, -0x200000000n],
  [-0x7fffffffn, 2n, -0x1fffffffcn],
  [-0x7ffffffen, 2n, -0x1fffffff8n],
  [-9n, 2n, -36n],
  [-8n, 2n, -32n],
  [-7n, 2n, -28n],
  [-6n, 2n, -24n],
  [-5n, 2n, -20n],
  [-4n, 2n, -16n],
  [-3n, 2n, -12n],
  [-2n, 2n, -8n],
  [-1n, 2n, -4n],
  [0n, 2n, 0n],
  [1n, 2n, 4n],
  [2n, 2n, 8n],
  [3n, 2n, 12n],
  [4n, 2n, 16n],
  [5n, 2n, 20n],
  [6n, 2n, 24n],
  [7n, 2n, 28n],
  [8n, 2n, 32n],
  [9n, 2n, 36n],
  [0x7ffffffen, 2n, 0x1fffffff8n],
  [0x7fffffffn, 2n, 0x1fffffffcn],
  [0x80000000n, 2n, 0x200000000n],
  [0x80000001n, 2n, 0x200000004n],
  [0xfffffffen, 2n, 0x3fffffff8n],
  [0xffffffffn, 2n, 0x3fffffffcn],
  [0x100000000n, 2n, 0x400000000n],
  [0x100000001n, 2n, 0x400000004n],
  [0x7ffffffffffffffen, 2n, 0x1fffffffffffffff8n],
  [0x7fffffffffffffffn, 2n, 0x1fffffffffffffffcn],
  [0x8000000000000000n, 2n, 0x20000000000000000n],
  [0x8000000000000001n, 2n, 0x20000000000000004n],
  [0xfffffffffffffffen, 2n, 0x3fffffffffffffff8n],
  [0xffffffffffffffffn, 2n, 0x3fffffffffffffffcn],
  [0x10000000000000000n, 2n, 0x40000000000000000n],
  [0x10000000000000001n, 2n, 0x40000000000000004n],
  [-0x10000000000000001n, 3n, -0x80000000000000008n],
  [-0x10000000000000000n, 3n, -0x80000000000000000n],
  [-0xffffffffffffffffn, 3n, -0x7fffffffffffffff8n],
  [-0xfffffffffffffffen, 3n, -0x7fffffffffffffff0n],
  [-0x8000000000000001n, 3n, -0x40000000000000008n],
  [-0x8000000000000000n, 3n, -0x40000000000000000n],
  [-0x7fffffffffffffffn, 3n, -0x3fffffffffffffff8n],
  [-0x7ffffffffffffffen, 3n, -0x3fffffffffffffff0n],
  [-0x100000001n, 3n, -0x800000008n],
  [-0x100000000n, 3n, -0x800000000n],
  [-0xffffffffn, 3n, -0x7fffffff8n],
  [-0xfffffffen, 3n, -0x7fffffff0n],
  [-0x80000001n, 3n, -0x400000008n],
  [-0x80000000n, 3n, -0x400000000n],
  [-0x7fffffffn, 3n, -0x3fffffff8n],
  [-0x7ffffffen, 3n, -0x3fffffff0n],
  [-9n, 3n, -72n],
  [-8n, 3n, -64n],
  [-7n, 3n, -56n],
  [-6n, 3n, -48n],
  [-5n, 3n, -40n],
  [-4n, 3n, -32n],
  [-3n, 3n, -24n],
  [-2n, 3n, -16n],
  [-1n, 3n, -8n],
  [0n, 3n, 0n],
  [1n, 3n, 8n],
  [2n, 3n, 16n],
  [3n, 3n, 24n],
  [4n, 3n, 32n],
  [5n, 3n, 40n],
  [6n, 3n, 48n],
  [7n, 3n, 56n],
  [8n, 3n, 64n],
  [9n, 3n, 72n],
  [0x7ffffffen, 3n, 0x3fffffff0n],
  [0x7fffffffn, 3n, 0x3fffffff8n],
  [0x80000000n, 3n, 0x400000000n],
  [0x80000001n, 3n, 0x400000008n],
  [0xfffffffen, 3n, 0x7fffffff0n],
  [0xffffffffn, 3n, 0x7fffffff8n],
  [0x100000000n, 3n, 0x800000000n],
  [0x100000001n, 3n, 0x800000008n],
  [0x7ffffffffffffffen, 3n, 0x3fffffffffffffff0n],
  [0x7fffffffffffffffn, 3n, 0x3fffffffffffffff8n],
  [0x8000000000000000n, 3n, 0x40000000000000000n],
  [0x8000000000000001n, 3n, 0x40000000000000008n],
  [0xfffffffffffffffen, 3n, 0x7fffffffffffffff0n],
  [0xffffffffffffffffn, 3n, 0x7fffffffffffffff8n],
  [0x10000000000000000n, 3n, 0x80000000000000000n],
  [0x10000000000000001n, 3n, 0x80000000000000008n],
  [-0x10000000000000001n, 4n, -0x100000000000000010n],
  [-0x10000000000000000n, 4n, -0x100000000000000000n],
  [-0xffffffffffffffffn, 4n, -0xffffffffffffffff0n],
  [-0xfffffffffffffffen, 4n, -0xfffffffffffffffe0n],
  [-0x8000000000000001n, 4n, -0x80000000000000010n],
  [-0x8000000000000000n, 4n, -0x80000000000000000n],
  [-0x7fffffffffffffffn, 4n, -0x7fffffffffffffff0n],
  [-0x7ffffffffffffffen, 4n, -0x7ffffffffffffffe0n],
  [-0x100000001n, 4n, -0x1000000010n],
  [-0x100000000n, 4n, -0x1000000000n],
  [-0xffffffffn, 4n, -0xffffffff0n],
  [-0xfffffffen, 4n, -0xfffffffe0n],
  [-0x80000001n, 4n, -0x800000010n],
  [-0x80000000n, 4n, -0x800000000n],
  [-0x7fffffffn, 4n, -0x7fffffff0n],
  [-0x7ffffffen, 4n, -0x7ffffffe0n],
  [-9n, 4n, -144n],
  [-8n, 4n, -128n],
  [-7n, 4n, -112n],
  [-6n, 4n, -96n],
  [-5n, 4n, -80n],
  [-4n, 4n, -64n],
  [-3n, 4n, -48n],
  [-2n, 4n, -32n],
  [-1n, 4n, -16n],
  [0n, 4n, 0n],
  [1n, 4n, 16n],
  [2n, 4n, 32n],
  [3n, 4n, 48n],
  [4n, 4n, 64n],
  [5n, 4n, 80n],
  [6n, 4n, 96n],
  [7n, 4n, 112n],
  [8n, 4n, 128n],
  [9n, 4n, 144n],
  [0x7ffffffen, 4n, 0x7ffffffe0n],
  [0x7fffffffn, 4n, 0x7fffffff0n],
  [0x80000000n, 4n, 0x800000000n],
  [0x80000001n, 4n, 0x800000010n],
  [0xfffffffen, 4n, 0xfffffffe0n],
  [0xffffffffn, 4n, 0xffffffff0n],
  [0x100000000n, 4n, 0x1000000000n],
  [0x100000001n, 4n, 0x1000000010n],
  [0x7ffffffffffffffen, 4n, 0x7ffffffffffffffe0n],
  [0x7fffffffffffffffn, 4n, 0x7fffffffffffffff0n],
  [0x8000000000000000n, 4n, 0x80000000000000000n],
  [0x8000000000000001n, 4n, 0x80000000000000010n],
  [0xfffffffffffffffen, 4n, 0xfffffffffffffffe0n],
  [0xffffffffffffffffn, 4n, 0xffffffffffffffff0n],
  [0x10000000000000000n, 4n, 0x100000000000000000n],
  [0x10000000000000001n, 4n, 0x100000000000000010n],
  [-0x10000000000000001n, 31n, -0x800000000000000080000000n],
  [-0x10000000000000000n, 31n, -0x800000000000000000000000n],
  [-0xffffffffffffffffn, 31n, -0x7fffffffffffffff80000000n],
  [-0xfffffffffffffffen, 31n, -0x7fffffffffffffff00000000n],
  [-0x8000000000000001n, 31n, -0x400000000000000080000000n],
  [-0x8000000000000000n, 31n, -0x400000000000000000000000n],
  [-0x7fffffffffffffffn, 31n, -0x3fffffffffffffff80000000n],
  [-0x7ffffffffffffffen, 31n, -0x3fffffffffffffff00000000n],
  [-0x100000001n, 31n, -0x8000000080000000n],
  [-0x100000000n, 31n, -0x8000000000000000n],
  [-0xffffffffn, 31n, -0x7fffffff80000000n],
  [-0xfffffffen, 31n, -0x7fffffff00000000n],
  [-0x80000001n, 31n, -0x4000000080000000n],
  [-0x80000000n, 31n, -0x4000000000000000n],
  [-0x7fffffffn, 31n, -0x3fffffff80000000n],
  [-0x7ffffffen, 31n, -0x3fffffff00000000n],
  [-9n, 31n, -0x480000000n],
  [-8n, 31n, -0x400000000n],
  [-7n, 31n, -0x380000000n],
  [-6n, 31n, -0x300000000n],
  [-5n, 31n, -0x280000000n],
  [-4n, 31n, -0x200000000n],
  [-3n, 31n, -0x180000000n],
  [-2n, 31n, -0x100000000n],
  [-1n, 31n, -0x80000000n],
  [0n, 31n, 0n],
  [1n, 31n, 0x80000000n],
  [2n, 31n, 0x100000000n],
  [3n, 31n, 0x180000000n],
  [4n, 31n, 0x200000000n],
  [5n, 31n, 0x280000000n],
  [6n, 31n, 0x300000000n],
  [7n, 31n, 0x380000000n],
  [8n, 31n, 0x400000000n],
  [9n, 31n, 0x480000000n],
  [0x7ffffffen, 31n, 0x3fffffff00000000n],
  [0x7fffffffn, 31n, 0x3fffffff80000000n],
  [0x80000000n, 31n, 0x4000000000000000n],
  [0x80000001n, 31n, 0x4000000080000000n],
  [0xfffffffen, 31n, 0x7fffffff00000000n],
  [0xffffffffn, 31n, 0x7fffffff80000000n],
  [0x100000000n, 31n, 0x8000000000000000n],
  [0x100000001n, 31n, 0x8000000080000000n],
  [0x7ffffffffffffffen, 31n, 0x3fffffffffffffff00000000n],
  [0x7fffffffffffffffn, 31n, 0x3fffffffffffffff80000000n],
  [0x8000000000000000n, 31n, 0x400000000000000000000000n],
  [0x8000000000000001n, 31n, 0x400000000000000080000000n],
  [0xfffffffffffffffen, 31n, 0x7fffffffffffffff00000000n],
  [0xffffffffffffffffn, 31n, 0x7fffffffffffffff80000000n],
  [0x10000000000000000n, 31n, 0x800000000000000000000000n],
  [0x10000000000000001n, 31n, 0x800000000000000080000000n],
  [-0x10000000000000001n, 32n, -0x1000000000000000100000000n],
  [-0x10000000000000000n, 32n, -0x1000000000000000000000000n],
  [-0xffffffffffffffffn, 32n, -0xffffffffffffffff00000000n],
  [-0xfffffffffffffffen, 32n, -0xfffffffffffffffe00000000n],
  [-0x8000000000000001n, 32n, -0x800000000000000100000000n],
  [-0x8000000000000000n, 32n, -0x800000000000000000000000n],
  [-0x7fffffffffffffffn, 32n, -0x7fffffffffffffff00000000n],
  [-0x7ffffffffffffffen, 32n, -0x7ffffffffffffffe00000000n],
  [-0x100000001n, 32n, -0x10000000100000000n],
  [-0x100000000n, 32n, -0x10000000000000000n],
  [-0xffffffffn, 32n, -0xffffffff00000000n],
  [-0xfffffffen, 32n, -0xfffffffe00000000n],
  [-0x80000001n, 32n, -0x8000000100000000n],
  [-0x80000000n, 32n, -0x8000000000000000n],
  [-0x7fffffffn, 32n, -0x7fffffff00000000n],
  [-0x7ffffffen, 32n, -0x7ffffffe00000000n],
  [-9n, 32n, -0x900000000n],
  [-8n, 32n, -0x800000000n],
  [-7n, 32n, -0x700000000n],
  [-6n, 32n, -0x600000000n],
  [-5n, 32n, -0x500000000n],
  [-4n, 32n, -0x400000000n],
  [-3n, 32n, -0x300000000n],
  [-2n, 32n, -0x200000000n],
  [-1n, 32n, -0x100000000n],
  [0n, 32n, 0n],
  [1n, 32n, 0x100000000n],
  [2n, 32n, 0x200000000n],
  [3n, 32n, 0x300000000n],
  [4n, 32n, 0x400000000n],
  [5n, 32n, 0x500000000n],
  [6n, 32n, 0x600000000n],
  [7n, 32n, 0x700000000n],
  [8n, 32n, 0x800000000n],
  [9n, 32n, 0x900000000n],
  [0x7ffffffen, 32n, 0x7ffffffe00000000n],
  [0x7fffffffn, 32n, 0x7fffffff00000000n],
  [0x80000000n, 32n, 0x8000000000000000n],
  [0x80000001n, 32n, 0x8000000100000000n],
  [0xfffffffen, 32n, 0xfffffffe00000000n],
  [0xffffffffn, 32n, 0xffffffff00000000n],
  [0x100000000n, 32n, 0x10000000000000000n],
  [0x100000001n, 32n, 0x10000000100000000n],
  [0x7ffffffffffffffen, 32n, 0x7ffffffffffffffe00000000n],
  [0x7fffffffffffffffn, 32n, 0x7fffffffffffffff00000000n],
  [0x8000000000000000n, 32n, 0x800000000000000000000000n],
  [0x8000000000000001n, 32n, 0x800000000000000100000000n],
  [0xfffffffffffffffen, 32n, 0xfffffffffffffffe00000000n],
  [0xffffffffffffffffn, 32n, 0xffffffffffffffff00000000n],
  [0x10000000000000000n, 32n, 0x1000000000000000000000000n],
  [0x10000000000000001n, 32n, 0x1000000000000000100000000n],
  [-0x10000000000000001n, 63n, -0x80000000000000008000000000000000n],
  [-0x10000000000000000n, 63n, -0x80000000000000000000000000000000n],
  [-0xffffffffffffffffn, 63n, -0x7fffffffffffffff8000000000000000n],
  [-0xfffffffffffffffen, 63n, -0x7fffffffffffffff0000000000000000n],
  [-0x8000000000000001n, 63n, -0x40000000000000008000000000000000n],
  [-0x8000000000000000n, 63n, -0x40000000000000000000000000000000n],
  [-0x7fffffffffffffffn, 63n, -0x3fffffffffffffff8000000000000000n],
  [-0x7ffffffffffffffen, 63n, -0x3fffffffffffffff0000000000000000n],
  [-0x100000001n, 63n, -0x800000008000000000000000n],
  [-0x100000000n, 63n, -0x800000000000000000000000n],
  [-0xffffffffn, 63n, -0x7fffffff8000000000000000n],
  [-0xfffffffen, 63n, -0x7fffffff0000000000000000n],
  [-0x80000001n, 63n, -0x400000008000000000000000n],
  [-0x80000000n, 63n, -0x400000000000000000000000n],
  [-0x7fffffffn, 63n, -0x3fffffff8000000000000000n],
  [-0x7ffffffen, 63n, -0x3fffffff0000000000000000n],
  [-9n, 63n, -0x48000000000000000n],
  [-8n, 63n, -0x40000000000000000n],
  [-7n, 63n, -0x38000000000000000n],
  [-6n, 63n, -0x30000000000000000n],
  [-5n, 63n, -0x28000000000000000n],
  [-4n, 63n, -0x20000000000000000n],
  [-3n, 63n, -0x18000000000000000n],
  [-2n, 63n, -0x10000000000000000n],
  [-1n, 63n, -0x8000000000000000n],
  [0n, 63n, 0n],
  [1n, 63n, 0x8000000000000000n],
  [2n, 63n, 0x10000000000000000n],
  [3n, 63n, 0x18000000000000000n],
  [4n, 63n, 0x20000000000000000n],
  [5n, 63n, 0x28000000000000000n],
  [6n, 63n, 0x30000000000000000n],
  [7n, 63n, 0x38000000000000000n],
  [8n, 63n, 0x40000000000000000n],
  [9n, 63n, 0x48000000000000000n],
  [0x7ffffffen, 63n, 0x3fffffff0000000000000000n],
  [0x7fffffffn, 63n, 0x3fffffff8000000000000000n],
  [0x80000000n, 63n, 0x400000000000000000000000n],
  [0x80000001n, 63n, 0x400000008000000000000000n],
  [0xfffffffen, 63n, 0x7fffffff0000000000000000n],
  [0xffffffffn, 63n, 0x7fffffff8000000000000000n],
  [0x100000000n, 63n, 0x800000000000000000000000n],
  [0x100000001n, 63n, 0x800000008000000000000000n],
  [0x7ffffffffffffffen, 63n, 0x3fffffffffffffff0000000000000000n],
  [0x7fffffffffffffffn, 63n, 0x3fffffffffffffff8000000000000000n],
  [0x8000000000000000n, 63n, 0x40000000000000000000000000000000n],
  [0x8000000000000001n, 63n, 0x40000000000000008000000000000000n],
  [0xfffffffffffffffen, 63n, 0x7fffffffffffffff0000000000000000n],
  [0xffffffffffffffffn, 63n, 0x7fffffffffffffff8000000000000000n],
  [0x10000000000000000n, 63n, 0x80000000000000000000000000000000n],
  [0x10000000000000001n, 63n, 0x80000000000000008000000000000000n],
  [-0x10000000000000001n, 64n, -0x100000000000000010000000000000000n],
  [-0x10000000000000000n, 64n, -0x100000000000000000000000000000000n],
  [-0xffffffffffffffffn, 64n, -0xffffffffffffffff0000000000000000n],
  [-0xfffffffffffffffen, 64n, -0xfffffffffffffffe0000000000000000n],
  [-0x8000000000000001n, 64n, -0x80000000000000010000000000000000n],
  [-0x8000000000000000n, 64n, -0x80000000000000000000000000000000n],
  [-0x7fffffffffffffffn, 64n, -0x7fffffffffffffff0000000000000000n],
  [-0x7ffffffffffffffen, 64n, -0x7ffffffffffffffe0000000000000000n],
  [-0x100000001n, 64n, -0x1000000010000000000000000n],
  [-0x100000000n, 64n, -0x1000000000000000000000000n],
  [-0xffffffffn, 64n, -0xffffffff0000000000000000n],
  [-0xfffffffen, 64n, -0xfffffffe0000000000000000n],
  [-0x80000001n, 64n, -0x800000010000000000000000n],
  [-0x80000000n, 64n, -0x800000000000000000000000n],
  [-0x7fffffffn, 64n, -0x7fffffff0000000000000000n],
  [-0x7ffffffen, 64n, -0x7ffffffe0000000000000000n],
  [-9n, 64n, -0x90000000000000000n],
  [-8n, 64n, -0x80000000000000000n],
  [-7n, 64n, -0x70000000000000000n],
  [-6n, 64n, -0x60000000000000000n],
  [-5n, 64n, -0x50000000000000000n],
  [-4n, 64n, -0x40000000000000000n],
  [-3n, 64n, -0x30000000000000000n],
  [-2n, 64n, -0x20000000000000000n],
  [-1n, 64n, -0x10000000000000000n],
  [0n, 64n, 0n],
  [1n, 64n, 0x10000000000000000n],
  [2n, 64n, 0x20000000000000000n],
  [3n, 64n, 0x30000000000000000n],
  [4n, 64n, 0x40000000000000000n],
  [5n, 64n, 0x50000000000000000n],
  [6n, 64n, 0x60000000000000000n],
  [7n, 64n, 0x70000000000000000n],
  [8n, 64n, 0x80000000000000000n],
  [9n, 64n, 0x90000000000000000n],
  [0x7ffffffen, 64n, 0x7ffffffe0000000000000000n],
  [0x7fffffffn, 64n, 0x7fffffff0000000000000000n],
  [0x80000000n, 64n, 0x800000000000000000000000n],
  [0x80000001n, 64n, 0x800000010000000000000000n],
  [0xfffffffen, 64n, 0xfffffffe0000000000000000n],
  [0xffffffffn, 64n, 0xffffffff0000000000000000n],
  [0x100000000n, 64n, 0x1000000000000000000000000n],
  [0x100000001n, 64n, 0x1000000010000000000000000n],
  [0x7ffffffffffffffen, 64n, 0x7ffffffffffffffe0000000000000000n],
  [0x7fffffffffffffffn, 64n, 0x7fffffffffffffff0000000000000000n],
  [0x8000000000000000n, 64n, 0x80000000000000000000000000000000n],
  [0x8000000000000001n, 64n, 0x80000000000000010000000000000000n],
  [0xfffffffffffffffen, 64n, 0xfffffffffffffffe0000000000000000n],
  [0xffffffffffffffffn, 64n, 0xffffffffffffffff0000000000000000n],
  [0x10000000000000000n, 64n, 0x100000000000000000000000000000000n],
  [0x10000000000000001n, 64n, 0x100000000000000010000000000000000n],
  [-0x10000000000000001n, -1n, -0x8000000000000001n],
  [-0x10000000000000000n, -1n, -0x8000000000000000n],
  [-0xffffffffffffffffn, -1n, -0x8000000000000000n],
  [-0xfffffffffffffffen, -1n, -0x7fffffffffffffffn],
  [-0x8000000000000001n, -1n, -0x4000000000000001n],
  [-0x8000000000000000n, -1n, -0x4000000000000000n],
  [-0x7fffffffffffffffn, -1n, -0x4000000000000000n],
  [-0x7ffffffffffffffen, -1n, -0x3fffffffffffffffn],
  [-0x100000001n, -1n, -0x80000001n],
  [-0x100000000n, -1n, -0x80000000n],
  [-0xffffffffn, -1n, -0x80000000n],
  [-0xfffffffen, -1n, -0x7fffffffn],
  [-0x80000001n, -1n, -0x40000001n],
  [-0x80000000n, -1n, -0x40000000n],
  [-0x7fffffffn, -1n, -0x40000000n],
  [-0x7ffffffen, -1n, -0x3fffffffn],
  [-9n, -1n, -5n],
  [-8n, -1n, -4n],
  [-7n, -1n, -4n],
  [-6n, -1n, -3n],
  [-5n, -1n, -3n],
  [-4n, -1n, -2n],
  [-3n, -1n, -2n],
  [-2n, -1n, -1n],
  [-1n, -1n, -1n],
  [0n, -1n, 0n],
  [1n, -1n, 0n],
  [2n, -1n, 1n],
  [3n, -1n, 1n],
  [4n, -1n, 2n],
  [5n, -1n, 2n],
  [6n, -1n, 3n],
  [7n, -1n, 3n],
  [8n, -1n, 4n],
  [9n, -1n, 4n],
  [0x7ffffffen, -1n, 0x3fffffffn],
  [0x7fffffffn, -1n, 0x3fffffffn],
  [0x80000000n, -1n, 0x40000000n],
  [0x80000001n, -1n, 0x40000000n],
  [0xfffffffen, -1n, 0x7fffffffn],
  [0xffffffffn, -1n, 0x7fffffffn],
  [0x100000000n, -1n, 0x80000000n],
  [0x100000001n, -1n, 0x80000000n],
  [0x7ffffffffffffffen, -1n, 0x3fffffffffffffffn],
  [0x7fffffffffffffffn, -1n, 0x3fffffffffffffffn],
  [0x8000000000000000n, -1n, 0x4000000000000000n],
  [0x8000000000000001n, -1n, 0x4000000000000000n],
  [0xfffffffffffffffen, -1n, 0x7fffffffffffffffn],
  [0xffffffffffffffffn, -1n, 0x7fffffffffffffffn],
  [0x10000000000000000n, -1n, 0x8000000000000000n],
  [0x10000000000000001n, -1n, 0x8000000000000000n],
  [-0x10000000000000001n, -2n, -0x4000000000000001n],
  [-0x10000000000000000n, -2n, -0x4000000000000000n],
  [-0xffffffffffffffffn, -2n, -0x4000000000000000n],
  [-0xfffffffffffffffen, -2n, -0x4000000000000000n],
  [-0x8000000000000001n, -2n, -0x2000000000000001n],
  [-0x8000000000000000n, -2n, -0x2000000000000000n],
  [-0x7fffffffffffffffn, -2n, -0x2000000000000000n],
  [-0x7ffffffffffffffen, -2n, -0x2000000000000000n],
  [-0x100000001n, -2n, -0x40000001n],
  [-0x100000000n, -2n, -0x40000000n],
  [-0xffffffffn, -2n, -0x40000000n],
  [-0xfffffffen, -2n, -0x40000000n],
  [-0x80000001n, -2n, -0x20000001n],
  [-0x80000000n, -2n, -0x20000000n],
  [-0x7fffffffn, -2n, -0x20000000n],
  [-0x7ffffffen, -2n, -0x20000000n],
  [-9n, -2n, -3n],
  [-8n, -2n, -2n],
  [-7n, -2n, -2n],
  [-6n, -2n, -2n],
  [-5n, -2n, -2n],
  [-4n, -2n, -1n],
  [-3n, -2n, -1n],
  [-2n, -2n, -1n],
  [-1n, -2n, -1n],
  [0n, -2n, 0n],
  [1n, -2n, 0n],
  [2n, -2n, 0n],
  [3n, -2n, 0n],
  [4n, -2n, 1n],
  [5n, -2n, 1n],
  [6n, -2n, 1n],
  [7n, -2n, 1n],
  [8n, -2n, 2n],
  [9n, -2n, 2n],
  [0x7ffffffen, -2n, 0x1fffffffn],
  [0x7fffffffn, -2n, 0x1fffffffn],
  [0x80000000n, -2n, 0x20000000n],
  [0x80000001n, -2n, 0x20000000n],
  [0xfffffffen, -2n, 0x3fffffffn],
  [0xffffffffn, -2n, 0x3fffffffn],
  [0x100000000n, -2n, 0x40000000n],
  [0x100000001n, -2n, 0x40000000n],
  [0x7ffffffffffffffen, -2n, 0x1fffffffffffffffn],
  [0x7fffffffffffffffn, -2n, 0x1fffffffffffffffn],
  [0x8000000000000000n, -2n, 0x2000000000000000n],
  [0x8000000000000001n, -2n, 0x2000000000000000n],
  [0xfffffffffffffffen, -2n, 0x3fffffffffffffffn],
  [0xffffffffffffffffn, -2n, 0x3fffffffffffffffn],
  [0x10000000000000000n, -2n, 0x4000000000000000n],
  [0x10000000000000001n, -2n, 0x4000000000000000n],
  [-0x10000000000000001n, -3n, -0x2000000000000001n],
  [-0x10000000000000000n, -3n, -0x2000000000000000n],
  [-0xffffffffffffffffn, -3n, -0x2000000000000000n],
  [-0xfffffffffffffffen, -3n, -0x2000000000000000n],
  [-0x8000000000000001n, -3n, -0x1000000000000001n],
  [-0x8000000000000000n, -3n, -0x1000000000000000n],
  [-0x7fffffffffffffffn, -3n, -0x1000000000000000n],
  [-0x7ffffffffffffffen, -3n, -0x1000000000000000n],
  [-0x100000001n, -3n, -0x20000001n],
  [-0x100000000n, -3n, -0x20000000n],
  [-0xffffffffn, -3n, -0x20000000n],
  [-0xfffffffen, -3n, -0x20000000n],
  [-0x80000001n, -3n, -0x10000001n],
  [-0x80000000n, -3n, -0x10000000n],
  [-0x7fffffffn, -3n, -0x10000000n],
  [-0x7ffffffen, -3n, -0x10000000n],
  [-9n, -3n, -2n],
  [-8n, -3n, -1n],
  [-7n, -3n, -1n],
  [-6n, -3n, -1n],
  [-5n, -3n, -1n],
  [-4n, -3n, -1n],
  [-3n, -3n, -1n],
  [-2n, -3n, -1n],
  [-1n, -3n, -1n],
  [0n, -3n, 0n],
  [1n, -3n, 0n],
  [2n, -3n, 0n],
  [3n, -3n, 0n],
  [4n, -3n, 0n],
  [5n, -3n, 0n],
  [6n, -3n, 0n],
  [7n, -3n, 0n],
  [8n, -3n, 1n],
  [9n, -3n, 1n],
  [0x7ffffffen, -3n, 0xfffffffn],
  [0x7fffffffn, -3n, 0xfffffffn],
  [0x80000000n, -3n, 0x10000000n],
  [0x80000001n, -3n, 0x10000000n],
  [0xfffffffen, -3n, 0x1fffffffn],
  [0xffffffffn, -3n, 0x1fffffffn],
  [0x100000000n, -3n, 0x20000000n],
  [0x100000001n, -3n, 0x20000000n],
  [0x7ffffffffffffffen, -3n, 0xfffffffffffffffn],
  [0x7fffffffffffffffn, -3n, 0xfffffffffffffffn],
  [0x8000000000000000n, -3n, 0x1000000000000000n],
  [0x8000000000000001n, -3n, 0x1000000000000000n],
  [0xfffffffffffffffen, -3n, 0x1fffffffffffffffn],
  [0xffffffffffffffffn, -3n, 0x1fffffffffffffffn],
  [0x10000000000000000n, -3n, 0x2000000000000000n],
  [0x10000000000000001n, -3n, 0x2000000000000000n],
  [-0x10000000000000001n, -4n, -0x1000000000000001n],
  [-0x10000000000000000n, -4n, -0x1000000000000000n],
  [-0xffffffffffffffffn, -4n, -0x1000000000000000n],
  [-0xfffffffffffffffen, -4n, -0x1000000000000000n],
  [-0x8000000000000001n, -4n, -0x800000000000001n],
  [-0x8000000000000000n, -4n, -0x800000000000000n],
  [-0x7fffffffffffffffn, -4n, -0x800000000000000n],
  [-0x7ffffffffffffffen, -4n, -0x800000000000000n],
  [-0x100000001n, -4n, -0x10000001n],
  [-0x100000000n, -4n, -0x10000000n],
  [-0xffffffffn, -4n, -0x10000000n],
  [-0xfffffffen, -4n, -0x10000000n],
  [-0x80000001n, -4n, -0x8000001n],
  [-0x80000000n, -4n, -0x8000000n],
  [-0x7fffffffn, -4n, -0x8000000n],
  [-0x7ffffffen, -4n, -0x8000000n],
  [-9n, -4n, -1n],
  [-8n, -4n, -1n],
  [-7n, -4n, -1n],
  [-6n, -4n, -1n],
  [-5n, -4n, -1n],
  [-4n, -4n, -1n],
  [-3n, -4n, -1n],
  [-2n, -4n, -1n],
  [-1n, -4n, -1n],
  [0n, -4n, 0n],
  [1n, -4n, 0n],
  [2n, -4n, 0n],
  [3n, -4n, 0n],
  [4n, -4n, 0n],
  [5n, -4n, 0n],
  [6n, -4n, 0n],
  [7n, -4n, 0n],
  [8n, -4n, 0n],
  [9n, -4n, 0n],
  [0x7ffffffen, -4n, 0x7ffffffn],
  [0x7fffffffn, -4n, 0x7ffffffn],
  [0x80000000n, -4n, 0x8000000n],
  [0x80000001n, -4n, 0x8000000n],
  [0xfffffffen, -4n, 0xfffffffn],
  [0xffffffffn, -4n, 0xfffffffn],
  [0x100000000n, -4n, 0x10000000n],
  [0x100000001n, -4n, 0x10000000n],
  [0x7ffffffffffffffen, -4n, 0x7ffffffffffffffn],
  [0x7fffffffffffffffn, -4n, 0x7ffffffffffffffn],
  [0x8000000000000000n, -4n, 0x800000000000000n],
  [0x8000000000000001n, -4n, 0x800000000000000n],
  [0xfffffffffffffffen, -4n, 0xfffffffffffffffn],
  [0xffffffffffffffffn, -4n, 0xfffffffffffffffn],
  [0x10000000000000000n, -4n, 0x1000000000000000n],
  [0x10000000000000001n, -4n, 0x1000000000000000n],
  [-0x10000000000000001n, -31n, -0x200000001n],
  [-0x10000000000000000n, -31n, -0x200000000n],
  [-0xffffffffffffffffn, -31n, -0x200000000n],
  [-0xfffffffffffffffen, -31n, -0x200000000n],
  [-0x8000000000000001n, -31n, -0x100000001n],
  [-0x8000000000000000n, -31n, -0x100000000n],
  [-0x7fffffffffffffffn, -31n, -0x100000000n],
  [-0x7ffffffffffffffen, -31n, -0x100000000n],
  [-0x100000001n, -31n, -3n],
  [-0x100000000n, -31n, -2n],
  [-0xffffffffn, -31n, -2n],
  [-0xfffffffen, -31n, -2n],
  [-0x80000001n, -31n, -2n],
  [-0x80000000n, -31n, -1n],
  [-0x7fffffffn, -31n, -1n],
  [-0x7ffffffen, -31n, -1n],
  [-9n, -31n, -1n],
  [-8n, -31n, -1n],
  [-7n, -31n, -1n],
  [-6n, -31n, -1n],
  [-5n, -31n, -1n],
  [-4n, -31n, -1n],
  [-3n, -31n, -1n],
  [-2n, -31n, -1n],
  [-1n, -31n, -1n],
  [0n, -31n, 0n],
  [1n, -31n, 0n],
  [2n, -31n, 0n],
  [3n, -31n, 0n],
  [4n, -31n, 0n],
  [5n, -31n, 0n],
  [6n, -31n, 0n],
  [7n, -31n, 0n],
  [8n, -31n, 0n],
  [9n, -31n, 0n],
  [0x7ffffffen, -31n, 0n],
  [0x7fffffffn, -31n, 0n],
  [0x80000000n, -31n, 1n],
  [0x80000001n, -31n, 1n],
  [0xfffffffen, -31n, 1n],
  [0xffffffffn, -31n, 1n],
  [0x100000000n, -31n, 2n],
  [0x100000001n, -31n, 2n],
  [0x7ffffffffffffffen, -31n, 0xffffffffn],
  [0x7fffffffffffffffn, -31n, 0xffffffffn],
  [0x8000000000000000n, -31n, 0x100000000n],
  [0x8000000000000001n, -31n, 0x100000000n],
  [0xfffffffffffffffen, -31n, 0x1ffffffffn],
  [0xffffffffffffffffn, -31n, 0x1ffffffffn],
  [0x10000000000000000n, -31n, 0x200000000n],
  [0x10000000000000001n, -31n, 0x200000000n],
  [-0x10000000000000001n, -32n, -0x100000001n],
  [-0x10000000000000000n, -32n, -0x100000000n],
  [-0xffffffffffffffffn, -32n, -0x100000000n],
  [-0xfffffffffffffffen, -32n, -0x100000000n],
  [-0x8000000000000001n, -32n, -0x80000001n],
  [-0x8000000000000000n, -32n, -0x80000000n],
  [-0x7fffffffffffffffn, -32n, -0x80000000n],
  [-0x7ffffffffffffffen, -32n, -0x80000000n],
  [-0x100000001n, -32n, -2n],
  [-0x100000000n, -32n, -1n],
  [-0xffffffffn, -32n, -1n],
  [-0xfffffffen, -32n, -1n],
  [-0x80000001n, -32n, -1n],
  [-0x80000000n, -32n, -1n],
  [-0x7fffffffn, -32n, -1n],
  [-0x7ffffffen, -32n, -1n],
  [-9n, -32n, -1n],
  [-8n, -32n, -1n],
  [-7n, -32n, -1n],
  [-6n, -32n, -1n],
  [-5n, -32n, -1n],
  [-4n, -32n, -1n],
  [-3n, -32n, -1n],
  [-2n, -32n, -1n],
  [-1n, -32n, -1n],
  [0n, -32n, 0n],
  [1n, -32n, 0n],
  [2n, -32n, 0n],
  [3n, -32n, 0n],
  [4n, -32n, 0n],
  [5n, -32n, 0n],
  [6n, -32n, 0n],
  [7n, -32n, 0n],
  [8n, -32n, 0n],
  [9n, -32n, 0n],
  [0x7ffffffen, -32n, 0n],
  [0x7fffffffn, -32n, 0n],
  [0x80000000n, -32n, 0n],
  [0x80000001n, -32n, 0n],
  [0xfffffffen, -32n, 0n],
  [0xffffffffn, -32n, 0n],
  [0x100000000n, -32n, 1n],
  [0x100000001n, -32n, 1n],
  [0x7ffffffffffffffen, -32n, 0x7fffffffn],
  [0x7fffffffffffffffn, -32n, 0x7fffffffn],
  [0x8000000000000000n, -32n, 0x80000000n],
  [0x8000000000000001n, -32n, 0x80000000n],
  [0xfffffffffffffffen, -32n, 0xffffffffn],
  [0xffffffffffffffffn, -32n, 0xffffffffn],
  [0x10000000000000000n, -32n, 0x100000000n],
  [0x10000000000000001n, -32n, 0x100000000n],
  [-0x10000000000000001n, -63n, -3n],
  [-0x10000000000000000n, -63n, -2n],
  [-0xffffffffffffffffn, -63n, -2n],
  [-0xfffffffffffffffen, -63n, -2n],
  [-0x8000000000000001n, -63n, -2n],
  [-0x8000000000000000n, -63n, -1n],
  [-0x7fffffffffffffffn, -63n, -1n],
  [-0x7ffffffffffffffen, -63n, -1n],
  [-0x100000001n, -63n, -1n],
  [-0x100000000n, -63n, -1n],
  [-0xffffffffn, -63n, -1n],
  [-0xfffffffen, -63n, -1n],
  [-0x80000001n, -63n, -1n],
  [-0x80000000n, -63n, -1n],
  [-0x7fffffffn, -63n, -1n],
  [-0x7ffffffen, -63n, -1n],
  [-9n, -63n, -1n],
  [-8n, -63n, -1n],
  [-7n, -63n, -1n],
  [-6n, -63n, -1n],
  [-5n, -63n, -1n],
  [-4n, -63n, -1n],
  [-3n, -63n, -1n],
  [-2n, -63n, -1n],
  [-1n, -63n, -1n],
  [0n, -63n, 0n],
  [1n, -63n, 0n],
  [2n, -63n, 0n],
  [3n, -63n, 0n],
  [4n, -63n, 0n],
  [5n, -63n, 0n],
  [6n, -63n, 0n],
  [7n, -63n, 0n],
  [8n, -63n, 0n],
  [9n, -63n, 0n],
  [0x7ffffffen, -63n, 0n],
  [0x7fffffffn, -63n, 0n],
  [0x80000000n, -63n, 0n],
  [0x80000001n, -63n, 0n],
  [0xfffffffen, -63n, 0n],
  [0xffffffffn, -63n, 0n],
  [0x100000000n, -63n, 0n],
  [0x100000001n, -63n, 0n],
  [0x7ffffffffffffffen, -63n, 0n],
  [0x7fffffffffffffffn, -63n, 0n],
  [0x8000000000000000n, -63n, 1n],
  [0x8000000000000001n, -63n, 1n],
  [0xfffffffffffffffen, -63n, 1n],
  [0xffffffffffffffffn, -63n, 1n],
  [0x10000000000000000n, -63n, 2n],
  [0x10000000000000001n, -63n, 2n],
  [-0x10000000000000001n, -64n, -2n],
  [-0x10000000000000000n, -64n, -1n],
  [-0xffffffffffffffffn, -64n, -1n],
  [-0xfffffffffffffffen, -64n, -1n],
  [-0x8000000000000001n, -64n, -1n],
  [-0x8000000000000000n, -64n, -1n],
  [-0x7fffffffffffffffn, -64n, -1n],
  [-0x7ffffffffffffffen, -64n, -1n],
  [-0x100000001n, -64n, -1n],
  [-0x100000000n, -64n, -1n],
  [-0xffffffffn, -64n, -1n],
  [-0xfffffffen, -64n, -1n],
  [-0x80000001n, -64n, -1n],
  [-0x80000000n, -64n, -1n],
  [-0x7fffffffn, -64n, -1n],
  [-0x7ffffffen, -64n, -1n],
  [-9n, -64n, -1n],
  [-8n, -64n, -1n],
  [-7n, -64n, -1n],
  [-6n, -64n, -1n],
  [-5n, -64n, -1n],
  [-4n, -64n, -1n],
  [-3n, -64n, -1n],
  [-2n, -64n, -1n],
  [-1n, -64n, -1n],
  [0n, -64n, 0n],
  [1n, -64n, 0n],
  [2n, -64n, 0n],
  [3n, -64n, 0n],
  [4n, -64n, 0n],
  [5n, -64n, 0n],
  [6n, -64n, 0n],
  [7n, -64n, 0n],
  [8n, -64n, 0n],
  [9n, -64n, 0n],
  [0x7ffffffen, -64n, 0n],
  [0x7fffffffn, -64n, 0n],
  [0x80000000n, -64n, 0n],
  [0x80000001n, -64n, 0n],
  [0xfffffffen, -64n, 0n],
  [0xffffffffn, -64n, 0n],
  [0x100000000n, -64n, 0n],
  [0x100000001n, -64n, 0n],
  [0x7ffffffffffffffen, -64n, 0n],
  [0x7fffffffffffffffn, -64n, 0n],
  [0x8000000000000000n, -64n, 0n],
  [0x8000000000000001n, -64n, 0n],
  [0xfffffffffffffffen, -64n, 0n],
  [0xffffffffffffffffn, -64n, 0n],
  [0x10000000000000000n, -64n, 1n],
  [0x10000000000000001n, -64n, 1n],
];

// Cases not covered above.
tests.push(
  // Negative shift with sign-bit set when interpreted as pointer-sized value (32-bit).
  [-1n, -0xf000_0000n, -1n],
  [0n, -0xf000_0000n, 0n],
  [1n, -0xf000_0000n, 0n],

  // Negative shift with sign-bit set when interpreted as pointer-sized value (64-bit).
  [-1n, -0xf000_0000_0000_0000n, -1n],
  [0n, -0xf000_0000_0000_0000n, 0n],
  [1n, -0xf000_0000_0000_0000n, 0n],
);

function f(tests) {
  for (let test of tests) {
    let lhs = test[0], rhs = test[1], expected = test[2];

    assertEq(lhs << rhs, expected);
  }
}

for (let i = 0; i < 10; ++i) {
  f(tests);
}
