mod case;
/// Provides conversion to and detection of class case strings.
///
/// This version singularizes strings.
///
/// Example string `ClassCase`
pub mod classcase;

/// Provides conversion to and detection of camel case strings.
///
/// Example string `camelCase`
pub mod camelcase;

/// Provides conversion to and detection of snake case strings.
///
/// Example string `snake_case`
pub mod snakecase;

/// Provides conversion to and detection of screaming snake case strings.
///
/// Example string `SCREAMING_SNAKE_CASE`
pub mod screamingsnakecase;

/// Provides conversion to and detection of kebab case strings.
///
/// Example string `kebab-case`
pub mod kebabcase;

/// Provides conversion to and detection of train case strings.
///
/// Example string `Train-Case`
pub mod traincase;

/// Provides conversion to and detection of sentence case strings.
///
/// Example string `Sentence case`
pub mod sentencecase;

/// Provides conversion to and detection of title case strings.
///
/// Example string `Title Case`
pub mod titlecase;

/// Provides conversion to and detection of table case strings.
///
/// Example string `table_cases`
pub mod tablecase;

/// Provides conversion to pascal case strings.
///
/// Example string `PascalCase`
pub mod pascalcase;
