"""
Core Linear Algebra Tools
=========================

=============== ==========================================================
Linear algebra basics
==========================================================================
norm            Vector or matrix norm
inv             Inverse of a square matrix
solve           Solve a linear system of equations
det             Determinant of a square matrix
slogdet         Logarithm of the determinant of a square matrix
lstsq           Solve linear least-squares problem
pinv            Pseudo-inverse (Moore-Penrose) calculated using a singular
                value decomposition
matrix_power    Integer power of a square matrix
matrix_rank     Calculate matrix rank using an SVD-based method
=============== ==========================================================

=============== ==========================================================
Eigenvalues and decompositions
==========================================================================
eig             Eigenvalues and vectors of a square matrix
eigh            Eigenvalues and eigenvectors of a Hermitian matrix
eigvals         Eigenvalues of a square matrix
eigvalsh        Eigenvalues of a Hermitian matrix
qr              QR decomposition of a matrix
svd             Singular value decomposition of a matrix
cholesky        Cholesky decomposition of a matrix
=============== ==========================================================

=============== ==========================================================
Tensor operations
==========================================================================
tensorsolve     Solve a linear tensor equation
tensorinv       Calculate an inverse of a tensor
=============== ==========================================================

=============== ==========================================================
Exceptions
==========================================================================
LinAlgError     Indicates a failed linear algebra operation
=============== ==========================================================

"""
from __future__ import division, absolute_import, print_function

# To get sub-modules
from .info import __doc__

from .linalg import *

from numpy.testing.nosetester import _numpy_tester
test = _numpy_tester().test
bench = _numpy_tester().bench
