## RabbitMQ 3.6.1

RabbitMQ `3.6.1` is a maintenance release that includes a fix for CVE-2015-8786,
a vulnerability in RabbitMQ management plugin.

### Server

#### Bug Fixes

 * Purging a lazy queue could result in an exception

   GitHub issue: [rabbitmq-server#514](https://github.com/rabbitmq/rabbitmq-server/issues/514)

 * Ensure `epmd` is running before starting RabbitMQ node on Windows

   GitHub issue: [rabbitmq-server#625](https://github.com/rabbitmq/rabbitmq-server/issues/625)

 * Channel error could make broker unreachable

   Those errors were misleadingly logged as `channel_termination_timeout`, which
   the issue really was with unhandled messages from concurrently closed TCP socket process.

   GitHub issue: [rabbitmq-server#530](https://github.com/rabbitmq/rabbitmq-server/issues/530)

 * (Automatic) deletion of an auto-delete queue could lead
   to blocked channels

   GitHub issue: [rabbitmq-server#581](https://github.com/rabbitmq/rabbitmq-server/issues/581)

 * During (from scratch) queue sync, queue leader node didn't respect mirror alarm state.
   With large data sets this could drive mirror node out of memory.

   GitHub issue: [rabbitmq-server#616](https://github.com/rabbitmq/rabbitmq-server/issues/616)

 * Changing password for users with non-standard (think broker configuration) password
   hashing function, for example, those migrated from `3.5.x` releases, didn't update
   effective hashing function.

   GitHub issue: [rabbitmq-server#623](https://github.com/rabbitmq/rabbitmq-server/issues/623)

 * Heavy and/or prolonged `rabbitmqctl` use could exhaust Erlang VM atom table

   GitHub issue: [rabbitmq-server#549](https://github.com/rabbitmq/rabbitmq-server/issues/549)

 * "Min masters" queue leader location strategy could result
   in an error.

   GitHub issue: [rabbitmq-server#521](https://github.com/rabbitmq/rabbitmq-server/issues/521)

 * Fixed a race condition in `pause_minority` handling mode.

   GitHub issue: [rabbitmq-server#307](https://github.com/rabbitmq/rabbitmq-server/issues/307)

 * Significantly reduce possibility of a race condition when
   an exchange is deleted and immediately re-declared, e.g. by a federation
   link.

   This could result in a link operation being blocked, preventing
   nodes from stopping.

   GitHub issue: [rabbitmq-federation#7](https://github.com/rabbitmq/rabbitmq-federation/issues/7)

 * `amq.rabbitmq.log` messages now have information about originating
   node in message headers

   GitHub issue: [rabbitmq-server#595](https://github.com/rabbitmq/rabbitmq-server/issues/595)

 * `scripts/rabbitmq-env` now works with GNU sed 4.2.2

   GitHub issue: [rabbitmq-server#592](https://github.com/rabbitmq/rabbitmq-server/issues/592)

 * Exceptions in VM memory use calculator no longer affect broker startup

   GitHub issue: [rabbitmq-server#328](https://github.com/rabbitmq/rabbitmq-server/issues/328)

 * [Direct Reply-to](https://www.rabbitmq.com/direct-reply-to.html) capability is now advertised to clients

   GitHub issue: [rabbitmq-server#520](https://github.com/rabbitmq/rabbitmq-server/issues/520)

#### Enhancements

 * Paths with non-ASCII characters on Windows are now handled

   RabbitMQ now can be installed into a location with non-ASCII characters,
   e.g. when username contains them.

   GitHub issues: [rabbitmq-server#493](https://github.com/rabbitmq/rabbitmq-server/issues/493)

 * Configurable number of TCP connection acceptors

   Plus a x10 increase of the default. This helps with workloads where connection
   churn is very high (e.g. all clients are PHP Web apps that cannot maintain
   long-lived connections).

   GitHub issues: [rabbitmq-server#528](https://github.com/rabbitmq/rabbitmq-server/issues/528)

 * `rabbitmqctl cluster_status` now includes cluster-wide resource alarm status

   GitHub issue: [rabbitmq-server#392](https://github.com/rabbitmq/rabbitmq-server/issues/392)

 * Windows installer no longer jumps over installation log

   GitHub issue: [rabbitmq-server#634](https://github.com/rabbitmq/rabbitmq-server/issues/634)

 * Improved `rabbitmqctl reset` error messages

   GitHub issue: [rabbitmq-server#167](https://github.com/rabbitmq/rabbitmq-server/issues/167)

 * More unsigned field data types are supported.

   GitHub issue: [rabbitmq-server#20](https://github.com/rabbitmq/rabbitmq-server/issues/20)



### Java client

#### Enhancements

 * Endpoints (hostnames) are now also accepted as a `java.util.List`

   GitHub issue: [rabbitmq-java-client#125](https://github.com/rabbitmq/rabbitmq-java-client/issues/125)

 * Autorecovering connections now shuffle hosts in a more
   reliable way

   GitHub issue: [rabbitmq-java-client#124](https://github.com/rabbitmq/rabbitmq-java-client/issues/124)

#### Bug Fixes

 * Binding recovery could fail

   GitHub issue: [rabbitmq-java-client#129](https://github.com/rabbitmq/rabbitmq-java-client/issues/129)

 * `Channel.queueDelete` could throw a `NullPointerException`

   GitHub issue: [rabbitmq-java-client#120](https://github.com/rabbitmq/rabbitmq-java-client/issues/120)



### .NET client

#### Bug Fixes

 * Autorecovering connections now use full list of provided hostnames
   during recovery

   GitHub issues: [rabbitmq-dotnet-client#153](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/153)



### Federation Plugin

#### Bug Fixes

 * Significantly reduce possibility of a race condition when
   an exchange is deleted and immediately re-declared, e.g. by a federation
   link

   This rendered federation links dysfunctional.

   GitHub issue: [rabbitmq-federation#7](https://github.com/rabbitmq/rabbitmq-federation/issues/7)



### Management plugin

#### Vulnerability Fixes

 * CVE-2015-8786: user-provided query parameters `lengths_age` and `lengths_incr` had no validation
   and could be used to exhaust server resources.

   The attacker needs to have access to HTTP API (authenticate successfully and have sufficient
   tags to pass authorisation) in order to carry out the attack.

   There is no workaround for earlier releases.

   Kudos to Vladimir Ivanov (Positive Technologies) for the responsible disclosure.

   GitHub issue: [rabbitmq-management#97](https://github.com/rabbitmq/rabbitmq-management/issues/97)


#### Enhancements

 * Password hashing function is now included in exported definitions

   Those upgrading from versions earlier than `3.6.0` via definitions export
   won't have to temporarily set hashing function to MD5 to ensure export succeeds.

   GitHub issue: [rabbitmq-management#117](https://github.com/rabbitmq/rabbitmq-management/issues/117)

#### Bug Fixes

 * Internet Explorer (9+) compatibility restored

   GitHub issue: [rabbitmq-management#98](https://github.com/rabbitmq/rabbitmq-management/issues/98)

 * Internet Explorer 11 compatibility fixes

   GitHub issues: [rabbitmq-management#112](https://github.com/rabbitmq/rabbitmq-management/issues/112),
                  [rabbitmq-management#114](https://github.com/rabbitmq/rabbitmq-management/issues/114)

 * When policy fails to be created with invalid paramaters a sensible
   error message will be displayed.

   GitHub issue: [rabbitmq-management#110](https://github.com/rabbitmq/rabbitmq-management/issues/110)


### Federation Management plugin

#### Enhancements

 * Federation link form now includes more settings (that are exchange- and queue-federation specific)

   GitHub issue: [rabbitmq-federation-management#5](https://github.com/rabbitmq/rabbitmq-federation-management/issues/5)


### Erlang client

#### Bug Fixes

 * `password` and `depth` query parameters are now propagated to TLS options

   GitHub issue: [rabbitmq-erlang-client#36](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/36)


### STOMP plugin

#### Bug Fixes

 * `durable` and `persistent` headers weren't always used interchangeably,
   leading to non-durable subscriptions

   GitHub issue: [rabbitmq-stomp#58](https://github.com/rabbitmq/rabbitmq-stomp/issues/58)

 * Client heartbeat timeouts resulted in confusing error messages
   in broker log.

   GitHub issues: [rabbitmq-stomp#63](https://github.com/rabbitmq/rabbitmq-stomp/issues/63)


### Web STOMP plugin

#### Bug Fixes

 * Cowboy options are now supported for TLS listeners.

   GitHub issue: [rabbitmq-web-stomp#36](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/36)


### Web STOMP Examples plugin

#### Bug Fixes

 * Multi-byte UTF-8 characters are now handled
   by the bundled version of stomp.js.

   GitHub issue: [rabbitmq-web-stomp-examples#2](https://github.com/rabbitmq/rabbitmq-web-stomp-examples/issues/2)


### Event Exchange plugin

#### Bug Fixes

 * Event timestamps are now in seconds, not milliseconds

   Per AMQP 0-9-1 spec. This is not a particularly great choice for events,
   so we will add an optional header with millisecond precision in a future release.

   GitHub issue: [rabbitmq-event-exchange#8](https://github.com/rabbitmq/rabbitmq-event-exchange/issues/8)


### JSON RPC plugin

Note: this plugin is deprecated and its use is highly discouraged.

#### Enhancements

 * RabbitmQ `3.6.x` support.

   GitHub issue: [rabbitmq-jsonrpc#3](https://github.com/rabbitmq/rabbitmq-jsonrpc/issues/3)
