#!/usr/bin/env python
import polib
import sys
import optparse

parser = optparse.OptionParser(usage="usage: %prog path_to_eng_file")

(options, args) = parser.parse_args()

if args == None or len(args) != 1:
	print("ERROR: not enough arguments");
	sys.exit(1)

path = args[0]

po = polib.POFile()
po.metadata = {
    'Project-Id-Version': 'PACKAGE VERSION',
    'Report-Msgid-Bugs-To': 'you@example.com',

    'POT-Creation-Date': '2007-10-18 14:00+0100',

    'PO-Revision-Date': 'YEAR-MO-DA HO:MI+ZONE',
    'Last-Translator': 'FULL NAME <EMAIL@ADDRESS>',
    'Language-Team': 'LANGUAGE <LL@li.org>',
    'Language': '',
    'MIME-Version': '1.0',
    'Content-Type': 'text/plain; charset=utf-8',
    'Content-Transfer-Encoding': '8bit',
}

lines = open(path, 'r').readlines()

for i in range(len(lines)):
    line = lines[i]
    msg = line[line.find('=') + 1:].strip()
    entry = polib.POEntry(msgid=msg,
                          msgstr=u'',
                          occurrences=[('unity_webapps.properties', str(i))]
        )
    po.append(entry)

po.save('unity_firefox_extension.pot')
