#!/usr/bin/python3
# -*- Mode: Python; indent-tabs-mode: nil; tab-width: 4; coding: utf-8 -*-

import os
import subprocess
import unittest

# pep8 is overdoing it a bit IMO
IGNORE_PEP8 = "E265, W503"
IGNORE_FILES = (
)


class TestPep8Clean(unittest.TestCase):
    """ ensure that the tree is pep8 clean """

    def test_pep8_clean(self):
        CURDIR = os.path.dirname(os.path.abspath(__file__))
        for dirpath, dirs, files in os.walk(os.path.join(CURDIR, "..")):
            for f in files:
                if os.path.splitext(f)[1] != ".py":
                    continue
                if f in IGNORE_FILES:
                    continue
                py_file = os.path.join(dirpath, f)
                if f == 'test_motd.py':
                    ret_code = subprocess.call(
                        ["pep8", "--ignore={0}".format(IGNORE_PEP8 + ", E501"),
                         py_file])
                else:
                    ret_code = subprocess.call(
                        ["pep8", "--ignore={0}".format(IGNORE_PEP8), py_file])
                self.assertEqual(0, ret_code)


if __name__ == "__main__":
    import logging
    logging.basicConfig(level=logging.DEBUG)
    unittest.main()
