// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_1_0_autogen.cpp:
//   Defines the GLES 1.0 entry points.

#include "libGLESv2/entry_points_gles_1_0_autogen.h"

#include "common/entry_points_enum_autogen.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture_gles_1_0_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationES1.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY AlphaFunc(GLenum func, GLfloat ref)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::AlphaFunc, "glAlphaFunc", "context = %d, func = %s, ref = %f",
          CID(context), GLenumToString(GLenumGroup::AlphaFunction, func), ref);

    if (context)
    {
        AlphaTestFunc funcPacked                              = FromGL<AlphaTestFunc>(func);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateAlphaFunc(context, funcPacked, ref));
        if (isCallValid)
        {
            context->alphaFunc(funcPacked, ref);
        }
        ANGLE_CAPTURE(AlphaFunc, isCallValid, context, funcPacked, ref);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY AlphaFuncx(GLenum func, GLfixed ref)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::AlphaFuncx, "glAlphaFuncx",
          "context = %d, func = %s, ref = 0x%X", CID(context),
          GLenumToString(GLenumGroup::AlphaFunction, func), ref);

    if (context)
    {
        AlphaTestFunc funcPacked                              = FromGL<AlphaTestFunc>(func);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateAlphaFuncx(context, funcPacked, ref));
        if (isCallValid)
        {
            context->alphaFuncx(funcPacked, ref);
        }
        ANGLE_CAPTURE(AlphaFuncx, isCallValid, context, funcPacked, ref);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ClearColorx(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ClearColorx, "glClearColorx",
          "context = %d, red = 0x%X, green = 0x%X, blue = 0x%X, alpha = 0x%X", CID(context), red,
          green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClearColorx(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->clearColorx(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(ClearColorx, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ClearDepthx(GLfixed depth)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ClearDepthx, "glClearDepthx", "context = %d, depth = 0x%X",
          CID(context), depth);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClearDepthx(context, depth));
        if (isCallValid)
        {
            context->clearDepthx(depth);
        }
        ANGLE_CAPTURE(ClearDepthx, isCallValid, context, depth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ClientActiveTexture(GLenum texture)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ClientActiveTexture, "glClientActiveTexture",
          "context = %d, texture = %s", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClientActiveTexture(context, texture));
        if (isCallValid)
        {
            context->clientActiveTexture(texture);
        }
        ANGLE_CAPTURE(ClientActiveTexture, isCallValid, context, texture);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ClipPlanef(GLenum p, const GLfloat *eqn)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ClipPlanef, "glClipPlanef",
          "context = %d, p = %s, eqn = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ClipPlaneName, p), (uintptr_t)eqn);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClipPlanef(context, p, eqn));
        if (isCallValid)
        {
            context->clipPlanef(p, eqn);
        }
        ANGLE_CAPTURE(ClipPlanef, isCallValid, context, p, eqn);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ClipPlanex(GLenum plane, const GLfixed *equation)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ClipPlanex, "glClipPlanex",
          "context = %d, plane = %s, equation = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateClipPlanex(context, plane, equation));
        if (isCallValid)
        {
            context->clipPlanex(plane, equation);
        }
        ANGLE_CAPTURE(ClipPlanex, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Color4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Color4f, "glColor4f",
          "context = %d, red = %f, green = %f, blue = %f, alpha = %f", CID(context), red, green,
          blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColor4f(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4f(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(Color4f, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Color4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Color4ub, "glColor4ub",
          "context = %d, red = %d, green = %d, blue = %d, alpha = %d", CID(context), red, green,
          blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColor4ub(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4ub(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(Color4ub, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Color4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Color4x, "glColor4x",
          "context = %d, red = 0x%X, green = 0x%X, blue = 0x%X, alpha = 0x%X", CID(context), red,
          green, blue, alpha);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColor4x(context, red, green, blue, alpha));
        if (isCallValid)
        {
            context->color4x(red, green, blue, alpha);
        }
        ANGLE_CAPTURE(Color4x, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ColorPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ColorPointer, "glColorPointer",
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::ColorPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                           = FromGL<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateColorPointer(context, size, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->colorPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(ColorPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DepthRangex(GLfixed n, GLfixed f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DepthRangex, "glDepthRangex", "context = %d, n = 0x%X, f = 0x%X",
          CID(context), n, f);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDepthRangex(context, n, f));
        if (isCallValid)
        {
            context->depthRangex(n, f);
        }
        ANGLE_CAPTURE(DepthRangex, isCallValid, context, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DisableClientState(GLenum array)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DisableClientState, "glDisableClientState",
          "context = %d, array = %s", CID(context), GLenumToString(GLenumGroup::EnableCap, array));

    if (context)
    {
        ClientVertexArrayType arrayPacked = FromGL<ClientVertexArrayType>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableClientState(context, arrayPacked));
        if (isCallValid)
        {
            context->disableClientState(arrayPacked);
        }
        ANGLE_CAPTURE(DisableClientState, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY EnableClientState(GLenum array)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::EnableClientState, "glEnableClientState",
          "context = %d, array = %s", CID(context), GLenumToString(GLenumGroup::EnableCap, array));

    if (context)
    {
        ClientVertexArrayType arrayPacked = FromGL<ClientVertexArrayType>(array);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEnableClientState(context, arrayPacked));
        if (isCallValid)
        {
            context->enableClientState(arrayPacked);
        }
        ANGLE_CAPTURE(EnableClientState, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Fogf(GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Fogf, "glFogf", "context = %d, pname = %s, param = %f",
          CID(context), GLenumToString(GLenumGroup::FogParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFogf(context, pname, param));
        if (isCallValid)
        {
            context->fogf(pname, param);
        }
        ANGLE_CAPTURE(Fogf, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Fogfv(GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Fogfv, "glFogfv",
          "context = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::FogParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFogfv(context, pname, params));
        if (isCallValid)
        {
            context->fogfv(pname, params);
        }
        ANGLE_CAPTURE(Fogfv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Fogx(GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Fogx, "glFogx", "context = %d, pname = %s, param = 0x%X",
          CID(context), GLenumToString(GLenumGroup::FogPName, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFogx(context, pname, param));
        if (isCallValid)
        {
            context->fogx(pname, param);
        }
        ANGLE_CAPTURE(Fogx, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Fogxv(GLenum pname, const GLfixed *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Fogxv, "glFogxv",
          "context = %d, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::FogPName, pname), (uintptr_t)param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateFogxv(context, pname, param));
        if (isCallValid)
        {
            context->fogxv(pname, param);
        }
        ANGLE_CAPTURE(Fogxv, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Frustumf(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Frustumf, "glFrustumf",
          "context = %d, l = %f, r = %f, b = %f, t = %f, n = %f, f = %f", CID(context), l, r, b, t,
          n, f);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFrustumf(context, l, r, b, t, n, f));
        if (isCallValid)
        {
            context->frustumf(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE(Frustumf, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Frustumx(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Frustumx, "glFrustumx",
          "context = %d, l = 0x%X, r = 0x%X, b = 0x%X, t = 0x%X, n = 0x%X, f = 0x%X", CID(context),
          l, r, b, t, n, f);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateFrustumx(context, l, r, b, t, n, f));
        if (isCallValid)
        {
            context->frustumx(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE(Frustumx, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetClipPlanef(GLenum plane, GLfloat *equation)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetClipPlanef, "glGetClipPlanef",
          "context = %d, plane = %s, equation = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetClipPlanef(context, plane, equation));
        if (isCallValid)
        {
            context->getClipPlanef(plane, equation);
        }
        ANGLE_CAPTURE(GetClipPlanef, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetClipPlanex(GLenum plane, GLfixed *equation)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetClipPlanex, "glGetClipPlanex",
          "context = %d, plane = %s, equation = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetClipPlanex(context, plane, equation));
        if (isCallValid)
        {
            context->getClipPlanex(plane, equation);
        }
        ANGLE_CAPTURE(GetClipPlanex, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetFixedv(GLenum pname, GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetFixedv, "glGetFixedv",
          "context = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::GetPName, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetFixedv(context, pname, params));
        if (isCallValid)
        {
            context->getFixedv(pname, params);
        }
        ANGLE_CAPTURE(GetFixedv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetLightfv(GLenum light, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetLightfv, "glGetLightfv",
          "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked                            = FromGL<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetLightfv(context, light, pnamePacked, params));
        if (isCallValid)
        {
            context->getLightfv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetLightfv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetLightxv(GLenum light, GLenum pname, GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetLightxv, "glGetLightxv",
          "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked                            = FromGL<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetLightxv(context, light, pnamePacked, params));
        if (isCallValid)
        {
            context->getLightxv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetLightxv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetMaterialfv(GLenum face, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetMaterialfv, "glGetMaterialfv",
          "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        MaterialParameter pnamePacked                         = FromGL<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetMaterialfv(context, face, pnamePacked, params));
        if (isCallValid)
        {
            context->getMaterialfv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetMaterialfv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetMaterialxv(GLenum face, GLenum pname, GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetMaterialxv, "glGetMaterialxv",
          "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        MaterialParameter pnamePacked                         = FromGL<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetMaterialxv(context, face, pnamePacked, params));
        if (isCallValid)
        {
            context->getMaterialxv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetMaterialxv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetTexEnvfv(GLenum target, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetTexEnvfv, "glGetTexEnvfv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked                         = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked                       = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexEnvfv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnvfv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetTexEnvfv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetTexEnviv(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetTexEnviv, "glGetTexEnviv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked                         = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked                       = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexEnviv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnviv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetTexEnviv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetTexEnvxv(GLenum target, GLenum pname, GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetTexEnvxv, "glGetTexEnvxv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked                         = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked                       = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexEnvxv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnvxv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(GetTexEnvxv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetTexParameterxv(GLenum target, GLenum pname, GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetTexParameterxv, "glGetTexParameterxv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterxv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterxv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterxv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY LightModelf(GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::LightModelf, "glLightModelf",
          "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::LightModelParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightModelf(context, pname, param));
        if (isCallValid)
        {
            context->lightModelf(pname, param);
        }
        ANGLE_CAPTURE(LightModelf, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY LightModelfv(GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::LightModelfv, "glLightModelfv",
          "context = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::LightModelParameter, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightModelfv(context, pname, params));
        if (isCallValid)
        {
            context->lightModelfv(pname, params);
        }
        ANGLE_CAPTURE(LightModelfv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY LightModelx(GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::LightModelx, "glLightModelx",
          "context = %d, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::LightModelParameter, pname), param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightModelx(context, pname, param));
        if (isCallValid)
        {
            context->lightModelx(pname, param);
        }
        ANGLE_CAPTURE(LightModelx, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY LightModelxv(GLenum pname, const GLfixed *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::LightModelxv, "glLightModelxv",
          "context = %d, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::LightModelParameter, pname), (uintptr_t)param);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightModelxv(context, pname, param));
        if (isCallValid)
        {
            context->lightModelxv(pname, param);
        }
        ANGLE_CAPTURE(LightModelxv, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Lightf(GLenum light, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Lightf, "glLightf",
          "context = %d, light = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), param);

    if (context)
    {
        LightParameter pnamePacked                            = FromGL<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightf(context, light, pnamePacked, param));
        if (isCallValid)
        {
            context->lightf(light, pnamePacked, param);
        }
        ANGLE_CAPTURE(Lightf, isCallValid, context, light, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Lightfv(GLenum light, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Lightfv, "glLightfv",
          "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked                            = FromGL<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightfv(context, light, pnamePacked, params));
        if (isCallValid)
        {
            context->lightfv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE(Lightfv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Lightx(GLenum light, GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Lightx, "glLightx",
          "context = %d, light = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), param);

    if (context)
    {
        LightParameter pnamePacked                            = FromGL<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightx(context, light, pnamePacked, param));
        if (isCallValid)
        {
            context->lightx(light, pnamePacked, param);
        }
        ANGLE_CAPTURE(Lightx, isCallValid, context, light, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Lightxv(GLenum light, GLenum pname, const GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Lightxv, "glLightxv",
          "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::LightName, light),
          GLenumToString(GLenumGroup::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked                            = FromGL<LightParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLightxv(context, light, pnamePacked, params));
        if (isCallValid)
        {
            context->lightxv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE(Lightxv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY LineWidthx(GLfixed width)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::LineWidthx, "glLineWidthx", "context = %d, width = 0x%X",
          CID(context), width);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLineWidthx(context, width));
        if (isCallValid)
        {
            context->lineWidthx(width);
        }
        ANGLE_CAPTURE(LineWidthx, isCallValid, context, width);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY LoadIdentity()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::LoadIdentity, "glLoadIdentity", "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLoadIdentity(context));
        if (isCallValid)
        {
            context->loadIdentity();
        }
        ANGLE_CAPTURE(LoadIdentity, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY LoadMatrixf(const GLfloat *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::LoadMatrixf, "glLoadMatrixf",
          "context = %d, m = 0x%016" PRIxPTR "", CID(context), (uintptr_t)m);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLoadMatrixf(context, m));
        if (isCallValid)
        {
            context->loadMatrixf(m);
        }
        ANGLE_CAPTURE(LoadMatrixf, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY LoadMatrixx(const GLfixed *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::LoadMatrixx, "glLoadMatrixx",
          "context = %d, m = 0x%016" PRIxPTR "", CID(context), (uintptr_t)m);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLoadMatrixx(context, m));
        if (isCallValid)
        {
            context->loadMatrixx(m);
        }
        ANGLE_CAPTURE(LoadMatrixx, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY LogicOp(GLenum opcode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::LogicOp, "glLogicOp", "context = %d, opcode = %s", CID(context),
          GLenumToString(GLenumGroup::LogicOp, opcode));

    if (context)
    {
        LogicalOperation opcodePacked                         = FromGL<LogicalOperation>(opcode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateLogicOp(context, opcodePacked));
        if (isCallValid)
        {
            context->logicOp(opcodePacked);
        }
        ANGLE_CAPTURE(LogicOp, isCallValid, context, opcodePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Materialf(GLenum face, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Materialf, "glMaterialf",
          "context = %d, face = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), param);

    if (context)
    {
        MaterialParameter pnamePacked                         = FromGL<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaterialf(context, face, pnamePacked, param));
        if (isCallValid)
        {
            context->materialf(face, pnamePacked, param);
        }
        ANGLE_CAPTURE(Materialf, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Materialfv(GLenum face, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Materialfv, "glMaterialfv",
          "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        MaterialParameter pnamePacked                         = FromGL<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaterialfv(context, face, pnamePacked, params));
        if (isCallValid)
        {
            context->materialfv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE(Materialfv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Materialx(GLenum face, GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Materialx, "glMaterialx",
          "context = %d, face = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), param);

    if (context)
    {
        MaterialParameter pnamePacked                         = FromGL<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaterialx(context, face, pnamePacked, param));
        if (isCallValid)
        {
            context->materialx(face, pnamePacked, param);
        }
        ANGLE_CAPTURE(Materialx, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Materialxv(GLenum face, GLenum pname, const GLfixed *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Materialxv, "glMaterialxv",
          "context = %d, face = %s, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::MaterialFace, face),
          GLenumToString(GLenumGroup::MaterialParameter, pname), (uintptr_t)param);

    if (context)
    {
        MaterialParameter pnamePacked                         = FromGL<MaterialParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMaterialxv(context, face, pnamePacked, param));
        if (isCallValid)
        {
            context->materialxv(face, pnamePacked, param);
        }
        ANGLE_CAPTURE(Materialxv, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY MatrixMode(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MatrixMode, "glMatrixMode", "context = %d, mode = %s",
          CID(context), GLenumToString(GLenumGroup::MatrixMode, mode));

    if (context)
    {
        MatrixType modePacked                                 = FromGL<MatrixType>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMatrixMode(context, modePacked));
        if (isCallValid)
        {
            context->matrixMode(modePacked);
        }
        ANGLE_CAPTURE(MatrixMode, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY MultMatrixf(const GLfloat *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MultMatrixf, "glMultMatrixf",
          "context = %d, m = 0x%016" PRIxPTR "", CID(context), (uintptr_t)m);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMultMatrixf(context, m));
        if (isCallValid)
        {
            context->multMatrixf(m);
        }
        ANGLE_CAPTURE(MultMatrixf, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY MultMatrixx(const GLfixed *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MultMatrixx, "glMultMatrixx",
          "context = %d, m = 0x%016" PRIxPTR "", CID(context), (uintptr_t)m);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMultMatrixx(context, m));
        if (isCallValid)
        {
            context->multMatrixx(m);
        }
        ANGLE_CAPTURE(MultMatrixx, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY MultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MultiTexCoord4f, "glMultiTexCoord4f",
          "context = %d, target = %s, s = %f, t = %f, r = %f, q = %f", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, target), s, t, r, q);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMultiTexCoord4f(context, target, s, t, r, q));
        if (isCallValid)
        {
            context->multiTexCoord4f(target, s, t, r, q);
        }
        ANGLE_CAPTURE(MultiTexCoord4f, isCallValid, context, target, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY MultiTexCoord4x(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MultiTexCoord4x, "glMultiTexCoord4x",
          "context = %d, texture = %s, s = 0x%X, t = 0x%X, r = 0x%X, q = 0x%X", CID(context),
          GLenumToString(GLenumGroup::TextureUnit, texture), s, t, r, q);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateMultiTexCoord4x(context, texture, s, t, r, q));
        if (isCallValid)
        {
            context->multiTexCoord4x(texture, s, t, r, q);
        }
        ANGLE_CAPTURE(MultiTexCoord4x, isCallValid, context, texture, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Normal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Normal3f, "glNormal3f",
          "context = %d, nx = %f, ny = %f, nz = %f", CID(context), nx, ny, nz);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateNormal3f(context, nx, ny, nz));
        if (isCallValid)
        {
            context->normal3f(nx, ny, nz);
        }
        ANGLE_CAPTURE(Normal3f, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Normal3x(GLfixed nx, GLfixed ny, GLfixed nz)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Normal3x, "glNormal3x",
          "context = %d, nx = 0x%X, ny = 0x%X, nz = 0x%X", CID(context), nx, ny, nz);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateNormal3x(context, nx, ny, nz));
        if (isCallValid)
        {
            context->normal3x(nx, ny, nz);
        }
        ANGLE_CAPTURE(Normal3x, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY NormalPointer(GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::NormalPointer, "glNormalPointer",
          "context = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::NormalPointerType, type), stride, (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                           = FromGL<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateNormalPointer(context, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->normalPointer(typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(NormalPointer, isCallValid, context, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Orthof(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Orthof, "glOrthof",
          "context = %d, l = %f, r = %f, b = %f, t = %f, n = %f, f = %f", CID(context), l, r, b, t,
          n, f);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateOrthof(context, l, r, b, t, n, f));
        if (isCallValid)
        {
            context->orthof(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE(Orthof, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Orthox(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Orthox, "glOrthox",
          "context = %d, l = 0x%X, r = 0x%X, b = 0x%X, t = 0x%X, n = 0x%X, f = 0x%X", CID(context),
          l, r, b, t, n, f);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateOrthox(context, l, r, b, t, n, f));
        if (isCallValid)
        {
            context->orthox(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE(Orthox, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PointParameterf(GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PointParameterf, "glPointParameterf",
          "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, pname), param);

    if (context)
    {
        PointParameter pnamePacked                            = FromGL<PointParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePointParameterf(context, pnamePacked, param));
        if (isCallValid)
        {
            context->pointParameterf(pnamePacked, param);
        }
        ANGLE_CAPTURE(PointParameterf, isCallValid, context, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PointParameterfv(GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PointParameterfv, "glPointParameterfv",
          "context = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        PointParameter pnamePacked                            = FromGL<PointParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePointParameterfv(context, pnamePacked, params));
        if (isCallValid)
        {
            context->pointParameterfv(pnamePacked, params);
        }
        ANGLE_CAPTURE(PointParameterfv, isCallValid, context, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PointParameterx(GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PointParameterx, "glPointParameterx",
          "context = %d, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, pname), param);

    if (context)
    {
        PointParameter pnamePacked                            = FromGL<PointParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePointParameterx(context, pnamePacked, param));
        if (isCallValid)
        {
            context->pointParameterx(pnamePacked, param);
        }
        ANGLE_CAPTURE(PointParameterx, isCallValid, context, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PointParameterxv(GLenum pname, const GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PointParameterxv, "glPointParameterxv",
          "context = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        PointParameter pnamePacked                            = FromGL<PointParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePointParameterxv(context, pnamePacked, params));
        if (isCallValid)
        {
            context->pointParameterxv(pnamePacked, params);
        }
        ANGLE_CAPTURE(PointParameterxv, isCallValid, context, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PointSize(GLfloat size)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PointSize, "glPointSize", "context = %d, size = %f",
          CID(context), size);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePointSize(context, size));
        if (isCallValid)
        {
            context->pointSize(size);
        }
        ANGLE_CAPTURE(PointSize, isCallValid, context, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PointSizex(GLfixed size)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PointSizex, "glPointSizex", "context = %d, size = 0x%X",
          CID(context), size);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePointSizex(context, size));
        if (isCallValid)
        {
            context->pointSizex(size);
        }
        ANGLE_CAPTURE(PointSizex, isCallValid, context, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PolygonOffsetx(GLfixed factor, GLfixed units)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PolygonOffsetx, "glPolygonOffsetx",
          "context = %d, factor = 0x%X, units = 0x%X", CID(context), factor, units);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePolygonOffsetx(context, factor, units));
        if (isCallValid)
        {
            context->polygonOffsetx(factor, units);
        }
        ANGLE_CAPTURE(PolygonOffsetx, isCallValid, context, factor, units);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PopMatrix()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PopMatrix, "glPopMatrix", "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePopMatrix(context));
        if (isCallValid)
        {
            context->popMatrix();
        }
        ANGLE_CAPTURE(PopMatrix, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PushMatrix()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PushMatrix, "glPushMatrix", "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePushMatrix(context));
        if (isCallValid)
        {
            context->pushMatrix();
        }
        ANGLE_CAPTURE(PushMatrix, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Rotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Rotatef, "glRotatef",
          "context = %d, angle = %f, x = %f, y = %f, z = %f", CID(context), angle, x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateRotatef(context, angle, x, y, z));
        if (isCallValid)
        {
            context->rotatef(angle, x, y, z);
        }
        ANGLE_CAPTURE(Rotatef, isCallValid, context, angle, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Rotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Rotatex, "glRotatex",
          "context = %d, angle = 0x%X, x = 0x%X, y = 0x%X, z = 0x%X", CID(context), angle, x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateRotatex(context, angle, x, y, z));
        if (isCallValid)
        {
            context->rotatex(angle, x, y, z);
        }
        ANGLE_CAPTURE(Rotatex, isCallValid, context, angle, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY SampleCoveragex(GLclampx value, GLboolean invert)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::SampleCoveragex, "glSampleCoveragex",
          "context = %d, value = 0x%X, invert = %s", CID(context), value,
          GLbooleanToString(invert));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateSampleCoveragex(context, value, invert));
        if (isCallValid)
        {
            context->sampleCoveragex(value, invert);
        }
        ANGLE_CAPTURE(SampleCoveragex, isCallValid, context, value, invert);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Scalef(GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Scalef, "glScalef", "context = %d, x = %f, y = %f, z = %f",
          CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateScalef(context, x, y, z));
        if (isCallValid)
        {
            context->scalef(x, y, z);
        }
        ANGLE_CAPTURE(Scalef, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Scalex(GLfixed x, GLfixed y, GLfixed z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Scalex, "glScalex", "context = %d, x = 0x%X, y = 0x%X, z = 0x%X",
          CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateScalex(context, x, y, z));
        if (isCallValid)
        {
            context->scalex(x, y, z);
        }
        ANGLE_CAPTURE(Scalex, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ShadeModel(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ShadeModel, "glShadeModel", "context = %d, mode = %s",
          CID(context), GLenumToString(GLenumGroup::ShadingModel, mode));

    if (context)
    {
        ShadingModel modePacked                               = FromGL<ShadingModel>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateShadeModel(context, modePacked));
        if (isCallValid)
        {
            context->shadeModel(modePacked);
        }
        ANGLE_CAPTURE(ShadeModel, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexCoordPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexCoordPointer, "glTexCoordPointer",
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::TexCoordPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                           = FromGL<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexCoordPointer(context, size, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->texCoordPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(TexCoordPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexEnvf(GLenum target, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexEnvf, "glTexEnvf",
          "context = %d, target = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), param);

    if (context)
    {
        TextureEnvTarget targetPacked                         = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked                       = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexEnvf(context, targetPacked, pnamePacked, param));
        if (isCallValid)
        {
            context->texEnvf(targetPacked, pnamePacked, param);
        }
        ANGLE_CAPTURE(TexEnvf, isCallValid, context, targetPacked, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexEnvfv(GLenum target, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexEnvfv, "glTexEnvfv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked                         = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked                       = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexEnvfv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->texEnvfv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(TexEnvfv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexEnvi(GLenum target, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexEnvi, "glTexEnvi",
          "context = %d, target = %s, pname = %s, param = %d", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), param);

    if (context)
    {
        TextureEnvTarget targetPacked                         = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked                       = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexEnvi(context, targetPacked, pnamePacked, param));
        if (isCallValid)
        {
            context->texEnvi(targetPacked, pnamePacked, param);
        }
        ANGLE_CAPTURE(TexEnvi, isCallValid, context, targetPacked, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexEnviv(GLenum target, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexEnviv, "glTexEnviv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked                         = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked                       = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexEnviv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->texEnviv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(TexEnviv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexEnvx(GLenum target, GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexEnvx, "glTexEnvx",
          "context = %d, target = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), param);

    if (context)
    {
        TextureEnvTarget targetPacked                         = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked                       = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexEnvx(context, targetPacked, pnamePacked, param));
        if (isCallValid)
        {
            context->texEnvx(targetPacked, pnamePacked, param);
        }
        ANGLE_CAPTURE(TexEnvx, isCallValid, context, targetPacked, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexEnvxv(GLenum target, GLenum pname, const GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexEnvxv, "glTexEnvxv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureEnvTarget, target),
          GLenumToString(GLenumGroup::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked                         = FromGL<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked                       = FromGL<TextureEnvParameter>(pname);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexEnvxv(context, targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->texEnvxv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE(TexEnvxv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexParameterx(GLenum target, GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexParameterx, "glTexParameterx",
          "context = %d, target = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), param);

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameterx(context, targetPacked, pname, param));
        if (isCallValid)
        {
            context->texParameterx(targetPacked, pname, param);
        }
        ANGLE_CAPTURE(TexParameterx, isCallValid, context, targetPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexParameterxv(GLenum target, GLenum pname, const GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexParameterxv, "glTexParameterxv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameterxv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterxv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterxv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Translatef(GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Translatef, "glTranslatef",
          "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateTranslatef(context, x, y, z));
        if (isCallValid)
        {
            context->translatef(x, y, z);
        }
        ANGLE_CAPTURE(Translatef, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Translatex(GLfixed x, GLfixed y, GLfixed z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Translatex, "glTranslatex",
          "context = %d, x = 0x%X, y = 0x%X, z = 0x%X", CID(context), x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateTranslatex(context, x, y, z));
        if (isCallValid)
        {
            context->translatex(x, y, z);
        }
        ANGLE_CAPTURE(Translatex, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexPointer, "glVertexPointer",
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLenumGroup::VertexPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                           = FromGL<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexPointer(context, size, typePacked, stride, pointer));
        if (isCallValid)
        {
            context->vertexPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE(VertexPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}
}  // namespace gl
