/*
 *	for new GOGO-no-coda (1999/09)
 *	Copyright (C) 1999, 2000 PEN@MarineCat, shigeo, sakai
 *
 *	99/01/18 LinuxŕW͑Ή
 *	99/03/02 Ot@CΉ
 *	99/03/18 C^[tFCX
 *	99/09/07 -skipIvVp~AWAV_checkFMT()Ŏ
 *	99/09/11 J & \[XJ
 *	99/09/26 J蒼̂߂C
 *	99/10/03 -e {n,c,5} Gt@VXIvVǉ
 *	99/10/07 MTbeta, VBR-beta
 *	99/11/04 RAW-PCMΉ̂offsetbswapIvVǉ
 *	99/11/09 detele option by Steve
 *	99/11/20 stdin for WinNT
 *	00/01/18 lame3.55 VBR partially
 *	00/03/23 MPGE_processTrackV
 */

#include "common.h"
#include "musenc.h"
#include "haveunit.h"
#include "message.h"

#ifdef	WIN32
#include <windows.h>
#include <signal.h>
#include <conio.h>
#ifdef	USE_8HZ
#error "Can't use USE_8HZ"
#endif /* USE_8HZ */
#endif /* WIN32 */

#include <string.h>
#include <ctype.h>
#if	defined(DISPLAY_REALTIME)
#include <unistd.h>
#include <sys/time.h>
#else
#include <time.h>
#endif
#include <stdarg.h>
#include <limits.h>
#ifndef __unix__
#include <dos.h>
#endif
#if	defined(__linux__) || defined(__FreeBSD__)
#include <signal.h>
#include <sys/time.h>
#endif

#ifndef _WINDOWS	/* Win GUIȊOłdebugϐg */
extern int debug;
#else
static int debug = 0;
#endif
/* ԕ\ɕύXƂ͒` */
//#define	DISPLAY_REALTIME
static int silentFlag = 0;
static int deleteFlag = 0;
static int testmodeFlag = 0;
static int enc_testtime = 0;
static char szInName[MAX_FILE_LEN], szOutName[MAX_FILE_LEN];

/*
 *   G[\
 */
void disp_err( const char *mesg, ... )
{
	char	bufs[1024];

	va_list vlist;
	va_start( vlist, mesg );
	vsprintf( bufs, mesg, vlist );
	fputs( bufs, stderr );
	va_end( vlist );
}

static void usage(void){
	fprintf(stderr, getMsg( MSG_help1 ) );
	fprintf(stderr, getMsg( MSG_help2 ) );
	fprintf(stderr, getMsg( MSG_help3 ) );
	fprintf(stderr, getMsg( MSG_help4 ) );
	fprintf(stderr, getMsg( MSG_help5 ) );
	fprintf(stderr, getMsg( MSG_help6 ) );
	fprintf(stderr, getMsg( MSG_help7 ) );
	fprintf(stderr, getMsg( MSG_help8 ) );
	fprintf(stderr, getMsg( MSG_help9 ) );
	fprintf(stderr, getMsg( MSG_help10 ) );

	fprintf(stderr, getMsg( MSG_help11 ) );
	fprintf(stderr, getMsg( MSG_help12 ) );
#ifdef USE_VBR
	fprintf(stderr, getMsg( MSG_help13 ) );
#endif
#ifdef RAW_INPUT
	fprintf(stderr, getMsg( MSG_help14 ) );
	fprintf(stderr, getMsg( MSG_help15 ) );
	fprintf(stderr, getMsg( MSG_help16 ) );
	fprintf(stderr, getMsg( MSG_help17 ) );
	fprintf(stderr, getMsg( MSG_help18 ) );
	fprintf(stderr, getMsg( MSG_help19 ) );
#ifdef __HIGHC__
	fprintf(stderr, getMsg( MSG_help20 ) );
#endif
#endif
#if     defined(USE_PTHREAD) || defined(USE_BTHREAD) || defined(USE_WINTHREAD) || defined(USE_OS2THREAD)
	fprintf(stderr, getMsg( MSG_help21 ) );
#endif
#ifdef BeOS
	fprintf(stderr, getMsg( MSG_help22 ) );
#if	defined(USE_BTHREAD)
	fprintf(stderr, getMsg( MSG_help23 ) );
#endif
#endif
	fprintf(stderr, getMsg( MSG_help24 ) );
	fprintf(stderr, getMsg( MSG_help25 ) );
	fprintf(stderr, getMsg( MSG_help26 ) );
	fprintf(stderr, getMsg( MSG_help27 ) );
	fprintf(stderr, getMsg( MSG_help28 ) );
	fprintf(stderr, getMsg( MSG_help29 ) );
	fprintf(stderr, getMsg( MSG_help30 ) );
	fprintf(stderr, getMsg( MSG_help31 ) );
	fprintf(stderr, getMsg( MSG_help33 ) ); /* lang */
#ifdef WIN32
	fprintf(stderr, getMsg( MSG_help32 ) );
#endif
}


/*
 *	MS-DOSt@COt@C
 *	ƃt@C݂Ȃꍇ ERR Ԃ
 *	WIN32`ĂȂΉȂ
 */

#define isKANJI1(x) ((unsigned char)((x^0x20)-0xA1)<=0x3B)

static int convertToLongFileName(char *fname, const int max_len )
{
#ifndef WIN32
	return NOERR;
#else
	LPHANDLE hdl;
	WIN32_FIND_DATA info;
	int i,j;
	hdl = FindFirstFile( fname, &info );
	if( hdl == INVALID_HANDLE_VALUE  )
		return ERR;
	if( !*info.cFileName ){
		FindClose( hdl );
		return ERR;
	}

	i = ( fname[1] == ':' ) ? 2 : 0;	/* hCu̕ */
	j = i - 1;
	while( i < strlen( fname ) ){
#ifdef JAPANESE_SPC
		if( isKANJI1( fname[i] ) ){
			i++;
		}else
#endif
		{
			if( fname[i] == '\\' ) j = i;
		}
		i++;
	}
	fname[j+1] = NUL;	/* patho */
	if( strlen( fname ) + strlen( info.cFileName ) >= max_len ) return ERR;
	strcat( fname, info.cFileName ); /* tpXɂ */
	if( debug ) fprintf( stderr, "long file name : %s\n", fname );
	FindClose( hdl );
	return NOERR;
#endif /* WIN32 */
}
//#undef isKANJI1

/*
 *	CPU\
 */
static void put_statUNIT(void){
	unsigned long statUNIT;
	MPGE_getUnitStates( &statUNIT );//	statUNIT = haveUNIT();
	if( statUNIT & tFAMILY4 )fprintf(stderr,"familiy 4:");
	if( statUNIT & tFAMILY5 )fprintf(stderr,"familiy 5:");
	if( statUNIT & tFAMILY6 )fprintf(stderr,"familiy 6(or over):");
	fprintf(stderr,"vendor ");
	if( statUNIT & tINTEL )fprintf(stderr,"Intel\n");
	else if( statUNIT & tAMD   )fprintf(stderr,"AMD\n");
	else if( statUNIT & tCYRIX )fprintf(stderr,"Cyrix\n");
	else if( statUNIT & tIDT   )fprintf(stderr,"IDT\n");
	else fprintf(stderr,"unkown\n");
	fprintf(stderr,"extended instruction - ");
	if( statUNIT & tMMX )fprintf(stderr,"MMX ");
	if( statUNIT & tCMOV )fprintf(stderr,"CMOV ");
	if( statUNIT & t3DN )fprintf(stderr,"3D Now! ");
	if( statUNIT & tE3DN)fprintf(stderr,"Ext. 3D Now! ");
	if( statUNIT & tSSE )fprintf(stderr,"SSE");
	fprintf(stderr,"\n");
}

/*
 *	IvV
 */

static int getOpt(int argc,char **argv)
{
//	char	*inPath, *outPath;
	char	bInPath, bOutPath;

	bInPath = bOutPath = FALSE;
	/***   analize options   ***/
	argc--,argv++;
	while(argc){
		if(!strcmp(*argv,"-m")){		/* mono/stereo */
			argc--,argv++;
			if(argc){
				if(!strcmp(*argv,"m")){
					argc--,argv++;
					MPGE_setConfigure( MC_ENCODEMODE, MC_MODE_MONO, 0);
					continue;
				}else if(!strcmp(*argv,"s")){
					argc--,argv++;
					MPGE_setConfigure( MC_ENCODEMODE, MC_MODE_STEREO, 0);
					continue;
				}else if(!strcmp(*argv,"j")){
					argc--,argv++;
					MPGE_setConfigure( MC_ENCODEMODE, MC_MODE_JOINT, 0);
					continue;
				}else if(!strcmp(*argv,"f")){
					argc--,argv++;
					MPGE_setConfigure( MC_ENCODEMODE, MC_MODE_MSSTEREO, 0);
					continue;
				}else if(!strcmp(*argv,"d")){
					argc--,argv++;
					MPGE_setConfigure( MC_ENCODEMODE, MC_MODE_DUALCHANNEL, 0);
					continue;
				}
			}
			disp_err( "%s[%s]\n", getMsg( MSG_err_opt_m ), *argv );
			return ERR;
		}else
#ifdef RAW_INPUT /* Thanks to Gonn 99/11/09 */
		if( !strcmp( *argv, "-bswap") ){
			argc--,argv++;
			MPGE_setConfigure( MC_BYTE_SWAP, TRUE, 0 );
		}else
#endif /* RAW_INPUT */
		if(!strncmp(*argv,"-b",2)){	/* bitrate */
			int unit=-1;
			if((*argv)[2]==NUL){
				unit=1;				/* bps */
			}else if((*argv)[2]=='r' && (*argv)[3]==NUL){
				unit=1000;			/* kbps */
			}
			if(unit==-1 || argc<=1){
				disp_err( "%s[%s]\n", getMsg( MSG_err_opt_b ), *argv );
				return ERR;
			}
			argc--,argv++;
			MPGE_setConfigure( MC_BITRATE, atoi(*argv)/unit, 0);
			argc--,argv++;
		}else if(!strcmp(*argv,"-s")){	/* INPUT sampling rate */
			int	freqHz;
			argc--,argv++;
			if(!argc){
				disp_err( getMsg( MSG_err_opt_s ) );
				return ERR;
			}
			freqHz=(int)(atof(*argv)*1000.0+0.5);
			if( freqHz == 0 ){
			  disp_err( getMsg( MSG_err_rate ) );
			  return ERR;
			}
			argc--,argv++;
			MPGE_setConfigure( MC_INPFREQ, freqHz, 0);
		}else if(!strcmp(*argv,"-d")){	/* OUTPUT sampling rate */
			int	freqHz;
			argc--,argv++;
			if(!argc){
				disp_err( getMsg( MSG_err_opt_d ) );
				return ERR;
			}
			freqHz=(int)(atof(*argv)*1000.0+0.5);
			argc--,argv++;
			MPGE_setConfigure( MC_OUTFREQ, freqHz, 0);
		}else
		if( !strcmp(*argv, "-emp") ){	/* emphasis */
			argc--,argv++;
			if( argc && !strcmp(*argv, "n") ){
				MPGE_setConfigure( MC_EMPHASIS, 0, 0);
			}else
			if( argc && !strcmp(*argv, "5") ){
				MPGE_setConfigure( MC_EMPHASIS, 1, 0);
			}else
			if( argc && !strcmp(*argv, "c") ){
				MPGE_setConfigure( MC_EMPHASIS, 3, 0);
			}else
			{
				disp_err( getMsg( MSG_err_opt_emp ) );
				return ERR;
			}
			argc--,argv++;
		}else
		/* special units */
		if( !strcmp(*argv,"-off") ){
			argc--,argv++;
			if( argc && !strcmp(*argv,"mmx") ){
				MPGE_setConfigure( MC_USEMMX, FALSE, 0);
			}else
			if( argc && !strcmp(*argv,"3dn") ){
				MPGE_setConfigure( MC_USE3DNOW, FALSE, 0);
			}else
			if( argc && ( !strcmp(*argv,"kni") || !strcmp(*argv,"sse") ) ){
				MPGE_setConfigure( MC_USEKNI, FALSE, 0);
			}else
			if( argc && !strcmp(*argv,"e3dn") ){
				MPGE_setConfigure( MC_USEE3DNOW, FALSE, 0);
			}else
			{
				disp_err( getMsg( MSG_err_opt_off ) );
				return ERR;
			}
			argc--,argv++;
		}else
		if( !strcmp(*argv, "-lpf") ){
			argc--,argv++;
			if( argc && !strcmp(*argv, "on") ){
				MPGE_setConfigure( MC_USELPF16, TRUE, 0 );
			}else
			if( argc && !strcmp(*argv, "off") ){
				MPGE_setConfigure( MC_USELPF16, FALSE, 0 );
			}else
			if( argc >= 2 && MPGE_setConfigure( MC_ENHANCEDFILTER, atoi( *argv ), atoi( *(argv+1) ) ) == ME_NOERR ){
				argc --,argv++;
			}else
			{
				disp_err( getMsg( MSG_err_opt_lpf ) );
				return ERR;
			}
			argc--,argv++;
		}else
		if( !strcmp( *argv, "-th" ) ){ /* ThresHold for j-stereo */
			argc--,argv++;
			if( argc >= 2 && MPGE_setConfigure( MC_MSTHRESHOLD, atoi( *argv ), atoi( *(argv+1) ) ) == ME_NOERR ){
				argc -= 2,argv += 2;
			}else
			{
				disp_err( getMsg( MSG_err_opt_th ) );
				return ERR;
			}
		}else
		if( !strcmp( *argv, "-i") ){ /* verify and overwirte */
			argc--,argv++;
			MPGE_setConfigure( MC_VERIFY, TRUE, 0 );
		}else
#if   defined(USE_PTHREAD) || defined(USE_BTHREAD) || defined(USE_WINTHREAD) || defined(USE_OS2THREAD)
		/* SMP */
		if( !strcmp(*argv,"-cpu") ){
			int	cpu;
			argc--,argv++;
			if(!argc){
				disp_err( getMsg( MSG_err_opt_cpu ) );
				return ERR;
			}
			cpu=atoi(*argv);
			argc--,argv++;
			MPGE_setConfigure( MC_CPU, cpu, 0);
		}else
#endif
#if	defined(BeOS)
		/* Priority */
		if( !strcmp(*argv,"-priority") ){
			int	priority;
			argc--,argv++;
			if(!argc){
				disp_err( getMsg( MSG_err_opt_priority ) );
				return ERR;
			}
			priority=atoi(*argv);
			argc--,argv++;
			MPGE_setConfigure( MC_THREAD_PRIORITY, priority, 0);
		}else
#endif
#if	defined(WIN32) 
		/* Priority */
		if( !strcmp(*argv,"-priority") ){
			argc--,argv++;
			if(!argc){
				disp_err( getMsg( MSG_err_opt_priority ) );
				return ERR;
			}
			{
				static const char *prio[] = {
					"highest", 
					"high", 
					"normal", 
					"low", 
					"lowest"
				};
				int		prio_id[] = {
					THREAD_PRIORITY_TIME_CRITICAL,
					THREAD_PRIORITY_HIGHEST,
					THREAD_PRIORITY_NORMAL,
					THREAD_PRIORITY_BELOW_NORMAL,
					THREAD_PRIORITY_IDLE
				};
				int		n;
				const int nMax = sizeof(prio) / sizeof( prio[0]);
				for( n = 0; n < nMax; n++){
					if( stricmp( *argv, prio[n]) == 0 ){
						break;
					}
				}
				if( n == nMax ) {
					disp_err( getMsg( MSG_err_opt_priority ) );
					return ERR;
				}
				MPGE_setConfigure( MC_THREAD_PRIORITY, (UPARAM)prio_id[n], 0);
			}
			argc--,argv++;
		}else
#endif
#if	defined(USE_BTHREAD)
		/* ReadThreadPriority */
		if( !strcmp(*argv,"-readthread") ){
			int	priority;
			argc--,argv++;
			if(!argc){
				disp_err( getMsg( MSG_err_opt_readpriority ) );
				return ERR;
			}
			priority=atoi(*argv);
			argc--,argv++;
			MPGE_setConfigure( MC_READTHREAD_PRIORITY, priority, 0);
		}else
#endif
		if( !strcmp(*argv,"-spc1") ){
			argc--,argv++;
			MPGE_setConfigure( MC_USESPC1, TRUE, 0);
		}else
		if( !strcmp(*argv,"-spc2") ){
			argc--,argv++;
			MPGE_setConfigure( MC_USESPC2, TRUE, 0);
		}else
		if( !strcmp(*argv,"-debug") ){
			argc--,argv++;
			debug = 1;
		}else
#ifdef USE_VBR
		if( !strcmp(*argv,"-v") ){
		  argc--,argv++;
		  if( argc && isdigit(**argv) && (*argv)[1]=='\0' ){
		    MPGE_setConfigure( MC_VBR, **argv - '0', 0);
		  }else{
		    disp_err( getMsg( MSG_err_opt_v ) );
		    return ERR;
		  }
		  argc--,argv++;
		}else
		if( !strcmp( *argv, "-vb" ) ){
			int minrate = 0, maxrate = 0;
			argc--,argv++;
			if( argc >= 2 ){
				minrate = atoi( *argv );
				argv++;
				maxrate = atoi( *argv );
				argv++;
				argc -= 2;
			}
			if( MPGE_setConfigure( MC_VBRBITRATE, minrate, maxrate ) == ME_PARAMERROR ){
				disp_err( getMsg( MSG_err_opt_vb ) );
			}
		}else
#endif /* USE_VBR */
#ifdef RAW_INPUT
		if( !strcmp( *argv, "-offset") ){
			argc--,argv++;
			if( !argc ){
				disp_err( getMsg( MSG_err_opt_offset ) );
				return ERR;
			}
			MPGE_setConfigure( MC_STARTOFFSET, atoi( *argv ), 0);
			argc--,argv++;
		}else
		if( !strcmp( *argv, "-8bit") ){
			argc--,argv++;
			MPGE_setConfigure( MC_8BIT_PCM, TRUE, 0 );
		}else
		if( !strcmp( *argv, "-mono") ){
			argc--,argv++;
			MPGE_setConfigure( MC_MONO_PCM, TRUE, 0 );
		}else
		if( !strcmp( *argv, "-tos") ){
			argc--,argv++;
			MPGE_setConfigure( MC_TOWNS_SND, TRUE, 0 );
		}else
#endif /* RAW_INPUT */
		if( !strcmp(*argv,"-o") ){
			/* output directory */
			argc--,argv++;
			if( !argc ){
				disp_err( getMsg( MSG_err_opt_outputdir ) );
				return ERR;
			}
			MPGE_setConfigure( MC_OUTPUTDIR, (UPARAM)*argv, 0 );
			argc--,argv++;
		}else
		if(!strcmp(*argv,"-silent")){ /* oߔ\ */
			argc--,argv++;
			silentFlag++;
		}else
		if(!strncmp(*argv,"-test", 5)){		/* benchmark mode */
			testmodeFlag++;
			enc_testtime = atoi( *argv + 5 );
			if( !enc_testtime ) enc_testtime = 60 * 10; /* sec */
			fprintf( stderr, "test time %dsec\n", enc_testtime );
			argc--,argv++;
		}else
		if(!strcmp(*argv,"-nopsy")){  /* S */
			MPGE_setConfigure( MC_USEPSY, FALSE, 0);
			argc--,argv++;
		}else
		if(!strcmp(*argv,"-delete")){
			deleteFlag++;
			argc--,argv++;
		}else
		if(!strcmp(*argv,"-lang")){
			argc--,argv++;
			argc--,argv++; /* already checked in the top of main() */
		}else
		if( !strcmp(*argv,"-riff") ){  /* RIFF/WAVE or RIFF/RMP3 */
			argc--;
			argv++;
			if( !argc ){
				disp_err( getMsg( MSG_err_riff_opt ) );
				return ERR;
			}
			if (!strcmp(*argv,"wave")) {
				MPGE_setConfigure( MC_OUTPUT_FORMAT, MC_OUTPUT_RIFF_WAVE, 0 );
			}
			else 
			if (!strcmp(*argv,"rmp")) {
				MPGE_setConfigure( MC_OUTPUT_FORMAT, MC_OUTPUT_RIFF_RMP, 0 );
			}
			else
			{
				disp_err( getMsg( MSG_err_riff_opt ) );
				return ERR;
			}
			argc--;
			argv++;
		}else
		{
			if(bInPath==FALSE){			/* input file name */
				if( !strcmp( *argv, "stdin" ) ){
					MPGE_setConfigure( MC_INPUTFILE, MC_INPDEV_STDIO, (UPARAM)0 );
				}
				else{
					char inPath[ MAX_FILE_LEN ];
					if( strlen( *argv ) >= MAX_FILE_LEN ){
						fprintf( stderr, "Sorry, this file name is too long.[%s]\n", *argv );
						return ERR;
					}
					strcpy( inPath, *argv );
					if( convertToLongFileName( inPath, MAX_FILE_LEN ) == ERR ){
						disp_err( getMsg( MSG_err_inp ), inPath );
						*inPath = NUL;
						return ERR;
					}
					MPGE_setConfigure( MC_INPUTFILE, MC_INPDEV_FILE, (UPARAM)inPath );
				}
				bInPath++;
				argc--,argv++;
			}else if(bOutPath==FALSE){	/* output file name */
				MPGE_setConfigure( MC_OUTPUTFILE, MC_OUTDEV_FILE, (UPARAM)*argv );
				bOutPath++;
				argc--,argv++;
			}else{
				disp_err( "%s[%s]\n", getMsg( MSG_err_else ), *argv );
				argc--,argv++;
				/* IvV͑s */
			}
		}
	}
	return NOERR;
}

static void putConfig(void)
{
	int		nParam;
	char	*strBuf;

	fprintf(stderr,"MPEG 1, layer 3 ");
	if( !MPGE_getConfigure( MG_ENCODEMODE, &nParam ) ){
		switch( nParam ){
			case MC_MODE_MONO:
				strBuf = getMsg( MSG_mono );
				break;
			case MC_MODE_STEREO:
				strBuf = getMsg( MSG_stereo );
				break;
			case MC_MODE_JOINT:
				strBuf = getMsg( MSG_j_stereo );
				break;
			case MC_MODE_MSSTEREO:
				strBuf = getMsg( MSG_ms_stereo );
				break;
			case MC_MODE_DUALCHANNEL:
				strBuf = getMsg( MSG_dual );
				break;
			default:
				strBuf = getMsg( MSG_undefined );
		}
		fprintf(stderr,"%s\n", strBuf );
	}

	if( !MPGE_getConfigure( MG_INPFREQ, &nParam ) ){
		fprintf(stderr, "%s=%.1fkHz ", getMsg( MSG_in_freq ), nParam / 1000.0 );
	}
	if( !MPGE_getConfigure( MG_OUTFREQ, &nParam ) ){
		fprintf(stderr, "%s=%.1fkHz ", getMsg( MSG_out_freq ), nParam / 1000.0 );
	}
	if( !MPGE_getConfigure( MG_BITRATE, &nParam ) ){
		fprintf(stderr,"%s=%dkbps\n", getMsg( MSG_bitrate ), nParam );
	}

	if( !MPGE_getConfigure( MG_INPUTFILE, szInName )  &&
	    !MPGE_getConfigure( MG_OUTPUTFILE, szOutName ) ){
		fprintf(stderr, "%s `%s'\n%s `%s'\n", getMsg( MSG_in_name ), (*szInName)?szInName:"stdin",
			getMsg( MSG_out_name ), szOutName);
	}
}

static char *
GetErrorMesg( int nErrorCode )
{
	switch( nErrorCode ){
	case ME_NOERR:
		return getMsg( MSG_ME_NOERR );
	case ME_EMPTYSTREAM:
		return getMsg( MSG_ME_EMPTYSTREAM );
	case ME_PARAMERROR:
		return getMsg( MSG_ME_INTERNALERROR );
	case ME_NOFPU:
	        return getMsg( MSG_ME_NOFPU );
	case ME_INFILE_NOFOUND:
	        return getMsg( MSG_ME_INFILE_NOFOUND );
	case ME_OUTFILE_NOFOUND:
	        return getMsg( MSG_ME_OUTFILE_NOFOUND );
	case ME_FREQERROR:
	        return getMsg( MSG_ME_FREQERROR );
	case ME_BITRATEERROR:
	case ME_BITRATE_ERR:
	        return getMsg( MSG_ME_BITRATEERROR );

	case ME_WAVETYPE_ERR:
	        return getMsg( MSG_ME_WAVETYPE_ERR );
	case ME_CANNOT_SEEK:
	        return getMsg( MSG_ME_CANNOT_SEEK );
	case ME_HALTED:
	        return getMsg( MSG_ME_HALTED );
        default:
		return "undefined error";
	}
}

#ifdef WIN32
static void
clock_to_hms( double sec, int *h, int *m, int *s, int *ms)
{
	int		t = (int)(sec * 100.);

	*ms = t % 100; t /= 100;
	*s  = t % 60 ; t /= 60;
	*m  = t % 60 ; t /= 60;
	*h  = t;
}
#endif

static int GENRAND()
{
	static unsigned int seed = 0;
	seed = seed * 0x32842851 + 12398321;
	return seed & INT_MAX;
}

/* ----------------------------------------------------------------------- */
#define		MAX_CHANNEL			16	
static	short test_sample[MAX_CHANNEL][2304];
static
MERET	enctest_inputfunc(void *buf, unsigned long nLength )
{
	static	int firstcall = 1;
	static	int	nRestFrame;
	if( firstcall ){
		int		i, j, nMax;

		firstcall = 0;
		for(i = 0;i < MAX_CHANNEL; i ++ ){
			nMax = 0x4000 + 0x6000 * i / MAX_CHANNEL;
			for(j = 0;j < 2304;j++){
				test_sample[i][j] = (GENRAND() % nMax) - nMax/2 ;
			}
		}
		nRestFrame = (int)((double)enc_testtime*(44100.*2*2/4608.));		// ct[
	}
	if( 0 < nRestFrame-- ){
		memcpy( buf, test_sample[ GENRAND() % MAX_CHANNEL ], nLength );
		return ME_NOERR;
	}
	return ME_EMPTYSTREAM;
}

static
MERET	enctest_outputfunc(void *buf, unsigned long nLength )
{
	return ME_NOERR;
}
/* ----------------------------------------------------------------------- */
#if defined(WIN32)

/* 
 *  CTRL+C~ sԂɂȂĂt@Cɖ߂
 */
BOOL WINAPI CTRL_C_HANDLER(DWORD  CtrlType)
{
    fprintf( stderr, "\n\nApplication was terminated.\n");
    MPGE_closeCoder();
    exit(-1);
}
#endif
/* ----------------------------------------------------------------------- */

/* Why does this run on Windows? */
void
write_time(int, long elapsed_sec, long elapsed_usec, unsigned frameNum,
	unsigned total_frame, unsigned sps, unsigned spf);/* defined in clk.nas */

#if	defined(__linux__) || defined(__FreeBSD__)
static struct timeval	ElapsedTime;
static int		total_frame, frameNum, samplesPerFrame, freqHz;
static struct itimerval	itimer;

/* \pXbh */
/* 莞ԖɃJ[lɂċN */
static void
display_time(int n)
{
	ElapsedTime.tv_sec += itimer.it_interval.tv_sec;
	ElapsedTime.tv_usec += itimer.it_interval.tv_usec;
	ElapsedTime.tv_sec += ElapsedTime.tv_usec/1000000;
	ElapsedTime.tv_usec = ElapsedTime.tv_usec%1000000;

	write_time(fileno(stdout), ElapsedTime.tv_sec, ElapsedTime.tv_usec,
		frameNum, total_frame, freqHz, samplesPerFrame);
}
#endif

int main(int argc,char **argv)
{
#if	!defined(__linux__) && !defined(__FreeBSD__)
	int		total_frame, frameNum, samplesPerFrame, freqHz;
#endif
#if	defined(DISPLAY_REALTIME)
	struct timeval	startTime, curTime;
#else
	clock_t	startTime, curTime, beforeTime;
#endif
	float	dclock;
	int mpegversion;
	int nEncMode;
	MERET	rval;


	/* initialize */
	if( MPGE_initializeWork() == ME_NOFPU ){
		fprintf(stderr, "%s\n", getMsg( MSG_ME_NOFPU ) );
		return ERR;
	}

	
	/* detect LANG(special case) */
	{
		t_lang lang = tLANG_UNKNOWN;
		int ac;
		char **av;
		ac = argc, av = argv;
		ac--, av++;
		while( ac ){
			if( !strcmp( *av, "-lang" ) ){
				ac--, av++;
				if( ac && !strcmp( *av, "sjis" ) ){
					lang = tLANG_JAPANESE_SJIS;
				}else
				if( ac && !strcmp( *av, "eucjp" ) ){
					lang = tLANG_JAPANESE_EUC;
				}else
				if( ac && !strcmp( *av, "eng" ) ){
					lang = tLANG_ENGLISH;
				}else
				if( ac && !strcmp( *av, "ger" ) ){
					lang = tLANG_GERMAN;
				}else
				if( ac && !strcmp( *av, "esp" ) ){
					lang = tLANG_SPANISH;
				}else
				{
					fprintf( stderr, getMsg( MSG_help33 ) );
					return ERR;
				}
			}
			ac--, av++;
		}
		/* ĂяoOInitializeĂKvA */
		MPGE_setConfigure( MC_LANG, lang, 0 );
	}

	/* opening */
	fprintf( stderr, "%s " VERSION "\n", getMsg( MSG_GOGO ) );
	fprintf( stderr, getMsg( MSG_TITLE1 ) );
	fprintf( stderr, getMsg( MSG_TITLE2 ) );

	/* print help */
	if( argc == 1 ){
		usage();
		return ERR;
	}

	/* analize options */
#if		defined(WIN32)
	MPGE_setConfigure( MC_THREAD_PRIORITY, THREAD_PRIORITY_HIGHEST, 0);
#endif
	if( getOpt(argc, argv) ){
		usage();
		MPGE_endCoder();
		return ERR;
	}

	/* if bench mark mode */
	if( testmodeFlag ){
		/* TEST : measure the time to encode 10 minutes PCM */

		struct	MCP_INPDEV_USERFUNC		userfunc;
		
		memset( &userfunc, 0, sizeof userfunc );
		userfunc.pUserFunc = enctest_inputfunc;
		userfunc.nSize     = 44100 * 2 * 2 * enc_testtime;
		userfunc.nChn      = 2;				// stereo
		userfunc.nFreq     = 44100;			// 44100Hz
		userfunc.nBit      = 16;			// 16bit PCM

		MPGE_setConfigure( MC_INPUTFILE, MC_INPDEV_USERFUNC, (UPARAM)&userfunc );
		MPGE_setConfigure( MC_OUTPUTFILE, MC_OUTDEV_USERFUNC, (UPARAM)enctest_outputfunc );

		fprintf( stderr, getMsg( MSG_BENCH ) );
	}

	/* 1wav邲ƂɕKv */

	rval = MPGE_detectConfigure();
	if( rval != ME_NOERR ){
		disp_err(  "%s\n", GetErrorMesg( rval ) );
		return ERR;
	}

	/* ݒ̕\ */

	putConfig();
	MPGE_getConfigure( MG_COUNT_FRAME, &total_frame );
	MPGE_getConfigure( MG_NUM_OF_SAMPLES, &samplesPerFrame );
	MPGE_getConfigure( MG_OUTFREQ, &freqHz );
	if( debug )put_statUNIT();

	frameNum = 0;
#if	defined(DISPLAY_REALTIME)
	gettimeofday(&startTime, NULL);
#else
	startTime = clock();
	beforeTime = startTime;
#endif
	MPGE_getConfigure( MG_MPEG_VERSION, (UPARAM *)&mpegversion );
	MPGE_getConfigure( MG_ENCODEMODE, (UPARAM *)&nEncMode );

#if	defined(__linux__) || defined(__FreeBSD__)
	if(silentFlag){
		MPGE_processTrack(&frameNum);
	}else{
		/* \̂߂CPUĝ͂ȂB
		   J[l̃XPW[0.1bƂɋNĂ炤B*/
		struct sigaction	new_sig, old_sig;

		ElapsedTime.tv_sec = ElapsedTime.tv_usec = 0;
		itimer.it_interval.tv_sec = 0;
		itimer.it_interval.tv_usec = 100000;	/* XV = 100~b */
		itimer.it_value = itimer.it_interval;
		memset(&new_sig, 0, sizeof(struct sigaction));
		new_sig.sa_handler = display_time;
		new_sig.sa_flags = SA_RESTART;
#ifdef	DISPLAY_REALTIME
		sigaction(SIGALRM, &new_sig, &old_sig);
		setitimer(ITIMER_REAL, &itimer, NULL);
#else
		sigaction(SIGVTALRM, &new_sig, &old_sig);
		setitimer(ITIMER_VIRTUAL, &itimer, NULL);
#endif

		MPGE_processTrack(&frameNum);

		itimer.it_interval.tv_sec = 0;
		itimer.it_interval.tv_usec = 0;	/* stop */
		itimer.it_value = itimer.it_interval;
#ifdef	DISPLAY_REALTIME
		setitimer(ITIMER_REAL, &itimer, NULL);
		sigaction(SIGALRM, &old_sig, NULL);
#else
		setitimer(ITIMER_VIRTUAL, &itimer, NULL);
		sigaction(SIGVTALRM, &old_sig, NULL);
#endif
	}
#else	/* defined(__linux__) || defined(__FreeBSD__) */
#if     defined ( WIN32 )
    //signal( SIGINT, CTRL_C_HANDLER);
    SetConsoleCtrlHandler( CTRL_C_HANDLER, TRUE );
#endif
	for(;;){
		if( !silentFlag ){
			while( (frameNum & 31) == 31 ){ /* RRōXVpx𒲐 */
#if	defined(DISPLAY_REALTIME)
				gettimeofday(&curTime, NULL);
				write_time(fileno(stdout), curTime.tv_sec - startTime.tv_sec,
					curTime.tv_usec - startTime.tv_usec,
					frameNum, total_frame, freqHz, samplesPerFrame);
#else
				curTime = clock();
				if( curTime - beforeTime < CLOCKS_PER_SEC / 5 )
					break;
				beforeTime = curTime;
				curTime -= startTime;
				write_time(fileno(stdout), curTime/CLOCKS_PER_SEC,
					(curTime%CLOCKS_PER_SEC)*(1000000L/CLOCKS_PER_SEC),
					frameNum, total_frame, freqHz, samplesPerFrame);
#endif
				break;
			}
			frameNum++;	
		}
#ifdef USE_BTHREAD
		/* BeOS̏ꍇAGR[hXbhƕ\Xbh̓Ɩܑ̂Ȃ̂
		    GR[hXbh炠uԂ̎sĂframeNumXbhԒʐMł炤 */
		rval = MPGE_processFrame(&frameNum);	/* }`Xbh͓frameNumς邪1Xbh̓X[ */
#else
		rval = MPGE_processFrame();
#endif
		if( rval == ME_EMPTYSTREAM )
			break;
#ifdef	USE_8HZ
		if( m_bCancel == TRUE ){
			break;
		}
#endif
		if( rval != ME_NOERR  ){
			disp_err( GetErrorMesg( rval ) );
			break;
		}
	} /* main loop */
#endif	/* defined(__linux__) || defined(__FreeBSD__) */

	MPGE_endCoder(); /* finish */

	if( deleteFlag && *szInName ){
		remove( szInName );
		if( debug ) fprintf( stderr, "%s[%s]\n", getMsg( MSG_DELETE ), szInName );
	}


#if	defined(DISPLAY_REALTIME)
	gettimeofday(&curTime, NULL);
	curTime.tv_sec -= startTime.tv_sec;
	curTime.tv_usec -= startTime.tv_usec;
	if( !silentFlag ){
		write_time(fileno(stdout), curTime.tv_sec, curTime.tv_usec,
			frameNum, total_frame, freqHz, samplesPerFrame);
	}
	dclock = (double)curTime.tv_sec + (double)curTime.tv_usec/1000000.0;
#else
	curTime = clock();
	curTime -= startTime;
	if( !silentFlag ){
		write_time(fileno(stdout), curTime/CLOCKS_PER_SEC,
			(curTime%CLOCKS_PER_SEC)*(1000000L/CLOCKS_PER_SEC),
			frameNum, total_frame, freqHz, samplesPerFrame);
	}
	dclock = (double)curTime / (double)CLOCKS_PER_SEC;
#endif
	fprintf( stderr, "%s=%8.3fsec ", getMsg( MSG_finish ), dclock );
	if( testmodeFlag ){
		fprintf( stderr, "(%6.2fx)\n", enc_testtime / dclock );
	}else{
		fprintf( stderr, "\n" );
	}
	if( debug ){
		extern int CLKcount;extern float CLKclock;
		printf("call %dtimes:ave %fclk\n",CLKcount,CLKclock/CLKcount);
		memFreeChk();
	}
	return NOERR;
}
