/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.RoleListPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.GetRolePolicyResult;
import com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListRolePoliciesResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMRoleListPoliciesDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMRoleListPoliciesDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof RoleListPoliciesRequest) {
            RoleListPoliciesRequest req = (RoleListPoliciesRequest)request;
            LOG.debug((Object)("list policies " + req));
            if (req.getPolicyName() == null) {
                LOG.debug((Object)"Listing all policies on an entity");
                ListRolePoliciesRequest listPoliciesRequest = new ListRolePoliciesRequest();
                GetRolePolicyRequest getPolicyRequest = new GetRolePolicyRequest();
                listPoliciesRequest.setRoleName(req.getRoleName());
                listPoliciesRequest.setMarker(req.getMarker());
                listPoliciesRequest.setMaxItems(req.getMaxItems());
                getPolicyRequest.setRoleName(req.getRoleName());
                LOG.debug((Object)"Listing policies");
                ListRolePoliciesResult listPoliciesResult = this.getClient().listRolePolicies(listPoliciesRequest);
                for (String policy : listPoliciesResult.getPolicyNames()) {
                    LOG.info((Object)policy);
                    if (!req.isVerbose()) continue;
                    getPolicyRequest.setPolicyName(policy);
                    LOG.debug((Object)"Getting single policy");
                    GetRolePolicyResult getPolicyResult = this.getClient().getRolePolicy(getPolicyRequest);
                    LOG.info((Object)this.urlDecodePolicy(getPolicyResult.getPolicyDocument()));
                }
                LOG.info((Object)("IsTruncated: " + listPoliciesResult.getIsTruncated()));
                if (listPoliciesResult.getIsTruncated().booleanValue()) {
                    LOG.info((Object)("Marker: " + listPoliciesResult.getMarker()));
                }
            } else {
                GetRolePolicyRequest getPolicyRequest = new GetRolePolicyRequest();
                getPolicyRequest.setPolicyName(req.getPolicyName());
                getPolicyRequest.setRoleName(req.getRoleName());
                LOG.debug((Object)"Getting single policy");
                GetRolePolicyResult getPolicyResult = this.getClient().getRolePolicy(getPolicyRequest);
                LOG.info((Object)this.urlDecodePolicy(getPolicyResult.getPolicyDocument()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

