/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.sam;

import htsjdk.samtools.MergingSamRecordIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.util.CloseableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.broadinstitute.gatk.engine.iterators.GATKSAMIterator;
import org.broadinstitute.gatk.engine.iterators.GATKSAMIteratorAdapter;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.sam.ArtificialSAMFileReader;
import org.broadinstitute.gatk.utils.sam.ArtificialSingleSampleReadStream;

public class ArtificialMultiSampleReadStream
implements Iterable<SAMRecord> {
    private Collection<ArtificialSingleSampleReadStream> perSampleArtificialReadStreams;
    private MergingSamRecordIterator mergingIterator;

    public ArtificialMultiSampleReadStream(Collection<ArtificialSingleSampleReadStream> perSampleArtificialReadStreams) {
        if (perSampleArtificialReadStreams == null || perSampleArtificialReadStreams.isEmpty()) {
            throw new ReviewedGATKException("Can't create an ArtificialMultiSampleReadStream out of 0 ArtificialSingleSampleReadStreams");
        }
        this.perSampleArtificialReadStreams = perSampleArtificialReadStreams;
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        this.initialize();
        return this.mergingIterator;
    }

    public GATKSAMIterator getGATKSAMIterator() {
        this.initialize();
        return GATKSAMIteratorAdapter.adapt((CloseableIterator)this.mergingIterator);
    }

    private void initialize() {
        ArrayList<ArtificialSAMFileReader> perSampleSAMReaders = new ArrayList<ArtificialSAMFileReader>(this.perSampleArtificialReadStreams.size());
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>(this.perSampleArtificialReadStreams.size());
        for (ArtificialSingleSampleReadStream readStream : this.perSampleArtificialReadStreams) {
            Collection<SAMRecord> thisStreamReads = readStream.makeReads();
            ArtificialSAMFileReader reader = new ArtificialSAMFileReader(readStream.getHeader(), thisStreamReads.toArray(new SAMRecord[thisStreamReads.size()]));
            perSampleSAMReaders.add(reader);
            headers.add(reader.getFileHeader());
        }
        SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, headers, true);
        this.mergingIterator = new MergingSamRecordIterator(headerMerger, perSampleSAMReaders, true);
    }
}

