/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Window;
import javax.swing.MenuElement;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.awt.AWT;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ExistingHierarchy;

public final class WindowAncestorFinder {
    private static ComponentHierarchy hierarchy = new ExistingHierarchy();

    @RunsInCurrentThread
    public static Window windowAncestorOf(Component c) {
        Component invoker;
        if (c == null) {
            return null;
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        if (c instanceof MenuElement && (invoker = AWT.invokerOf(c)) != null) {
            return WindowAncestorFinder.windowAncestorOf(invoker);
        }
        return WindowAncestorFinder.windowAncestorOf(hierarchy.parentOf(c));
    }

    private WindowAncestorFinder() {
    }
}

