/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.CRC32;

public abstract class ModuleBase
implements Module {
    protected App _app;
    protected String _coverage;
    protected Date _date;
    protected String[] _format;
    protected String _init;
    protected List _defaultParams;
    protected JhoveBase _je;
    protected String[] _mimeType;
    protected String _name;
    protected String _note;
    protected String _param;
    protected String _release;
    protected String _repInfoNote;
    protected String _rights;
    protected List _signature;
    protected List _specification;
    protected Agent _vendor;
    protected String _wellFormedNote;
    protected String _validityNote;
    protected boolean _isRandomAccess;
    protected long _nByte;
    protected CRC32 _crc32;
    protected MessageDigest _md5;
    protected MessageDigest _sha1;
    protected boolean _checksumFinished;
    protected int _verbosity;
    protected boolean _countStream;
    protected boolean _bigEndian;
    protected List _features;
    protected Logger _logger = Logger.getLogger("edu.harvard.hul.ois.jhove.module");

    protected ModuleBase(String string, String string2, int[] nArray, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        this._logger.info("Initializing " + string);
        this._name = string;
        this._release = string2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(nArray[0], nArray[1] - 1, nArray[2]);
        this._date = gregorianCalendar.getTime();
        this._format = stringArray;
        this._coverage = string3;
        this._mimeType = stringArray2;
        this._signature = new ArrayList();
        this._specification = new ArrayList();
        this._wellFormedNote = string4;
        this._repInfoNote = string6;
        this._validityNote = string5;
        this._note = string7;
        this._rights = string8;
        this._isRandomAccess = bl;
        this._verbosity = 2;
        this.initFeatures();
    }

    public void initFeatures() {
        this._features = new ArrayList(2);
        this._features.add("edu.harvard.hul.ois.jhove.canValidate");
        this._features.add("edu.harvard.hul.ois.jhove.canCharacterize");
    }

    @Override
    public void init(String string) throws Exception {
        this._init = string;
    }

    @Override
    public void setDefaultParams(List list) {
        this._defaultParams = list;
    }

    @Override
    public void applyDefaultParams() throws Exception {
        this.resetParams();
        for (String string : this._defaultParams) {
            this.param(string);
        }
    }

    @Override
    public void resetParams() throws Exception {
        this._param = null;
    }

    @Override
    public void param(String string) throws Exception {
        this._param = string;
    }

    public App getApp() {
        return this._app;
    }

    public JhoveBase getBase() {
        return this._je;
    }

    public long getNByte() {
        return this._nByte;
    }

    public boolean isBigEndian() {
        return this._bigEndian;
    }

    @Override
    public final String getCoverage() {
        return this._coverage;
    }

    @Override
    public final Date getDate() {
        return this._date;
    }

    @Override
    public final String[] getFormat() {
        return this._format;
    }

    @Override
    public final String[] getMimeType() {
        return this._mimeType;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final String getNote() {
        return this._note;
    }

    @Override
    public final String getRelease() {
        return this._release;
    }

    @Override
    public final String getRepInfoNote() {
        return this._repInfoNote;
    }

    @Override
    public final String getRights() {
        return this._rights;
    }

    @Override
    public final List getSignature() {
        return this._signature;
    }

    @Override
    public final List getSpecification() {
        return this._specification;
    }

    @Override
    public final Agent getVendor() {
        return this._vendor;
    }

    @Override
    public final String getWellFormedNote() {
        return this._wellFormedNote;
    }

    @Override
    public final String getValidityNote() {
        return this._validityNote;
    }

    @Override
    public final boolean isRandomAccess() {
        return this._isRandomAccess;
    }

    @Override
    public boolean hasFeature(String string) {
        if (this._features == null) {
            return false;
        }
        for (String string2 : this._features) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getFeatures() {
        return this._features;
    }

    @Override
    public List getDefaultParams() {
        return this._defaultParams;
    }

    @Override
    public final void setApp(App app) {
        this._app = app;
    }

    @Override
    public final void setBase(JhoveBase jhoveBase) {
        this._je = jhoveBase;
    }

    public final void setValidityNote(String string) {
        this._validityNote = string;
    }

    public final void setCRC32(CRC32 cRC32) {
        this._crc32 = cRC32;
        this._checksumFinished = true;
    }

    @Override
    public void setVerbosity(int n) {
        this._verbosity = n;
    }

    public final void setNByte(long l) {
        this._nByte = l;
        this._checksumFinished = true;
    }

    public final void setMD5(MessageDigest messageDigest) {
        this._md5 = messageDigest;
        this._checksumFinished = true;
    }

    public final void setSHA1(MessageDigest messageDigest) {
        this._sha1 = messageDigest;
        this._checksumFinished = true;
    }

    @Override
    public int parse(InputStream inputStream, RepInfo repInfo, int n) throws IOException {
        return 0;
    }

    @Override
    public void parse(RandomAccessFile randomAccessFile, RepInfo repInfo) throws IOException {
    }

    @Override
    public void checkSignatures(File file, InputStream inputStream, RepInfo repInfo) throws IOException {
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setModule(this);
        int n = 0;
        if (this._signature.size() > 0) {
            byte[] byArray = new byte[1024];
            inputStream.read(byArray);
            inputStream.close();
            ListIterator listIterator = this._signature.listIterator();
            while (listIterator.hasNext()) {
                Signature signature = (Signature)listIterator.next();
                if (!(signature instanceof InternalSignature)) continue;
                InternalSignature internalSignature = (InternalSignature)signature;
                int[] nArray = internalSignature.getValue();
                int n2 = internalSignature.getOffset();
                boolean bl = true;
                for (int i = 0; i < nArray.length; ++i) {
                    if (byArray[n2 + i] == nArray[i]) continue;
                    bl = false;
                    break;
                }
                if (!bl && internalSignature.getUse().equals(SignatureUseType.MANDATORY)) {
                    repInfo.setWellFormed(false);
                    return;
                }
                if (!bl) continue;
                ++n;
            }
        }
        if (n == 0) {
            int n3 = this.parse(inputStream, repInfo, 0);
            while (n3 != 0) {
                inputStream.close();
                inputStream = new FileInputStream(file);
                n3 = this.parse(inputStream, repInfo, n3);
            }
        } else if (repInfo.getWellFormed() == 1) {
            repInfo.setSigMatch(this._name);
        }
    }

    @Override
    public void checkSignatures(File file, RandomAccessFile randomAccessFile, RepInfo repInfo) throws IOException {
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setModule(this);
        int n = 0;
        ListIterator listIterator = this._signature.listIterator();
        try {
            while (listIterator.hasNext()) {
                Signature signature = (Signature)listIterator.next();
                if (!(signature instanceof InternalSignature)) continue;
                InternalSignature internalSignature = (InternalSignature)signature;
                randomAccessFile.seek(internalSignature.getOffset());
                int[] nArray = internalSignature.getValue();
                boolean bl = true;
                for (int i = 0; i < nArray.length; ++i) {
                    if (ModuleBase.readUnsignedByte(randomAccessFile) == nArray[i]) continue;
                    bl = false;
                    break;
                }
                if (!bl && internalSignature.getUse().equals(SignatureUseType.MANDATORY)) {
                    repInfo.setWellFormed(false);
                    break;
                }
                if (!bl) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            repInfo.setWellFormed(false);
            return;
        }
        if (n == 0) {
            repInfo.setWellFormed(false);
        } else if (repInfo.getWellFormed() == 1) {
            repInfo.setSigMatch(this._name);
        }
    }

    protected void initParse() {
        this._logger.info(this._name + " called initParse");
        this._checksumFinished = false;
        this._nByte = 0L;
        this._crc32 = new CRC32();
        try {
            this._md5 = MessageDigest.getInstance("MD5");
            this._sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    protected void calcRAChecksum(Checksummer checksummer, RandomAccessFile randomAccessFile) throws IOException {
        if (checksummer == null) {
            return;
        }
        randomAccessFile.seek(0L);
        byte[] byArray = new byte[this._je.getBufferSize()];
        int n = -1;
        try {
            while ((n = randomAccessFile.read(byArray)) != -1) {
                if (n <= 0) continue;
                checksummer.update(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setChecksums(Checksummer checksummer, RepInfo repInfo) {
        if (checksummer != null) {
            repInfo.setChecksum(new Checksum(checksummer.getCRC32(), ChecksumType.CRC32));
            String string = checksummer.getMD5();
            if (string != null) {
                repInfo.setChecksum(new Checksum(string, ChecksumType.MD5));
            }
            if ((string = checksummer.getSHA1()) != null) {
                repInfo.setChecksum(new Checksum(string, ChecksumType.SHA1));
            }
        }
    }

    @Override
    public void show(OutputHandler outputHandler) {
        outputHandler.show(this);
    }

    protected String getCRC32() {
        return Long.toHexString(this._crc32.getValue());
    }

    public Property addIntegerProperty(String string, int n, String[] stringArray, int[] nArray) {
        boolean bl = this._je.getShowRawFlag();
        Property property = null;
        if (!bl) {
            int n2 = -1;
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                n2 = i;
                break;
            }
            if (n2 > -1) {
                property = new Property(string, PropertyType.STRING, stringArray[n2]);
            }
        }
        if (property == null) {
            property = new Property(string, PropertyType.INTEGER, new Integer(n));
        }
        return property;
    }

    public Property addIntegerProperty(String string, int n, String[] stringArray) {
        if (!this._je.getShowRawFlag()) {
            try {
                return new Property(string, PropertyType.STRING, stringArray[n]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Property(string, PropertyType.INTEGER, new Integer(n));
    }

    public static int readUnsignedByte(DataInputStream dataInputStream) throws IOException {
        return ModuleBase.readUnsignedByte(dataInputStream, null);
    }

    public static int readUnsignedByte(DataInputStream dataInputStream, ModuleBase moduleBase) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        if (moduleBase != null) {
            ++moduleBase._nByte;
        }
        return n;
    }

    public static int readUnsignedByte(RandomAccessFile randomAccessFile) throws IOException {
        return randomAccessFile.readUnsignedByte();
    }

    public static int readByteBuf(DataInputStream dataInputStream, byte[] byArray, ModuleBase moduleBase) throws IOException {
        int n = dataInputStream.read(byArray);
        if (moduleBase != null && n > 0) {
            moduleBase._nByte += (long)n;
        }
        return n;
    }

    public static int readUnsignedShort(DataInputStream dataInputStream, boolean bl) throws IOException {
        return ModuleBase.readUnsignedShort(dataInputStream, bl, null);
    }

    public static int readUnsignedShort(DataInputStream dataInputStream, boolean bl, ModuleBase moduleBase) throws IOException {
        int n = 0;
        if (bl) {
            n = dataInputStream.readUnsignedShort();
        } else {
            int n2 = dataInputStream.readUnsignedByte();
            int n3 = dataInputStream.readUnsignedByte();
            n = n3 << 8 | n2;
        }
        if (moduleBase != null) {
            moduleBase._nByte += 2L;
        }
        return n;
    }

    public static int readUnsignedShort(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        int n = 0;
        if (bl) {
            n = randomAccessFile.readUnsignedShort();
        } else {
            int n2 = randomAccessFile.readUnsignedByte();
            int n3 = randomAccessFile.readUnsignedByte();
            n = n3 << 8 | n2;
        }
        return n;
    }

    public static long readUnsignedInt(DataInputStream dataInputStream, boolean bl) throws IOException {
        return ModuleBase.readUnsignedInt(dataInputStream, bl, null);
    }

    public static long readUnsignedInt(DataInputStream dataInputStream, boolean bl, ModuleBase moduleBase) throws IOException {
        long l = 0L;
        if (bl) {
            l = dataInputStream.readInt();
            if (l < 0L) {
                l &= 0xFFFFFFFFL;
            }
        } else {
            long l2 = dataInputStream.readUnsignedByte();
            long l3 = dataInputStream.readUnsignedByte();
            long l4 = dataInputStream.readUnsignedByte();
            long l5 = dataInputStream.readUnsignedByte();
            l = l5 << 24 | l4 << 16 | l3 << 8 | l2;
        }
        if (moduleBase != null) {
            moduleBase._nByte += 4L;
        }
        return l;
    }

    public static long readUnsignedInt(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        long l = 0L;
        if (bl) {
            l = randomAccessFile.readInt();
            if (l < 0L) {
                l &= 0xFFFFFFFFL;
            }
        } else {
            byte[] byArray = new byte[4];
            randomAccessFile.read(byArray);
            long l2 = (long)byArray[0] & 0xFFL;
            long l3 = (long)byArray[1] & 0xFFL;
            long l4 = (long)byArray[2] & 0xFFL;
            long l5 = (long)byArray[3] & 0xFFL;
            l = l5 << 24 | l4 << 16 | l3 << 8 | l2;
        }
        return l;
    }

    public static long readSignedLong(DataInputStream dataInputStream, boolean bl, ModuleBase moduleBase) throws IOException {
        long l = 0L;
        if (bl) {
            l = dataInputStream.readLong();
        } else {
            long l2 = dataInputStream.readUnsignedByte();
            long l3 = dataInputStream.readUnsignedByte();
            long l4 = dataInputStream.readUnsignedByte();
            long l5 = dataInputStream.readUnsignedByte();
            long l6 = dataInputStream.readUnsignedByte();
            long l7 = dataInputStream.readUnsignedByte();
            long l8 = dataInputStream.readUnsignedByte();
            long l9 = dataInputStream.readUnsignedByte();
            l = l9 << 56 | l8 << 48 | l7 << 40 | l6 << 32 | l5 << 24 | l4 << 16 | l3 << 8 | l2;
        }
        if (moduleBase != null) {
            moduleBase._nByte += 8L;
        }
        return l;
    }

    public static Rational readUnsignedRational(DataInputStream dataInputStream, boolean bl) throws IOException {
        return ModuleBase.readUnsignedRational(dataInputStream, bl, null);
    }

    public static Rational readUnsignedRational(DataInputStream dataInputStream, boolean bl, ModuleBase moduleBase) throws IOException {
        long l = ModuleBase.readUnsignedInt(dataInputStream, bl, moduleBase);
        long l2 = ModuleBase.readUnsignedInt(dataInputStream, bl, moduleBase);
        return new Rational(l, l2);
    }

    public static Rational readUnsignedRational(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        long l = ModuleBase.readUnsignedInt(randomAccessFile, bl);
        long l2 = ModuleBase.readUnsignedInt(randomAccessFile, bl);
        return new Rational(l, l2);
    }

    public static Rational readSignedRational(DataInputStream dataInputStream, boolean bl, ModuleBase moduleBase) throws IOException {
        long l = ModuleBase.readSignedInt(dataInputStream, bl, moduleBase);
        long l2 = ModuleBase.readSignedInt(dataInputStream, bl, moduleBase);
        return new Rational(l, l2);
    }

    public static Rational readSignedRational(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        long l = ModuleBase.readSignedInt(randomAccessFile, bl);
        long l2 = ModuleBase.readSignedInt(randomAccessFile, bl);
        return new Rational(l, l2);
    }

    public static int readSignedByte(RandomAccessFile randomAccessFile) throws IOException {
        return randomAccessFile.readByte();
    }

    public static int readSignedShort(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        int n = ModuleBase.readUnsignedShort(randomAccessFile, bl);
        if ((n & 0x8000) != 0) {
            n |= 0xFFFF0000;
        }
        return n;
    }

    public static int readSignedInt(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        long l = ModuleBase.readUnsignedInt(randomAccessFile, bl);
        if ((l & 0x80000000L) != 0L) {
            l |= 0xFFFFFFFF00000000L;
        }
        return (int)l;
    }

    public static int readSignedByte(DataInputStream dataInputStream) throws IOException {
        return ModuleBase.readSignedByte(dataInputStream, null);
    }

    public static int readSignedByte(DataInputStream dataInputStream, ModuleBase moduleBase) throws IOException {
        byte by = dataInputStream.readByte();
        if (moduleBase != null) {
            ++moduleBase._nByte;
        }
        return by;
    }

    public static int readSignedShort(DataInputStream dataInputStream, boolean bl) throws IOException {
        return ModuleBase.readSignedShort(dataInputStream, bl, null);
    }

    public static int readSignedShort(DataInputStream dataInputStream, boolean bl, ModuleBase moduleBase) throws IOException {
        int n = ModuleBase.readUnsignedShort(dataInputStream, bl, moduleBase);
        if ((n & 0x8000) != 0) {
            n |= 0xFFFF0000;
        }
        return n;
    }

    public static int readSignedInt(DataInputStream dataInputStream, boolean bl) throws IOException {
        return ModuleBase.readSignedInt(dataInputStream, bl, null);
    }

    public static int readSignedInt(DataInputStream dataInputStream, boolean bl, ModuleBase moduleBase) throws IOException {
        long l = ModuleBase.readUnsignedInt(dataInputStream, bl, moduleBase);
        if ((l & 0x80000000L) != 0L) {
            l |= 0xFFFFFFFF00000000L;
        }
        return (int)l;
    }

    public static float readFloat(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        float f = 0.0f;
        if (bl) {
            f = randomAccessFile.readFloat();
        } else {
            byte[] byArray = new byte[4];
            randomAccessFile.read(byArray);
            int n = byArray[0] & 0xFF;
            int n2 = byArray[1] & 0xFF;
            int n3 = byArray[2] & 0xFF;
            int n4 = byArray[3] & 0xFF;
            f = Float.intBitsToFloat(n4 << 24 | n3 << 16 | n2 << 8 | n);
        }
        return f;
    }

    public static float readFloat(DataInputStream dataInputStream, boolean bl, ModuleBase moduleBase) throws IOException {
        float f = 0.0f;
        if (bl) {
            f = dataInputStream.readFloat();
        } else {
            int n = dataInputStream.readUnsignedByte();
            int n2 = dataInputStream.readUnsignedByte();
            int n3 = dataInputStream.readUnsignedByte();
            int n4 = dataInputStream.readUnsignedByte();
            f = Float.intBitsToFloat(n4 << 24 | n3 << 16 | n2 << 8 | n);
        }
        if (moduleBase != null) {
            moduleBase._nByte += 4L;
        }
        return f;
    }

    public static double readDouble(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        double d = 0.0;
        if (bl) {
            d = randomAccessFile.readDouble();
        } else {
            byte[] byArray = new byte[8];
            randomAccessFile.read(byArray);
            long l = (long)byArray[0] & 0xFFL;
            long l2 = (long)byArray[1] & 0xFFL;
            long l3 = (long)byArray[2] & 0xFFL;
            long l4 = (long)byArray[3] & 0xFFL;
            long l5 = (long)byArray[4] & 0xFFL;
            long l6 = (long)byArray[5] & 0xFFL;
            long l7 = (long)byArray[6] & 0xFFL;
            long l8 = (long)byArray[7] & 0xFFL;
            d = Double.longBitsToDouble(l8 << 56 | l7 << 48 | l6 << 40 | l5 << 32 | l4 << 24 | l3 << 16 | l2 << 8 | l);
        }
        return d;
    }

    public static double readDouble(DataInputStream dataInputStream, boolean bl) throws IOException {
        return ModuleBase.readDouble(dataInputStream, bl, null);
    }

    public static double readDouble(DataInputStream dataInputStream, boolean bl, ModuleBase moduleBase) throws IOException {
        double d = 0.0;
        if (bl) {
            d = dataInputStream.readDouble();
        } else {
            long l = dataInputStream.readUnsignedByte();
            long l2 = dataInputStream.readUnsignedByte();
            long l3 = dataInputStream.readUnsignedByte();
            long l4 = dataInputStream.readUnsignedByte();
            long l5 = dataInputStream.readUnsignedByte();
            long l6 = dataInputStream.readUnsignedByte();
            long l7 = dataInputStream.readUnsignedByte();
            long l8 = dataInputStream.readUnsignedByte();
            d = Double.longBitsToDouble(l8 << 56 | l7 << 48 | l6 << 40 | l5 << 32 | l4 << 24 | l3 << 16 | l2 << 8 | l);
        }
        if (moduleBase != null) {
            moduleBase._nByte += 8L;
        }
        return d;
    }

    public int skipBytes(DataInputStream dataInputStream, int n) throws IOException {
        return this.skipBytes(dataInputStream, n, null);
    }

    public int skipBytes(DataInputStream dataInputStream, int n, ModuleBase moduleBase) throws IOException {
        int n2 = dataInputStream.skipBytes(n);
        if (moduleBase != null) {
            moduleBase._nByte += (long)n2;
        }
        return n2;
    }

    public static DataInputStream getBufferedDataStream(InputStream inputStream, int n) {
        BufferedInputStream bufferedInputStream = n <= 0 ? new BufferedInputStream(inputStream) : new BufferedInputStream(inputStream, n);
        return new DataInputStream(bufferedInputStream);
    }

    protected Property[] vectorToPropArray(Vector vector) {
        Property[] propertyArray = new Property[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            propertyArray[i] = (Property)vector.elementAt(i);
        }
        return propertyArray;
    }
}

