#!/bin/bash

################################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_AssociatedProcessorCacheMemory.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_AssociatedProcessorCacheMemory provider module";
Name = "CPU_OpenDRIM_AssociatedProcessorCacheMemoryModule";
Location = "cmpiCPU_OpenDRIM_AssociatedProcessorCacheMemoryProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_AssociatedProcessorCacheMemory provider";
Name = "CPU_OpenDRIM_AssociatedProcessorCacheMemoryProvider";
ProviderModuleName = "CPU_OpenDRIM_AssociatedProcessorCacheMemoryModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_AssociatedProcessorCacheMemory provider capabilities";
ProviderModuleName = "CPU_OpenDRIM_AssociatedProcessorCacheMemoryModule";
ProviderName = "CPU_OpenDRIM_AssociatedProcessorCacheMemoryProvider";
ClassName = "OpenDRIM_AssociatedProcessorCacheMemory";
ProviderType = {2, 3};
Namespaces = {"$1"};
SupportedProperties = {"Antecedent", "Dependent", "Level", "OtherLevelDescription", "WritePolicy", "OtherWritePolicyDescription", "CacheType", "OtherCacheTypeDescription", "LineSize", "ReplacementPolicy", "OtherReplacementPolicyDescription", "ReadPolicy", "OtherReadPolicyDescription", "FlushTimer", "Associativity", "OtherAssociativityDescription"};
CapabilityID = "CPU_OpenDRIM_AssociatedProcessorCacheMemory";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_AssociatedProcessorCacheMemory.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_AssociatedProcessorCacheMemory]   
   provider: CPU_OpenDRIM_AssociatedProcessorCacheMemoryProvider
   location: cmpiCPU_OpenDRIM_AssociatedProcessorCacheMemoryProvider
   type: instance association
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_AssociatedProcessorCacheMemory.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_AssociatedProcessorCacheMemory-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_AssociatedProcessorCacheMemory.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
