#!/bin/sh
set -o errexit

###
# Copyright (c) 2015-2021, Antoine Le Gonidec <vv221@dotslashplay.it>
# Copyright (c) 2016-2021, Mopi
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Goetia
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20210815.3

# Set game-specific variables

GAME_ID='goetia'
GAME_NAME='Goetia'

ARCHIVE_BASE_0='goetia_en_gog_1_18328.sh'
ARCHIVE_BASE_0_MD5='13d620c4b7426cb755cba43d68cbbb1e'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='7000000'
ARCHIVE_BASE_0_VERSION='1.0-gog18328'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/goetia'

ARCHIVE_GAME_BIN32_PATH='data/noarch/game'
ARCHIVE_GAME_BIN32_FILES='
Goetia.x86
Goetia_Data/Mono/x86
Goetia_Data/Plugins/x86'

ARCHIVE_GAME_BIN64_PATH='data/noarch/game'
ARCHIVE_GAME_BIN64_FILES='
Goetia.x86_64
Goetia_Data/Mono/x86_64
Goetia_Data/Plugins/x86_64'

ARCHIVE_GAME_DATA_PATH='data/noarch/game'
ARCHIVE_GAME_DATA_FILES='
Goetia_Data'

APP_MAIN_TYPE='native'
APP_MAIN_EXE_BIN32='Goetia.x86'
APP_MAIN_EXE_BIN64='Goetia.x86_64'
APP_MAIN_ICON='Goetia_Data/Resources/UnityPlayer.png'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID glibc libstdc++ glx xcursor libxrandr gtk2 libX11.so.6 libgdk_pixbuf-2.0.so.0 libgobject-2.0.so.0 libglib-2.0.so.0"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Start pulseaudio if it is available

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Start pulseaudio if it is available
pulseaudio_is_available() {
	command -v pulseaudio >/dev/null 2>&1
}
if pulseaudio_is_available; then
	if ! pulseaudio --check; then
		touch .stop_pulseaudio_on_exit
	fi
	pulseaudio --start
fi'

# Work around crash on launch related to libpulse
# Some Unity3D games crash on launch if libpulse-simple.so.0 is available but pulseaudio is not running

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Work around crash on launch related to libpulse
# Some Unity3D games crash on launch if libpulse-simple.so.0 is available but pulseaudio is not running
LIBPULSE_NULL_LINK="${APP_LIBS:=libs}/libpulse-simple.so.0"
if pulseaudio_is_available; then
	rm --force "$LIBPULSE_NULL_LINK"
else
	mkdir --parents "$(dirname "$LIBPULSE_NULL_LINK")"
	ln --force --symbolic /dev/null "$LIBPULSE_NULL_LINK"
fi'

# Use a dedicated log file for the current game session

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Use a dedicated log file for the current game session
mkdir --parents logs
APP_OPTIONS="${APP_OPTIONS} -logFile ./logs/$(date +%F-%R).log"'

# Stop pulseaudio if it has been started for this game session

APP_MAIN_POSTRUN="$APP_MAIN_POSTRUN"'

# Stop pulseaudio if it has been started for this game session
if [ -e .stop_pulseaudio_on_exit ]; then
	pulseaudio --kill
	rm .stop_pulseaudio_on_exit
fi'

# Load common functions

target_version='2.13'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "${path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write 'APP_MAIN'
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
