/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

/**
 * Retrieves crafts types models from the data base and implements their basic
 * behavior by setting call-back functions (engine, resupply, ...).
 * 
 * @file
 */

#ifndef _planes_h
#define _planes_h

#include "pm.h"

#ifdef planes_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Returns the thrust engine function specific for the specified aircraft.
 * This module contains specific functions that simulates the performances
 * of several types of engines; its one of these functions that gets returned.
 * @param cinfo Specific craft informations.
 * @return Engine RPM update and thrust calculator function.
 */
EXTERN inventory_ThrustCalculator * planes_getThrustCalculator(craftType * cinfo);

/**
 * Fuel resupply +10% max fuel load, weapon resupply and damage repair.
 * This function should be called once for any new aircraft, then every 30 s
 * while on ground.
 * If drone, set fuel quantity to half the capacity.
 * FIXME: fuel resupply of aircraft commented out as it can be set by user.
 * @param c
 */
EXTERN void   planes_genericResupply(craft * c);

/**
 * Call-back function for the alarm module.
 * Scans for all the players aircraft; if a player is on the airport
 * grounds and motionless, then invoke the plane's resupply procedure.
 */
EXTERN void planes_doResupply(void *dummy1, void *dummy2);

/**
 * Returns the fuel consumed in the last deltaT interval.
 * @param c
 * @return Fuel consumed in the last deltaT interval (lb).
 */
EXTERN double planes_fuelUsed( craft * c );

/**
 * Allocates a new plane in the ptbl[] table.
 * @param planeType Name of the plane, for ex. "C-172".
 * @return Index of the new plane in the ptbl[] table. If negative: -1 == table
 * full; -2 == unknown plane name.
 */
EXTERN int  planes_newPlane(char *planeType);

#undef EXTERN
#endif
