/*
 *       File name:  aghermann/ui/sf/d/rk1968.cc
 *         Project:  Aghermann
 *          Author:  Andrei Zavada <johnhommer@gmail.com>
 * Initial version:  2013-01-25
 *
 *         Purpose:  scoring facility: rk1968 dialog
 *
 *         License:  GPL
 */

#include "rk1968.hh"

using namespace std;
using namespace agh::ui;

SScoringFacility::SRK1968Dialog&
SScoringFacility::
rk1968_d()
{
        if ( !_rk1968_d )
                _rk1968_d = new SRK1968Dialog(*this);
        return *_rk1968_d;
}


SScoringFacility::SRK1968Dialog::
SRK1968Dialog (SScoringFacility& p_)
      : SDirlevelStorableAdapter<agh::rk1968::CScoreAssistant>(
              *p_._p.ED, agh::SExpDirLevelId {p_._p.ED->group_of(p_.csubject()), p_.csubject().id, p_.session()},
              mSFRKProfiles, eSFRKProfileList, eSFRKProfileList_changed_cb_handler_id,
              bSFRKProfileSave, bSFRKProfileRevert, bSFRKProfileDiscard,
              wSFRKProfileSave, eSFRKProfileSaveName,
              eSFRKProfileSaveOriginSubject, eSFRKProfileSaveOriginExperiment, eSFRKProfileSaveOriginUser,
              bSFRKProfileSaveOK),
        suppress_preview_handler (false),
        _p (p_)
{
      // 1. widgets
        builder = gtk_builder_new();
        if ( !gtk_builder_add_from_resource( builder, "/org/gtk/aghermann/sf-rk1968.glade", NULL) )
                throw runtime_error( "Failed to load SF::rk1968 glade resource");
        gtk_builder_connect_signals( builder, NULL);

        AGH_GBGETOBJ (wSFRK);
        AGH_GBGETOBJ (bSFRKProfileRevert);
        AGH_GBGETOBJ (bSFRKProfileSave);
        AGH_GBGETOBJ (bSFRKProfileDiscard);
        AGH_GBGETOBJ (eSFRKProfileList);

        AGH_GBGETOBJ (eSFRKScript);
        AGH_GBGETOBJ (tSFRKScript);

        AGH_GBGETOBJ (lSFRKTopInfo);
        AGH_GBGETOBJ (lSFRKBottomInfo);
        AGH_GBGETOBJ (bSFRKPreview);
        AGH_GBGETOBJ (bSFRKApply);
        AGH_GBGETOBJ (bSFRKDismiss);
        AGH_GBGETOBJ (wSFRKProfileSave);
        AGH_GBGETOBJ (eSFRKProfileSaveName);
        AGH_GBGETOBJ (eSFRKProfileSaveOriginSubject);
        AGH_GBGETOBJ (eSFRKProfileSaveOriginExperiment);
        AGH_GBGETOBJ (eSFRKProfileSaveOriginUser);
        AGH_GBGETOBJ (bSFRKProfileSaveOK);

        mSFRKProfiles =
                gtk_list_store_new( 1, G_TYPE_STRING);
        gtk_combo_box_set_model_properly(
                eSFRKProfileList, mSFRKProfiles);

        {
                auto font_desc = pango_font_description_from_string( "Mono 10");
                gtk_widget_override_font( (GtkWidget*)eSFRKScript, font_desc);
                pango_font_description_free( font_desc);
        }

        G_CONNECT_1 (wSFRK, show);
        G_CONNECT_1 (wSFRK, hide);

        eSFRKProfileList_changed_cb_handler_id =
                G_CONNECT_1 (eSFRKProfileList, changed);
        G_CONNECT_1 (bSFRKProfileSave,    clicked);
        G_CONNECT_1 (bSFRKProfileRevert,  clicked);
        G_CONNECT_1 (bSFRKProfileDiscard, clicked);

        for ( auto& W : {tSFRKScript} )
                g_signal_connect(
                        W, "changed",
                        (GCallback)eSFRK_any_profile_value_changed_cb,
                        this);

        G_CONNECT_1 (bSFRKPreview, toggled);
        G_CONNECT_1 (bSFRKApply,   clicked);
        G_CONNECT_1 (bSFRKDismiss, clicked);

        G_CONNECT_1 (eSFRKProfileSaveName, changed);

        for ( auto& W : {eSFRKProfileSaveOriginUser, eSFRKProfileSaveOriginExperiment, eSFRKProfileSaveOriginSubject} )
                g_signal_connect(
                        W, "toggled",
                        (GCallback)eSFRK_any_profile_origin_toggled_cb,
                        this);

      // 2. dialog
        W_V.reg( tSFRKScript, &Pp2.script_contents);
}

SScoringFacility::SRK1968Dialog::
~SRK1968Dialog ()
{
        gtk_widget_destroy( (GtkWidget*)wSFRK);
        g_object_unref( (GObject*)mSFRKProfiles);
        g_object_unref( (GObject*)builder);
}



// Local Variables:
// Mode: c++
// indent-tabs-mode: nil
// tab-width: 8
// c-basic-offset: 8
// End:
