var NAVTREE =
[
  [ "AllegroGL", "index.html", [
    [ "AllegroGL", "index.html", null ],
    [ "Related Pages", "pages.html", [
      [ "Deprecated List", "deprecated.html", null ]
    ] ],
    [ "Modules", "modules.html", [
      [ "Version information", "group__version.html", null ],
      [ "Core routines", "group__core.html", [
        [ "Defines", "group__core.html", [
          [ "allegro_gl_begin", "group__core.html#ga59b02f9584f81789449a7fcc2018bfc5", null ],
          [ "allegro_gl_end", "group__core.html#gac1303e0363f3adfc33c8812e9b8e30b0", null ]
        ] ],
        [ "Functions", "group__core.html", [
          [ "install_allegro_gl", "group__core.html#gaa0cbb82fa1e2bae6788eb7bd06673bd3", null ],
          [ "remove_allegro_gl", "group__core.html#gaeff6abbb1d1071a01f4cd694ef504298", null ],
          [ "allegro_gl_flip", "group__core.html#gaf5aad043e99b766393fa4a7ec034a0f1", null ],
          [ "allegro_gl_opengl_version", "group__core.html#ga444d507eaeb5ba800787f6a81827615d", null ]
        ] ]
      ] ],
      [ "Graphics drivers", "group__gfxdrv.html", null ],
      [ "Bitmap Routines", "group__bitmap.html", [
        [ "Functions", "group__bitmap.html", [
          [ "allegro_gl_set_video_bitmap_color_depth", "group__bitmap.html#ga92d58cf7b4bebf34aa27112efba1020e", null ]
        ] ]
      ] ],
      [ "Texture Routines", "group__texture.html", [
        [ "Defines", "group__texture.html", [
          [ "AGL_TEXTURE_FLIP", "group__texture.html#gadeffe4feb290278035beacedb284a010", null ],
          [ "AGL_TEXTURE_MASKED", "group__texture.html#gaba184d573c65f33b35d1d57936607d08", null ],
          [ "AGL_TEXTURE_RESCALE", "group__texture.html#gaa8b7246edc7ec019ec3b434eb0cacdf2", null ]
        ] ],
        [ "Functions", "group__texture.html", [
          [ "allegro_gl_use_mipmapping", "group__texture.html#gab5393ecc10a2a31da7eb80c889af89ac", null ],
          [ "allegro_gl_use_alpha_channel", "group__texture.html#ga1d88f4ebc7ed1ecd65640b72ea46a71e", null ],
          [ "allegro_gl_flip_texture", "group__texture.html#ga3ec0a1c4c6656f13c8398bab7a1293f2", null ],
          [ "allegro_gl_check_texture", "group__texture.html#ga6996c14538e18b1614f91d34b2d4d691", null ],
          [ "allegro_gl_check_texture_ex", "group__texture.html#gab0cf4dc0ddcb45f5b067d08aed1c88e6", null ],
          [ "allegro_gl_get_texture_format", "group__texture.html#ga2392fe7a8dd6db65532160821804aa68", null ],
          [ "allegro_gl_set_texture_format", "group__texture.html#ga5d535e8af776dd449cc4755b9e3585b1", null ],
          [ "allegro_gl_make_texture", "group__texture.html#gae071354f76bc28e1bafbd90bdecbc0c9", null ],
          [ "allegro_gl_make_masked_texture", "group__texture.html#gaeb33dfbbc1725f5132c10ac32ef6800d", null ],
          [ "allegro_gl_make_texture_ex", "group__texture.html#gaf3a48c555068e7051171255c1011150a", null ]
        ] ]
      ] ],
      [ "Math conversion routines", "group__math.html", [
        [ "Functions", "group__math.html", [
          [ "allegro_gl_MATRIX_to_GLfloat", "group__math.html#ga4cf4f453cb3f95a1e7e861a7401b4a8d", null ],
          [ "allegro_gl_MATRIX_to_GLdouble", "group__math.html#gaee6cb48f8e3e70abecc6c282a8ea1edc", null ],
          [ "allegro_gl_MATRIX_f_to_GLfloat", "group__math.html#gae8e0ee18b9aeca955402be16de6ca79d", null ],
          [ "allegro_gl_MATRIX_f_to_GLdouble", "group__math.html#gab93f3588ea08b048f418023aa76cb3fc", null ],
          [ "allegro_gl_GLfloat_to_MATRIX", "group__math.html#ga468e83ca4de52ed839978d48f5dbe111", null ],
          [ "allegro_gl_GLdouble_to_MATRIX", "group__math.html#ga68e2e0e9dcdba42004070a5f8f547994", null ],
          [ "allegro_gl_GLfloat_to_MATRIX_f", "group__math.html#ga08692466ae37d7888bbd5f5ee5aa9268", null ],
          [ "allegro_gl_GLdouble_to_MATRIX_f", "group__math.html#gaa6b729a9e93e249a8a76e078e94a2b44", null ]
        ] ]
      ] ],
      [ "Text drawing and fonts.", "group__Text.html", [
        [ "Defines", "group__Text.html", [
          [ "AGL_FONT_TYPE_DONT_CARE", "group__Text.html#gad2ebae17d2548a5befb888f8618f2206", null ],
          [ "AGL_FONT_TYPE_BITMAP", "group__Text.html#ga7ed8fdc1b0065d2fe584b15d69108b1a", null ],
          [ "AGL_FONT_TYPE_OUTLINE", "group__Text.html#gaba7b8c941356029687ff4b4340e8b841", null ],
          [ "AGL_FONT_TYPE_TEXTURED", "group__Text.html#ga92bf039bc7b06568273ee17f15cf6671", null ],
          [ "AGL_FONT_STYLE_BOLD", "group__Text.html#gab77d7d2c6ec6d1786472943f7cd814ca", null ],
          [ "AGL_FONT_STYLE_BLACK", "group__Text.html#ga27874c1fb7fdc1e00115bd853c973fc3", null ],
          [ "AGL_FONT_STYLE_ITALIC", "group__Text.html#ga67c48bf08c2b6cd6cc1a08dec2c7c5ef", null ],
          [ "AGL_FONT_STYLE_UNDERLINE", "group__Text.html#gae9e4682339d264429ee601c632231c9f", null ],
          [ "AGL_FONT_STYLE_STRIKEOUT", "group__Text.html#ga6ba31b9c7866d28b5494fad2577569db", null ],
          [ "AGL_FONT_STYLE_ANTI_ALIASED", "group__Text.html#ga91cc859278878dd4bf200bed7eab4359", null ],
          [ "AGL_FONT_POLYGONS", "group__Text.html#ga4b45ef558e7934ceaaff146f450ab23f", null ],
          [ "AGL_FONT_LINES", "group__Text.html#ga0b426eb30e7203eb094a7adfbb04cb6d", null ]
        ] ],
        [ "Functions", "group__Text.html", [
          [ "allegro_gl_printf", "group__Text.html#ga84ecf6d5f5b363d7715e15eca8ebafeb", null ],
          [ "allegro_gl_printf_ex", "group__Text.html#gab93317445f8a566f8b5632e04fbf8e5b", null ],
          [ "allegro_gl_convert_allegro_font", "group__Text.html#gad01388c5188ae09628284aa2425acae9", null ],
          [ "allegro_gl_convert_allegro_font_ex", "group__Text.html#ga4986ec80f1a3362e47f7669461fef414", null ],
          [ "allegro_gl_set_font_generation_mode", "group__Text.html#ga62e79ccec5062f1cdadbc225319e9b44", null ],
          [ "allegro_gl_load_system_font", "group__Text.html#ga5bddcc6c1954665140083928117519de", null ],
          [ "allegro_gl_load_system_font_ex", "group__Text.html#ga4ad68c54b0183c60cdbf2c7a02dc3157", null ],
          [ "allegro_gl_destroy_font", "group__Text.html#gabcbdd9810f7254cdb105f987ae1e557f", null ],
          [ "allegro_gl_list_font_textures", "group__Text.html#ga70b78c3a523dc9977c222d466edc6a5a", null ]
        ] ]
      ] ],
      [ "OpenGL Extensions", "group__extensions.html", [
        [ "Defines", "group__extensions.html", [
          [ "AGL_DEFINE_PROC_TYPE", "group__extensions.html#gac45f9222ac965c8d0d756f513cebf0d1", null ]
        ] ],
        [ "Functions", "group__extensions.html", [
          [ "allegro_gl_is_extension_supported", "group__extensions.html#ga7351f56ea1c4f4665193fc3bf547ff0a", null ],
          [ "allegro_gl_get_proc_address", "group__extensions.html#gaa0c2cd7c4b4a94e8801af42a58356cc4", null ]
        ] ],
        [ "Variables", "group__extensions.html", [
          [ "allegro_gl_extensions_GL", "group__extensions.html#ga7492f6f6acc608789210560ee63e5436", null ],
          [ "agl_extension_table", "group__extensions.html#ga2d6ebb26eec58470e4242b750656268b", null ]
        ] ]
      ] ],
      [ "Allegro-compatible GUI routines", "group__gui.html", [
        [ "Functions", "group__gui.html", [
          [ "algl_do_dialog", "group__gui.html#ga30c12b20a701f84f994ebcbea14afc99", null ],
          [ "algl_popup_dialog", "group__gui.html#ga4c6641a5fe463ca062b90bcc3bb5677d", null ],
          [ "algl_draw_mouse", "group__gui.html#ga4418d38b8585ab443ba7f41a476765c6", null ],
          [ "algl_set_mouse_drawer", "group__gui.html#ga428394c0ae4d4a1e96fe2b27fb13f745", null ],
          [ "algl_alert", "group__gui.html#gad6be783b911635769fcb54d188a77107", null ],
          [ "algl_alert3", "group__gui.html#gadc8b61d7a682b7be11f0f1cc864b30be", null ],
          [ "d_algl_viewport_proc", "group__gui.html#gae41d96ae1ebefffdf60391e632915fd3", null ]
        ] ]
      ] ],
      [ "Allegro Graphics Driver", "group__glvtable.html", [
        [ "Defines", "group__glvtable.html", [
          [ "SET_TEX_COORDS", "group__glvtable.html#ga397c41b7c07794b6edce960693361a83", null ]
        ] ],
        [ "Functions", "group__glvtable.html", [
          [ "allegro_gl_screen_acquire", "group__glvtable.html#ga702812e50246c61eb9f01fd8aba69325", null ],
          [ "allegro_gl_screen_release", "group__glvtable.html#ga6c2b0685587a0feafcb194a9a67d6aa9", null ],
          [ "allegro_gl_video_acquire", "group__glvtable.html#ga7002daa2a3e02adf79bed09039469595", null ],
          [ "allegro_gl_video_release", "group__glvtable.html#ga6fe7f8e5d64ab6b6e85643adefe8b0d5", null ]
        ] ]
      ] ],
      [ "Option settings", "group__settings.html", [
        [ "Defines", "group__settings.html", [
          [ "AGL_ALLEGRO_FORMAT", "group__settings.html#gab34e1290cbeb5fe252642f3bd59f0a52", null ],
          [ "AGL_RED_DEPTH", "group__settings.html#gabe75eb7c907fedeef4763ad6c3ffd8f0", null ],
          [ "AGL_GREEN_DEPTH", "group__settings.html#gada8f8e9bb4e0ccf1bf7f7353d1e6032d", null ],
          [ "AGL_BLUE_DEPTH", "group__settings.html#ga8efacc076a3d6523dd989211833c1ca8", null ],
          [ "AGL_ALPHA_DEPTH", "group__settings.html#gad37b2a655ca53a34bb41bc629c8aa51e", null ],
          [ "AGL_COLOR_DEPTH", "group__settings.html#ga71846e567336fe02f8f063af1282ddc5", null ],
          [ "AGL_ACC_RED_DEPTH", "group__settings.html#ga317622005a4a2956a0d1659d3c47822a", null ],
          [ "AGL_ACC_GREEN_DEPTH", "group__settings.html#ga00f4cfb4cb19b60d677b6941fec903ba", null ],
          [ "AGL_ACC_BLUE_DEPTH", "group__settings.html#gaf80c6da60114ac3962aabcfd8745b97e", null ],
          [ "AGL_ACC_ALPHA_DEPTH", "group__settings.html#gab8eba4f52cdb3d333b237c0ab0b3594a", null ],
          [ "AGL_DOUBLEBUFFER", "group__settings.html#gaa1150ae35d6ff9b33d5771f29f9770dd", null ],
          [ "AGL_STEREO", "group__settings.html#ga47be892718fa4b2c6166caf51da67489", null ],
          [ "AGL_AUX_BUFFERS", "group__settings.html#ga6267cbe7841d12c35d59032f66b7b871", null ],
          [ "AGL_Z_DEPTH", "group__settings.html#gabef24a727709a823e8fc900fdb72892e", null ],
          [ "AGL_STENCIL_DEPTH", "group__settings.html#ga7b34772508e08edb0436e85d2d696fb9", null ],
          [ "AGL_WINDOW_X", "group__settings.html#gafea8132efd1fcac7a7f997ef0fe34cfa", null ],
          [ "AGL_RENDERMETHOD", "group__settings.html#ga3cd047a464c8f8d928f9529226a4cf12", null ],
          [ "AGL_FULLSCREEN", "group__settings.html#ga1baffefcedaffebf7ca47724a0441e60", null ],
          [ "AGL_WINDOWED", "group__settings.html#ga6fcfd5d01183e704595b05fa9812b94f", null ],
          [ "AGL_VIDEO_MEMORY_POLICY", "group__settings.html#gab78a9c8ca24294b008d706a409c4fa37", null ],
          [ "AGL_SAMPLE_BUFFERS", "group__settings.html#gae1836cab58a366c122ace31160fe0e06", null ],
          [ "AGL_SAMPLES", "group__settings.html#ga92d9751c38774297013087e89a25749d", null ]
        ] ],
        [ "Functions", "group__settings.html", [
          [ "allegro_gl_clear_settings", "group__settings.html#gadd1249980001c22cb3eba880561a7e19", null ],
          [ "allegro_gl_set", "group__settings.html#ga025e79a4394803a0e15aaf07b1a8a656", null ],
          [ "allegro_gl_get", "group__settings.html#ga2179291ddb3cb528c3c0cf84af5c51a9", null ],
          [ "allegro_gl_save_settings", "group__settings.html#gaa461b9459f56c9274d2d49accf201ee1", null ],
          [ "allegro_gl_load_settings", "group__settings.html#ga60a577d2fed019cdae83c648f1ff74ec", null ]
        ] ]
      ] ],
      [ "Allegro Interfacing", "group__allegro.html", [
        [ "Functions", "group__allegro.html", [
          [ "allegro_gl_set_allegro_mode", "group__allegro.html#ga7ea7ffd9b72d0d0722cbf982b729efdb", null ],
          [ "allegro_gl_unset_allegro_mode", "group__allegro.html#ga00fbbee541046767114bf9746ceb6f8b", null ],
          [ "allegro_gl_set_projection", "group__allegro.html#gabaf6024e9d196da357aad02c5dc7589f", null ],
          [ "allegro_gl_unset_projection", "group__allegro.html#ga603f8f3719d02816acdf3dbdcaa1f447", null ]
        ] ]
      ] ]
    ] ],
    [ "File List", "files.html", [
      [ "aglf.c", "aglf_8c.html", null ],
      [ "alleggl.c", "alleggl_8c.html", null ],
      [ "alleggl.h", "alleggl_8h.html", null ],
      [ "allglint.h", null, null ],
      [ "djgpp.c", null, null ],
      [ "fontconv.c", "fontconv_8c.html", null ],
      [ "glext.c", "glext_8c.html", null ],
      [ "glvtable.c", "glvtable_8c.html", null ],
      [ "glvtable.h", null, null ],
      [ "gui.c", "gui_8c.html", null ],
      [ "mainpage.foo", "mainpage_8foo.html", null ],
      [ "math.c", "math_8c.html", null ],
      [ "scorer.c", "scorer_8c.html", null ],
      [ "texture.c", "texture_8c.html", null ],
      [ "videovtb.c", "videovtb_8c.html", null ],
      [ "win.c", null, null ],
      [ "x.c", null, null ]
    ] ],
    [ "Globals", "globals.html", null ]
  ] ]
];

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode)
  {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  if (level==0 && node.childrenData)
  {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() 
    {
      if (node.expanded) 
      {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast)
        {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        }
        else
        {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } 
      else 
      {
        expandNode(o, node, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  }
  else
  {
    domNode.appendChild(imgNode);
  }
  if (level==0)
  {
    if (node.isLast)
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    }
    else
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2pnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  }
  else
  {
    if (node.isLast)
    {
      imgNode.src = node.relpath+"ftv2blank.png";
    }
    else
    {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  a.appendChild(node.label);
  if (link) 
  {
    a.href = node.relpath+link;
  } 
  else 
  {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
      node.expanded = false;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() 
  {
    if (!node.childrenUL) 
    {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
}

function expandNode(o, node, imm)
{
  if (node.childrenData && !node.expanded) 
  {
    if (!node.childrenVisited) 
    {
      getNode(o, node);
    }
    if (imm)
    {
      $(node.getChildrenUL()).show();
    } 
    else 
    {
      $(node.getChildrenUL()).slideDown("fast",showRoot);
    }
    if (node.isLast)
    {
      node.plus_img.src = node.relpath+"ftv2mlastnode.png";
    }
    else
    {
      node.plus_img.src = node.relpath+"ftv2mnode.png";
    }
    node.expanded = true;
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) 
  {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
        i==l);
  }
}

function findNavTreePage(url, data)
{
  var nodes = data;
  var result = null;
  for (var i in nodes) 
  {
    var d = nodes[i];
    if (d[1] == url) 
    {
      return new Array(i);
    }
    else if (d[2] != null) // array of children
    {
      result = findNavTreePage(url, d[2]);
      if (result != null) 
      {
        return (new Array(i).concat(result));
      }
    }
  }
  return null;
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;

  getNode(o, o.node);

  o.breadcrumbs = findNavTreePage(toroot, NAVTREE);
  if (o.breadcrumbs == null)
  {
    o.breadcrumbs = findNavTreePage("index.html",NAVTREE);
  }
  if (o.breadcrumbs != null && o.breadcrumbs.length>0)
  {
    var p = o.node;
    for (var i in o.breadcrumbs) 
    {
      var j = o.breadcrumbs[i];
      p = p.children[j];
      expandNode(o,p,true);
    }
    p.itemDiv.className = p.itemDiv.className + " selected";
    p.itemDiv.id = "selected";
    $(window).load(showRoot);
  }
}

