////////////////////////////////////////////////////////////////////////////////
// Copyright AllSeen Alliance. All rights reserved.
//
//    Permission to use, copy, modify, and/or distribute this software for any
//    purpose with or without fee is hereby granted, provided that the above
//    copyright notice and this permission notice appear in all copies.
//
//    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
//    WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
//    MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
//    ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
//    WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
//    ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
//    OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
#import "AJNBusInterface.h"
#import "AJNBusAttachment.h"
#import "BasicService.h"

const AJNSessionPort kBasicObjectServicePort = 25;
NSString * const kBasicObjectServicePath = @ "/sample";
NSString * const kBasicObjectServiceName = @ "org.alljoyn.bus.sample";
NSString * const kBasicObjectInterfaceName = @ "org.alljoyn.bus.sample";
NSString * const kBasicObjectMethodName = @ "cat";

@protocol MyMethodSample <AJNBusInterface>

- (NSString*)concatenateString:(NSString *)string1 withString:(NSString *)string2;

@end

@interface MyBasicSampleObject : AJNBusObject

@property (nonatomic, strong) id<BasicServiceDelegate> delegate;

@end
