/*
 This Java source file was generated by test-to-java.xsl
 and is a derived work from the source document.
 The source document contained the following notice:



 Copyright (c) 2001 World Wide Web Consortium,
 (Massachusetts Institute of Technology, Institut National de
 Recherche en Informatique et en Automatique, Keio University).  All
 Rights Reserved.  This program is distributed under the W3C's Software
 Intellectual Property License.  This program is distributed in the
 hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.

 See W3C License http://www.w3.org/Consortium/Legal/ for more details.


 */

package tests.org.w3c.dom;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.DOMException;

import javax.xml.parsers.DocumentBuilder;

/**
 * The method removeNamedItemNS removes a node specified by local name and
 * namespace
 *
 * Retreive an attribute node and then remove from the NamedNodeMap. Verify if
 * the attribute node was actually remove from the node map.
 *
 * @author IBM
 * @author Neil Delima
 * @see <a
 *      href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-D58B193">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-D58B193</a>
 */
public final class NamedNodeMapRemoveNamedItemNS extends DOMTestCase {

    DOMDocumentBuilderFactory factory;

    DocumentBuilder builder;

    protected void setUp() throws Exception {
        super.setUp();
        try {
            factory = new DOMDocumentBuilderFactory(DOMDocumentBuilderFactory
                    .getConfiguration2());
            builder = factory.getBuilder();
        } catch (Exception e) {
            fail("Unexpected exception" + e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        factory = null;
        builder = null;
        super.tearDown();
    }

    /**
     * Runs the test case.
     *
     * @throws Throwable
     *             Any uncaught exception causes test to fail
     */
    public void testRemoveNamedItemNS1() throws Throwable {
        Document doc;
        NamedNodeMap attributes;
        Node element;
        Attr attribute;
        NodeList elementList;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("http://www.nist.gov",
                "address");
        element = elementList.item(1);
        attributes = element.getAttributes();
        attribute = (Attr) attributes.removeNamedItemNS("http://www.nist.gov",
                "domestic");
        attribute = (Attr) attributes.getNamedItemNS("http://www.nist.gov",
                "domestic");
        assertNull("namednodemapremovenameditemns01", attribute);
    }

// Assumes validation.
//    public void testRemoveNamedItemNS2() throws Throwable {
//        Document doc;
//        NamedNodeMap attributes;
//        Node element;
//        Attr attribute;
//        NodeList elementList;
//        String attrValue;
//        String nullNS = null;
//
//        doc = (Document) load("staffNS", builder);
//        elementList = doc.getElementsByTagNameNS("http://www.nist.gov",
//                "employee");
//        element = elementList.item(1);
//        attributes = element.getAttributes();
//        attribute = (Attr) attributes.removeNamedItemNS(nullNS, "defaultAttr");
//        attribute = (Attr) attributes.getNamedItemNS(nullNS, "defaultAttr");
//        attrValue = attribute.getNodeValue();
//        assertNotNull("namednodemapremovenameditemns02", attribute);
//        assertEquals("namednodemapremovenameditemns02_attrValue", "defaultVal",
//                attrValue);
//    }
    public void testRemoveNamedItemNS3() throws Throwable {
        Document doc;
        NamedNodeMap attributes;
        Node element;
        Attr attribute;

        Attr attribute1;
        Attr attribute2;
        String nodeName;
        doc = (Document) load("staffNS", builder);
        element = doc.createElementNS("http://www.w3.org/DOM/Test", "root");
        attribute1 = doc
                .createAttributeNS("http://www.w3.org/DOM/L1", "L1:att");
        ((Element) /* Node */element).setAttributeNodeNS(attribute1);
        attribute2 = doc
                .createAttributeNS("http://www.w3.org/DOM/L2", "L2:att");
        ((Element) /* Node */element).setAttributeNodeNS(attribute2);
        attributes = element.getAttributes();
        attribute = (Attr) attributes.removeNamedItemNS(
                "http://www.w3.org/DOM/L1", "att");
        attribute = (Attr) attributes.getNamedItemNS(
                "http://www.w3.org/DOM/L2", "att");
        nodeName = attribute.getNodeName();
        assertEquals("namednodemapremovenameditemns02", "L2:att", nodeName);
    }
    public void _testRemoveNamedItemNS4() throws Throwable {
        Document doc;
        NamedNodeMap attributes;
        Node element;
        Attr attribute;

        NodeList elementList;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("*", "employee");
        element = elementList.item(0);
        attributes = element.getAttributes();
        attributes.removeNamedItemNS("http://www.w3.org/2000/xmlns/", "xmlns");
        attribute = (Attr) attributes.getNamedItemNS(
                "http://www.w3.org/2000/xmlns/", "xmlns");
        assertNull("namednodemapremovenameditemns04_1", attribute);
        attributes.removeNamedItemNS("http://www.w3.org/2000/xmlns/", "dmstc");
        attribute = (Attr) attributes.getNamedItemNS(
                "http://www.w3.org/2000/xmlns/", "dmstc");
        assertNull("namednodemapremovenameditemns04_2", attribute);
    }

// Assumes validation.
//    public void testRemoveNamedItemNS5() throws Throwable {
//        Document doc;
//        DocumentType docType;
//        NamedNodeMap entities;
//        NamedNodeMap notations;
//
//        String nullNS = null;
//
//        doc = (Document) load("staffNS", builder);
//        docType = doc.getDoctype();
//        entities = docType.getEntities();
//        assertNotNull("entitiesNotNull", entities);
//        notations = docType.getNotations();
//        assertNotNull("notationsNotNull", notations);
//
//        try {
//            entities.removeNamedItemNS(nullNS, "ent1");
//            fail("entity_throw_DOMException");
//
//        } catch (DOMException ex) {
//            switch (ex.code) {
//            case 8:
//                break;
//            case 7:
//                break;
//            default:
//                throw ex;
//            }
//        }
//
//        try {
//            notations.removeNamedItemNS(nullNS, "notation1");
//            fail("notation_throw_DOMException");
//
//        } catch (DOMException ex) {
//            switch (ex.code) {
//            case 8:
//                break;
//            case 7:
//                break;
//            default:
//                throw ex;
//            }
//        }
//    }
    public void testRemoveNamedItemNS6() throws Throwable {
        Document doc;
        NamedNodeMap attributes;
        Node element;

        NodeList elementList;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("http://www.nist.gov",
                "employee");
        element = elementList.item(1);
        attributes = element.getAttributes();

        {
            boolean success = false;
            try {
                attributes.removeNamedItemNS("http://www.Nist.gov", "domestic");
            } catch (DOMException ex) {
                success = (ex.code == DOMException.NOT_FOUND_ERR);
            }
            assertTrue("throw_NOT_FOUND_ERR", success);
        }
    }
    public void testRemoveNamedItemNS7() throws Throwable {
        Document doc;
        NamedNodeMap attributes;
        Node element;

        NodeList elementList;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("http://www.nist.gov",
                "employee");
        element = elementList.item(1);
        attributes = element.getAttributes();

        {
            boolean success = false;
            try {
                attributes.removeNamedItemNS("http://www.nist.gov", "domestic");
            } catch (DOMException ex) {
                success = (ex.code == DOMException.NOT_FOUND_ERR);
            }
            assertTrue("throw_NOT_FOUND_ERR", success);
        }
    }
    public void testRemoveNamedItemNS8() throws Throwable {
        Document doc;
        NamedNodeMap attributes;
        Element element;

        NodeList elementList;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("http://www.nist.gov",
                "address");
        element = (Element) elementList.item(1);
        attributes = element.getAttributes();
        element.removeAttributeNS("http://www.nist.gov", "domestic");

        {
            boolean success = false;
            try {
                attributes.removeNamedItemNS("http://www.nist.gov", "domestic");
            } catch (DOMException ex) {
                success = (ex.code == DOMException.NOT_FOUND_ERR);
            }
            assertTrue("throw_NOT_FOUND_ERR", success);
        }
    }
    public void testRemoveNamedItemNS9() throws Throwable {
        Document doc;
        NamedNodeMap attributes;
        NamedNodeMap newAttributes;
        Element element;
        Attr attribute;
        NodeList elementList;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("http://www.nist.gov",
                "address");
        element = (Element) elementList.item(1);
        attributes = element.getAttributes();
        attribute = (Attr) attributes.removeNamedItemNS("http://www.nist.gov",
                "domestic");
        newAttributes = element.getAttributes();
        attribute = (Attr) newAttributes.getNamedItemNS("http://www.nist.gov",
                "domestic");
        assertNull("namednodemapremovenameditemns09", attribute);
    }

}
