/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 10:49:10 GMT 2018
 */

package uk.ac.sanger.artemis.circular.digest;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.CharArrayReader;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PipedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFileReader;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.FeatureFromVectorPredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.circular.digest.FragmentBand;
import uk.ac.sanger.artemis.circular.digest.ReportDetails;
import uk.ac.sanger.artemis.circular.digest.Utils;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Utils_ESTest extends Utils_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      // Undeclared exception!
      try { 
        Utils.findCutSitesFromExperiment((Reader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.Reader", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader(2510);
      try { 
        Utils.findCutSitesFromExperiment(pipedReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      // Undeclared exception!
      try { 
        Utils.findCutSitesFromEmbossReport(pipedReader0);
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // Couldn't read, or parse results
         //
         verifyException("uk.ac.sanger.artemis.circular.digest.Utils", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      FileDescriptor fileDescriptor0 = new FileDescriptor();
      MockFileReader mockFileReader0 = new MockFileReader(fileDescriptor0);
      // Undeclared exception!
      try { 
        Utils.findCutSitesFromEmbossReport(mockFileReader0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      ReportDetails reportDetails0 = new ReportDetails();
      reportDetails0.length = (-1367);
      // Undeclared exception!
      try { 
        Utils.createDNADrawFromReportDetails(reportDetails0, (EntryGroup) null);
        fail("Expecting exception: ArithmeticException");
      
      } catch(ArithmeticException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      ReportDetails reportDetails0 = new ReportDetails();
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("uk.ac.sanger.artemis.io.InvalidRelationException");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureVector featureVector0 = new FeatureVector();
      FeatureFromVectorPredicate featureFromVectorPredicate0 = new FeatureFromVectorPredicate(featureVector0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureFromVectorPredicate0, "uk.ac.sanger.artemis.io.InvalidRelationException");
      // Undeclared exception!
      Utils.createDNADrawFromReportDetails(reportDetails0, filteredEntryGroup0);
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      ReportDetails reportDetails0 = new ReportDetails();
      reportDetails0.length = 32768;
      // Undeclared exception!
      try { 
        Utils.createDNADrawFromReportDetails(reportDetails0, (EntryGroup) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      StringReader stringReader0 = new StringReader("start");
      // Undeclared exception!
      try { 
        Utils.findCutSitesFromExperiment(stringReader0);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"start\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      char[] charArray0 = new char[4];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      Utils.findCutSitesFromEmbossReport(charArrayReader0);
      List<FragmentBand> list0 = Utils.findCutSitesFromExperiment(charArrayReader0);
      assertTrue(list0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test9()  throws Throwable  {
      Utils utils0 = new Utils();
  }
}
