/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:31:21 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PipedReader;
import java.io.Writer;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockPrintWriter;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BlastStreamFeature;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class BlastStreamFeature_ESTest extends BlastStreamFeature_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      Key key0 = new Key("subject_id", true);
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(key0, (Location) null, (QualifierVector) null);
      // Undeclared exception!
      try { 
        blastStreamFeature0.writeToStream((Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      // Undeclared exception!
      try { 
        BlastStreamFeature.readFromStream((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader(3280);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      try { 
        BlastStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      BlastStreamFeature blastStreamFeature0 = null;
      try {
        blastStreamFeature0 = new BlastStreamFeature((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      char[] charArray0 = new char[5];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      try { 
        BlastStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // invalid Blast line (not enough fields): \u0000\u0000\u0000\u0000\u0000
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      Key key0 = new Key((String) null, true);
      Range range0 = new Range(68);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature(key0, location0, qualifierVector0);
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(emblStreamFeature0);
      Feature feature0 = blastStreamFeature0.copy();
      assertFalse(feature0.equals((Object)blastStreamFeature0));
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      Key key0 = new Key("");
      QualifierVector qualifierVector0 = new QualifierVector();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(key0, (Location) null, qualifierVector0);
      CharArrayWriter charArrayWriter0 = new CharArrayWriter(0);
      MockPrintWriter mockPrintWriter0 = new MockPrintWriter(charArrayWriter0, false);
      blastStreamFeature0.writeToStream(mockPrintWriter0);
      assertEquals(5, charArrayWriter0.size());
      assertEquals("null\n", charArrayWriter0.toString());
  }
}
