#ifndef ATL_stGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,240,320,400,480,960,1040,1120,1200,1440,1920
 * N : 25,240,320,400,480,960,1040,1120,1200,1440,1920
 * NB : 2,8,8,28,80,24,40,56,136,104,80
 */
#define ATL_stGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 132) (nb_) = 2; \
   else if ((n_) < 360) (nb_) = 8; \
   else if ((n_) < 440) (nb_) = 28; \
   else if ((n_) < 720) (nb_) = 80; \
   else if ((n_) < 1000) (nb_) = 24; \
   else if ((n_) < 1080) (nb_) = 40; \
   else if ((n_) < 1160) (nb_) = 56; \
   else if ((n_) < 1320) (nb_) = 136; \
   else if ((n_) < 1680) (nb_) = 104; \
   else (nb_) = 80; \
}


#endif    /* end ifndef ATL_stGetNB_geqrf */
