/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;

public class YUVBuffer
implements ImageProducer {
    public int y_width;
    public int y_height;
    public int y_stride;
    public int uv_width;
    public int uv_height;
    public int uv_stride;
    public short[] data;
    public int y_offset;
    public int u_offset;
    public int v_offset;
    private int[] pixels;
    private int pix_size;
    private boolean newPixels = true;
    private ColorModel colorModel = ColorModel.getRGBdefault();
    private ImageProducer filteredThis;
    private int crop_x;
    private int crop_y;
    private int crop_w;
    private int crop_h;
    private final int FLAGS = 1074266368;
    private static int[] yuv2rgb_table = new int[]{2147483629, 0x7FFFFFEF, 0x7FFFFFF0, 0x7FFFFFF1, 0x7FFFFFF2, 0x7FFFFFF3, 0x7FFFFFF4, 0x7FFFFFF6, 0x7FFFFFF7, 0x7FFFFFF8, 0x7FFFFFF9, 0x7FFFFFFA, 0x7FFFFFFB, 0x7FFFFFFD, 0x7FFFFFFE, Integer.MAX_VALUE, Integer.MIN_VALUE, -2143287295, -2136993790, -2132797437, -2128599035, -2122305530, -2118109177, -2113912824, -2107619319, -2103422966, -2099224564, -2092931059, -2088734706, -2084538353, -2078244848, -2074048495, -2069850093, -2063556588, -2059360235, -2055163882, -2048870377, -2044674024, -2040475622, -2034182117, -2029985764, -2025789411, -2019495906, -2015299553, -2011101151, -2004807646, -2000611293, -1996414940, -1992218587, -1985925082, -1981726680, -1977530327, -1971236822, -1967040469, -1962844116, -1956550611, -1952352209, -1948155856, -1941862351, -1937665998, -1933469645, -1927176140, -1922977738, -1918781385, -1912487880, -1908291527, -1904095174, -1897801669, -1893603267, -1889406914, -1883113409, -1878917056, -1874720703, -1868427198, -1864228796, -1860032443, -1853738938, -1849542585, -1845346232, -1839052727, -1834856374, -1830657972, -1824364467, -1820168114, -1815971761, -1809678256, -1805481903, -1801283501, -1794989996, -1790793643, -1786597290, -1780303785, -1776107432, -1771909030, -1765615525, -1761419172, -1757222819, -1750929314, -1746732961, -1742534559, -1736241054, -1732044701, -1727848348, -1721554843, -1717358490, -1713160088, -1706866583, -1702670230, -1698473877, -1692180372, -1687984019, -1683785617, -1679589264, -1673295759, -1669099406, -1664903053, -1658609548, -1654411146, -1650214793, -1643921288, -1639724935, -1635528582, -1629235077, -1625036675, -1620840322, -1614546817, -1610350464, -1606154111, -1599860606, -1595662204, -1591465851, -1585172346, -1580975993, -1576779640, -1570486135, -1566287733, -1562091380, -1555797875, -1551601522, -1547405169, -1541111664, -1536913262, -1532716909, -1526423404, -1522227051, -1518030698, -1511737193, -1507540840, -1503342438, -1497048933, -1492852580, -1488656227, -1482362722, -1478166369, -1473967967, -1467674462, -1463478109, -1459281756, -1452988251, -1448791898, -1444593496, -1438299991, -1434103638, -1429907285, -1423613780, -1419417427, -1415219025, -1408925520, -1404729167, -1400532814, -1394239309, -1390042956, -1385844554, -1381648201, -1375354696, -1371158343, -1366961990, -1360668485, -1356470083, -1352273730, -1345980225, -1341783872, -1337587519, -1331294014, -1327095612, -1322899259, -1316605754, -1312409401, -1308213048, -1301919543, -1297721141, -1293524788, -1287231283, -1283034930, -1278838577, -1272545072, -1268346670, -1264150317, -1257856812, -1253660459, -1249464106, -1243170601, -1238972199, -1234775846, -1228482341, -1224285988, -1220089635, -1213796130, -1209599777, -1205401375, -1199107870, -1194911517, -1190715164, -1184421659, -1180225306, -1176026904, -1169733399, -1165537046, -1161340693, -1155047188, -1150850835, -1146652433, -1140358928, -1136162575, -1131966222, -1125672717, -1121476364, -1117277962, -1110984457, -1106788104, -1102591751, -1096298246, -1092101893, -1087903491, -1081609986, -1077413633, -1073217280, -1069020927, -1062727422, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, -1058529020, 205521155, 203424005, 203424007, 201326857, 199229707, 197132557, 195035407, 195035409, 192938259, 190841109, 188743959, 188743961, 186646811, 184549661, 182452511, 182452513, 180355363, 178258213, 176161063, 174063913, 174063915, 171966765, 169869615, 167772465, 167772466, 165675316, 163578166, 161481016, 161481018, 159383868, 157286718, 155189568, 155189570, 153092420, 150995270, 148898120, 146800970, 146800972, 144703822, 142606672, 140509522, 140509524, 138412374, 136315224, 134218074, 134218076, 132120926, 130023776, 127926626, 127926628, 125829478, 123732328, 121635178, 119538028, 119538030, 0x7000170, 115343730, 113246580, 113246582, 111149432, 109052282, 106955132, 106955134, 104857984, 102760834, 100663684, 98566533, 98566535, 96469385, 94372235, 92275085, 92275087, 90177937, 88080787, 85983637, 85983639, 83886489, 81789339, 79692189, 79692191, 77595041, 75497891, 73400741, 71303591, 71303593, 69206443, 67109293, 65012143, 65012145, 62914995, 60817845, 58720695, 58720697, 56623547, 54526397, 52429247, 52429249, 50332099, 48234949, 46137799, 44040649, 44040651, 41943501, 39846351, 37749201, 37749203, 35652053, 33554903, 31457752, 31457754, 29360604, 27263454, 25166304, 23069154, 23069156, 20972006, 18874856, 16777706, 16777708, 0xE001EE, 12583408, 10486258, 10486260, 8389110, 6291960, 4194810, 4194812, 2097662, 512, -2096638, -4193788, -4193786, -6290936, -8388086, -10485236, -10485234, -12582384, -14679534, -16776684, -16776682, -18873832, -20970982, -23068132, -23068130, -25165280, -27262430, -29359580, -31456730, -31456728, -33553879, -35651029, -37748179, -37748177, -39845327, -41942477, -44039627, -44039625, -46136775, -48233925, -50331075, -52428225, -52428223, -54525373, -56622523, -58719673, -58719671, -60816821, -62913971, -65011121, -65011119, -67108269, -69205419, -71302569, -71302567, -73399717, -75496867, -77594017, -79691167, -79691165, -81788315, -83885465, -85982615, -85982613, -88079763, -90176913, -92274063, -92274061, -94371211, -96468361, -98565511, -98565509, -100662660, -102759810, -104856960, -106954110, -106954108, -109051258, -111148408, -113245558, -113245556, -115342706, -117439856, -119537006, -119537004, -121634154, -123731304, -125828454, -127925604, -127925602, -130022752, -132119902, -134217052, -134217050, -136314200, -138411350, -140508500, -140508498, -142605648, -144702798, -146799948, -146799946, -148897096, -150994246, -153091396, -155188546, -155188544, -157285694, -159382844, -161479994, -161479992, -163577142, -165674292, -167771442, -167771441, -169868591, -171965741, -174062891, -174062889, -176160039, -178257189, -180354339, -182451489, -182451487, -184548637, -186645787, -188742937, -188742935, -190840085, -192937235, -195034385, -195034383, -197131533, -199228683, -201325833, -203422983, -203422981, 436838400, 434743296, 430553088, 426362880, 424267776, 420077568, 415885312, 413792256, 409600000, 405409792, 403316736, 399124480, 397031424, 392839168, 388648960, 386555904, 382363648, 378173440, 376078336, 371888128, 369795072, 365602816, 361412608, 359317504, 355127296, 350937088, 348841984, 344651776, 342556672, 338366464, 334176256, 332081152, 327890944, 323698688, 321605632, 317415424, 315320320, 311130112, 306937856, 304844800, 300654592, 296462336, 294369280, 290177024, 288083968, 283893760, 279701504, 277608448, 273416192, 0x100C1000, 267132928, 262940672, 260847616, 256655360, 252465152, 250370048, 246179840, 241989632, 239894528, 235704320, 233609216, 229419008, 225228800, 223133696, 0xD0CD000, 214751232, 212658176, 208467968, 206372864, 202182656, 197990400, 195897344, 191707136, 187514880, 185421824, 181229568, 179136512, 174946304, 170754048, 168660992, 164468736, 160278528, 158185472, 153993216, 0x90DD000, 147707904, 143517696, 141424640, 137232384, 133042176, 130947072, 126756864, 124663808, 120471552, 116281344, 114186240, 109996032, 105805824, 103710720, 99520512, 97425408, 93235200, 89044992, 86949888, 82759680, 78567424, 76474368, 72282112, 70189056, 65998848, 61806592, 59713536, 55521280, 51331072, 49238016, 45045760, 42952704, 38760448, 34570240, 32477184, 28284928, 24094720, 21999616, 17809408, 15716352, 11524096, 7333888, 0x4FF000, 0x100000, -3141632, -5236736, -9426944, -13619200, -15712256, -19902464, -21997568, -26187776, -30380032, -32473088, -36663296, -40855552, -42948608, -47140864, -49233920, -53424128, -57616384, -59709440, -63901696, -68091904, -70184960, -74377216, -76470272, -80662528, -84852736, -86947840, -91138048, -95328256, -97423360, -101613568, -103708672, -107898880, -112089088, -114184192, -118374400, -122566656, -124659712, -128849920, -130945024, -135135232, -139327488, -141420544, -145610752, -149803008, -151896064, -156088320, -158181376, -162371584, -166563840, -168656896, -172849152, -177039360, -179132416, -183324672, -185417728, -189609984, -193800192, -195893248, -200085504, -204275712, -206370816, -210561024, -212654080, -216846336, -221036544, -223131648, -227321856, -231512064, -233607168, -237797376, -239892480, -244082688, -248272896, -250368000, -254558208, -258750464, -260843520, -265035776, -267128832, -271319040, -275511296, -277604352, -281796608, -285986816, -288079872, -292272128, -294365184, -298557440, -302747648, -304840704, -309032960, -313223168, -315318272, -319508480, -321601536, -325793792, -329984000, -332079104, -336269312, -340459520, -342554624, -346744832, -348839936, -353030144, -357220352, -359315456, -363505664, -367697920, -369790976, -373981184, -376076288, -380266496, -384458752, -386551808, -390742016, -394934272, -397027328, -401219584, -403312640, -407502848, -411695104, -413788160, -417980416, -422170624, -424263680, -428455936, -432646144};

    public void addConsumer(ImageConsumer imageConsumer) {
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return false;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void startProduction(ImageConsumer imageConsumer) {
        imageConsumer.setColorModel(this.colorModel);
        imageConsumer.setHints(30);
        imageConsumer.setDimensions(this.y_width, this.y_height);
        this.prepareRGBData(0, 0, this.y_width, this.y_height);
        imageConsumer.setPixels(0, 0, this.y_width, this.y_height, this.colorModel, this.pixels, 0, this.y_width);
        imageConsumer.imageComplete(3);
    }

    private synchronized void prepareRGBData(int n, int n2, int n3, int n4) {
        if (!this.newPixels) {
            return;
        }
        int n5 = n3 * n4;
        try {
            if (n5 != this.pix_size) {
                this.pixels = new int[n5];
                this.pix_size = n5;
            }
            this.YUVtoRGB(n, n2, n3, n4);
        }
        catch (Throwable throwable) {}
        this.newPixels = false;
    }

    public synchronized void newPixels() {
        this.newPixels = true;
    }

    public Object getObject(int n, int n2, int n3, int n4) {
        if (n == 0 && n2 == 0 && n3 == this.y_width && n4 == this.y_height) {
            return this;
        }
        if (n != this.crop_x || n2 != this.crop_y || n3 != this.crop_w || n4 != this.crop_h) {
            this.crop_x = n;
            this.crop_y = n2;
            this.crop_w = n3;
            this.crop_h = n4;
            CropImageFilter cropImageFilter = new CropImageFilter(this.crop_x, this.crop_y, this.crop_w, this.crop_h);
            this.filteredThis = new FilteredImageSource(this, cropImageFilter);
        }
        return this.filteredThis;
    }

    private void YUVtoRGB_classic(int n, int n2, int n3, int n4) {
        int n5 = this.y_offset + n + n2 * this.y_stride;
        int n6 = n5 + this.y_stride;
        int n7 = this.u_offset + n / 2 + n2 / 2 * this.uv_stride;
        int n8 = this.v_offset + n / 2 + n2 / 2 * this.uv_stride;
        int n9 = 0;
        int n10 = n3;
        int n11 = n3 / 2;
        int n12 = n4 / 2;
        int n13 = this.y_stride * 2 - n11 * 2;
        int n14 = this.uv_stride - n11;
        int n15 = n3;
        int n16 = 0;
        while (n16 < n12) {
            int n17 = 0;
            while (n17 < n11) {
                int n18 = this.data[n7++] - 128;
                int n19 = this.data[n8++] - 128;
                int n20 = 298 * (this.data[n5] - 16);
                int n21 = 409 * n19 + 128;
                int n22 = 100 * n18 + 208 * n19 - 128;
                int n23 = 516 * n18 + 128;
                int n24 = n20 + n21 >> 8;
                int n25 = n20 - n22 >> 8;
                int n26 = n20 + n23 >> 8;
                n20 = 298 * (this.data[n5 + 1] - 16);
                this.pixels[n9] = (YUVBuffer.clamp255(n24) << 16) + (YUVBuffer.clamp255(n25) << 8) + YUVBuffer.clamp255(n26) | 0xFF000000;
                n24 = n20 + n21 >> 8;
                n25 = n20 - n22 >> 8;
                n26 = n20 + n23 >> 8;
                n20 = 298 * (this.data[n6] - 16);
                this.pixels[n9 + 1] = (YUVBuffer.clamp255(n24) << 16) + (YUVBuffer.clamp255(n25) << 8) + YUVBuffer.clamp255(n26) | 0xFF000000;
                n24 = n20 + n21 >> 8;
                n25 = n20 - n22 >> 8;
                n26 = n20 + n23 >> 8;
                n20 = 298 * (this.data[n6 + 1] - 16);
                this.pixels[n10] = (YUVBuffer.clamp255(n24) << 16) + (YUVBuffer.clamp255(n25) << 8) + YUVBuffer.clamp255(n26) | 0xFF000000;
                n24 = n20 + n21 >> 8;
                n25 = n20 - n22 >> 8;
                n26 = n20 + n23 >> 8;
                this.pixels[n10 + 1] = (YUVBuffer.clamp255(n24) << 16) + (YUVBuffer.clamp255(n25) << 8) + YUVBuffer.clamp255(n26) | 0xFF000000;
                n5 += 2;
                n6 += 2;
                n9 += 2;
                n10 += 2;
                ++n17;
            }
            n5 += n13;
            n6 += n13;
            n7 += n14;
            n8 += n14;
            n9 += n15;
            n10 += n15;
            ++n16;
        }
    }

    private static final short clamp255(int n) {
        n -= 255;
        n = -(255 + (n >> 31 & n));
        return (short)(-(n >> 31 & n));
    }

    private void YUVtoRGB(int n, int n2, int n3, int n4) {
        int n5 = this.y_offset + n + n2 * this.y_stride;
        int n6 = n5 + this.y_stride;
        int n7 = this.u_offset + n / 2 + n2 / 2 * this.uv_stride;
        int n8 = this.v_offset + n / 2 + n2 / 2 * this.uv_stride;
        int n9 = 0;
        int n10 = n3;
        int n11 = n3 / 2;
        int n12 = n4 / 2;
        int n13 = this.y_stride * 2 - n11 * 2;
        int n14 = this.uv_stride - n11;
        int n15 = n3;
        int n16 = n12;
        while (n16 > 0) {
            int n17 = n11;
            while (n17 > 0) {
                int n18 = yuv2rgb_table[256 + this.data[n7++]] + yuv2rgb_table[512 + this.data[n8++]];
                int n19 = n18 + yuv2rgb_table[this.data[n5]];
                int n20 = n19 & 0x40080100;
                n20 -= n20 >> 8;
                n19 |= n20;
                n20 = 0x40080100 & ~(n19 >> 1);
                this.pixels[n9] = 0xFF000000 | (n19 += n20 >> 8) << 5 & 0xFF0000 | n19 >> 14 & 0xFF00 | n19 & 0xFF;
                n19 = n18 + yuv2rgb_table[this.data[n5 + 1]];
                n20 = n19 & 0x40080100;
                n20 -= n20 >> 8;
                n19 |= n20;
                n20 = 0x40080100 & ~(n19 >> 1);
                this.pixels[n9 + 1] = 0xFF000000 | (n19 += n20 >> 8) << 5 & 0xFF0000 | n19 >> 14 & 0xFF00 | n19 & 0xFF;
                n19 = n18 + yuv2rgb_table[this.data[n6]];
                n20 = n19 & 0x40080100;
                n20 -= n20 >> 8;
                n19 |= n20;
                n20 = 0x40080100 & ~(n19 >> 1);
                this.pixels[n10] = 0xFF000000 | (n19 += n20 >> 8) << 5 & 0xFF0000 | n19 >> 14 & 0xFF00 | n19 & 0xFF;
                n19 = n18 + yuv2rgb_table[this.data[n6 + 1]];
                n20 = n19 & 0x40080100;
                n20 -= n20 >> 8;
                n19 |= n20;
                n20 = 0x40080100 & ~(n19 >> 1);
                this.pixels[n10 + 1] = 0xFF000000 | (n19 += n20 >> 8) << 5 & 0xFF0000 | n19 >> 14 & 0xFF00 | n19 & 0xFF;
                n5 += 2;
                n6 += 2;
                n9 += 2;
                n10 += 2;
                --n17;
            }
            n5 += n13;
            n6 += n13;
            n7 += n14;
            n8 += n14;
            n9 += n15;
            n10 += n15;
            --n16;
        }
    }
}

