/* Copyright (c) 2007  Dmitry Xmelkov
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */

/* Test of addition.  Random cases.
   $Id$
 */
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases:  x + y = z	*/
    long x, y, z;
} t[] = {

    { 0xc224056f, 0x3dd8cd18, 0xc2239908 },  /*   1: -4.1005306e+01  1.0585994e-01 -4.0899446e+01 */
    { 0x42c688e7, 0xc00e543f, 0x42c21645 },  /*   2:  9.9267387e+01 -2.2238920e+00  9.7043495e+01 */
    { 0x417341e3, 0xd396b743, 0xd396b743 },  /*   3:  1.5203586e+01 -1.2946394e+12 -1.2946394e+12 */
    { 0xc16d3668, 0x42637e1e, 0x42283084 },  /*   4: -1.4825783e+01  5.6873161e+01  4.2047379e+01 */
    { 0xbdc7e165, 0x4787242a, 0x4787241e },  /*   5: -9.7597875e-02  6.9192328e+04  6.9192231e+04 */
    { 0xbe120ff8, 0x49f0ca40, 0x49f0ca3f },  /*   6: -1.4263904e-01  1.9725520e+06  1.9725519e+06 */
    { 0x41930068, 0xbf093b35, 0x418eb68e },  /*   7:  1.8375198e+01 -5.3605968e-01  1.7839139e+01 */
    { 0xbf135d14, 0x3d274803, 0xbf08e894 },  /*   8: -5.7563901e-01  4.0840160e-02 -5.3479885e-01 */
    { 0xbfdd1f85, 0xbfea34d9, 0xc063aa2f },  /*   9: -1.7275244e+00 -1.8297378e+00 -3.5572622e+00 */
    { 0x5ad889bb, 0x3f318bda, 0x5ad889bb },  /*  10:  3.0475016e+16  6.9354022e-01  3.0475016e+16 */
    { 0x3f101385, 0xbffcdf59, 0xbfb4d596 },  /*  11:  5.6279784e-01 -1.9755660e+00 -1.4127682e+00 */
    { 0x70bc9c79, 0xbfa524dd, 0x70bc9c79 },  /*  12:  4.6697877e+29 -1.2901875e+00  4.6697877e+29 */
    { 0x426d7577, 0xbfe3d6bb, 0x426656c1 },  /*  13:  5.9364712e+01 -1.7799906e+00  5.7584721e+01 */
    { 0x3ffa9cb7, 0xbf4edcc9, 0x3f932e52 },  /*  14:  1.9579076e+00 -8.0805641e-01  1.1498511e+00 */
    { 0x4690b2ca, 0x3fb2068e, 0x4690b592 },  /*  15:  1.8521395e+04  1.3908250e+00  1.8522785e+04 */
    { 0xbc20b102, 0xbf01ab0a, 0xbf042dce },  /*  16: -9.8078270e-03 -5.0651610e-01 -5.1632393e-01 */
    { 0xc3f8489a, 0xcdd0e459, 0xcdd0e469 },  /*  17: -4.9656720e+02 -4.3807824e+08 -4.3807874e+08 */
    { 0x4490f867, 0xc0c86bbb, 0x44902ffb },  /*  18:  1.1597626e+03 -6.2631507e+00  1.1534994e+03 */
    { 0xbd8175b9, 0xc29cbb3a, 0xc29cdb97 },  /*  19: -6.3212819e-02 -7.8365677e+01 -7.8428890e+01 */
    { 0x3ca3787d, 0xbfe0e68e, 0xbfde58ac },  /*  20:  1.9954914e-02 -1.7570360e+00 -1.7370811e+00 */
    { 0xbef9d6a9, 0x3f1ca8b2, 0x3dfdeaec },  /*  21: -4.8796585e-01  6.1194909e-01  1.2398323e-01 */
    { 0xc304ccff, 0x428af5e6, 0xc27d4830 },  /*  22: -1.3280077e+02  6.9480270e+01 -6.3320496e+01 */
    { 0x3f316d32, 0x44114c12, 0x4411786d },  /*  23:  6.9307244e-01  5.8118860e+02  5.8188167e+02 */
    { 0x41c7bb8b, 0x410dc723, 0x42074f8e },  /*  24:  2.4966574e+01  8.8611174e+00  3.3827691e+01 */
    { 0xc14b7c2e, 0xbc42d728, 0xc14bace4 },  /*  25: -1.2717817e+01 -1.1892118e-02 -1.2729709e+01 */
    { 0xc2a1b905, 0x3f533e8d, 0xc2a01288 },  /*  26: -8.0861366e+01  8.2517320e-01 -8.0036193e+01 */
    { 0xbf18f2e8, 0xbe5c8df4, 0xbf501665 },  /*  27: -5.9745646e-01 -2.1538526e-01 -8.1284171e-01 */
    { 0xbf5478ab, 0xbd3052e0, 0xbf5f7dd9 },  /*  28: -8.2996625e-01 -4.3047786e-02 -8.7301403e-01 */
    { 0xc1df2794, 0xbf17065c, 0xc1e3dfc7 },  /*  29: -2.7894325e+01 -5.8994079e-01 -2.8484266e+01 */
    { 0xc19556e5, 0xbd8790e6, 0xc195de76 },  /*  30: -1.8667429e+01 -6.6194341e-02 -1.8733623e+01 */
    { 0xc20a9ca7, 0xbff18abb, 0xc21228fd },  /*  31: -3.4652981e+01 -1.8870462e+00 -3.6540027e+01 */
    { 0x3f06ef9e, 0x3f4cd7a1, 0x3fa9e3a0 },  /*  32:  5.2709377e-01  8.0016524e-01  1.3272590e+00 */
    { 0x410e01a6, 0xc0c0843c, 0x4036fe20 },  /*  33:  8.8754025e+00 -6.0161419e+00  2.8592606e+00 */
    { 0x3c2fb0ab, 0x3fc1ef02, 0x3fc34e63 },  /*  34:  1.0723273e-02  1.5151064e+00  1.5258297e+00 */
    { 0x3fddf13e, 0x40e87fe3, 0x410ffe19 },  /*  35:  1.7339246e+00  7.2656112e+00  8.9995358e+00 */
    { 0x41382ab7, 0x4c83f771, 0x4c83f772 },  /*  36:  1.1510428e+01  6.9188488e+07  6.9188500e+07 */
    { 0xbf0bab64, 0xbbd49ef5, 0xbf0d54a2 },  /*  37: -5.4558396e-01 -6.4886757e-03 -5.5207264e-01 */
    { 0xc000549a, 0x4053d5d7, 0x3fa7027a },  /*  38: -2.0051637e+00  3.3099267e+00  1.3047631e+00 */
    { 0x3528e8fc, 0xb9d67515, 0xb9d620a1 },  /*  39:  6.2923914e-07 -4.0904494e-04 -4.0841570e-04 */
    { 0x429309f0, 0xc3167ce7, 0xc299efde },  /*  40:  7.3519409e+01 -1.5048790e+02 -7.6968491e+01 */
    { 0x470881eb, 0x3d1230fa, 0x470881f4 },  /*  41:  3.4945918e+04  3.5691239e-02  3.4945954e+04 */
    { 0x3fba3cea, 0xc07bf016, 0xc01ed1a1 },  /*  42:  1.4549839e+00 -3.9365287e+00 -2.4815447e+00 */
    { 0xbe1a1b52, 0x4606cc6e, 0x4606cbd4 },  /*  43: -1.5049484e-01  8.6271074e+03  8.6269569e+03 */
    { 0x3d6980b7, 0x3df73480, 0x3e35fa6e },  /*  44:  5.7007518e-02  1.2070560e-01  1.7771312e-01 */
    { 0x423dcbe2, 0xbf3cc008, 0x423ad8e2 },  /*  45:  4.7449104e+01 -7.3730516e-01  4.6711799e+01 */
    { 0x3dcbdfc6, 0x3cc4ef40, 0x3dfd1b96 },  /*  46:  9.9547908e-02  2.4039865e-02  1.2358777e-01 */
    { 0xd97a6fcc, 0xbff642aa, 0xd97a6fcc },  /*  47: -4.4057291e+15 -1.9239094e+00 -4.4057291e+15 */
    { 0x3d5bda53, 0xc2442ff2, 0xc243f8fb },  /*  48:  5.3675007e-02 -4.9046822e+01 -4.8993147e+01 */
    { 0x39d9b6da, 0x3d8f206d, 0x3d8ffa24 },  /*  49:  4.1525700e-04  6.9886066e-02  7.0301323e-02 */
    { 0x3e19f801, 0x3e70bc6c, 0x3ec55a36 },  /*  50:  1.5036012e-01  2.3509377e-01  3.8545389e-01 */
    { 0xba5ba145, 0xbf306af3, 0xbf30a1db },  /*  51: -8.3782180e-04 -6.8913192e-01 -6.8996974e-01 */
    { 0xc1bfb3b7, 0xbe080af1, 0xc1c0c3cd },  /*  52: -2.3962751e+01 -1.3285424e-01 -2.4095606e+01 */
    { 0xbfe5f74d, 0x3dd4d4a0, 0xbfd8aa03 },  /*  53: -1.7966095e+00  1.0392118e-01 -1.6926883e+00 */
    { 0x3fd8d535, 0x3df96d47, 0x3fe86c09 },  /*  54:  1.6940066e+00  1.2179046e-01  1.8157970e+00 */
    { 0xc446be7d, 0xbfee387e, 0xc4473599 },  /*  55: -7.9497638e+02 -1.8610990e+00 -7.9683748e+02 */
    { 0x80000000, 0x40f2c2d8, 0x40f2c2d8 },  /*  56: -0.0000000e+00  7.5862846e+00  7.5862846e+00 */
    { 0xbdf2d05c, 0x3b71cf23, 0xbdeb41e3 },  /*  57: -1.1856148e-01  3.6897145e-03 -1.1487176e-01 */
    { 0x3f242fe6, 0xbe282df7, 0x3ef448d0 },  /*  58:  6.4135587e-01 -1.6423784e-01  4.7711803e-01 */
    { 0x41725de0, 0x38d67795, 0x41725e4b },  /*  59:  1.5147919e+01  1.0226589e-04  1.5148021e+01 */
    { 0xbfec624a, 0xbdfb2e04, 0xbffc152a },  /*  60: -1.8467495e+00 -1.2264636e-01 -1.9693959e+00 */
    { 0xbfd70a42, 0x3ddab950, 0xbfc95ead },  /*  61: -1.6800005e+00  1.0679877e-01 -1.5732018e+00 */
    { 0x3c843978, 0xbff92252, 0xbff7116c },  /*  62:  1.6140684e-02 -1.9463599e+00 -1.9302192e+00 */
    { 0xd76494e0, 0x41c40846, 0xd76494e0 },  /*  63: -2.5132806e+14  2.4504040e+01 -2.5132806e+14 */
    { 0xc11af3c4, 0x41894216, 0x40ef20d0 },  /*  64: -9.6845131e+00  1.7157269e+01  7.4727554e+00 */
    { 0x3fe75c10, 0x42774ab1, 0x427e8592 },  /*  65:  1.8074970e+00  6.1822941e+01  6.3630438e+01 */
    { 0x407991cd, 0xb2ce7069, 0x407991cd },  /*  66:  3.8995240e+00 -2.4032675e-08  3.8995239e+00 */
    { 0x41f1cd89, 0x40c6cce9, 0x4211c062 },  /*  67:  3.0225359e+01  6.2125134e+00  3.6437872e+01 */
    { 0x46b31a2c, 0x40a4ff64, 0x46b3247c },  /*  68:  2.2925086e+04  5.1561756e+00  2.2930242e+04 */
    { 0x41116a41, 0x3f3e00e6, 0x411d4a4f },  /*  69:  9.0884409e+00  7.4220121e-01  9.8306421e+00 */
    { 0x414166c6, 0x43903411, 0x43963f47 },  /*  70:  1.2087591e+01  2.8840677e+02  3.0049436e+02 */
    { 0x40c12d26, 0xbff00486, 0x40852c04 },  /*  71:  6.0367613e+00 -1.8751380e+00  4.1616232e+00 */
    { 0x3bdf2eb6, 0xc5a3c470, 0xc5a3c462 },  /*  72:  6.8109883e-03 -5.2405547e+03 -5.2405479e+03 */
    { 0xbfc8ae1f, 0xbdde02a2, 0xbfd68e49 },  /*  73: -1.5678138e+00 -1.0840346e-01 -1.6762172e+00 */
    { 0xb74e47a8, 0xbd4cd843, 0xbd4ce527 },  /*  74: -1.2295241e-05 -5.0010931e-02 -5.0023226e-02 */
    { 0x3f3c6660, 0x3fd98178, 0x401bda54 },  /*  75:  7.3593712e-01  1.6992636e+00  2.4352007e+00 */
    { 0xbf16fc4b, 0x3f487ded, 0x3e460688 },  /*  76: -5.8978719e-01  7.8317147e-01  1.9338429e-01 */
    { 0xb193fc8f, 0x5256c36d, 0x5256c36d },  /*  77: -4.3069757e-09  2.3060043e+11  2.3060043e+11 */
    { 0xc1a320fb, 0xbfce5b5e, 0xc1b006b1 },  /*  78: -2.0391104e+01 -1.6121633e+00 -2.2003267e+01 */
    { 0x3de03686, 0x40f8f1bf, 0x40fc7299 },  /*  79:  1.0947900e-01  7.7795100e+00  7.8889890e+00 */
    { 0xbf0a78d0, 0x3f1893a4, 0x3d61ad40 },  /*  80: -5.4090595e-01  5.9600282e-01  5.5096865e-02 */
    { 0xbe5313e0, 0xbe047bdb, 0xbeabc7de },  /*  81: -2.0613050e-01 -1.2937872e-01 -3.3550923e-01 */
    { 0xbffa2306, 0xc3d10abc, 0xc3d204df },  /*  82: -1.9541938e+00 -4.1808386e+02 -4.2003806e+02 */
    { 0xbfdceb28, 0x2c8e90dd, 0xbfdceb28 },  /*  83: -1.7259264e+00  4.0519658e-12 -1.7259264e+00 */
    { 0xbf1f1f23, 0xc304acfc, 0xc3054c1b },  /*  84: -6.2156886e-01 -1.3267572e+02 -1.3329729e+02 */
    { 0x40ebbdfb, 0x40e7f576, 0x4169d9b8 },  /*  85:  7.3669410e+00  7.2487135e+00  1.4615654e+01 */
    { 0xc11df495, 0xbe16ff65, 0xc1205093 },  /*  86: -9.8722124e+00 -1.4745863e-01 -1.0019671e+01 */
    { 0x3f1e3f5a, 0x3e2e2473, 0x3f49c877 },  /*  87:  6.1815417e-01  1.7006092e-01  7.8821509e-01 */
    { 0x3fba0871, 0xbe7e8614, 0x3f9a37ae },  /*  88:  1.4533826e+00 -2.4855834e-01  1.2048243e+00 */
    { 0x408cfb1e, 0x3f081858, 0x409dfe29 },  /*  89:  4.4056540e+00  5.3162146e-01  4.9372754e+00 */
    { 0x3b65b098, 0xc00667f3, 0xc0062e87 },  /*  90:  3.5047885e-03 -2.1000946e+00 -2.0965898e+00 */
    { 0x3fc16e5e, 0x3fd845ab, 0x404cda04 },  /*  91:  1.5111806e+00  1.6896261e+00  3.2008067e+00 */
    { 0xbddac78c, 0xc2aa2136, 0xc2aa57e8 },  /*  92: -1.0682592e-01 -8.5064865e+01 -8.5171691e+01 */
    { 0xbfdf1f53, 0x718b7c39, 0x718b7c39 },  /*  93: -1.7431434e+00  1.3813950e+30  1.3813950e+30 */
    { 0xbe0d9bb9, 0xc12e3895, 0xc1306f04 },  /*  94: -1.3828935e-01 -1.0888814e+01 -1.1027103e+01 */
    { 0x3db46906, 0x407cd726, 0x40813d37 },  /*  95:  8.8090941e-02  3.9506316e+00  4.0387226e+00 */
    { 0xce11dca7, 0xbbd9da30, 0xce11dca7 },  /*  96: -6.1178925e+08 -6.6483244e-03 -6.1178925e+08 */
    { 0xac03e362, 0x4700dde0, 0x4700dde0 },  /*  97: -1.8742442e-12  3.2989875e+04  3.2989875e+04 */
    { 0x3f94f3fd, 0xc1eb7605, 0xc1e226c5 },  /*  98:  1.1636959e+00 -2.9432627e+01 -2.8268931e+01 */
    { 0x76101ea0, 0xbf209f2a, 0x76101ea0 },  /*  99:  7.3077334e+32 -6.2742865e-01  7.3077334e+32 */
    { 0xbe60bcf7, 0x3f875421, 0x3f567904 },  /* 100: -2.1947084e-01  1.0572549e+00  8.3778407e-01 */
    { 0xbb5166c0, 0xb0e5e7b9, 0xbb5166c7 },  /* 101: -3.1952113e-03 -1.6727802e-09 -3.1952130e-03 */
    { 0xbe4d4516, 0x4178bcee, 0x417587da },  /* 102: -2.0045885e-01  1.5546125e+01  1.5345667e+01 */
    { 0x3ff4fd29, 0x3ffe3f29, 0x40799e29 },  /* 103:  1.9139758e+00  1.9863025e+00  3.9002783e+00 */
    { 0xc5855426, 0xbff806e2, 0xc58563a6 },  /* 104: -4.2665186e+03 -1.9377100e+00 -4.2684563e+03 */
    { 0xbf401186, 0x4091bf96, 0x40737aca },  /* 105: -7.5026739e-01  4.5546370e+00  3.8043696e+00 */
    { 0xbfb1196e, 0x3e557585, 0xbf966abd },  /* 106: -1.3835886e+00  2.0845611e-01 -1.1751324e+00 */
    { 0xc13bf0cc, 0x4224eea9, 0x41ebe4ec },  /* 107: -1.1746288e+01  4.1233067e+01  2.9486778e+01 */
    { 0x3e63c98a, 0xbb348593, 0x3e60f774 },  /* 108:  2.2244850e-01 -2.7545437e-03  2.1969395e-01 */
    { 0x4179fdde, 0x3fe710f2, 0x418b6ffe },  /* 109:  1.5624479e+01  1.8052046e+00  1.7429684e+01 */
    { 0xbd84d3e1, 0x427a2452, 0x4279e1e8 },  /* 110: -6.4857252e-02  6.2535469e+01  6.2470612e+01 */
    { 0xbf150b99, 0xbdcb55fc, 0xbf2e7658 },  /* 111: -5.8220822e-01 -9.9285096e-02 -6.8149331e-01 */
    { 0x4176be5a, 0xc603c84a, 0xc6038a9a },  /* 112:  1.5421473e+01 -8.4340723e+03 -8.4186508e+03 */
    { 0x80000000, 0x3f306c94, 0x3f306c94 },  /* 113: -0.0000000e+00  6.8915677e-01  6.8915677e-01 */
    { 0x4ee82502, 0x40d2eee2, 0x4ee82502 },  /* 114:  1.9473697e+09  6.5916605e+00  1.9473697e+09 */
    { 0xbde00782, 0x4268f619, 0x42688615 },  /* 115: -1.0938932e-01  5.8240330e+01  5.8130940e+01 */
    { 0x3f35242f, 0xc10e7412, 0xc10321cf },  /* 116:  7.0758337e-01 -8.9033375e+00 -8.1957541e+00 */
    { 0x43146a9a, 0x4df6073a, 0x4df6073f },  /* 117:  1.4841641e+02  5.1595859e+08  5.1595874e+08 */
    { 0xbf20aed9, 0x3e49c60f, 0xbedc7aaa },  /* 118: -6.2766796e-01  1.9704460e-01 -4.3062337e-01 */
    { 0xbf131eec, 0xbf11f6a4, 0xbf928ac8 },  /* 119: -5.7469058e-01 -5.7016969e-01 -1.1448603e+00 */
    { 0xbf15397c, 0x3df9377f, 0xbeec2518 },  /* 120: -5.8290839e-01  1.2168788e-01 -4.6122051e-01 */
    { 0x3d404abc, 0xc1be0177, 0xc1bda152 },  /* 121:  4.6946272e-02 -2.3750715e+01 -2.3703769e+01 */
    { 0x3fe65b3c, 0x3fee97b8, 0x406a797a },  /* 122:  1.7996593e+00  1.8640051e+00  3.6636643e+00 */
    { 0x0d1eb49f, 0xbfcd0122, 0xbfcd0122 },  /* 123:  4.8904924e-31 -1.6015971e+00 -1.6015971e+00 */
    { 0xc20773f4, 0x3b0efb1d, 0xc20771b8 },  /* 124: -3.3863235e+01  2.1817156e-03 -3.3861054e+01 */
    { 0xbf5c022c, 0x3d2c97c0, 0xbf5138b0 },  /* 125: -8.5940814e-01  4.2136908e-02 -8.1727123e-01 */
    { 0xbf1b1c67, 0x80000000, 0xbf1b1c67 },  /* 126: -6.0590214e-01 -0.0000000e+00 -6.0590214e-01 */
    { 0xc5bcc75b, 0x3f0473b4, 0xc5bcc337 },  /* 127: -6.0409194e+03  5.1739049e-01 -6.0404020e+03 */
    { 0x3dbf93ff, 0xc145636a, 0xc143e442 },  /* 128:  9.3543999e-02 -1.2336771e+01 -1.2243227e+01 */
    { 0x4212cc12, 0xc40fd080, 0xc406a3bf },  /* 129:  3.6699287e+01 -5.7525781e+02 -5.3855853e+02 */
    { 0xbe99df2c, 0xc4fe62d3, 0xc4fe6c71 },  /* 130: -3.0053079e-01 -2.0350883e+03 -2.0353888e+03 */
    { 0x00000000, 0xbf0d7fb2, 0xbf0d7fb2 },  /* 131:  0.0000000e+00 -5.5272973e-01 -5.5272973e-01 */
    { 0x3fdb82d3, 0x3f496972, 0x40201bc6 },  /* 132:  1.7149299e+00  7.8676522e-01  2.5016952e+00 */
    { 0x42750179, 0xbfc1e236, 0x426ef267 },  /* 133:  6.1251438e+01 -1.5147159e+00  5.9736722e+01 */
    { 0x3f1712e7, 0xc074984a, 0xc04ed390 },  /* 134:  5.9013218e-01 -3.8217950e+00 -3.2316628e+00 */
    { 0xbf09f981, 0xbd6061d1, 0xbf17ff9e },  /* 135: -5.3896338e-01 -5.4780785e-02 -5.9374416e-01 */
    { 0xb71b62c3, 0xf2b793ea, 0xf2b793ea },  /* 136: -9.2617147e-06 -7.2722655e+30 -7.2722655e+30 */
    { 0x3fb63e86, 0x43098fcd, 0x430afc4a },  /* 137:  1.4237831e+00  1.3756172e+02  1.3898550e+02 */
    { 0x4d390d00, 0x3ff2fbcb, 0x4d390d00 },  /* 138:  1.9403981e+08  1.8983091e+00  1.9403981e+08 */
    { 0x40c529e8, 0x3f581ea1, 0x40e02dbc },  /* 139:  6.1613655e+00  8.4421736e-01  7.0055829e+00 */
    { 0x43200480, 0x40cb3364, 0x43265e1b },  /* 140:  1.6001758e+02  6.3500233e+00  1.6636760e+02 */
    { 0xbe58af1c, 0x44a13e14, 0x44a1374f },  /* 141: -2.1160549e-01  1.2899399e+03  1.2897283e+03 */
    { 0xbac98b80, 0xc068b947, 0xc068d278 },  /* 142: -1.5376657e-03 -3.6363084e+00 -3.6378461e+00 */
    { 0x3f2f4856, 0x4275c4f6, 0x42788217 },  /* 143:  6.8469751e-01  6.1442345e+01  6.2127042e+01 */
    { 0x43badba6, 0x3e5132ea, 0x43baf5cc },  /* 144:  3.7371600e+02  2.0429578e-01  3.7392030e+02 */
    { 0x41a281c4, 0xc1a4e6c8, 0xbe994100 },  /* 145:  2.0313362e+01 -2.0612686e+01 -2.9932404e-01 */
    { 0x3ee3a71a, 0x3f47b81a, 0x3f9cc5d4 },  /* 146:  4.4463426e-01  7.8015292e-01  1.2247872e+00 */
    { 0xbd13af48, 0xc4a3f49f, 0xc4a3f5c6 },  /* 147: -3.6055833e-02 -1.3116444e+03 -1.3116805e+03 */
    { 0xbfcdd3be, 0xbfbf7a65, 0xc046a712 },  /* 148: -1.6080244e+00 -1.4959227e+00 -3.1039470e+00 */
    { 0x3f157196, 0x3c3dc34b, 0x3f1868a3 },  /* 149:  5.8376443e-01  1.1582206e-02  5.9534664e-01 */
    { 0xbfe9861d, 0x52d51622, 0x52d51622 },  /* 150: -1.8244053e+00  4.5759968e+11  4.5759968e+11 */
    { 0x3efad56b, 0x58dac7c1, 0x58dac7c1 },  /* 151:  4.8990950e-01  1.9244118e+15  1.9244118e+15 */
    { 0x00000000, 0xc0ed24a3, 0xc0ed24a3 },  /* 152:  0.0000000e+00 -7.4107223e+00 -7.4107223e+00 */
    { 0x42468dc9, 0xbf163397, 0x424434fb },  /* 153:  4.9638462e+01 -5.8672470e-01  4.9051737e+01 */
    { 0xc68ee9cc, 0x40641506, 0xc68ee2ab },  /* 154: -1.8292898e+04  3.5637832e+00 -1.8289335e+04 */
    { 0x3f1172e8, 0xbe165c22, 0x3ed7b7bf },  /* 155:  5.6815958e-01 -1.4683583e-01  4.2132375e-01 */
    { 0xbde89b67, 0xbd748058, 0xbe316dca },  /* 156: -1.1357766e-01 -5.9692711e-02 -1.7327037e-01 */
    { 0x3fe1d899, 0x41350d8f, 0x415148a2 },  /* 157:  1.7644225e+00  1.1315810e+01  1.3080233e+01 */
    { 0x4251bdf9, 0xb8765c83, 0x4251bdea },  /* 158:  5.2435520e+01 -5.8737129e-05  5.2435461e+01 */
    { 0xc189d2f6, 0xc1dd19ec, 0xc2337671 },  /* 159: -1.7228008e+01 -2.7637657e+01 -4.4865665e+01 */
    { 0x43c1b71c, 0x40eb52e3, 0x43c56468 },  /* 160:  3.8743054e+02  7.3538680e+00  3.9478441e+02 */
    { 0xbfda932a, 0xbbece292, 0xbfdb800d },  /* 161: -1.7076161e+00 -7.2291577e-03 -1.7148452e+00 */
    { 0x3ff6ba43, 0xc32d3835, 0xc32b4ac0 },  /* 162:  1.9275593e+00 -1.7321956e+02 -1.7129200e+02 */
    { 0x3fc2cc33, 0x3f0e3bf4, 0x4004f516 },  /* 163:  1.5218567e+00  5.5560231e-01  2.0774590e+00 */
    { 0xc40dc68e, 0x3e32be7b, 0xc40dbb62 },  /* 164: -5.6710242e+02  1.7455475e-01 -5.6692786e+02 */
    { 0x3dbf876a, 0xbf0c92c8, 0xbee943b6 },  /* 165:  9.3520001e-02 -5.4911470e-01 -4.5559470e-01 */
    { 0xa6b16fb2, 0x42298b2c, 0x42298b2c },  /* 166: -1.2312117e-15  4.2385910e+01  4.2385910e+01 */
    { 0xbf13d115, 0xbcda4357, 0xbf1aa330 },  /* 167: -5.7740909e-01 -2.6643438e-02 -6.0405253e-01 */
    { 0xbffe20e7, 0x3e635cbe, 0xbfe1b54f },  /* 168: -1.9853791e+00  2.2203347e-01 -1.7633456e+00 */
    { 0xbf324401, 0x3d358e78, 0xbf26eb1a },  /* 169: -6.9635016e-01  4.4325322e-02 -6.5202484e-01 */
    { 0xc15d4b26, 0xbe02f229, 0xc15f56ef },  /* 170: -1.3830847e+01 -1.2787689e-01 -1.3958724e+01 */
    { 0xbf14625e, 0xbfd3d2a8, 0xc00f01ec },  /* 171: -5.7962596e-01 -1.6548662e+00 -2.2344922e+00 */
    { 0xc0b05b27, 0xbd7339c4, 0xc0b2419b },  /* 172: -5.5111270e+00 -5.9381261e-02 -5.5705083e+00 */
    { 0xbe9b8855, 0x3bba04f0, 0xbe98a041 },  /* 173: -3.0377451e-01  5.6768581e-03 -2.9809765e-01 */
    { 0x3d11922e, 0x3b86c5d0, 0x3d226ae8 },  /* 174:  3.5539798e-02  4.1129366e-03  3.9652735e-02 */
    { 0xbffdf699, 0x3f08c465, 0xbfb99466 },  /* 175: -1.9840881e+00  5.3424674e-01 -1.4498413e+00 */
    { 0xbdf468ea, 0x3fe957de, 0x3fda114f },  /* 176: -1.1934073e-01  1.8229940e+00  1.7036533e+00 */
    { 0xc0c10bae, 0xba7c0d30, 0xc0c1138e },  /* 177: -6.0326757e+00 -9.6150022e-04 -6.0336372e+00 */
    { 0xbfb644f6, 0xbfadf0a0, 0xc0321acb },  /* 178: -1.4239795e+00 -1.3589058e+00 -2.7828853e+00 */
    { 0xb487e7fb, 0xbdbebb51, 0xbdbebb73 },  /* 179: -2.5314498e-07 -9.3130715e-02 -9.3130968e-02 */
    { 0xbe4395a3, 0x41e4ed6f, 0x41e36644 },  /* 180: -1.9100051e-01  2.8615934e+01  2.8424934e+01 */
    { 0x3b0f08a4, 0xbda80b9a, 0xbda39355 },  /* 181:  2.1825219e-03 -8.2053378e-02 -7.9870856e-02 */
    { 0xbcd3d609, 0xc0c3bc9f, 0xc0c49075 },  /* 182: -2.5858896e-02 -6.1167750e+00 -6.1426339e+00 */
    { 0xbcad035f, 0x411808a7, 0x4117b225 },  /* 183: -2.1119772e-02  9.5021124e+00  9.4809926e+00 */
    { 0x3e6bdb39, 0x3e84b011, 0x3efa9dae },  /* 184:  2.3032846e-01  2.5915578e-01  4.8948424e-01 */
    { 0x3b07b7d6, 0xbf066700, 0xbf05df48 },  /* 185:  2.0708940e-03 -5.2500916e-01 -5.2293826e-01 */
    { 0xbfdd114c, 0xbfc168bc, 0xc04f3d04 },  /* 186: -1.7270904e+00 -1.5110087e+00 -3.2380991e+00 */
    { 0x3e1129e0, 0xc1d885be, 0xc1d7636a },  /* 187:  1.4176130e-01 -2.7065304e+01 -2.6923542e+01 */
    { 0xc171212b, 0x3e3eef0e, 0xc16e256f },  /* 188: -1.5070598e+01  1.8645880e-01 -1.4884139e+01 */
    { 0xbf1c8637, 0x3f0ac299, 0xbd8e1cf0 },  /* 189: -6.1142296e-01  5.4203182e-01 -6.9391131e-02 */
    { 0x4730a91b, 0xbf016d03, 0x4730a89a },  /* 190:  4.5225105e+04 -5.0556964e-01  4.5224600e+04 */
    { 0xbfecd95c, 0x3fde3417, 0xbdea5450 },  /* 191: -1.8503833e+00  1.7359647e+00 -1.1441863e-01 */
    { 0x4365b711, 0x3d57ce5f, 0x4365c48e },  /* 192:  2.2971510e+02  5.2687045e-02  2.2976779e+02 */
    { 0x411897ff, 0x3f943407, 0x412b1e80 },  /* 193:  9.5371084e+00  1.1578377e+00  1.0694946e+01 */
    { 0x3ff5b5de, 0x3e36c80e, 0x40064770 },  /* 194:  1.9196126e+00  1.7849752e-01  2.0981102e+00 */
    { 0x4001410f, 0xbb63ae6d, 0x40010823 },  /* 195:  2.0195959e+00 -3.4741417e-03  2.0161217e+00 */
    { 0xbe689ab9, 0xbfd30769, 0xbff01ac0 },  /* 196: -2.2715272e-01 -1.6486636e+00 -1.8758164e+00 */
    { 0xbdd70cf0, 0xbf0eaf77, 0xbf299115 },  /* 197: -1.0500515e-01 -5.5736488e-01 -6.6237003e-01 */
    { 0xc0f0f9f2, 0x3c0ee9ea, 0xc0f0b27d },  /* 198: -7.5305109e+00  8.7227616e-03 -7.5217881e+00 */
    { 0xc1ff9914, 0xc124a84f, 0xc228f69e },  /* 199: -3.1949745e+01 -1.0291091e+01 -4.2240836e+01 */
    { 0x40fa1620, 0x41609d0c, 0x41aed40e },  /* 200:  7.8152008e+00  1.4038342e+01  2.1853542e+01 */
    { 0x3d71373f, 0xc2ff19a3, 0xc2fefb7c },  /* 201:  5.8890577e-02 -1.2755007e+02 -1.2749118e+02 */
    { 0x3d0e4bb9, 0x3e00eab8, 0x3e247da6 },  /* 202:  3.4740184e-02  1.2589538e-01  1.6063556e-01 */
    { 0x40d90c8b, 0xbfde4e00, 0x40a1790b },  /* 203:  6.7827811e+00 -1.7367554e+00  5.0460258e+00 */
    { 0x3fb51eee, 0x3596464a, 0x3fb51ef7 },  /* 204:  1.4150064e+00  1.1196328e-06  1.4150075e+00 */
    { 0xc15ad121, 0xbfed0586, 0xc17871d2 },  /* 205: -1.3676057e+01 -1.8517311e+00 -1.5527788e+01 */
    { 0x408a2dcf, 0xc6f507a5, 0xc6f4ff02 },  /* 206:  4.3180919e+00 -3.1363822e+04 -3.1359504e+04 */
    { 0xbb0c3325, 0xc27e4da6, 0xc27e4fd7 },  /* 207: -2.1392789e-03 -6.3575829e+01 -6.3577968e+01 */
    { 0x4428f72e, 0x3dabfb81, 0x4428fc8e },  /* 208:  6.7586218e+02  8.3975799e-02  6.7594616e+02 */
    { 0xc0e1d330, 0xba887bb4, 0xc0e1dbb8 },  /* 209: -7.0570297e+00 -1.0412843e-03 -7.0580710e+00 */
    { 0x40d6e904, 0xba7d5374, 0x40d6e119 },  /* 210:  6.7159443e+00 -9.6636196e-04  6.7149779e+00 */
    { 0xbfc69c06, 0xbf32cec0, 0xc01001b3 },  /* 211: -1.5516365e+00 -6.9846725e-01 -2.2501037e+00 */
    { 0xbe727955, 0xc963b462, 0xc963b466 },  /* 212: -2.3679097e-01 -9.3267812e+05 -9.3267836e+05 */
    { 0x439fd4d8, 0xbab66123, 0x439fd4aa },  /* 213:  3.1966284e+02 -1.3914447e-03  3.1966145e+02 */
    { 0x40af1a38, 0x3bdca56a, 0x40af5161 },  /* 214:  5.4719505e+00  6.7335861e-03  5.4786841e+00 */
    { 0xbcbd14e1, 0x3ceb6182, 0x3bb93284 },  /* 215: -2.3081245e-02  2.8733019e-02  5.6517739e-03 */
    { 0xbc3dc861, 0x48a260e4, 0x48a260e4 },  /* 216: -1.1583419e-02  3.3255112e+05  3.3255111e+05 */
    { 0xba2cadfd, 0x42982162, 0x4298210c },  /* 217: -6.5872056e-04  7.6065201e+01  7.6064542e+01 */
    { 0xbf2312a9, 0xbd55d3d1, 0xbf306fe6 },  /* 218: -6.3700348e-01 -5.2203957e-02 -6.8920744e-01 */
    { 0xc0b8e938, 0xbf3405f7, 0xc0cf69f7 },  /* 219: -5.7784691e+00 -7.0321602e-01 -6.4816851e+00 */
    { 0xbe29dab5, 0xc240c7df, 0xc24171ba },  /* 220: -1.6587336e-01 -4.8195187e+01 -4.8361060e+01 */
    { 0x4bd27d1d, 0xbfdb412b, 0x4bd27d1c },  /* 221:  2.7589178e+07 -1.7129263e+00  2.7589176e+07 */
    { 0x3b6c7bba, 0xbee7df66, 0xbee6066f },  /* 222:  3.6084489e-03 -4.5287627e-01 -4.4926782e-01 */
    { 0x42426e35, 0xbefa9c91, 0x424078fc },  /* 223:  4.8607624e+01 -4.8947576e-01  4.8118148e+01 */
    { 0x3eb0ad8f, 0xbe3a88ef, 0x3e26d22f },  /* 224:  3.4507415e-01 -1.8216299e-01  1.6291116e-01 */
    { 0x411857cb, 0x3b3adb1f, 0x41186379 },  /* 225:  9.5214338e+00  2.8511954e-03  9.5242850e+00 */
    { 0xbe8b9276, 0xbb2bcb82, 0xbe8cea0d },  /* 226: -2.7260178e-01 -2.6213829e-03 -2.7522317e-01 */
    { 0x3b0b414a, 0x3ff0525d, 0x3ff097fe },  /* 227:  2.1248632e-03  1.8775135e+00  1.8796384e+00 */
    { 0xc8b9abab, 0x3f003e66, 0xc8b9ab9b },  /* 228: -3.8025334e+05  5.0095212e-01 -3.8025284e+05 */
    { 0xbf06c543, 0xbfde4a9a, 0xc010d69e },  /* 229: -5.2644747e-01 -1.7366517e+00 -2.2630991e+00 */
    { 0x436a4bd9, 0xc5838ae6, 0xc578710e },  /* 230:  2.3429628e+02 -4.2093623e+03 -3.9750660e+03 */
    { 0xc242a6dc, 0x4359fd20, 0x43295369 },  /* 231: -4.8662949e+01  2.1798877e+02  1.6932582e+02 */
    { 0x3fd9ef7d, 0x4149e0f2, 0x41651ee2 },  /* 232:  1.7026211e+00  1.2617418e+01  1.4320039e+01 */
    { 0xc1fdca77, 0x3fcab573, 0xc1f11f20 },  /* 233: -3.1723860e+01  1.5836624e+00 -3.0140197e+01 */
    { 0xbfe19fc0, 0x41d7f954, 0x41c9df58 },  /* 234: -1.7626877e+00  2.6996742e+01  2.5234055e+01 */
    { 0x4008050e, 0x4075d936, 0x40beef22 },  /* 235:  2.1253085e+00  3.8413825e+00  5.9666910e+00 */
    { 0x3e553b1c, 0xc463801e, 0xc46372ca },  /* 236:  2.0823330e-01 -9.1000183e+02 -9.0979360e+02 */
    { 0x2ccec5db, 0xbcfb6e48, 0xbcfb6e48 },  /* 237:  5.8768385e-12 -3.0692235e-02 -3.0692235e-02 */
    { 0x41a0fe74, 0x3ea4a196, 0x41a390fa },  /* 238:  2.0124245e+01  3.2154530e-01  2.0445790e+01 */
    { 0xb77048f0, 0xc0b170a2, 0xc0b170c0 },  /* 239: -1.4322097e-05 -5.5449991e+00 -5.5450134e+00 */
    { 0x40197497, 0xbbde3135, 0x4019057e },  /* 240:  2.3977411e+00 -6.7807683e-03  2.3909603e+00 */
    { 0xbfe65026, 0x40e3ee71, 0x40aa5a68 },  /* 241: -1.7993209e+00  7.1228566e+00  5.3235357e+00 */
    { 0xbf5a88b9, 0xc11b1342, 0xc128bbce },  /* 242: -8.5364872e-01 -9.6922016e+00 -1.0545850e+01 */
    { 0x391019a5, 0xb729f569, 0x39057a4e },  /* 243:  1.3742463e-04 -1.0130324e-05  1.2729431e-04 */
    { 0xbf091fdb, 0x4094e86e, 0x4083c473 },  /* 244: -5.3564233e-01  4.6533728e+00  4.1177304e+00 */
    { 0x43e025cd, 0x3a1533be, 0x43e025e0 },  /* 245:  4.4829532e+02  5.6916091e-04  4.4829589e+02 */
    { 0x417050be, 0xbff131fb, 0x41522a7f },  /* 246:  1.5019712e+01 -1.8843378e+00  1.3135375e+01 */
    { 0xbe471ea3, 0xbfd70cc0, 0xbfeff094 },  /* 247: -1.9445281e-01 -1.6800766e+00 -1.8745294e+00 */
    { 0x3fc6e369, 0xbf22cfa4, 0x3f6af72e },  /* 248:  1.5538150e+00 -6.3598084e-01  9.1783416e-01 */
    { 0xbe6b2682, 0x3f14013e, 0x3eb26f3b },  /* 249: -2.2963908e-01  5.7814395e-01  3.4850487e-01 */
    { 0x41b02eda, 0xbf24559c, 0x41ab0c2d },  /* 250:  2.2022877e+01 -6.4193130e-01  2.1380945e+01 */
    { 0xca728c19, 0xbfb778d9, 0xca728c1f },  /* 251: -3.9738942e+06 -1.4333755e+00 -3.9738957e+06 */
    { 0xbe2935b2, 0x6c9fef27, 0x6c9fef27 },  /* 252: -1.6524389e-01  1.5467886e+27  1.5467886e+27 */
    { 0x3fe96cb2, 0xbfd710e9, 0x3e12de48 },  /* 253:  1.8236296e+00 -1.6802036e+00  1.4342606e-01 */
    { 0x3d215eee, 0xbff32210, 0xbfee1719 },  /* 254:  3.9397173e-02 -1.8994770e+00 -1.8600798e+00 */
    { 0xd894e9e5, 0xbf14f62f, 0xd894e9e5 },  /* 255: -1.3098583e+15 -5.8188146e-01 -1.3098583e+15 */
    { 0x455a3ef9, 0xbba1ecdb, 0x455a3ee5 },  /* 256:  3.4919358e+03 -4.9415655e-03  3.4919308e+03 */
    { 0x427fa593, 0xc253efe0, 0x412ed6cc },  /* 257:  6.3911694e+01 -5.2984253e+01  1.0927441e+01 */
    { 0xb7f818ae, 0x408c30bc, 0x408c307e },  /* 258: -2.9575396e-05  4.3809490e+00  4.3809194e+00 */
    { 0x413e2eff, 0xbd116318, 0x413d9d9c },  /* 259:  1.1886474e+01 -3.5494894e-02  1.1850979e+01 */
    { 0xbf2291dc, 0xc625e4e9, 0xc625e773 },  /* 260: -6.3503814e-01 -1.0617228e+04 -1.0617863e+04 */
    { 0xc01efcd7, 0x3fb9c743, 0xbf84326b },  /* 261: -2.4841821e+00  1.4513935e+00 -1.0327886e+00 */
    { 0xbe75688b, 0x3e3fc649, 0xbd568908 },  /* 262: -2.3965661e-01  1.8727984e-01 -5.2376777e-02 */
    { 0xbf2df173, 0x4274691b, 0x4271b155 },  /* 263: -6.7946547e-01  6.1102642e+01  6.0423177e+01 */
    { 0xbcd8527c, 0x416e2c56, 0x416dc02d },  /* 264: -2.6406519e-02  1.4885824e+01  1.4859418e+01 */
    { 0x39dff1ef, 0xc174c6d2, 0xc174c512 },  /* 265:  4.2714129e-04 -1.5298540e+01 -1.5298113e+01 */
    { 0xc3a61efb, 0xbd9d1931, 0xc3a628cd },  /* 266: -3.3224203e+02 -7.6708205e-02 -3.3231874e+02 */
    { 0x3e21722f, 0x4292a396, 0x4292f44f },  /* 267:  1.5766214e-01  7.3319504e+01  7.3477166e+01 */
    { 0xd83422ac, 0x40ab29ac, 0xd83422ac },  /* 268: -7.9224403e+14  5.3488369e+00 -7.9224403e+14 */
    { 0x40618cd1, 0xbf21f03d, 0x403910c2 },  /* 269:  3.5242198e+00 -6.3257200e-01  2.8916478e+00 */
    { 0xbfc52684, 0xbff24923, 0xc05bb7d4 },  /* 270: -1.5402379e+00 -1.8928570e+00 -3.4330949e+00 */
    { 0x3e8d50b6, 0xc00bd68e, 0xbff458ee },  /* 271:  2.7600640e-01 -2.1849704e+00 -1.9089640e+00 */
    { 0xbf0a2ef8, 0x3db63745, 0xbee6d01f },  /* 272: -5.3977919e-01  8.8972606e-02 -4.5080658e-01 */
    { 0xcabe2153, 0x3e95285a, 0xcabe2152 },  /* 273: -6.2301855e+06  2.9132348e-01 -6.2301852e+06 */
    { 0xc167f78b, 0x0f600812, 0xc167f78b },  /* 274: -1.4497935e+01  1.1045607e-29 -1.4497935e+01 */
    { 0x4193be9d, 0xbf222075, 0x418ead99 },  /* 275:  1.8468073e+01 -6.3330775e-01  1.7834765e+01 */
    { 0xc16e8dc9, 0xc103d90a, 0xc1b9336a },  /* 276: -1.4909616e+01 -8.2404881e+00 -2.3150104e+01 */
    { 0x3c9a8c73, 0x3da76e31, 0x3dce114e },  /* 277:  1.8865800e-02  8.1753142e-02  1.0061894e-01 */
    { 0xc27329a6, 0x3fcd0c57, 0xc26cc143 },  /* 278: -6.0790672e+01  1.6019391e+00 -5.9188733e+01 */
    { 0xbe812f5c, 0x40c283ec, 0x40ba70f6 },  /* 279: -2.5231445e-01  6.0786037e+00  5.8262893e+00 */
    { 0x4011084c, 0xb6827268, 0x4011083c },  /* 280:  2.2661314e+00 -3.8876206e-06  2.2661275e+00 */
    { 0xbff5692b, 0x41e127d2, 0x41d1d13f },  /* 281: -1.9172720e+00  2.8144444e+01  2.6227172e+01 */
    { 0xbf126880, 0x3fca6f65, 0x3f813b25 },  /* 282: -5.7190704e-01  1.5815245e+00  1.0096174e+00 */
    { 0xc2900eff, 0x3fd68db1, 0xc28cb4c8 },  /* 283: -7.2029289e+01  1.6761991e+00 -7.0353090e+01 */
    { 0x3b4ea627, 0xb8c053a2, 0x3b48a38a },  /* 284:  3.1532140e-03 -9.1708513e-05  3.0615055e-03 */
    { 0x3fd933be, 0x3d75e622, 0x3fe0e2ef },  /* 285:  1.6968915e+00  6.0033925e-02  1.7569255e+00 */
    { 0x3fb7e6c8, 0xbc03ee10, 0x3fb6deec },  /* 286:  1.4367304e+00 -8.0523640e-03  1.4286780e+00 */
    { 0x3e4ae65f, 0x3c9b46d9, 0x3e5e4f3a },  /* 287:  1.9814442e-01  1.8954681e-02  2.1709910e-01 */
    { 0xc10f245e, 0xbfcd9182, 0xc128d68e },  /* 288: -8.9463787e+00 -1.6060030e+00 -1.0552382e+01 */
    { 0x422fab4c, 0x3e5fd123, 0x42308b1d },  /* 289:  4.3917282e+01  2.1857123e-01  4.4135853e+01 */
    { 0xbf55a323, 0xc0075271, 0xc03cbb3a },  /* 290: -8.3452052e-01 -2.1144068e+00 -2.9489273e+00 */
    { 0xa4af6a61, 0xbfbaf314, 0xbfbaf314 },  /* 291: -7.6074365e-17 -1.4605432e+00 -1.4605432e+00 */
    { 0x41e20157, 0x3c7a178b, 0x41e2209a },  /* 292:  2.8250654e+01  1.5264402e-02  2.8265919e+01 */
    { 0x3f0d88b8, 0xc5ad109b, 0xc5ad0c2f },  /* 293:  5.5286741e-01 -5.5380757e+03 -5.5375228e+03 */
    { 0x5af48396, 0x39bfd35a, 0x5af48396 },  /* 294:  3.4412287e+16  3.6587828e-04  3.4412287e+16 */
    { 0x482e65f2, 0x4d01dc28, 0x4d0207c1 },  /* 295:  1.7858378e+05  1.3616806e+08  1.3634665e+08 */
    { 0xc76581ef, 0xbfce0b59, 0xc765838b },  /* 296: -5.8753934e+04 -1.6097213e+00 -5.8755543e+04 */
    { 0x3e88174e, 0xbceb772c, 0x3e72bfb6 },  /* 297:  2.6580280e-01 -2.8743349e-02  2.3705945e-01 */
    { 0x3db20abf, 0xbf16e492, 0xbf00a33a },  /* 298:  8.6934559e-02 -5.8942521e-01 -5.0249065e-01 */
    { 0x42e2fa8c, 0x3886c488, 0x42e2fa94 },  /* 299:  1.1348935e+02  6.4262247e-05  1.1348941e+02 */
    { 0x349b846f, 0xc0d83073, 0xc0d83072 },  /* 300:  2.8967358e-07 -6.7559142e+00 -6.7559139e+00 */
    { 0x3dfe7aaa, 0x3e7576fa, 0x3eba5a28 },  /* 301:  1.2425740e-01  2.3971167e-01  3.6396907e-01 */
    { 0x43054283, 0x3d8502c1, 0x43055323 },  /* 302:  1.3325981e+02  6.4946659e-02  1.3332476e+02 */
    { 0x4146fd5f, 0xbe2c2e59, 0x41444ca6 },  /* 303:  1.2436858e+01 -1.6814555e-01  1.2268713e+01 */
    { 0xc16a1420, 0xbbbb7391, 0xc16a2b8e },  /* 304: -1.4629913e+01 -5.7205637e-03 -1.4635634e+01 */
    { 0xbf8addd8, 0x3ca686c3, 0xbf8843bd },  /* 305: -1.0848951e+00  2.0327931e-02 -1.0645672e+00 */
    { 0x3f2aba71, 0xbfdddb03, 0xbf887dca },  /* 306:  6.6690737e-01 -1.7332462e+00 -1.0663388e+00 */
    { 0x3cc12c03, 0x43e7fc13, 0x43e7ff18 },  /* 307:  2.3580557e-02  4.6396933e+02  4.6399291e+02 */
    { 0xc0eda05c, 0x3c70f094, 0xc0ed27e4 },  /* 308: -7.4258251e+00  1.4705796e-02 -7.4111193e+00 */
    { 0xbf44d986, 0xbfcbefaa, 0xc0172e36 },  /* 309: -7.6894414e-01 -1.5932515e+00 -2.3621956e+00 */
    { 0x3f018cae, 0xbe1bf583, 0x3eb51e9a },  /* 310:  5.0605285e-01 -1.5230374e-01  3.5374911e-01 */
    { 0xb3a87bd4, 0x3d415059, 0x3d415044 },  /* 311: -7.8456338e-08  4.7195766e-02  4.7195688e-02 */
    { 0x422d4e3d, 0x3e90b2d4, 0x422e6fa3 },  /* 312:  4.3326405e+01  2.8261435e-01  4.3609019e+01 */
    { 0xc28b5d6f, 0xc1b09bf5, 0xc2b7846c },  /* 313: -6.9682487e+01 -2.2076151e+01 -9.1758638e+01 */
    { 0x3a7a95da, 0xc1c2c29b, 0xc1c2c0a6 },  /* 314:  9.5590728e-04 -2.4345022e+01 -2.4344066e+01 */
    { 0x516f0380, 0x40c93d50, 0x516f0380 },  /* 315:  6.4159744e+10  6.2887344e+00  6.4159744e+10 */
    { 0xbc6ceacc, 0xc001789d, 0xc0026588 },  /* 316: -1.4460277e-02 -2.0229867e+00 -2.0374469e+00 */
    { 0x3ef8e151, 0xbfdbfa02, 0xbf9dc1ae },  /* 317:  4.8609403e-01 -1.7185671e+00 -1.2324731e+00 */
    { 0xbcb15505, 0xbff2949b, 0xbff559ef },  /* 318: -2.1646986e-02 -1.8951601e+00 -1.9168071e+00 */
    { 0xb5432402, 0x3f79c82a, 0x3f79c81e },  /* 319: -7.2695559e-07  9.7571051e-01  9.7570978e-01 */
    { 0x40885c84, 0xe8461764, 0xe8461764 },  /* 320:  4.2612934e+00 -3.7418402e+24 -3.7418402e+24 */
    { 0xbd07070f, 0x3f045623, 0x3ef7cb64 },  /* 321: -3.2965716e-02  5.1693934e-01  4.8397363e-01 */
    { 0xbc6916fa, 0x3c4317e9, 0xbb17fc44 },  /* 322: -1.4226669e-02  1.1907556e-02 -2.3191134e-03 */
    { 0xbff31843, 0xbf15a1e6, 0xc01ef49b },  /* 323: -1.8991779e+00 -5.8450162e-01 -2.4836795e+00 */
    { 0xc243f6ae, 0x40d4b7d0, 0xc2295fb4 },  /* 324: -4.8990898e+01  6.6474380e+00 -4.2343460e+01 */
    { 0x3e8e0d03, 0xbfd9dafa, 0xbfb657b9 },  /* 325:  2.7744302e-01 -1.7019951e+00 -1.4245521e+00 */
    { 0xc11a4230, 0xbff600d9, 0xc139024b },  /* 326: -9.6411591e+00 -1.9219009e+00 -1.1563060e+01 */
    { 0xbf1912e5, 0x40b34892, 0x40a02635 },  /* 327: -5.9794456e-01  5.6026087e+00  5.0046641e+00 */
    { 0xbefabfcb, 0xc8c4b257, 0xc8c4b267 },  /* 328: -4.8974451e-01 -4.0283472e+05 -4.0283521e+05 */
    { 0xbb637d6d, 0xb81b617d, 0xbb65eaf3 },  /* 329: -3.4712211e-03 -3.7045673e-05 -3.5082667e-03 */
    { 0xc143798b, 0xc0cb8f95, 0xc194a0ab },  /* 330: -1.2217174e+01 -6.3612771e+00 -1.8578451e+01 */
    { 0x3fc9c7ce, 0x3fd8c783, 0x405147a8 },  /* 331:  1.5764101e+00  1.6935886e+00  3.2699987e+00 */
    { 0x400c0d00, 0x424f65e3, 0x425826b3 },  /* 332:  2.1882935e+00  5.1849499e+01  5.4037792e+01 */
    { 0x3f12f207, 0xbfcb94dc, 0xbf821bd8 },  /* 333:  5.7400554e-01 -1.5904803e+00 -1.0164748e+00 */
    { 0xbe5cfda0, 0x3df3305c, 0xbdc6cae4 },  /* 334: -2.1581125e-01  1.1874458e-01 -9.7066671e-02 */
    { 0x3fdfea37, 0x3d54bc11, 0x3fe69018 },  /* 335:  1.7493352e+00  5.1937167e-02  1.8012723e+00 */
    { 0xb8c57c1d, 0xc0ee8b7b, 0xc0ee8c40 },  /* 336: -9.4168099e-05 -7.4545264e+00 -7.4546206e+00 */
    { 0x4097733f, 0xbfabebe2, 0x4058f08d },  /* 337:  4.7328181e+00 -1.3431361e+00  3.3896821e+00 */
    { 0x50ddb85a, 0x42a0d66d, 0x50ddb85a },  /* 338:  2.9758771e+10  8.0418800e+01  2.9758771e+10 */
    { 0x3ef72624, 0x3c494959, 0x3efd706f },  /* 339:  4.8271286e-01  1.2285554e-02  4.9499842e-01 */
    { 0xc1312da6, 0xc001e215, 0xc151a62b },  /* 340: -1.1073645e+01 -2.0294240e+00 -1.3103069e+01 */
    { 0x3dccc28d, 0x3fc68915, 0x3fd3553e },  /* 341:  9.9980451e-02  1.5510584e+00  1.6510389e+00 */
    { 0x3ff933b8, 0xbefb4927, 0x3fba616e },  /* 342:  1.9468908e+00 -4.9079248e-01  1.4560983e+00 */
    { 0x41350ed7, 0x3dc80b7e, 0x41369eee },  /* 343:  1.1316123e+01  9.7678170e-02  1.1413801e+01 */
    { 0xbc3fddb3, 0xbf1a0936, 0xbf1d08ad },  /* 344: -1.1710572e-02 -6.0170305e-01 -6.1341362e-01 */
    { 0x3ffa1ebd, 0x3e562aa4, 0x400a7209 },  /* 345:  1.9540631e+00  2.0914704e-01  2.1632101e+00 */
    { 0xcfcfed6e, 0x3fdf840d, 0xcfcfed6e },  /* 346: -6.9768878e+09  1.7462174e+00 -6.9768878e+09 */
    { 0xbdbc0c14, 0xb6317771, 0xbdbc0d77 },  /* 347: -9.1819912e-02 -2.6444579e-06 -9.1822557e-02 */
    { 0xb3be55e7, 0x3f32ca2b, 0x3f32ca2a },  /* 348: -8.8631900e-08  6.9839734e-01  6.9839725e-01 */
    { 0x3bec8f36, 0x41684c35, 0x416869c7 },  /* 349:  7.2192205e-03  1.4518605e+01  1.4525824e+01 */
    { 0xc1079634, 0x45bf8db0, 0x45bf49e5 },  /* 350: -8.4741707e+00  6.1297109e+03  6.1212368e+03 */
    { 0xbf917936, 0xbd473ec7, 0xbf97b32c },  /* 351: -1.1365116e+00 -4.8643854e-02 -1.1851554e+00 */
    { 0xbe7aa65a, 0x3f534e5b, 0x3f14a4c4 },  /* 352: -2.4477521e-01  8.2541436e-01  5.8063915e-01 */
    { 0x3b775fb9, 0x41d4f728, 0x41d4fee3 },  /* 353:  3.7746264e-03  2.6620682e+01  2.6624456e+01 */
    { 0xbf42f67d, 0x3db5612c, 0xbf2c4a58 },  /* 354: -7.6157361e-01  8.8564247e-02 -6.7300937e-01 */
    { 0xbee12812, 0x3e3c4fdb, 0xbe830024 },  /* 355: -4.3975884e-01  1.8389837e-01 -2.5586046e-01 */
    { 0x3b65ea0f, 0xc0cfb1e1, 0xc0cf9524 },  /* 356:  3.5082137e-03 -6.4904637e+00 -6.4869555e+00 */
    { 0x3fddf3b1, 0xc0f64dc4, 0xc0bed0d8 },  /* 357:  1.7339994e+00 -7.6969929e+00 -5.9629935e+00 */
    { 0x3f3fbd2d, 0x40d149fe, 0x40e941a4 },  /* 358:  7.4898034e-01  6.5402822e+00  7.2892626e+00 */
    { 0xbefd625c, 0x504f0133, 0x504f0133 },  /* 359: -4.9489105e-01  1.3891849e+10  1.3891849e+10 */
    { 0x3db26efa, 0x40c23a87, 0x40c50443 },  /* 360:  8.7125733e-02  6.0696445e+00  6.1567702e+00 */
    { 0xbc49014f, 0x00000000, 0xbc49014f },  /* 361: -1.2268378e-02  0.0000000e+00 -1.2268378e-02 */
    { 0xbf2db95b, 0x3e3a742d, 0xbefe38a0 },  /* 362: -6.7860955e-01  1.8208380e-01 -4.9652575e-01 */
    { 0xbf38ea9e, 0xbf38f15f, 0xbfb8edfe },  /* 363: -7.2232997e-01 -7.2243303e-01 -1.4447630e+00 */
    { 0xbe7c4738, 0xbee5dbbc, 0xbf31ffac },  /* 364: -2.4636543e-01 -4.4894207e-01 -6.9530749e-01 */
    { 0x3e0ecc5e, 0x3df5857c, 0x3e84c78e },  /* 365:  1.3945147e-01  1.1988351e-01  2.5933498e-01 */
    { 0xc1caf47c, 0x40843797, 0xc1a9e696 },  /* 366: -2.5369377e+01  4.1317859e+00 -2.1237591e+01 */
    { 0xc39df74a, 0x3f202a24, 0xc39da735 },  /* 367: -3.1593195e+02  6.2564301e-01 -3.1530630e+02 */
    { 0xc2d01209, 0x3f5c7062, 0xc2ce5928 },  /* 368: -1.0403522e+02  8.6108983e-01 -1.0317414e+02 */
    { 0x3f0f825a, 0x41ab290f, 0x41afa522 },  /* 369:  5.6058276e-01  2.1395048e+01  2.1955631e+01 */
    { 0x3dd77f86, 0xbbee6564, 0x3dc89930 },  /* 370:  1.0522370e-01 -7.2752703e-03  9.7948430e-02 */
    { 0xc084a09b, 0xca22544d, 0xca22545e },  /* 371: -4.1446052e+00 -2.6596032e+06 -2.6596074e+06 */
    { 0xc17ac440, 0x498b3711, 0x498b3694 },  /* 372: -1.5672913e+01  1.1404501e+06  1.1404345e+06 */
    { 0x80000000, 0x527179fe, 0x527179fe },  /* 373: -0.0000000e+00  2.5928345e+11  2.5928345e+11 */
    { 0xbfc93dd4, 0xbe208bc9, 0xbfdd4f4d },  /* 374: -1.5721993e+00 -1.5678324e-01 -1.7289826e+00 */
    { 0xbf2322b9, 0x3fe5cdfe, 0x3f943ca2 },  /* 375: -6.3724858e-01  1.7953489e+00  1.1581003e+00 */
    { 0x39e24a63, 0xbff7152e, 0xbff70709 },  /* 376:  4.3161502e-04 -1.9303339e+00 -1.9299022e+00 */
    { 0x3da4dcf5, 0xbe065dfc, 0xbd4fbe06 },  /* 377:  8.0499567e-02 -1.3121790e-01 -5.0718330e-02 */
    { 0xbe3892a8, 0x42637af6, 0x4262c263 },  /* 378: -1.8024695e-01  5.6870079e+01  5.6689832e+01 */
    { 0xbfbd6f94, 0xbde14d10, 0xbfcb8465 },  /* 379: -1.4799676e+00 -1.1001027e-01 -1.5899779e+00 */
    { 0x3a3ef777, 0xbe0ca536, 0xbe0be63f },  /* 380:  7.2847999e-04 -1.3734898e-01 -1.3662050e-01 */
    { 0xbe6bf255, 0x3feb4987, 0x3fcdcb3c },  /* 381: -2.3041661e-01  1.8381814e+00  1.6077648e+00 */
    { 0xbc9df168, 0xbc19b644, 0xbceacc8a },  /* 382: -1.9280151e-02 -9.3818344e-03 -2.8661985e-02 */
    { 0x3f1a2f8d, 0xbbc31138, 0x3f18a96b },  /* 383:  6.0228807e-01 -5.9529804e-03  5.9633509e-01 */
    { 0x4191ad61, 0x3fc1ec08, 0x419dcc22 },  /* 384:  1.8209658e+01  1.5150156e+00  1.9724673e+01 */
    { 0x4206349a, 0x4380377f, 0x4390fe12 },  /* 385:  3.3551369e+01  2.5643356e+02  2.8998493e+02 */
    { 0x3d28b191, 0xb83e2d9c, 0x3d288206 },  /* 386:  4.1184966e-02 -4.5342007e-05  4.1139624e-02 */
    { 0x410c8843, 0x41a5078c, 0x41eb4bae },  /* 387:  8.7832670e+00  2.0628685e+01  2.9411952e+01 */
    { 0xbfe01099, 0xbe558d3b, 0xbffac240 },  /* 388: -1.7505065e+00 -2.0854656e-01 -1.9590531e+00 */
    { 0x3fe2d489, 0x40ece5b6, 0x4112cd6c },  /* 389:  1.7721111e+00  7.4030409e+00  9.1751519e+00 */
    { 0x414f5895, 0x3fdf1ace, 0x416b3bef },  /* 390:  1.2959126e+01  1.7430055e+00  1.4702132e+01 */
    { 0x3a0c66d2, 0x3c51fdf9, 0x3c5ac466 },  /* 391:  5.3558976e-04  1.2816899e-02  1.3352489e-02 */
    { 0x3e8a0a71, 0xbfcc4ee0, 0xbfa9cc44 },  /* 392:  2.6961091e-01 -1.5961571e+00 -1.3265462e+00 */
    { 0xbfe66648, 0xbffb4b04, 0xc070d8a6 },  /* 393: -1.7999964e+00 -1.9632268e+00 -3.7632232e+00 */
    { 0x42355cee, 0xbf285463, 0x4232bb9c },  /* 394:  4.5340752e+01 -6.5753764e-01  4.4683214e+01 */
    { 0xbf487642, 0xbda45bfe, 0xbf5d01c2 },  /* 395: -7.8305447e-01 -8.0253586e-02 -8.6330806e-01 */
    { 0x3f1c57a0, 0xc26bbc80, 0xc2694b22 },  /* 396:  6.1071205e-01 -5.8934082e+01 -5.8323370e+01 */
    { 0x3d2f0ace, 0x3f2d36d6, 0x3f382783 },  /* 397:  4.2734914e-02  6.7661798e-01  7.1935289e-01 */
    { 0xc17607bf, 0xbd9f7e8c, 0xc17746bc },  /* 398: -1.5376891e+01 -7.7878088e-02 -1.5454769e+01 */
    { 0x3da240a2, 0xb96607e9, 0x3da1cd9e },  /* 399:  7.9224840e-02 -2.1937456e-04  7.9005465e-02 */
    { 0x40d6af43, 0xbe262ec1, 0x40d17dcd },  /* 400:  6.7088943e+00 -1.6228773e-01  6.5466065e+00 */
    { 0xbfcecaa7, 0xbdfccc56, 0xbfde976c },  /* 401: -1.6155595e+00 -1.2343661e-01 -1.7389961e+00 */
    { 0x40a8d4c1, 0x3ad7b5c2, 0x40a8e23c },  /* 402:  5.2759709e+00  1.6457366e-03  5.2776167e+00 */
    { 0xbef0a632, 0x3ef79d2d, 0x3c5edf60 },  /* 403: -4.7001797e-01  4.8362103e-01  1.3603061e-02 */
    { 0xbe805739, 0x3c41a3f5, 0xbe749433 },  /* 404: -2.5066546e-01  1.1818876e-02 -2.3884658e-01 */
    { 0xbde3d700, 0x3f2f153d, 0x3f129a5d },  /* 405: -1.1124992e-01  6.8391782e-01  5.7266790e-01 */
    { 0xbf3edce9, 0xc0b83707, 0xc0d012a4 },  /* 406: -7.4555832e-01 -5.7567172e+00 -6.5022755e+00 */
    { 0xc1e03243, 0xbf01c431, 0xc1e44065 },  /* 407: -2.8024542e+01 -5.0689989e-01 -2.8531442e+01 */
    { 0xbfe6666c, 0x3f3038d9, 0xbf8e4a00 },  /* 408: -1.8000007e+00  6.8836743e-01 -1.1116332e+00 */
    { 0xbfcd913e, 0x3f1e8013, 0xbf7ca269 },  /* 409: -1.6059949e+00  6.1914176e-01 -9.8685318e-01 */
    { 0x40c0cd01, 0x3f1259cc, 0x40d3183a },  /* 410:  6.0250249e+00  5.7168269e-01  6.5967076e+00 */
    { 0x6fc3a80d, 0x4073e145, 0x6fc3a80d },  /* 411:  1.2110548e+29  3.8106244e+00  1.2110548e+29 */
    { 0xbf1057f6, 0xbc185405, 0xbf12b946 },  /* 412: -5.6384218e-01 -9.2973756e-03 -5.7313955e-01 */
    { 0xbe8d3165, 0x48570325, 0x48570313 },  /* 413: -2.7576748e-01  2.2017258e+05  2.2017230e+05 */
    { 0x8372f9db, 0x3ff4ca9e, 0x3ff4ca9e },  /* 414: -7.1404228e-37  1.9124334e+00  1.9124334e+00 */
    { 0x00000000, 0xc2936682, 0xc2936682 },  /* 415:  0.0000000e+00 -7.3700211e+01 -7.3700211e+01 */
    { 0xbd93c9a4, 0x3f3dd0d1, 0x3f2b579c },  /* 416: -7.2161943e-02  7.4146754e-01  6.6930559e-01 */
    { 0x38fa3da7, 0xc07466bb, 0xc07464c7 },  /* 417:  1.1932413e-04 -3.8187702e+00 -3.8186508e+00 */
    { 0x39a1ca31, 0x3e631e07, 0x3e636eec },  /* 418:  3.0858957e-04  2.2179423e-01  2.2210282e-01 */
    { 0x3e084950, 0xc3730990, 0xc372e77e },  /* 419:  1.3309216e-01 -2.4303735e+02 -2.4290426e+02 */
    { 0xc082c4a2, 0x3948c2f3, 0xc082c310 },  /* 420: -4.0865030e+00  1.9146111e-04 -4.0863116e+00 */
    { 0xbfbc7b07, 0x3b2df84c, 0xbfbc240b },  /* 421: -1.4725045e+00  2.6545702e-03 -1.4698499e+00 */
    { 0x3e22de5b, 0x3c9d7d53, 0x3e368e05 },  /* 422:  1.5905134e-01  1.9224798e-02  1.7827614e-01 */
    { 0x3aa06823, 0x3fee220e, 0x3fee4a28 },  /* 423:  1.2238066e-03  1.8604143e+00  1.8616381e+00 */
    { 0x3fe49552, 0xbf624663, 0x3f66e441 },  /* 424:  1.7858069e+00 -8.8388652e-01  9.0192038e-01 */
    { 0x3f3b3708, 0xbf16bb4e, 0x3e11eee8 },  /* 425:  7.3130846e-01 -5.8879554e-01  1.4251292e-01 */
    { 0xc0009e0e, 0x3ff5e71c, 0xbdb55000 },  /* 426: -2.0096469e+00  1.9211154e+00 -8.8531494e-02 */
    { 0xbd74d8b6, 0x4215b8c5, 0x42157b8f },  /* 427: -5.9776984e-02  3.7430439e+01  3.7370662e+01 */
    { 0x0cf0273f, 0x3f3ac287, 0x3f3ac287 },  /* 428:  3.7001475e-31  7.2953075e-01  7.2953075e-01 */
    { 0x3d6dd25b, 0x2d474adb, 0x3d6dd25b },  /* 429:  5.8061939e-02  1.1328462e-11  5.8061939e-02 */
    { 0x444c18ee, 0x457f902f, 0x45994b35 },  /* 430:  8.1638953e+02  4.0890115e+03  4.9054010e+03 */
    { 0xc0b68778, 0x40ce4265, 0x3f3dd768 },  /* 431: -5.7040367e+00  6.4456048e+00  7.4156809e-01 */
    { 0x3ef88725, 0xbefe947d, 0xbc41ab00 },  /* 432:  4.8540607e-01 -4.9722663e-01 -1.1820555e-02 */
    { 0xa44c7398, 0xc0af97f2, 0xc0af97f2 },  /* 433: -4.4333360e-17 -5.4872980e+00 -5.4872980e+00 */
    { 0x30bc9b34, 0xbfa1b2c4, 0xbfa1b2c4 },  /* 434:  1.3722912e-09 -1.2632680e+00 -1.2632680e+00 */
    { 0xbe4ba869, 0x46b5455e, 0x46b544f8 },  /* 435: -1.9888462e-01  2.3202684e+04  2.3202485e+04 */
    { 0xc33bcc4a, 0x47f0000d, 0x47efa227 },  /* 436: -1.8779800e+02  1.2288010e+05  1.2269230e+05 */
    { 0x3c372a6b, 0x40cf0a7e, 0x40cf6613 },  /* 437:  1.1179547e-02  6.4700308e+00  6.4812103e+00 */
    { 0x3e881a1c, 0x41434dde, 0x41478eaf },  /* 438:  2.6582420e-01  1.2206511e+01  1.2472335e+01 */
    { 0x4d62e1f5, 0xc177ef82, 0x4d62e1f4 },  /* 439:  2.3790370e+08 -1.5495974e+01  2.3790368e+08 */
    { 0x40a0f9e7, 0xc004600b, 0x403d93c3 },  /* 440:  5.0305057e+00 -2.0683620e+00  2.9621437e+00 */
    { 0xbf38021f, 0x4019dd83, 0x3fd7b9f6 },  /* 441: -7.1878237e-01  2.4041450e+00  1.6853626e+00 */
    { 0xc12cb5cf, 0x3f18e42f, 0xc123278c },  /* 442: -1.0794387e+01  5.9723181e-01 -1.0197155e+01 */
    { 0xb2eaec96, 0x4b06f5dc, 0x4b06f5dc },  /* 443: -2.7348772e-08  8.8447640e+06  8.8447640e+06 */
    { 0xbef1d27a, 0x4100f3a8, 0x40f2ca28 },  /* 444: -4.7230893e-01  8.0594864e+00  7.5871775e+00 */
    { 0xc069e0d4, 0xbfea5a01, 0xc0af86ea },  /* 445: -3.6543474e+00 -1.8308717e+00 -5.4852191e+00 */
    { 0xbc067718, 0x3fd3dd39, 0x3fd2d04b },  /* 446: -8.2071051e-03  1.6551887e+00  1.6469816e+00 */
    { 0xbe634977, 0x4291b968, 0x429147c3 },  /* 447: -2.2195993e-01  7.2862122e+01  7.2640162e+01 */
    { 0x3fec6eb3, 0x42696515, 0x4270c88b },  /* 448:  1.8471283e+00  5.8348713e+01  6.0195841e+01 */
    { 0x3f028365, 0xc0e365a5, 0xc0d31538 },  /* 449:  5.0981742e-01 -7.1061578e+00 -6.5963404e+00 */
    { 0xc1a51edb, 0x46cc40f7, 0x46cc17af },  /* 450: -2.0640066e+01  2.6144482e+04  2.6123842e+04 */
    { 0x41607a00, 0xbcab6bc6, 0x4160244a },  /* 451:  1.4029785e+01 -2.0925414e-02  1.4008860e+01 */
    { 0x423c9a1a, 0xc09e8931, 0x4228c8f4 },  /* 452:  4.7150490e+01 -4.9542470e+00  4.2196243e+01 */
    { 0x3f0d92b6, 0x42c072a4, 0x42c18dc9 },  /* 453:  5.5301988e-01  9.6223907e+01  9.6776927e+01 */
    { 0xbdf6e7a0, 0x41c47b06, 0x41c3841e },  /* 454: -1.2055898e-01  2.4560070e+01  2.4439511e+01 */
    { 0x424adc75, 0xbdd4966d, 0x424a722a },  /* 455:  5.0715290e+01 -1.0380254e-01  5.0611488e+01 */
    { 0xba4fdf32, 0xbdba56e5, 0xbdbbf6a3 },  /* 456: -7.9296820e-04 -9.0986051e-02 -9.1779019e-02 */
    { 0xd2455f63, 0xbe5c744d, 0xd2455f63 },  /* 457: -2.1192722e+11 -2.1528740e-01 -2.1192722e+11 */
    { 0xbdad1481, 0xc27907c0, 0xc2795e4a },  /* 458: -8.4511764e-02 -6.2257568e+01 -6.2342080e+01 */
    { 0x3db874f7, 0xc5c391d8, 0xc5c39120 },  /* 459:  9.0066843e-02 -6.2582305e+03 -6.2581404e+03 */
    { 0x3e44552f, 0x3ff238a0, 0x400561a3 },  /* 460:  1.9173120e-01  1.8923531e+00  2.0840843e+00 */
    { 0xbfd35a74, 0x3fe24bf2, 0x3def17e0 },  /* 461: -1.6511979e+00  1.7679427e+00  1.1674476e-01 */
    { 0x3ffc5066, 0x338b9f20, 0x3ffc5067 },  /* 462:  1.9712036e+00  6.5016366e-08  1.9712036e+00 */
    { 0xc0c503ad, 0x80000000, 0xc0c503ad },  /* 463: -6.1566987e+00 -0.0000000e+00 -6.1566987e+00 */
    { 0xbfdcd1ae, 0x332b6fe8, 0xbfdcd1ae },  /* 464: -1.7251489e+00  3.9915818e-08 -1.7251489e+00 */
    { 0xbfeb7ff2, 0x40cec1d3, 0x4093e1d6 },  /* 465: -1.8398421e+00  6.4611602e+00  4.6213181e+00 */
    { 0x3f28c71e, 0xbdadfc82, 0x3f13078e },  /* 466:  6.5928829e-01 -8.4954277e-02  5.7433401e-01 */
    { 0x3fd81970, 0xc26945b6, 0xc26284ea },  /* 467:  1.6882763e+00 -5.8318077e+01 -5.6629801e+01 */
    { 0x40e57f04, 0x40ab488c, 0x414863c8 },  /* 468:  7.1717548e+00  5.3526058e+00  1.2524361e+01 */
    { 0x437bd152, 0x401030ca, 0x437e1215 },  /* 469:  2.5181766e+02  2.2529778e+00  2.5407064e+02 */
    { 0xc1e87d28, 0x410caba3, 0xc1a22756 },  /* 470: -2.9061111e+01  8.7919035e+00 -2.0269208e+01 */
    { 0x3c2470a8, 0x370e192e, 0x3c24942e },  /* 471:  1.0036625e-02  8.4697222e-06  1.0045095e-02 */
    { 0x3e0f183c, 0xc346d35e, 0xc346af98 },  /* 472:  1.3974088e-01 -1.9882565e+02 -1.9868591e+02 */
    { 0x3f03c5e4, 0x3d12f194, 0x3f0cf4fd },  /* 473:  5.1473832e-01  3.5874918e-02  5.5061324e-01 */
    { 0x3d5b480d, 0x4111bf04, 0x41129a4c },  /* 474:  5.3535510e-02  9.1091347e+00  9.1626702e+00 */
    { 0xbdf50b3a, 0xbde43a97, 0xbe6ca2e8 },  /* 475: -1.1965032e-01 -1.1143988e-01 -2.3109020e-01 */
    { 0x3e28b3eb, 0x3f2b9323, 0x3f55c01e },  /* 476:  1.6474883e-01  6.7021388e-01  8.3496271e-01 */
    { 0xbd163e62, 0x3e6da159, 0x3e4811c0 },  /* 477: -3.6680587e-02  2.3206080e-01  1.9538022e-01 */
    { 0x418ecfaf, 0x3e721bdf, 0x4190b3e7 },  /* 478:  1.7851408e+01  2.3643444e-01  1.8087842e+01 */
    { 0xbfd30253, 0xbf121bbb, 0xc00e0818 },  /* 479: -1.6485084e+00 -5.7073563e-01 -2.2192441e+00 */
    { 0xc082c93d, 0xc11e2b0d, 0xc15f8fac },  /* 480: -4.0870652e+00 -9.8855104e+00 -1.3972576e+01 */
    { 0x3fec3738, 0xeb12f4c5, 0xeb12f4c5 },  /* 481:  1.8454351e+00 -1.7765906e+26 -1.7765906e+26 */
    { 0x3fa07741, 0xc1cab760, 0xc1c0afec },  /* 482:  1.2536393e+00 -2.5339539e+01 -2.4085899e+01 */
    { 0x457a1126, 0x3d14e393, 0x457a11bb },  /* 483:  4.0010718e+03  3.6349844e-02  4.0011081e+03 */
    { 0x3f0b6a5e, 0x40f8b6ba, 0x41051203 },  /* 484:  5.4459178e-01  7.7723055e+00  8.3168973e+00 */
    { 0x43970aac, 0x3ff185f0, 0x4397fc32 },  /* 485:  3.0208337e+02  1.8868999e+00  3.0397027e+02 */
    { 0x401908f2, 0xbbf90804, 0x40188c6e },  /* 486:  2.3911710e+00 -7.5998325e-03  2.3835711e+00 */
    { 0xc0f39191, 0x3c4bfe07, 0xc0f32b92 },  /* 487: -7.6115193e+00  1.2450702e-02 -7.5990686e+00 */
    { 0xc09f557a, 0x3ff519b7, 0xc0441e18 },  /* 488: -4.9791842e+00  1.9148473e+00 -3.0643369e+00 */
    { 0x4a5e049c, 0x492bd5db, 0x4a847d09 },  /* 489:  3.6375430e+06  7.0383769e+05  4.3413807e+06 */
    { 0x39a2fa84, 0x40e4a79a, 0x40e4aa26 },  /* 490:  3.1085697e-04  7.1454592e+00  7.1457700e+00 */
    { 0x465b928b, 0xc50c3740, 0x463884bb },  /* 491:  1.4052636e+04 -2.2434531e+03  1.1809183e+04 */
    { 0xc182ffd5, 0x3f4e2b0f, 0xc1791cf9 },  /* 492: -1.6374918e+01  8.0534452e-01 -1.5569573e+01 */
    { 0xc20a56e2, 0xbe843920, 0xc20b5f54 },  /* 493: -3.4584846e+01 -2.5824833e-01 -3.4843095e+01 */
    { 0xc15d4622, 0x3f3c2940, 0xc151838e },  /* 494: -1.3829622e+01  7.3500443e-01 -1.3094618e+01 */
    { 0x3e774119, 0x3c086993, 0x3e7fc7b2 },  /* 495:  2.4145927e-01  8.3259521e-03  2.4978522e-01 */
    { 0xb7a834ac, 0xbefd921d, 0xbefd94be },  /* 496: -2.0051688e-05 -4.9525538e-01 -4.9527543e-01 */
    { 0x3f9905c3, 0xc06f038e, 0xc02280ac },  /* 497:  1.1954883e+00 -3.7345920e+00 -2.5391036e+00 */
    { 0xbe55a5bb, 0x3e571e98, 0x3abc6e80 },  /* 498: -2.0864002e-01  2.1007764e-01  1.4376193e-03 */
    { 0xc00a884f, 0xbe0859c4, 0xc0130deb },  /* 499: -2.1645696e+00 -1.3315493e-01 -2.2977245e+00 */
    { 0x420c9259, 0xac964973, 0x420c9259 },  /* 500:  3.5142918e+01 -4.2714109e-12  3.5142918e+01 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x,y,z;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	y.lo = pgm_read_dword (& t[i].y);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = x.fl + y.fl;
	/* Comparison is integer to verify the zero sign.	*/
	if (v.lo != z.lo)
	    x_exit (i+1);
    }
    return 0;
}
