//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_29.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot29(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[29] = {2.108939509820528e-02,1.898958839897566e-01,5.279975615038072e-01,1.036379651913351e+00,1.716539858419621e+00,
    2.570513078602510e+00,3.600905885617244e+00,4.810942229512131e+00,6.204522378750385e+00,7.786297858454517e+00,9.561766127672030e+00,1.153739008940822e+01,
    1.372074942079911e+01,1.612073342103771e+01,1.874778903887881e+01,2.161424367541841e+01,2.473473146698531e+01,2.812676613508207e+01,3.181152693122955e+01,
    3.581496382885539e+01,4.016939799514068e+01,4.491592313790842e+01,5.010816840756123e+01,5.581852415111124e+01,6.214918909678898e+01,6.925369922799511e+01,
    7.738485097617951e+01,8.702589218231859e+01,9.941861090776851e+01};
  constexpr double aw[29] = {2.843997053142649e-01,2.403980521953700e-01,1.716819278930999e-01,1.034872325933194e-01,5.257437408931641e-02,
    2.246531415827838e-02,8.053458274756885e-03,2.414345454729693e-03,6.029606131367349e-04,1.248689305564107e-04,2.132733945420083e-05,2.985130609178755e-06,
    3.398474532453084e-07,3.119524657171614e-08,2.285076676629938e-09,1.319601105882511e-10,5.921777385428942e-12,2.029740224794918e-13,5.204271646572515e-15,
    9.730521835512161e-17,1.285264502254630e-18,1.151965104988007e-20,6.648027661502612e-23,2.301802977748063e-25,4.328835598816510e-28,3.810330373842877e-31,
    1.230286865040881e-34,9.182452610065772e-39,4.934542797516668e-44};
  constexpr double x[11136] = {  1.417364511095090e-03, -1.200320178142514e-05,  7.618395507811085e-08, -4.294150311585067e-10,  2.266458027860906e-12,
 -1.146773746891119e-14,  5.631806294569002e-17, -2.704160423449783e-19,  1.275343664497885e-21, -5.925982397526913e-24,  2.718499008429655e-26, -1.232967835445120e-28,
  1.273297585545165e-02, -1.072311306644879e-04,  6.729873522578099e-07, -3.722313036139264e-09,  1.908956506889702e-11, -9.269720376913319e-14,  4.302054295540335e-16,
 -1.914620011358365e-18,  8.164127650356501e-21, -3.318637985859985e-23,  1.271695556739849e-25, -4.489949061307563e-28,  3.524014775459197e-02, -2.934702699939603e-04,
  1.800416356894355e-06, -9.577422478541712e-09,  4.619235898650441e-11, -2.043876955704934e-13,  8.243607031601989e-16, -2.945842707754355e-18,  8.579284579022819e-21,
 -1.388849720644590e-23, -5.392497869903263e-26,  7.305510555991397e-28,  6.869193572214026e-02, -5.624661765698282e-04,  3.332633077001747e-06, -1.666687683973571e-08,
  7.245258570937253e-11, -2.681616764258556e-13,  7.634661461018107e-16, -8.928131081005804e-19, -8.019065959557719e-21,  8.269229448815471e-23, -5.016801179146383e-25,
  2.316721685456700e-27,  1.127208130710215e-01, -9.022778403632194e-04,  5.096565397869790e-06, -2.330971333891911e-08,  8.555617211430782e-11, -2.148757209950971e-13,
 -1.881825796200311e-17,  4.425069461735560e-18, -3.335545393927436e-20,  1.613456870703967e-22, -5.093496181647907e-25,  2.737248540434188e-28,  1.668421311447763e-01,
 -1.297787537617675e-03,  6.889074558269379e-06, -2.778442894642873e-08,  7.586524740418528e-11, -1.987014755749671e-14, -1.345118204109295e-15,  9.961672088977997e-18,
 -4.216064129084231e-20,  7.848342785606516e-23,  4.313756070089134e-25, -5.215844399877877e-27,  2.304587190634012e-01, -1.731349650722635e-03,  8.497242125183918e-06,
 -2.865566278885009e-08,  3.967618433401484e-11,  2.784783197132129e-13, -2.605499982617457e-15,  1.106532426482230e-17, -1.366392892460328e-20, -1.774183475684626e-22,
  1.585819446567687e-24, -6.570064743335105e-27,  3.028666093618940e-01, -2.183553039473715e-03,  9.719840738318885e-06, -2.505746028848007e-08, -1.907994445588994e-11,
  5.858012173335132e-13, -3.034338061309783e-15,  4.791700275320256e-18,  4.473430438688614e-20, -4.041048287053460e-22,  1.392726543961430e-24,  2.027079323257480e-27,
  3.832618703918152e-01, -2.634066626085172e-03,  1.038791268144035e-05, -1.688210671582819e-08, -8.923821241347950e-11,  7.833069049499268e-13, -2.124036989497540e-15,
 -7.342002733519142e-18,  9.442587692352784e-20, -3.346332509895637e-22, -6.927865954489445e-25,  1.345804439546960e-26,  4.707485195084062e-01, -3.062533889359247e-03,
  1.038243007036686e-05, -4.838903161714727e-09, -1.548829057486159e-10,  7.728294218501243e-13,  4.111061543556618e-17, -1.930071784495561e-17,  9.084528338959695e-20,
  8.808297771507142e-23, -3.009840712164157e-24,  1.241585735071727e-26,  5.643474826806055e-01, -3.449479135974288e-03,  9.647251691918900e-06,  9.630863071455079e-09,
 -1.993185367778162e-10,  5.182515772254392e-13,  2.723870329162208e-15, -2.365640498994820e-17,  2.023693442835324e-20,  5.829995003652367e-22, -2.966904791700806e-24,
 -5.197732717897851e-27,  6.630065560898937e-01, -3.777186900079398e-03,  8.196009087428820e-06,  2.457165063212292e-08, -2.095017290928783e-10,  6.658766325309185e-14,
  4.809098932206338e-15, -1.620233698616941e-17, -8.190746962662607e-20,  7.210540324846818e-22,  1.363899086555909e-25, -2.245786349357233e-26,  7.656113134414835e-01,
 -4.030515765155664e-03,  6.112116572969629e-06,  3.782933564271184e-08, -1.797390610579165e-10, -4.609931078800379e-13,  5.304879750509795e-15,  8.642644035682822e-19,
 -1.494615438124567e-19,  3.046194070465261e-22,  3.820711283970927e-24, -1.810442726337486e-26,  8.709968890942826e-01, -4.197609419549726e-03,  3.541759624699275e-06,
  4.741173548699660e-08, -1.136092767842890e-10, -9.067399220290653e-13,  3.832050818672111e-15,  1.946480021534171e-17, -1.314832974089662e-19, -4.082717870702590e-22,
  4.517409326338245e-24,  7.006648016492506e-27,  9.779605518195035e-01, -4.270470917285920e-03,  6.804143473080048e-07,  5.183133443412150e-08, -2.351407633851920e-11,
 -1.129839556032589e-12,  8.527559884963799e-16,  2.989889800305779e-17, -3.180860598074365e-20, -8.747940015809551e-22,  1.207311708397017e-24,  2.721407709495775e-26,
  1.085274967233207e+00, -4.245370925481526e-03, -2.245879241334216e-06,  5.036882440542000e-08,  7.211039258738566e-11, -1.056432731454565e-12, -2.493551009674905e-15,
  2.642846480850678e-17,  8.931071479728959e-20, -7.162692516038293e-22, -3.260369736461513e-24,  2.013665554218716e-26,  1.191702029057680e+00, -4.123067130361521e-03,
 -5.002694427289465e-06,  4.320841924369118e-08,  1.532455378348724e-10, -7.071647809610677e-13, -4.885336760841935e-15,  1.075566355333245e-17,  1.555023101419049e-19,
 -5.106636623488056e-23, -4.827347651630544e-24, -6.855717319177437e-27,  1.296007120833443e+00, -3.908819789479938e-03, -7.370637943024709e-06,  3.141759694901931e-08,
  2.032498166726099e-10, -1.912293116879399e-13, -5.413486602673495e-15, -8.857306534806564e-18,  1.276735930167111e-19,  5.988161230322804e-22, -2.233267231396713e-24,
 -2.471992822785335e-26,  1.396973651154389e+00, -3.612197406526444e-03, -9.167606615638752e-06,  1.677142970279473e-08,  2.129953602627208e-10,  3.315883433731473e-13,
 -3.985416505429393e-15, -2.237464370536509e-17,  3.040777049531251e-20,  7.520042625032176e-22,  1.839461978411703e-24, -1.622724985641711e-26,  1.493417687696626e+00,
 -3.246676317044536e-03, -1.026752146597505e-05,  1.450148654016955e-09,  1.830453814025332e-10,  7.069925644982949e-13, -1.339437676139431e-15, -2.373453589349837e-17,
 -6.838058305878077e-20,  3.619439811237182e-22,  3.638593297829771e-24,  5.872094616222139e-27,  1.584202499140772e+00, -2.829048165695071e-03, -1.061348248577508e-05,
 -1.233723478300412e-08,  1.232580725821215e-10,  8.392784790520656e-13,  1.334304123226252e-15, -1.399821064996901e-17, -1.079436866220522e-19, -1.880697248281529e-22,
  2.056541008651180e-24,  1.669176561853508e-26,  1.668252800528349e+00, -2.378659307407780e-03, -1.022382534603075e-05, -2.273534305575549e-08,  4.991512400969409e-11,
  7.213402255773220e-13,  2.969820120802593e-15, -5.212665559513066e-20, -7.586272636694361e-20, -4.575930584513169e-22, -7.196300580556605e-25,  8.492255113301003e-27,
  1.744568487708507e+00, -1.916515501407705e-03, -9.190287561531402e-06, -2.856026305419541e-08, -1.882433006365468e-11,  4.305255133925106e-13,  3.103687682113568e-15,
  1.007520607898253e-17, -9.546974128445908e-21, -3.219336136696083e-22, -1.939333332236481e-24, -4.588999542915616e-27,  1.812237641526134e+00, -1.464293294390017e-03,
 -7.668333422113080e-06, -2.949288081593220e-08, -6.785691850965054e-11,  9.288244067619297e-14,  2.019389288710793e-15,  1.207852876623327e-17,  3.912148795339250e-20,
 -1.064393244783599e-23, -1.068972415283115e-24, -7.707867290798590e-27,  1.870448584044422e+00, -1.043305631474327e-03, -5.860553048241399e-06, -2.611037099336208e-08,
 -8.904801004961523e-11, -1.690110428939721e-13,  5.045631727420110e-16,  7.294457734890222e-18,  4.423093710470620e-20,  1.729070836476934e-22,  2.948471944152068e-25,
 -1.925618898126168e-27,  1.918500782065801e+00, -6.734729609207561e-04, -3.994841268666684e-06, -1.974890130035958e-08, -8.300981489902390e-11, -2.830366000915025e-13,
 -6.234272789639388e-16,  7.360841032546905e-19,  1.881207785057877e-20,  1.355824007181017e-22,  6.846710985779025e-25,  2.524049425752553e-27,  1.955814440460999e+00,
 -3.723518413485993e-04, -2.299679206374597e-06, -1.222308959006063e-08, -5.825780538532120e-11, -2.503377876654305e-13, -9.502604831814937e-16, -2.974254102045564e-18,
 -5.766792826120772e-21,  1.238199541749750e-23,  2.236543007320862e-25,  1.625454511546623e-27,  1.981938894627844e+00, -1.542690084584971e-04, -9.791952408165997e-07,
 -5.455810346944521e-09, -2.803875985379794e-11, -1.354997815421425e-13, -6.200225127715813e-16, -2.685126381668286e-18, -1.092345412336622e-20, -4.099194380708268e-23,
 -1.360417869108143e-25, -3.530269082237493e-28,  1.996563460796256e+00, -2.957356908962128e-05, -1.905491445414308e-07, -1.088838652769646e-09, -5.816222704333205e-12,
 -2.972177251845850e-14, -1.470551549612617e-16, -7.093137498439415e-19, -3.349168613777307e-21, -1.551863359962310e-23, -7.066371399546649e-26, -3.163891863998539e-28,
  1.370538859632642e-03, -1.141374255199913e-05,  7.124121701595419e-08, -3.949155957984714e-10,  2.050029333644352e-12, -1.020254197872929e-14,  4.928713332762707e-17,
 -2.328187044262854e-19,  1.080342003048251e-21, -4.939701079740789e-24,  2.230176899983003e-26, -9.956487862538145e-29,  1.231454338375020e-02, -1.020208478538942e-04,
  6.300927825492996e-07, -3.431168269617088e-09,  1.733467594999279e-11, -8.298713404553161e-14,  3.800807749877427e-16, -1.671539027383436e-18,  7.056392793029811e-21,
 -2.847572732269372e-23,  1.088188435849298e-25, -3.864139401873938e-28,  3.409436278912147e-02, -2.795143949184310e-04,  1.689790264538232e-06, -8.869999292031434e-09,
  4.229592879240612e-11, -1.855622945410701e-13,  7.456428383333977e-16, -2.679662865106583e-18,  8.047606699910549e-21, -1.546901956141928e-23, -2.663335688163821e-26,
  5.199261631035555e-28,  6.649415375494394e-02, -5.365858161206700e-04,  3.139412216922082e-06, -1.554955476412274e-08,  6.727042047925623e-11, -2.501648540439323e-13,
  7.352958777788701e-16, -1.105472701259749e-18, -5.379796524552858e-21,  6.455341844991409e-23, -4.079261917022351e-25,  1.951254340751063e-27,  1.091915076407239e-01,
 -8.626012387116705e-04,  4.824920442889960e-06, -2.197517921541029e-08,  8.126357628853370e-11, -2.139559220199395e-13,  9.098578713457360e-17,  3.446729255432169e-18,
 -2.790966467012693e-20,  1.413386800948211e-22, -4.882293866770815e-25,  6.551657764516732e-28,  1.617591236492791e-01, -1.243987999532312e-03,  6.562925931181838e-06,
 -2.657542611887578e-08,  7.516683273578711e-11, -4.895559645076979e-14, -1.084633340422026e-15,  8.660643118120569e-18, -3.907635822085880e-20,  9.154054384655234e-23,
  2.307840991465230e-25, -3.938426437521247e-27,  2.236671142706942e-01, -1.664735991880509e-03,  8.157356161007718e-06, -2.797958049875599e-08,  4.464524804192047e-11,
  2.196093824559696e-13, -2.302668499785898e-15,  1.053756749118333e-17, -1.897810545532097e-20, -1.196790100008165e-22,  1.303875511803505e-24, -6.197843970944277e-27,
  2.942860041039843e-01, -2.107001396457257e-03,  9.417693483228262e-06, -2.527291962295701e-08, -8.080513303249767e-12,  5.147358201976228e-13, -2.882239041710922e-15,
  6.001318030763190e-18,  3.120447084065383e-20, -3.472960562744220e-22,  1.432015036020580e-24, -1.292991208449235e-28,  3.728904947294789e-01, -2.551796766240694e-03,
  1.017726836657694e-05, -1.818742265099223e-08, -7.409677806551774e-11,  7.301932535647607e-13, -2.289152974145408e-15, -4.517363024870079e-18,  8.201544128947706e-20,
 -3.513305418629908e-22, -1.626457347228339e-25,  1.063801068103729e-26,  4.586640771485243e-01, -2.979747670137548e-03,  1.031000422678673e-05, -7.193501141177690e-09,
 -1.394585175810391e-10,  7.676616580520074e-13, -4.582934673203547e-16, -1.636508101465014e-17,  9.198368977945836e-20, -2.108905327023381e-23, -2.443574590431398e-24,
  1.313227906346445e-26,  5.507045786373438e-01, -3.371892245946395e-03,  9.744040409259432e-06,  6.528015010075576e-09, -1.883529716121126e-10,  5.757676544544303e-13,
  2.073546897095801e-15, -2.269627452800515e-17,  3.904765714583234e-20,  4.612777158247345e-22, -3.082957721983922e-24, -2.275475021868953e-28,  6.480307318155651e-01,
 -3.710496231450366e-03,  8.470820556900866e-06,  2.123638879011130e-08, -2.070539679038757e-10,  1.762898510429579e-13,  4.322637908059909e-15, -1.840886707565286e-17,
 -5.607999222453189e-20,  7.078019685508592e-22, -7.710755660832052e-25, -1.863341725565568e-26,  7.495898493885247e-01, -3.979852569250408e-03,  6.548531802559355e-06,
  3.488666797595369e-08, -1.876865383493137e-10, -3.339149063036944e-13,  5.263969943677951e-15, -3.715168014377980e-18, -1.359455131066079e-19,  4.405329864208434e-22,
  2.954140215637912e-24, -2.096396655379750e-26,  8.542666774608821e-01, -4.167031825866912e-03,  4.099212183578438e-06,  4.545408225473139e-08, -1.307827470693694e-10,
 -8.087182944946172e-13,  4.316202632060510e-15,  1.505751752386723e-17, -1.428740202212361e-19, -2.235786161492724e-22,  4.663958283840693e-24, -2.993057333969472e-28,
  9.608934826785420e-01, -4.262547803011506e-03,  1.299391689066099e-06,  5.127572907678082e-08, -4.583911184485641e-11, -1.099471111247034e-12,  1.671020286483843e-15,
  2.838875800344521e-17, -6.215050041897140e-20, -8.033683725422740e-22,  2.340069285015043e-24,  2.393840779438976e-26,  1.068261403042312e+00, -4.260902267445446e-03,
 -1.635237828382093e-06,  5.135056695483815e-08,  5.044479027330617e-11, -1.107099725113248e-12, -1.717588177246899e-15,  2.885049662408480e-17,  6.140571406827058e-20,
 -8.273800878343706e-22, -2.258968513655962e-24,  2.509873939962834e-26,  1.175133058642921e+00, -4.160974114599561e-03, -4.469968885095777e-06,  4.554094348029845e-08,
  1.379570491639521e-10, -8.202397073005352e-13, -4.515058023591251e-15,  1.566459032380826e-17,  1.501345161749240e-19, -2.480943174622190e-22, -4.970389791684715e-24,
  5.017152894360096e-28,  1.280256376812267e+00, -3.966221901336091e-03, -6.974264085006865e-06,  3.463186237238348e-08,  1.981083733593568e-10, -3.236481273606713e-13,
 -5.601187826253491e-15, -4.446193236293616e-18,  1.473623671608085e-19,  4.879238476313016e-22, -3.302782210660493e-24, -2.354073234789275e-26,  1.382379536862001e+00,
 -3.684674826886348e-03, -8.945700467251161e-06,  2.022700191546690e-08,  2.186205576195608e-10,  2.285559074178351e-13, -4.594121333551849e-15, -2.095573563801037e-17,
  5.861721601840108e-20,  8.096557255518425e-22,  1.003123471845513e-24, -2.170761550075437e-26,  1.480266883986847e+00, -3.328696031151511e-03, -1.023208699593950e-05,
  4.490016702836633e-09,  1.968087146108584e-10,  6.666370471369845e-13, -2.032477516657926e-15, -2.568571540646541e-17, -5.268021187230466e-20,  5.113535022147770e-22,
  3.797099418105643e-24,  1.097595970764043e-27,  1.572715602154789e+00, -2.914513400337994e-03, -1.074913734949581e-05, -1.022922149207513e-08,  1.403300855952928e-10,
  8.662024025316657e-13,  8.930992459345120e-16, -1.754340101292202e-17, -1.130531135677291e-19, -9.076279515189949e-23,  2.815797804026555e-24,  1.764520840922741e-26,
  1.658572874851749e+00, -2.461526508154704e-03, -1.049136899539152e-05, -2.181741961837523e-08,  6.505308415070895e-11,  7.923086735809907e-13,  2.931862519282130e-15,
 -2.748067856195887e-18, -9.275433289337914e-20, -4.778189871082357e-22, -2.639187907440727e-25,  1.229925500372103e-26,  1.736753204189829e+00, -1.991413133577933e-03,
 -9.534520336781170e-06, -2.878842589193361e-08, -9.446310021249807e-12,  5.083535116762679e-13,  3.379665176766652e-15,  9.568923581942776e-18, -2.257830127795514e-20,
 -4.031756820499742e-22, -2.112199857063190e-24, -3.134581818461575e-27,  1.806255507706217e+00, -1.527073918257154e-03, -8.028692103472557e-06, -3.056097951282883e-08,
 -6.548649369248375e-11,  1.455469665765747e-13,  2.374994113750423e-15,  1.331534447946365e-17,  3.788308392603337e-20, -6.060622591614167e-23, -1.439539545640427e-24,
 -9.133445283656982e-27,  1.866179573754243e+00, -1.091467826992089e-03, -6.182535328307324e-06, -2.756145057549380e-08, -9.228974063919066e-11, -1.542848213954126e-13,
  7.295743911323823e-16,  8.811532284487937e-18,  5.064432779468028e-20,  1.826570061458936e-22,  1.833447080394394e-25, -3.204225341302344e-27,  1.915741439395742e+00,
 -7.064026524595000e-04, -4.239986441791173e-06, -2.112314885291463e-08, -8.881812860490405e-11, -2.976788016144848e-13, -5.936163792792132e-16,  1.421672890356236e-18,
  2.421336700216406e-20,  1.652547853719104e-22,  8.004192875718995e-25,  2.725253151998919e-27,  1.954287286390505e+00, -3.913522181291064e-04, -2.452118345869091e-06,
 -1.319653634607664e-08, -6.349947504853067e-11, -2.741637641491928e-13, -1.036042950994044e-15, -3.149785026253697e-18, -5.141560824779850e-21,  2.289330737198630e-23,
  3.054447965393963e-25,  2.110963595129058e-27,  1.981305725783370e+00, -1.623722871667200e-04, -1.047448806351884e-06, -5.926945269885275e-09, -3.090386081729442e-11,
 -1.513234253841880e-13, -7.003292721309296e-16, -3.059369119701678e-18, -1.250089018343176e-20, -4.674765474535267e-23, -1.518018443926334e-25, -3.608778210503202e-28,
  1.996442032687244e+00, -3.115185497124026e-05, -2.041938222751196e-07, -1.186852436922325e-09, -6.447624968557550e-12, -3.350207266343157e-14, -1.685044073788344e-16,
 -8.259998577900779e-19, -3.962260103717303e-21, -1.864446231830691e-23, -8.617361657112366e-26, -3.914048980059451e-28,  1.325994502589897e-03, -1.086222625751991e-05,
  6.669250130218408e-08, -3.636854109517523e-10,  1.857298887163289e-12, -9.094129711134499e-15,  4.322664878436693e-17, -2.009290696253169e-19,  9.175683124603506e-22,
 -4.129372796021239e-24,  1.835217523782537e-26, -8.066567920100654e-29,  1.191628720223833e-02, -9.714020963616292e-05,  5.905296837569408e-07, -3.166611236366939e-09,
  1.576248956170036e-11, -7.440223462910793e-14,  3.362906373092526e-16, -1.461328640895590e-18,  6.105671801917856e-21, -2.444630300341667e-23,  9.305258245363689e-26,
 -3.314570287113028e-28,  3.300268361130956e-02, -2.664106041376610e-04,  1.587291292221296e-06, -8.222007073717267e-09,  3.875770789416744e-11, -1.685386538592538e-13,
  6.741326657885139e-16, -2.431213514459532e-18,  7.476599985180153e-21, -1.612657867389885e-23, -7.390686867661964e-27,  3.623713199502280e-28,  6.439688465806283e-02,
 -5.121989735343306e-04,  2.959113487664506e-06, -1.451230643493863e-08,  6.244099537444947e-11, -2.329066063874427e-13,  7.022603474351076e-16, -1.243430637041170e-18,
 -3.329792163090674e-21,  4.985490371835658e-23, -3.293628275259222e-25,  1.626793920675648e-27,  1.058166620769498e-01, -8.250349043645728e-04,  4.568878854458367e-06,
 -2.070904524078022e-08,  7.701360950797557e-11, -2.107105152275307e-13,  1.757290791227078e-16,  2.631322992988949e-18, -2.316535138957852e-20,  1.224607419886439e-22,
 -4.540718513251532e-25,  8.749885128704714e-28,  1.568861874885322e-01, -1.192739850360431e-03,  6.251200160760301e-06, -2.538192410568269e-08,  7.394633401220122e-11,
 -7.221501996469682e-14, -8.591352868824176e-16,  7.464389593563384e-18, -3.565348958794945e-20,  9.763335519026160e-23,  8.156909983966892e-26, -2.879246923396974e-27,
  2.171365791135299e-01, -1.600807704157999e-03,  7.826022625582100e-06, -2.723302267316667e-08,  4.850832416652402e-11,  1.678137021520643e-13, -2.016697781836451e-15,
  9.870875027994544e-18, -2.241201886515582e-20, -7.281494962021107e-23,  1.043671736866712e-24, -5.603150092266906e-27,  2.860067587702049e-01, -2.032874388361444e-03,
  9.113970430217377e-06, -2.532354952577568e-08,  1.536612283136870e-12,  4.476802033725993e-13, -2.702023496093875e-15,  6.810832392227217e-18,  1.972694844811687e-20,
 -2.906197302690458e-22,  1.390741327781168e-24, -1.649407542519835e-27,  3.628447346997394e-01, -2.471270679611278e-03,  9.952378157247363e-06, -1.925916305458181e-08,
 -6.005107206830276e-11,  6.740206062574589e-13, -2.380801512292579e-15, -2.095624354677740e-18,  6.935580415160728e-20, -3.492894268541566e-22,  2.448702785326647e-25,
  7.917772590565269e-27,  4.469094478100340e-01, -2.897649694880980e-03,  1.021079850495187e-05, -9.302758998731396e-09, -1.242506772076389e-10,  7.514952126779284e-13,
 -8.755491240710256e-16, -1.345148460396716e-17,  8.960425835416578e-20, -1.073003534406987e-22, -1.869224311626257e-24,  1.283015451257837e-26,  5.373733392763784e-01,
 -3.293676918287932e-03,  9.804682885571292e-06,  3.608980854054885e-09, -1.763906506800317e-10,  6.180625220239537e-13,  1.457871571970231e-15, -2.120479750465991e-17,
  5.344299375317921e-20,  3.390052054069360e-22, -3.001738925742656e-24,  3.743013788235925e-27,  6.333258148738372e-01, -3.641766335314395e-03,  8.705914164606864e-06,
  1.795718979802261e-08, -2.025334381069144e-10,  2.736682894528374e-13,  3.785845065983511e-15, -1.980321242774431e-17, -3.134015187494598e-20,  6.618572414744611e-22,
 -1.493247487370174e-24, -1.412244858286561e-26,  7.337777943222550e-01, -3.925841268670661e-03,  6.948955644256085e-06,  3.183707717700642e-08, -1.931123852318184e-10,
 -2.093040790303080e-13,  5.101577821714956e-15, -7.790703094377758e-18, -1.181856545454005e-19,  5.398366901954909e-22,  2.004164962386638e-24, -2.191165893707121e-26,
  8.376675402682419e-01, -4.132093097368564e-03,  4.631590873600646e-06,  4.323792567286278e-08, -1.458897707874743e-10, -7.005928906432364e-13,  4.672851502815171e-15,
  1.039262448566919e-17, -1.475866362338796e-19, -3.932172852413991e-23,  4.499981429597877e-24, -7.005063510905561e-27,  9.438679589028200e-01, -4.249705558456743e-03,
  1.909582018688391e-06,  5.036883280213118e-08, -6.736437585437517e-11, -1.050078765712908e-12,  2.433854594317517e-15,  2.595724686097050e-17, -8.914545802060933e-20,
 -6.900838935988127e-22,  3.286986569411457e-24,  1.884413009714349e-26,  1.051195549945887e+00, -4.271507317840133e-03, -1.014925506673841e-06,  5.197858620159461e-08,
  2.795703620036911e-11, -1.138434122188348e-12, -8.868537906546441e-16,  3.032369470513589e-17,  3.026948049606800e-20, -8.946097899094070e-22, -1.080547164745437e-24,
  2.810983295767687e-26,  1.158421155078576e+00, -4.194511660312196e-03, -3.910793685702565e-06,  4.761128905301021e-08,  1.205069340915816e-10, -9.228045319723412e-13,
 -4.010804560518897e-15,  2.028780224920740e-17,  1.376507771500488e-19, -4.441557629488355e-22, -4.774978084769833e-24,  8.412395948451286e-27,  1.264282608368143e+00,
 -4.020300338713648e-03, -6.539900692018636e-06,  3.774247615439022e-08,  1.902838610697218e-10, -4.590224244217163e-13, -5.657215546225909e-15,  5.229699687012822e-19,
  1.623073040078939e-19,  3.359309432392240e-22, -4.272195770140696e-24, -2.015437980217132e-26,  1.367499327957229e+00, -3.755209762230917e-03, -8.681857964566859e-06,
  2.375531371040016e-08,  2.220427696202374e-10,  1.114949894443326e-13, -5.150195607589108e-15, -1.860783569167296e-17,  8.824349908961495e-20,  8.292226413607254e-22,
 -5.885383823629976e-26, -2.637554501578546e-26,  1.466788804598876e+00, -3.410282679504894e-03, -1.015888243952753e-05,  7.742719986428354e-09,  2.095944972589001e-10,
  6.090547529036548e-13, -2.772301790528990e-15, -2.704763513993544e-17, -3.154135430435684e-20,  6.624916628380711e-22,  3.715157644132440e-24, -5.028581011739542e-27,
  1.560884840566118e+00, -3.000958008647462e-03, -1.085784132725907e-05, -7.844357535425908e-09,  1.578265664349457e-10,  8.813311973535603e-13,  3.509088078009270e-16,
 -2.119012067632480e-17, -1.141057855142945e-19,  3.741038739932056e-23,  3.590612334549131e-24,  1.732982074927765e-26,  1.648557275390584e+00, -2.546485772827809e-03,
 -1.074639771327578e-05, -2.064601013534723e-08,  8.159487099207327e-11,  8.613986840965360e-13,  2.810768679694952e-15, -5.992337217968821e-18, -1.100044454952475e-19,
 -4.763434819521472e-22,  3.680832388970665e-25,  1.646693092941850e-26,  1.728632808837730e+00, -2.069072908335775e-03, -9.880538259238579e-06, -2.885373375724149e-08,
  1.553101176609701e-12,  5.925849908574551e-13,  3.635180328229181e-15,  8.597648743713794e-18, -3.864109882589679e-20, -4.897987807522448e-22, -2.201756713265354e-24,
 -7.702900488530931e-28,  1.800016405496077e+00, -1.592787952436251e-03, -8.401604115820885e-06, -3.158224970820699e-08, -6.197465867928365e-11,  2.071553330368539e-13,
  2.764383474408034e-15,  1.448077022007908e-17,  3.456423141889658e-20, -1.266305815891919e-22, -1.871435436101022e-24, -1.047014124550974e-26,  1.861712651470641e+00,
 -1.142276389957478e-03, -6.522231059266909e-06, -2.906173337338203e-08, -9.517938227282020e-11, -1.336251120895659e-13,  9.999828548066977e-16,  1.053847365547521e-17,
  5.731383593868646e-20,  1.867064700958974e-22,  6.846160318271513e-27, -4.891681844728455e-27,  1.912846348934567e+00, -7.413610710968031e-04, -4.502189702886207e-06,
 -2.259262641244541e-08, -9.491047156456751e-11, -3.113546332786594e-13, -5.420221650023913e-16,  2.298103669787863e-18,  3.076810958376827e-20,  1.997086828527216e-22,
  9.230124085386715e-25,  2.825278014441505e-27,  1.952681615743230e+00, -4.116202961543549e-04, -2.616758138670827e-06, -1.425777545895083e-08, -6.923863688409702e-11,
 -3.001048641164708e-13, -1.126398539653421e-15, -3.298578737248920e-18, -4.073567846560544e-21,  3.713855375485280e-23,  4.112615120367225e-25,  2.721526215405927e-27,
  1.980639014827972e+00, -1.710450129333996e-04, -1.121641833462918e-06, -6.446561979178187e-09, -3.410558736986687e-11, -1.692060768389914e-13, -7.918535393587326e-16,
 -3.487527155134958e-18, -1.429691757966089e-20, -5.313563556015089e-23, -1.675140513439856e-25, -3.492797293523450e-28,  1.996314065420544e+00, -3.284418061124005e-05,
 -2.190778687699914e-07, -1.295602627262907e-09, -7.160057615159805e-12, -3.783868676151942e-14, -1.935133453763497e-16, -9.642318755566922e-19, -4.699891882499439e-21,
 -2.246201964884219e-23, -1.053898382758276e-25, -4.856189890405010e-28,  1.283585732917573e-03, -1.034565142765204e-05,  6.250075244107619e-08, -3.353691768230340e-10,
  1.685351564059133e-12, -8.121016841379225e-15,  3.799032857742684e-17, -1.738103803418731e-19,  7.813122378200924e-22, -3.461580914799039e-24,  1.514732246022048e-26,
 -6.556325175992507e-29,  1.153694008338030e-02, -9.256379241812499e-05,  5.539958258571447e-07, -2.925890762734875e-09,  1.435195107207575e-11, -6.680097583632842e-14,
  2.979814336779591e-16, -1.279337492343531e-18,  5.289221578682300e-21, -2.100130748407505e-23,  7.954547844561193e-26, -2.836271632579201e-28,  3.196182753516178e-02,
 -2.540966386233410e-04,  1.492239497234509e-06, -7.627993528670964e-09,  3.554335010579314e-11, -1.531498599801192e-13,  6.093206897741372e-16, -2.201279359860108e-18,
  6.894222737125845e-21, -1.614032686042787e-23,  5.852566608582259e-27,  2.454154916081066e-28,  6.239435516245837e-02, -4.892060205192200e-04,  2.790809361167692e-06,
 -1.354961185218649e-08,  5.794853011937410e-11, -2.164806204347689e-13,  6.662050145450699e-16, -1.323675445775627e-18, -1.755695613452620e-21,  3.802588307371897e-23,
 -2.641428588342178e-25,  1.344662124012130e-27,  1.025880797867067e-01, -7.894572786714600e-04,  4.327625356350841e-06, -1.951028842626713e-08,  7.284712594465246e-11,
 -2.056887085966382e-13,  2.396662591048346e-16,  1.957141412861843e-18, -1.907406047601958e-20,  1.051056986965562e-22, -4.129212332257398e-25,  9.797773960199957e-28,
  1.522133465053544e-01, -1.143928584730473e-03,  5.953664817327859e-06, -2.421138869381417e-08,  7.231211793187935e-11, -9.045189060967310e-14, -6.655736156418595e-16,
  6.380112838041509e-18, -3.210804500357213e-20,  9.862817831764778e-23, -2.560285483736201e-26, -2.024177410591684e-27,  2.108565138917186e-01, -1.539493275525602e-03,
  7.503985644325211e-06, -2.643257658365569e-08,  5.140254978368585e-11,  1.226463817630410e-13, -1.750693230423621e-15,  9.119335952253201e-18, -2.433949341994369e-20,
 -3.579612810362994e-23,  8.124172050716505e-25, -4.897611281080714e-27,  2.780191616126511e-01, -1.961177079429335e-03,  8.810519586264359e-06, -2.523079233292980e-08,
  9.857506699430343e-12,  3.851821245843647e-13, -2.503979725792889e-15,  7.285272227830839e-18,  1.024546336248373e-20, -2.367659250940971e-22,  1.294813605063376e-24,
 -2.630790353218411e-27,  3.531174046010362e-01, -2.392591423811588e-03,  9.715938050795509e-06, -2.011525706218375e-08, -4.714555806710587e-11,  6.164164956266119e-13,
 -2.410280746011497e-15, -7.490258699214200e-20,  5.703481742223444e-20, -3.332731961108663e-22,  5.380371875172021e-25,  5.460986074230639e-27,  4.354814685805507e-01,
 -2.816442501214703e-03,  1.008772928449919e-05, -1.117179459548197e-08, -1.094597551242700e-10,  7.262822857886269e-13, -1.212725252532969e-15, -1.065929427125958e-17,
  8.452935957883280e-20, -1.710399047992723e-22, -1.325328079938490e-24,  1.179443655942348e-26,  5.243557143308819e-01, -3.215113251560856e-03,  9.831470689758020e-06,
  8.873232546956550e-10, -1.637265599362679e-10,  6.461303348629075e-13,  8.897513317094506e-16, -1.932214894270661e-17,  6.353420720197837e-20,  2.231570847220214e-22,
 -2.769681204048562e-24,  6.624917097988688e-27,  6.188993317204816e-01, -3.571311718876214e-03,  8.902153325182919e-06,  1.476518816881969e-08, -1.961968770409631e-10,
  3.577829409760192e-13,  3.220807880297756e-15, -2.043752798899801e-17, -8.725578876855457e-21,  5.910843381642500e-22, -2.011129303099060e-24, -9.424068523236249e-27,
  7.181879576351035e-01, -3.868774245701164e-03,  7.312344969122025e-06,  2.872036119698424e-08, -1.960938880378346e-10, -8.989278321305600e-14,  4.833511963832889e-15,
 -1.124810726464559e-17, -9.754006530733720e-20,  6.008342722913986e-22,  1.051412935402489e-24, -2.113456066644608e-26,  8.212165020398573e-01, -4.093005656825731e-03,
  5.135998157703831e-06,  4.079777720782044e-08, -1.587593329473327e-10, -5.854862888846766e-13,  4.897757031976071e-15,  5.681234187340221e-18, -1.458524696136697e-19,
  1.327792141343293e-22,  4.064560069100359e-24, -1.256052841553487e-26,  9.269034900677476e-01, -4.232031095740778e-03,  2.506858921464379e-06,  4.912640496111796e-08,
 -8.772471496213657e-11, -9.832889799900882e-13,  3.117175395511946e-15,  2.273399484093715e-17, -1.114382980752939e-19, -5.438237721615038e-22,  3.979602421514793e-24,
  1.248173851222749e-26,  1.034097240685342e+00, -4.277125881935406e-03, -3.892529166868600e-07,  5.224288313113867e-08,  5.044721491294599e-12, -1.149450393423471e-12,
 -2.911656685436205e-17,  3.077112669297155e-17, -2.412564047762018e-21, -9.127081579317396e-22,  1.809680534939982e-25,  2.884173467070278e-26,  1.141584198580095e+00,
 -4.223481325685067e-03, -3.328514995178437e-06,  4.938672307710895e-08,  1.011367680810215e-10, -1.011765466491135e-12, -3.383740258063110e-15,  2.440079353760105e-17,
  1.183334947625116e-19, -6.254407850042701e-22, -4.233012032281859e-24,  1.612433698467701e-26,  1.248099709119233e+00, -4.070756893758127e-03, -6.069050539071403e-06,
  4.070621300346381e-08,  1.797499431353944e-10, -5.940230225512572e-13, -5.568285426287073e-15,  5.875669955400484e-18,  1.711243734095653e-19,  1.487928158832845e-22,
 -5.044172496137808e-24, -1.459330114101045e-26,  1.352341470016568e+00, -3.823463850271028e-03, -8.375426731329364e-06,  2.731895031437168e-08,  2.229961857923361e-10,
 -1.801533987020256e-14, -5.627210882348488e-15, -1.530920214351143e-17,  1.177635025626911e-19,  8.025892555051640e-22, -1.296129092900798e-24, -2.956636143645091e-26,
  1.452985801882222e+00, -3.491124177767930e-03, -1.004545916988604e-05,  1.118980636824867e-08,  2.210484036140464e-10,  5.333405005719755e-13, -3.539979316831450e-15,
 -2.764723671678203e-17, -5.088654154862387e-21,  8.046177999664609e-22,  3.338657939510112e-24, -1.222769478348352e-26,  1.548706749273197e+00, -3.088152998036439e-03,
 -1.093623967548970e-05, -5.177871023063133e-09,  1.754872259009970e-10,  8.822227936281761e-13, -2.931253494766908e-16, -2.479077095427566e-17, -1.099938857642758e-19,
  1.958333530439122e-22,  4.316064136946234e-24,  1.533723241903520e-26,  1.638197853927379e+00, -2.633424436389758e-03, -1.098573650500685e-05, -1.919906757279741e-08,
  9.948171602159143e-11,  9.264302240110578e-13,  2.591152111815555e-15, -9.782519425939949e-18, -1.267017576334399e-19, -4.458761782476601e-22,  1.186124200430433e-24,
  2.069451339950618e-26,  1.720196237531682e+00, -2.149500839264671e-03, -1.022622728839374e-05, -2.872925114357691e-08,  1.429595026136410e-11,  6.825615014765223e-13,
  3.855831185504337e-15,  7.061999849772471e-18, -5.785894406141804e-20, -5.776142818063914e-22, -2.163858888148944e-24,  2.686350989940114e-27,  1.793508404416718e+00,
 -1.661533251466661e-03, -8.786391898318453e-06, -3.253695459139113e-08, -5.713463149032310e-11,  2.784863080061558e-13,  3.184536165629890e-15,  1.549851699629262e-17,
  2.854393112883577e-20, -2.110416556929914e-22, -2.356868915367575e-24, -1.153013469532700e-26,  1.857036944716756e+00, -1.195875284550319e-03, -6.880192765816048e-06,
 -3.060457539569207e-08, -9.758688996407753e-11, -1.058711481705044e-13,  1.321744937243475e-15,  1.247965595176334e-17,  6.398292523641101e-20,  1.820753766019620e-22,
 -2.541551476166493e-25, -7.055611025249582e-27,  1.909807115500109e+00, -7.784893281699592e-04, -4.782620343877727e-06, -2.416169352848437e-08, -1.012618333188944e-10,
 -3.234728410315126e-13, -4.627581148714240e-16,  3.405084106105601e-18,  3.865212133412681e-20,  2.391093763177013e-22,  1.046497799258459e-24,  2.751662392337007e-27,
  1.950992155636200e+00, -4.332580332541473e-04, -2.794701266840575e-06, -1.541511090154740e-08, -7.551862144427701e-11, -3.282601266287975e-13, -1.220358655361267e-15,
 -3.404119460563875e-18, -2.409701389449722e-21,  5.619610406323711e-23,  5.471546992103899e-25,  3.482417586406172e-27,  1.979936385123902e+00, -1.803371233663802e-04,
 -1.202389827407523e-06, -7.020391080859954e-09, -3.768793831964583e-11, -1.894358830354859e-13, -8.962062803385356e-16, -3.976957374693408e-18, -1.633402958264557e-20,
 -6.013375027961608e-23, -1.820828180703842e-25, -3.066075715067764e-28,  1.996179082158986e+00, -3.466099922427829e-05, -2.353382826009506e-07, -1.416479575496140e-09,
 -7.965552542777405e-12, -4.282476110512692e-14, -2.227450060949644e-16, -1.128423878211117e-18, -5.589851355816310e-21, -2.713790373508971e-23, -1.292678728782349e-25,
 -6.042852575462074e-28,  1.243178282484723e-03, -9.861296743090579e-06,  5.863291226744876e-08, -3.096549803846815e-10,  1.531668831476096e-12, -7.264935118968143e-15,
  3.345573389095080e-17, -1.506907358650079e-19,  6.669407359742772e-22, -2.909625718259816e-24,  1.253855830317868e-26, -5.345439519571739e-29,  1.117533185961156e-02,
 -8.826846390927157e-05,  5.202200615678781e-07, -2.706570977858988e-09,  1.308464152056481e-11, -6.006083022279397e-14,  2.644201366512406e-16, -1.121588710028320e-18,
  4.587555357439966e-21, -1.805646322427094e-23,  6.799780562735212e-26, -2.422789741774166e-28,  3.096875043322807e-02, -2.425154262714782e-04,  1.404017175168666e-06,
 -7.083029864920562e-09,  3.262172393855558e-11, -1.392413985657507e-13,  5.506865642208405e-16, -1.989896429997257e-18,  6.319735101901231e-21, -1.571755041203894e-23,
  1.466029548179103e-26,  1.593526460299264e-28,  6.048117608510078e-02, -4.675144884680170e-04,  2.633636980000957e-06, -1.265621623831048e-08,  5.377577711887305e-11,
 -2.009416088610713e-13,  6.285474562751294e-16, -1.359882732597020e-18, -5.633660759297482e-22,  2.856955076198065e-23, -2.104318565016854e-25,  1.103221898852304e-27,
  9.949803745956291e-02, -7.557532657756269e-04,  4.100360525146429e-06, -1.837731464494936e-08,  6.879496844359307e-11, -1.993447062956061e-13,  2.864676370342372e-16,
  1.404209761915947e-18, -1.557704856869217e-20,  8.946331707797261e-23, -3.690143156746706e-25,  1.005402414966037e-27,  1.477310783178115e-01, -1.097441886785477e-03,
  5.670007767715406e-06, -2.306967632562957e-08,  7.035722639572826e-11, -1.043947725354446e-13, -5.007834393773977e-16,  5.409106209374631e-18, -2.859538969644614e-20,
  9.603332895747971e-23, -9.923760653971331e-26, -1.350715413377265e-27,  2.048166156503020e-01, -1.480716000538308e-03,  7.191803155155752e-06, -2.559271005048770e-08,
  5.345553457200693e-11,  8.360485281803276e-14, -1.506407307712435e-15,  8.325716900374001e-18, -2.509317629357817e-20, -7.392684936254559e-24,  6.131248038061922e-25,
 -4.161177110861849e-27,  2.703135085989844e-01, -1.891900754919567e-03,  8.508940233200105e-06, -2.501463835044690e-08,  1.697687638345631e-11,  3.275639859961432e-13,
 -2.296613617014122e-15,  7.486507542577745e-18,  2.624484425138096e-21, -1.874777582715450e-22,  1.165611529717540e-24, -3.179321917195832e-27,  3.437009482607608e-01,
 -2.315841358791787e-03,  9.470425653013110e-06, -2.077409950109457e-08, -3.539484601332435e-11,  5.587399017652134e-13, -2.388597952371446e-15,  1.562830653968272e-18,
  4.547634579510765e-20, -3.075921654661255e-22,  7.307064210357597e-25,  3.359751611047894e-27,  4.243762125972481e-01, -2.736305592939550e-03,  9.943633572421145e-06,
 -1.280862295907100e-08, -9.524778445968915e-11,  6.938949844327937e-13, -1.474309192966460e-15, -8.062114598987118e-18,  7.753901179212111e-20, -2.140903795113985e-22,
 -8.381544867698900e-25,  1.029348176204715e-26,  5.116525707244904e-01, -3.136462439390934e-03,  9.826830530925890e-06, -1.627940340870277e-09, -1.506330194624874e-10,
  6.612285379468193e-13,  3.782532599826871e-16, -1.718128962045129e-17,  6.964963423786380e-20,  1.188102936421374e-22, -2.434390090710277e-24,  8.448543280361029e-27,
  6.047575668630697e-01, -3.499438558643855e-03,  9.060749891997127e-06,  1.168728845348162e-08, -1.883146583540882e-10,  4.282028571626832e-13,  2.647731993873218e-15,
 -2.039253798673269e-17,  1.101779598650103e-20,  5.036901586991309e-22, -2.325988547534607e-24, -4.954200257878479e-27,  7.028319654899630e-01, -3.808950342392301e-03,
  7.638125070454173e-06,  2.557466587356928e-08, -1.967589486420264e-10,  2.199966687482427e-14,  4.478166212053066e-15, -1.401697959760103e-17, -7.537226672258835e-20,
  6.248438436301659e-22,  1.649382433541097e-25, -1.896187296037697e-26,  8.049296939297977e-01, -4.050003409011838e-03,  5.609964980493625e-06,  3.817038141373840e-08,
 -1.692834149515187e-10, -4.665531176118646e-13,  4.992425337987298e-15,  1.120652955738437e-18, -1.382912273618672e-19,  2.830022084461806e-22,  3.417192431276124e-24,
 -1.659405826766348e-26,  9.100191734120440e-01, -4.209643485199656e-03,  3.087318978004594e-06,  4.756975703885306e-08, -1.065929670101184e-10, -9.012580760993954e-13,
  3.701084384452877e-15,  1.888640255153176e-17, -1.280367272617028e-19, -3.756865910490383e-22,  4.376412138532333e-24,  5.511788870882784e-27,  1.016986479205186e+00,
 -4.277732620673254e-03,  2.373880130960153e-07,  5.213994104038497e-08, -1.788165897890522e-11, -1.139849065458281e-12,  8.264788420336056e-16,  3.017206879473218e-17,
 -3.483643920336132e-20, -8.803980407162840e-22,  1.422712639216056e-24,  2.722124121243697e-26,  1.124640807202658e+00, -4.247712939104847e-03, -2.726846594002750e-06,
  5.083885621070801e-08,  8.014682108314678e-11, -1.084370608443880e-12, -2.651113844502397e-15,  2.779604641580277e-17,  9.295991694887706e-20, -7.784943754057639e-22,
 -3.370584601854381e-24,  2.285185423893130e-26,  1.231722738182288e+00, -4.117307457628407e-03, -5.563735384373685e-06,  4.347997448435652e-08,  1.665496340126643e-10,
 -7.250653336092207e-13, -5.326581993952758e-15,  1.139727896752579e-17,  1.727129726837036e-19, -6.374798398287859e-23, -5.528652103961044e-24, -7.158636028710667e-27,
  1.336915769561541e+00, -3.889095375292367e-03, -8.026227732226054e-06,  3.087653120518447e-08,  2.212529396596214e-10, -1.577601841896955e-13, -5.998853121755573e-15,
 -1.109106199333332e-17,  1.454052075711873e-19,  7.242339678224292e-22, -2.629610933881479e-24, -3.065346430287859e-26,  1.438861514161745e+00, -3.570889835875548e-03,
 -9.889624514053321e-06,  1.480703599198602e-08,  2.308029364012522e-10,  4.391007826119554e-13, -4.311850069664239e-15, -2.732202693592753e-17,  2.613115497994812e-20,
  9.251357841103448e-22,  2.630535919172869e-24, -2.000194713410484e-26,  1.536178833078524e+00, -3.175842383429178e-03, -1.098094698707495e-05, -2.229545065651343e-09,
  1.930030827392335e-10,  8.664680854079228e-13, -1.035239428779806e-15, -2.816319371712512e-17, -9.968274726297136e-20,  3.809471905098192e-22,  4.910415992719831e-24,
  1.132309452446502e-26,  1.627486965353198e+00, -2.722203395016856e-03, -1.120595295688075e-05, -1.745585397692168e-08,  1.186075808522682e-10,  9.848583357877795e-13,
  2.258142049619198e-15, -1.408279118532858e-17, -1.416690541569898e-19, -3.790427024313871e-22,  2.183614326567277e-24,  2.453841712032411e-26,  1.711432438013957e+00,
 -2.232684702650540e-03, -1.056913893918284e-05, -2.838621488099870e-08,  2.888743143673025e-11,  7.772452600319168e-13,  4.024402933735153e-15,  4.861409285737188e-18,
 -8.017099572051453e-20, -6.605177610620659e-22, -1.947193700451007e-24,  7.372009163406507e-27,  1.786719194985205e+00, -1.733401250075051e-03, -9.182122618186004e-06,
 -3.340224894444631e-08, -5.076496482372452e-11,  3.602181971240154e-13,  3.630004630483334e-15,  1.627116240866642e-17,  1.912529003612276e-20, -3.156658546623024e-22,
 -2.878170338081595e-24, -1.205038611775644e-26,  1.852140996875886e+00, -1.252412539049221e-03, -7.256879969099383e-06, -3.218105841787770e-08, -9.935756917518759e-11,
 -6.971877246003849e-14,  1.700807323796825e-15,  1.462937135132314e-17,  7.027304308713561e-20,  1.649472480543699e-22, -6.218618315276278e-25, -9.748480354254389e-27,
  1.906614760435706e+00, -8.179380908567026e-04, -5.082497154129122e-06, -2.583420691703804e-08, -1.078338722031595e-10, -3.332869130933530e-13, -3.487465991318747e-16,
  4.787990504198948e-18,  4.804204094215730e-20,  2.833121617718330e-22,  1.161114728488317e-24,  2.402542342740442e-27,  1.949213207064281e+00, -4.563766192328911e-04,
 -2.987154280666311e-06, -1.667755435110293e-08, -8.238446712242802e-11, -3.586992039461838e-13, -1.316417486315828e-15, -3.444321762166187e-18,  4.660182259599491e-23,
  8.140913823754116e-23,  7.203256570080772e-25,  4.420408138444109e-27,  1.979195249981879e+00, -1.903037676043198e-04, -1.290381481778227e-06, -7.654915437625775e-09,
 -4.170107915061578e-11, -2.123422064684189e-13, -1.015214344469642e-15, -4.535714158602066e-18, -1.863299779699855e-20, -6.766439305687920e-23, -1.937920448577915e-25,
 -2.159825475061927e-28,  1.996036561950082e+00, -3.661393017058601e-05, -2.531299660221803e-07, -1.551081955615574e-09, -8.878174259737212e-12, -4.857094430361737e-14,
 -2.569994264938081e-16, -1.323982951447975e-18, -6.666670893904571e-21, -3.288197466791367e-23, -1.590263875241245e-25, -7.541782340378650e-28,  1.204648262280592e-03,
 -9.406691036301928e-06,  5.505943535253838e-08, -2.862684348168175e-10,  1.394069803965722e-12, -6.510311370673471e-15,  2.952010022620637e-17, -1.309321957111527e-19,
  5.706829257979334e-22, -2.452102657312330e-24,  1.040848071212771e-26, -4.371405628064684e-29,  1.083038073246435e-02, -8.423314890529153e-05,  4.889587837095142e-07,
 -2.506492029095726e-09,  1.194442523589095e-11, -5.407559451590015e-14,  2.349767810646309e-16, -9.846827118711047e-19,  3.984011605596026e-21, -1.553889284913298e-23,
  5.813966088462811e-26, -2.067144318060341e-28,  3.002062694614156e-02, -2.316146082686468e-04,  1.322062878278722e-06, -6.582661349725187e-09,  2.996466355789722e-11,
 -1.266711925282814e-13,  4.977165224123350e-16, -1.796592546173995e-18,  5.765964298616582e-21, -1.501083686280363e-23,  2.021953768347310e-26,  9.667406118465677e-29,
  5.865231470431541e-02, -4.470385641666451e-04,  2.486794857831197e-06, -1.182714780705869e-08,  4.990470541754048e-11, -1.863145331032915e-13,  5.903619191895132e-16,
 -1.362987771402079e-18,  3.247504226079762e-22,  2.106047721724558e-23, -1.665073112051546e-25,  8.991992151265466e-28,  9.653925950986418e-02, -7.238140809606140e-04,
  3.886306743078767e-06, -1.730810435723564e-08,  6.487973245866886e-11, -1.920511189386082e-13,  3.192713576836519e-16,  9.545125923618110e-19, -1.261143607994772e-20,
  7.558270968062877e-23, -3.252117777490496e-25,  9.788423358110661e-28,  1.434303044024786e-01, -1.053170194616255e-03,  5.399855065994822e-06, -2.196126721349938e-08,
  6.816088982900434e-11, -1.146963519539604e-13, -3.616255538896959e-16,  4.548496523232329e-18, -2.522246274050306e-20,  9.103799039321005e-23, -1.467612634129011e-25,
 -8.329431515367165e-28,  1.990068961315323e-01, -1.424395370770118e-03,  6.889871394642310e-06, -2.472593144920728e-08,  5.478450720408099e-11,  5.015769607234721e-14,
 -1.284537251560875e-15,  7.522865071889941e-18, -2.496004346260278e-20,  1.368352665535162e-23,  4.458868159112029e-25, -3.447594436045603e-27,  2.628801546620040e-01,
 -1.825024839189795e-03,  8.210601039444417e-06, -2.469352150917989e-08,  2.299397196669294e-11,  2.749642944355302e-13, -2.086767723552161e-15,  7.471223256097274e-18,
 -3.319998952092508e-21, -1.437359524706176e-22,  1.019902164563397e-24, -3.397248590918126e-27,  3.345875183071864e-01, -2.241083908607969e-03,  9.218097280172548e-06,
 -2.125411567709972e-08, -2.478895978738280e-11,  5.020930809664020e-13, -2.326088247034234e-15,  2.846798447004230e-18,  3.495986853234157e-20, -2.759393043320107e-22,
  8.394826759620356e-25,  1.649717908707471e-27,  4.135890797065457e-01, -2.657396203790444e-03,  9.781237855040062e-06, -1.422355861236097e-08, -8.174058579777937e-11,
  6.560757429119239e-13, -1.666510728359731e-15, -5.709796667659385e-18,  6.933290154363243e-20, -2.390589271660549e-22, -4.229325383862739e-25,  8.558233936353008e-27,
  4.992637700170468e-01, -3.057965900982741e-03,  9.793272049629268e-06, -3.931937834536375e-09, -1.373553190907642e-10,  6.647888545398468e-13, -7.110648670576264e-17,
 -1.490211242064873e-17,  7.226668364865287e-20,  2.919190610036480e-23, -2.040133272125197e-24,  9.329411990985936e-27,  5.909056014330641e-01, -3.426442118909450e-03,
  9.183212415872779e-06,  8.746025807488748e-09, -1.791611211771443e-10,  4.849524761574666e-13,  2.084272741824554e-15, -1.976815301154086e-17,  2.743444712572016e-20,
  4.074958964862426e-22, -2.455043626396020e-24, -1.019323257019142e-27,  6.877202423317391e-01, -3.746671205603738e-03,  7.926165261589239e-06,  2.243574409198976e-08,
 -1.952773062415065e-10,  1.245141955572165e-13,  4.055305538226277e-15, -1.606928962649522e-17, -5.295236485948117e-20,  6.156277878770132e-22, -6.026841039913730e-25,
 -1.580308140734211e-26,  7.888222747959227e-01, -4.003338222796935e-03,  6.051471520344308e-06,  3.539371019981115e-08, -1.774162947025201e-10, -3.468481105527605e-13,
  4.963560315143725e-15, -3.116755557566886e-18, -1.258263607869416e-19,  4.042736535727181e-22,  2.629333484727942e-24, -1.893493478897218e-26,  8.932335691791534e-01,
 -4.182691916023173e-03,  3.647344411584408e-06,  4.572506580944217e-08, -1.236894752692707e-10, -8.065604798732139e-13,  4.170753003803442e-15,  1.460696852257406e-17,
 -1.383707529695241e-19, -1.978371502643809e-22,  4.465761156435465e-24, -1.384284432222172e-27,  9.998833004259533e-01, -4.273337387362883e-03,  8.606026355524079e-07,
  5.167282097569360e-08, -4.041262879666880e-11, -1.110030562562087e-12,  1.651016937820291e-15,  2.856346452216275e-17, -6.522630979533671e-20, -8.005026972096286e-22,
  2.544463913704533e-24,  2.343995729173922e-26,  1.107610218230444e+00, -4.267067316189846e-03, -2.109812370709144e-06,  5.194451932382250e-08,  5.788780714486775e-11,
 -1.138348501637779e-12, -1.835565345060966e-15,  3.029839670747427e-17,  6.276465904625694e-20, -8.915835687620609e-22, -2.247191303305198e-24,  2.787972458167135e-26,
  1.215167855509579e+00, -4.159686147069630e-03, -5.026487644874160e-06,  4.602193200813145e-08,  1.507990097536262e-10, -8.484529446183325e-13, -4.930734914058181e-15,
  1.684422621683765e-17,  1.663841516480682e-19, -2.886913654779458e-22, -5.654758302008577e-24,  1.582755961976858e-27,  1.321233399613393e+00, -3.951763233955242e-03,
 -7.634598801504792e-06,  3.438341827924960e-08,  2.166356734072165e-10, -3.049101707425065e-13, -6.240501736385966e-15, -6.043864609837183e-18,  1.692611199600290e-19,
  5.923171660564118e-22, -3.955294505988903e-24, -2.914799803737750e-26,  1.424420935621458e+00, -3.649232686241516e-03, -9.689512112727543e-06,  1.856425844230652e-08,
  2.384887631066616e-10,  3.265621247468908e-13, -5.060019093217689e-15, -2.593450286283942e-17,  6.109705906538919e-20,  1.010469288429186e-21,  1.580400874251319e-24,
 -2.764069551035684e-26,  1.523299674784473e+00, -3.263743173746320e-03, -1.098860648364553e-05,  9.955147768308854e-10,  2.100183087715118e-10,  8.318131027224767e-13,
 -1.866129596030872e-15, -3.109483004879285e-17, -8.232801178948387e-20,  5.856561455218978e-22,  5.279594159012245e-24,  5.084767924429594e-27,  1.616417577423128e+00,
 -2.812655122988736e-03, -1.140337772079609e-05, -1.539775417205414e-08,  1.388120632406851e-10,  1.033797699431777e-12,  1.798437485339032e-15, -1.881550230460918e-17,
 -1.534734825538964e-19, -2.691655543010965e-22,  3.331251565312539e-24,  2.741155147221649e-26,  1.702330448321572e+00, -2.318591279381810e-03, -1.090647023011220e-05,
 -2.779436813648897e-08,  4.540762564460491e-11,  8.751519742366158e-13,  4.120928044814230e-15,  1.901179070175350e-18, -1.052584657511544e-19, -7.302554595592799e-22,
 -1.496280512985327e-24,  1.333069970619875e-26,  1.779636118719907e+00, -1.808474767981644e-03, -9.587569539061727e-06, -3.415196394084339e-08, -4.265218689418582e-11,
  4.528632554826374e-13,  4.092292502987712e-15,  1.667809195888046e-17,  5.561395498738374e-21, -4.413671211765118e-22, -3.404277305944630e-24, -1.168440479662954e-26,
  1.847012752605737e+00, -1.312039385717936e-03, -7.652629435240266e-06, -3.377957276381449e-08, -1.003092356014307e-10, -2.372452718871190e-14,  2.142765388536914e-15,
  1.696742460564778e-17,  7.565177430146235e-20,  1.305796287841407e-22, -1.120126198869512e-24, -1.298912587780205e-26,  1.903259682638543e+00, -8.598679501462591e-04,
 -5.403080998994561e-06, -2.761328071297950e-08, -1.145715115023886e-10, -3.398645971421475e-13, -1.915616914865523e-16,  6.497683528189512e-18,  5.910109644575046e-20,
  3.316818919893518e-22,  1.251830505234179e-24,  1.638805136592033e-27,  1.947338606256013e+00, -4.810973412002641e-04, -3.195436233251995e-06, -1.805484705629760e-08,
 -8.988219000211565e-11, -3.914474306424873e-13, -1.412355089206325e-15, -3.389978611588888e-18,  3.545728415724492e-21,  1.144324122272623e-22,  9.391456411442410e-25,
  5.561380493485672e-27,  1.978412790584331e+00, -2.010059296735315e-04, -1.386388325714902e-06, -8.357475718116391e-09, -4.620221968322452e-11, -2.383010323067726e-13,
 -1.150938886038622e-15, -5.172457060227718e-18, -2.121036755574942e-20, -7.556446264185344e-23, -2.000292496759123e-25, -5.312463610826466e-29,  1.995885934758339e+00,
 -3.871591276555439e-05, -2.726284321222832e-07, -1.701252274588497e-09, -9.914405194931055e-12, -5.520903483538568e-14, -2.972447188045499e-16, -1.557552119307242e-18,
 -7.973392006599851e-21, -3.995934590581924e-23, -1.962237864214148e-25, -9.440522067010670e-28,  1.167881215283788e-03, -8.979586902986280e-06,  5.175386940465706e-08,
 -2.649676839272441e-10,  1.270661775350721e-12, -5.843837377860492e-15,  2.609694574149266e-17, -1.140060137422031e-19,  4.894601930283033e-22, -2.071796125371759e-24,
  8.664048794924691e-27, -3.585406459148755e-29,  1.050108546473228e-02, -8.043862161903814e-05,  4.599928218287801e-07, -2.323736032182507e-09,  1.091714682949223e-11,
 -4.875310024432433e-14,  2.091095055910222e-16, -8.657131308769869e-19,  3.464365469223215e-21, -1.338589915031755e-23,  4.973189858262637e-26, -1.762406694416035e-28,
  2.911483249464848e-02, -2.213461110056870e-04,  1.245866003307288e-06, -6.122861836046900e-09,  2.754672265722715e-11, -1.153092949091969e-13,  4.499150011805623e-16,
 -1.620564398472441e-18,  5.241024412467042e-21, -1.413135993645325e-23,  2.342653766593179e-26,  5.160129684643514e-29,  5.690306909839528e-02, -4.276986125797095e-04,
  2.349539426578993e-06, -1.105772595971322e-08,  4.631701924019063e-11, -1.726019801810655e-13,  5.524489970255531e-16, -1.341676157964162e-18,  9.720952680476029e-22,
  1.513897574478169e-23, -1.308101317970806e-25,  7.285539853990736e-28,  9.370489321038510e-02, -6.935370579088452e-04,  3.684712562893939e-06, -1.630033218923300e-08,
  6.111727470650630e-11, -1.841110665840626e-13,  3.407394244672227e-16,  5.920549939440824e-19, -1.011436945678309e-20,  6.342007779301090e-23, -2.833505634154060e-25,
  9.199248811409384e-28,  1.393023781890866e-01, -1.011007132346208e-03,  5.142786192207047e-06, -2.088947425308449e-08,  6.579002998744807e-11, -1.219352886950804e-13,
 -2.450830727038477e-16,  3.792618433930295e-18, -2.205846200596471e-20,  8.455735359461735e-23, -1.744459669503363e-25, -4.447348498558135e-28,  1.934176945444599e-01,
 -1.370448277230494e-03,  6.598447399928348e-06, -2.384295913829085e-08,  5.549596994653831e-11,  2.176680029380110e-14, -1.084982191793209e-15,  6.735182888277203e-18,
 -2.418114165198123e-20,  2.868349850765555e-23,  3.089028830063111e-25, -2.790052544316142e-27,  2.557095575731141e-01, -1.760518664927636e-03,  7.916659058263882e-06,
 -2.428427396418037e-08,  2.800929700459313e-11,  2.273756879798251e-13, -1.879784293203163e-15,  7.289771854183500e-18, -7.796290593447059e-21, -1.059377296549251e-22,
  8.701724607408121e-25, -3.376031220509977e-27,  3.257690483790303e-01, -2.168365326897901e-03,  8.960989787218460e-06, -2.157340809919755e-08, -1.529828757514383e-11,
  4.473409580998911e-13, -2.232162351401568e-15,  3.813170505593253e-18,  2.564412981401034e-20, -2.413251598309783e-22,  8.815846613309644e-25,  3.256338121840354e-28,
  4.031148836149082e-01, -2.579850282338309e-03,  9.603133888214705e-06, -1.542865894583686e-08, -6.903072175259970e-11,  6.144036503891489e-13, -1.796636849295790e-15,
 -3.631401802188072e-18,  6.050821914321295e-20, -2.489722230041357e-22, -8.575750134198285e-26,  6.771989499323770e-27,  4.871882485248339e-01, -2.979844809057124e-03,
  9.733340768972388e-06, -6.023486605784015e-09, -1.241090528936947e-10,  6.583369333575759e-13, -4.559397820231809e-16, -1.258770506983499e-17,  7.194845335041816e-20,
 -4.412271070549039e-23, -1.624858928562192e-24,  9.433842412756320e-27,  5.773473612491293e-01, -3.352604588309437e-03,  9.271293620984626e-06,  5.959571915384626e-09,
 -1.690061126230415e-10,  5.284450018053093e-13,  1.545125125175434e-15, -1.867451271572010e-17,  4.033507714583703e-20,  3.093986266170039e-22, -2.426433194238692e-24,
  2.190384789638929e-27,  6.728620065754380e-01, -3.682237860376364e-03,  8.176746452555028e-06,  1.933636141769549e-08, -1.918510975352283e-10,  2.162710507928705e-13,
  3.584933807927176e-15, -1.741511318993047e-17, -3.138160690955370e-20,  5.786811177446299e-22, -1.217542374339916e-24, -1.208770185732452e-26,  7.729083666008476e-01,
 -3.953276295114530e-03,  6.458956024387568e-06,  3.250598859128370e-08, -1.831713631051224e-10, -2.292107482607058e-13,  4.822244052129014e-15, -6.891689730706689e-18,
 -1.095832469266419e-19,  4.924699765062804e-22,  1.775617961428347e-24, -1.960587326530637e-26,  8.765645850628502e-01, -4.151353191092660e-03,  4.183656657142757e-06,
  4.362255317454888e-08, -1.387891848664685e-10, -7.020601683467324e-13,  4.516931870895607e-15,  1.009939212038661e-17, -1.423095904382046e-19, -2.231997138076559e-23,
  4.264846571868849e-24, -7.589490854521241e-27,  9.828076299293579e-01, -4.263984935034076e-03,  1.476071960668801e-06,  5.085103429810933e-08, -6.215354327640329e-11,
 -1.061070567605781e-12,  2.417391536318298e-15,  2.603670509473632e-17, -9.197743933957081e-20, -6.796130060692251e-22,  3.459781882300639e-24,  1.792486718825975e-26,
  1.090512159681065e+00, -4.281438477137795e-03, -1.481679175665412e-06,  5.268648703919745e-08,  3.475006322262803e-11, -1.172025068895248e-12, -9.640263946339077e-16,
  3.177842772098654e-17,  2.935468536310881e-20, -9.559411780772388e-22, -9.503812959754418e-25,  3.066320662965518e-26,  1.198452240940737e+00, -4.197649308743628e-03,
 -4.460328098298092e-06,  4.829270505778437e-08,  1.326878401588744e-10, -9.605404348755620e-13, -4.386428529177799e-15,  2.195887670063447e-17,  1.519613433156713e-19,
 -5.107704481988964e-22, -5.381630989930154e-24,  1.084457990843631e-26,  1.305306888746703e+00, -4.011131211959791e-03, -7.201428488275963e-06,  3.779261952716621e-08,
  2.090292846787584e-10, -4.560823526084905e-13, -6.330927282088602e-15, -3.193174385808250e-19,  1.874370253500278e-19,  4.095265883124371e-22, -5.152548960224645e-24,
 -2.479858409788028e-26,  1.409670475744972e+00, -3.725792377496710e-03, -9.443652596772776e-06,  2.242548783959833e-08,  2.437480673744593e-10,  1.966625877442578e-13,
 -5.753272440126559e-15, -2.338766971118253e-17,  9.829985102759055e-20,  1.047305840055381e-21,  2.130638445588337e-25, -3.426543942719723e-26,  1.510069042337124e+00,
 -3.351545868870653e-03, -1.095595825572356e-05,  4.486163265769798e-09,  2.261347261060712e-10,  7.763013782481267e-13, -2.770205758995689e-15, -3.335092890724995e-17,
 -5.741010955827132e-20,  7.989837750761239e-22,  5.325290467405964e-24, -3.353593474183147e-27,  1.604983388051946e+00, -2.904581894395513e-03, -1.157413542340323e-05,
 -1.300919757893641e-08,  1.598740660984015e-10,  1.070075255159393e-12,  1.201587756277081e-15, -2.385358412140368e-17, -1.604694719813968e-19, -1.112937569426006e-22,
  4.571143018957528e-24,  2.860809039531203e-26,  1.692879486542772e+00, -2.407163454814628e-03, -1.123504847630263e-05, -2.692243718350082e-08,  6.390192817790559e-11,
  9.742877552629875e-13,  4.122977997932815e-15, -1.898003600179107e-18, -1.324653735133825e-19, -7.763555827576754e-22, -7.567984059672388e-25,  2.045525898261557e-26,
  1.772246207559829e+00, -1.886825496147023e-03, -1.000117110642938e-05, -3.475644552105388e-08, -3.257490754264951e-11,  5.566865786843430e-13,  4.559188808407670e-15,
  1.657456342469782e-17, -1.289950172861380e-20, -5.874372185000764e-22, -3.887041303094414e-24, -1.000330558429555e-26,  1.841639547201950e+00, -1.374909141890256e-03,
 -8.067620148851553e-06, -3.538535578787229e-08, -1.002295493390050e-10,  3.368045921322934e-14,  2.652383532490599e-15,  1.945366665271724e-17,  7.939873942097376e-20,
  7.327492264377715e-23, -1.772413898535187e-24, -1.673594286156334e-26,  1.899731618254440e+00, -9.044497169574415e-04, -5.745664173856536e-06, -2.950098718146405e-08,
 -1.213988889362246e-10, -3.420537647959405e-13,  1.871542127115660e-17,  8.589752516520516e-18,  7.195723665712753e-20,  3.828469241300236e-22,  1.296522849856562e-24,
  2.760201359522178e-28,  1.945361682428615e+00, -5.075525188053394e-04, -3.420987496773018e-06, -1.955746738680627e-08, -9.805770890904955e-11, -4.264660862834039e-13,
 -1.505012121755393e-15, -3.202850674088758e-18,  8.403928321697047e-21,  1.572771743517561e-22,  1.213030423348864e-24,  6.926009440927112e-27,  1.977585931252475e+00,
 -2.125111343359863e-04, -1.491275725608079e-06, -9.136390876910264e-09, -5.125660404157036e-11, -2.677407766590795e-13, -1.305689899741260e-15, -5.896258716057629e-18,
 -2.407464899492256e-20, -8.354218908972497e-23, -1.968980998600549e-25,  2.166132060289667e-28,  1.995726575836155e+00, -4.098138356169988e-05, -2.940329776427392e-07,
 -1.869119174578368e-09, -1.109361200354370e-11, -6.289646283484586e-14, -3.446558076640776e-16, -1.837317265408555e-18, -9.563821552559862e-21, -4.870588109809597e-23,
 -2.428579460888878e-25, -1.185241652496299e-27,  1.132771268533498e-03, -8.577937443376177e-06,  4.869249113804229e-08, -2.455391334394698e-10,  1.159798592187391e-12,
 -5.254113411679494e-15,  2.311330255104493e-17, -9.947272156751261e-20,  4.207515676603506e-22, -1.754815623889469e-24,  7.231280022685575e-27, -2.949181614271875e-29,
  1.018651835613290e-02, -7.686732128317278e-05,  4.331247197820506e-07, -2.156597521936225e-09,  9.990370569935348e-12, -4.401325648533511e-14,  1.863517809421403e-16,
 -7.621944688888092e-19,  3.016484273219538e-21, -1.154375050659471e-23,  4.256510495563457e-26, -1.502030213953484e-28,  2.824892692075050e-02, -2.116657591724749e-04,
  1.174961901609801e-06, -5.699992164323872e-09,  2.534493689267709e-11, -1.050373564758970e-13,  4.068120100494305e-16, -1.460806614830782e-18,  4.749615190094562e-21,
 -1.315910587622043e-23,  2.495426659844911e-26,  1.970837047079718e-29,  5.522904433738853e-02, -4.094207275217072e-04,  2.221181530413077e-06, -1.034356227861670e-08,
  4.299454465117058e-11, -1.597900233634897e-13,  5.153926457221023e-16, -1.302798861057021e-18,  1.430239912345895e-21,  1.050407380737181e-23, -1.019652260298456e-25,
  5.870333743711074e-28,  9.098848465825196e-02, -6.648254263887315e-04,  3.494855774848335e-06, -1.535146423574521e-08,  5.751799327363499e-11, -1.757689301435182e-13,
  3.531138129144662e-16,  3.028155602440873e-19, -8.025700407668185e-21,  5.287383916643839e-23, -2.445237023299195e-25,  8.428725551769553e-28,  1.353390716553433e-01,
 -9.708498299289758e-04,  4.898346926804096e-06, -1.985662830156926e-08,  6.330070546384111e-11, -1.266199623218714e-13, -1.483241189556810e-16,  3.134073219797899e-18,
 -1.914388082445433e-20,  7.727831582574186e-23, -1.874467902275652e-25, -1.616706575041766e-28,  1.880396858719171e-01, -1.318790040960325e-03,  6.317669457944028e-06,
 -2.295289318905414e-08,  5.568573806478214e-11, -2.096156225984567e-15, -9.070593231554145e-16,  5.980063390727992e-18, -2.295408504162201e-20,  3.876187743223415e-23,
  1.992679283865386e-25, -2.206375979279835e-27,  2.487923150451019e-01, -1.698343089055173e-03,  7.628078979258116e-06, -2.380212749214407e-08,  3.212203593720704e-11,
  1.846787460106013e-13, -1.679690531179344e-15,  6.985700067122290e-18, -1.101893699864762e-20, -7.405726963912021e-23,  7.251918388611083e-25, -3.192855947416839e-27,
  3.172373183273533e-01, -2.097716432089107e-03,  8.700926173784184e-06, -2.174947901753485e-08, -6.878093046405401e-12,  3.951352323526384e-13, -2.115162468202054e-15,
  4.501594210776655e-18,  1.759175373918937e-20, -2.060849869758427e-22,  8.733634213416718e-25, -6.445448865221329e-28,  3.929479347537899e-01, -2.503783644701883e-03,
  9.411760863775937e-06, -1.643721946497410e-08, -5.718098201562807e-11,  5.702747211012961e-13, -1.872557351000877e-15, -1.838656762474929e-18,  5.155061585717287e-20,
 -2.469541430879279e-22,  1.742437060134171e-25,  5.068412385223375e-27,  4.754240986117892e-01, -2.902299971691406e-03,  9.649576720898275e-06, -7.904607265535992e-09,
 -1.110789519136356e-10,  6.434231791269577e-13, -7.764861653657377e-16, -1.032250687277177e-17,  6.928927260462133e-20, -1.009216780582246e-22, -1.218643105197645e-24,
  8.948884484586813e-27,  5.640856726973761e-01, -3.278193334097089e-03,  9.326938718296980e-06,  3.341865124817284e-09, -1.581079413177859e-10,  5.594088478423859e-13,
  1.041851122620152e-15, -1.722407317189084e-17,  4.975670689091756e-20,  2.150352883634122e-22, -2.274238927575722e-24,  4.592565753899780e-27,  6.582652794404729e-01,
 -3.615947568633402e-03,  8.390522508472354e-06,  1.630585438852794e-08, -1.867052959605357e-10,  2.963633969580270e-13,  3.086310797202271e-15, -1.809637579695298e-17,
 -1.154351130874047e-20,  5.204830930122916e-22, -1.664112496088572e-24, -8.214808465769257e-27,  7.572010044258031e-01, -3.900094489978039e-03,  6.831312330728593e-06,
  2.954478874446337e-08, -1.866158465762287e-10, -1.161719218514950e-13,  4.582936678720506e-15, -1.010266403888893e-17, -9.078268053850769e-20,  5.463824578208217e-22,
  9.259744651689323e-25, -1.879126416262055e-26,  8.600293714658015e-01, -4.115828834365694e-03,  4.693359493720154e-06,  4.129557355893828e-08, -1.517260775656016e-10,
 -5.907745824582774e-13,  4.736069836287215e-15,  5.564804036877873e-18, -1.401374433150528e-19,  1.400163424616100e-22,  3.815296982684971e-24, -1.261963266863793e-26,
  9.657791460531217e-01, -4.249754006607990e-03,  2.079628198828811e-06,  4.969020019933074e-08, -8.273754062364797e-11, -9.946590438262472e-13,  3.101734131950265e-15,
  2.273010985172638e-17, -1.137795505702583e-19, -5.273454584860182e-22,  4.105084141067735e-24,  1.127535652292109e-26,  1.073366714065555e+00, -4.290755295285067e-03,
 -8.468821033939421e-07,  5.305401098036216e-08,  1.115068188394964e-11, -1.184409999121858e-12, -6.628999812706981e-17,  3.216247676962420e-17, -5.415617148030567e-21,
 -9.667127685472917e-22,  4.135722453338041e-25,  3.090620909982144e-26,  1.181593997683482e+00, -4.230979288700784e-03, -3.868729495421803e-06,  5.025652283047914e-08,
  1.124768537755011e-10, -1.057905494342210e-12, -3.706555597148928e-15,  2.648698384528402e-17,  1.298382339956669e-19, -7.138223350741465e-22, -4.706295468177703e-24,
  1.970839432646958e-26,  1.289150092567870e+00, -4.066872485009059e-03, -6.728177977410527e-06,  4.105586869052462e-08,  1.983910461534153e-10, -6.074419762485718e-13,
 -6.253975445877803e-15,  5.872753037495476e-18,  1.982241877323448e-19,  1.835075511983815e-22, -6.096448615456684e-24, -1.767209016617630e-26,  1.394618006061168e+00,
 -3.800198626272727e-03, -9.151042024736317e-06,  2.634920485488531e-08,  2.462494753436097e-10,  5.111606599620576e-14, -6.358426667264888e-15, -1.964022613810318e-17,
  1.357785530619426e-19,  1.024129848770646e-21, -1.405854531576785e-24, -3.891764101551024e-26,  1.496487992837899e+00, -3.438915535515512e-03, -1.087991558101108e-05,
  8.224593874681645e-09,  2.409193096041155e-10,  6.984309698773200e-13, -3.725136808070233e-15, -3.468718734033584e-17, -2.487438646552374e-20,  1.006127290175547e-21,
  4.956721185438273e-24, -1.366269439917503e-26,  1.593178949156044e+00, -2.997754297996251e-03, -1.171418720451772e-05, -1.027867117026668e-08,  1.815068425621479e-10,
  1.090315919914962e-12,  4.614605870104319e-16, -2.901496710982165e-17, -1.608826042384296e-19,  9.656363837479002e-23,  5.812739908132746e-24,  2.736240123456878e-26,
  1.683069052377328e+00, -2.498317222563998e-03, -1.155132276286326e-05, -2.573877094758070e-08,  8.437030761737404e-11,  1.072096515743874e-12,  4.006256986115704e-15,
 -6.588021694809688e-18, -1.607213071589239e-19, -7.863267433929351e-22,  3.163333629959390e-25,  2.842190264893212e-26,  1.764536234004120e+00, -1.968511149190204e-03,
 -1.042098854410099e-05, -3.518247231723120e-08, -2.030970750461197e-11,  6.716088850122340e-13,  5.014099709411679e-15,  1.579259647013690e-17, -3.694424372727141e-20,
 -7.508433811055995e-22, -4.257905962224459e-24, -6.512898176481201e-27,  1.836008101033769e+00, -1.441175787990486e-03, -8.501832503750309e-06, -3.697999060530401e-08,
 -9.887375494446561e-11,  1.041631130770837e-13,  3.232947153920505e-15,  2.202143837201749e-17,  8.057221892078574e-20, -1.354093056710208e-23, -2.598377157787084e-24,
 -2.085032108849286e-26,  1.896019599382871e+00, -9.518646175683837e-04, -6.111555754734062e-06, -3.149798697960091e-08, -1.282145908909412e-10, -3.384451476167538e-13,
  2.936086376739589e-16,  1.112290356051208e-17,  8.667101219385340e-20,  4.343734777639798e-22,  1.263826606599243e-24, -1.922436932553565e-27,  1.943275211660882e+00,
 -5.358865100387431e-04, -3.665378552101459e-06, -2.119661771296827e-08, -1.069553170877191e-10, -4.636265647017220e-13, -1.590005447733813e-15, -2.833345838116385e-18,
  1.501682857680294e-20,  2.123464751415149e-22,  1.552063789433899e-24,  8.522467201003640e-27,  1.976711311704444e+00, -2.248942470121945e-04, -1.606015431488226e-06,
 -1.000109542017154e-08, -5.693861976107464e-11, -3.011483638262423e-13, -1.482033414740951e-15, -6.716262738157171e-18, -2.722064076230385e-20, -9.111555088723080e-23,
 -1.786773955359406e-25,  6.423112593556095e-28,  1.995557799331430e+00, -4.342648117767418e-05, -3.175704113183390e-07, -2.057147966733599e-09, -1.243861154598578e-11,
 -7.182181339893826e-14, -4.006628614955289e-16, -2.173396003654686e-18, -1.150542446644516e-20, -5.954825942887597e-23, -3.014962458933678e-25, -1.492445797059002e-27,
  1.099220372718538e-03, -8.199875722489189e-06,  4.585398959417272e-08, -2.277937947001511e-10,  1.060045534807765e-12, -4.731351984567371e-15,  2.050744977586167e-17,
 -8.696606068686525e-20,  3.624866917453078e-22, -1.489918833254454e-24,  6.051153498769669e-27, -2.432641725904895e-29,  9.885818915150541e-03, -7.350318818179594e-05,
  4.081763441298710e-07, -2.003557775788287e-09,  9.153155994965309e-12, -3.978637603258471e-14,  1.663015159309746e-16, -6.720000851757991e-19,  2.630025706109733e-21,
 -9.966531176891958e-24,  3.645749605403709e-26, -1.280020941269384e-28,  2.742063960130156e-02, -2.025329260387276e-04,  1.108927466031497e-06, -5.310762271641965e-09,
  2.333859846468586e-11, -9.574795545188640e-14,  3.679674164947777e-16, -1.316204668879896e-18,  4.293997509449950e-21, -1.215070810715294e-23,  2.530503928875625e-26,
 -2.380032822745311e-30,  5.362613041616674e-02, -3.921363103272429e-04,  2.101082941304114e-06, -9.680556201317505e-09,  3.991951178350990e-11, -1.478528460613337e-13,
  4.796065428072815e-16, -1.251719672823676e-18,  1.740865888185327e-21,  6.906077398916994e-24, -7.878285732886902e-26,  4.705061160552002e-28,  8.838395567226462e-02,
 -6.375880697440157e-04,  3.316045422100308e-06, -1.445883652921811e-08,  5.408790601063760e-11, -1.672197804640984e-13,  3.582702423676754e-16,  7.463182206285097e-20,
 -6.289586229061919e-21,  4.380985494603915e-23, -2.092972571949650e-25,  7.576117609847386e-28,  1.315325608350216e-01, -9.325991484568935e-04,  4.666060137809826e-06,
 -1.886424099940729e-08,  6.073946946505415e-11, -1.291933982696788e-13, -6.873867528849140e-17,  2.564524286121735e-18, -1.649794365237727e-20,  6.970231210450278e-23,
 -1.899015733498212e-25,  3.796019336583490e-29,  1.828638853693005e-01, -1.269335288243222e-03,  6.047575507643581e-06, -2.206338411645222e-08,  5.543926017766726e-11,
 -2.193794080792747e-14, -7.496812851558289e-16,  5.269217297896225e-18, -2.143716869801919e-20,  4.494493170686959e-23,  1.135476085439060e-25, -1.703459270563039e-27,
  2.421191956782913e-01, -1.638451955338444e-03,  7.345652137683313e-06, -2.326075087685969e-08,  3.542811302944881e-11,  1.466712540053307e-13, -1.489389865831648e-15,
  6.595765333860759e-18, -1.319601896215040e-20, -4.778142902598844e-23,  5.906678097921591e-25, -2.909726051196351e-27,  3.089840125857269e-01, -2.029154285629973e-03,
  8.439524103112031e-06, -2.179902112677155e-08,  5.274827612608948e-13,  3.459408647735377e-13, -1.982304373935982e-15,  4.952498953495869e-18,  1.079267940466475e-20,
 -1.719334029208716e-22,  8.293899930092819e-25, -1.307984071867393e-27,  3.830821182853827e-01, -2.429293246673478e-03,  9.209393287574038e-06, -1.726332729161734e-08,
 -4.622814270410480e-11,  5.248938067210324e-13, -1.902269602088456e-15, -3.295294177421253e-19,  4.283520187651881e-20, -2.359899482869453e-22,  3.627937381279160e-25,
  3.535219554757640e-27,  4.639686498286483e-01, -2.825512021592779e-03,  9.544478975990793e-06, -9.580029134181437e-09, -9.841897698841318e-11,  6.215660242644774e-13,
 -1.035083632234477e-15, -8.172032575810063e-18,  6.487143571046787e-20, -1.420308980157942e-22, -8.433192998526860e-25,  8.058891879456928e-27,  5.511223247799779e-01,
 -3.203459561857380e-03,  9.352235907994340e-06,  9.028414025710707e-10, -1.467078263353457e-10,  5.788124420768825e-13,  5.829091267359900e-16, -1.552512741160213e-17,
  5.591413109195315e-20,  1.286349171101659e-22, -2.034124154482818e-24,  6.194054794458570e-27,  6.439369057019785e-01, -3.548091015633487e-03,  8.568477217085090e-06,
  1.336983953456583e-08, -1.800784999917398e-10,  3.643295702589035e-13,  2.577162277723227e-15, -1.817945699066167e-17,  5.918757489398270e-21,  4.478002134578036e-22,
 -1.943071604999725e-24, -4.517153557284271e-27,  7.417121010221329e-01, -3.844076739238090e-03,  7.167877082751594e-06,  2.654622199281108e-08, -1.878639116706718e-10,
 -9.885815925968489e-15,  4.262390207253847e-15, -1.268743294356201e-17, -7.064092430774368e-20,  5.673998317447934e-22,  1.395132489682565e-25, -1.678989034408199e-26,
  8.436442289479229e-01, -4.076341898005358e-03,  5.173970889871337e-06,  3.877965214967836e-08, -1.623948868583121e-10, -4.757401869004080e-13,  4.830063892363283e-15,
  1.189351779657738e-18, -1.324944045318443e-19,  2.803649130280982e-22,  3.176289079125425e-24, -1.616591684932043e-26,  9.488171468029488e-01, -4.230755840579190e-03,
  2.667324997046297e-06,  4.821150753890159e-08, -1.018369499724039e-10, -9.130079214494161e-13,  3.684580929910236e-15,  1.881795069828386e-17, -1.297076769860459e-19,
 -3.553000067140895e-22,  4.445418804659571e-24,  4.178405572617688e-27,  1.056194176785041e+00, -4.294982525947226e-03, -2.099446619104009e-07,  5.304313527276880e-08,
 -1.248072023848373e-11, -1.175245926934089e-12,  8.266393494498214e-16,  3.143817677610584e-17, -3.959599760211413e-20, -9.234714515515236e-22,  1.731687384090428e-24,
  2.860330644420223e-26,  1.164612041385566e+00, -4.259487855997267e-03, -3.255566608986300e-06,  5.188231454964512e-08,  9.049156409358796e-11, -1.137518705959935e-12,
 -2.910864233971791e-15,  3.019615180187875e-17,  1.009826373074397e-19, -8.823869376386537e-22, -3.666976794876812e-24,  2.724085502778798e-26,  1.272778146924722e+00,
 -4.118674240731962e-03, -6.216889157247830e-06,  4.412484839445412e-08,  1.847582960008968e-10, -7.548429765625529e-13, -6.000084381555484e-15,  1.227319692650868e-17,
  2.002773897258541e-19, -7.326117387259325e-23, -6.672879158148421e-24, -8.195990335136178e-27,  1.379272892016541e+00, -3.872075197843357e-03, -8.811205226909757e-06,
  3.028890593263111e-08,  2.457039105390162e-10, -1.075607200133752e-13, -6.842078644577950e-15, -1.471966599553505e-17,  1.712150240837695e-19,  9.328906592920559e-22,
 -3.169063355920039e-24, -4.068519176685234e-26,  1.482558970986586e+00, -3.525493521194186e-03, -1.075764787654728e-05,  1.218586280666565e-08,  2.539149076733025e-10,
  5.973176489108903e-13, -4.701811581362432e-15, -3.486674628603639e-17,  1.473996948138278e-20,  1.189045122741265e-21,  4.105342075933109e-24, -2.515550257422129e-26,
  1.580999795676600e+00, -3.091910142211377e-03, -1.181938582376869e-05, -7.199796029003215e-09,  2.033551186402064e-10,  1.091065067291765e-12, -4.221780023645005e-16,
 -3.406041848841387e-17, -1.529400891034834e-19,  3.521047533720438e-22,  6.932227520304455e-24,  2.294763159976896e-26,  1.672889040765276e+00, -2.591938653776006e-03,
 -1.185136415583930e-05, -2.421215993154594e-08,  1.067556839420991e-10,  1.165425934058414e-12,  3.745565924553729e-15, -1.217899439441564e-17, -1.884778429302263e-19,
 -7.462372774860908e-22,  1.748012145142357e-24,  3.662762369031810e-26,  1.756492773324141e+00, -2.053572276394210e-03, -1.084466309811720e-05, -3.539328421910515e-08,
 -5.639128985533712e-12,  7.970938365108273e-13,  5.435440650707195e-15,  1.414455120476752e-17, -6.709578480926150e-20, -9.253646456536477e-22, -4.425839542945457e-24,
 -6.950499966680208e-28,  1.830104520359478e+00, -1.510992194451360e-03, -8.955001282452790e-06, -3.854087395060559e-08, -9.596313968055111e-11,  1.894431838025920e-13,
  3.885416724904775e-15,  2.457002141322568e-17,  7.798149214772058e-20, -1.370675263448320e-22, -3.608595125074655e-24, -2.504998159418038e-26,  1.892111912264667e+00,
 -1.002304352749904e-03, -6.502062029496327e-06, -3.360307707487066e-08, -1.348861187481671e-10, -3.273330495405691e-13,  6.462977328093070e-16,  1.415611503872186e-17,
  1.031901176252486e-19,  4.823486771998712e-22,  1.110748248241668e-24, -5.248526462987148e-27,  1.941071366603871e+00, -5.662567862645494e-04, -3.930318455956264e-06,
 -2.298418230553242e-08, -1.166155634888081e-10, -5.026768881944267e-13, -1.661372548158611e-15, -2.217749565729102e-18,  2.387385927602535e-20,  2.824478145604537e-22,
  1.966208657125986e-24,  1.033469189597662e-26,  1.975785255902097e+00, -2.382383809749098e-04, -1.731699881108678e-06, -1.096229539510840e-08, -6.333302927654040e-11,
 -3.390753385312401e-13, -1.682786201531936e-15, -7.641119943527361e-18, -3.062110049463601e-20, -9.752507254284023e-23, -1.370704951290153e-25,  1.293007878908310e-27,
  1.995378851012130e+00, -4.606928354239089e-05, -3.434994468176054e-07, -2.268201171421967e-09, -1.397635989547509e-11, -8.221165407252461e-14, -4.670120243712512e-16,
 -2.578331749057490e-18, -1.388304137142073e-20, -7.302999837996333e-23, -3.754451426766141e-25, -1.884751494501169e-27,  1.067137619123503e-03, -7.843696597428592e-06,
  4.321919015352479e-08, -2.115641456999225e-10,  9.701496137972004e-13, -4.267130975322392e-15,  1.822705199351532e-17, -7.617997943453348e-20,  3.129604436421410e-22,
 -1.267979328337405e-24,  5.076433609515355e-27, -2.012044431875825e-29,  9.598188150355335e-03, -7.033151764103026e-05,  3.849867801680963e-07, -1.863262473348208e-09,
  8.395864520815873e-12, -3.601174323630148e-14,  1.486117707395433e-16, -5.933091983689628e-19,  2.296175730620625e-21, -8.615087384641407e-24,  3.125230332331015e-26,
 -1.091007709137534e-28,  2.662785589266585e-02, -1.939102172812967e-04,  1.047377151292373e-06, -4.952196795594037e-09,  2.150904493990194e-11, -8.734385233716937e-14,
  3.329730271456573e-16, -1.185600704096894e-18,  3.874721664814998e-21, -1.114542331633930e-23,  2.485128587042089e-26, -1.722724031112562e-29,  5.209048181748954e-02,
 -3.757816761190592e-04,  1.988652950718062e-06, -9.064886861600626e-09,  3.707475496441541e-11, -1.367563629245947e-13,  4.453715650581998e-16, -1.192603566250276e-18,
  1.937479265651139e-21,  4.139327517042608e-24, -6.024875526287801e-26,  3.751492921611566e-28,  8.588558168693927e-02, -6.117392697470530e-04,  3.147622972001042e-06,
 -1.361971769409804e-08,  5.082955296346607e-11, -1.586175603893896e-13,  3.577681480867471e-16, -1.029525653589924e-19, -4.855324930244726e-21,  3.607905972373283e-23,
 -1.778749599042169e-25,  6.708434027617894e-28,  1.278754105855449e-01, -8.961598266260592e-04,  4.445434741079023e-06, -1.791314669676160e-08,  5.814462189352057e-11,
 -1.300388365858076e-13, -3.956264974848348e-18,  2.075278552990353e-18, -1.412458047661089e-20,  6.218346913976229e-23, -1.850605297337299e-25,  1.727662839364318e-28,
  1.778816498442658e-01, -1.221998686594418e-03,  5.788119555276530e-06, -2.118079482077599e-08,  5.483213426721236e-11, -3.823582853667853e-14, -6.114983709363367e-16,
  4.609854058228456e-18, -1.975426564501736e-20,  4.811788270620769e-23,  4.817735223147270e-26, -1.280847769737148e-27,  2.356811643568795e-01, -1.580793407201938e-03,
  7.070014907317836e-06, -2.267231391772967e-08,  3.801879095976312e-11,  1.130929251048291e-13, -1.310847758162496e-15,  6.150285865831093e-18, -1.452085249289383e-20,
 -2.661898362039510e-23,  4.699021545601322e-25, -2.574208199098843e-27,  3.010007719782034e-01, -1.962683793071141e-03,  8.178206566012197e-06, -2.173776801023194e-08,
  6.981957523027655e-12,  3.000631325538595e-13, -1.839684831241337e-15,  5.205112831784969e-18,  5.185087990382785e-21, -1.400460695222139e-22,  7.619962216530800e-25,
 -1.718054275794761e-27,  3.735109668583893e-01, -2.356458532419744e-03,  8.998133851019980e-06, -1.792147557529389e-08, -3.618679106642476e-11,  4.792757637198021e-13,
 -1.893561823286611e-15,  9.083473751698447e-19,  3.463455780349402e-20, -2.187708459160652e-22,  4.885887019214669e-25,  2.221167437073182e-27,  4.528185487649128e-01,
 -2.749641865503225e-03,  9.420476063424550e-06, -1.105670559130075e-08, -8.625341926924867e-11,  5.942078488052727e-13, -1.235649304018496e-15, -6.183792172181067e-18,
  5.923369908564163e-20, -1.689919856441905e-22, -5.129771988150652e-25,  6.929445256772409e-27,  5.384581357525016e-01, -3.128637358720379e-03,  9.349370136942576e-06,
 -1.351257826830685e-09, -1.350258292125954e-10,  5.877917348480465e-13,  1.738424877103003e-16, -1.367693254677358e-17,  5.914897982778808e-20,  5.302712053378595e-23,
 -1.739919150352077e-24,  7.067278511725366e-27,  6.298825849891534e-01, -3.478949852193503e-03,  8.711878627398956e-06,  1.055006438759846e-08, -1.722144488098434e-10,
  4.201089204240069e-13,  2.073103680502084e-15, -1.774745249507793e-17,  2.060183378763622e-20,  3.671035259039607e-22, -2.067885871253766e-24, -1.241318213297858e-27,
  7.264524254965585e-01, -3.785510582437351e-03,  7.468407950281975e-06,  2.354425069419724e-08, -1.870686694556588e-10,  8.791201155301800e-14,  3.878565252877532e-15,
 -1.462144216938374e-17, -5.028506160072260e-20,  5.589904255583776e-22, -5.393418681038703e-25, -1.396176074389198e-26,  8.274245288822567e-01, -4.033133561175565e-03,
  5.623443230660840e-06,  3.611151676419395e-08, -1.707502112131486e-10, -3.598879635839278e-13,  4.805692131952434e-15, -2.865892782598820e-18, -1.202922389490221e-19,
  3.925020457351324e-22,  2.416425384257052e-24, -1.810858536019788e-26,  9.319404238204659e-01, -4.207132143592965e-03,  3.235500187630825e-06,  4.644101033481556e-08,
 -1.191725995052810e-10, -8.187347557720294e-13,  4.151697775857461e-15,  1.449720664035803e-17, -1.392722702322720e-19, -1.758647539166373e-22,  4.476300323051723e-24,
 -2.682970318664933e-27,  1.039014911707773e+00, -4.294121185401761e-03,  4.246034523533890e-07,  5.265677866560955e-08, -3.571681193843102e-11, -1.145016714958510e-12,
  1.684280702047872e-15,  2.965494710311526e-17, -7.130145014639348e-20, -8.302277056262609e-22,  2.897186805310532e-24,  2.403795353880268e-26,  1.147525976391617e+00,
 -4.283019176302079e-03, -2.625053901636556e-06,  5.314467446675948e-08,  6.711282654677427e-11, -1.196898691098676e-12, -2.025094952069606e-15,  3.289348561363162e-17,
  6.688171484668449e-20, -1.003330280329387e-21, -2.340924970441448e-24,  3.262248304684435e-26,  1.256207402594974e+00, -4.166242304571703e-03, -5.670177370308638e-06,
  4.695251196485857e-08,  1.682529775175095e-10, -8.940012972496847e-13, -5.567477525743522e-15,  1.858784295877986e-17,  1.927773129998901e-19, -3.442180785565672e-22,
 -6.794369232136164e-24,  2.852943564660085e-27,  1.363646007959326e+00, -3.941044362817705e-03, -8.424251026547474e-06,  3.419390811098268e-08,  2.418805409465771e-10,
 -2.760672312976282e-13, -7.172670819654802e-15, -8.731396621983290e-18,  2.020878154269256e-19,  7.705851769277240e-22, -4.932912165275653e-24, -3.885325549313316e-26,
  1.468285899309527e+00, -3.610899851490132e-03, -1.058666822605285e-05,  1.633761053566860e-08,  2.646541953356589e-10,  4.728528720070642e-13, -5.664829458605247e-15,
 -3.368085615901179e-17,  6.020319754331737e-20,  1.327667088572711e-21,  2.740920972987111e-24, -3.678159509221765e-26,  1.568442578018420e+00, -3.186753853226100e-03,
 -1.188554387462802e-05, -3.772428275808047e-09,  2.249950469131403e-10,  1.068949135736330e-12, -1.442088888022817e-15, -3.869631824896222e-17, -1.350485070077921e-19,
  6.474761601649032e-22,  7.777120820500691e-24,  1.481281650836887e-26,  1.662329867568431e+00, -2.687880910600065e-03, -1.213087687397262e-05, -2.231284513922318e-08,
  1.309318908921696e-10,  1.250521578514232e-12,  3.316192526106809e-15, -1.862333188777717e-17, -2.136743276869571e-19, -6.417832734133448e-22,  3.529593617520094e-24,
  4.414610380471591e-26,  1.748102279210144e+00, -2.142028734383671e-03, -1.126937446735985e-05, -3.534875756947338e-08,  1.163794438967578e-11,  9.320223610495956e-13,
  5.796177811402222e-15,  1.143038346489959e-17, -1.035821505123722e-19, -1.100690973400008e-21, -4.277782302860129e-24,  7.917985476149864e-27,  1.823914306027437e+00,
 -1.584507946582066e-03, -9.426562135587894e-06, -4.004066778151002e-08, -9.118461701490693e-11,  2.912250833598713e-13,  4.607359770549263e-15,  2.695639318957806e-17,
  7.017251605192127e-20, -3.046249570614719e-22, -4.797067820208842e-24, -2.885410557028468e-26,  1.887996055582839e+00, -1.055970977083506e-03, -6.918460946802080e-06,
 -3.581264380278000e-08, -1.412435646343497e-10, -3.066759749666829e-13,  1.091566750487122e-15,  1.774407975637935e-17,  1.212871894647819e-19,  5.208673659664881e-22,
  7.802973244372669e-25, -1.004477855757669e-26,  1.938741661760072e+00, -5.988350723382289e-04, -4.217662575777013e-06, -2.493264548727585e-08, -1.270723724471751e-10,
 -5.431987046459144e-13, -1.711131900785758e-15, -1.274993527864949e-18,  3.557242698350202e-20,  3.707621827936336e-22,  2.463868899110133e-24,  1.230422929600330e-26,
  1.974803737027850e+00, -2.526359268071731e-04, -1.869558498120568e-06, -1.203214504834650e-08, -7.053632093705526e-11, -3.821436284468615e-13, -1.910990445443228e-15,
 -8.678101509515498e-18, -3.421467229975674e-20, -1.016112135872786e-22, -6.017165974183366e-26,  2.265120229203355e-27,  1.995188899966711e+00, -4.893008338693346e-05,
 -3.721158930868855e-07, -2.505611259135316e-09, -1.573879366485113e-11, -9.433900026387440e-14, -5.458417980520169e-16, -3.067723143388860e-18, -1.680367671262075e-20,
 -8.984524422546399e-23, -4.689712074568209e-25, -2.386961786641660e-27,  1.036438625077518e-03, -7.507840609638250e-06,  4.077081351894093e-08, -1.967014301596038e-10,
  8.890143851659169e-13, -3.854187354208872e-15,  1.622762623977986e-17, -6.685807838468761e-20,  2.707646186395160e-22, -1.081566631979007e-24,  4.269198608542204e-27,
 -1.668594710103040e-29,  9.322883413722872e-03, -6.733882982951530e-05,  3.634104783860985e-07, -1.734502232694624e-09,  7.709992581348165e-12, -3.263638783109834e-14,
  1.329828422734386e-16, -5.245616888619095e-19,  2.007422497582301e-21, -7.456082101380433e-24,  2.681499770208542e-26, -9.302506646243277e-29,  2.586860477892741e-02,
 -1.857631850536593e-04,  9.899593873517393e-07, -4.621603935627889e-09,  1.983946333968328e-11, -7.973721445127740e-14,  3.014531219683478e-16, -1.067839199875653e-18,
  3.491167484032707e-21, -1.016967077924359e-23,  2.386699190978751e-26, -2.677188225323513e-29,  5.061849859615436e-02, -3.602976869016546e-04,  1.883345076190351e-06,
 -8.493002261652133e-09,  3.444384879048685e-11, -1.264610324027116e-13,  4.128659216537693e-16, -1.128654271828866e-18,  2.046873149681730e-21,  2.035485001439966e-24,
 -4.550828979481581e-26,  2.975383451462898e-28,  8.348797068144777e-02, -5.871984448557322e-04,  2.988962816973365e-06, -1.283135840775740e-08,  4.774274679698905e-11,
 -1.500821213115075e-13,  3.528960873264797e-16, -2.388583870564396e-19, -3.677663468120922e-21,  2.952938201449509e-23, -1.502206482155696e-25,  5.868947796940749e-28,
  1.243605589027590e-01, -8.614405619998211e-04,  4.235973073903181e-06, -1.700362525553359e-08,  5.554734702263814e-11, -1.294855500405708e-13,  4.815016848634345e-17,
  1.657697612334095e-18, -1.201712397833845e-20,  5.496135640236959e-23, -1.754239860691186e-25,  2.582459582961892e-28,  1.730846762430147e-01, -1.176695557049423e-03,
  5.539186200563724e-06, -2.031035317765708e-08,  5.393075090085855e-11, -5.143269861756755e-14, -4.910099088757696e-16,  4.005701686341722e-18, -1.799992839852463e-20,
  4.902529431940596e-23, -2.777892758393291e-28, -9.334957217202457e-28,  2.294694026829455e-01, -1.525311056817746e-03,  6.801666206231751e-06, -2.204757014388953e-08,
  3.997972018012873e-11,  8.364580642861848e-14, -1.145264547139025e-15,  5.673698339157993e-18, -1.516716091780799e-20, -9.984599858473590e-24,  3.643915346907836e-25,
 -2.221109937022483e-27,  2.932792393036727e-01, -1.898299213557753e-03,  7.918214024731714e-06, -2.158039570530396e-08,  1.255357889499205e-11,  2.576739118677938e-13,
 -1.692335621534401e-15,  5.296099140205511e-18,  6.731459528721831e-22, -1.111526906303593e-22,  6.811490069522118e-25, -1.928046234942502e-27,  3.642277278827785e-01,
 -2.285342822737699e-03,  8.779910564624319e-06, -1.842623850596369e-08, -2.705305362269770e-11,  4.342535852559517e-13, -1.853767903987594e-15,  1.894583945306751e-18,
  2.713107023832602e-20, -1.976069189460948e-22,  5.617659396628771e-25,  1.144425765033619e-27,  4.419698366662444e-01, -2.674831347343617e-03,  9.279902074140614e-06,
 -1.234335341995253e-08, -7.467876033083721e-11,  5.626829518320028e-13, -1.383198257447306e-15, -4.389038397603412e-18,  5.285086231207776e-20, -1.837722128213893e-22,
 -2.350144621809295e-25,  5.698137239860494e-27,  5.260930228733183e-01, -3.053943090740575e-03,  9.320580893810713e-06, -3.417524064459276e-09, -1.232581804403720e-10,
  5.875836868016027e-13, -1.824181009158603e-16, -1.176643774513258e-17,  5.988128871516802e-20, -1.023408969719922e-23, -1.421272544581981e-24,  7.326018035179873e-27,
  6.161069121759697e-01, -3.408794607117735e-03,  8.822232383551456e-06,  7.864386496401251e-09, -1.633545419987518e-10,  4.639863998329013e-13,  1.587277213576708e-15,
 -1.689276198248943e-17,  3.232324445027411e-20,  2.841353828515953e-22, -2.060857526907868e-24,  1.457415125377026e-27,  7.114315954394077e-01, -3.724683911697934e-03,
  7.733054383640165e-06,  2.057013332280999e-08, -1.844135964521245e-10,  1.759213589447046e-13,  3.449626050956982e-15, -1.591389484659902e-17, -3.068921468471823e-20,
  5.260761121406433e-22, -1.082415121989882e-24, -1.067770202534045e-26,  8.113846479663066e-01, -3.986459613065565e-03,  6.040172091733517e-06,  3.332816299756505e-08,
 -1.768032945315648e-10, -2.459355848804467e-13,  4.673804326570758e-15, -6.472082418751169e-18, -1.046165906910871e-19,  4.730000256508771e-22,  1.605619511537891e-24,
 -1.850368272257841e-26,  9.151671454079573e-01, -4.179052597198384e-03,  3.780829269079756e-06,  4.440879388576997e-08, -1.345206305593311e-10, -7.147311785218923e-13,
  4.494518289197293e-15,  9.973409740130451e-18, -1.424259142210889e-19, -1.026345968654744e-24,  4.221650126200017e-24, -8.712876734425150e-27,  1.021849206546372e+00,
 -4.288208272154445e-03,  1.052308145227261e-06,  5.190458063331338e-08, -5.814710805036722e-11, -1.094914509625165e-12,  2.478353920933521e-15,  2.691942199340112e-17,
 -9.886451681827033e-20, -6.949372549205473e-22,  3.821366930875409e-24,  1.773763486969793e-26,  1.130355961172286e+00, -4.301452243323714e-03, -1.981672618669136e-06,
  5.402465224095133e-08,  4.276453849547590e-11, -1.234240864672386e-12, -1.079656636687009e-15,  3.444058123355358e-17,  2.943167823061127e-20, -1.067269028641089e-21,
 -8.367301614739021e-25,  3.526556872452735e-26,  1.239455341688951e+00, -4.209305643270710e-03, -5.091207985429508e-06,  4.949444873949588e-08,  1.490824614289776e-10,
 -1.020691475402024e-12, -4.962888134079196e-15,  2.450644408155343e-17,  1.755547740640341e-19, -6.100753303602749e-22, -6.414103858980857e-24,  1.442013231153946e-26,
  1.347749733480551e+00, -4.006731752680865e-03, -7.990916293803319e-06,  3.801040318475573e-08,  2.346218326849512e-10, -4.503901408552250e-13, -7.322734670301798e-15,
 -1.862076305737874e-18,  2.258775548783033e-19,  5.404931844816602e-22, -6.529449362816026e-24, -3.305551014364709e-26,  1.453674257382783e+00, -3.694736336881779e-03,
 -1.036492280764673e-05,  2.064003103014326e-08,  2.726766205016458e-10,  3.258427301451985e-13, -6.573605495149910e-15, -3.097181725966601e-17,  1.095532684924051e-19,
  1.401734265155132e-21,  8.864720795951630e-25, -4.718711655475522e-26,  1.555505195721584e+00, -3.281956471405895e-03, -1.190851510146132e-05, -3.733024928788029e-12,
  2.459377405628078e-10,  1.020872416387788e-12, -2.582148879798381e-15, -4.258380012302263e-17, -1.060120169210890e-19,  9.683278746123106e-22,  8.177554269924711e-24,
  2.747189159670228e-27,  1.651382606937956e+00, -2.785961400734213e-03, -1.238522272074775e-05, -2.001371857532434e-08,  1.566918910718083e-10,  1.323059835362689e-12,
  2.695756637280848e-15, -2.579941674686503e-17, -2.337521076829784e-19, -4.599197090882886e-22,  5.604384539672357e-24,  4.972348393030931e-26,  1.739351174174781e+00,
 -2.233875838674591e-03, -1.169180241765982e-05, -3.500576706732423e-08,  3.169330304705113e-11,  1.074558910534521e-12,  6.063636222192771e-15,  7.449601789348975e-18,
 -1.461741780845303e-19, -1.261617050243562e-21, -3.683224579545818e-24,  1.962928881370962e-26,  1.817422371775655e+00, -1.661866714948316e-03, -9.915591490287860e-06,
 -4.144675659652738e-08, -8.419194854185427e-11,  4.111012901744804e-13,  5.391648746286484e-15,  2.898687725042467e-17,  5.543778438072688e-20, -5.227989360025601e-22,
 -6.131211853900110e-24, -3.152602396326329e-26,  1.883658699699031e+00, -1.113076545838285e-03, -7.361969368964141e-06, -3.812000855196133e-08, -1.470725236923207e-10,
 -2.740602695090549e-13,  1.645594004477176e-15,  2.193034335969249e-17,  1.404775070543487e-19,  5.414320328131326e-22,  1.996144701810071e-25, -1.668521937932021e-26,
  1.936276894085766e+00, -6.338085438221725e-04, -4.529419035581098e-06, -2.705495621407778e-08, -1.383491902057166e-10, -5.845525982375023e-13, -1.728746788157695e-15,
  9.699866905296355e-20,  5.082972367087303e-20,  4.807371496269964e-22,  3.049464351263179e-24,  1.430305848924798e-26,  1.973762338068960e+00, -2.681897211013324e-04,
 -2.020976243516888e-06, -1.322444598023635e-08, -7.865816693771584e-11, -4.310503528731645e-13, -2.169857455651902e-15, -9.831746526994595e-18, -3.788857130813071e-20,
 -1.016432133947519e-22,  6.894495446391710e-26,  3.692261752210181e-27,  1.994987029113658e+00, -5.203170899316584e-05, -4.037588042796411e-07, -2.773268313010596e-09,
 -1.776386049540834e-11, -1.085338438179633e-13, -6.397793887614141e-16, -3.661027991487859e-18, -2.040267755080136e-20, -1.108826806403485e-22, -5.875888102594000e-25,
 -3.031311269987651e-27,  1.007044980173720e-03, -7.190879682195952e-06,  3.849326482214994e-08, -1.830733284725030e-10,  8.156785458167907e-13, -3.486244387406217e-15,
  1.447127607522065e-17, -5.878501802429855e-20,  2.347330873199244e-22, -9.246138200575686e-25,  3.598911039669849e-27, -1.387367088590351e-29,  9.059213736512715e-03,
 -6.451275349656589e-05,  3.433156192478212e-07, -1.616195630157271e-09,  7.088027489531912e-12, -2.961403431573101e-14,  1.191555187252484e-16, -4.644196129505528e-19,
  1.757362291154134e-21, -6.461160414438850e-24,  2.303056227089179e-26, -7.936140427261030e-29,  2.514104760872849e-02, -1.780600693059450e-04,  9.363533481420500e-07,
 -4.316547324609978e-09,  1.831470977185343e-11, -7.284884118931886e-14,  2.730639288470305e-16, -9.617977411185605e-19,  3.141941798805697e-21, -9.240466076833199e-24,
  2.255183899908447e-26, -3.247393338126009e-29,  4.920680887894664e-02, -3.456294104495905e-04,  1.784653909162334e-06, -7.961606679905554e-09,  3.201119467126079e-11,
 -1.169240208653164e-13,  3.821892549470704e-16, -1.062308793565671e-18,  2.090360592822117e-21,  4.575074128088464e-25, -3.384814063611837e-26,  2.346757292568439e-28,
  8.118604316005887e-02, -5.638898866436962e-04,  2.839472249443309e-06, -1.209102992292128e-08,  4.482519299392091e-11, -1.417052280371500e-13,  3.447122896946717e-16,
 -3.406453057835219e-19, -2.716756497939714e-21,  2.401345893112630e-23, -1.261474979887570e-25,  5.083821994353552e-28,  1.209813010197206e-01, -8.283540388773249e-04,
  4.037176900362435e-06, -1.613550758092025e-08,  5.297273472805487e-11, -1.278146331333599e-13,  8.946995952758970e-17,  1.303476381023633e-18, -1.016192620892180e-20,
  4.818829621949319e-23, -1.628750661162547e-25,  3.070031992588018e-28,  1.684649980085070e-01, -1.133342377386092e-03,  5.300603396334308e-06, -1.945629368779770e-08,
  5.279301001295371e-11, -6.193447959511081e-14, -3.866493591612160e-16,  3.457865356697964e-18, -1.624431660293858e-20,  4.827965102471333e-23, -3.496827856842161e-26,
 -6.537996524249324e-28,  2.234753250075819e-01, -1.471945018347823e-03,  6.540983931478747e-06, -2.139595169335775e-08,  4.139035626330235e-11,  5.801073931381422e-14,
 -9.932309390075509e-16,  5.185226194618226e-18, -1.528685674727007e-20,  2.739590098339726e-24,  2.743437411409859e-25, -1.874566023356199e-27,  2.858110990829613e-01,
 -1.835985568203082e-03,  7.660617473966028e-06, -2.134046700561779e-08,  1.731290569726347e-11,  2.188362668338896e-13, -1.544308314294811e-15,  5.258706602687543e-18,
 -2.858629999640184e-21, -8.563020756724587e-23,  5.945496407468688e-25, -1.987151328253804e-27,  3.552254252289408e-01, -2.215994711642822e-03,  8.556477439805868e-06,
 -1.879200438479559e-08, -1.880810959444472e-11,  3.904914257088463e-13, -1.789602872492832e-15,  2.653375771391156e-18,  2.043138844227148e-20, -1.743938898367280e-22,
  5.927445406802074e-25,  3.009631399735029e-28,  4.314180240511708e-01, -2.601204080971582e-03,  9.124978094165432e-06, -1.345002642769063e-08, -6.376606167699890e-11,
  5.281964193438950e-13, -1.483418923779186e-15, -2.805009365155435e-18,  4.612295248475972e-20, -1.885228638173659e-22, -1.146424001499699e-26,  4.471021716195627e-27,
  5.140260739165984e-01, -2.979575119928839e-03,  9.268124557706414e-06, -5.295987563758283e-09, -1.115758570908728e-10,  5.794679429173004e-13, -4.851815088713425e-16,
 -9.866474558257264e-18,  5.856696566293317e-20, -6.067330336486071e-23, -1.102323597527649e-24,  7.103646290052725e-27,  6.026134253766704e-01, -3.337882972015655e-03,
  8.901235487059731e-06,  5.326862857094652e-09, -1.537315381501976e-10,  4.965308523012339e-13,  1.130185926546111e-15, -1.571050065327597e-17,  4.108977252550263e-20,
  2.036351476850641e-22, -1.949215211622413e-24,  3.508572924057269e-27,  6.966580815665007e-01, -3.661881974861350e-03,  7.962322539296260e-06,  1.765200823358344e-08,
 -1.801038521538831e-10,  2.532715222925232e-13,  2.993070747103563e-15, -1.660214508806026e-17, -1.263391087096434e-20,  4.743858421675111e-22, -1.477304911017056e-24,
 -7.278063342024306e-27,  7.955379168720537e-01, -3.936586909562371e-03,  6.422994171805058e-06,  3.046598701769692e-08, -1.806168586943796e-10, -1.363010565578416e-13,
  4.448356857443827e-15, -9.536552698181504e-18, -8.662717084004021e-20,  5.211335947906751e-22,  8.080454445754347e-25, -1.754919975442122e-26,  8.985147503160564e-01,
 -4.146711978430790e-03,  4.300368314587860e-06,  4.214805335215077e-08, -1.477166076686493e-10, -6.040255752256160e-13,  4.710188960023536e-15,  5.446938683019728e-18,
 -1.395295307060698e-19,  1.586694186121952e-22,  3.728495859780204e-24, -1.346507511862950e-26,  1.004717130641476e+00, -4.277315845163857e-03,  1.668869499565181e-06,
  5.080252191224390e-08, -7.939148177110085e-11, -1.026768609993912e-12,  3.184263988647431e-15,  2.338637587874955e-17, -1.209619050447178e-19, -5.285846028939623e-22,
  4.442696270654114e-24,  1.039481772958897e-26,  1.113122565249297e+00, -4.314702692570006e-03, -1.330089656040521e-06,  5.451032777899099e-08,  1.789911361699587e-11,
 -1.248509820901184e-12, -1.079394452896726e-16,  3.476423449593569e-17, -9.217079854603816e-21, -1.069591988455761e-21,  7.179069140108114e-25,  3.489962128436933e-26,
  1.222540476516907e+00, -4.247620615478070e-03, -4.483656639518473e-06,  5.171023032540236e-08,  1.275363076980311e-10, -1.130953848826141e-12, -4.201705754624402e-15,
  2.972471630241997e-17,  1.491569532484164e-19, -8.506558561475889e-22, -5.535543960182722e-24,  2.529947775582133e-26,  1.331597929713787e+00, -4.068771513198738e-03,
 -7.512595960969040e-06,  4.168273841890802e-08,  2.238566410690167e-10, -6.259285482925238e-13, -7.271129645948092e-15,  5.624226321963457e-18,  2.403065715598324e-19,
  2.528037497624466e-22, -7.784590636706777e-24, -2.339536385411788e-26,  1.438731147201602e+00, -3.776590391656190e-03, -1.009087897760007e-05,  2.504613268754905e-08,
  2.775478114575215e-10,  1.581125807962583e-13, -7.384125824002909e-15, -2.665608585128770e-17,  1.601303421179991e-19,  1.393161510964624e-21, -1.371099092215272e-24,
 -5.485040388571393e-26,  1.542186929766505e+00, -3.377156348526431e-03, -1.188428812921561e-05,  4.090831428746449e-09,  2.656370568587058e-10,  9.442438156515177e-13,
 -3.816297872678521e-15, -4.535531799866666e-17, -6.527468119899722e-20,  1.293467675672653e-21,  7.964983314799197e-24, -1.295228144807530e-26,  1.640039139577182e+00,
 -2.885959188189818e-03, -1.260946102383858e-05, -1.729170447517830e-08,  1.837371289933756e-10,  1.378230498231046e-12,  1.866496497743861e-15, -3.349679152431110e-17,
 -2.457378151090831e-19, -1.910584140262369e-22,  7.854279342536551e-24,  5.183872478932278e-26,  1.730225955931839e+00, -2.329080229244425e-03, -1.210809407400023e-05,
 -3.431877694761913e-08,  5.465373630542063e-11,  1.222017743502994e-12,  6.199719420689128e-15,  2.018835148748635e-18, -1.939988549585997e-19, -1.387532192002631e-21,
 -2.504738728403463e-24,  3.442131195270912e-26,  1.810613074051881e+00, -1.743203119461389e-03, -1.042074013316233e-05, -4.272074153503441e-08, -7.460922895749520e-11,
  5.504217635623833e-13,  6.224934747957517e-15,  3.040968364371953e-17,  3.186476016246604e-20, -7.961369490654018e-22, -7.539482709702449e-24, -3.202518391627484e-26,
  1.879085647878929e+00, -1.173842466482638e-03, -7.833701769695052e-06, -4.051465457291258e-08, -1.521063467541096e-10, -2.266714242348478e-13,  2.325509745934827e-15,
  2.673745107905165e-17,  1.599139998117788e-19,  5.323007835482656e-22, -7.205837438086372e-25, -2.553282991053187e-26,  1.933667078713276e+00, -6.713810681319724e-04,
 -4.867753128403497e-06, -2.936432151539003e-08, -1.504539004764995e-10, -6.258092653001596e-13, -1.700482222162104e-15,  2.025260807181467e-18,  7.048862275550875e-20,
  6.158557024518974e-22,  3.719554596757417e-24,  1.609424174756675e-26,  1.972656207414467e+00, -2.850143735323431e-04, -2.187514699787573e-06, -1.455487030797448e-08,
 -8.782296049847609e-11, -4.865707572918966e-13, -2.462664739280134e-15, -1.110184508750470e-17, -4.145397920404822e-20, -9.508203612814314e-23,  2.741304632864536e-25,
  5.757966040904006e-27,  1.994772224322556e+00, -5.539989864673072e-05, -4.388177879406690e-07, -3.075725997455101e-09, -2.009678518571723e-11, -1.251962879212535e-13,
 -7.520625866376502e-16, -4.382592586776415e-18, -2.485171959772255e-20, -1.372825883598680e-22, -7.384334799533408e-25, -3.859661005058750e-27,  9.788837464943763e-04,
 -6.891504398029521e-06,  3.637244873305759e-08, -1.705619450443552e-10,  7.492976996077141e-13, -3.157866524598971e-15,  1.292564336574748e-17, -5.177950391470000e-20,
  2.038976380361774e-22, -7.921535948981004e-25,  3.040906070299057e-27, -1.156472914551440e-29,  8.806535605267962e-03, -6.184192201469569e-05,  3.245826685640423e-07,
 -1.507374366657974e-09,  6.523322776201263e-12, -2.690420096677026e-14,  1.069053291740089e-16, -4.117344667567523e-19,  1.540533592176606e-21, -5.606220933544683e-24,
  1.980093149629394e-26, -6.775198446548006e-29,  2.444346781719747e-02, -1.707715636528147e-04,  8.862660410369804e-07, -4.034820663275612e-09,  1.692114436841712e-11,
 -6.660741089727853e-14,  2.474923973582865e-16, -8.664068721816191e-19,  2.825168227685601e-21, -8.368007504866022e-24,  2.104966785183243e-26, -3.542801202992815e-29,
  4.785225267958838e-02, -3.317258037882373e-04,  1.692112120900388e-06, -7.467647010797575e-09,  2.976206945557165e-11, -1.081008493988619e-13,  3.533818155566404e-16,
 -9.953957978912381e-19,  2.084804062042316e-21, -7.056280332272110e-25, -2.467759484271717e-26,  1.839824058687076e-28,  7.897501318375619e-02, -5.417424981202832e-04,
  2.698591030245197e-06, -1.139605357646703e-08,  4.207299929466585e-11, -1.335556486735302e-13,  3.340803788976745e-16, -4.146811706279140e-19, -1.937905063467063e-21,
  1.939331604031868e-23, -1.053816781648911e-25,  4.367161793789854e-28,  1.177312734824574e-01, -7.968169129157239e-04,  3.848552244547035e-06, -1.530826572965250e-08,
  5.044068787451137e-11, -1.252645729210603e-13,  1.216667413060351e-16,  1.004820747740260e-18, -8.541084969520073e-21,  4.195159643916988e-23, -1.488000566383705e-25,
  3.290769363294917e-28,  1.640149796194507e-01, -1.091857189870599e-03,  5.072153578525231e-06, -1.862198735254022e-08,  5.146907021524545e-11, -7.010936589612717e-14,
 -2.968475233271170e-16,  2.965534285737237e-18, -1.453772420765814e-20,  4.637452704734530e-23, -5.868103294594943e-26, -4.330319628559704e-28,  2.176905905846102e-01,
 -1.420632814397658e-03,  6.288240209528241e-06, -2.072567107726800e-08,  4.232367068637430e-11,  3.586031846978163e-14, -8.548640963686966e-16,  4.699587253853575e-18,
 -1.500969105100983e-20,  1.216118937783302e-23,  1.990998270726758e-25, -1.550185129886749e-27,  2.785881118847648e-01, -1.775719941921858e-03,  7.406331953888712e-06,
 -2.103041064779505e-08,  2.133085885980282e-11,  1.835267673709261e-13, -1.398776891395016e-15,  5.122326682380935e-18, -5.534254019455460e-21, -6.358904778719737e-23,
  5.078687248819009e-25, -1.938238612177751e-27,  3.464969153703643e-01, -2.148449445624649e-03,  8.329418045786133e-06, -1.903276263569929e-08, -1.142141011114822e-11,
  3.485007339054450e-13, -1.707066194504729e-15,  3.211318962068069e-18,  1.458132982139497e-20, -1.506190889825054e-22,  5.914183252471272e-25, -3.279220657423042e-28,
  4.211581617311421e-01, -2.528866411685200e-03,  8.957798512871511e-06, -1.438773014908742e-08, -5.356368024041768e-11,  4.918123975761850e-13, -1.542314893827052e-15,
 -1.437388585475576e-18,  3.937212669457803e-20, -1.853924760918830e-22,  1.596184997571124e-25,  3.323239820186253e-27,  5.022556192451481e-01, -2.905713803273514e-03,
  9.194241576559331e-06, -6.989209230453255e-09, -1.001242340836216e-10,  5.647179219012076e-13, -7.355903311612845e-16, -8.035186399412484e-18,  5.566308510946724e-20,
 -9.866158772209620e-23, -8.012421054342176e-25,  6.535650986649436e-27,  5.894046600712843e-01, -3.266458450109981e-03,  8.950731695902542e-06,  2.947930136207319e-09,
 -1.435645132010012e-10,  5.185314106647871e-13,  7.096968044538575e-16, -1.429305170856790e-17,  4.705866854460458e-20,  1.292130132026190e-22, -1.761674132587716e-24,
  4.912287322833170e-27,  6.821392237589687e-01, -3.597384676856876e-03,  8.157036036827205e-06,  1.481461433057886e-08, -1.743579090657028e-10,  3.194965730478961e-13,
  2.525033417974413e-15, -1.674515664528723e-17,  3.312025508568620e-21,  4.098609117424597e-22, -1.725363232683576e-24, -4.044051895361511e-27,  7.798965829724424e-01,
 -3.883789886560620e-03,  6.771175367601844e-06,  2.756001356718056e-08, -1.822984477153609e-10, -3.304049637249702e-14,  4.145380657857703e-15, -1.200369128170195e-17,
 -6.746598986658114e-20,  5.385384154201005e-22,  7.687592285977381e-26, -1.553908897457872e-26,  8.819998536643143e-01, -4.110326982263781e-03,  4.791585519437785e-06,
  3.969412847890428e-08, -1.586569016447214e-10, -4.896491304241487e-13,  4.801250910357977e-15,  1.100946614221510e-18, -1.312855755651535e-19,  2.948977811164722e-22,
  3.059515695775089e-24, -1.667768071487927e-26,  9.876383976557972e-01, -4.261549495237165e-03,  2.270214552226556e-06,  4.937234206256995e-08, -9.911192093225163e-11,
 -9.429421871709492e-13,  3.782279926087166e-15,  1.924618781354041e-17, -1.367024647572776e-19, -3.439791002304916e-22,  4.731949240837798e-24,  2.768571273901031e-27,
  1.095846620201524e+00, -4.322723942536340e-03, -6.750709783489763e-07,  5.459714117525189e-08, -7.018465253059913e-12, -1.239488220886649e-12,  8.555979464920006e-16,
  3.386170688341554e-17, -4.684203711330690e-20, -1.010930587359236e-21,  2.191142892060320e-24,  3.160845219431501e-26,  1.205482232190696e+00, -4.280974840866591e-03,
 -3.851653771881755e-06,  5.356467191437757e-08,  1.039788989856508e-10, -1.221297697671268e-12, -3.307486347994607e-15,  3.396737608856888e-17,  1.148420190251432e-19,
 -1.046991505133371e-21, -4.215590200866204e-24,  3.429664595426147e-26,  1.315205894643128e+00, -4.126811633118788e-03, -6.991356504369952e-06,  4.515488381747620e-08,
  2.096102732929277e-10, -7.976707565317615e-13, -7.005064886016816e-15,  1.339775191304641e-17,  2.435868449991216e-19, -7.557596062355714e-23, -8.540386280700785e-24,
 -1.050633517839062e-26,  1.423465341892350e+00, -3.856039539545978e-03, -9.763608298708174e-06,  2.950232402405831e-08,  2.788806042821663e-10, -2.743800738775895e-14,
 -8.051321293325520e-15, -2.074484760084759e-17,  2.087023013967852e-19,  1.288684592314456e-21, -3.877929561791043e-24, -5.828860108508146e-26,  1.528488570519056e+00,
 -3.471960639612127e-03, -1.180909110249556e-05,  8.486691439771058e-09,  2.835021264493638e-10,  8.372224375883079e-13, -5.108059179124426e-15, -4.663900739955291e-17,
 -1.316004981172973e-20,  1.595404138696187e-21,  6.997677180998771e-24, -3.134663962515343e-26,  1.628292310613444e+00, -2.987612792621270e-03, -1.279840610688339e-05,
 -1.412929455554254e-08,  2.116691163271720e-10,  1.410878826939405e-12,  8.179198409045348e-16, -4.140537409117429e-17, -2.464145441407149e-19,  1.682768721861473e-22,
  1.009090785935863e-23,  4.885156808130142e-26,  1.720713320784804e+00, -2.427575507280559e-03, -1.251383989853115e-05, -3.324070389238534e-08,  8.058277897968176e-11,
  1.370741070887747e-12,  6.161706727436235e-15, -5.004427738397578e-18, -2.453436311415935e-19, -1.452479630881780e-21, -6.161601022669504e-25,  5.176668752465727e-26,
  1.803470255476843e+00, -1.828639039007458e-03, -1.094016114984978e-05, -4.381801318821338e-08, -6.203736487225186e-11,  7.101244427837704e-13,  7.085941809628764e-15,
  3.090984944840261e-17, -2.559391063335421e-21, -1.125313842640595e-21, -8.897435185303129e-24, -2.898823035429002e-26,  1.874261800834259e+00, -1.238498480518109e-03,
 -8.334618893016752e-06, -4.298132591589382e-08, -1.560179496599124e-10, -1.612797079744467e-13,  3.148627367439411e-15,  3.215335906203649e-17,  1.782589177083787e-19,
  4.778600470804537e-22, -2.083953866377554e-24, -3.686139164238798e-26,  1.930901379655831e+00, -7.117744695741470e-04, -5.234988713672337e-06, -3.187390669538023e-08,
 -1.633722001504008e-10, -6.656639169114642e-13, -1.608650131352650e-15,  4.665755338521687e-18,  9.551200597148621e-20,  7.792110537552624e-22,  4.456899653265895e-24,
  1.727692681404005e-26,  1.971480008788959e+00, -3.032377737377378e-04, -2.370935982046716e-06, -1.604120873799144e-08, -9.817138196223350e-11, -5.495579026073735e-13,
 -2.792584184708682e-15, -1.248048162431784e-17, -4.461139052234829e-20, -7.825496213320363e-23,  5.886977950390380e-25,  8.711704137299022e-27,  1.994543361911840e+00,
 -5.906373900745117e-05, -4.777417155741266e-07, -3.418330055692505e-09, -2.279163026180805e-11, -1.448129838501305e-13, -8.866943745413779e-16, -5.262972537114979e-18,
 -3.036914096206205e-20, -1.705109334217886e-22, -9.307441685211149e-25, -4.926269165031351e-27,  9.518870069111372e-04, -6.608512665398543e-06,  3.439560706202236e-08,
 -1.590620654611392e-10,  6.891287892097167e-13, -2.864337238142381e-15,  1.156303804521553e-17, -4.568854386148400e-20,  1.774523152287411e-22, -6.801080851130272e-25,
  2.575203211940896e-27, -9.664149113091717e-30,  8.564249131611907e-03, -5.931588029973264e-05,  3.071030994722513e-07, -1.407170291671079e-09,  6.009990239685733e-12,
 -2.447142643905293e-14,  9.603763925978779e-17, -3.655193598054270e-19,  1.352275579203878e-21, -4.870785240760047e-24,  1.704265594497237e-26, -5.788930442524314e-29,
  2.377426153970276e-02, -1.638706033518125e-04,  8.394296853515380e-07, -3.774424876945959e-09,  1.564648095151514e-11, -6.094876288097018e-14,  2.244545334224152e-16,
 -7.806620342612252e-19,  2.538696014374486e-21, -7.557615622707927e-24,  1.946254566964791e-26, -3.645092272448655e-29,  4.655186693291216e-02, -3.185394199605977e-04,
  1.605287635996214e-06, -7.008298566428201e-09,  2.768264538328846e-11, -9.994663006758226e-14,  3.264396362328536e-16, -9.292639560179107e-19,  2.043468240044407e-21,
 -1.543468046876440e-24, -1.751072700014959e-26,  1.432683739854216e-28,  7.685037043961421e-02, -5.206895367885246e-04,  2.565790648614566e-06, -1.074382291657993e-08,
  3.948109153415388e-11, -1.256834429960809e-13,  3.217004929753034e-16, -4.663007184562461e-19, -1.311167650248431e-21,  1.554290609245416e-23, -8.760667730067947e-26,
  3.724795605764366e-28,  1.146044383580595e-01, -7.667497611733633e-04,  3.669613225967340e-06, -1.452108937417859e-08,  4.796672152607731e-11, -1.220364808096204e-13,
  1.461943330587144e-16,  7.545498818908566e-19, -7.134452830045921e-21,  3.629127454281620e-23, -1.341931723947731e-25,  3.323115237761846e-28,  1.597273096668082e-01,
 -1.052159925992959e-03,  4.853583309875516e-06, -1.781005951110024e-08,  5.000210012675621e-11, -7.628832980267253e-14, -2.200779143167667e-16,  2.526551825792466e-18,
 -1.291458946850834e-20,  4.369980442902853e-23, -7.381259593492798e-26, -2.623017352106635e-28,  2.121071123346668e-01, -1.371310165411264e-03,  6.043615405758537e-06,
 -2.004382566881765e-08,  4.284608974183372e-11,  1.686882271019598e-14, -7.299239663747877e-16,  4.227690979178737e-18, -1.444416214805974e-20,  1.884976649948605e-23,
  1.374645364050662e-25, -1.257046164167493e-27,  2.716021436613334e-01, -1.717472676657435e-03,  7.156130140117438e-06, -2.066152824955688e-08,  2.467719328738410e-11,
  1.516552327320006e-13, -1.258148238360360e-15,  4.912358995616653e-18, -7.478068379714766e-21, -4.494844344555498e-23,  4.250481185240370e-25, -1.816956227853569e-27,
  3.380349380811836e-01, -2.082730265074158e-03,  8.100151324303417e-06, -1.916193963657866e-08, -4.853556221448604e-12,  3.086580266770474e-13, -1.611399633584035e-15,
  3.595693670540939e-18,  9.580066093232367e-21, -1.273934390723546e-22,  5.666525572263494e-25, -7.693712970325079e-28,  4.111849077937244e-01, -2.457908469519863e-03,
  8.780321687828924e-06, -1.516808142898058e-08, -4.410013806143382e-11,  4.544501310636275e-13, -1.565916056211705e-15, -2.827671270564850e-19,  3.284531468271753e-20,
 -1.763940855578705e-22,  2.828627507665443e-25,  2.302350671587070e-27,  4.907793033930702e-01, -2.832521734721672e-03,  9.101128545626874e-06, -8.501874235927933e-09,
 -8.902361558399492e-11,  5.445617197019631e-13, -9.362133503458608e-16, -6.316432768582481e-18,  5.160169777967126e-20, -1.251798944846067e-22, -5.304287852888873e-25,
  5.747122426341179e-27,  5.764822079377983e-01, -3.194749351926454e-03,  8.972669528449634e-06,  7.346554372832731e-10, -1.330550784604660e-10,  5.309356554461463e-13,
  3.311785140097962e-16, -1.272590749759970e-17,  5.049663214834580e-20,  6.334751651803143e-23, -1.525719049021688e-24,  5.721243347993677e-27,  6.678812572516376e-01,
 -3.531464206188758e-03,  8.318294148318383e-06,  1.207914085223179e-08, -1.673998296094763e-10,  3.744961284946119e-13,  2.059774267736094e-15, -1.641670684593460e-17,
  1.678989330890776e-20,  3.381623010141373e-22, -1.838710719233800e-24, -1.182492317091509e-27,  7.644717867678230e-01, -3.828347203832620e-03,  7.084390260482510e-06,
  2.464323906585329e-08, -1.819927754702693e-10,  6.218934499161478e-14,  3.781963812705209e-15, -1.385310393011824e-17, -4.818117051890548e-20,  5.287011274458450e-22,
 -5.488521477362238e-25, -1.281395044351529e-26,  8.656381660030892e-01, -4.070132838191211e-03,  5.252381119052318e-06,  3.708353709663606e-08, -1.672974959671984e-10,
 -3.745133014730528e-13,  4.775017360188055e-15, -2.908183937138164e-18, -1.186488048002633e-19,  4.020151657382427e-22,  2.284705708308553e-24, -1.827854085183200e-26,
  9.706322354984772e-01, -4.241046265198430e-03,  2.852562026004052e-06,  4.764078686744082e-08, -1.170219656213206e-10, -8.462051985387031e-13,  4.258330048494294e-15,
  1.471021513719936e-17, -1.456691897910037e-19, -1.544340670382166e-22,  4.692905972365692e-24, -4.415709589468533e-27,  1.078549067510495e+00, -4.325507631796153e-03,
 -2.139263254231271e-08,  5.428796220748150e-08, -3.152710348047956e-11, -1.207778674547531e-12,  1.777405272723128e-15,  3.180001243738254e-17, -8.133650609726055e-20,
 -8.970140600697130e-22,  3.462387364609280e-24,  2.581233841785307e-26,  1.188300814729056e+00, -4.309190567288561e-03, -3.199714861360149e-06,  5.502894408805878e-08,
  7.883818070107238e-11, -1.288884978124756e-12, -2.310831214880686e-15,  3.700978717233409e-17,  7.449772148083161e-20, -1.183399062101224e-21, -2.560242189582929e-24,
  4.040181934001167e-26,  1.298590296995656e+00, -4.180519307845224e-03, -6.429930977884784e-06,  4.837202960240618e-08,  1.920105615306728e-10, -9.604147479909605e-13,
 -6.521683991229235e-15,  2.108241855529485e-17,  2.346446103513390e-19, -4.221321790822303e-22, -8.678154047402025e-24,  4.471820326756118e-27,  1.407887315126128e+00,
 -3.932656549698156e-03, -9.382860496029914e-06,  3.394934131229859e-08,  2.763565555453796e-10, -2.268436474881026e-13, -8.531946534016802e-15, -1.335904431319736e-17,
  2.516854471143199e-19,  1.082431780856137e-21, -6.420389669651845e-24, -5.631176949852929e-26,  1.514412537976925e+00, -3.565947667567365e-03, -1.167950482442673e-05,
  1.314957598234808e-08,  2.989148497957226e-10,  6.989656519001382e-13, -6.410844912964164e-15, -4.609019362255514e-17,  4.892841046130062e-20,  1.842007910923407e-21,
  5.190569357255407e-24, -5.079878657183152e-26,  1.616136095233470e+00, -3.090618524171886e-03, -1.294670388687721e-05, -1.051619162459049e-08,  2.399845154698267e-10,
  1.415714146991574e-12, -4.503344959622259e-16, -4.911173378928802e-17, -2.325931485956783e-19,  6.126007923734272e-22,  1.205549105917321e-23,  3.925121632606776e-26,
  1.710800304779952e+00, -2.529257726314861e-03, -1.290406185225169e-05, -3.172409021453516e-08,  1.094602697154165e-10,  1.516005013021816e-12,  5.903801473243859e-15,
 -1.369202821850622e-17, -2.974780122104110e-19, -1.426114566231800e-21,  2.070588487415034e-24,  7.043014397748371e-26,  1.795977304251554e+00, -1.918279326122778e-03,
 -1.147143347945522e-05, -4.468745745591184e-08, -4.606436225543470e-11,  8.905235528712507e-13,  7.943677157242811e-15,  3.010869579459845e-17, -4.976692235080557e-20,
 -1.504737952171394e-21, -1.001411567152422e-23, -2.076868656388529e-26,  1.869171126230543e+00, -1.307281189091013e-03, -8.865464807258504e-06, -4.549899415957988e-08,
 -1.584115530375160e-10, -7.424930068537841e-14,  4.131233393543749e-15,  3.811340119626480e-17,  1.935353469916709e-19,  3.581617517416551e-22, -4.001987777789051e-24,
 -5.072718037552840e-26,  1.927968035455425e+00, -7.552297892340321e-04, -5.633605321281721e-06, -3.459641482832975e-08, -1.770590730691790e-10, -7.023312680576678e-13,
 -1.430748550954821e-15,  8.206867315515320e-18,  1.269568756784001e-19,  9.727901529980076e-22,  5.221697955142270e-24,  1.721262928372710e-26,  1.970227864756770e+00,
 -3.230028018179894e-04, -2.573229775360335e-06, -1.770364339159126e-08, -1.098619100398210e-10, -6.209371004819554e-13, -3.162410024581669e-15, -1.394776087954725e-17,
 -4.690223904322877e-20, -4.591363306645960e-23,  1.058736481868119e-24,  1.288818558143310e-26,  1.994299194243310e+00, -6.305617978299265e-05, -5.210491365342179e-07,
 -3.807374621200913e-09, -2.591322558814963e-11, -1.679777620987309e-13, -1.048639578450934e-15, -6.340630918063801e-18, -3.723332138830738e-20, -2.124553724915642e-22,
 -1.176481619499955e-24, -6.301216893801881e-27,  9.259914562517062e-04, -6.340799602957900e-06,  3.255117585866989e-08, -1.484796442837827e-10,  6.345167747116120e-13,
 -2.601555940609899e-15,  1.035971377611705e-17, -4.038273382849493e-20,  1.547245336768812e-22, -5.851209473146947e-25,  2.185569051367448e-27, -8.095854459982281e-30,
  8.331794574862144e-03, -5.692500136047263e-05,  2.907782602561972e-07, -1.314804036785157e-09,  5.542806346946715e-12, -2.228460521158351e-14,  8.638346589333791e-17,
 -3.249253709223251e-19,  1.188607706946623e-21, -4.237455837800165e-24,  1.468481402160119e-26, -4.951049398187656e-29,  2.313192903342903e-02, -1.573321731970530e-04,
  7.955993509960579e-07, -3.533547564983668e-09,  1.447965063608513e-11, -5.581522269997394e-14,  2.036934835031704e-16, -7.036298356860158e-19,  2.280248300385769e-21,
 -6.811180858395874e-24,  1.786144226024210e-26, -3.614909435666399e-29,  4.530287165782830e-02, -3.060261367209366e-04,  1.523780977407533e-06, -6.580950738176368e-09,
  2.575998867779347e-11, -9.241697818724780e-14,  3.013264705683698e-16, -8.648854789581045e-19,  1.976721740777090e-21, -2.127943665435051e-24, -1.195013552419869e-26,
  1.106927784074613e-28,  7.480786332457173e-02, -5.006683645784567e-04,  2.440573353872620e-06, -1.013181982356212e-08,  3.704355082782889e-11, -1.181235557747914e-13,
  3.081361466223377e-16, -4.999506783242913e-19, -8.109080386038380e-22,  1.234917611414821e-23, -7.249328858154034e-26,  3.157053680426355e-28,  1.115950676984505e-01,
 -7.380770049303919e-04,  3.499885050734284e-06, -1.377295029500263e-08,  4.556266153041298e-11, -1.182989153764623e-13,  1.643146824089954e-16,  5.461436862442081e-19,
 -5.921079564139089e-21,  3.121391865665181e-23, -1.197449732720170e-25,  3.227238045779544e-28,  1.555949927769891e-01, -1.014172659505948e-03,  4.644611581186057e-06,
 -1.702249579242701e-08,  4.842900979558787e-11, -8.076654474336016e-14, -1.548878770027467e-16,  2.137866135908060e-18, -1.139694692764405e-20,  4.055723170636440e-23,
 -8.237633560197532e-26, -1.331583103253922e-28,  2.067170626679160e-01, -1.323911672008164e-03,  5.807210880298959e-06, -1.935650172584626e-08,  4.301760570530996e-11,
  7.195839651216822e-16, -6.179106258244997e-16,  3.777293043099001e-18, -1.367920663482060e-20,  2.332061713342864e-23,  8.795435850021211e-26, -9.994347580677696e-28,
  2.648451905276116e-01, -1.661208456608839e-03,  6.910655716283424e-06, -2.024402268388661e-08,  2.741933791506403e-11,  1.230818052680909e-13, -1.124173119857854e-15,
  4.650298220251750e-18, -8.809028001779487e-21, -2.949917545809076e-23,  3.486211411003011e-25, -1.651736847768143e-27,  3.298321618724617e-01, -2.018849692068862e-03,
  7.869939109928902e-06, -1.919227771547900e-08,  9.411850472003215e-13,  2.712231470995345e-13, -1.507087018412719e-15,  3.833179669254315e-18,  5.392857889004595e-21,
 -1.054985092619441e-22,  5.260232586432676e-25, -1.054171389504139e-27,  4.014925902480089e-01, -2.388405281670562e-03,  8.594364417710464e-06, -1.580301420102941e-08,
 -3.538700739607774e-11,  4.168861197223484e-13, -1.560056843140094e-15,  6.690455823108739e-19,  2.672074890053551e-20, -1.633208041000358e-22,  3.644695015643401e-25,
  1.433098274686811e-27,  4.795941552643657e-01, -2.760144191226301e-03,  8.990915087528576e-06, -9.840399862437120e-09, -7.837045189548159e-11,  5.201525711984806e-13,
 -1.090659786744852e-15, -4.740897824410705e-18,  4.677189405503884e-20, -1.416000466313425e-22, -2.971588799475433e-25,  4.845038449940944e-27,  5.638467790500228e-01,
 -3.122968113979321e-03,  8.969063599528073e-06, -1.308962099011708e-09, -1.223847937373654e-10,  5.347923291109861e-13, -2.262651588105605e-18, -1.108480528989673e-17,
  5.174046519407376e-20,  7.475464605932627e-24, -1.265705005767156e-24,  6.022027788387752e-27,  6.538893476379578e-01, -3.464383001081432e-03,  8.447428898736328e-06,
  9.463193848978733e-09, -1.594524346572550e-10,  4.184861491171065e-13,  1.609356911030996e-15, -1.569890072659356e-17,  2.763407574386399e-20,  2.643071154659406e-22,
 -1.836854527333780e-24,  1.177344953040189e-27,  7.492735513617794e-01, -3.770538582406631e-03,  7.362694475406081e-06,  2.174610184184526e-08, -1.798735625123084e-10,
  1.481450193632965e-13,  3.375316733701818e-15, -1.509565624245569e-17, -2.967085859003370e-20,  4.963666664998401e-22, -1.045270717326982e-24, -9.715887737536256e-27,
  8.494444261550402e-01, -4.026379813351517e-03,  5.681095901650085e-06,  3.435304642797467e-08, -1.736505119828900e-10, -2.613051046293605e-13,  4.642725839585728e-15,
 -6.457329910333565e-18, -1.027264587265627e-19,  4.771892479591481e-22,  1.473395992587969e-24, -1.836496471596037e-26,  9.537172655439180e-01, -4.215972090694155e-03,
  3.412477211179861e-06,  4.563872595954910e-08, -1.328934469969034e-10, -7.395932382484392e-13,  4.604376005282177e-15,  9.995580857641954e-18, -1.479142003346218e-19,
  2.749699521869614e-23,  4.358903195883517e-24, -1.055220993762957e-26,  1.061250806080295e+00, -4.323083345327880e-03,  6.262474994777650e-07,  5.359289877270758e-08,
 -5.518562026239309e-11, -1.154759086553475e-12,  2.626715048008727e-15,  2.870938959449261e-17, -1.108816325396606e-19, -7.379400876780324e-22,  4.435764388806263e-24,
  1.819951464165096e-26,  1.171017066890299e+00, -4.332127429793450e-03, -2.532658518740132e-06,  5.608147672819451e-08,  5.259104272140325e-11, -1.331680238901163e-12,
 -1.247707194461733e-15,  3.869585473377428e-17,  3.049017205646258e-20, -1.249234847480946e-21, -7.130307161918977e-25,  4.294024142006235e-26,  1.281769088881952e+00,
 -4.229586185399033e-03, -5.831694445372435e-06,  5.128224371772305e-08,  1.712891941124170e-10, -1.109019418680116e-12, -5.829014132241411e-15,  2.828156216984248e-17,
  2.132887956551875e-19, -7.607330192769851e-22, -8.138517396091158e-24,  2.000976782692751e-26,  1.392009248883919e+00, -4.006015113948646e-03, -8.949124233809536e-06,
  3.832351519747211e-08,  2.697465665693811e-10, -4.351547927985919e-13, -8.787767511564408e-15, -4.735934956494812e-18,  2.854498446933738e-19,  7.779790217171323e-22,
 -8.743754156215842e-24, -4.828233180742333e-26,  1.499962990710215e+00, -3.658670215724079e-03, -1.149258103863315e-05,  1.803525354392222e-08,  3.112522067308062e-10,
  5.298585848007256e-13, -7.669222740978381e-15, -4.342812335381973e-17,  1.183884853366816e-19,  1.999383408209343e-21,  2.545037746825987e-24, -6.903935566806141e-26,
  1.603565769627466e+00, -3.194629510988071e-03, -1.304892851704679e-05, -6.450994730754914e-09,  2.680750848640144e-10,  1.387587303639434e-12, -1.925667533151172e-15,
 -5.610566849628618e-17, -2.014833301229560e-19,  1.124858701036054e-21,  1.343177211780721e-23,  2.199856707488482e-26,  1.700474442987138e+00, -2.633980850653015e-03,
 -1.327321765202410e-05, -2.972261684140652e-08,  1.411604708181960e-10,  1.651973335752929e-12,  5.379587079460001e-15, -2.401039413870057e-17, -3.465310028056000e-19,
 -1.275902894933321e-21,  5.570548200399405e-24,  8.830661207399398e-26,  1.788117231947011e+00, -2.012206899120608e-03, -1.201148307412632e-05, -4.527136219985813e-08,
 -2.628027480234588e-11,  1.091055511436851e-12,  8.755720970239471e-15,  2.757055204238334e-17, -1.113332977350849e-19, -1.919673404567761e-21, -1.062218612441505e-23,
 -5.573866484019307e-27,  1.863796635181221e+00, -1.380432023217272e-03, -9.426690778449271e-06, -4.803969619688711e-08, -1.588149388832093e-10,  3.841692359228538e-14,
  5.286803945602344e-15,  4.447730042657294e-17,  2.029682949859982e-19,  1.488530210879668e-22, -6.580451586235242e-24, -6.677579853318702e-26,  1.924854279872911e+00,
 -8.020084990258307e-04, -6.066229318062117e-06, -3.754351187890661e-08, -1.914279496564130e-10, -7.334188134203350e-13, -1.138518978869008e-15,  1.287158287965573e-17,
  1.659155297437116e-19,  1.196335968544675e-21,  5.939141660588203e-24,  1.493165032908498e-26,  1.968893292930296e+00, -3.444692686312080e-04, -2.796643786120400e-06,
 -1.956504352139472e-08, -1.230721458094651e-10, -7.016921931314661e-13, -3.574142870339543e-15, -1.546570404841361e-17, -4.764201497103976e-20,  9.358286441905925e-24,
  1.747334359962136e-24,  1.872900836615302e-26,  1.994038333078648e+00, -6.741463977456308e-05, -5.693407673893445e-07, -4.250292977418598e-09, -2.953956191291985e-11,
 -1.954176054467973e-13, -1.244075615430514e-15, -7.664124941521611e-18, -4.580000106824538e-20, -2.655492082658334e-22, -1.491112432134163e-24, -8.074508656556424e-27,
  9.011380307498504e-04, -6.087348498917591e-06,  3.082865944341013e-08, -1.387304903934700e-10,  5.848832102067812e-13, -2.365950801665491e-15,  9.295263523340391e-18,
 -3.575237831145924e-20,  1.351516122611569e-22, -5.044228902528466e-25,  1.858775339577416e-27, -6.798755687296908e-30,  8.108649181160372e-03, -5.466041138467094e-05,
  2.755183699987284e-07, -1.229575045757989e-09,  5.117130972775129e-12, -2.031641595396334e-14,  7.779590287322036e-17, -2.892214610351179e-19,  1.046127354801275e-21,
 -3.691452679835642e-24,  1.266716931615337e-26, -4.239186643829058e-29,  2.251506683110793e-02, -1.511331333533418e-04,  7.545508310796605e-07, -3.310544527201786e-09,
  1.341067845520727e-11, -5.115497505678889e-14,  1.849775023865061e-16, -6.344503343905623e-19,  2.047525300578356e-21, -6.128238535354421e-24,  1.629429617169970e-26,
 -3.497044296992930e-29,  4.410265716412553e-02, -2.941449057815163e-04,  1.447222782870022e-06, -6.183192812173239e-09,  2.398204253604347e-11, -8.546867044424361e-14,
  2.779831270789109e-16, -8.029392992119464e-19,  1.892611123035482e-21, -2.516616706206215e-24, -7.672536348208105e-27,  8.472021293661442e-29,  7.284348301287658e-02,
 -4.816202062142832e-04,  2.322471023769001e-06, -9.557625776920999e-09,  3.475388501754260e-11, -1.108988124971630e-13,  2.938372374042846e-16, -5.193200015948903e-19,
 -4.153236084524926e-22,  9.712155273312656e-24, -5.971915108413539e-26,  2.660770422637424e-28,  1.086977283560925e-01, -7.107268114927252e-04,  3.338906292789619e-06,
 -1.306265644356619e-08,  4.323725103527273e-11, -1.141922634118510e-13,  1.771165604663357e-16,  3.737514242026293e-19, -4.880215418105683e-21,  2.670332775995712e-23,
 -1.059151982351009e-25,  3.048414150836368e-28,  1.516113406479344e-01, -9.778197979430974e-04,  4.444936910313959e-06, -1.626073662855018e-08,  4.678114714577093e-11,
 -8.380541601976969e-14, -9.991855287978927e-17,  1.795879248664538e-18, -9.997330098831451e-21,  3.717524626623384e-23, -8.603017680142460e-26, -3.793566889892372e-29,
  2.015128767736587e-01, -1.278371400226082e-03,  5.579060510742251e-06, -1.866887557651110e-08,  4.289201347164017e-11, -1.288976664386819e-14, -5.181441309601672e-16,
  3.353588202421747e-18, -1.278631401334974e-20,  2.602700708513054e-23,  4.897572392343544e-26, -7.782798732701983e-28,  2.583093994108625e-01, -1.606887288129713e-03,
  6.670436305559272e-06, -1.978704242404151e-08,  2.962155090018898e-11,  9.763140864926959e-14, -9.980524832269744e-16,  4.353970218412518e-18, -9.637015025430806e-21,
 -1.695370144006422e-23,  2.800190983006866e-25, -1.464364239901312e-27,  3.218812244059237e-01, -1.956810752843854e-03,  7.639894872907200e-06, -1.913575149348685e-08,
  6.012727167572926e-12,  2.363571411733110e-13, -1.397884535601685e-15,  3.948950703927009e-18,  1.961954781122134e-21, -8.544019011061680e-23,  4.757368830128221e-25,
 -1.213327768040754e-27,  3.920752651531574e-01, -2.320417915787996e-03,  8.401599671185092e-06, -1.630453081524003e-08, -2.742170456948510e-11,  3.797608477281541e-13,
 -1.530215855024076e-15,  1.432960382141924e-18,  2.111678560059621e-20, -1.477014857109334e-22,  4.113225670593468e-25,  7.226357991743148e-28,  4.686966562067054e-01,
 -2.688709745302474e-03,  8.865645303418916e-06, -1.101256705333699e-08, -6.823905735745927e-11,  4.925481396363230e-13, -1.203231477856770e-15, -3.327652332233405e-18,
  4.150921827040555e-20, -1.494969901196613e-22, -1.044719339570072e-25,  3.914645905132299e-27,  5.514982662058947e-01, -3.051310911672815e-03,  8.941959787286153e-06,
 -3.181657138111617e-09, -1.117136637798179e-10,  5.312005365783518e-13, -2.894836748523318e-16, -9.434057274002747e-18,  5.116213505731836e-20, -3.785820475469202e-23,
 -1.001746969095488e-24,  5.918228400104611e-27,  6.401676333239351e-01, -3.396392058649915e-03,  8.545962386182623e-06,  6.980863731602449e-09, -1.507315192253875e-10,
  4.519440972423369e-13,  1.183497846079754e-15, -1.467641361769520e-17,  3.584435466201842e-20,  1.924401215575234e-22, -1.743383992892602e-24,  2.977551382868529e-27,
  7.343107841080770e-01, -3.710641886268459e-03,  7.606491471698258e-06,  1.889608402531492e-08, -1.761353085955801e-10,  2.239893936178356e-13,  2.941970051270024e-15,
 -1.576806615498333e-17, -1.264875724548664e-20,  4.469415168116300e-22, -1.402919447072737e-24, -6.552742397414075e-27,  8.334323481112806e-01, -3.979329691031243e-03,
  6.076508975535580e-06,  3.153881558421603e-08, -1.777788561364508e-10, -1.524045651948558e-13,  4.418553706886566e-15, -9.459907059541638e-18, -8.467924130736658e-20,
  5.202335224257523e-22,  6.875934854892052e-25, -1.716508541652458e-26,  9.369113928961322e-01, -4.186518845916263e-03,  3.946915706019296e-06,  4.340018555434922e-08,
 -1.465603475782880e-10, -6.262624631416829e-13,  4.818369723414498e-15,  5.310815926995702e-18, -1.439115601863497e-19,  1.910777062300594e-22,  3.786151591047578e-24,
 -1.521426892177402e-26,  1.043972542243518e+00, -4.315517648333393e-03,  1.263314148214740e-06,  5.252885842890366e-08, -7.758744923109800e-11, -1.082495804950441e-12,
  3.377161744874885e-15,  2.477178646742481e-17, -1.340832832419809e-19, -5.469793680798575e-22,  5.049685687367848e-24,  9.620869737669700e-27,  1.153652314342252e+00,
 -4.349684515186213e-03, -1.855515227005769e-06,  5.670860739805620e-08,  2.574614345679135e-11, -1.348554811725285e-12, -1.573423601810072e-16,  3.895017139491817e-17,
 -1.454073348147223e-20, -1.240067278070254e-21,  1.162144578314188e-24,  4.167186235981414e-26,  1.264761397971816e+00, -4.273733336303824e-03, -5.200619564385326e-06,
  5.383810945253668e-08,  1.477778554598815e-10, -1.238669404460104e-12, -4.946130766013831e-15,  3.460777843352187e-17,  1.802949181386128e-19, -1.064290288196355e-21,
 -6.934436839749083e-24,  3.438688038821223e-26,  1.375845017644205e+00, -4.075695944056127e-03, -8.463670780555865e-06,  4.255835003795903e-08,  2.589291006037729e-10,
 -6.465969342535896e-13, -8.788786023087501e-15,  4.775132259349587e-18,  3.066825498763902e-19,  3.894403323333098e-22, -1.058140857441243e-23, -3.432492951026917e-26,
  1.485145919728346e+00, -3.749659772869739e-03, -1.124596158163210e-05,  2.308966068230886e-08,  3.199127667231138e-10,  3.317005398895606e-13, -8.821247220536489e-15,
 -3.847462309609249e-17,  1.914241152253819e-19,  2.035830449427400e-21, -8.274870560361915e-25, -8.338431130724590e-26,  1.590578084149354e+00, -3.299255580333229e-03,
 -1.309969906192286e-05, -1.942837192564386e-09,  2.952338301643651e-10,  1.321832378705274e-12, -3.580054739264447e-15, -6.180002796031218e-17, -1.511454710328343e-19,
  1.674657800802609e-21,  1.387543762086661e-23, -3.075588461863549e-27,  1.689723946755305e+00, -2.741552326482429e-03, -1.361522530312577e-05, -2.719297024283006e-08,
  1.754299330066445e-10,  1.771722166381416e-12,  4.545496966228529e-15, -3.578342329484924e-17, -3.874743673793054e-19, -9.708354981728976e-22,  9.785645395410984e-24,
  1.023626452971924e-25,  1.779872772187656e+00, -2.110477203480366e-03, -1.255650454821611e-05, -4.550560587257925e-08, -2.297623795174683e-12,  1.309987145965951e-12,
  9.466844199756411e-15,  2.282003839056926e-17, -1.880920710277969e-19, -2.343126086810114e-21, -1.037700693121982e-23,  1.825777206778203e-26,  1.858120368170085e+00,
 -1.458194547186199e-03, -1.001836449148507e-05, -5.056725784627786e-08, -1.566730859532827e-10,  1.809815119412146e-13,  6.623506797966724e-15,  5.100117688975893e-17,
  2.028352520461687e-19, -1.781600991901161e-22, -9.895699454239262e-24, -8.397429505281903e-26,  1.921546257911358e+00, -8.523936143309282e-04, -6.535617047352548e-06,
 -4.072505685505925e-08, -2.063371021618910e-10, -7.557770019318692e-13, -6.969759781829375e-16,  1.891702556941533e-17,  2.134057771894269e-19,  1.445624347229859e-21,
  6.482471206670647e-24,  9.023304102491070e-27,  1.967469133906941e+00, -3.678161142286601e-04, -3.043717858137929e-06, -2.165127961139836e-08, -1.379997472989838e-10,
 -7.928395362903835e-13, -4.028369426320633e-15, -1.696962901706294e-17, -4.582878682439421e-20,  9.792552470111152e-23,  2.739756664064383e-24,  2.680383026577278e-26,
  1.993759230296463e+00, -7.218172268674777e-05, -6.233145184441688e-07, -4.755891118839046e-09, -3.376476935547793e-11, -2.280254416728564e-13, -1.480712943247204e-15,
 -9.294924641427418e-18, -5.652467149832154e-20, -3.329304936250666e-22, -1.894586448591674e-24, -1.036071891814962e-26,  8.772715717389724e-04, -5.847222717826588e-06,
  2.921851917324832e-08, -1.297391219149713e-10,  5.397164273589301e-13, -2.154404848188713e-15,  8.352113933409451e-18, -3.170428958058190e-20,  1.182616536646941e-22,
 -4.357237034439000e-25,  1.584009431345680e-27, -5.723699183394930e-30,  7.894324306916280e-03, -5.251392240251697e-05,  2.612416264356223e-07, -1.150852817759258e-09,
  4.728836757517202e-12, -1.854282928389343e-14,  7.014706550058103e-17, -2.577774080282701e-19,  9.219228901632709e-22, -3.220218740588552e-24,  1.093855837615650e-26,
 -3.634392338232820e-29,  2.192236055873188e-02, -1.452520613553577e-04,  7.160787247580988e-07, -3.103923166594884e-09,  1.243057203654146e-11, -4.692148588676352e-14,
  1.680978978738961e-16, -5.723365799508495e-19,  1.838274070020683e-21, -5.506763137084219e-24,  1.479207369390504e-26, -3.324427335076851e-29,  4.294877222361773e-02,
 -2.828575212527305e-04,  1.375271489493601e-06, -5.812800150817819e-09,  2.233759901805597e-11, -7.906010497422994e-14,  2.563347145561339e-16, -7.438776465357485e-19,
  1.797327938904792e-21, -2.755388598962615e-24, -4.416287177910505e-27,  6.407713668896517e-29,  7.095344847119713e-02, -4.634899171061456e-04,  2.211043921794992e-06,
 -9.018929229848050e-09,  3.260524543792820e-11, -1.040224049957205e-13,  2.791596163434345e-16, -5.274550819647803e-19, -1.059825992865526e-22,  7.544418665261854e-24,
 -4.898084347862111e-26,  2.230694294995309e-28,  1.059072672250899e-01, -6.846309801827125e-04,  3.186230581794708e-06, -1.238889697743290e-08,  4.099667387325355e-11,
 -1.098326726723869e-13,  1.855341027665002e-16,  2.321738373852477e-19, -3.991980289654750e-21,  2.272852466759708e-23, -9.299159448819933e-26,  2.819997744308320e-28,
  1.477699624257918e-01, -9.430282216951817e-04,  4.254243372449649e-06, -1.552576097258677e-08,  4.508494975755971e-11, -8.563498341041220e-14, -5.391629275128305e-17,
  1.496711548599594e-18, -8.721163628412029e-21,  3.372244247573222e-23, -8.611527055928395e-26,  3.008328388871861e-29,  1.964872537457441e-01, -1.234623379367150e-03,
  5.359141026486140e-06, -1.798531027803390e-08,  4.251723425268285e-11, -2.424377777631130e-14, -4.298287470064846e-16,  2.959732293568570e-18, -1.182180669759341e-20,
  2.735836735609042e-23,  1.894657082242565e-26, -5.922944577402608e-28,  2.519870849839339e-01, -1.554465378512290e-03,  6.435895798045175e-06, -1.929873722832969e-08,
  3.134433906360653e-11,  7.510574588075034e-14, -8.805357542375821e-16,  4.037859530323936e-18, -1.006074427751662e-20, -6.984625911692298e-24,  2.198454597726971e-25,
 -1.270840777491565e-27,  3.141747681632581e-01, -1.896608126863479e-03,  7.410993270792833e-06, -1.900351587113381e-08,  1.041335899709801e-11,  2.041391407925958e-13,
 -1.286871790683971e-15,  3.966086384407808e-18, -7.844618285763847e-22, -6.750293030984725e-23,  4.206739195491226e-25, -1.275822217166353e-27,  3.829267701552671e-01,
 -2.253994630255698e-03,  8.203557036737446e-06, -1.668449680042915e-08, -2.019011526660042e-11,  3.435887019200270e-13, -1.481409058108587e-15,  2.026848401626964e-18,
  1.610173698875271e-20, -1.307873871708431e-22,  4.303264030356137e-25,  1.655308076280067e-28,  4.580828053655027e-01, -2.618331008784421e-03,  8.727263468397299e-06,
 -1.202718232529283e-08, -5.868366269204160e-11,  4.626975966586791e-13, -1.278622569099048e-15, -2.085953330978382e-18,  3.609117215444965e-20, -1.504988230327613e-22,
  4.785200292223937e-26,  3.018984712530418e-27,  5.394358102727195e-01, -2.979957534493831e-03,  8.893404522054266e-06, -4.884547662012409e-09, -1.011795757646609e-10,
  5.212665641238319e-13, -5.309737438303855e-16, -7.825905043516546e-18,  4.913986082360431e-20, -7.282016471620844e-23, -7.492873135315810e-25,  5.516679084442107e-27,
  6.267192740697467e-01, -3.327729580776869e-03,  8.615565431335416e-06,  4.642876450487690e-09, -1.414411886108268e-10,  4.755523107128226e-13,  7.895636739088894e-16,
 -1.343172641706830e-17,  4.155229458499226e-20,  1.257299687091121e-22, -1.583085142750904e-24,  4.219278405314329e-27,  7.195912893723373e-01, -3.648930486625302e-03,
  7.816495338525964e-06,  1.611744297133546e-08, -1.709853846287413e-10,  2.892673335965269e-13,  2.497136186207285e-15, -1.592672851329271e-17,  2.369752094918357e-21,
  3.859554614679854e-22, -1.624669447551677e-24, -3.574298497884898e-27,  8.176145819148330e-01, -3.929252306617450e-03,  6.437825810469233e-06,  2.867563560562436e-08,
 -1.797894580963963e-10, -4.982654627864205e-14,  4.118584965047825e-15, -1.186612377712163e-17, -6.563260595359157e-20,  5.332130302678770e-22, -2.273399293685120e-26,
 -1.498975812264251e-26,  9.202317090953450e-01, -4.152901086660458e-03,  4.453255274677102e-06,  4.096134244116450e-08, -1.579198019264896e-10, -5.093501724043220e-13,
  4.903834799678445e-15,  8.435642036646182e-19, -1.344773904295366e-19,  3.281356458007771e-22,  3.045130302798789e-24, -1.818178641801971e-26,  1.026734644944320e+00,
 -4.302912469376969e-03,  1.885512495019899e-06,  5.111889061662841e-08, -9.837324192374713e-11, -9.936222312865638e-13,  4.008024175223578e-15,  2.020571870432703e-17,
 -1.500601843322698e-19, -3.390964202223921e-22,  5.281343841340284e-24,  9.679286515316862e-28,  1.136228205076611e+00, -4.361801670197176e-03, -1.173430009497664e-06,
  5.690494108429741e-08, -1.174821284713863e-12, -1.339337191286177e-12,  9.201213645533546e-16,  3.778308126936810e-17, -5.791486753838905e-20, -1.158094871220403e-21,
  2.901070387488312e-24,  3.682115181412486e-26,  1.247587400623556e+00, -4.312715790987906e-03, -4.541213063667122e-06,  5.599825900440905e-08,  1.218990988265434e-10,
 -1.345133621935226e-12, -3.902464211397159e-15,  3.971383375719776e-17,  1.373860418734425e-19, -1.307750296789265e-21, -5.154257476025765e-24,  4.594023497614310e-26,
  1.359410147609667e+00, -4.141293137762111e-03, -7.928577091708318e-06,  4.658636510864946e-08,  2.439044586727389e-10, -8.548044239885700e-13, -8.516178890806872e-15,
  1.472895711897530e-17,  3.127670763694319e-19, -5.876743580774979e-23, -1.169115353489898e-23, -1.543061774932791e-26,  1.469969223480709e+00, -3.838431717851165e-03,
 -1.093799333536878e-05,  2.824948116835113e-08,  3.243462810320549e-10,  1.078226331983388e-13, -9.801848759357036e-15, -3.119015806822609e-17,  2.632071858620454e-19,
  1.926512665996723e-21, -4.694906004698293e-24, -9.110493993730224e-26,  1.577171434964334e+00, -3.404064149515317e-03, -1.309381500289945e-05,  2.987131460980487e-09,
  3.206685278175063e-10,  1.214659232892692e-12, -5.368345850545472e-15, -6.556575304830788e-17, -8.098071706304385e-20,  2.218026891294086e-21,  1.306100154850644e-23,
 -3.489012578150077e-26,  1.678537898140736e+00, -2.851728944805169e-03, -1.392351212798784e-05, -2.409705469108963e-08,  2.118667711905682e-10,  1.867360384398382e-12,
  3.365308900064389e-15, -4.865728231625235e-17, -4.142686520991751e-19, -4.867486623292277e-22,  1.446582135191444e-23,  1.087642498192071e-25,  1.771226502720126e+00,
 -2.213112061492772e-03, -1.310188724920150e-05, -4.532022116078201e-08,  2.622206149088071e-11,  1.544098041496027e-12,  1.000829958510354e-14,  1.537344630659247e-17,
 -2.796403916597321e-19, -2.732987032601859e-21, -8.871717530970199e-24,  5.180220762602859e-26,  1.852123393311791e+00, -1.540810972904069e-03, -1.064006341821559e-05,
 -5.303593450406761e-08, -1.513443885167728e-10,  3.578066806971868e-13,  8.140857749516091e-15,  5.730536356949244e-17,  1.883607421363069e-19, -6.528439441812852e-22,
 -1.395759497129399e-23, -1.002728476548611e-25,  1.918028937722652e+00, -9.066906308637270e-04, -7.044627321398185e-06, -4.414808905968943e-08, -2.215728138660442e-10,
 -7.653267368047767e-13, -6.350926029740906e-17,  2.662934657455594e-17,  2.701857332565006e-19,  1.709964207062358e-21,  6.651065739069840e-24, -2.476554122302470e-27,
  1.965947469842309e+00, -3.932438945048095e-04, -3.317321927626045e-06, -2.399154737041205e-08, -1.548626734840017e-10, -8.953838408574354e-13, -4.523355349448425e-15,
 -1.835611204896822e-17, -4.001968655798889e-20,  2.341060205302197e-22,  4.149437493106907e-24,  3.782464078918525e-26,  1.993460155486705e+00, -7.740606522330116e-05,
 -6.837836320033633e-07, -5.334634660967027e-09, -3.870283549070111e-11, -2.669016606741588e-13, -1.768205381503099e-15, -1.131104766172470e-17, -6.999144786749229e-20,
 -4.186443986746497e-22, -2.412523327258075e-24, -1.330374125280842e-26,  8.543405200221963e-04, -5.619558444828395e-06,  2.771207505285670e-08, -1.214377670089967e-10,
  4.985630825330294e-13, -1.964193189547462e-15,  7.515101322386004e-18, -2.815914088279040e-20,  1.036579169844548e-22, -3.771253927449377e-25,  1.352403616054910e-27,
 -4.831087391598648e-30,  7.688362797962555e-03, -5.047797168544565e-05,  2.478734124212496e-07, -1.078069205958076e-09,  4.374247613490928e-12, -1.694268342171093e-14,
  6.332547611874108e-17, -2.300493084037320e-19,  8.134998220520262e-22, -2.813085838307577e-24,  9.455485531122728e-27, -3.120695741999109e-29,  2.135257835581645e-02,
 -1.396691086768019e-04,  6.799947089345331e-07, -2.912327583453113e-09,  1.153122134592836e-11, -4.307297339406366e-14,  1.528670155701155e-16, -5.165723370603631e-19,
  1.650333643057105e-21, -4.943752467372549e-24,  1.337328104352011e-26, -3.121211554700790e-29,  4.183891313152212e-02, -2.721284059514678e-04,  1.307611181207219e-06,
 -5.467720888829967e-09,  2.081626333107118e-11, -7.315160831970033e-14,  2.362962185415733e-16, -6.879791458558179e-19,  1.695586789337212e-21, -2.880748001368121e-24,
 -1.970786385682184e-27,  4.771046663673414e-29,  6.913419238180191e-02, -4.462257614820214e-04,  2.105879385251772e-06, -8.513529888683110e-09,  3.059059841440629e-11,
 -9.749994444301023e-14,  2.643816361500863e-16, -5.268605587617099e-19,  1.326119836187701e-22,  5.770177316710657e-24, -4.000080520346352e-26,  1.860449877817844e-28,
  1.032187969621077e-01, -6.597248168518441e-04,  3.041427798324193e-06, -1.175027952659068e-08,  3.884500368931040e-11, -1.053155478292489e-13,  1.903645899844750e-16,
  1.168280355724671e-19, -3.237783768321946e-21,  1.924966383610416e-23, -8.113668162061168e-26,  2.565932200282149e-28,  1.440647546156527e-01, -9.097273786894027e-04,
  4.072205686721401e-06, -1.481815998519427e-08,  4.336254641359698e-11, -8.645651702745031e-14, -1.573766501692556e-17,  1.236397148856890e-18, -7.568699826861201e-21,
  3.031938729826736e-23, -8.369908793051391e-26,  7.662108759128900e-29,  1.916331558747314e-01, -1.192602021716135e-03,  5.147381216310718e-06, -1.730944661185294e-08,
  4.193569542172615e-11, -3.360703123730789e-14, -3.521035869049750e-16,  2.597291073275061e-18, -1.082910882124118e-20,  2.764242928595625e-23, -3.626272654396222e-27,
 -4.388492794504904e-28,  2.458707432761946e-01, -1.503895918965650e-03,  6.207365961716457e-06, -1.878632131908441e-08,  3.264409447695376e-11,  5.529305462659440e-14,
 -7.720092182277899e-16,  3.713483773350669e-18, -1.016686589342353e-20,  7.469877547777708e-25,  1.681087490771305e-25, -1.082372028991941e-27,  3.067054716752500e-01,
 -1.838229217449038e-03,  7.184080161871916e-06, -1.880588026699793e-08,  1.419626389272804e-11,  1.745818541960309e-13, -1.176515619851305e-15,  3.905239519028578e-18,
 -2.925235915529664e-21, -5.180055411529223e-23,  3.645093069728944e-25, -1.267324440629467e-27,  3.740407734449348e-01, -2.189172011715380e-03,  8.001625390262914e-06,
 -1.695447592123549e-08, -1.366899962887640e-11,  3.087698979325706e-13, -1.418127818473700e-15,  2.470098703719067e-18,  1.170375845201881e-20, -1.135610744565177e-22,
  4.279514165619667e-25, -2.518561420569213e-28,  4.477481818589676e-01, -2.549105475366529e-03,  8.577603579640196e-06, -1.289377421099232e-08, -4.974065782157281e-11,
  4.314352935309284e-13, -1.321670851790065e-15, -1.017108840588590e-18,  3.073741583086630e-20, -1.461755891085783e-22,  1.623459975282937e-25,  2.200560625982785e-27,
  5.276578655670336e-01, -2.909071489980027e-03,  8.825418307992567e-06, -6.420781952482164e-09, -9.089852000244687e-11,  5.060687623946547e-13, -7.285170681044537e-16,
 -6.300693277165418e-18,  4.603586407316018e-20, -9.810217062908598e-23, -5.191877643099112e-25,  4.917408498391259e-27,  6.135465042994067e-01, -3.258619942354853e-03,
  8.658018451506384e-06,  2.456810275994223e-09, -1.317703175550134e-10,  4.901427865307336e-13,  4.326862606605640e-16, -1.204147520241594e-17,  4.498582756261334e-20,
  6.636891927565137e-23, -1.379672280217855e-24,  4.947474993480239e-27,  7.051217912239554e-01, -3.585670934588581e-03,  7.993691108035949e-06,  1.343106454790913e-08,
 -1.646367499815647e-10,  3.438681735922929e-13,  2.054247263237243e-15, -1.564138768631737e-17,  1.506382591031173e-20,  3.186236832314955e-22, -1.722870934525821e-24,
 -9.606675845862996e-28,  8.020026881538825e-01, -3.876422213778320e-03,  6.764657842696751e-06,  2.579628565501835e-08, -1.798255923982834e-10,  4.481284722581954e-14,
  3.759807345840438e-15, -1.366065536966764e-17, -4.660511193590668e-20,  5.199046079908651e-22, -6.222097788317372e-25, -1.218361647850922e-26,  9.036944082855225e-01,
 -4.115352586874115e-03,  4.929315626874228e-06,  3.835952361323121e-08, -1.669304356798387e-10, -3.918492536500409e-13,  4.869142978384091e-15, -3.248794262043919e-18,
 -1.206694961991251e-19,  4.334504036868898e-22,  2.211483915004902e-24, -1.943700587907228e-26,  1.009557008579765e+00, -4.285402895623931e-03,  2.488856992220380e-06,
  4.939134811834852e-08, -1.172407810600340e-10, -8.911929698670664e-13,  4.505012597593311e-15,  1.524918309247391e-17, -1.584768706944532e-19, -1.293981121249377e-22,
  5.145869065238468e-24, -6.944252374623106e-27,  1.118766545168007e+00, -4.368460018880974e-03, -4.915626025991186e-07,  5.667340527373966e-08, -2.765628657722403e-11,
 -1.304806229303165e-12,  1.946011602488626e-15,  3.528818562882995e-17, -9.714591698548692e-20, -1.011757929819426e-21,  4.358935868997530e-24,  2.903237950331147e-26,
  1.230268177992559e+00, -4.346326498263575e-03, -3.858434861016672e-06,  5.772872083600306e-08,  9.415228396857756e-11, -1.424996949717513e-12, -2.736265476230786e-15,
  4.332124248328918e-17,  8.710656591697899e-20, -1.470982264985706e-21, -2.953500965666485e-24,  5.331905623249580e-26,  1.342721750245246e+00, -4.202420637630991e-03,
 -7.346725593638934e-06,  5.034112315241773e-08,  2.248037173918579e-10, -1.053118029700617e-12, -7.964615822806667e-15,  2.461244528817983e-17,  3.021275219892167e-19,
 -5.336624563504288e-22, -1.189295160001192e-23,  6.586750301242952e-27,  1.454442760335239e+00, -3.924491387802271e-03, -1.056783332677630e-05,  3.344321267472369e-08,
  3.240847361229087e-10, -1.368872801640913e-13, -1.054713408846705e-14, -2.170197701198843e-17,  3.282107527815405e-19,  1.658187408762482e-21, -8.712818184751362e-24,
 -8.991050521541814e-26,  1.563346029858018e+00, -3.508582267704317e-03, -1.302640796354269e-05,  8.304544585691290e-09,  3.435234189197511e-10,  1.063573312839610e-12,
 -7.227763883558951e-15, -6.678234285064656e-17,  7.807842280973917e-21,  2.699358368845029e-21,  1.074313483869648e-23, -7.085683277126897e-26,  1.666906459923321e+00,
 -2.964213208203591e-03, -1.419109223224908e-05, -2.040451066203961e-08,  2.499035030255615e-10,  1.930268988769029e-12,  1.815528705998428e-15, -6.207322759375237e-17,
 -4.202267127672627e-19,  1.869867853795713e-22,  1.918142426599039e-23,  1.032729925389800e-25,  1.762160993212605e+00, -2.320092965233433e-03, -1.364215085195033e-05,
 -4.464043469203870e-08,  5.953526097571158e-11,  1.788358294436047e-12,  1.029822724266409e-14,  4.787429303874456e-18, -3.837578577013862e-19, -3.030234733647221e-21,
 -5.676471862754102e-24,  9.490822605456553e-26,  1.845785820365500e+00, -1.628517755187002e-03, -1.129075163473024e-05, -5.538902248951941e-08, -1.421010672777429e-10,
  5.730971943843795e-13,  9.825440919749658e-15,  6.284024024882760e-17,  1.537085708319963e-19, -1.303372919091439e-21, -1.865653190728105e-23, -1.122291626038455e-25,
  1.914286019290556e+00, -9.652281880172536e-04, -7.596180027533209e-06, -4.781551734053671e-08, -2.368288982105758e-10, -7.568678015675702e-13,  8.127733975673466e-16,
  3.631106998676913e-17,  3.364616973063092e-19,  1.968727692467855e-21,  6.144055501307904e-24, -2.216943530682333e-26,  1.964319532444889e+00, -4.209775870298644e-04,
 -3.620697856218404e-06, -2.661868725813574e-08, -1.738982976463159e-10, -1.010247716566658e-12, -5.053739927731331e-15, -1.946637099087983e-17, -2.816679581237756e-20,
  4.374233708374860e-22,  6.124226938038770e-24,  5.264023879912339e-26,  1.993139169839161e+00, -8.314334513880751e-05, -7.516986497246897e-07, -5.999002453993002e-09,
 -4.449226106584836e-11, -3.134068120541158e-13, -2.118676304506300e-15, -1.381174408448395e-17, -8.695012991175580e-20, -5.278970426679156e-22, -3.077592258041238e-24,
 -1.708056389924168e-26,  8.322966377640266e-04, -5.403558171273306e-06,  2.630141856436952e-08, -1.137654903951937e-10,  4.610208633805920e-13, -1.792929583581228e-15,
  6.771115218380280e-18, -2.504927312532002e-20,  9.100600229547156e-23, -3.270522136522369e-25,  1.156657031450409e-27, -4.089030845795286e-30,  7.490336598980609e-03,
 -4.854556713965833e-05,  2.353455891771940e-07, -1.010711635388476e-09,  4.050085122389269e-12, -1.549731797682460e-14,  5.723382425645513e-17, -2.055672600227078e-19,
  7.187180180988627e-22, -2.460992998722508e-24,  8.180896101297664e-27, -2.684735777297815e-29,  2.080456484282875e-02, -1.343658704369419e-04,  6.461259795469903e-07,
 -2.734525191547872e-09,  1.070530853254882e-11, -3.957192654284783e-14,  1.391163047081445e-16, -4.665086687216358e-19,  1.481662084062491e-21, -4.435656329949977e-24,
  1.204727495731298e-26, -2.905186255474984e-29,  4.077091358915994e-02, -2.619244143014638e-04,  1.243949592241920e-06, -5.146063243080140e-09,  1.940841319924856e-11,
 -6.770562509794119e-14,  2.177767488268898e-16, -6.353910337034430e-19,  1.590929666926411e-21, -2.921629964259823e-24, -1.676301599795409e-28,  3.474909931467947e-29,
  6.738234793195738e-02, -4.297792011768279e-04,  2.006590477141279e-06, -8.039340556242494e-09,  2.870285945225938e-11, -9.133114951402895e-14,  2.497180670703702e-16,
 -5.195867352004605e-19,  3.134216418722988e-22,  4.324165358816490e-24, -3.253080302603791e-26,  1.543161410292856e-28,  1.006276822256959e-01, -6.359470005036932e-04,
  2.904084862747068e-06, -1.114536081023865e-08,  3.678458732998710e-11, -1.007186328110440e-13,  1.922850869080424e-16,  2.370200803269130e-20, -2.600563625919196e-21,
  1.622227601098810e-23, -7.042447955707876e-26,  2.302802937025668e-28,  1.404898906895837e-01, -8.778493417530502e-04,  3.898493474581216e-06, -1.413820151641415e-08,
  4.163230593450384e-11, -8.644517434719456e-14,  1.565020057861502e-17,  1.011023769513996e-18, -6.536561124060019e-21,  2.704869618050361e-23, -7.961878802550138e-26,
  1.064323061802136e-28,  1.869438064017325e-01, -1.152242472859635e-03,  4.943670081693277e-06, -1.664428771970938e-08,  4.118474211325555e-11, -4.122306797453598e-14,
 -2.840816835350068e-16,  2.266618213692975e-18, -9.840891092143683e-21,  2.714975558621250e-23, -2.010303430595134e-26, -3.146213919353833e-28,  2.399530623334107e-01,
 -1.455129777823725e-03,  5.985097266410856e-06, -1.825614092702769e-08,  3.357290580708483e-11,  3.797586954950858e-14, -6.725736569425469e-16,  3.389782162140097e-18,
 -1.002992999632993e-20,  6.571748504888639e-24,  1.244118334081865e-25, -9.063488856170435e-28,  2.994660766300392e-01, -1.781655141442391e-03,  6.959882795502203e-06,
 -1.855230415793573e-08,  1.741433269008982e-11,  1.476454369720256e-13, -1.068740328980678e-15,  3.784500573992058e-18, -4.540925215709558e-21, -3.832135685763838e-23,
  3.098728694349682e-25, -1.209624367266637e-27,  3.654108182190381e-01, -2.125976083969855e-03,  7.797057319186308e-06, -1.712560174078656e-08, -7.828147044660454e-12,
  2.756034442203539e-13, -1.344312963636620e-15,  2.782484043266804e-18,  7.920132100181008e-21, -9.675989713940816e-23,  4.099542560340934e-25, -5.478143129734581e-28,
  4.376880034379653e-01, -2.481116432806178e-03,  8.418382328735216e-06, -1.362232629298146e-08, -4.143090579338770e-11,  3.994797778807963e-13, -1.337160672162408e-15,
 -1.162792177135649e-19,  2.561331261049210e-20, -1.379640256602036e-22,  2.430140016396577e-25,  1.484271554272001e-27,  5.161622644216196e-01, -2.838800302680505e-03,
  8.739973437991691e-06, -7.795194287602649e-09, -8.096543284150589e-11,  4.866303891902332e-13, -8.848695257363374e-16, -4.887649462514796e-18,  4.218067187014087e-20,
 -1.147459647211181e-22, -3.181826785576958e-25,  4.207213312809343e-27,  6.006506899291745e-01, -3.189272961250331e-03,  8.675175240115515e-06,  4.273605802159252e-10,
 -1.218900784765465e-10,  4.966458274506629e-13,  1.159643604523917e-16, -1.057391810476296e-17,  4.643529696995474e-20,  1.564961540843856e-23, -1.154207026780200e-24,
  5.235273605068957e-27,  6.909079647938620e-01, -3.521120956473619e-03,  8.139293980529759e-06,  1.085442639944547e-08, -1.573015170816119e-10,  3.879791943218741e-13,
  1.624666288094596e-15, -1.498916067290159e-17,  2.528975707058528e-20,  2.495298988692153e-22, -1.716231268312514e-24,  1.178719917510246e-27,  7.866071254180633e-01,
 -3.821115542575029e-03,  7.056995109432008e-06,  2.293101615919376e-08, -1.780587623320322e-10,  1.303068166351020e-13,  3.359203573092050e-15, -1.485835219829624e-17,
 -2.845754192595521e-20,  4.851967621713173e-22, -1.090559520810344e-24, -9.082196271061815e-27,  8.873147174770365e-01, -4.074122764348453e-03,  5.373366432169276e-06,
  3.563225153573125e-08, -1.736083865015230e-10, -2.765027707515318e-13,  4.726574651931033e-15, -6.845153895853718e-18, -1.036794578475537e-19,  5.047893825620536e-22,
  1.357701633486813e-24, -1.913446816150576e-26,  9.924589256940978e-01, -4.263154460237068e-03,  3.069729268222495e-06,  4.737891410367625e-08, -1.339518270495746e-10,
 -7.785248954776228e-13,  4.860570937301953e-15,  1.014239416025507e-17, -1.595225811375618e-19,  6.828677795185859e-23,  4.690792518173736e-24, -1.347071676180044e-26,
  1.101289134057565e+00, -4.369681683936703e-03,  1.850112068025689e-07,  5.602500249582103e-08, -5.320728848007332e-11, -1.246628793251765e-12,  2.885337382972885e-15,
  3.163272989324746e-17, -1.301479137098287e-19, -8.146210364941152e-22,  5.426607694533008e-24,  1.926078976345653e-26,  1.212825557696615e+00, -4.374399576238994e-03,
 -3.157602508564096e-06,  5.900400722866565e-08,  6.509531144870189e-11, -1.475846037265956e-12, -1.492343521632855e-15,  4.524322634702613e-17,  3.260055760160206e-20,
 -1.541123995498648e-21, -5.362596638282203e-25,  5.569498057607275e-26,  1.325798430141276e+00, -4.258718588831063e-03, -6.721778972403514e-06,  5.375935159318251e-08,
  2.018912289678399e-10, -1.234927547538154e-12, -7.143651731576646e-15,  3.388229243305858e-17,  2.744838512571230e-19, -9.968595153156042e-22, -1.110118519248949e-23,
  2.929576565700407e-26,  1.438578375195477e+00, -4.007340927520477e-03, -1.013553804833138e-05,  3.859272845554580e-08,  3.187728165519154e-10, -3.960709884568083e-13,
 -1.099930061361104e-14, -1.031897662121608e-17,  3.807012405649392e-19,  1.233160057573847e-21, -1.245515822324634e-23, -7.846114942394213e-26,  1.549104043368591e+00,
 -3.612299922655035e-03, -1.289310548533986e-05,  1.396103193216301e-08,  3.629092967122195e-10,  8.677889392997199e-13, -9.079009839452994e-15, -6.490146901524547e-17,
  1.118702257058432e-19,  3.055966190237106e-21,  6.824355978030002e-24, -1.068675027469551e-25,  1.654821098718851e+00, -3.078650442474939e-03, -1.441067565775494e-05,
 -1.609546226804439e-08,  2.887960207837683e-10,  1.951477262775654e-12, -1.086653637123026e-16, -7.525608562775866e-17, -3.986328955698082e-19,  1.040112613055303e-21,
  2.331996079202799e-23,  8.196087454791137e-26,  1.752658980820466e+00, -2.431353913651734e-03, -1.417089680542889e-05, -4.338828499497249e-08,  9.777725488102758e-11,
  2.035634509594701e-12,  1.024369118554350e-14, -9.273035174888815e-18, -4.957961483588577e-19, -3.159319168524268e-21, -4.093342279668678e-25,  1.454136694344248e-25,
  1.839086834443088e+00, -1.721540135477165e-03, -1.196864020289747e-05, -5.755752400885322e-08, -1.281358269081911e-10,  8.305291612445101e-13,  1.164569185647279e-14,
  6.685437120117273e-17,  9.214808287644312e-20, -2.150020626894852e-21, -2.369450501783353e-23, -1.146779145028762e-25,  1.910299841230544e+00, -1.028358332275348e-03,
 -8.193196910362806e-06, -5.172445027851172e-08, -2.516822634269904e-10, -7.238769472929874e-13,  1.991197763609436e-15,  4.825688170896070e-17,  4.114514053057941e-19,
  2.186771544809297e-21,  4.531914457955482e-24, -5.328896887283097e-26,  1.962575599054292e+00, -4.512697465235756e-04, -3.957504960708940e-06, -2.956947668039937e-08,
 -1.953607573916757e-10, -1.138163667901139e-12, -5.608684849121155e-15, -2.006362827428974e-17, -7.403597968631046e-21,  7.340936506106275e-22,  8.851545205305305e-24,
  7.218684703865154e-26,  1.992794095619494e+00, -8.945748335376719e-05, -8.281741074159460e-07, -6.763923852829370e-09, -5.130190731048601e-11, -3.692286482845518e-13,
 -2.547394063959740e-15, -1.692352434875535e-17, -1.083634278135112e-19, -6.673671012121470e-22, -3.930997476723849e-24, -2.190177911854015e-26,  8.110947551085198e-04,
 -5.198484837670916e-06,  2.497933531254996e-08, -1.066674284650837e-10,  4.267321832999432e-13, -1.638520864723584e-15,  6.108797934337058e-18, -2.231687412030565e-20,
  8.002330016520184e-23, -2.841943351407815e-25,  9.907290751822287e-28, -3.471932960271988e-30,  7.299844570539758e-03, -4.671023804215410e-05,  2.235958660131879e-07,
 -9.483171226697648e-10,  3.753421746189826e-12, -1.419025757009939e-14,  5.178704498608246e-17, -1.839249008474135e-19,  6.357382142643739e-22, -2.156250869958888e-24,
  7.083094621582490e-27, -2.315473666372740e-29,  2.027723558583373e-02, -1.293252669582385e-04,  6.143138451164511e-07, -2.569394702241554e-09,  9.946226948255205e-12,
 -3.638466873617743e-14,  1.266944896140776e-16, -4.215598771593822e-19,  1.330350247438529e-21, -3.978692511405772e-24,  1.081662091394391e-26, -2.689724113947732e-29,
  3.974273534406007e-02, -2.522146506079667e-04,  1.184016258887153e-06, -4.846083497694989e-09,  1.810515536909124e-11, -6.268681887268780e-14,  2.006827316454798e-16,
 -5.861626415543200e-19,  1.485969335237741e-21, -2.900954409020798e-24,  1.126598522295537e-27,  2.446809211262954e-29,  6.569473642650762e-02, -4.141046952608309e-04,
  1.912814627761664e-06, -7.594387080888403e-09,  2.693499681129805e-11, -8.551122853491896e-14,  2.353317377122648e-16, -5.073048827940439e-19,  4.472296851371691e-22,
  3.150435266418421e-24, -2.635325100624628e-26,  1.271815202447992e-28,  9.812952645955753e-02, -6.132394449756804e-04,  2.773806191546406e-06, -1.057267159127076e-08,
  3.481637047208227e-11, -9.610470982638552e-14,  1.918677219337696e-16, -5.069631858659573e-20, -2.064895886344319e-21,  1.360021132754815e-23, -6.086917752348333e-26,
  2.041451453992482e-28,  1.370398105286422e-01, -8.473288348599535e-04,  3.732774795345125e-06, -1.348588623048349e-08,  3.990933308115754e-11, -8.575262374570081e-14,
  4.117254693139661e-17,  8.168287293743077e-19, -5.618950611320169e-21,  2.396341083274620e-23, -7.452248339446288e-26,  1.233675698978251e-28,  1.824126859951602e-01,
 -1.113480900728014e-03,  4.747864014556975e-06, -1.599227702978592e-08,  4.029706174333759e-11, -4.731413239644866e-14, -2.248794123263449e-16,  1.967167559743261e-18,
 -8.881027169145903e-21,  2.609951909545071e-23, -3.169135843230845e-26, -2.160630947980527e-28,  2.342269302727819e-01, -1.408116110443703e-03,  5.769268883977787e-06,
 -1.771374370969426e-08,  3.417850715365592e-11,  2.293705142625816e-14, -5.821111885810539e-16,  3.073495092339277e-18, -9.712940628790513e-21,  1.079879347137234e-23,
  8.809938991570378e-26, -7.472587679974242e-28,  2.924494111856779e-01, -1.726861637435150e-03,  6.739019950871787e-06, -1.825140948484218e-08,  2.011923703103206e-11,
  1.232496495378674e-13, -9.649995831874927e-16,  3.619407406762934e-18, -5.709993039917203e-21, -2.696644831023048e-23,  2.585227551357736e-25, -1.120577599710569e-27,
  3.570303627866503e-01, -2.064423375894239e-03,  7.590974889606407e-06, -1.720848156214882e-08, -2.632267836419639e-12,  2.443003802170690e-13, -1.263356584639925e-15,
  2.983308308728659e-18,  4.725539233055808e-21, -8.090777626696024e-23,  3.812355331675942e-25, -7.425910297672030e-28,  4.278971814040227e-01, -2.414433919162828e-03,
  8.251195055609700e-06, -1.422304717750021e-08, -3.376203307736470e-11,  3.674369504618554e-13, -1.329674327836944e-15,  6.258720299687473e-19,  2.083560940427196e-20,
 -1.271232238472749e-22,  2.946312939428163e-25,  8.808625137149103e-28,  5.049462802259087e-01, -2.769275975138570e-03,  8.638975742715668e-06, -9.013978056649514e-09,
 -7.145550714920296e-11,  4.638998996551315e-13, -1.003463254983648e-15, -3.606069062825643e-18,  3.786333755789655e-20, -1.239910000622599e-22, -1.495438838971523e-25,
  3.456364719482095e-27,  5.880323875575501e-01, -3.119883444726277e-03,  8.668930127855720e-06, -1.443363764668768e-09, -1.119524432596362e-10,  4.960442588228927e-13,
 -1.592785518185604e-16, -9.087433683649563e-18,  4.622324047983684e-20, -2.590832071725242e-23, -9.241765564640303e-25,  5.169881441474132e-27,  6.769544749982730e-01,
 -3.455527775383716e-03,  8.254708694827101e-06,  8.401656412184613e-09, -1.491855025801587e-10,  4.220341047810751e-13,  1.217556338430605e-15, -1.404927554020845e-17,
  3.305440097883829e-20,  1.824326977431250e-22, -1.626834934157147e-24,  2.798133012019507e-27,  7.714372498482974e-01, -3.763607099090828e-03,  7.315173463426040e-06,
  2.010716235474744e-08, -1.746805803662900e-10,  2.058482138285682e-13,  2.932982337894750e-15, -1.549866567453372e-17, -1.186356298979655e-20,  4.345039711367166e-22,
 -1.421455412204098e-24, -5.979553000599145e-27,  8.711068411639580e-01, -4.029473086889349e-03,  5.784124324899483e-06,  3.281636866929558e-08, -1.780214538822953e-10,
 -1.657227300792000e-13,  4.491259158345559e-15, -9.863281860656468e-18, -8.472905278144035e-20,  5.426428697387390e-22,  5.465239443052720e-25, -1.755417439798194e-26,
  9.754589713736539e-01, -4.236360014852993e-03,  3.624923805620606e-06,  4.511754529136227e-08, -1.483357518855768e-10, -6.590366464786703e-13,  5.073712425225873e-15,
  5.111964081301349e-18, -1.538439085593659e-19,  2.425339895106374e-22,  3.987142311595262e-24, -1.819469094478108e-26,  1.083817602504047e+00, -4.365528735516596e-03,
  8.513935514411583e-07,  5.497828009783196e-08, -7.737818195753397e-11, -1.167248275808448e-12,  3.708646197523192e-15,  2.704214072086730e-17, -1.553911031253050e-19,
 -5.837144653489604e-22,  6.041106478232107e-24,  8.622328206062203e-27,  1.195281944081764e+00, -4.396812751820221e-03, -2.444284453426290e-06,  5.980788300927350e-08,
  3.532323143833141e-11, -1.496393967703369e-12, -2.192705403530225e-16,  4.539938991485779e-17, -2.267893557666980e-20, -1.514021107409993e-21,  1.870889225849158e-24,
  5.288607517903752e-26,  1.308660168010352e+00, -4.309859393258057e-03, -6.058129498924612e-06,  5.678304748924709e-08,  1.755600245451733e-10, -1.394034359253275e-12,
 -6.077968301123456e-15,  4.200878760796365e-17,  2.309727143886378e-19, -1.408797574858788e-21, -9.344685347226076e-24,  4.999108147351403e-26,  1.422389897421163e+00,
 -4.086486770334545e-03, -9.642131192094469e-06,  4.361530609475460e-08,  3.081954367677160e-10, -6.621073428416062e-13, -1.111172700306787e-14,  2.471182196671759e-18,
  4.153456271032941e-19,  6.715772136412814e-22, -1.546600619912332e-23, -5.679712643802840e-26,  1.534449756024260e+00, -3.714674686587855e-03, -1.269020108652949e-05,
  1.989397861531709e-08,  3.779414446980850e-10,  6.285936308976778e-13, -1.082927477385306e-14, -5.951848495642480e-17,  2.255767122652309e-19,  3.225267044428557e-21,
  1.415978162113278e-24, -1.376264127420972e-25,  1.642274817686108e+00, -3.194626915743859e-03, -1.457481128987867e-05, -1.116337313689684e-08,  3.276215266893586e-10,
  1.922182991500276e-12, -2.387472692113857e-15, -8.722674035805346e-17, -3.436208305811810e-19,  2.034721943493076e-21,  2.612110749038840e-23,  4.222297205405211e-26,
  1.742703575041815e+00, -2.546773949986545e-03, -1.468078314256252e-05, -4.148491150025299e-08,  1.409176889555414e-10,  2.276469681925844e-12,  9.744885843329342e-15,
 -2.694798926685004e-17, -6.081420037775933e-19, -3.032087253306186e-21,  7.157468409734003e-24,  1.983529583332770e-25,  1.832004753874492e+00, -1.820085506950295e-03,
 -1.267103243842314e-05, -5.945898512504337e-08, -1.085772579474886e-10,  1.132743741694330e-12,  1.354589999051467e-14,  6.837203999887462e-17, -3.506909181453402e-21,
 -3.196047531221836e-21, -2.850530718052844e-23, -1.005995039093256e-25,  1.906051287620182e+00, -1.096456219778002e-03, -8.838519837209241e-06, -5.586410316727103e-08,
 -2.655644662703642e-10, -6.583122154468756e-13,  3.538774861751829e-15,  6.271258898225186e-17,  4.927624719740172e-19,  2.308774429730402e-21,  1.232070537312234e-24,
 -9.950179262366049e-26,  1.960704875348175e+00, -4.844040376905495e-04, -4.331868715010221e-06, -3.288485985998493e-08, -2.195156447442149e-10, -1.279513231485501e-12,
 -6.169285165099527e-15, -1.980274965374568e-17,  2.622509307836437e-20,  1.158653412831242e-21,  1.255966125750687e-23,  9.735228577294447e-26,  1.992422480374084e+00,
 -9.642208231541445e-05, -9.145210856800649e-07, -7.647321212357546e-09, -5.933836081045779e-11, -4.364675849366193e-13, -3.073639118514153e-15, -2.080788929194211e-17,
 -1.354664646569927e-19, -8.455754159986178e-22, -5.023836227486451e-24, -2.800425010592150e-26,  7.906925390437679e-04, -5.003656560415015e-06,  2.373923627212436e-08,
 -1.000941183672193e-10,  3.953787191714699e-13, -1.499128006962312e-15,  5.518290684044235e-18, -1.991246524714547e-20,  7.047026250335045e-23, -2.474626340328313e-25,
  8.495867692261117e-28, -2.959445852045212e-30,  7.116510493544973e-03, -4.496599054420163e-05,  2.125672375206072e-07, -8.904669961415054e-10,  3.481639927181479e-12,
 -1.300693824653914e-14,  4.691066745013945e-17, -1.647705317953507e-19,  5.629762546849475e-22, -1.892347160609776e-24,  6.134768060872090e-27, -2.004007447710894e-29,
  1.976957201328974e-02, -1.245314360202042e-04,  5.844124569918305e-07, -2.415915336821629e-09,  9.248008463896936e-12, -3.348096397606013e-14,  1.154658594012295e-16,
 -3.811991698307847e-19,  1.194625662549186e-21, -3.569084622655481e-24,  9.678661885964292e-27, -2.485455410207043e-29,  3.875245952828821e-02, -2.429703015535951e-04,
  1.127560811196410e-06, -4.566174697356580e-09,  1.689828079196118e-11, -5.806210683278529e-14,  1.849202654174946e-16, -5.402719245714603e-19,  1.382582140185296e-21,
 -2.836907145878053e-24,  2.016002050793831e-27,  1.625422816336563e-29,  6.406835568024698e-02, -3.991595105066791e-04,  1.824212285992128e-06, -7.176806855061987e-09,
  2.528011006706721e-11, -8.003200630248977e-14,  2.213432208423167e-16, -4.913718135378023e-19,  5.429545347397359e-22,  2.201125640235300e-24, -2.128141952568045e-26,
  1.039407112074750e-28,  9.572015923461509e-02, -5.915471580834994e-04,  2.650213883727475e-06, -1.003073683311095e-08,  3.294017282073673e-11, -9.152394910281335e-14,
  1.895935052995709e-16, -1.093920575573219e-19, -1.617017987613531e-21,  1.133756521841419e-23, -5.244763106812470e-26,  1.788168407420222e-28,  1.337092098123948e-01,
 -8.181032336556750e-04,  3.574719054125532e-06, -1.286099621131145e-08,  3.820591288664227e-11, -8.450956947535729e-14,  6.165211211412858e-17,  6.502607132866082e-19,
 -4.808589967465899e-21,  2.109378765443269e-23, -6.890736491346352e-26,  1.304483135358677e-28,  1.780335281803917e-01, -1.076254730840185e-03,  4.559793080712092e-06,
 -1.535536938512951e-08,  3.930110725468394e-11, -5.208152479226624e-14, -1.736380149879133e-16,  1.697746224839333e-18, -7.966332443011184e-21,  2.466569695247775e-23,
 -3.944420539828475e-26, -1.397378546767148e-28,  2.286854410531032e-01, -1.362802892440612e-03,  5.559997854201616e-06, -1.716394810738255e-08,  3.450433227623776e-11,
  9.964337240618515e-15, -5.003417911269429e-16,  2.769519489178212e-18, -9.268286102837271e-21,  1.370776908874151e-23,  5.836743308328439e-26, -6.074968983672094e-28,
  2.856484098107179e-01, -1.673819893717463e-03,  6.522011845649219e-06, -1.791100603339275e-08,  2.236072867526717e-11,  1.012843050827799e-13, -8.663465157520206e-16,
  3.423056112322354e-18, -6.506256038027668e-21, -1.758122290691586e-23,  2.115131410356032e-25, -1.014396826878561e-27,  3.488928165021862e-01, -2.004521939093666e-03,
  7.384376393249768e-06, -1.721312852860988e-08,  1.957377599097609e-12,  2.149967136070290e-13, -1.178124182304646e-15,  3.090799491476187e-18,  2.079112298370349e-21,
 -6.635056059208482e-23,  3.457977304819145e-25, -8.565166194393336e-28,  4.183703716542507e-01, -2.349115700981404e-03,  8.077514245573871e-06, -1.470617642954690e-08,
 -2.673062469567469e-11,  3.358062555576561e-13, -1.303486939074637e-15,  1.221729641575869e-18,  1.647924665945388e-20, -1.147152004185549e-22,  3.221983902603543e-25,
  3.903731341170740e-28,  4.940066883547412e-01, -2.700615579575619e-03,  8.524250124667182e-06, -1.008438262288528e-08, -6.242582894125456e-11,  4.387378975688443e-13,
 -1.088148025655335e-15, -2.466731276354961e-18,  3.332663698918317e-20, -1.271508865338012e-22, -1.383424152576317e-26,  2.717744055140675e-27,  5.756914049671700e-01,
 -3.050630984008177e-03,  8.641188815372618e-06, -3.155526993366887e-09, -1.020895359661260e-10,  4.893342331414489e-13, -3.932072103433241e-16, -7.629907382544879e-18,
  4.467925103700836e-20, -5.840652481608534e-23, -7.031383843289864e-25,  4.841053459357720e-27,  6.632650213324609e-01, -3.389126753622074e-03,  8.341490088880384e-06,
  6.083669995774311e-09, -1.404838288629833e-10,  4.466600508390601e-13,  8.398842852748691e-16, -1.289874947529728e-17,  3.848368566115237e-20,  1.201832414918861e-22,
 -1.477592173143077e-24,  3.903520364965306e-27,  7.565013257372695e-01, -3.704167743705772e-03,  7.539837920093151e-06,  1.734888525412711e-08, -1.698950131428657e-10,
  2.710033888627688e-13,  2.495975398715746e-15, -1.563946127342848e-17,  2.699670369070404e-21,  3.732521365775842e-22, -1.620204488967350e-24, -3.108204624751789e-27,
  8.550839202046079e-01, -3.981673542765843e-03,  6.160740014109158e-06,  2.994726719408726e-08, -1.802818825974280e-10, -6.153478860528939e-14,  4.180086958065124e-15,
 -1.225930110858725e-17, -6.498043930353146e-20,  5.497393014387618e-22, -1.734052147640923e-25, -1.504797662588281e-26,  9.585749008013292e-01, -4.205236288108412e-03,
  4.151680693236463e-06,  4.264538228999669e-08, -1.602900368187424e-10, -5.360970996832708e-13,  5.149448027230719e-15,  3.578135527240492e-19, -1.424438197031328e-19,
  3.850545709242637e-22,  3.118854954881449e-24, -2.094607064547831e-26,  1.066373256196791e+00, -4.356101418087344e-03,  1.502950567181990e-06,  5.355855263691013e-08,
 -9.977472103324484e-11, -1.069734236384990e-12,  4.393387740844079e-15,  2.178059820752904e-17, -1.719922108107367e-19, -3.375945913887596e-22,  6.189090918761347e-24,
 -1.768933818016630e-27,  1.177660140487951e+00, -4.413488915383186e-03, -1.724186197332833e-06,  6.013377583643800e-08,  5.445057671921799e-12, -1.486534007939252e-12,
  1.033687148215887e-15,  4.382047519975504e-17, -7.529257419617215e-20, -1.394545193069605e-21,  4.048045263928219e-24,  4.537053099642472e-26,  1.291328180435977e+00,
 -4.355553259023697e-03, -5.360823775166957e-06,  5.936145103905717e-08,  1.463200094231474e-10, -1.525004777532224e-12, -4.806358733962684e-15,  4.852092453549448e-17,
  1.741055665712946e-19, -1.733437495296714e-21, -6.769632621492816e-24,  6.611602274799854e-26,  1.405893107905888e+00, -4.161447556334258e-03, -9.089644553943936e-06,
  4.842605700583311e-08,  2.922999209372212e-10, -9.264386253921136e-13, -1.085370165286658e-14,  1.602527485346453e-17,  4.278597841035653e-19,  1.132150983780946e-23,
 -1.732620927840616e-23, -2.656424386394879e-26,  1.519389672273192e+00, -3.815137723265593e-03, -1.241482334538085e-05,  2.602694477168986e-08,  3.877839747448874e-10,
  3.496158855977406e-13, -1.237727162043243e-14, -5.044361472310738e-17,  3.411828391583782e-19,  3.153993213186105e-21, -5.124076343002322e-24, -1.573687613432628e-25,
  1.629262394254247e+00, -3.311669237636968e-03, -1.467606386558958e-05, -5.617844510606190e-09,  3.652882549511609e-10,  1.834407894953661e-12, -4.971297396885153e-15,
 -9.684624292242062e-17, -2.512580896020305e-19,  3.100852361225659e-21,  2.676063990012426e-23, -1.604414627741452e-26,  1.732278492635000e+00, -2.666169619913848e-03,
 -1.516353114902220e-05, -3.885358337367487e-08,  1.887129528063344e-10,  2.498994931645247e-12,  8.701982072638902e-15, -4.808180059934251e-17, -7.099060247593312e-19,
 -2.556607607329450e-21,  1.696055567445075e-23,  2.454029949643847e-25,  1.824517117169653e+00, -1.924335491000856e-03, -1.339415707312161e-05, -6.099666916666697e-08,
 -8.251684532483123e-11,  1.480691279865942e-12,  1.543983244903482e-14,  6.619069994988412e-17, -1.400732632541007e-19, -4.415390404859594e-21, -3.217763065794672e-23,
 -6.143079825943063e-26,  1.901519697497360e+00, -1.169919056518926e-03, -9.534801091655414e-06, -6.021321995357360e-08, -2.777296373172824e-10, -5.504514514186144e-13,
  5.527993226454219e-15,  7.981076240742950e-17,  5.755523334461705e-19,  2.252865040891375e-21, -4.499568162146340e-24, -1.643506956258501e-25,  1.958695363123501e+00,
 -5.206991669927800e-04, -4.748431582871757e-06, -3.661006332753531e-08, -2.466307834835255e-10, -1.434092744466956e-12, -6.705000344702382e-15, -1.819030704148279e-17,
  7.809093803560197e-20,  1.755479195529106e-21,  1.750984140337537e-23,  1.286818157024699e-25,  1.992021554816383e+00, -1.041221529443410e-04, -1.012287037808331e-06,
 -8.670785102654431e-09, -6.885523439475729e-11, -5.177457971255510e-13, -3.721816331891783e-15, -2.567118678918709e-17, -1.698404492433246e-19, -1.073298413837491e-21,
 -6.417810990691487e-24, -3.562714655724382e-26,  7.710502823084070e-04, -4.818441877754526e-06,  2.257509658638109e-08, -9.400090857585943e-11,  3.666766701767613e-13,
 -1.373132801662396e-15,  4.991018392173847e-18, -1.779364327589218e-20,  6.214312904880165e-23, -2.159527791608021e-25,  7.289903493138634e-28, -2.535778110907173e-30,
  6.939981243051925e-03, -4.330726743455204e-05,  2.022074803717643e-07, -8.367822286960208e-10,  3.232396282688434e-12, -1.193447069987404e-14,  4.253939244740886e-17,
 -1.477995992538124e-19,  4.990636487680181e-22, -1.663789893427137e-24,  5.312061589966313e-27, -1.743527608834950e-29,  1.928061674430525e-02, -1.199696347726799e-04,
  5.562876623221401e-07, -2.273157140947937e-09,  8.605258261841704e-12, -3.083366260807996e-14,  1.053086795473246e-16, -3.449543274214662e-19,  1.072848811663845e-21,
 -3.203251591078020e-24,  8.626370900593390e-27, -2.301890867025682e-29,  3.779827864030211e-02, -2.341644818300537e-04,  1.074351396057195e-06, -4.304856060398602e-09,
  1.578021962166059e-11, -5.380064619054045e-14,  1.703968134317067e-16, -4.976465174278334e-19,  1.282058422883705e-21, -2.744024427973877e-24,  2.579510231061605e-27,
  9.570307413161997e-30,  6.250036914698731e-02, -3.849035425543542e-04,  1.740465595432829e-06, -6.784846225092826e-09,  2.373148831948440e-11, -7.488283904898786e-14,
  2.078388448465552e-16, -4.728851368359795e-19,  6.079186191463121e-22,  1.435227651083198e-24, -1.715944169797515e-26,  8.388852792498160e-29,  9.339562415605034e-02,
 -5.708181001704094e-04,  2.532947690269008e-06, -9.518091811823161e-09,  3.115491950878294e-11, -8.701594481416349e-14,  1.858646628169351e-16, -1.549961353803631e-19,
 -1.244797656636007e-21,  9.389797025548684e-24, -4.511754103309571e-26,  1.545458466404696e-28,  1.304930294493333e-01, -7.901125449352435e-04,  3.423999367510336e-06,
 -1.226313685543124e-08,  3.653190584155745e-11, -8.282813612288519e-14,  7.781559588358715e-17,  5.080151479826801e-19, -4.097439674361614e-21,  1.845262492305035e-23,
 -6.315472971141439e-26,  1.299289847943631e-28,  1.738003139237452e-01, -1.040502834580607e-03,  4.379266490070545e-06, -1.473509548230805e-08,  3.822150869002171e-11,
 -5.570639136278675e-14, -1.295387820502515e-16,  1.456715602558892e-18, -7.108081608596692e-21,  2.298308196960441e-23, -4.427046568793203e-26, -8.257029978698086e-29,
  2.233218982534010e-01, -1.319137382902407e-03,  5.357347426432694e-06, -1.661091117384426e-08,  3.458964704520487e-11, -1.146350488824675e-15, -4.268703304803159e-16,
  2.481230543504097e-18, -8.738887499755794e-21,  1.554450921271770e-23,  3.433934990787004e-26, -4.880802352369627e-28,  2.790561299693631e-01, -1.622497298351173e-03,
  6.309289679401387e-06, -1.753812644434191e-08,  2.418613123955138e-11,  8.161808036872741e-14, -7.734997512033037e-16,  3.206276679167258e-18, -6.997347917970910e-21,
 -9.980451917800541e-24,  1.693437823969207e-25, -9.021703597428493e-28,  3.409915717404275e-01, -1.946272308749860e-03,  7.178143761254056e-06, -1.714891775445395e-08,
  5.981601831049483e-12,  1.877656464401989e-13, -1.090990843861519e-15,  3.121707775635915e-18, -6.979842024734314e-23, -5.329163715190170e-23,  3.067692908390108e-25,
 -9.088550942750336e-28,  4.091020218034060e-01, -2.285208254771050e-03,  7.898690148903897e-06, -1.508182451580687e-08, -2.032427346949625e-11,  3.049889328730101e-13,
 -1.262498753253652e-15,  1.685503185524237e-18,  1.258451032160997e-20, -1.016043676011338e-22,  3.305394907163751e-25,  5.211630736697719e-30,  4.833398245213218e-01,
 -2.632921951214808e-03,  8.397529565225734e-06, -1.101443813670326e-08, -5.391721619841076e-11,  4.119098045581873e-13, -1.142973776882112e-15, -1.473403207384383e-18,
  2.876616602996618e-20, -1.255201951486860e-22,  9.034010355965298e-26,  2.027640863118912e-27,  5.636268620057536e-01, -2.981679967026784e-03,  8.593843004156069e-06,
 -4.711248590495255e-09, -9.241369961629937e-11,  4.774930446462379e-13, -5.871807359092239e-16, -6.238833216354095e-18,  4.212044265340248e-20, -8.241119734512511e-23,
 -5.008073358432959e-25,  4.332534641946125e-27,  6.498423874758630e-01, -3.322140342913220e-03,  8.401305695171967e-06,  3.908369305970214e-09, -1.313775752915601e-10,
  4.626260493947841e-13,  4.965311103237682e-16, -1.160910331185508e-17,  4.178986040155863e-20,  6.473358013840622e-23, -1.290276264376259e-24,  4.538183233943274e-27,
  7.418065460135902e-01, -3.643062072963280e-03,  7.731903621064882e-06,  1.467703178050587e-08, -1.639112800773332e-10,  3.256736643563167e-13,  2.061209478406217e-15,
 -1.535080786867363e-17,  1.494423355768143e-20,  3.064705459681933e-22, -1.700822060006980e-24, -6.310322680300522e-28,  8.392580045584023e-01, -3.930999249214684e-03,
  6.502776874879961e-06,  2.705824163730208e-08, -1.805382986248230e-10,  3.445141149474265e-14,  3.810673686983761e-15, -1.402460746797436e-17, -4.546635251281477e-20,
  5.304337137847767e-22, -7.695480761318102e-25, -1.198823565914909e-26,  9.418235610182601e-01, -4.170020234364214e-03,  4.647705351738470e-06,  4.000167535686256e-08,
 -1.697779044122499e-10, -4.128915743694020e-13,  5.097896983687252e-15, -3.956347685781543e-18, -1.265620844563006e-19,  4.909969535502062e-22,  2.172191286451440e-24,
 -2.178385749110640e-26,  1.048976927774364e+00, -4.341535729539151e-03,  2.135387898020979e-06,  5.179692463524527e-08, -1.200688499504602e-10, -9.576061018876554e-13,
  4.924703842377922e-15,  1.612984979886007e-17, -1.797340763311931e-19, -9.440509409941599e-23,  5.903454554002140e-24, -1.094692345024943e-26,  1.159983167139643e+00,
 -4.424396751391099e-03, -1.003033781115976e-06,  5.998481093628768e-08, -2.393975227848797e-11, -1.447319272105173e-12,  2.219626648055575e-15,  4.064283129185845e-17,
 -1.221280322346733e-19, -1.195766842652917e-21,  5.809271095869596e-24,  3.418970281970967e-26,  1.273824758772087e+00, -4.395553056922651e-03, -4.635465159259936e-06,
  6.145277542380095e-08,  1.147794358936048e-10, -1.623484175460409e-12, -3.379493515628855e-15,  5.304748122319455e-17,  1.075601201472168e-19, -1.942698765550764e-21,
 -3.623640458321457e-24,  7.568047645046374e-26,  1.389105674019834e+00, -4.231762255719964e-03, -8.481127889221735e-06,  5.294065268677092e-08,  2.712105852315345e-10,
 -1.180000282769632e-12, -1.021421540559680e-14,  2.958787100206018e-17,  4.156034099430551e-19, -6.948747747526853e-22, -1.772365917251449e-23,  9.056351932618106e-27,
  1.503932611729198e+00, -3.913101115171966e-03, -1.206509553746407e-05,  3.227083024692522e-08,  3.916981561388692e-10,  3.694919082282621e-14, -1.362013483213052e-14,
 -3.776233161694876e-17,  4.493447073633793e-19,  2.808181391930729e-21, -1.219268480109361e-23, -1.609056181691714e-25,  1.615780617213802e+00, -3.429245305148594e-03,
 -1.470722317227614e-05,  5.128533309807572e-10,  4.005594231134330e-10,  1.681758346909831e-12, -7.777315071745399e-15, -1.028964193706379e-16, -1.207165751439929e-19,
  4.136467971842472e-21,  2.448525519811210e-23, -8.936138700854109e-26,  1.721368322348253e+00, -2.789287641453056e-03, -1.560997297636662e-05, -3.542349451640400e-08,
  2.406586687782433e-10,  2.689040169723814e-12,  7.024876483807451e-15, -7.211868988821459e-17, -7.870323895893997e-19, -1.651816076495753e-21,  2.849568061723068e-23,
  2.749250833259616e-25,  1.816600804394996e+00, -2.034436647746132e-03, -1.413299455064262e-05, -6.205927549177611e-08, -4.905061309081326e-11,  1.872824962565977e-12,
  1.720472666563628e-14,  5.891246642165471e-17, -3.226801693260625e-19, -5.737749138118710e-21, -3.340740557400337e-23,  1.185863396541360e-26,  1.896682780561594e+00,
 -1.249164028196798e-03, -1.028435955575733e-05, -6.473695969353467e-08, -2.872198689597778e-10, -3.888086788100909e-13,  8.032398158100326e-15,  9.947581730625467e-17,
  6.514599770142957e-19,  1.904555484182026e-21, -1.354060055233590e-23, -2.501099571397349e-25,  1.956533711532672e+00, -5.605132237306799e-04, -5.212404180353927e-06,
 -4.079452131674369e-08, -2.769613683944415e-10, -1.600778806284029e-12, -7.168812605999474e-15, -1.453336630331517e-17,  1.553551830903718e-19,  2.579663672630790e-21,
  2.397004352344112e-23,  1.658098706450959e-25,  1.991588183113106e+00, -1.126561953201731e-04, -1.123304690111769e-06, -9.860417343082380e-09, -8.016494069338457e-11,
 -6.163466032312832e-13, -4.522878524775542e-15, -3.177706702575238e-17, -2.135014187322633e-19, -1.363980744909895e-21, -8.184238737952701e-24, -4.495488772260911e-26,
  7.521307103780604e-04, -4.642255458323674e-06,  2.148140100490734e-08, -8.834744025607690e-11,  3.403726341381765e-13, -1.259109302364810e-15,  4.519506657622797e-18,
 -1.592403585772533e-20,  5.486779879542681e-23, -1.889173931752499e-25,  6.253009239874662e-28, -2.189398226374497e-30,  6.769925115319395e-03, -4.172891171362433e-05,
  1.924687028383578e-07, -7.869193073970037e-10,  3.003590210256936e-12, -1.096143524687249e-14,  3.861586363572357e-17, -1.327483566113462e-19,  4.428131053114347e-22,
 -1.465987812386930e-24,  4.593629011822186e-27, -1.529495601934417e-29,  1.880946929160179e-02, -1.156261503776382e-04,  5.298159672225758e-07, -2.140272287769172e-09,
  8.013096342112045e-12, -2.841838375218344e-14,  9.611372211350390e-17, -3.124035949344734e-19,  9.635030238695777e-22, -2.877977830171366e-24,  7.648445436792741e-27,
 -2.149311190037182e-29,  3.687848911983625e-02, -2.257720918893246e-04,  1.024173222999208e-06, -4.060763107748872e-09,  1.474399684519714e-11, -4.987378652158312e-14,
  1.570223686895150e-16, -4.581805727921880e-19,  1.185216480308588e-21, -2.634144638631327e-24,  2.873335385312916e-27,  3.913019538228419e-30,  6.098809574300102e-02,
 -3.712991475281656e-04,  1.661277106643654e-06, -6.416857106126697e-09,  2.228265190446145e-11, -7.005135476685985e-14,  1.948772717815013e-16, -4.527306232372477e-19,
  6.480727356863693e-22,  8.173394631020337e-25, -1.386308697808370e-26,  6.628457175062103e-29,  9.115216733451868e-02, -5.510030436143502e-04,  2.421664811150515e-06,
 -9.033294835997000e-09,  2.945883461867477e-11, -8.261147258530759e-14,  1.810155109820917e-16, -1.897565593393213e-19, -9.376739162033037e-22,  7.714174956576194e-24,
 -3.883331775147944e-26,  1.312308384979080e-28,  1.273864451241943e-01, -7.632993691023907e-04,  3.280294462918799e-06, -1.169177281477591e-08,  3.489509700961814e-11,
 -8.080408842152033e-14,  9.030082098628645e-17,  3.870493339063564e-19, -3.477252094114358e-21,  1.603923441985537e-23, -5.756301106856553e-26,  1.233206482741586e-28,
  1.697072655461302e-01, -1.006165676696991e-03,  4.206077332527003e-06, -1.413261986927883e-08,  3.707946574940774e-11, -5.835081638331739e-14, -9.181325512415511e-17,
  1.242147176016900e-18, -6.313319985930051e-21,  2.115266345646104e-23, -4.695562861032726e-26, -4.206288258243077e-29,  2.181298171270770e-01, -1.277066524087205e-03,
  5.161334601959118e-06, -1.605819381660544e-08,  3.446973750012483e-11, -1.058861922998355e-14, -3.612251140626577e-16,  2.210764733373464e-18, -8.159455372348764e-21,
  1.651914887888410e-23,  1.511212053712864e-26, -3.892969569335465e-28,  2.726657659561838e-01, -1.572858114701522e-03,  6.101204713635822e-06, -1.713906803059891e-08,
  2.563999273104336e-11,  6.410580575826177e-14, -6.869039496226131e-16,  2.977844460006627e-18, -7.243984773365290e-21, -3.967900690656800e-24,  1.320830231204323e-25,
 -7.925447260796398e-28,  3.333200321496130e-01, -1.889668403407986e-03,  6.973050380100751e-06, -1.702456258155625e-08,  9.482148465838349e-12,  1.626288176429375e-13,
 -1.003886280473593e-15,  3.091067923472224e-18, -1.777112332376273e-21, -4.182575991734043e-23,  2.664649856581338e-25, -9.172925135418033e-28,  4.000864144013455e-01,
 -2.222747736388832e-03,  7.715953130083593e-06, -1.535984413813352e-08, -1.452345062234302e-11,  2.752975088242149e-13, -1.210198518704732e-15,  2.032229965059292e-18,
  9.163944869967559e-21, -8.847052649100988e-23,  3.240233704332687e-25, -2.873863776734376e-28,  4.729416402011902e-01, -2.566284456848964e-03,  8.260447253442730e-06,
 -1.181271067353437e-08, -4.595615552387466e-11,  3.840832426328248e-13, -1.172015212523592e-15, -6.243249547451060e-19,  2.433226298661295e-20, -1.203103268369786e-22,
  1.656354548563624e-25,  1.407472441249328e-27,  5.518372510342427e-01, -2.913179778921212e-03,  8.528748815297646e-06, -6.114291270789331e-09, -8.301813673395193e-11,
  4.614538960332573e-13, -7.434695727572628e-16, -4.941951654558836e-18,  3.883741161452160e-20, -9.880656537601711e-23, -3.234558002698637e-25,  3.716314364358791e-27,
  6.366884945141571e-01, -3.254777323464996e-03,  8.435901014777534e-06,  1.880887969951465e-09, -1.220314274425325e-10,  4.707950564259790e-13,  1.904796896925207e-16,
 -1.024410540478750e-17,  4.324030311303864e-20,  1.721068982814829e-23, -1.084201280538755e-24,  4.768281933060958e-27,  7.273590613659257e-01, -3.580546418572094e-03,
  7.892515774021625e-06,  1.210910186118817e-08, -1.569376113215764e-10,  3.700485831008046e-13,  1.639646753071899e-15, -1.470921204313050e-17,  2.475162402208338e-20,
  2.385048849420033e-22, -1.682979365845374e-24,  1.356726498819320e-27,  8.236400392000859e-01, -3.877727261058200e-03,  6.810182560636924e-06,  2.417997395519375e-08,
 -1.789672921738716e-10,  1.210483129942485e-13,  3.400438407966239e-15, -1.518091647397923e-17, -2.704323829648841e-20,  4.900587291159563e-22, -1.225402801519465e-24,
 -8.725515878547141e-27,  9.252208175257460e-01, -4.130965275348676e-03,  5.111175680009533e-06,  3.722576820866482e-08, -1.768235074709961e-10, -2.923121423474391e-13,
  4.933185434882963e-15, -7.708619737088133e-18, -1.075521841026994e-19,  5.588498265500098e-22,  1.226556439261951e-24, -2.095175115872753e-26,  1.031648839656796e+00,
 -4.322000445824081e-03,  2.744813557336456e-06,  4.972916971251468e-08, -1.380058269115956e-10, -8.346450353887538e-13,  5.295626626856494e-15,  1.036847439494680e-17,
 -1.790194007955116e-19,  1.298072128273332e-22,  5.254280696050898e-24, -1.820100651077449e-26,  1.142274078371909e+00, -4.429550441561369e-03, -2.864590841196768e-07,
  5.937347669093173e-08, -5.226369443996308e-11, -1.380871960104998e-12,  3.296776745962214e-15,  3.609353513362316e-17, -1.606651738202199e-19, -9.371507294289623e-22,
  7.023561447094116e-24,  2.076332009517461e-26,  1.256173090301643e+00, -4.429658318764088e-03, -3.888097407972601e-06,  6.302559324381260e-08,  8.162071836967972e-11,
 -1.686444588013322e-12, -1.856652312059423e-15,  5.534902818463671e-17,  3.582778357604645e-20, -2.019913046538565e-21, -2.231894119004027e-25,  7.758613837181768e-26,
  1.372047052113304e+00, -4.296998236853775e-03, -7.820624951846759e-06,  5.707821103855946e-08,  2.452339241624318e-10, -1.413725080765531e-12, -9.204293143396335e-15,
  4.235153701087901e-17,  3.780220740873138e-19, -1.384969066955894e-21, -1.651328050104098e-23,  4.574416562669028e-26,  1.488089768661764e+00, -4.007966398610391e-03,
 -1.164027660585904e-05,  3.852582285557623e-08,  3.890914430202980e-10, -3.009076521086479e-13, -1.446172632536920e-14, -2.187359820637868e-17,  5.399812098509984e-19,
  2.182124972264517e-21, -1.899304000206425e-23, -1.448179397159062e-25,  1.601828516495407e+00, -3.546767035909425e-03, -1.466154081002581e-05,  7.179758217002643e-09,
  4.320930172149709e-10,  1.460237214442141e-12, -1.068881304423191e-14, -1.041968132440821e-16,  4.466404146308472e-20,  5.013676904861507e-21,  1.878610598083146e-23,
 -1.700556142481587e-25,  1.709958817901564e+00, -2.915798150605823e-03, -1.601014923934842e-05, -3.113428734275513e-08,  2.959469666578387e-10,  2.830512925090105e-12,
  4.645729435678580e-15, -9.801134208160252e-17, -8.230407826144068e-19, -2.678461266483607e-22,  4.069053224351802e-23,  2.730124560362569e-25,  1.808232198490862e+00,
 -2.150489795998845e-03, -1.488110450177947e-05, -6.252146102364357e-08, -7.338239537021280e-12,  2.304166156021267e-12,  1.867683810183594e-14,  4.502664362198486e-17,
 -5.528937520507607e-19, -7.033017641089486e-21, -3.052076996164024e-23,  1.265793641263465e-25,  1.891516543707038e+00, -1.334624920574767e-03, -1.108899617310104e-05,
 -6.938322257693004e-08, -2.928302279226656e-10, -1.601925185043192e-13,  1.111900401764560e-14,  1.212917444414112e-16,  7.073536734397457e-19,  1.113036454098606e-21,
 -2.680575195221394e-23, -3.557754539644279e-25,  1.954205050148828e+00, -6.042484222487139e-04, -5.729613873774516e-06, -4.549150303578184e-08, -3.107271285368017e-10,
 -1.777058963370939e-12, -7.490781174418081e-15, -7.876089582962641e-18,  2.673473027091144e-19,  3.696222078339980e-21,  3.215446372945358e-23,  2.064412413859574e-25,
  1.991118803996401e+00, -1.221387144624808e-04, -1.249752287267770e-06, -1.124788669553133e-08, -9.365362498586114e-11, -7.363925330441533e-13, -5.516140676915266e-15,
 -3.946200175859656e-17, -2.690023786656229e-19, -1.734042277410816e-21, -1.039930063125904e-23, -5.599670405717226e-26,  7.338988047825526e-04, -4.474554222355511e-06,
  2.045309516717267e-08, -8.309719026772544e-11,  3.162400132917918e-13, -1.155799332797476e-15,  4.097225357699702e-18, -1.427243856278399e-20,  4.849456695207445e-23,
 -1.657457927333148e-25,  5.352898934098968e-28, -1.913291046297379e-30,  6.606030293659469e-03, -4.022613358152266e-05,  1.833069409908830e-07, -7.405665741552341e-10,
  2.793336312191873e-12, -1.007770428397824e-14,  3.508960136496375e-17, -1.193885673526785e-19,  3.931876605799614e-22, -1.295171337080530e-24,  3.959526289869176e-27,
 -1.360219015439601e-29,  1.835528210595951e-02, -1.114882185436483e-04,  5.048835988912897e-07, -2.016487268008317e-09,  7.467105036264839e-12, -2.621323166983566e-14,
  8.778290555963483e-17, -2.831719951932497e-19,  8.651780941135416e-22, -2.590598152884272e-24,  6.728416457446697e-27, -2.041479976321467e-29,  3.599148446924818e-02,
 -2.177696868665692e-04,  9.768272242317298e-07, -3.832638492788314e-09,  1.378318911012230e-11, -4.625499942519384e-14,  1.447101932882813e-16, -4.217484861338907e-19,
  1.092483552291725e-21, -2.517302745434655e-24,  2.931258701623952e-27, -1.245849565308516e-30,  5.952900032366385e-02, -3.583109837830770e-04,  1.586368533546162e-06,
 -6.071293039978418e-09,  2.092738077435828e-11, -6.552405080493611e-14,  1.824948429530751e-16, -4.316231152039280e-19,  6.681746044162195e-22,  3.163530840517293e-25,
 -1.130264372947174e-26,  5.028440431752649e-29,  8.898622641519184e-02, -5.320554345193379e-04,  2.316039557203724e-06, -8.574937137786117e-09,  2.784960204922368e-11,
 -7.833400299634362e-14,  1.753219245676536e-16, -2.156076622123005e-19, -6.865933755671505e-22,  6.269591676771898e-24, -3.356218978466835e-26,  1.083757938516036e-28,
  1.243848570232283e-01, -7.376088490675508e-04,  3.143290178724683e-06, -1.114625869932656e-08,  3.330150249023561e-11, -7.851887598446505e-14,  9.966409005970306e-17,
  2.845819121714150e-19, -2.940005269802472e-21,  1.384209320204228e-23, -5.238131052256361e-26,  1.113358890721915e-28,  1.657488401182223e-01, -9.731854275898278e-04,
  4.040006654791020e-06, -1.354879284898940e-08,  3.589311638534900e-11, -6.015911143778199e-14, -5.974962609404426e-17,  1.051939285929674e-18, -5.585998344458547e-21,
  1.924598577923913e-23, -4.819249558624762e-26, -1.655013228926990e-29,  2.131029251730589e-01, -1.236537283858772e-03,  4.971936912900296e-06, -1.550882271049852e-08,
  3.417613496303965e-11, -1.854415674543690e-14, -3.028890908057850e-16,  1.959261846018886e-18, -7.557787907210987e-21,  1.680551988264021e-23, -2.258680753562159e-28,
 -3.113648144136279e-28,  2.664706601706895e-01, -1.524864086419680e-03,  5.898036821242565e-06, -1.671943906426219e-08,  2.676386984128177e-11,  4.859437526971430e-14,
 -6.067842003860643e-16,  2.744704740558937e-18, -7.299855727733948e-21,  6.483266247489094e-25,  9.945716438358398e-26, -6.925801504807282e-28,  3.258716374318236e-01,
 -1.834698361390267e-03,  6.769769090067883e-06, -1.684810736874607e-08,  1.250076380036533e-11,  1.395663999990609e-13, -9.183446759361775e-16,  3.012087074024901e-18,
 -3.100676620225601e-21, -3.197019008718487e-23,  2.264555999603492e-25, -8.980264335554180e-28,  3.913177063196128e-01, -2.161760925947607e-03,  7.530417387860551e-06,
 -1.554972993936444e-08, -9.303179901625038e-12,  2.469658563267757e-13, -1.149651764672540e-15,  2.276989700546840e-18,  6.208621702162918e-21, -7.583108363297523e-23,
  3.063754893511591e-25, -5.037016045301607e-28,  4.628077548738410e-01, -2.500779815154094e-03,  8.114531466237688e-06, -1.248808856232694e-08, -3.855675237679649e-11,
  3.558291363382344e-13, -1.179236808043885e-15,  8.639855304797173e-20,  2.013375926235717e-20, -1.126115227501269e-22,  2.153593967157136e-25,  8.657285274642773e-28,
  5.403204962510481e-01, -2.845265160425236e-03,  8.447708875516311e-06, -7.369762883169973e-09, -7.397798831093688e-11,  4.420871983397560e-13, -8.649958071608102e-16,
 -3.758255880574566e-18,  3.508513053553249e-20, -1.086686971966176e-22, -1.745147373341683e-25,  3.049123878013649e-27,  6.238044566688804e-01, -3.187232308522988e-03,
  8.447067923018251e-06,  3.866019046505942e-12, -1.125922353724593e-10,  4.720811899109046e-13, -7.694775880246225e-17, -8.858462047622959e-18,  4.312979380059484e-20,
 -2.196907469781918e-23, -8.755148917617170e-25,  4.669522929700913e-27,  7.131640167299566e-01, -3.516867166844267e-03,  8.023009765074606e-06,  9.659307628317126e-09,
 -1.491759903878363e-10,  4.045547843401198e-13,  1.240076519420463e-15, -1.379262831160283e-17,  3.214477607446797e-20,  1.728481780591311e-22, -1.589214409968436e-24,
  2.817943379944160e-27,  8.082398623093915e-01, -3.822133628848718e-03,  7.083255244716422e-06,  2.134015310582921e-08, -1.757650885125528e-10,  1.974762040529856e-13,
  2.965838058523784e-15, -1.577418034935232e-17, -1.036728541304631e-20,  4.343119373062022e-22, -1.538849360913661e-24, -5.559336582698830e-27,  9.087814959597649e-01,
 -4.088337531941047e-03,  5.540737536723081e-06,  3.435617487822921e-08, -1.815051989226342e-10, -1.768758128070387e-13,  4.672242415631051e-15, -1.082069515635125e-17,
 -8.676780542684296e-20,  5.900221319846277e-22,  3.476426602941420e-25, -1.881908713860749e-26,  1.014408479697505e+00, -4.297693698157024e-03,  3.327786779324332e-06,
  4.739452590419440e-08, -1.534075835693712e-10, -7.047077956445838e-13,  5.506725358373361e-15,  4.753518390940335e-18, -1.707713859732292e-19,  3.223345956388654e-22,
  4.336158560449764e-24, -2.313297110503489e-26,  1.124555782845231e+00, -4.429008472410991e-03,  4.201087844679082e-07,  5.832094984149962e-08, -7.901117469128195e-11,
 -1.290232050825679e-12,  4.230741578204835e-15,  3.046821113959410e-17, -1.891632797233176e-19, -6.420920409610995e-22,  7.626452640739638e-24,  6.656161556248618e-27,
  1.238397065359250e+00, -4.457718245219608e-03, -3.125074152537641e-06,  6.405980092280709e-08,  4.757214638267619e-11, -1.712344504426285e-12, -3.017343324994405e-16,
  5.533694233234401e-17, -3.623672146480830e-20, -1.961732607530063e-21,  3.089876751360037e-24,  7.178956173163847e-26,  1.354738358351748e+00, -4.356759003452820e-03,
 -7.113114740678848e-06,  6.076418255931711e-08,  2.148532982066116e-10, -1.619081590486359e-12, -7.857474732735294e-15,  5.352756949915666e-17,  3.168516575935668e-19,
 -1.995111615960414e-21, -1.375322529143621e-23,  7.870937755423455e-26,  1.471874735256838e+00, -4.099134119875162e-03, -1.114087412093489e-05,  4.468411039653255e-08,
  3.795632454695816e-10, -6.533189960038657e-13, -1.482158084549899e-14, -3.495858510388973e-18,  6.034088868151466e-19,  1.304229952271174e-21, -2.463703393611496e-23,
 -1.085237979311495e-25,  1.587407578090414e+00, -3.663595080594977e-03, -1.453298687336846e-05,  1.431195937023313e-08,  4.584976880333555e-10,  1.169028648955009e-12,
 -1.355823800449680e-14, -9.975069770645691e-17,  2.366661116910212e-19,  5.592199939991861e-21,  9.581484080137636e-24, -2.465166720723797e-25,  1.698037216065129e+00,
 -3.045288955849787e-03, -1.635346469495430e-05, -2.594118238803830e-08,  3.534345344557168e-10,  2.906105398808335e-12,  1.533613135419836e-15, -1.241658392674735e-16,
 -8.005773108745083e-19,  1.589849719647467e-21,  5.185211068748102e-23,  2.258690858867018e-25,  1.799387392005193e+00, -2.272537995609249e-03, -1.563046578648707e-05,
 -6.224546206612264e-08,  4.331829024894952e-11,  2.765297904845196e-12,  1.965022068991716e-14,  2.306084348637421e-17, -8.263244062670434e-19, -8.098943621616270e-21,
 -2.162231442302728e-23,  2.847990668041866e-25,  1.885995234319096e+00, -1.426747077836648e-03, -1.194976203959954e-05, -7.407843673514855e-08, -2.930770810119361e-10,
  1.500042246452194e-13,  1.483642831198237e-14,  1.443285696935273e-16,  7.240388702787706e-19, -3.065899978258411e-22, -4.503823897968640e-23, -4.739407179832871e-25,
  1.951692802322874e+00, -6.523562080509780e-04, -6.306546373904071e-06, -5.075729042769175e-08, -3.480784065496362e-10, -1.958385070719238e-12, -7.569659956382151e-15,
  3.074756744167486e-18,  4.258590908752914e-19,  5.175798514457272e-21,  4.210389260533882e-23,  2.446321192557046e-25,  1.990609360762613e+00, -1.327032730962642e-04,
 -1.394228065147179e-06, -1.287175449436388e-08, -1.098001319652868e-10, -8.830725291850605e-13, -6.751575759079667e-15, -4.915420016365188e-17, -3.395415356084502e-19,
 -2.202859409274812e-21, -1.313165107774209e-23, -6.834784823094482e-26,  7.163216411922062e-04, -4.314833831632658e-06,  1.948554204054498e-08, -7.821706795437948e-11,
  2.940758742266427e-13, -1.062091476841050e-15,  3.718454156373746e-18, -1.281211017246870e-20,  4.289344922802970e-23, -1.459518139770267e-25,  4.559185014239628e-28,
 -1.706149734908165e-30,  6.448003440142739e-03, -3.879448048805032e-05,  1.746817962754974e-07, -6.974409805466056e-10,  2.599940126527001e-12, -9.274288661518469e-15,
  3.191607135628597e-17, -1.075231596685094e-19,  3.492717777853576e-22, -1.148364724010319e-24,  3.389702349638918e-27, -1.238192318547235e-29,  1.791725693209259e-02,
 -1.075439492023869e-04,  4.813856565880139e-07, -1.901095876184477e-09,  6.963281875511005e-12, -2.419854360263869e-14,  8.022802937832551e-17, -2.569282825130703e-19,
  7.765462763817219e-22, -2.339246757584076e-24,  5.842197861341347e-27, -2.000266212752753e-29,  3.513574887841414e-02, -2.101353557941941e-04,  9.321288206273233e-07,
 -3.619323509879779e-09,  1.289188310637437e-11, -4.291979478792522e-14,  1.333772049355432e-16, -3.882165475025736e-19,  1.003944112181194e-21, -2.402674048964373e-24,
  2.761607486884278e-27, -6.555837935587380e-30,  5.812068477352418e-02, -3.459058634037403e-04,  1.515479559482940e-06, -5.746704887920600e-09,  1.965973211981430e-11,
 -6.128677631572907e-14,  1.707098516815540e-16, -4.101425097019394e-19,  6.719171889429882e-22, -9.605218252282721e-26, -9.430217158213836e-27,  3.480006139058756e-29,
  8.689442015393152e-02, -5.139312575452846e-04,  2.215762907754584e-06, -8.141650420358599e-09,  2.632449827393417e-11, -7.420100419113935e-14,  1.690094519899026e-16,
 -2.342175442468609e-19, -4.839654754338825e-22,  5.015668119864774e-24, -2.930453219398492e-26,  8.492982957742023e-29,  1.214838797856607e-01, -7.129886085382873e-04,
  3.012680624049496e-06, -1.062586519395541e-08,  3.175563674310956e-11, -7.604150314163886e-14,  1.063873457335113e-16,  1.980797115577219e-19, -2.478266324197959e-21,
  1.184006757425990e-23, -4.784837014742643e-26,  9.367958011696308e-29,  1.619197224679022e-01, -9.415060453803716e-04,  3.880826948886034e-06, -1.298419669903904e-08,
  3.467787832163944e-11, -6.125922296699315e-14, -3.269635344445345e-17,  8.838998339684662e-19, -4.927975925465946e-21,  1.730802010747345e-23, -4.862592146512908e-26,
 -5.607354125476521e-30,  2.082351614410557e-01, -1.197496946799527e-03,  4.789098480580116e-06, -1.496534841589682e-08,  3.373686318216028e-11, -2.518195359172751e-14,
 -2.513248587289298e-16,  1.727065189714444e-18, -6.956085262654678e-21,  1.654064838223899e-23, -1.260863635222244e-26, -2.552428112189310e-28,  2.604643121051712e-01,
 -1.478474976301654e-03,  5.700002463460566e-06, -1.628420763813191e-08,  2.759621789605183e-11,  3.492742654545349e-14, -5.331941575626150e-16,  2.512192581373132e-18,
 -7.212011351840308e-21,  4.043191974385406e-24,  7.089646958532018e-26, -6.088983101733062e-28,  3.186398849059000e-01, -1.781345313113459e-03,  6.568880187540160e-06,
 -1.662693358506722e-08,  1.507845825487251e-11,  1.185259741298227e-13, -8.355563446294936e-16,  2.896122065513646e-18, -4.097997851280976e-21, -2.369331716924364e-23,
  1.876192452877605e-25, -8.665403212578598e-28,  3.827899644249151e-01, -2.102266138589343e-03,  7.343085724786278e-06, -1.566054337731196e-08, -4.634509358917636e-12,
  2.201592938761377e-13, -1.083508391769805e-15,  2.434305678710839e-18,  3.693487449155015e-21, -6.406961022674364e-23,  2.805411902873857e-25, -6.629161866130067e-28,
  4.529335049166687e-01, -2.436472948232799e-03,  7.961202826692313e-06, -1.304959957837856e-08, -3.172262994618723e-11,  3.276256017485007e-13, -1.168394935565678e-15,
  6.675430705912242e-19,  1.624267750902774e-20, -1.033776988639301e-22,  2.429372022645535e-25,  3.994266025045691e-28,  5.290740113183345e-01, -2.778056695576543e-03,
  8.352457865482008e-06, -8.483838241756610e-09, -6.535172688564848e-11,  4.201877361779101e-13, -9.551050924923634e-16, -2.699221670254333e-18,  3.107791962592125e-20,
 -1.131659708743795e-22, -5.529568506184442e-26,  2.370257005276401e-27,  6.111906385246884e-01, -3.119685488153772e-03,  8.436616485512154e-06, -1.722258634764424e-09,
 -1.031883679680224e-10,  4.674129952199606e-13, -3.058273296930350e-16, -7.497324872255510e-18,  4.175728066230733e-20, -5.296847708708766e-23, -6.770411103500906e-25,
  4.315466960069264e-27,  6.992255938657975e-01, -3.452259393040854e-03,  8.124872452190444e-06,  7.338708462153424e-09, -1.408179344743113e-10,  4.298038505608680e-13,
  8.691332718203289e-16, -1.267644163794793e-17,  3.725588128560843e-20,  1.120732467213480e-22, -1.442682344252871e-24,  3.758960970190590e-27,  7.930662146622364e-01,
 -3.764490743103233e-03,  7.322606083937420e-06,  1.856322467121360e-08, -1.711396731587609e-10,  2.633327160974445e-13,  2.521779749541163e-15, -1.586807584672173e-17,
  4.108950619813749e-21,  3.687309240029867e-22, -1.719527940300620e-24, -2.723538599511854e-27,  8.925193386986358e-01, -4.042412134468692e-03,  5.935489839174168e-06,
  3.142977576372327e-08, -1.839474563443724e-10, -6.867181754866100e-14,  4.333594166949526e-15, -1.325629904287442e-17, -6.546875073348627e-20,  5.882022345157631e-22,
 -4.167400813185493e-25, -1.581973312574049e-26,  9.972744912155573e-01, -4.268839217864571e-03,  3.881352212641783e-06,  4.483446638210704e-08, -1.661724860960854e-10,
 -5.715548456413244e-13,  5.565289608126625e-15, -4.940751238499806e-19, -1.562992508734088e-19,  4.745083786369882e-22,  3.254125094844902e-24, -2.566341073138552e-26,
  1.106850870209256e+00, -4.422871611503065e-03,  1.111542189653961e-06,  5.685612830370620e-08, -1.037349538459578e-10, -1.179160192318133e-12,  4.996053222944567e-15,
  2.410434781211160e-17, -2.067537450689153e-19, -3.351980898968142e-22,  7.621129885205676e-24, -6.658689393054588e-27,  1.220521074572921e+00, -4.479633631088743e-03,
 -2.352919605365046e-06,  6.454711030679215e-08,  1.337739372649062e-11, -1.701188200379563e-12,  1.221054055857100e-15,  5.307725588127308e-17, -1.039019078043241e-19,
 -1.778211720419733e-21,  5.994769832788924e-24,  5.926965928127673e-26,  1.337202209758314e+00, -4.410691325480253e-03, -6.364418977108999e-06,  6.393306543886139e-08,
  1.807128994330347e-10, -1.788599969569543e-12, -6.228266088691325e-15,  6.241873085923220e-17,  2.360342373527616e-19, -2.467952827546443e-21, -9.707838370047951e-24,
  1.035063355595719e-25,  1.455303485068641e+00, -4.186014152958219e-03, -1.056872051686737e-05,  5.063327040516930e-08,  3.629431926798181e-10, -1.007993249960157e-12,
 -1.464348514449114e-14,  1.636578190557045e-17,  6.316034943476271e-19,  2.379432598382066e-22, -2.828605924985262e-23, -5.490800734048519e-26,  1.572521935942460e+00,
 -3.779045632746590e-03, -1.431651584637150e-05,  2.181635519408280e-08,  4.784032693730595e-10,  8.111586034779951e-13, -1.621456742213183e-14, -8.890468743545755e-17,
  4.420945355537679e-19,  5.739593923540022e-21, -2.636567245113704e-24, -3.046092449705101e-25,  1.685592574828408e+00, -3.177261291775009e-03, -1.662890801416798e-05,
 -1.982048646113079e-08,  4.116284182848325e-10,  2.898365155709963e-12, -2.290125327101807e-15, -1.484502934894976e-16, -7.038426757921399e-19,  3.836780607475479e-21,
  5.974944678639091e-23,  1.235511246600148e-25,  1.790042444301698e+00, -2.400553350916430e-03, -1.637134421345563e-05, -6.108413559125332e-08,  1.033759981332752e-10,
  3.241388951082643e-12,  1.988086727349180e-14, -8.185693071277921e-18, -1.129937486417766e-18, -8.658199192491798e-21, -4.926160732134454e-24,  4.786247340835762e-25,
  1.880091307779812e+00, -1.525980295370122e-03, -1.286667314121894e-05, -7.872290180273308e-08, -2.861754776053213e-10,  5.571673502691528e-13,  1.919761301408692e-14,
  1.669306529443588e-16,  6.752330024837767e-19, -2.559633423024444e-21, -6.843771752320464e-23, -5.865178446440236e-25,  1.948978477527440e+00, -7.053426469189153e-04,
 -6.950373742731813e-06, -5.664969808082802e-08, -3.890471197233146e-10, -2.137299564647210e-12, -7.262328440117489e-15,  2.003014432241441e-17,  6.451773530737474e-19,
  7.083799529781721e-21,  5.346933939982013e-23,  2.680572925803479e-25,  1.990055217759920e+00, -1.445062093549731e-04, -1.559842612169504e-06, -1.477914327765147e-08,
 -1.292001124373660e-10, -1.062930990979790e-12, -8.292687779710948e-15, -6.139585804450775e-17, -4.290579208656475e-19, -2.791985953143181e-21, -1.641521605497557e-23,
 -8.073389723508910e-26,  6.993682408768224e-04, -4.162625509403050e-06,  1.857448290870942e-08, -7.367705898060895e-11,  2.736981972590139e-13, -9.770030760812046e-16,
  3.378165702660246e-18, -1.152021241122611e-20,  3.794976920035219e-23, -1.291719407102409e-25,  3.840304707274830e-28, -1.575320091643597e-30,  6.295568401542277e-03,
 -3.742980993271533e-05,  1.665561098008104e-07, -6.572852075294484e-10,  2.421876716311586e-12, -8.543205053586480e-15,  2.905586216473655e-17, -9.698280286302353e-20,
  3.102421870774430e-22, -1.023434137054130e-24,  2.861602849690927e-27, -1.172957957188036e-29,  1.749464144874984e-02, -1.037822586531057e-04,  4.592253424145189e-07,
 -1.793452912221694e-09,  6.497997204797479e-12, -2.235666705204301e-14,  7.336958176296957e-17, -2.333828314583385e-19,  6.963269722472335e-22, -2.123254792518500e-24,
  4.952814514151198e-27, -2.064326870671033e-29,  3.430985131365383e-02, -2.028486102916482e-04,  8.899067856644495e-07, -3.419750254993744e-09,  1.206463568995183e-11,
 -3.984563154371341e-14,  1.229440535203388e-16, -3.574536243303232e-19,  9.193508136736502e-22, -2.299743095704771e-24,  2.338443023552361e-27, -1.296398136571206e-29,
  5.676087967160629e-02, -3.340526130442142e-04,  1.448366696353901e-06, -5.441736313477861e-09,  1.847404928866601e-11, -5.732512383497478e-14,  1.595258574077494e-16,
 -3.887665725723837e-19,  6.619957472632864e-22, -4.473651549895847e-25, -8.255878800580383e-27,  1.822176087200264e-29,  8.487353852654106e-02, -4.965889046047637e-04,
  2.120541989613984e-06, -7.732112479498074e-09,  2.488050088794627e-11, -7.022506553154900e-14,  1.622601162871907e-16, -2.470347729841080e-19, -3.236668100431440e-22,
  3.910848787151657e-24, -2.612554605094254e-26,  5.890834492968300e-29,  1.186793327186610e-01, -6.893886822150539e-04,  2.888169049612527e-06, -1.012980118806098e-08,
  3.026074419801938e-11, -7.343023263802311e-14,  1.108848039984182e-16,  1.252333486532114e-19, -2.085541732347026e-21,  1.000181919814927e-23, -4.424668628927014e-26,
  6.853652944897313e-29,  1.582148179118560e-01, -9.110733321984563e-04,  3.728305117855955e-06, -1.243918665623904e-08,  3.344676172249709e-11, -6.176420236514465e-14,
 -1.006389939479799e-17,  7.357981580223293e-19, -4.339957398873083e-21,  1.535779868196599e-23, -4.892261045009689e-26, -1.082770975020961e-29,  2.035206747649733e-01,
 -1.159893359578043e-03,  4.612735400619610e-06, -1.442989944903926e-08,  3.317669545318400e-11, -3.065806330432148e-14, -2.059946593175760e-16,  1.513879275394337e-18,
 -6.372301417904504e-21,  1.582288515246617e-23, -2.305028323103317e-26, -2.238745725461760e-28,  2.546403853009940e-01, -1.433649043700028e-03,  5.507262072832225e-06,
 -1.583775159993612e-08,  2.817236334172413e-11,  2.294893762406743e-14, -4.660582599962843e-16,  2.284233223712701e-18, -7.021685827766787e-21,  6.362812865768690e-24,
  4.551905387609585e-26, -5.494299703504685e-28,  3.116183481083968e-01, -1.729588089868162e-03,  6.370879288935865e-06, -1.636777636771868e-08,  1.725493287444030e-11,
  9.943016232603434e-14, -7.564191607386699e-16,  2.752713174852685e-18, -4.824977536107860e-21, -1.694216967108848e-23,  1.501383262434202e-25, -8.393781482985922e-28,
  3.744971976909834e-01, -2.044274093881127e-03,  7.154855083596125e-06, -1.570085954664868e-08, -4.857842327347859e-13,  1.949843195963122e-13, -1.014024796104709e-15,
  2.517699571774388e-18,  1.581588656194069e-21, -5.346972732619754e-23,  2.485453842038879e-25, -7.879906956665942e-28,  4.433139890620427e-01, -2.373417846826404e-03,
  7.801773576686976e-06, -1.350625777991488e-08, -2.544872951075373e-11,  2.998637802985852e-13, -1.142972956451418e-15,  1.129665611960671e-18,  1.269910408809882e-20,
 -9.343167507647970e-23,  2.514156721300312e-25, -5.816528844001149e-30,  5.180947548268240e-01, -2.711661402083828e-03,  8.244651264891331e-06, -9.463505014284267e-09,
 -5.718275444888023e-11,  3.964668784508803e-13, -1.017374765877847e-15, -1.770146612561927e-18,  2.698745933375858e-20, -1.134902300015830e-22,  3.419687442932831e-26,
  1.699379243602991e-27,  5.988467128528647e-01, -3.052302584386851e-03,  8.406350310798553e-06, -3.298953924154023e-09, -9.392973832370943e-11,  4.577030927032856e-13,
 -4.973669852453592e-16, -6.196465755577996e-18,  3.940737317499370e-20, -7.640150957531826e-23, -4.986105288938804e-25,  3.766872147238119e-27,  6.855470587905091e-01,
 -3.386945797819316e-03,  8.199705449978458e-06,  5.155405264333523e-09, -1.320413050135529e-10,  4.465418199867222e-13,  5.314126030634662e-16, -1.143050256474614e-17,
  4.029323160775899e-20,  5.784116045474605e-23, -1.265630951905070e-24,  4.211423435320719e-27,  7.781267590283256e-01, -3.705064988756739e-03,  7.529119411175463e-06,
  1.587026089165156e-08, -1.653036534010490e-10,  3.185504004509455e-13,  2.081214226080936e-15, -1.553766520057699e-17,  1.612302789967919e-20,  2.982817094632683e-22,
 -1.785896524977547e-24, -3.862718723649845e-28,  8.764469759331689e-01, -3.993469688536696e-03,  6.294960819700266e-06,  2.848114976828219e-08, -1.843120363576081e-10,
  3.066300928478860e-14,  3.936240609796121e-15, -1.501701440246298e-17, -4.475228829771296e-20,  5.586021220893520e-22, -1.038310605459733e-24, -1.240021318362803e-26,
  9.802645785026318e-01, -4.235682366371467e-03,  4.403059495275551e-06,  4.209150030563962e-08, -1.762718849122245e-10, -4.387024552070762e-13,  5.484167703563955e-15,
 -5.199438796213584e-18, -1.371486192486453e-19,  5.818439062125209e-22,  2.110267353522017e-24, -2.599772444661109e-26,  1.089181447361412e+00, -4.411280144647426e-03,
  1.783100625683896e-06,  5.501443416534070e-08, -1.260683397837207e-10, -1.051912540338839e-12,  5.576950286256640e-15,  1.735320243292454e-17, -2.134365586539992e-19,
 -3.972582238402474e-23,  7.069789115801026e-24, -1.800058809226279e-26,  1.202569800659055e+00, -4.495357660968528e-03, -1.578186315610592e-06,  6.449104854457055e-08,
 -2.023512439771027e-11, -1.654482029088267e-12,  2.651403590423832e-15,  4.877924096682795e-17, -1.630164438536706e-19, -1.491116668543502e-21,  8.232551930212375e-24,
  4.180967521158005e-26,  1.319462538412330e+00, -4.458491504676443e-03, -5.581078879416255e-06,  6.653078268157301e-08,  1.435917354727405e-10, -1.916336709378474e-12,
 -4.388636042943338e-15,  6.848455561061945e-17,  1.413414486570477e-19, -2.760350427689291e-21, -4.814956133096703e-24,  1.168095363560620e-25,  1.438394314252124e+00,
 -4.268036454834135e-03, -9.927005330448407e-06,  5.626018437918527e-08,  3.393178170809077e-10, -1.351654101598330e-12, -1.390257600448343e-14,  3.649215054880840e-17,
  6.193886275081740e-19, -9.233166328884277e-22, -2.930506832062456e-23,  9.735556137559125e-27,  1.557178532355328e+00, -3.892399357264432e-03, -1.400832823387859e-05,
  2.957863390565962e-08,  4.905423766918384e-10,  3.939251564353015e-13, -1.847507795071663e-14, -7.149889603797109e-17,  6.434926762232967e-19,  5.355742538695629e-21,
 -1.674403478884207e-23, -3.302503491424746e-25,  1.672616124616538e+00, -3.311127597391763e-03, -1.682533824385201e-05, -1.277513690490402e-08,  4.686968550046220e-10,
  2.791122090133102e-12, -6.737952337473829e-15, -1.682938630585089e-16, -5.217720658975383e-19,  6.292612217043064e-21,  6.188297479619297e-23, -3.542612576231477e-26,
  1.780173693399765e+00, -2.534422930217332e-03, -1.709220684918265e-05, -5.888572786824677e-08,  1.729342802502958e-10,  3.711405240065885e-12,  1.909858306616747e-14,
 -4.932400497233103e-17, -1.439548886859544e-18, -8.373044079402419e-21,  2.069271349553990e-23,  6.851200266866018e-25,  1.873775428327419e+00, -1.632769201915927e-03,
 -1.383836754235934e-05, -8.318589715919678e-08, -2.700339202189332e-10,  1.076335091032335e-12,  2.415625567987561e-14,  1.864833158059537e-16,  5.273483673993948e-19,
 -5.839233111484098e-21, -9.608219240336779e-23, -6.598018498695326e-25,  1.946041441829451e+00, -7.637739522788774e-04, -7.668959308032325e-06, -6.322565417627166e-08,
 -4.334775288873787e-10, -2.302281391381469e-12, -6.371030554345039e-15,  4.519198479267781e-17,  9.415373057665798e-19,  9.458097778088161e-21,  6.514725732225225e-23,
  2.539546812231168e-25,  1.989451060390682e+00, -1.577311804904519e-04, -1.750333771973605e-06, -1.702784133668712e-08, -1.525966525355967e-10, -1.284233558465238e-12,
 -1.022004468058103e-14, -7.686776337207831e-17, -5.422736735831735e-19, -3.522785910175307e-21, -2.019415281848263e-23, -9.016360245599490e-26,  6.830094342868602e-04,
 -4.017493156014298e-06,  1.771600238138212e-08, -6.944991044613647e-11,  2.549434590114544e-13, -8.996648583353018e-16,  3.071922531174332e-18, -1.037739247766461e-20,
  3.355955324332801e-23, -1.151791457507193e-25,  3.158498301530463e-28, -1.543037947811650e-30,  6.148465019077124e-03, -3.612826473781716e-05,  1.588956692167828e-07,
 -6.198651075543677e-10,  2.257771721300773e-12, -7.877362026266030e-15,  2.647394503045281e-17, -8.762346594654647e-20,  2.753349018308132e-22, -9.192640632542344e-25,
  2.345937162578841e-27, -1.186891007888714e-29,  1.708672616839266e-02, -1.001928075697330e-04,  4.383132637487268e-07, -1.692968527134388e-09,  6.067955969201614e-12,
 -2.067176510821954e-14,  6.713558808051550e-17, -2.122869338658682e-19,  6.232322148265332e-22, -1.943855169809390e-24,  3.999730998922905e-27, -2.305799379115161e-29,
  3.351244003429970e-02, -1.958902819780977e-04,  8.500021996733915e-07, -3.232934410078525e-09,  1.129643578556217e-11, -3.701183018784579e-14,  1.133348965605039e-16,
 -3.293422526422221e-19,  8.380847984752633e-22, -2.220019348910920e-24,  1.581892991457786e-27, -2.204847717857022e-29,  5.544743649544692e-02, -3.227219436759091e-04,
  1.384802198569986e-06, -5.155119181158399e-09,  1.736496359519489e-11, -5.362475217596281e-14,  1.489340994069078e-16, -3.679028860076381e-19,  6.400893206008082e-22,
 -7.671558337442522e-25, -7.881333539359854e-27, -2.127183448034128e-30,  8.292053335450601e-02, -4.799890479698138e-04,  2.030099498315668e-06, -7.345051259815691e-09,
  2.351437620782890e-11, -6.641487380793232e-14,  1.552178942978547e-16, -2.553366015273866e-19, -2.011417549838649e-22,  2.908793316565245e-24, -2.421174156629955e-26,
  2.660372022640947e-29,  1.159672303038658e-01, -6.667614400219139e-04,  2.769468474162692e-06, -9.657232463643895e-09,  2.881899832062999e-11, -7.073413963202232e-14,
  1.135087409690682e-16,  6.392080711546928e-20, -1.756694646718828e-21,  8.282450853108046e-24, -4.199060406970320e-26,  3.148117175589094e-29,  1.546292448064767e-01,
 -8.818349686291162e-04,  3.582204978696893e-06, -1.191392713551449e-08,  3.221065214301560e-11, -6.177370372549649e-14,  8.674564869431268e-18,  6.053866739638396e-19,
 -3.822467115914928e-21,  1.338538733882818e-23, -4.988984591039900e-26, -3.734944193421705e-29,  1.989538210970121e-01, -1.123675135761028e-03,  4.442740503947074e-06,
 -1.390423222470417e-08,  3.251741207028940e-11, -3.511579443591655e-14, -1.663765764208051e-16,  1.318882596999334e-18, -5.821620050865333e-21,  1.470640571726797e-23,
 -3.277558840161448e-26, -2.243653999112179e-28,  2.489927125095704e-01, -1.390343465271282e-03,  5.319926836506508e-06, -1.538390840449751e-08,  2.852453847166291e-11,
  1.250587438933821e-14, -4.052087746525297e-16,  2.063509034050332e-18, -6.765580652342447e-21,  7.710070511437635e-24,  2.201417933330492e-26, -5.263698576741143e-28,
  3.048006926837801e-01, -1.679401870626315e-03,  6.176184945704776e-06, -1.607674910123004e-08,  1.906814626036584e-11,  8.218304306742415e-14, -6.815886263567064e-16,
  2.589642272275398e-18, -5.335662904707417e-21, -1.167204159313791e-23,  1.133844947592571e-25, -8.376139199155640e-28,  3.664333859250022e-01, -1.987788738699224e-03,
  6.966522605849908e-06, -1.567873284229754e-08,  3.176268604228171e-12,  1.714976788367286e-13, -9.430967575336052e-16,  2.539360734523066e-18, -1.730391824599053e-22,
 -4.425598898994118e-23,  2.112658449373705e-25, -9.089010238676447e-28,  4.339441103928589e-01, -2.311658434474480e-03,  7.637448518760347e-06, -1.386693814252636e-08,
 -1.972298094798266e-11,  2.728548782956982e-13, -1.106144970643681e-15,  1.484154071049373e-18,  9.515510809357668e-21, -8.349086767596108e-23,  2.429165397133895e-25,
 -3.784121642524910e-28,  5.073792832377366e-01, -2.646173399980838e-03,  8.125856989117719e-06, -1.031633618593542e-08, -4.950111314896616e-11,  3.715489391655171e-13,
 -1.055460026686058e-15, -9.715197527670461e-19,  2.294266981245646e-20, -1.108227700385613e-22,  9.432226594543759e-26,  1.032391138477452e-27,  5.867717182423566e-01,
 -2.985234989365213e-03,  8.358045436908070e-06, -4.729302269553501e-09, -8.490837294593611e-11,  4.438240983997568e-13, -6.536526306730960e-16, -4.982973749216638e-18,
  3.633608829283890e-20, -9.322813779884530e-23, -3.478671070778567e-25,  3.060289898246788e-27,  6.721308128932656e-01, -3.321135927285599e-03,  8.249191019184184e-06,
  3.114777861563213e-09, -1.230080940475047e-10,  4.556023576543781e-13,  2.296553875274325e-16, -1.011720834665339e-17,  4.150926300189055e-20,  1.095371347847029e-23,
 -1.078749049154518e-24,  4.210623546008167e-27,  7.634281083067982e-01, -3.644114722439291e-03,  7.703912024088759e-06,  1.327893765721105e-08, -1.584680517870197e-10,
  3.633466161735157e-13,  1.654898698083321e-15, -1.486370430309128e-17,  2.557636249415645e-20,  2.270606700597118e-22, -1.762603545119987e-24,  1.335673604465488e-27,
  8.605759104462755e-01, -3.941792960429272e-03,  6.619077128577911e-06,  2.554205048736822e-08, -1.827888956204962e-10,  1.199435122711443e-13,  3.498675307156343e-15,
 -1.613635458861941e-17, -2.551238993978931e-20,  5.071765584308240e-22, -1.508057323729215e-24, -8.986324001598608e-27,  9.633954284337154e-01, -4.198486064994258e-03,
  4.890968863320877e-06,  3.920805094104513e-08, -1.837440050537751e-10, -3.093054893758610e-13,  5.280393042518300e-15, -9.238982330739436e-18, -1.149558976557809e-19,
  6.436876484105558e-22,  9.923923439575841e-25, -2.456952093234695e-26,  1.071568987032004e+00, -4.394410488285793e-03,  2.430500987776879e-06,  5.283645838458815e-08,
 -1.457327527948507e-10, -9.130062556753254e-13,  5.967384694212317e-15,  1.055321141914250e-17, -2.099927314732071e-19,  2.244751403749478e-22,  6.077440595421214e-24,
 -2.662169733478127e-26,  1.184568009299005e+00, -4.504895575206811e-03, -8.073158216524288e-07,  6.390648002076801e-08, -5.258104518671288e-11, -1.575095230926869e-12,
  3.936593313581637e-15,  4.277063961735637e-17, -2.103785924458232e-19, -1.130840880110197e-21,  9.634076955604270e-24,  2.164116956966175e-26,  1.301544382727076e+00,
 -4.499910547933254e-03, -4.770206199492244e-06,  6.851657377534207e-08,  1.043692993227902e-10, -1.998234971758915e-12, -2.422892905938326e-15,  7.139048134459989e-17,
  3.975170362941258e-20, -2.849138709275005e-21,  3.766620913905813e-25,  1.169671114953873e-25,  1.421167739564767e+00, -4.344661884591321e-03, -9.220258378429580e-06,
  6.145526306490041e-08,  3.090422964816280e-10, -1.670853612782444e-12, -1.260990892782450e-14,  5.555654790690419e-17,  5.653336195058059e-19, -2.067111427393335e-21,
 -2.739694562972569e-23,  7.653854827135561e-26,  1.541387238607328e+00, -4.002912342137675e-03, -1.360611236115036e-05,  3.746561188027641e-08,  4.938374641043223e-10,
 -7.100064552119472e-14, -2.016086313126157e-14, -4.797986692251940e-17,  8.207519803838979e-19,  4.397135310658725e-21, -3.105948248881198e-23, -3.127684091572382e-25,
  1.659101623395907e+00, -3.446211847030085e-03, -1.693183576234845e-05, -4.839827234902278e-09,  5.225116969096077e-10,  2.571204028325899e-12, -1.164650697282376e-14,
 -1.808947261114238e-16, -2.515768885438091e-19,  8.679208666683895e-21,  5.595535406094155e-23, -2.397873361855222e-25,  1.769758125098921e+00, -2.673934261408886e-03,
 -1.777970520893375e-05, -5.550061670818212e-08,  2.516061196391973e-10,  4.147721673343918e-12,  1.702877546448631e-14, -9.999030568572204e-17, -1.718297294497080e-18,
 -6.886258466450521e-21,  5.494665926768439e-23,  8.626590893288866e-25,  1.867016514243540e+00, -1.747540664919797e-03, -1.486170422001105e-05, -8.730091964146102e-08,
 -2.422778431667845e-10,  1.720428343621187e-12,  2.957681946817936e-14,  1.991961728495778e-16,  2.409158488113353e-19, -1.026640988787705e-20, -1.251440318718938e-22,
 -6.404179499539887e-25,  1.942858666387472e+00, -8.282819150752524e-04, -8.470826085728580e-06, -7.053747179472907e-08, -4.809307109320286e-10, -2.436263900349585e-12,
 -4.628951640535674e-15,  8.129280726207378e-17,  1.331463785084686e-18,  1.226815000271867e-20,  7.470460250346091e-23,  1.636475738638929e-25,  1.988790774928033e+00,
 -1.725947357408666e-04, -1.970209998071716e-06, -1.968896070110051e-08, -1.809191227112730e-10, -1.557426010325983e-12, -1.263550281832140e-14, -9.641338345447665e-17,
 -6.846009278317502e-19, -4.410942319292460e-21, -2.421664858268612e-23, -9.038563450229139e-26,  6.672177356352670e-04, -3.879030729990839e-06,  1.690649696030141e-08,
 -6.551085235006887e-11,  2.376644985356460e-13, -8.293079175620143e-16,  2.795783482673253e-18, -9.367525408590783e-21,  2.962398640242022e-23, -1.039237788274950e-25,
  2.460897475843421e-28, -1.658296535122868e-30,  6.006448032560823e-03, -3.488625054871036e-05,  1.516689445413976e-07, -5.849674325620984e-10,  2.106384515536870e-12,
 -7.270463175556625e-15,  2.413898609231647e-17, -7.932517173476393e-20,  2.438021060243715e-22, -8.361671062116834e-25,  1.798875234775964e-27, -1.326025598864609e-29,
  1.669284157409895e-02, -9.676594432720397e-05,  4.185667999857195e-07, -1.599103150481878e-09,  5.670163117845696e-12, -1.912964940329886e-14,  6.146045010926898e-17,
 -1.934343451862513e-19,  5.558770036881080e-22, -1.805497448750105e-24,  2.878003323739222e-27, -2.860942110372329e-29,  3.274223750341734e-02, -1.892424279150172e-04,
  8.122674870688863e-07, -3.057968623392111e-09,  1.058266795893787e-11, -3.439949461365159e-14,  1.044768357599534e-16, -3.037921712982331e-19,  7.590359066100424e-22,
 -2.179904673109245e-24,  3.182282431878459e-28, -3.662691424951801e-29,  5.417832032911307e-02, -3.118863288030211e-04,  1.324573032192020e-06, -4.885668975059886e-09,
  1.632739017752807e-11, -5.017166230349960e-14,  1.389149897565588e-16, -3.479233800238830e-19,  6.067062651295432e-22, -1.091934971921809e-24, -8.566935097016105e-27,
 -3.099628768560801e-29,  8.103250942877083e-02, -4.640945181811506e-04,  1.944173078466760e-06, -6.979247658881556e-09,  2.222274855035391e-11, -6.277607465210569e-14,
  1.479927775630801e-16, -2.602829998662474e-19, -1.136836644638876e-22,  1.951630773426883e-24, -2.397643391646572e-26, -1.890618110131258e-29,  1.133437730156562e-01,
 -6.450615071710013e-04,  2.656302104761578e-06, -9.207297439799193e-09,  2.743167089618216e-11, -6.799454069641479e-14,  1.145540492869606e-16,  1.215494168222190e-20,
 -1.488560265953709e-21,  6.615409753087615e-24, -4.178258020438939e-26, -2.660598751132000e-29,  1.511583269983793e-01, -8.537405297995792e-04,  3.442289356834211e-06,
 -1.140842366201676e-08,  3.097856338576522e-11, -6.137549489995977e-14,  2.398259969331603e-17,  4.903885298004178e-19, -3.377037075232847e-21,  1.134242172468924e-23,
 -5.268819279076386e-26, -9.670330194502488e-29,  1.945291600949949e-01, -1.088791824864885e-03,  4.278987543018933e-06, -1.338977693054166e-08,  3.177805027591030e-11,
 -3.868625903494920e-14, -1.319782766521302e-16,  1.140788795246326e-18, -5.318249394093801e-21,  1.318813458184213e-23, -4.348047812479331e-26, -2.718442364650276e-28,
  2.435152992751076e-01, -1.348514703836427e-03,  5.138064886244775e-06, -1.492602403349114e-08,  2.868196056368031e-11,  3.449999912567072e-15, -3.504188265575859e-16,
  1.851575893235943e-18, -6.477786737643525e-21,  8.122393498308087e-24, -1.647887354615545e-27, -5.612766136388477e-28,  2.981806898072110e-01, -1.630758769216976e-03,
  5.985145926824986e-06, -1.575937396414387e-08,  2.055399790781224e-11,  6.667538332326052e-14, -6.115263682120512e-16,  2.412980657098792e-18, -5.683190414141380e-21,
 -7.884511301553153e-24,  7.559358447603165e-26, -8.931350598170929e-28,  3.585925053016528e-01, -1.932808020277327e-03,  6.778792004342404e-06, -1.560167856902709e-08,
  6.385628954540195e-12,  1.497145403511448e-13, -8.723005289361337e-16,  2.509882316170614e-18, -1.624160710680196e-21, -3.664766737177760e-23,  1.679877113652047e-25,
 -1.069597148299384e-27,  4.248186149054223e-01, -2.251229418565362e-03,  7.469327306762058e-06, -1.414027675693671e-08, -1.452782583173280e-11,  2.468377717340033e-13,
 -1.060764411271970e-15,  1.742395824362835e-18,  6.679719747906700e-21, -7.421834828064058e-23,  2.178816892844242e-25, -7.679646839861201e-28,  4.969238010329328e-01,
 -2.581674636735086e-03,  7.997549590280237e-06, -1.105029028917585e-08, -4.232523496828734e-11,  3.459707701864826e-13, -1.072978389231982e-15, -3.003832026413285e-19,
  1.903008192269402e-20, -1.063428270852980e-22,  1.245887430337387e-25,  3.327609992030252e-28,  5.749641158622705e-01, -2.918620058607499e-03,  8.293432644731778e-06,
 -6.017721858612336e-09, -7.619940343408483e-11,  4.265903564841515e-13, -7.774195697556605e-16, -3.876354759848177e-18,  3.275967673987156e-20, -1.046921983469440e-22,
 -2.316458876371669e-25,  2.192968847614146e-27,  6.589784466433475e-01, -3.255025654002332e-03,  8.275060987451068e-06,  1.219750591069933e-09, -1.138630992143633e-10,
  4.578648779482138e-13, -3.502831515794307e-17, -8.790573372563115e-18,  4.117071568281906e-20, -2.858844877776555e-23, -9.015734698078792e-25,  3.768635563459109e-27,
  7.489758611019161e-01, -3.581888574937401e-03,  7.848292759634806e-06,  1.080360252851657e-08, -1.508371463967062e-10,  3.981695341257059e-13,  1.251305802622681e-15,
 -1.392794395992774e-17,  3.249894270454414e-20,  1.580846489974975e-22, -1.678813480634772e-24,  2.347742944157516e-27,  8.449165151202843e-01, -3.887663832370619e-03,
  6.908127518298059e-06,  2.264102632600037e-08, -1.795873473126356e-10,  1.984140880799101e-13,  3.038085462266232e-15, -1.667297665753009e-17, -8.426602537115025e-21,
  4.398748538906829e-22, -1.835054383327750e-24, -5.975500195530974e-27,  9.466826483656617e-01, -4.157526731886835e-03,  5.343643955161144e-06,  3.622544845721944e-08,
 -1.886858311274437e-10, -1.860744010298956e-13,  4.973727504447764e-15, -1.254121963083634e-17, -9.132289528114717e-20,  6.624627857907310e-22, -3.471235316335633e-26,
 -2.198311180347032e-26,  1.054034190938688e+00, -4.372471306460019e-03,  3.049971008092481e-06,  5.036652172552017e-08, -1.625406576365268e-10, -7.669933922488548e-13,
  6.170333383531795e-15,  4.007251826188071e-18, -1.978356469494888e-19,  4.422675616816611e-22,  4.770986389667078e-24, -3.228228454126880e-26,  1.166540343534308e+00,
 -4.508303251612926e-03, -4.650769781852963e-08,  6.281869441330146e-08, -8.304524496638082e-11, -1.467041703327838e-12,  5.034340751223539e-15,  3.546303199853707e-17,
 -2.439784947008020e-19, -7.325413419267212e-22,  1.013048197695920e-23,  1.018957471057862e-27,  1.283473660547370e+00, -4.534758068001972e-03, -3.939315070242586e-06,
  6.986428652939063e-08,  6.398536108262950e-11, -2.032347880832196e-12, -4.214919002739169e-16,  7.103425248738511e-17, -6.133024936533376e-20, -2.734006770329415e-21,
  5.286672332888928e-24,  1.041927490465622e-25,  1.403646353684994e+00, -4.415392683243724e-03, -8.454281657224522e-06,  6.611672463259937e-08,  2.727350945496021e-10,
 -1.952856319058979e-12, -1.081370763866907e-14,  7.225275910459855e-17,  4.721711947835528e-19, -3.077367982392608e-21, -2.268507876927018e-23,  1.355372760631603e-25,
  1.525160928101147e+00, -4.109828848634822e-03, -1.310924975755257e-05,  4.532895984748062e-08,  4.874859512756120e-10, -5.678777141735781e-13, -2.111466645759110e-14,
 -1.944888156435850e-17,  9.535056087153580e-19,  2.895140075497748e-21, -4.356989222670458e-23, -2.482669106267705e-25,  1.645045704471124e+00, -3.581752920696651e-03,
 -1.693810950291674e-05,  3.914830875155278e-09,  5.707269246074222e-10,  2.230301097184200e-12, -1.677435283320316e-14, -1.835385377859085e-16,  9.802360895375913e-20,
  1.064082627893972e-20,  4.049327246539542e-23, -4.632539472237686e-25,  1.758773799827275e+00, -2.818761052202732e-03, -1.841875187221510e-05, -5.079014426606960e-08,
  3.383876589079431e-10,  4.516390160970970e-12,  1.342544678511854e-14, -1.584416288089202e-16, -1.917161168611389e-18, -3.894344372800066e-21,  9.530437451310511e-23,
  9.514932844331849e-25,  1.859781840186675e+00, -1.870687767307927e-03, -1.593130830448930e-05, -9.086162112716103e-08, -2.003161397184886e-10,  2.497695705980361e-12,
  3.519948364329629e-14,  1.999729050412225e-16, -2.252334332785287e-19, -1.579608623465302e-20, -1.500015233859373e-22, -4.553036235137012e-25,  1.939404455058002e+00,
 -8.995688736853881e-04, -9.365070247455537e-06, -7.862733558832711e-08, -5.305558750672332e-10, -2.514800782022842e-12, -1.685683327569001e-15,  1.315538755119280e-16,
  1.828165548643306e-18,  1.534596828520906e-20,  7.754011777612894e-23, -6.377661920588737e-26,  1.988067303529437e+00, -1.893531749204927e-04, -2.224929655150976e-06,
 -2.285029586080404e-08, -2.153322705540076e-10, -1.895702090400673e-12, -1.566702775323050e-14, -1.210558391402582e-16, -8.617554373755524e-19, -5.455049166787008e-21,
 -2.783644479408046e-23, -6.912751203880113e-26,  6.519672274724301e-04, -3.746859867774858e-06,  1.614264675099980e-08, -6.183735123390409e-11,  2.217286218519633e-13,
 -7.652528747934889e-16,  2.546214577764279e-18, -8.477665434854384e-21,  2.604160935348405e-23, -9.562270056403437e-26,  1.663762629279693e-28, -2.016203884306526e-30,
  5.869286070488530e-03, -3.370041534283850e-05,  1.448468496955324e-07, -5.523978168501402e-10,  1.966593139056933e-12, -6.716926525480431e-15,  2.202267146553574e-17,
 -7.199243729251023e-20,  2.148473479663481e-22, -7.767205382143218e-25,  1.148017526576912e-27, -1.677609795767815e-29,  1.631235547340222e-02, -9.349265315954570e-05,
  3.999095269333620e-07, -1.511362946167609e-09,  5.301892064772137e-12, -1.771764181690627e-14,  5.628369337730597e-17, -1.766666479682113e-19,  4.926235590507927e-22,
 -1.718320015117269e-24,  1.399887207692715e-27, -3.979457139674575e-29,  3.199803566184060e-02, -1.828882434429692e-04,  7.765655295705511e-07, -2.894016461043528e-09,
  9.919077383808449e-12, -3.199145256029601e-14,  9.629890289149654e-17, -2.807597079705897e-19,  6.803435074788204e-22, -2.205798830188674e-24, -1.794824265998801e-27,
 -6.173262321398050e-29,  5.295160304221041e-02, -3.015198907064841e-04,  1.267479898471910e-06, -4.632280326291033e-09,  1.535651861390717e-11, -4.695244972025616e-14,
  1.294385396802669e-16, -3.292072204151673e-19,  5.607943212335674e-22, -1.473756710153177e-24, -1.085636033857371e-26, -7.683017553593109e-29,  7.920671611177615e-02,
 -4.488701870316051e-04,  1.862514676546634e-06, -6.633537355962275e-09,  2.100215312876040e-11, -5.931205591693472e-14,  1.406631512408765e-16, -2.629845287171559e-19,
 -6.105311858575379e-23,  9.574122426586489e-25, -2.625122580079249e-26, -9.018616588500018e-29,  1.108053384647663e-01, -6.242456815765446e-04,  2.548403583458440e-06,
 -8.779120431911841e-09,  2.609927369482408e-11, -6.524633364676893e-14,  1.142609953818536e-16, -3.199478147440786e-20, -1.280990732055772e-21,  4.895925228376561e-24,
 -4.488997383829883e-26, -1.229497620427012e-28,  1.477975862417470e-01, -8.267414861767113e-04,  3.308321820688280e-06, -1.092255100022896e-08,  2.975785995014925e-11,
 -6.064699081078273e-14,  3.625899506476748e-17,  3.884398765278702e-19, -3.007923537452997e-21,  9.121118543148481e-24, -5.920815429631542e-26, -2.114414058267218e-28,
  1.902414510970766e-01, -1.055194050052426e-03,  4.121334851125049e-06, -1.288767950742460e-08,  3.097514004628462e-11, -4.148923734867679e-14, -1.023499285169654e-16,
  9.778404724337231e-19, -4.877922243046549e-21,  1.118019411750624e-23, -5.781224054493561e-26, -3.956236153821881e-28,  2.382023261372669e-01, -1.308118830045739e-03,
  4.961706910044057e-06, -1.446700040160645e-08,  2.867093950173672e-11, -4.361077598054241e-15, -3.014331699293380e-16,  1.648902553775521e-18, -6.192776825145209e-21,
  7.532611522768511e-24, -2.879372195476771e-26, -6.930930240293790e-28,  2.917522273727148e-01, -1.583628364786958e-03,  5.798048107589498e-06, -1.542061676799037e-08,
  2.174610463537518e-11,  5.278871822367523e-14, -5.465479447782237e-16,  2.227081688681138e-18, -5.922408320830217e-21, -5.685068084851153e-24,  3.318272359055716e-26,
 -1.058673059751514e-27,  3.509685509079861e-01, -1.879324607628710e-03,  6.592280073892428e-06, -1.547666788594497e-08,  9.176224683671590e-12,  1.296156001177967e-13,
 -8.029410913458670e-16,  2.438001020749728e-18, -2.834473209888274e-21, -3.093787649253191e-23,  1.155463939575520e-25, -1.339811256485904e-27,  4.159321267117952e-01,
 -2.192157118673598e-03,  7.298407792960904e-06, -1.433459417243571e-08, -9.841587534461865e-12,  2.219866142861902e-13, -1.009374912087579e-15,  1.915005252511790e-18,
  4.155394911209932e-21, -6.631212868707577e-23,  1.738722619873214e-25, -1.258473256840523e-27,  4.867242078863478e-01, -2.518235649634664e-03,  7.861106687769296e-06,
 -1.167353955584569e-08, -3.566367489702817e-11,  3.201836703278323e-13, -1.073432212025325e-15,  2.483029964774538e-19,  1.529291904304546e-20, -1.012941767230102e-22,
  1.219136147353549e-25, -4.838355671601316e-28,  5.634218447891012e-01, -2.852581532680262e-03,  8.214183009713928e-06, -7.169706428514670e-09, -6.786237135756579e-11,
  4.067447485342323e-13, -8.718595050836369e-16, -2.889965055267022e-18,  2.884451710082522e-20, -1.123294619899205e-22, -1.581508838272751e-25,  1.101340451231050e-27,
  6.460907948974459e-01, -3.188796893584133e-03,  8.279068957635048e-06, -5.289273152272560e-10, -1.047333809896252e-10,  4.542182470222767e-13, -2.629224182774677e-16,
 -7.496226554130728e-18,  3.953029045632895e-20, -6.156968369948954e-23, -7.542343689606495e-25,  2.840219373107195e-27,  7.347746434491420e-01, -3.518624072473502e-03,
  7.963723344264938e-06,  8.455416597456309e-09, -1.426044029145617e-10,  4.236434007247450e-13,  8.766472633889789e-16, -1.280967103515766e-17,  3.700734312929222e-20,
  9.311792620956672e-23, -1.568147902794948e-24,  2.533541625148524e-27,  8.294780420166356e-01, -3.831360564180604e-03,  7.162722800420768e-06,  1.980317759391366e-08,
 -1.749278366197086e-10,  2.657096620303493e-13,  2.569743841487055e-15, -1.670389630875578e-17,  6.030999188297314e-21,  3.619380739173966e-22, -2.045589973135971e-24,
 -3.758722383797616e-27,  9.301407200995568e-01, -4.113090322577234e-03,  5.760133356870752e-06,  3.318306394391846e-08, -1.912436813477666e-10, -7.122703360539415e-14,
  4.585233335668728e-15, -1.508408107340490e-17, -6.772432291066981e-20,  6.426114363149022e-22, -9.358466271245919e-25, -1.897495461388732e-26,  1.036596869217981e+00,
 -4.345699269828404e-03,  3.638285287205154e-06,  4.765122385473037e-08, -1.763941871756930e-10, -6.182583697633972e-13,  6.196545788385412e-15, -2.034755613550087e-18,
 -1.788311361676393e-19,  6.036453384844337e-22,  3.276214910590924e-24, -3.527284786762278e-26,  1.148511125851833e+00, -4.505684789812061e-03,  6.983981927851693e-07,
  6.126213005280920e-08, -1.111020597975493e-10, -1.335205748262565e-12,  5.914595132424707e-15,  2.731172106377904e-17, -2.630983651622967e-19, -3.322335474956228e-22,
  9.744793939689511e-24, -1.820062970532713e-26,  1.265276929417140e+00, -4.562904788194787e-03, -3.096142331580575e-06,  7.056299812787975e-08,  2.339682504383453e-11,
 -2.018907217166763e-12,  1.525535923693779e-15,  6.754631384770058e-17, -1.548993307457769e-19, -2.437156135665915e-21,  9.381801933274194e-24,  8.034247574656746e-26,
  1.385854640022230e+00, -4.479782206193800e-03, -7.636031004424218e-06,  7.015464525338403e-08,  2.312549153135425e-10, -2.186509326241566e-12, -8.596929181969756e-15,
  8.542706625798436e-17,  3.466186340244460e-19, -3.851645268317547e-21, -1.572267700787566e-23,  1.774532507135103e-25,  1.508515495541861e+00, -4.212395503164776e-03,
 -1.251896792983476e-05,  5.301021909774060e-08,  4.710349493447131e-10, -1.077632877661606e-12, -2.121890988773523e-14,  1.237483201411083e-17,  1.023983459862989e-18,
  9.625004846565204e-22, -5.228631033285478e-23, -1.419924113068509e-25,  1.630448204002556e+00, -3.716911407801930e-03, -1.683494535254938e-05,  1.337969981290054e-08,
  6.108942076664522e-10,  1.766766208940207e-12, -2.180995009687469e-14, -1.740037335000395e-16,  5.047600182410502e-19,  1.179012195074285e-20,  1.548768521094241e-23,
 -6.662288939263383e-25,  1.747200334662788e+00, -2.968449982008646e-03, -1.899271528625468e-05, -4.463744698698656e-08,  4.315419484560823e-10,  4.778330832090364e-12,
  8.114836244758931e-15, -2.212164350111480e-16, -1.978685907970649e-18,  7.484829594682041e-22,  1.363361465725797e-22,  8.816838460284585e-25,  1.852037211172423e+00,
 -2.002549973473097e-03, -1.703907579474074e-05, -9.361926597634885e-08, -1.414674034463474e-10,  3.408292060459172e-12,  4.060387802829830e-14,  1.824757119843380e-16,
 -9.057830749988590e-19, -2.208980224216941e-20, -1.615281805230514e-22, -2.078483491506884e-26,  1.935650153978873e+00, -9.784116890254194e-04, -1.036119480439187e-05,
 -8.751941777388736e-08, -5.809216824122131e-10, -2.503912814645532e-12,  2.904100645431235e-15,  1.994811485313264e-16,  2.434774652345163e-18,  1.827813284535344e-20,
  6.578449474174650e-23, -5.164522693621655e-25,  1.987272468671753e+00, -2.083110168964373e-04, -2.521125733446818e-06, -2.662056524262724e-08, -2.572978565782165e-10,
 -2.315690898620671e-12, -1.947374302962885e-14, -1.519941434050565e-16, -1.078782577291130e-18, -6.614298425158855e-21, -2.965092594974973e-23, -3.247063852021879e-27,
  6.372334543475696e-04, -3.620627718447731e-06,  1.542138995567299e-08, -5.840889253396195e-11,  2.070159018302771e-13, -7.069011934133079e-16,  2.319997177518961e-18,
 -7.698312323531077e-21,  2.269594973049173e-23, -9.093021985477038e-26,  6.270766678343423e-29, -2.780701102575858e-30,  5.736760718420212e-03, -3.256763075364849e-05,
  1.384025268472008e-07, -5.219789890246762e-10,  1.837380677313354e-12, -6.211820538748830e-15,  2.009898556134676e-17, -6.555739446935093e-20,  1.875185055318018e-22,
 -7.473339766320537e-25,  2.696291101454206e-28, -2.390674879583411e-29,  1.594467055062209e-02, -9.036450671305569e-05,  3.822706927963952e-07, -1.429295752433084e-09,
  4.960655599603145e-12, -1.642446870481857e-14,  5.154847879665180e-17, -1.618853648414715e-19,  4.313032900644325e-22, -1.702634862266907e-24, -7.680656200947380e-28,
 -6.082174652753279e-29,  3.127869153711740e-02, -1.768119818317435e-04,  7.427688486761135e-07, -2.740306911060515e-09,  9.301735706915057e-12, -2.977222804286067e-14,
  8.873035450823347e-17, -2.602790654762167e-19,  5.988885861290097e-22, -2.343136260403155e-24, -5.391272887727106e-27, -1.057562326086526e-28,  5.176545690862824e-02,
 -2.915982942878418e-04,  1.213336309997983e-06, -4.393922730796390e-09,  1.444779848764450e-11, -4.395456276541246e-14,  1.204633560646390e-16, -3.122022410522966e-19,
  4.989326464115258e-22, -1.995377742657724e-24, -1.578197719918887e-26, -1.536696950386359e-28,  7.744053939708685e-02, -4.342828558017386e-04,  1.784889876330122e-06,
 -6.306811917349194e-09,  1.984907368489376e-11, -5.602469947885780e-14,  1.332759158502501e-16, -2.645989260248480e-19, -4.671358489396888e-23, -2.024490478407951e-25,
 -3.259854984189495e-26, -2.083006446637512e-28,  1.083484728752272e-01, -6.042728498954156e-04,  2.445517087579879e-06, -8.371822855804956e-09,  2.482167380245679e-11,
 -6.251930190415623e-14,  1.128152106774042e-16, -7.052597164037166e-20, -1.138734710527374e-21,  2.950064754991127e-24, -5.359220921740906e-26, -2.869064210396197e-28,
  1.445427346381852e-01, -8.007911917799719e-04,  3.180068099025989e-06, -1.045607797184136e-08,  2.855444828868933e-11, -5.965684922432807e-14,  4.583374650110904e-17,
  2.969617844012729e-19, -2.724903519972224e-21,  6.513732199042187e-24, -7.267782193085616e-26, -4.205961569835804e-28,  1.860856486011142e-01, -1.022833618507495e-03,
  3.969628519939379e-06, -1.239884001266443e-08,  3.012291941718667e-11, -4.363436476637709e-14, -7.709859351423004e-17,  8.277028648925378e-19, -4.521804066480073e-21,
  8.457187099506741e-24, -8.015613013304588e-26, -6.464318972649451e-28,  2.330481496333915e-01, -1.269111801395390e-03,  4.790851205780259e-06, -1.400934091305423e-08,
  2.851499899873320e-11, -1.106359443133588e-14, -2.579994457929733e-16,  1.454786495534963e-18, -5.950314863721896e-21,  5.698953766177339e-24, -6.502251792780298e-26,
 -9.875357308489357e-28,  2.855093191670005e-01, -1.537978178878460e-03,  5.615120921352332e-06, -1.506492478324947e-08,  2.267564705975314e-11,  4.039826927329046e-14,
 -4.868723893786679e-16,  2.034450109425493e-18, -6.115180337267751e-21, -5.377761309595498e-24, -2.043211780212563e-26, -1.419634739488279e-27,  3.435555565068847e-01,
 -1.827326560835350e-03,  6.407523194448834e-06, -1.531013381769015e-08,  1.158130297929949e-11,  1.111529326056583e-13, -7.361086848032030e-16,  2.330247344293098e-18,
 -3.880340934794707e-21, -2.761852202421127e-23,  4.687418455596211e-26, -1.829315223449710e-27,  4.072791799876622e-01, -2.134460264802256e-03,  7.125590168457310e-06,
 -1.445783946620367e-08, -5.639693534505306e-12,  1.984179233703394e-13, -9.542431403916777e-16,  2.011005065037689e-18,  1.878300989703854e-21, -6.065556379830629e-23,
  1.036885150221621e-25, -1.984759937207426e-27,  4.767761427411674e-01, -2.455916348950074e-03,  7.717807296114111e-06, -1.219432540664069e-08, -2.951679045605050e-11,
  2.945566890981216e-13, -1.060170318926804e-15,  6.802134056755948e-19,  1.172634973401180e-20, -9.713651549050590e-23,  7.809542647479390e-26, -1.568527686184841e-27,
  5.521423754353507e-01, -2.787230062339642e-03,  8.121896442959153e-06, -8.191587799488396e-09, -5.994275407112729e-11,  3.849496156737542e-13, -9.404723786819527e-16,
 -2.032791574016154e-18,  2.469490793276038e-20, -1.180833483287510e-22, -1.401849248900949e-25, -3.636300534623598e-28,  6.334679929173651e-01, -3.122617530073510e-03,
  8.262965909873691e-06, -2.132398162992670e-09, -9.572838956013251e-11,  4.455300677936466e-13, -4.554806172609370e-16, -6.272322928494974e-18,  3.679725221931240e-20,
 -8.964464850215516e-23, -6.608043421067152e-25,  1.286038144746810e-27,  7.208281554419375e-01, -3.454546563350906e-03,  8.051781301025692e-06,  6.242552737912977e-09,
 -1.339494887126794e-10,  4.405153740450065e-13,  5.349746321746604e-16, -1.158369636397467e-17,  3.925605305213558e-20,  3.245945682254953e-23, -1.470787717412550e-24,
  1.703406452944746e-27,  8.142686417528742e-01, -3.773155384762116e-03,  7.383753648975112e-06,  1.705003821973462e-08, -1.690346275775209e-10,  3.218042805484731e-13,
  2.106581107162369e-15, -1.631851775858222e-17,  1.755188283613401e-20,  2.772041478100252e-22, -2.183803799375066e-24, -2.763962845839823e-27,  9.137829693235491e-01,
 -4.065468557083166e-03,  6.139942686590253e-06,  3.011760012582398e-08, -1.916031527071344e-10,  3.352650208169220e-14,  4.135955662133874e-15, -1.688992287690765e-17,
 -4.545776201891015e-20,  5.893004345200369e-22, -1.710830838069950e-24, -1.639893623240152e-26,  1.019275837287875e+00, -4.314354595402737e-03,  4.192784174821961e-06,
  4.473804507698490e-08, -1.872800521460724e-10, -4.708506938959833e-13,  6.062885811312953e-15, -7.387423413078960e-18, -1.551191627947191e-19,  7.032249706798102e-22,
  1.694740780117518e-24, -3.639465732668165e-26,  1.130504171711222e+00, -4.497189219970865e-03,  1.422022372107245e-06,  5.927881958436561e-08, -1.363296829729432e-10,
 -1.185038496815471e-12,  6.560182958072362e-15,  1.877456006307944e-17, -2.682824796852214e-19,  3.642315978361581e-23,  8.566342215362478e-24, -3.490711168246344e-26,
  1.246981139733524e+00, -4.584283591667457e-03, -2.248464563197219e-06,  7.061694342494343e-08, -1.646522446164987e-11, -1.960237228032630e-12,  3.334801778006549e-15,
  6.126455029680955e-17, -2.351105901267180e-19, -2.000122060640691e-21,  1.223639751532291e-23,  4.833504344476675e-26,  1.367818750787825e+00, -4.537443522124041e-03,
 -6.773451926346673e-06,  7.349450614549197e-08,  1.856611337375363e-10, -2.363010833028139e-12, -6.071305867904363e-15,  9.419467363659221e-17,  1.985894605198805e-19,
 -4.317218067282138e-21, -7.425378759849982e-24,  1.953255695960227e-25,  1.491469817311408e+00, -4.309876451492689e-03, -1.183842632903643e-05,  6.034687225921936e-08,
  4.444370381895534e-10, -1.579008723509260e-12, -2.041139859107315e-14,  4.528307384601373e-17,  1.019824433376944e-18, -1.215969665032461e-21, -5.566437015367968e-23,
 -8.788247266519861e-27,  1.615312453984264e+00, -3.850780089169269e-03, -1.661467360650154e-05,  2.340663092913792e-08,  6.406116113910169e-10,  1.187082351551715e-12,
 -2.639160805304907e-14, -1.510009742379872e-16,  9.328566740840301e-19,  1.177682984464147e-20, -1.715028914256807e-23, -8.025728255706130e-25,  1.735019434205319e+00,
 -3.122409601508429e-03, -1.948375471032033e-05, -3.695989513518728e-08,  5.285176778003913e-10,  4.891667591620085e-12,  1.046301073713420e-15, -2.829785992417818e-16,
 -1.844817525194109e-18,  6.909803987509930e-21,  1.696129061890507e-22,  5.904966282739171e-25,  1.843747223951851e+00, -2.143389250780484e-03, -1.817366229036024e-05,
 -9.528280184967961e-08, -6.316298389418686e-11,  4.440042443466755e-12,  4.517901133662716e-14,  1.395294724572477e-16, -1.815784833234839e-18, -2.837205407577401e-20,
 -1.470964828730598e-22,  7.330014573152086e-25,  1.931563848581669e+00, -1.065663961456070e-03, -1.146883102718386e-05, -9.720893838371492e-08, -6.298023882000363e-10,
 -2.357759739329257e-12,  9.682579657682876e-15,  2.883738568331829e-16,  3.132865669501915e-18,  2.025085162574333e-20,  2.710056191572202e-23, -1.308044720986400e-24,
  1.986396759769519e+00, -2.298314872232948e-04, -2.866887852602284e-06, -3.113475531594760e-08, -3.086512192532918e-10, -2.838259813486137e-12, -2.425029393970816e-14,
 -1.905521567437879e-16, -1.337960086949868e-18, -7.766522469671857e-21, -2.685553797530603e-23,  1.495958404099936e-25,  6.229933247390355e-04, -3.500004972511467e-06,
  1.473989981994316e-08, -5.520678886934551e-11,  1.934176288617033e-13, -6.537288392290691e-16,  2.114122069757761e-18, -7.024193393712964e-21,  1.943495561713867e-23,
 -9.122727609855326e-26, -8.776346637026855e-29, -4.185386642481488e-30,  5.608665658748475e-03, -3.148497503753851e-05,  1.323111509438800e-07, -4.935491926219414e-10,
  1.717822737854674e-12, -5.750818942140872e-15,  1.834334424654333e-17, -5.998743060643226e-20,  1.605259776873787e-22, -7.608782729527439e-25, -1.040269041174263e-27,
 -3.676855678321859e-29,  1.558922210089547e-02, -8.737362260449185e-05,  3.655847401511836e-07, -1.352487472434156e-09,  4.644178523051274e-12, -1.524019609143702e-14,
  4.719962257172101e-17, -1.490760831646693e-19,  3.687265598339677e-22, -1.796351245075852e-24, -4.185182365887424e-27, -9.763666216350486e-29,  3.058312316117908e-02,
 -1.709988802161633e-04,  7.107588508189605e-07, -2.596129431764564e-09,  8.727006973297997e-12, -2.772806739508734e-14,  8.169780686994356e-17, -2.425161082532924e-19,
  5.093609939680030e-22, -2.671188015371818e-24, -1.155431699196387e-26, -1.805027830946654e-28,  5.061814863544672e-02, -2.820986481027446e-04,  1.161967716664217e-06,
 -4.169636541422627e-09,  1.359691938848392e-11, -4.116660912454424e-14,  1.119334616667810e-16, -2.975226993411103e-19,  4.138122332415742e-22, -2.795027194899713e-24,
 -2.512736978436046e-26, -2.812513658020572e-28,  7.573149440537331e-02, -4.203011488560367e-04,  1.711077224161057e-06, -5.998019420712460e-09,  1.875996486884522e-11,
 -5.291516788225190e-14,  1.258432103809985e-16, -2.664828691067110e-19, -8.013136018467719e-23, -1.740338517969961e-24, -4.571017880202279e-26, -4.029634709493624e-28,
  1.059698828979434e-01, -5.851039032737797e-04,  2.347397305777032e-06, -7.984532796618191e-09,  2.359818254172330e-11, -5.983946858518951e-14,  1.103431835427525e-16,
 -1.057087431114684e-19, -1.074791115064186e-21,  4.829429031996869e-25, -7.174923244519409e-26, -5.601787244616520e-28,  1.413896671445851e-01, -7.758448621972606e-04,
  3.057297217784336e-06, -1.000868947551774e-08,  2.737293483292353e-11, -5.846671777925310e-14,  5.295893633379776e-17,  2.129141927845843e-19, -2.548020211967828e-21,
  3.143684979673447e-24, -9.843555017478536e-26, -7.800069044537842e-28,  1.820568973505436e-01, -9.916636081739828e-04,  3.823705136535709e-06, -1.192394774798336e-08,
  2.923352229446584e-11, -4.522271599215302e-14, -5.590767724200639e-17,  6.871954416147832e-19, -4.282934120720808e-21,  4.566672226648012e-24, -1.176421847367474e-25,
 -1.096954373498530e-27,  2.280473022621098e-01, -1.231449702968487e-03,  4.625468199880451e-06, -1.355519407076314e-08,  2.823499623128857e-11, -1.678811983149179e-14,
 -2.199044320117123e-16,  1.267064077528402e-18, -5.803677605572572e-21,  2.089047633431104e-24, -1.194707496074787e-25, -1.537994268299683e-27,  2.794461122352708e-01,
 -1.493774102746118e-03,  5.436543344337093e-06, -1.469626662104100e-08,  2.337126213422780e-11,  2.937460694597181e-14, -4.326783711873648e-16,  1.835377057033660e-18,
 -6.340061303101584e-21, -7.615972573283549e-24, -9.638625260594300e-26, -2.095438446628986e-27,  3.363476117267324e-01, -1.776797948763383e-03,  6.224983705316220e-06,
 -1.510798646668504e-08,  1.363290416760389e-11,  9.425434607401045e-14, -6.727480165078854e-16,  2.190359977905446e-18, -4.862210950632026e-21, -2.757405505040464e-23,
 -5.089793770244941e-26, -2.689527539646322e-27,  3.988542477972689e-01, -2.078150760139265e-03,  6.951681661938483e-06, -1.451755278670249e-08, -1.895765831821301e-12,
  1.761965840678290e-13, -8.974171541768347e-16,  2.036785439721558e-18, -2.543637773690436e-22, -5.855523204414006e-23, -7.018843268257928e-27, -3.133883871680410e-27,
  4.670750247379467e-01, -2.394766807988174e-03,  7.568831728046235e-06, -1.262084024847459e-08, -2.387834932955377e-11,  2.693803422501625e-13, -1.036393243588670e-15,
  9.999495735544729e-19,  8.265288918157981e-21, -9.581206141936574e-23, -2.329342448678741e-26, -3.140287568250742e-27,  5.411227607116819e-01, -2.722663814373446e-03,
  8.018092930045359e-06, -9.090324098417699e-09, -5.247364081468148e-11,  3.617805894220710e-13, -9.869743460512802e-16, -1.311716441913276e-18,  2.033413343654545e-20,
 -1.245681338483122e-22, -1.991388400874408e-25, -2.438877334475068e-27,  6.211095323172984e-01, -3.056641522968303e-03,  8.228479174934779e-06, -3.593418890426930e-09,
 -8.694065482499359e-11,  4.326209290812047e-13, -6.151415567970359e-16, -5.151473898422704e-18,  3.310219558843681e-20, -1.155855553403403e-22, -6.538538649954247e-25,
 -1.136578011116457e-27,  7.071392215746016e-01, -3.389868431093621e-03,  8.114125487698831e-06,  4.170433272197592e-09, -1.250363224126984e-10,  4.496052700147297e-13,
  2.283132719531926e-16, -1.032004317439182e-17,  3.937911934685247e-20, -2.539487242229762e-23, -1.437408487578789e-24, -4.268048973490287e-28,  7.992953918322597e-01,
 -3.713312424931255e-03,  7.572347650905411e-06,  1.439956574683665e-08, -1.621296079746294e-10,  3.669512850368639e-13,  1.658904503870664e-15, -1.561428628239489e-17,
  2.592919830513185e-20,  1.873507659079755e-22, -2.313997755784278e-24, -3.475924094105746e-27,  8.976215496505402e-01, -4.014955401651281e-03,  6.482999137286623e-06,
  2.706254370579345e-08, -1.899790678135883e-10,  1.269691445588367e-13,  3.645759857081659e-15, -1.801972173820399e-17, -2.564399319618910e-20,  5.069223901463190e-22,
 -2.399187343489710e-24, -1.519324540909334e-26,  1.002088830749592e+00, -4.278716500732028e-03,  4.711376463118783e-06,  4.167405401856974e-08, -1.952615262548580e-10,
 -3.283607374665329e-13,  5.790425518126464e-15, -1.193623653015403e-17, -1.289700702782304e-19,  7.388481201284184e-22,  8.313943341863551e-26, -3.686694566290184e-26,
  1.112542617725173e+00, -4.483006484191774e-03,  2.119526588787356e-06,  5.691665429441967e-08, -1.584184284616663e-10, -1.022252466372666e-12,  6.966330012674371e-15,
  1.027336698615180e-17, -2.612131772161099e-19,  3.440528370664941e-22,  6.713237193723767e-24, -4.890823519446370e-26,  1.228613386609624e+00, -4.598889121907208e-03,
 -1.403920019011912e-06,  7.004477758360028e-08, -5.473533207327976e-11, -1.860530319653936e-12,  4.934749477203600e-15,  5.268693589307536e-17, -2.978884182312006e-19,
 -1.478748810640569e-21,  1.356303893149357e-23,  1.141923063739656e-26,  1.349566253550066e+00, -4.588056540125979e-03, -5.875277138863278e-06,  7.607999336592974e-08,
  1.371605329048399e-10, -2.476499905034653e-12, -3.368563034349948e-15,  9.802229587917081e-17,  3.989078596620676e-20, -4.443159907054684e-21,  1.057665603856844e-24,
  1.856371658582789e-25,  1.474045650331051e+00, -4.401568895993321e-03, -1.107272493358342e-05,  6.717910378260067e-08,  4.080796610249511e-10, -2.050035276793664e-12,
 -1.869622804447811e-14,  7.678903481131333e-17,  9.362524199258319e-19, -3.409213113357534e-21, -5.299191953265423e-23,  1.289012899429856e-25,  1.599645525837566e+00,
 -3.982398139476084e-03, -1.627162709537409e-05,  3.381056334613158e-08,  6.576958750560873e-10,  5.067059176442928e-13, -3.013932947983500e-14, -1.145687817794534e-16,
  1.335790868259415e-18,  1.036725225885046e-20, -5.353812995355635e-23, -8.309503936435071e-25,  1.722215459519873e+00, -3.279902527000596e-03, -1.987331047707126e-05,
 -2.772239165963486e-08,  6.259270199616795e-10,  4.815304921661692e-12, -7.656591665492932e-15, -3.366805953926059e-16, -1.468937278404480e-18,  1.407247857759340e-20,
  1.845678630226614e-22,  4.822137592078314e-26,  1.834875631991972e+00, -2.293362166230916e-03, -1.931999497693423e-05, -9.552289164800289e-08,  3.675920035477446e-11,
  5.563672250490590e-12,  4.811116912688273e-14,  6.402687685043663e-17, -2.932653362568893e-18, -3.331397042931886e-20, -9.208723832626708e-23,  1.817726436783790e-24,
  1.927110057111996e+00, -1.162255432241916e-03, -1.269730652852503e-05, -1.076474342625858e-07, -6.739183091844881e-10, -2.016477799952782e-12,  1.927091554722844e-14,
  4.003675589504150e-16,  3.864586832275237e-18,  1.985261959476240e-20, -5.611135833310101e-23, -2.558699261531300e-24,  1.985429072893425e+00, -2.543495404058147e-04,
 -3.272116291700129e-06, -3.656082325459049e-08, -3.716947841908018e-10, -3.489395817066526e-12, -3.022857529880673e-14, -2.380304778916625e-16, -1.634624202704307e-18,
 -8.631622807070953e-21, -1.411821295809346e-23,  4.648365272318902e-25,  6.092250205146147e-04, -3.384684066306586e-06,  1.409556373514438e-08, -5.221401225179204e-11,
  1.808348607076468e-13, -6.052828300897847e-16,  1.925650707812162e-18, -6.455894029807780e-21,  1.603787029884896e-23, -9.901913611266280e-26, -3.182269531845704e-28,
 -6.435153639096604e-30,  5.484805875586426e-03, -3.044971753208258e-05,  1.265497520210673e-07, -4.669608010908847e-10,  1.607075601330673e-12, -5.330179676018478e-15,
  1.673141683801467e-17, -5.530037519618628e-20,  1.319469353093235e-22, -8.402892426026366e-25, -3.079321330166091e-27, -5.721771989654846e-29,  1.524547593059045e-02,
 -8.451262363757502e-05,  3.497908686402542e-07, -1.280558895126911e-09,  4.350371038355064e-12, -1.415622253166524e-14,  4.318067652285760e-17, -1.383531364256309e-19,
  2.998716582827529e-22, -2.065103145044447e-24, -9.673807129189908e-27, -1.554548892245874e-28,  2.991030577255241e-02, -1.654350913422900e-04,  6.804251286431661e-07,
 -2.460829553823712e-09,  8.191512201447431e-12, -2.584705605395492e-14,  7.512035843595638e-17, -2.278616880516221e-19,  4.026886485859751e-22, -3.323175397815555e-24,
 -2.188924631191989e-26, -2.963346340358670e-28,  4.950803377402192e-02, -2.729994122002482e-04,  1.113210677596260e-06, -3.958529334191812e-09,  1.279978376675006e-11,
 -3.857877789018673e-14,  1.037715492792845e-16, -2.861118692326750e-19,  2.916491713175377e-22, -4.100039507753735e-24, -4.154931407506110e-26, -4.769257497743550e-28,
  7.407721829517190e-02, -4.068954126620288e-04,  1.640867548344652e-06, -5.706164853128308e-09,  1.773125770643241e-11, -4.998483028184724e-14,  1.183336332242613e-16,
 -2.704416907171107e-19, -1.806797771231583e-22, -4.003073953098838e-24, -6.959397673894792e-26, -7.003585446581139e-28,  1.036664277602031e-01, -5.667016537225947e-04,
  2.253809306863980e-06, -7.616393379680685e-09,  2.242761569280300e-11, -5.723064181334945e-14,  1.069001859876371e-16, -1.404325075326042e-19, -1.116007778378281e-21,
 -2.992328859084465e-24, -1.050712266398605e-25, -9.796235116410259e-28,  1.383344541854968e-01, -7.518595445228853e-04,  2.939782386628537e-06, -9.580006272345295e-09,
  2.621674623303792e-11, -5.713330219638190e-14,  5.779018547970122e-17,  1.323526075174967e-19, -2.515325556833602e-21, -1.629550468353607e-24, -1.443013409976991e-25,
 -1.339164489885383e-27,  1.781505271144913e-01, -9.616384342363606e-04,  3.683394115761745e-06, -1.146351366436496e-08,  2.831712917012238e-11, -4.634897276919985e-14,
 -3.856731992078330e-17,  5.517583448852699e-19, -4.216565399002100e-21, -1.294657309288097e-24, -1.806336598315898e-25, -1.811738838007025e-27,  2.231944915530041e-01,
 -1.195088954088483e-03,  4.465504453685294e-06, -1.310639530019034e-08,  2.784922217669032e-11, -2.166104577759885e-14, -1.870227881233621e-16,  1.081481377161898e-18,
 -5.832902831671689e-21, -4.279259881210001e-24, -2.054271670337913e-25, -2.427476257313023e-27,  2.735568926304501e-01, -1.450980778737120e-03,  5.262449392397877e-06,
 -1.431817364559045e-08,  2.385895442896561e-11,  1.958380235593890e-14, -3.841758099730190e-16,  1.627167070550049e-18, -6.708444460483408e-21, -1.360616671087633e-23,
 -2.111174088906270e-25, -3.192340166404549e-27,  3.293388768808585e-01, -1.727719416652036e-03,  6.045056048885054e-06, -1.487563604406647e-08,  1.536140447357790e-11,
  7.882583549129234e-14, -6.137496827075603e-16,  2.018241171129376e-18, -5.923282278248805e-21, -3.234010416866081e-23, -1.973605311937518e-25, -4.055747662862815e-27,
  3.906517679449549e-01, -2.023234404713823e-03,  6.777401586920068e-06, -1.452084446990004e-08,  1.417392112939769e-12,  1.553400556070283e-13, -8.408200980440332e-16,
  1.994567028665141e-18, -2.404806143188754e-21, -6.206058998484245e-23, -1.809349483190281e-25, -4.874859291616257e-27,  4.576160909893356e-01, -2.334828048679649e-03,
  7.415262764045514e-06, -1.296113442348685e-08, -1.873706808696316e-11,  2.448695738832140e-13, -1.005213362042812e-15,  1.208765372091464e-18,  4.760505299564389e-21,
 -1.001193826267022e-22, -2.085450651609077e-25, -5.401043305255802e-27,  5.303596846409652e-01, -2.658969137832070e-03,  7.904206146502650e-06, -9.873315690027859e-09,
 -4.547751564079903e-11,  3.377217919810715e-13, -1.015279279062481e-15, -7.345688550187565e-19,  1.567333845794887e-20, -1.354722810925576e-22, -3.672709790665920e-25,
 -5.348756414375105e-27,  6.090143162672979e-01, -2.991009169396255e-03,  8.177294647914560e-06, -4.916099103136095e-09, -7.844695212955523e-11,  4.162423052878747e-13,
 -7.452154165862514e-16, -4.163981974572230e-18,  2.844975146862412e-20, -1.436938245113931e-22, -7.772327170338487e-25, -4.659633810057460e-27,  6.937098436998743e-01,
 -3.324788571417792e-03,  8.152464641577679e-06,  2.241990977613212e-09, -1.160120968034500e-10,  4.517584055396286e-13, -4.322312722943991e-17, -9.085728075141967e-18,
  3.741682883901454e-20, -8.423575350461686e-23, -1.531496027586575e-24, -4.112127127665413e-27,  7.845643325563594e-01, -3.652085992732226e-03,  7.729826790625946e-06,
  1.186622054864402e-08, -1.544273497354998e-10,  4.016179382079754e-13,  1.234205437832399e-15, -1.469483819698872e-17,  3.096506353197616e-20,  9.106117549553081e-23,
 -2.521027375445017e-24, -6.294672619290544e-27,  8.816674401237994e-01, -3.961843857739307e-03,  6.789610398283708e-06,  2.404777474790344e-08, -1.866059814814687e-10,
  2.083361936059549e-13,  3.132322966566256e-15, -1.856817490327096e-17, -9.284022092927283e-21,  3.974727470586809e-22, -3.080417542801143e-24, -1.617340053142794e-26,
  9.850524384207862e-01, -4.239078696218302e-03,  5.192527415494865e-06,  3.850476088647482e-08, -2.004684163343324e-10, -1.938429350889818e-13,  5.402417084297558e-15,
 -1.564024678891036e-17, -1.027047463763085e-19,  7.094815306218137e-22, -1.559647996725541e-24, -3.800055208845284e-26,  1.094648767073138e+00, -4.463362856275781e-03,
  2.786673237015955e-06,  5.422756411162419e-08, -1.771730851759821e-10, -8.525400524190885e-13,  7.139166836086632e-15,  2.160117757155677e-18, -2.445455081557308e-19,
  5.659312308943790e-22,  4.294797643940968e-24, -6.070615927438362e-26,  1.210200666113521e+00, -4.606776004535094e-03, -5.698430629764601e-07,  6.887824393971802e-08,
 -9.064786661876989e-11, -1.725516120049140e-12,  6.269275547474878e-15,  4.240775734338530e-17, -3.413403117052144e-19, -9.375466481309324e-22,  1.321475248534671e-23,
 -2.729069091860688e-26,  1.331125852711280e+00, -4.631373398071788e-03, -4.950795974176850e-06,  7.787486318195332e-08,  8.704451485526635e-11, -2.524412800018710e-12,
 -6.299657143617853e-16,  9.676318352621556e-17, -1.174110968752353e-19, -4.246443648787147e-21,  8.510315216299708e-24,  1.489470021221439e-25,  1.456267469159534e+00,
 -4.486818371389434e-03, -1.022882989627750e-05,  7.335678318032378e-08,  3.627829814827287e-10, -2.469685859348065e-12, -1.614798602026474e-14,  1.043896390892123e-16,
  7.770714213696395e-19, -5.378756884290233e-21, -4.463311796985506e-23,  2.455397885769664e-25,  1.583458410091793e+00, -4.110768846115017e-03, -1.580255717548555e-05,
  4.437446907206959e-08,  6.603630795248908e-10, -2.499745545938544e-13, -3.269606957461679e-14, -6.633572538622700e-17,  1.661822694575763e-18,  7.515033011800320e-21,
 -8.832121003298135e-23, -7.278083024194950e-25,  1.708776019446769e+00, -3.440042195349193e-03, -2.014275339695702e-05, -1.695038901642342e-08,  7.196066649234251e-10,
  4.513629290733591e-12, -1.765544965449229e-14, -3.741641773763524e-16, -8.308234706606547e-19,  2.128666207402536e-20,  1.705802824469443e-22, -7.135081652285188e-25,
  1.825385829448936e+00, -2.452488359762062e-03, -2.045886437343498e-05, -9.398141557642165e-08,  1.596649521212707e-10,  6.728119575307222e-12,  4.840574445398675e-14,
 -4.953908824154129e-17, -4.175582898037322e-18, -3.502205935082847e-20,  1.624071148029021e-23,  3.125509527934233e-24,  1.922249434677896e+00, -1.269187148904990e-03,
 -1.405501033471010e-05, -1.187235632113867e-07, -7.086398635820976e-10, -1.404839059767322e-12,  3.231548245896012e-14,  5.347877317225064e-16,  4.507394630156316e-18,
  1.487070064783467e-20, -2.059706482671989e-22, -4.340580534465791e-24,  1.984356392188175e+00, -2.823880629101205e-04, -3.748966012508227e-06, -4.310803729328826e-08,
 -4.493091885425017e-10, -4.301060539472435e-12, -3.767295835243873e-14, -2.953706503231919e-16, -1.949261431220846e-18, -8.635505902169692e-21,  1.833055526311060e-23,
  1.073261673935421e-24,  };
  constexpr double w[11136] = {  1.063836572841200e-01, -4.869046261213738e-04,  2.374441811859850e-06, -1.208990816926404e-08,  6.309853881180461e-11,
 -3.331376066277471e-13,  1.764520028949794e-15, -9.332609155931073e-18,  4.916794111234479e-20, -2.577403355132908e-22,  1.343759203775844e-24, -6.967626343720804e-27,
  1.055019539276795e-01, -7.688600818952996e-04,  6.452888055595905e-06, -5.295115118439368e-08,  4.159485949137252e-10, -3.144633877568304e-12,  2.303905129271289e-14,
 -1.644395455809554e-16,  1.147759622978411e-18, -7.856584862752756e-21,  5.285794064936245e-23, -3.501265585708918e-25,  1.037692355028620e-01, -1.315874340708110e-03,
  1.655597470542226e-05, -1.864247193720889e-07,  1.935915493820593e-09, -1.892175829951274e-11,  1.762404480248681e-13, -1.577283229007599e-15,  1.364434068503385e-17,
 -1.145971924042839e-19,  9.377377299146811e-22, -7.496352829780230e-24,  1.012445781666354e-01, -2.095642517311595e-03,  3.621861990204722e-05, -5.331697274525112e-07,
  7.049093567445389e-09, -8.602246397545323e-11,  9.851909318098873e-13, -1.070816441414755e-14,  1.113441580330757e-16, -1.114216744421371e-18,  1.078010275672416e-20,
 -1.011994813093947e-22,  9.801111920066551e-02, -3.063234674500728e-03,  6.991405087772787e-05, -1.309050918745616e-06,  2.148291101052915e-08, -3.196681633469478e-10,
  4.403066285619993e-12, -5.691975291941206e-14,  6.974114769323799e-16, -8.158416522931473e-18,  9.163369401418990e-20, -9.924809856702692e-22,  9.417020610064648e-02,
 -4.164820814776902e-03,  1.222256520987390e-04, -2.847204707304306e-06,  5.686616772615197e-08, -1.013446608487098e-09,  1.651165963567134e-11, -2.499406313345138e-13,
  3.555597875944069e-15, -4.794134808225639e-17,  6.166918346543121e-19, -7.606248172824894e-21,  8.983466979237635e-02, -5.341886327122625e-03,  1.969828713648628e-04,
 -5.601569669487925e-06,  1.339438665722322e-07, -2.817224607321040e-09,  5.356376167381828e-11, -9.374949884527072e-13,  1.530079724437022e-14, -2.351053643905280e-16,
  3.426174379925410e-18, -4.762178036671945e-20,  8.512191604627288e-02, -6.535462025996168e-03,  2.965012896824953e-04, -1.012137179881529e-05,  2.856409005624365e-07,
 -7.000779983003930e-09,  1.535361644860854e-10, -3.073785044409966e-12,  5.697465798497068e-14, -9.881037065454800e-16,  1.616402914692056e-17, -2.509633259112512e-19,
  8.014747633096840e-02, -7.689939889699382e-03,  4.210395435451562e-04, -1.699337683801208e-05,  5.587873645664222e-07, -1.577828794520007e-08,  3.950475133611409e-10,
 -8.960337250866071e-12,  1.869417102623130e-13, -3.628462513657066e-15,  6.609520154646982e-17, -1.137477052520286e-18,  7.501952750668946e-02, -8.756148194508435e-03,
  5.685406901831287e-04, -2.675734376263074e-05,  1.013180346021889e-06, -3.261916753443801e-08,  9.236244817258970e-10, -2.352925497210971e-11,  5.480726355941675e-13,
 -1.181479410473748e-14,  2.379123179578978e-16, -4.506967012677411e-18,  6.983471014732642e-02, -9.693493673383746e-03,  7.346737995065370e-04, -3.980755143053416e-05,
  1.716956070424551e-06, -6.242151591233068e-08,  1.981521024362966e-09, -5.624141846484455e-11,  1.451700560473808e-12, -3.451207245885289e-14,  7.631311175398269e-16,
 -1.581205100376100e-17,  6.467538275168709e-02, -1.047111722758104e-02,  9.131439296895325e-04, -5.629756416712716e-05,  2.737978332361161e-06, -1.113988240627682e-07,
  3.932190082122166e-09, -1.234136599313965e-10,  3.505285255972311e-12, -9.129644351902924e-14,  2.202937827563541e-15, -4.962759382099458e-17,  5.960827461130203e-02,
 -1.106813089365013e-02,  1.096203476870441e-03, -7.606563491896244e-05,  4.131943854547173e-06, -1.865504385099039e-07,  7.265825503350377e-09, -2.503734827534955e-10,
  7.773199111998818e-12, -2.204200662804050e-13,  5.769649591569622e-15, -1.405252168328211e-16,  5.468436543465381e-02, -1.147309208476223e-02,  1.275279431886427e-03,
 -9.859457131992339e-05,  5.928884889824750e-06, -2.946602022051689e-07,  1.257067203040452e-08, -4.723759384811941e-10,  1.592928752005215e-11, -4.888514193423837e-13,
  1.380294315509628e-14, -3.615131628119314e-16,  4.993973543135700e-02, -1.168292040101729e-02,  1.441629398377624e-03, -1.230136953655032e-04,  8.120427459082762e-06,
 -4.408853203923075e-07,  2.045836415912353e-08, -8.329206496022502e-10,  3.032267219421696e-11, -1.001354802400001e-12,  3.033340449040175e-14, -8.499142631435214e-16,
  4.539709524979597e-02, -1.170147442553160e-02,  1.586951112210126e-03, -1.481433588852876e-04,  1.065034049595216e-05, -6.271297467365189e-07,  3.144126568295866e-08,
 -1.378236016675613e-09,  5.385140358058654e-11, -1.903069609783902e-12,  6.152437296849110e-14, -1.834977776516147e-15,  4.106771285317532e-02, -1.153798846753805e-02,
  1.703890608811273e-03, -1.725759392463329e-04,  1.341053201842038e-05, -8.505045624954503e-07,  4.577418847831363e-08, -2.147430896404679e-09,  8.954475273347775e-11,
 -3.368263375989447e-12,  1.156234080249866e-13, -3.652994921444263e-15,  3.695349171465861e-02, -1.120553251519380e-02,  1.786417746306239e-03, -1.947825079198221e-04,
  1.624380766235298e-05, -1.102226456617105e-06,  6.328822922655434e-08, -3.159121786283428e-09,  1.398125370562637e-10, -5.568721799869360e-12,  2.019702884502204e-13,
 -6.727488119862534e-15,  3.304900830647606e-02, -1.071961315889821e-02,  1.830059985721398e-03, -2.132319990258115e-04,  1.895360600201110e-05, -1.367274181240319e-06,
  8.325577918767007e-08, -4.396924106924170e-09,  2.054298741552143e-10, -8.620010546594547e-12,  3.287202250176050e-13, -1.149056356610560e-14,  2.934337507474360e-02,
 -1.009698761459610e-02,  1.832003121085189e-03, -2.265096665336234e-04,  2.131980585462994e-05, -1.625013046851013e-06,  1.043284719733957e-07, -5.797527948428871e-09,
  2.844630013880295e-10, -1.251253332228146e-11,  4.993302319529550e-13, -1.823384005490538e-14,  2.582184930081435e-02, -9.354723193422274e-03,  1.791079628198333e-03,
 -2.334234261028049e-04,  2.311877926703835e-05, -1.850831249325489e-06,  1.245814910443193e-07, -7.245587558236505e-09,  3.714573796623322e-10, -1.704462249936022e-11,
  7.084817408900416e-13, -2.690627955384105e-14,  2.246715324787937e-02, -8.509503802451728e-03,  1.707671421492807e-03, -2.330896249612748e-04,  2.414528438167341e-05,
 -2.018645025978588e-06,  1.416789497577289e-07, -8.578937423811322e-09,  4.572462336066691e-10, -2.178256423953109e-11,  9.387633127808846e-13, -3.691509960687473e-14,
  1.926050464456116e-02, -7.577164140995087e-03,  1.583554968330172e-03, -2.249931463805225e-04,  2.423360960548268e-05, -2.103961916955810e-06,  1.531497838536200e-07,
 -9.605664203492758e-09,  5.296551097659919e-10, -2.607276014217387e-11,  1.159779019812765e-12, -4.701747443816460e-14,  1.618237907265804e-02, -6.572420369352625e-03,
  1.421714271114218e-03, -2.090199391591748e-04,  2.327556776411282e-05, -2.087076207992303e-06,  1.567376573349350e-07, -1.013170278595274e-08,  5.751736640468945e-10,
 -2.912129904175522e-11,  1.331065904372191e-12, -5.539291410942549e-14,  1.321303905641919e-02, -5.508761542569769e-03,  1.226142646495326e-03, -1.854626782718580e-04,
  2.123341319329606e-05, -1.955928486177495e-06,  1.507681442515333e-07, -9.994624291453617e-09,  5.813855217677404e-10, -3.013706393422823e-11,  1.409192069358025e-12,
 -5.994430710740244e-14,  1.033287228584672e-02, -4.398467596278834e-03,  1.001648900296506e-03, -1.550021532765032e-04,  1.814640905842301e-05, -1.708197359252748e-06,
  1.344670633454092e-07, -9.097016856772892e-09,  5.396749150257382e-10, -2.851156355548663e-11,  1.357899035274990e-12, -5.879436599447247e-14,  7.522595579855237e-03,
 -3.252729499675311e-03,  7.536793656633822e-04, -1.186683060315239e-04,  1.413051743468973e-05, -1.352298339921625e-06,  1.081680912978621e-07, -7.432071928776557e-09,
  4.475609092224258e-10, -2.399032936050012e-11,  1.158697709554308e-12, -5.085201345803864e-14,  4.763505443935408e-03, -2.081908403436956e-03,  4.881755023017308e-04,
 -7.778741489766407e-05,  9.371637338099701e-06, -9.071430183645476e-07,  7.336686691749933e-08, -5.095155784129738e-09,  3.100251595772124e-10, -1.678540240849865e-11,
  8.186039636690430e-13, -3.626352664732591e-14,  2.040601154379981e-03, -8.971428307681867e-04,  2.117585012046312e-04, -3.396623987836818e-05,  4.118810349556263e-06,
 -4.012134266148851e-07,  3.264838004615749e-08, -2.280857133742656e-09,  1.395834887301542e-10, -7.599490524365949e-12,  3.726175848177296e-13, -1.659255419015110e-14,
  1.044731345961427e-01, -4.684727362646871e-04,  2.235207720774617e-06, -1.113141838525756e-08,  5.683898890201203e-11, -2.937553082274793e-13,  1.523909950301190e-15,
 -7.897890279867221e-18,  4.078729254777426e-20, -2.096461794634216e-22,  1.071971809606461e-24, -5.452339392917588e-27,  1.025258891806561e-01, -7.196700868262319e-04,
  5.855423060409261e-06, -4.677056616847865e-08,  3.582327319397254e-10, -2.643045499289761e-12,  1.890916430014957e-14, -1.318568740153315e-16,  8.995426359653442e-19,
 -6.020628249116656e-21,  3.961865260648216e-23, -2.567590745870480e-25,  9.875717272303233e-02, -1.191875699649577e-03,  1.449294304641837e-05, -1.582619097428788e-07,
  1.596440460037549e-09, -1.517618502049823e-11,  1.376170883403695e-13, -1.200031766520037e-15,  1.012149336351145e-17, -8.293261351753253e-20,  6.623851884986366e-22,
 -5.170733299398393e-24,  9.340352950949028e-02, -1.829691237425720e-03,  3.044442069197196e-05, -4.329582808166354e-07,  5.542737697002951e-09, -6.560749438343635e-11,
  7.297608483446651e-13, -7.711704389661880e-15,  7.802941509325820e-17, -7.603990007815229e-19,  7.169018289973026e-21, -6.561959862992964e-23,  8.678497018503206e-02,
 -2.561364469958138e-03,  5.607403838391706e-05, -1.011229398445423e-06,  1.602915700830303e-08, -2.308458231554223e-10,  3.082188970142805e-12, -3.867178864241203e-14,
  4.603662567261738e-16, -5.237138377027245e-18,  5.724775787149122e-20, -6.038733103364960e-22,  7.927011422804596e-02, -3.309625318287782e-03,  9.291323215491034e-05,
 -2.080133270325234e-06,  4.005341981679509e-08, -6.897292029122315e-10,  1.087726626884498e-11, -1.596003426002995e-13,  2.203407751144962e-15, -2.886173516220329e-17,
  3.609938540814836e-19, -4.332821177110287e-21,  7.123944189814559e-02, -4.002334946450608e-03,  1.409673404647559e-04, -3.847397753848921e-06,  8.858433698942106e-08,
 -1.798332270270999e-09,  3.306349813926767e-11, -5.604585233988513e-13,  8.870515208795062e-15, -1.323256641705921e-16,  1.873981405279074e-18, -2.533498049574588e-20,
  6.305199861057886e-02, -4.581055221832036e-03,  1.984225062832731e-04, -6.496967933803139e-06,  1.764425811350660e-07, -4.171572482834807e-09,  8.842565358446291e-11,
 -1.713774489050702e-12,  3.079416219083656e-14, -5.183359152172004e-16,  8.238260613458958e-18, -1.243898359531819e-19,  5.501956014283346e-02, -5.006330599854641e-03,
  2.618107742937397e-04, -1.013668792155204e-05,  3.207517473334373e-07, -8.736457082006211e-09,  2.114102888442553e-10, -4.642079932132303e-12,  9.388905859325681e-14,
 -1.768821804725542e-15,  3.130804629313960e-17, -5.240618954017562e-19,  4.739037499715141e-02, -5.259329286468558e-03,  3.265545934996897e-04, -1.475391874819572e-05,
  5.378886805989789e-07, -1.671200173408606e-08,  4.575436806249868e-10, -1.128837971795183e-11,  2.550103732918190e-13, -5.338003969143634e-15,  1.044915644339841e-16,
 -1.926186686794076e-18,  4.034266972150690e-02, -5.340266992269927e-03,  3.877187393152769e-04, -2.019364242984898e-05,  8.394641062506658e-07, -2.947959945050938e-08,
  9.055822757932931e-10, -2.491220365634454e-11,  6.241052936369958e-13, -1.441806987618301e-14,  3.101459639756541e-16, -6.257841240700741e-18,  3.398655739071586e-02,
 -5.264557233566689e-03,  4.407699033016454e-04, -2.616666904819788e-05,  1.228360866084339e-06, -4.833842226798567e-08,  1.653152058705466e-09, -5.034548762793113e-11,
  1.389362382593379e-12, -3.520101518800490e-14,  8.271357287869358e-16, -1.816360280299550e-17,  2.837206137148034e-02, -5.057829406023406e-03,  4.821773199715402e-04,
 -3.228617365212215e-05,  1.696000522610638e-06, -7.418394909556416e-08,  2.803720936771311e-09, -9.388268655801843e-11,  2.835887088008048e-12, -7.832896791966775e-14,
  1.999161340379369e-15, -4.752218503446141e-17,  2.350068330920824e-02, -4.750865486841198e-03,  5.097584108229386e-04, -3.812276304290317e-05,  2.221717306438937e-06,
 -1.071855162445932e-07,  4.445324666623914e-09, -1.626021458970724e-10,  5.343613045600139e-12, -1.599834832994166e-13,  4.411124235352929e-15, -1.129216407365230e-16,
  1.933817785581510e-02, -4.375228948694018e-03,  5.227521059756843e-04, -4.326427085587329e-05,  2.774510870796611e-06, -1.465528854525512e-07,  6.624706925818714e-09,
 -2.630493054299326e-10,  9.349805361692230e-12, -3.017508038367319e-13,  8.941212486683034e-15, -2.452651808595748e-16,  1.582674288048525e-02, -3.960013352868782e-03,
  5.216653592519405e-04, -4.736714948972069e-05,  3.316773937249082e-06, -1.904643585867216e-07,  9.323083713833096e-09, -3.994315961635794e-10,  1.526838078929707e-11,
 -5.283386148988614e-13,  1.673871561674241e-14, -4.896258363006833e-16,  1.289548777980952e-02, -3.529820454317469e-03,  5.079731931747300e-04, -5.019051332022054e-05,
  3.809095859087453e-06, -2.361861775708503e-07,  1.244039674111903e-08, -5.717013662001883e-10,  2.337206223927228e-11, -8.626071809248678e-13,  2.907515735541399e-14,
 -9.026174046678970e-16,  1.046864769211961e-02, -3.103845994531191e-03,  4.837590242470417e-04, -5.160952588363604e-05,  4.215070761246140e-06, -2.803614688755251e-07,
  1.579325713360366e-08, -7.740386646281081e-10,  3.365988793981408e-11, -1.318236758377033e-12,  4.704117646356263e-14, -1.542663860126894e-15,  8.471478837893542e-03,
 -2.695822627764913e-03,  4.513676206688847e-04, -5.160993683804633e-05,  4.505188916895020e-06, -3.194054039984264e-07,  1.912836742916688e-08, -9.942215670031282e-10,
  4.574509513246039e-11, -1.891448761039816e-12,  7.111521525068773e-14, -2.452260273016347e-15,  6.834072244099708e-03, -2.314531006580392e-03,  4.131183216973223e-04,
 -5.026892228433990e-05,  4.659251975425252e-06, -3.499239824776665e-07,  2.214929787625172e-08, -1.214184157669092e-09,  5.880081382748728e-11, -2.554094666632266e-12,
  1.006977933685744e-13, -3.634589078825039e-15,  5.493474919940677e-03, -1.964614508675164e-03,  3.711004080149292e-04, -4.772862940548142e-05,  4.667174517889977e-06,
 -3.690793443424810e-07,  2.455141412611638e-08, -1.411773944929391e-09,  7.159097564541356e-11, -3.250678487966410e-12,  1.337589829680377e-13, -5.030673280774591e-15,
  4.394545917706449e-03, -1.647490777274010e-03,  3.270517757998350e-04, -4.416833794825022e-05,  4.528386964249613e-06, -3.748484486732356e-07,  2.605836764204303e-08,
 -1.563429654332852e-09,  8.259398063196938e-11, -3.901254088979308e-12,  1.667573616451105e-13, -6.505856904379878e-15,  3.489941090945346e-03, -1.362220117872712e-03,
  2.823087907369182e-04, -3.977962862227811e-05,  4.250267308089882e-06, -3.661536046418098e-07,  2.645400838786294e-08, -1.647297148673704e-09,  9.020336551032026e-11,
 -4.410749615103999e-12,  1.949406265180509e-13, -7.854086841181201e-15,  2.739550521462024e-03, -1.106251334265638e-03,  2.378091332114119e-04, -3.474710147208997e-05,
  3.846092153002678e-06, -3.428724462278709e-07,  2.560538262823416e-08, -1.646234035696898e-09,  9.297031489330710e-11, -4.683537499277903e-12,  2.130390348178426e-13,
 -8.824506366969776e-15,  2.109632326879964e-03, -8.760123810601488e-04,  1.941288667573448e-04, -2.923553433267791e-05,  3.332944462329450e-06, -3.057548569334932e-07,
  2.347485281388159e-08, -1.550218966362942e-09,  8.984273005924325e-11, -4.640541906131567e-12,  2.162428170030988e-13, -9.168103577302949e-15,  1.571811714487375e-03,
 -6.673448553155180e-04,  1.515377474591199e-04, -2.338318334208782e-05,  2.729897347605237e-06, -2.562829533388142e-07,  2.012157405815322e-08, -1.357837231148690e-09,
  8.035652757158187e-11, -4.235323314325542e-12,  2.012540922128748e-13, -8.694828942934788e-15,  1.102053599768030e-03, -4.758004298832193e-04,  1.100612106029081e-04,
 -1.730028074240411e-05,  2.056660141901125e-06, -1.965092207758064e-07,  1.569411400694920e-08, -1.076703676633588e-09,  6.474529180890362e-11, -3.465632743471945e-12,
  1.671577902315032e-13, -7.326482878738603e-15,  6.796870932438282e-04, -2.968335221035715e-04,  6.954368556833872e-05, -1.107183555540504e-05,  1.332786436312100e-06,
 -1.289034035875133e-07,  1.041697637766339e-08, -7.228729947268038e-10,  4.395152650690774e-11, -2.377884340682641e-12,  1.158841259545360e-13, -5.130043503572727e-15,
  2.868969427921454e-04, -1.260898486051162e-04,  2.975026838311250e-05, -4.770090257858051e-06,  5.782043842125055e-07, -5.630125938867106e-08,  4.579735825064107e-09,
 -3.198278338917321e-10,  1.956567764470826e-11, -1.064856932599654e-12,  5.219384459174878e-14, -2.323389003314059e-15,  1.026341822401257e-01, -4.511103563363152e-04,
  2.106899602336799e-06, -1.026708085451768e-08,  5.131244239181442e-11, -2.596943627054457e-13,  1.319963518105507e-15, -6.705624436765362e-18,  3.395740028715868e-20,
 -1.712000329241448e-22,  8.588185674302353e-25, -4.286282467036928e-27,  9.973747349846752e-02, -6.749781134496750e-04,  5.326898776560143e-06, -4.143827140547817e-08,
  3.096269689342152e-10, -2.230466577343079e-12,  1.558964240440917e-14, -1.062543208713614e-16,  7.088004756770153e-19, -4.640442870201428e-21,  2.987939618948762e-23,
 -1.895298953917243e-25,  9.421011313063689e-02, -1.083116451211491e-03,  1.273759372237730e-05, -1.349783987586722e-07,  1.323401264857759e-09, -1.224257253392787e-11,
  1.081358318271129e-13, -9.192132695016375e-16,  7.562712180551984e-18, -6.047973643178410e-20,  4.716914196859893e-22, -3.597085941323360e-24,  8.654097476225243e-02,
 -1.605504130511024e-03,  2.574061665805950e-05, -3.538887133178446e-07,  4.389597927143076e-09, -5.042565878223543e-11,  5.450391696114726e-13, -5.602597390616832e-15,
  5.518969614560217e-17, -5.239828228780329e-19,  4.815995984819611e-21, -4.299880236992547e-23,  7.736556686705481e-02, -2.157277730100564e-03,  4.533780719065504e-05,
 -7.880193349274801e-07,  1.207217601527590e-08, -1.683619287738814e-10,  2.180153231918358e-12, -2.656189591961536e-14,  3.073609466453451e-16, -3.401725327335345e-18,
  3.620388464066427e-20, -3.720747970337334e-22,  6.737424036748696e-02, -2.656234565101152e-03,  7.138365407104998e-05, -1.536838706065647e-06,  2.854484460863977e-08,
 -4.752019339640552e-10,  7.257284090397332e-12, -1.032632352384446e-13,  1.384106291327474e-15, -1.761949374156162e-17,  2.143615113154122e-19, -2.504573981518323e-21,
  5.722391299013791e-02, -3.037654053502586e-03,  1.022421217060040e-04, -2.679476897452969e-06,  5.943062841835959e-08, -1.164980326599930e-09,  2.072026003613923e-11,
 -3.402856006020668e-13,  5.224628799011145e-15, -7.568919369824842e-17,  1.041973702788121e-18, -1.370534661668802e-20,  4.746901615539641e-02, -3.263202465963259e-03,
  1.349774543866792e-04, -4.240543385238284e-06,  1.108562646812094e-07, -2.529041049155925e-09,  5.182865720991509e-11, -9.726827953375535e-13,  1.694718961578550e-14,
 -2.769237367439486e-16,  4.277121661800092e-18, -6.281631771421600e-20,  3.852049805028484e-02, -3.322846273862753e-03,  1.659820877714724e-04, -6.165575374671012e-06,
  1.877659741189387e-07, -4.934042406257618e-09,  1.154143489814397e-10, -2.453685282473999e-12,  4.811695901138073e-14, -8.799770185261460e-16,  1.513610201107290e-17,
 -2.464537194752418e-19,  3.063399615084696e-02, -3.230774120545911e-03,  1.917894813645848e-04, -8.317878803795825e-06,  2.919624148243401e-07, -8.754090183148545e-09,
  2.317388103254469e-10, -5.537161826398490e-12,  1.213143042425351e-13, -2.465849028515943e-15,  4.692220055178883e-17, -8.416665760490937e-19,  2.392206453441779e-02,
 -3.017646155154970e-03,  2.097900634837532e-04, -1.050003197843909e-05,  4.206127023573272e-07, -1.426505010324120e-08,  4.239927206390219e-10, -1.130346768507008e-11,
  2.748070740029908e-13, -6.168499502528717e-15,  1.290675434707568e-16, -2.535665204523349e-18,  1.838192454055302e-02, -2.721811291375653e-03,  2.186513507651025e-04,
 -1.249326147851899e-05,  5.658827541397722e-07, -2.153112662124390e-08,  7.132239292458014e-10, -2.107050590855519e-11,  5.648251215284074e-13, -1.391736207147781e-14,
  3.183826105308729e-16, -6.813630271524325e-18,  1.392971527790347e-02, -2.381630804704498e-03,  2.183796096415803e-04, -1.410147301471962e-05,  7.159546416540251e-07,
 -3.032532656380123e-08,  1.111677289506333e-09, -3.615785311514915e-11,  1.062268095957926e-12, -2.856892094986093e-14,  7.107171933393913e-16, -1.648330473962578e-17,
  1.043387592463159e-02, -2.030123074556273e-03,  2.100841918297210e-04, -1.518646472042029e-05,  8.571477367582408e-07, -4.011807810623665e-08,  1.616580372599924e-09,
 -5.752934767745014e-11,  1.841565782953630e-12, -5.376337715447407e-14,  1.446932724724767e-15, -3.618821620538520e-17,  7.742963074234096e-03, -1.692210779775707e-03,
  1.955751120370144e-04, -1.568580252663159e-05,  9.764720345678823e-07, -5.014440528775047e-08,  2.206673982011824e-09, -8.540458363918535e-11,  2.962088650123739e-12,
 -9.337526735413228e-14,  2.705004848092264e-15, -7.260651547253580e-17,  5.705884190767656e-03, -1.384179184301196e-03,  1.769320693895330e-04, -1.561184263758105e-05,
  1.063855456896342e-06, -5.953136611074824e-08,  2.843019636420356e-09, -1.189669479746746e-10,  4.446055211078293e-12, -1.505535149961607e-13,  4.671594762934077e-15,
 -1.339441844144775e-16,  4.184584913540863e-03, -1.114630566146133e-03,  1.561471000204004e-04, -1.503621317745886e-05,  1.113495783057013e-06, -6.744754052835904e-08,
  3.474143902311743e-09, -1.562806293425972e-10,  6.259544477534418e-12, -2.265305052471255e-13,  7.492658236806373e-15, -2.284223219060568e-16,  3.060449226398199e-03,
 -8.861933581273559e-04,  1.348905958119165e-04, -1.406691456965092e-05,  1.124148964207001e-06, -7.323292138567738e-08,  4.044097588561721e-09, -1.944643091379887e-10,
  8.303417170445812e-12, -3.195366088642200e-13,  1.121200443580919e-14, -3.617773357886153e-16,  2.236143250146207e-03, -6.973981622924793e-04,  1.144039099557208e-04,
 -1.282501240056352e-05,  1.098505362327225e-06, -7.647940241950066e-08,  4.501164305201561e-09, -2.300841549077136e-10,  1.041829781568552e-11, -4.241985049187504e-13,
  1.571505863004156e-14, -5.342578559614687e-16,  1.634585504079056e-03, -5.443496526210453e-04,  9.549252017259369e-05, -1.142577245656322e-05,  1.042007895135892e-06,
 -7.705151748155533e-08,  4.805013012273783e-09, -2.596611298157329e-10,  1.240336551135670e-11, -5.316904548431872e-13,  2.069788623409216e-14, -7.380093346943354e-16,
  1.196405328604670e-03, -4.220224143361566e-04,  7.858277088747770e-05, -9.966398110749534e-06,  9.615045513119926e-07, -7.505526089112076e-08,  4.930873501286944e-09,
 -2.801632934122858e-10,  1.404447005864055e-11, -6.306868416272833e-13,  2.567656120843553e-14, -9.558621835244364e-16,  8.768483358063831e-04, -3.251517005371142e-04,
  6.380757422315550e-05, -8.520294805314466e-06,  8.640447831372182e-07, -7.077384280128968e-08,  4.870382396444651e-09, -2.893755612766780e-10,  1.514471674338428e-11,
 -7.089247936419020e-13,  3.004072833824792e-14, -1.162268987574533e-15,  6.427192318574966e-04, -2.487714815402178e-04,  5.109552749706869e-05, -7.136453369273085e-06,
  7.559939346029453e-07, -6.459174498653856e-08,  4.629663444595033e-09, -2.860905799807504e-10,  1.555079778997277e-11, -7.550225800054317e-13,  3.314220061175312e-14,
 -1.326543435093513e-15,  4.696688017692945e-04, -1.884844391250057e-04,  4.024834823553270e-05, -5.842089536774931e-06,  6.425114237006824e-07, -5.692454071703459e-08,
  4.225717678874868e-09, -2.701207749150447e-10,  1.517049830455269e-11, -7.601635354866449e-13,  3.439967381510678e-14, -1.417862099832107e-15,  3.399406408947051e-04,
 -1.405494891663720e-04,  3.100021977818042e-05, -4.646831232921545e-06,  5.273495547621639e-07, -4.816508805264723e-08,  3.682277937880911e-09, -2.421737487356968e-10,
  1.397980673095759e-11, -7.193376018791343e-13,  3.339725715769667e-14, -1.410959259509245e-15,  2.405796647988602e-04, -1.018577417815947e-04,  2.305847167994290e-05,
 -3.547194863568216e-06,  4.128874367733277e-07, -3.864993920548999e-08,  3.026053400783398e-09, -2.036524407768606e-10,  1.202073830604132e-11, -6.319811600693470e-13,
  2.995766301636527e-14, -1.291246816066765e-15,  1.620469410614717e-04, -6.984848236914400e-05,  1.612817264103335e-05, -2.530599358131309e-06,  3.003095219881388e-07,
 -2.864492153200344e-08,  2.283930355119820e-09, -1.564396925091156e-10,  9.392616790056114e-12, -5.020083102841090e-13,  2.417834121241085e-14, -1.058252765550479e-15,
  9.716547112363171e-05, -4.239970975653096e-05,  9.924620456976374e-06, -1.578630413901694e-06,  1.898597758506502e-07, -1.834669751919566e-08,  1.481380831551373e-09,
 -1.027138857022397e-10,  6.240131268529165e-12, -3.373442729290177e-13,  1.642779850404798e-14, -7.267077835859987e-16,  4.037063995213167e-05, -1.773630959651536e-05,
  4.183091827111330e-06, -6.704309653256960e-07,  8.123278578696742e-08, -7.906666182692644e-09,  6.429013812241217e-10, -4.487994456344053e-11,  2.744521245181286e-12,
 -1.493145437000740e-13,  7.315983578289836e-15, -3.255530490932109e-16,  1.008626901075338e-01, -4.347344062752163e-04,  1.988454634535412e-06, -9.485973340940146e-09,
  4.642074929060737e-11, -2.301510046925213e-13,  1.146537632498453e-15, -5.711320436612417e-18,  2.836969693653110e-20, -1.403370337160045e-22,  6.908913543248868e-25,
 -3.384605521928222e-27,  9.711975670383254e-02, -6.342710048042067e-04,  4.857954794380328e-06, -3.682175298956492e-08,  2.685307865869830e-10, -1.889600087830700e-12,
  1.290850473952129e-14, -8.603029400402666e-17,  5.613909857458360e-19, -3.596572055392846e-21,  2.266852520701694e-23, -1.407901593784183e-25,  9.007167522234409e-02,
 -9.873524335455631e-04,  1.123725334662785e-05, -1.156300644564541e-07,  1.102550883624328e-09, -9.930710335521193e-12,  8.548291337325688e-14, -7.086896228296415e-16,
  5.690120828621698e-18, -4.443162629229022e-20,  3.385190027004917e-22, -2.522904911438688e-24,  8.050550262738863e-02, -1.415444165235528e-03,  2.188423725617427e-05,
 -2.910624779734276e-07,  3.500149444979333e-09, -3.904381213282554e-11,  4.103007256479867e-13, -4.104568846145250e-15,  3.938194854502108e-17, -3.644373206222802e-19,
  3.266818331060561e-21, -2.846203606458168e-23,  6.940629153749216e-02, -1.829355187610587e-03,  3.693794839456301e-05, -6.191937379985877e-07,  9.173229618967097e-09,
 -1.239555322952907e-10,  1.557529198210327e-12, -1.843538856975398e-14,  2.074517260574280e-16, -2.234660981669419e-18,  2.316506857660987e-20, -2.320396528892441e-22,
  5.778472165168548e-02, -2.151834755253745e-03,  5.539643156742859e-05, -1.147589989471965e-06,  2.057193165244030e-08, -3.312504926312536e-10,  4.901294275469675e-12,
 -6.765964489998283e-14,  8.808334571458643e-16, -1.090137217153084e-17,  1.290529249651650e-19, -1.468315290406454e-21,  4.652622025751582e-02, -2.333776874841905e-03,
  7.510427625913371e-05, -1.890893736222679e-06,  4.042003101125493e-08, -7.653946445858588e-10,  1.317444074943664e-11, -2.096982856893432e-13,  3.124374761265653e-15,
 -4.397084399714479e-17,  5.886001754956455e-19, -7.534494299694682e-21,  3.629156682033553e-02, -2.360222931575087e-03,  9.326000904768102e-05, -2.812169928887348e-06,
  7.078980138408523e-08, -1.558846044596068e-09,  3.089457632085776e-11, -5.616039369813143e-13,  9.490315702337034e-15, -1.505799076758026e-16,  2.260592705570748e-18,
 -3.230010559359342e-20,  2.747956098296111e-02, -2.246491243768667e-03,  1.071947266871329e-04, -3.820832703564847e-06,  1.120082881432008e-07, -2.840110554386555e-09,
  6.422955103086800e-11, -1.322325863145427e-12,  2.514556911006583e-14, -4.464778028476864e-16,  7.463955703509106e-18, -1.182319868844838e-19,  2.024413125635363e-02,
 -2.027878552211261e-03,  1.150773985209426e-04, -4.790704912068583e-06,  1.619006704064780e-07, -4.684839197011712e-09,  1.199176064543474e-10, -2.775093300051644e-12,
  5.896796112738018e-14, -1.163902655583178e-15,  2.153018362564476e-17, -3.758028351423771e-19,  1.454699691193695e-02, -1.747481140720653e-03,  1.162884203825906e-04,
 -5.591797871433285e-06,  2.158128083604824e-07, -7.067804585417481e-09,  2.032365256409946e-10, -5.250275026092015e-12,  1.238593836487760e-13, -2.701119716045995e-15,
  5.496934948595089e-17, -1.051408662455617e-18,  1.022431721741945e-02, -1.445906687240496e-03,  1.113880491519359e-04, -6.123088009431787e-06,  2.675157901355068e-07,
 -9.838741742401617e-09,  3.155927361587447e-10, -9.042233996315596e-12,  2.353982522397240e-13, -5.639724737359432e-15,  1.255834437986553e-16, -2.618655468303793e-18,
  7.049779188729469e-03, -1.154866700113963e-03,  1.017772687222361e-04, -6.334229512504003e-06,  3.106792423074346e-07, -1.273735069205658e-08,  4.527194928624041e-10,
 -1.429774121287193e-11,  4.083924022299562e-13, -1.069107698049134e-14,  2.591585051622341e-16, -5.862453704207847e-18,  4.783742466684093e-03, -8.948410185420102e-04,
  8.923216384205951e-05, -6.230363352688942e-06,  3.403546590363658e-07, -1.544564056847680e-08,  6.044024614166921e-10, -2.091591535608874e-11,  6.518764777388352e-13,
 -1.854963478468871e-14,  4.870848245659079e-16, -1.189708887995730e-17,  3.205096840449851e-03, -6.758252062355891e-04,  7.548078069082347e-05, -5.861711539357122e-06,
  3.539552205592504e-07, -1.765915203261445e-08,  7.560590995808065e-10, -2.850468031572487e-11,  9.641490403070662e-13, -2.967138730000093e-14,  8.399328150986695e-16,
 -2.205012895760722e-17,  2.127461004928036e-03, -4.997616124667436e-04,  6.192188913351735e-05, -5.304617259555701e-06,  3.514878037952065e-07, -1.915165356429341e-08,
  8.917015815475704e-10, -3.642002282006965e-11,  1.329883614633371e-12, -4.404201809370355e-14,  1.337700353178641e-15, -3.757485552812866e-17,  1.403788924469260e-03,
 -3.634232924122968e-04,  4.950677338871919e-05, -4.641654818284966e-06,  3.351106339890185e-07, -1.981320611175703e-08,  9.972547473875861e-10, -4.388070110122946e-11,
  1.720781888657584e-12, -6.102356268392100e-14,  1.979429207427310e-15, -5.922542087534067e-17,  9.238550666350026e-04, -2.609559646247286e-04,  3.875083877280126e-05,
 -3.946303502344040e-06,  3.082999204110099e-07, -1.965439463569171e-08,  1.063149644600094e-09, -5.012072144296529e-11,  2.099886295210655e-12, -7.935099612954523e-14,
  2.736001542775025e-15, -8.681107331451754e-17,  6.083188342473978e-04, -1.857293854002191e-04,  2.982057142694740e-05, -3.274415686487398e-06,  2.749526940061238e-07,
 -1.878247257543908e-08,  1.085521874078993e-09, -5.453012002079218e-11,  2.428238572555744e-12, -9.729648194715994e-14,  3.549339429847284e-15, -1.188913732588469e-16,
  4.018887239857358e-04, -1.314702198149445e-04,  2.264564747447475e-05, -2.661975423087746e-06,  2.386679964084748e-07, -1.736258363699442e-08,  1.065936384263073e-09,
 -5.674467049261991e-11,  2.671779826720910e-12, -1.129558971161422e-13,  4.339066597889185e-15, -1.527498506705066e-16,  2.670057883490038e-04, -9.281622214313856e-05,
  1.702247101349986e-05, -2.127187612540234e-06,  2.023137944011128e-07, -1.557779997348865e-08,  1.010039058601190e-09, -5.666864448129261e-11,  2.806534632993748e-12,
 -1.245709286296626e-13,  5.014999403964706e-15, -1.846939437466532e-16,  1.786548288656340e-04, -6.547995202764797e-05,  1.269310963982668e-05, -1.674685783471116e-06,
  1.678706148580199e-07, -1.359756011926354e-08,  9.257408218806971e-10, -5.443874387341862e-11,  2.820985310387340e-12, -1.307971364561180e-13,  5.491911586292230e-15,
 -2.106162082087280e-16,  1.204142476456491e-04, -4.619013797576405e-05,  9.396675073929284e-06, -1.300122141746101e-06,  1.364769396030366e-07, -1.155846516817961e-08,
  8.214828025321566e-10, -5.035219644774899e-11,  2.715612307624281e-12, -1.308590274648405e-13,  5.702642375349945e-15, -2.266683963754818e-16,  8.160583312729108e-05,
 -3.253248900826550e-05,  6.897365965132286e-06, -9.941117778713881e-07,  1.085849194435174e-07, -9.556805958293813e-09,  7.049254662210647e-10, -4.478506126197574e-11,
  2.500385729931769e-12, -1.245780907597297e-13,  5.606705842535895e-15, -2.298789367463785e-16,  5.531700261144514e-05, -2.276495999039052e-05,  4.995851177542098e-06,
 -7.451227828749462e-07,  8.415013639808083e-08, -7.649689193994676e-09,  5.821774457428313e-10, -3.812103179063856e-11,  2.191325432956527e-12, -1.122983625801759e-13,
  5.193385120999396e-15, -2.185842916194176e-16,  3.706664097554966e-05, -1.564631355866907e-05,  3.530337258473752e-06, -5.413099250423496e-07,  6.280635077107880e-08,
 -5.861048332280423e-09,  4.575128853347562e-10, -3.070167692903331e-11,  1.807148142851801e-12, -9.475449309233340e-14,  4.479999848103341e-15, -1.926177633698243e-16,
  2.392184224573116e-05, -1.029325092278829e-05,  2.372153520740974e-06, -3.714877372984014e-07,  4.400200515907973e-08, -4.189451865626873e-09,  3.334448456902222e-10,
 -2.280054156353132e-11,  1.366680074172592e-12, -7.292853226552814e-14,  3.507056768449600e-15, -1.532709296184597e-16,  1.391839403741344e-05, -6.068245145800732e-06,
  1.419038429611896e-06, -2.254962588187818e-07,  2.709431430433839e-08, -2.615772091820019e-09,  2.110167259212871e-10, -1.461837192109062e-11,  8.873493970991137e-13,
 -4.793099917739129e-14,  2.332252159546410e-15, -1.030909017047843e-16,  5.685850177658649e-06, -2.497057802936752e-06,  5.886774139001552e-07, -9.430750793665398e-08,
  1.142187784408966e-08, -1.111262353875954e-09,  9.032088101214211e-11, -6.302610591465826e-12,  3.852679661606062e-13, -2.095223246998903e-14,  1.026210575303396e-15,
 -4.564835943237896e-17,  9.915486419887212e-02, -4.192698098541975e-04,  1.878932145441148e-06, -8.778623012086901e-09,  4.208045598926246e-11, -2.044550047983893e-13,
  9.986071860088016e-16, -4.879268514362051e-18,  2.378113262872484e-20, -1.154608403368780e-22,  5.580149327652673e-25, -2.684094970567688e-27,  9.465770097013435e-02,
 -5.971045369729388e-04,  4.440677950358153e-06, -3.281154768759659e-08,  2.336517147156071e-10, -1.606785829857656e-12,  1.073287593689183e-14, -6.997383237607849e-17,
  4.468470059886672e-19, -2.802445720370412e-21,  1.729642057702920e-23, -1.052220437831467e-25,  8.629367800835339e-02, -9.027191585496960e-04,  9.949326686132790e-06,
 -9.947308885314786e-08,  9.229456570048774e-10, -8.098054293266581e-12,  6.796576103607176e-14, -5.497875070783223e-16,  4.309764231651086e-18, -3.287337144199659e-20,
  2.447669986144828e-22, -1.783465607648492e-24,  7.517302298177830e-02, -1.253445280112897e-03,  1.870336513913309e-05, -2.408087249668292e-07,  2.809123840494322e-09,
 -3.044460279065446e-11,  3.112101362212876e-13, -3.031302095872976e-15,  2.834104277660992e-17, -2.557376143388170e-19,  2.236702014200594e-21, -1.902351180718214e-23,
  6.263610897168272e-02, -1.561253818086169e-03,  3.031257292339077e-05, -4.903868329983143e-07,  7.029697730319621e-09, -9.208737820845705e-11,  1.123350754226776e-12,
 -1.292347945961475e-14,  1.414853238470933e-16, -1.483992388820128e-18,  1.498966976868618e-20, -1.463990405194146e-22,  4.998379315906460e-02, -1.758617014043479e-03,
  4.340070338380078e-05, -8.656390079421229e-07,  1.498482290096909e-08, -2.334978757460837e-10,  3.348872279437623e-12, -4.486982001110675e-14,  5.675921305812825e-16,
 -6.832098714157163e-18,  7.872844270596651e-20, -8.725620527411003e-22,  3.826319011998217e-02, -1.813772247853680e-03,  5.583935951857130e-05, -1.351267235678486e-06,
  2.785113359337312e-08, -5.096838627686635e-10,  8.493630882332198e-12, -1.310792751663512e-13,  1.895882721262490e-15, -2.592861895858100e-17,  3.375994156526642e-19,
 -4.206892452111387e-21,  2.815346976648954e-02, -1.732004138574323e-03,  6.539820036468785e-05, -1.893449538302016e-06,  4.591202990028751e-08, -9.762056383027971e-10,
  1.871637130649364e-11, -3.296427181652560e-13,  5.404265086558464e-15, -8.328316093996268e-17,  1.215567060031145e-18, -1.690115230957426e-20,  1.995626440415831e-02,
 -1.545696419387981e-03,  7.046352647476868e-05, -2.410486920154867e-06,  6.803579670569416e-08, -1.664994694025467e-09,  3.641182992317620e-11, -7.260602518925737e-13,
  1.339107532615046e-14, -2.308815748021760e-16,  3.751882169800051e-18, -5.782531088847472e-20,  1.366367984145670e-02, -1.299398372670837e-03,  7.048201586987042e-05,
 -2.816521805664862e-06,  9.164722010825077e-08, -2.559506993508358e-09,  6.335425397509782e-11, -1.420058786670726e-12,  2.926751770822090e-14, -5.609920135045499e-16,
  1.008852244076417e-17, -1.713590639901097e-19,  9.063319796186287e-03, -1.036119243935502e-03,  6.597918178181791e-05, -3.047563760109009e-06,  1.133080768565561e-07,
 -3.582999359903621e-09,  9.967022825912962e-11, -2.494856865020809e-12,  5.710805744655019e-14, -1.209901038442679e-15,  2.394634781014728e-17, -4.459005889841841e-19,
  5.843466040732286e-03, -7.885999998034373e-04,  5.822903015167409e-05, -3.078370776468758e-06,  1.296888073540957e-07, -4.609316614859186e-09,  1.431392185376995e-10,
 -3.976686421453695e-12,  1.005209718879877e-13, -2.341239124407958e-15,  5.073726204399474e-17, -1.030659717457489e-18,  3.675242002649507e-03, -5.762939269766592e-04,
  4.878071324703207e-05, -2.924477303547462e-06,  1.385058127794699e-07, -5.494269596799707e-09,  1.892699937630888e-10, -5.802178196919844e-12,  1.610813944464073e-13,
 -4.103411920679608e-15,  9.689622750499536e-17, -2.137309790382287e-18,  2.263750331233017e-03, -4.066617930461529e-04,  3.904383105126817e-05, -2.631319812257542e-06,
  1.390437805368874e-07, -6.114816241027214e-09,  2.322494784110394e-10, -7.812085502457583e-12,  2.369522977064900e-13, -6.569403212750249e-15,  1.682419657229536e-16,
 -4.011671604002839e-18,  1.371213104811167e-03, -2.786322199413622e-04,  3.004441777775235e-05, -2.257319481434280e-06,  1.321217037196368e-07, -6.399858937758111e-09,
  2.664187919726773e-10, -9.779097274971256e-12,  3.224098099414908e-13, -9.681528638560069e-15,  2.676782850876722e-16, -6.869718354881488e-18,  8.203757009124515e-04,
 -1.863850479199152e-04,  2.236200805969442e-05, -1.858182980994309e-06,  1.196236883127694e-07, -6.341920212779125e-09,  2.876814654645434e-10, -1.146105995930827e-11,
  4.086554065819639e-13, -1.322806020552973e-14,  3.930652904156830e-16, -1.081066791532738e-17,  4.869808195389425e-04, -1.223813664716294e-04,  1.619375099191606e-05,
 -1.476860060516657e-06,  1.038572849048928e-07, -5.988788467754929e-09,  2.943273493549254e-10, -1.265898910201677e-11,  4.857066985016827e-13, -1.686772848800977e-14,
  5.362511535274143e-16, -1.573799762971983e-17,  2.881280926886828e-04, -7.929420302189608e-05,  1.147477421007455e-05, -1.140029426734654e-06,  8.698834463380727e-08,
 -5.422295799912778e-09,  2.870734985597767e-10, -1.325856760024150e-11,  5.446658351739610e-13, -2.019708057813588e-14,  6.838748385383868e-16, -2.132412399779637e-17,
  1.706825840089703e-04, -5.095743791857053e-05,  7.999435962978333e-06, -8.595174603760554e-07,  7.069117311324885e-08, -4.734178741797270e-09,  2.684666445307121e-10,
 -1.324335895352798e-11,  5.795475057999542e-13, -2.283677491059660e-14,  8.198021502746345e-16, -2.704037931456213e-17,  1.016668750020556e-04, -3.263590631111028e-05,
  5.514272993257075e-06, -6.362216593212996e-07,  5.603079986954579e-08, -4.006851694959202e-09,  2.419860354623594e-10, -1.268090109503766e-11,  5.881248441234816e-13,
 -2.450655137392946e-14,  9.283649584934459e-16, -3.224728164597334e-17,  6.112489018057418e-05, -2.092012830005207e-05,  3.775550907414998e-06, -4.644812235443894e-07,
  4.351591150874692e-08, -3.302575254092988e-09,  2.111859499793315e-10, -1.169214034663888e-11,  5.717113503807252e-13, -2.506664365304336e-14,  9.973073033721334e-16,
 -3.631560681359614e-17,  3.720770663797709e-05, -1.346842031508465e-05,  2.576982061142602e-06, -3.356891027977325e-07,  3.323784789766046e-08, -2.660600708265350e-09,
  1.790902608008049e-10, -1.041717739657080e-11,  5.341810587046520e-13, -2.451931585043769e-14,  1.019585422088382e-15, -3.873908292240823e-17,  2.297242703833430e-05,
 -8.727565585898189e-06,  1.757438502304504e-06, -2.407303889401620e-07,  2.502583799372921e-08, -2.099751015239812e-09,  1.478972785015126e-10, -8.987220875031404e-12,
  4.806899337478675e-13, -2.297891223416572e-14,  9.937153520363850e-16, -3.920752843301626e-17,  1.438235170693911e-05, -5.692791956230869e-06,  1.197745836594097e-06,
 -1.713307918519340e-07,  1.857751788984233e-08, -1.623533991573288e-09,  1.189423205462484e-10, -7.507281480738958e-12,  4.165053849419690e-13, -2.062636031591878e-14,
  9.228999650152896e-16, -3.762807703402746e-17,  9.096188872032779e-06, -3.724748641302388e-06,  8.129912088259757e-07, -1.206073306758950e-07,  1.354988351998845e-08,
 -1.225563963111393e-09,  9.281919411447587e-11, -6.049437557219912e-12,  3.461788427231304e-13, -1.766374756514079e-14,  8.134768744657453e-16, -3.410121592484767e-17,
  5.751425384967274e-06, -2.419903173775787e-06,  5.440802439974649e-07, -8.313104805794332e-08,  9.612379135146254e-09, -8.940475440341281e-10,  6.956592273796238e-11,
 -4.653854966378628e-12,  2.731180408608264e-13, -1.427936933971285e-14,  6.732629008787925e-16, -2.886999245238566e-17,  3.546388698360464e-06, -1.523102065840392e-06,
  3.502833209654939e-07, -5.474238526439874e-08,  6.471056088226255e-09, -6.149073079830426e-10,  4.884881030883313e-11, -3.334114396997863e-12,  1.994962786206223e-13,
 -1.062733636027277e-14,  5.102161935329450e-16, -2.226292111640075e-17,  1.998015531193189e-06, -8.703016392808874e-07,  2.033069654080760e-07, -3.227362588777861e-08,
  3.873873822941155e-09, -3.736264334653541e-10,  3.011184530796836e-11, -2.084082295734379e-12,  1.263916214645177e-13, -6.821187188959619e-15,  3.316275162639085e-16,
 -1.464668336252496e-17,  8.015576414454181e-07, -3.518803574038633e-07,  8.291804357611617e-08, -1.327763688620878e-08,  1.607373557448066e-09, -1.563162208657069e-10,
  1.269952882254791e-11, -8.858005683218449e-13,  5.412507158444527e-14, -2.942320757737126e-15,  1.440536519811460e-16, -6.405387137900109e-18,  9.750719645798397e-02,
 -4.046485832471233e-04,  1.777497547585068e-06, -8.136791284505023e-09,  3.822038410381793e-11, -1.820455661780915e-13,  8.720461675879120e-16, -4.180690428516668e-18,
  1.999942350159754e-20, -9.533152019881785e-23,  4.524287035125314e-25, -2.137405540932728e-27,  9.233792660472830e-02, -5.630928689713977e-04,  4.068353047046338e-06,
 -2.931684854419357e-08,  2.039411594779076e-10, -1.371180877649881e-12,  8.959531304169959e-15, -5.716395749262677e-17,  3.573730106721404e-19, -2.194911868435571e-21,
  1.327021798658207e-23, -7.910128941231876e-26,  8.283476952395911e-02, -8.276599702366086e-04,  8.839181119100931e-06, -8.591798664628553e-08,  7.761255706717296e-10,
 -6.637050076680698e-12,  5.433720764031364e-14, -4.290638757967606e-16,  3.285167441644024e-18, -2.448751894278682e-20,  1.782548710650574e-22, -1.270316320222601e-24,
  7.044121508806077e-02, -1.114656871481569e-03,  1.606448280408868e-05, -2.003551793777580e-07,  2.268542887266388e-09, -2.389952353499270e-11,  2.377606538911698e-13,
 -2.255939253445072e-15,  2.056185480486720e-17, -1.809991635893888e-19,  1.545168761637732e-21, -1.283415740949347e-23,  5.684135161332151e-02, -1.340510756198176e-03,
  2.504643396354773e-05, -3.912952213962939e-07,  5.430692621020236e-09, -6.900315619674529e-11,  8.176048121267514e-13, -9.146526128806499e-15,  9.746404648741313e-17,
 -9.957939535209452e-19,  9.804794190083717e-21, -9.340372990391288e-23,  4.358326735541968e-02, -1.449214712905584e-03,  3.431053111370184e-05, -6.592675185680235e-07,
  1.102654629594430e-08, -1.663560444505627e-10,  2.313757374373163e-12, -3.010225995475452e-14,  3.701486122139325e-16, -4.335018755577851e-18,  4.864259798108469e-20,
 -5.253436314388734e-22,  3.180859164419474e-02, -1.425051182271045e-03,  4.199421215380730e-05, -9.772575546445543e-07,  1.943072283093044e-08, -3.438013942120914e-10,
  5.549117091283115e-12, -8.306316548802614e-14,  1.166676006112034e-15, -1.551064204713842e-17,  1.964966824255623e-19, -2.384344497954540e-21,  2.214377846673803e-02,
 -1.288555575068578e-03,  4.651132340924635e-05, -1.293462881148736e-06,  3.022257083374313e-08, -6.206984835608016e-10,  1.151608548808249e-11, -1.965774532577458e-13,
  3.127472920683787e-15, -4.682350498577729e-17,  6.645991792001575e-19, -8.994004495606252e-21,  1.474083783021069e-02, -1.081439245376706e-03,  4.710704202325261e-05,
 -1.546962305715555e-06,  4.204910918591052e-08, -9.934005693868418e-10,  2.101266620247653e-11, -4.059092747232787e-13,  7.262335842347869e-15, -1.216085052535604e-16,
  1.921262738300831e-18, -2.881537664089475e-20,  9.410408828723760e-03, -8.492211004457457e-04,  4.402739465400626e-05, -1.688902664733000e-06,  5.291825042954257e-08,
 -1.426515951592877e-09,  3.414844815061819e-11, -7.414454787238426e-13,  1.482308237106673e-14, -2.759399032861579e-16,  4.824542443326745e-18, -7.974975142673817e-20,
  5.780160830284433e-03, -6.284552449401822e-04,  3.828526005323335e-05, -1.698437586433607e-06,  6.082839076360389e-08, -1.857160588796511e-09,  4.997518438241082e-11,
 -1.212053315370502e-12,  2.691944568586824e-14, -5.540425801290277e-16,  1.066426227463968e-17, -1.933128455316015e-19,  3.428664179525343e-03, -4.412121681585880e-04,
  3.121154943984147e-05, -1.586380984856653e-06,  6.442954510893080e-08, -2.212457050425842e-09,  6.650504951548747e-11, -1.791270512388523e-12,  4.395805314280543e-14,
 -9.951729131659006e-16,  2.098574959250496e-17, -4.152342660596865e-19,  1.972203040404913e-03, -2.957343767614129e-04,  2.402775654140786e-05, -1.386934271235356e-06,
  6.340145679747322e-08, -2.432551529740704e-09,  8.119270972443681e-11, -2.415292822580399e-12,  6.515509823910814e-14, -1.614692892070248e-15,  3.713295041258615e-17,
 -7.984716581366545e-19,  1.105055796967341e-03, -1.904366066397615e-04,  1.759003903859802e-05, -1.143494682952573e-06,  5.841552560567414e-08, -2.488292570310201e-09,
  9.169104812134457e-11, -2.996527936657172e-12,  8.841915794078088e-14, -2.387500932922234e-15,  5.961221618447511e-17, -1.387173063721674e-18,  6.061145773315756e-04,
 -1.185511974619522e-04,  1.233010206183321e-05, -8.955618742430413e-07,  5.077305336126010e-08, -2.386343342465093e-09,  9.653544361692210e-11, -3.447960654192977e-12,
  1.107478113649003e-13, -3.243440732282426e-15,  8.754676991699247e-17, -2.195508809692788e-18,  3.271505400702281e-04, -7.179708229037055e-05,  8.332610077520240e-06,
 -6.710259840340259e-07,  4.193663770626338e-08, -2.161664259851314e-09,  9.546947859107266e-11, -3.707629093059421e-12,  1.290120457465758e-13, -4.079531670034664e-15,
  1.185285291541214e-16, -3.190339275423380e-18,  1.747331589552051e-04, -4.257200917826616e-05,  5.465964768035773e-06, -4.844221312125540e-07,  3.315308030609415e-08,
 -1.862994856017816e-09,  8.933434455235150e-11, -3.753039038180422e-12,  1.407970164893711e-13, -4.785353746417097e-15,  1.490167521573999e-16, -4.287269711387095e-18,
  9.288414062718787e-05, -2.487420844822350e-05,  3.503982369689072e-06, -3.392833751140377e-07,  2.526221549242780e-08, -1.538368155630076e-09,  7.965269435661616e-11,
 -3.601308907073092e-12,  1.449581512832800e-13, -5.271233656869874e-15,  1.751650579517592e-16, -5.364302637657492e-18,  4.942981790549300e-05, -1.441316882645882e-05,
  2.209818459208400e-06, -2.321114675924553e-07,  1.868066937280107e-08, -1.225413258354258e-09,  6.812982942874657e-11, -3.297800676992938e-12,  1.417223594074423e-13,
 -5.488161763525931e-15,  1.937501481221247e-16, -6.288926324139988e-18,  2.648652421515797e-05, -8.334087777930561e-06,  1.379871898801759e-06, -1.561147554561686e-07,
  1.349280574411667e-08, -9.477000766520738e-10,  5.625813090303871e-11, -2.899928615300379e-12,  1.323864841094112e-13, -5.433367841965374e-15,  2.028509034413888e-16,
 -6.948261683744328e-18,  1.436866551138923e-05, -4.837044040595453e-06,  8.582319007251861e-07, -1.038515114335861e-07,  9.576167802222230e-09, -7.157809577097166e-10,
  4.510776958847150e-11, -2.462637268348101e-12,  1.188091032209984e-13, -5.142420215964649e-15,  2.020772096123331e-16, -7.271343762096873e-18,  7.929366282680755e-06,
 -2.832357627084904e-06,  5.344653304216303e-07, -6.868558393093841e-08,  6.712646292416675e-09, -5.306360401220332e-10,  3.529105458193491e-11, -2.029218100796187e-12,
  1.029089251066175e-13, -4.673562788793974e-15,  1.923612609709588e-16, -7.237292572447421e-18,  4.467304826416296e-06, -1.679766621957263e-06,  3.345787409369796e-07,
 -4.534222053751260e-08,  4.665198744835133e-09, -3.875507404952592e-10,  2.703766060520308e-11, -1.627968298355287e-12,  8.630848548645054e-14, -4.091049137879878e-15,
  1.754790966960468e-16, -6.869625530745922e-18,  2.573363524654982e-06, -1.010800827260004e-06,  2.109315359359664e-07, -2.992969798274637e-08,  3.219987499268813e-09,
 -2.792868170633068e-10,  2.031291514475734e-11, -1.273170645126492e-12,  7.016319091895141e-14, -3.452293758064994e-15,  1.535121248931462e-16, -6.221723902737228e-18,
  1.512557617371672e-06, -6.160451364263703e-07,  1.336821726309124e-07, -1.971793454295932e-08,  2.202904851449800e-09, -1.981767028205912e-10,  1.493127403878062e-11,
 -9.682804657888855e-13,  5.514367665644507e-14, -2.800694658918492e-15,  1.284077264226216e-16, -5.359886383686516e-18,  8.991952822596413e-07, -3.770171348062119e-07,
  8.444433112204834e-08, -1.285367873781583e-08,  1.480797339583265e-09, -1.372393183959759e-10,  1.064197774423279e-11, -7.095788890262512e-13,  4.151002488532003e-14,
 -2.163601288824537e-15,  1.017108529359826e-16, -4.349043699307114e-18,  5.281398177855672e-07, -2.263673994208873e-07,  5.194419843547051e-08, -8.099859303609518e-09,
  9.554067815935763e-10, -9.059644024730174e-11,  7.182476915273911e-12, -4.892715141627057e-13,  2.922019891333908e-14, -1.553747802929163e-15,  7.446390519948168e-17,
 -3.243679108279670e-18,  2.874780437926909e-07, -1.250961762491807e-07,  2.919084729386189e-08, -4.628728074255378e-09,  5.549941293136536e-10, -5.347147495695116e-11,
  4.305039849222715e-12, -2.976621586605076e-13,  1.803472492731337e-14, -9.724042239064069e-16,  4.723302812138317e-17, -2.084280902545655e-18,  1.131109567725350e-07,
 -4.963441171144872e-08,  1.169047126573038e-08, -1.871097859888465e-09,  2.264057536825591e-10, -2.200762919337069e-11,  1.787144111282074e-12, -1.245991361768728e-13,
  7.610076980381781e-15, -4.135198839373075e-16,  2.023721322204637e-17, -8.994903725104721e-19,  9.591643801049908e-02, -3.908090424173575e-04,  1.683408636792037e-06,
 -7.553293819740600e-09,  3.477964278774604e-11, -1.624519028613483e-13,  7.634545196293242e-16, -3.592302883925986e-18,  1.687180349095942e-20, -7.898160372915695e-23,
  3.681850119475372e-25, -1.708894495796042e-27,  9.014849635509541e-02, -5.318997922300689e-04,  3.735260648555002e-06, -2.626201755612919e-08,  1.785445631607006e-10,
 -1.174136465712713e-12,  7.507857551598139e-15, -4.689627823627441e-17,  2.871283084666413e-19, -1.727608482299960e-21,  1.023530659898889e-23, -5.980125982061187e-26,
  7.965931206165662e-02, -7.608691259049798e-04,  7.878511733288187e-06, -7.449493074650551e-08,  6.555104895971733e-10, -5.466011318105125e-12,  4.367186059494490e-14,
 -3.367694618375701e-16,  2.519553630278851e-18, -1.836026804090535e-20,  1.307161445771149e-22, -9.114197935355336e-25,  6.622521797273247e-02, -9.951754284086595e-04,
  1.386317576264465e-05, -1.675925890490911e-07,  1.842858683682890e-09, -1.888253185463266e-11,  1.829055533376620e-13, -1.691309253345538e-15,  1.503463929304972e-17,
 -1.291579027721804e-19,  1.076655529328317e-21, -8.736567552496909e-24,  5.185226842615102e-02, -1.157542672719418e-03,  2.082992574725556e-05, -3.144596212159071e-07,
  4.227800428130749e-09, -5.213204776111470e-11,  6.002731816026738e-13, -6.532924676940724e-15,  6.778573929343834e-17, -6.749078923890576e-19,  6.480221301422381e-21,
 -6.023584681801766e-23,  3.828919655346497e-02, -1.203610674318062e-03,  2.735711882527190e-05, -5.067068216987278e-07,  8.192806196996288e-09, -1.197335834822516e-10,
  1.615696048001565e-12, -2.041992373831240e-14,  2.441755983757261e-16, -2.783429370070048e-18,  3.042364036837564e-20, -3.202938033742994e-22,  2.671284993012329e-02,
 -1.131199896122167e-03,  3.192701009496998e-05, -7.148591384335344e-07,  1.371789153674679e-08, -2.347794976874004e-10,  3.671808455618459e-12, -5.333057711425543e-14,
  7.276781647606105e-16, -9.407573571554214e-18,  1.159964107206154e-19, -1.371015791485899e-21,  1.764590822894289e-02, -9.711850931177218e-04,  3.352545483140918e-05,
 -8.958827727285100e-07,  2.017907201536389e-08, -4.004451123789160e-10,  7.192152716734013e-12, -1.190235063474737e-13,  1.838180250887251e-15, -2.674413086856191e-17,
  3.692417344755899e-19, -4.864795747514751e-21,  1.106558341428216e-02, -7.687491230614225e-04,  3.200379738783545e-05, -1.009158977101917e-06,  2.642383882518271e-08,
 -6.027919384762923e-10,  1.233551451811542e-11, -2.308990229310683e-13,  4.008358450680374e-15, -6.520093055647028e-17,  1.001656548067970e-18, -1.462170471015271e-20,
  6.607393938526320e-03, -5.655860045287219e-04,  2.802625967632529e-05, -1.032123569041158e-06,  3.114437773617587e-08, -8.104781559980687e-10,  1.876576746576261e-11,
 -3.947347448417579e-13,  7.655854627535214e-15, -1.384267026474744e-16,  2.353275508595666e-18, -3.785954711182981e-20,  3.769930191640731e-03, -3.896032543156259e-04,
  2.270112919890390e-05, -9.671589404447172e-07,  3.336467919239334e-08, -9.835172062122421e-10,  2.560192043087919e-11, -6.016278618879226e-13,  1.296479283461108e-14,
 -2.592187353217412e-16,  4.852320249261362e-18, -8.562585211101514e-20,  2.063561318723214e-03, -2.530150919387134e-04,  1.714037686631539e-05, -8.373453313826018e-07,
  3.277858759854242e-08, -1.087339138377341e-09,  3.163309867974465e-11, -8.259186498816550e-13,  1.967455578916283e-14, -4.328986045278576e-16,  8.881935212014952e-18,
 -1.711619080312552e-19,  1.088519268545825e-03, -1.559486432113362e-04,  1.215461541063794e-05, -6.751979954070110e-07,  2.978098327918678e-08, -1.104806143278468e-09,
  3.571925237238477e-11, -1.030829083905353e-12,  2.701373163213227e-14, -6.511301121452043e-16,  1.457969344035870e-17, -3.055577518434003e-19,  5.561194396528154e-04,
 -9.184177673258315e-05,  8.154991670606587e-06, -5.110588889524063e-07,  2.522637740975159e-08, -1.040326047991510e-09,  3.717645095292677e-11, -1.179969920216406e-12,
  3.385913197096273e-14, -8.901348617639670e-16,  2.166145660199456e-17, -4.917550538805037e-19,  2.767048094152495e-04, -5.203434113883793e-05,  5.215409064947889e-06,
 -3.659223675775980e-07,  2.008151335539040e-08, -9.152548083451086e-10,  3.595999060621571e-11, -1.249158786254960e-12,  3.907041581033946e-14, -1.115472260662852e-15,
  2.938132834971760e-17, -7.197079848265346e-19,  1.348973692280689e-04, -2.856193023574370e-05,  3.203308160532009e-06, -2.497808123807886e-07,  1.514264215215653e-08,
 -7.583694579215770e-10,  3.258814589070962e-11, -1.232953011959050e-12,  4.184406405406128e-14, -1.291872919292178e-15,  3.668192530467360e-17, -9.657775658392900e-19,
  6.485613177847376e-05, -1.530002902931876e-05,  1.904039960291098e-06, -1.638261471477585e-07,  1.090209702803724e-08, -5.965394546038133e-10,  2.788955574416923e-11,
 -1.143676977725245e-12,  4.192442925190826e-14, -1.393665624039202e-15,  4.248488484645710e-17, -1.197570237250167e-18,  3.096369521410035e-05, -8.058605872614287e-06,
  1.103819172254142e-06, -1.040616957703666e-07,  7.553781877877006e-09, -4.490047438872504e-10,  2.271837616205208e-11, -1.004778945893662e-12,  3.960012362164703e-14,
 -1.411198325748347e-15,  4.599334373882453e-17, -1.382511618580536e-18,  1.478508528302963e-05, -4.205448618271972e-06,  6.290315217372342e-07, -6.452321253295542e-08,
  5.076797652300892e-09, -3.259204625300422e-10,  1.775090245393980e-11, -8.424665763090177e-13,  3.552824837081246e-14, -1.351155350404792e-15,  4.687872568252472e-17,
 -1.496471680932334e-18,  7.112571584128726e-06, -2.191178904307546e-06,  3.551269209393014e-07, -3.935906898896253e-08,  3.335367555917364e-09, -2.298956897943282e-10,
  1.340359410037168e-11, -6.791003709816110e-13,  3.049392574880213e-14, -1.231837629905116e-15,  4.529484103873624e-17, -1.528980938941732e-18,  3.471849910582663e-06,
 -1.148399420496134e-06,  2.001236485404436e-07, -2.379721000410929e-08,  2.157883963178930e-09, -1.587255361051853e-10,  9.850167346273782e-12, -5.299044367474126e-13,
  2.520660676175261e-14, -1.076332892358538e-15,  4.174868355817708e-17, -1.483594656994322e-18,  1.731015655949294e-06, -6.096051900985326e-07,  1.133490565825848e-07,
 -1.435904030999415e-08,  1.384036706534967e-09, -1.079660354387209e-10,  7.089708469988063e-12, -4.027096149182145e-13,  2.018506822186834e-14, -9.064456257631136e-16,
  3.690788225383976e-17, -1.374281317363055e-18,  8.864395121864725e-07, -3.296476599783707e-07,  6.489959014650801e-08, -8.695497136752115e-09,  8.848740999960867e-10,
 -7.273515626672397e-11,  5.023108009355998e-12, -2.995115605881910e-13,  1.573091406630282e-14, -7.389722611838294e-16,  3.142416443841267e-17, -1.220024349130009e-18,
  4.678860077734315e-07, -1.822739332115643e-07,  3.770355211012397e-08, -5.303805801669959e-09,  5.658547934657910e-10, -4.868568591981637e-11,  3.513649509605516e-12,
 -2.185947859480662e-13,  1.196068280023848e-14, -5.844785586427761e-16,  2.581860150933985e-17, -1.039790847376929e-18,  2.545328947733940e-07, -1.030687261720941e-07,
  2.222650722506487e-08, -3.258186897479389e-09,  3.618323539251104e-10, -3.236335251825969e-11,  2.424828454450765e-12, -1.564086712927812e-13,  8.861760291505972e-15,
 -4.478577898287884e-16,  2.043606636874358e-17, -8.491345718550893e-19,  1.417277297737023e-07, -5.920075183027055e-08,  1.320548384199281e-08, -2.001907732949880e-09,
  2.297173627975583e-10, -2.120880802008528e-11,  1.638549085239531e-12, -1.088670438003313e-13,  6.346947387387947e-15, -3.297316890164907e-16,  1.545166977608164e-17,
 -6.586897656141976e-19,  7.903637764916504e-08, -3.380227179140236e-08,  7.737986731476118e-09, -1.203738318617865e-09,  1.416551819063567e-10, -1.340221820781194e-11,
  1.060216611346056e-12, -7.207064593638371e-14,  4.295485746044679e-15, -2.279616043922920e-16,  1.090458865583684e-17, -4.741490273727791e-19,  4.146444530758988e-08,
 -1.802405008752853e-08,  4.200888504397361e-09, -6.653373530423484e-10,  7.968288666216695e-11, -7.668478110137614e-12,  6.167219877829754e-13, -4.259671666345191e-14,
  2.578202444899742e-15, -1.388748699759404e-16,  6.739160688558826e-18, -2.971077417253475e-19,  1.597819860160512e-08, -7.008322362747800e-09,  1.649861145085204e-09,
 -2.639330180865233e-10,  3.192044800918886e-11, -3.101294848028002e-12,  2.517225850160244e-13, -1.754184055932122e-14,  1.070906165615037e-15, -5.816552670571842e-17,
  2.845322058076770e-18, -1.264135638910548e-19,  9.437957536646299e-02, -3.776951119878788e-04,  1.596003872366584e-06, -7.021849428688807e-09,  3.170599098254143e-11,
 -1.452775288622229e-13,  6.700206031172013e-16, -3.095196853262594e-18,  1.427640576665380e-20, -6.565290401676871e-23,  3.007042779200738e-25, -1.371595761073137e-27,
  8.807873172886921e-02, -5.032314429871171e-04,  3.436512322616375e-06, -2.358380461617522e-08,  1.567624907844013e-10, -1.008721542403098e-12,  6.314580339320994e-15,
 -3.862912766119987e-17,  2.317115113569151e-19, -1.366290877758452e-21,  7.934896290098372e-24, -4.545684316183573e-26,  7.673647134059418e-02, -7.012464434880204e-04,
  7.044070091952963e-06, -6.482742623285785e-08,  5.559523358047066e-10, -4.522507003704544e-12,  3.527847481227072e-14, -2.657836026603057e-16,  1.943783016691730e-18,
 -1.385281839685674e-20,  9.649460158508560e-23, -6.585168463104716e-25,  6.245426171068744e-02, -8.918404370406662e-04,  1.201724749547374e-05, -1.409047217803903e-07,
  1.505533251197384e-09, -1.501072996536457e-11,  1.416405850425278e-13, -1.276981217862162e-15,  1.107571978339363e-17, -9.289400655854471e-20,  7.564264576686079e-22,
 -5.998789178287473e-24,  4.753300266859586e-02, -1.004921813851087e-03,  1.743024762366183e-05, -2.544312402670776e-07,  3.315585999662467e-09, -3.969622278231579e-11,
  4.443954572979025e-13, -4.707259077818733e-15,  4.757997019809079e-17, -4.618330117395637e-19,  4.325853513659646e-21, -3.924949069006492e-23,  3.387688026860033e-02,
 -1.007016419234378e-03,  2.199045154056230e-05, -3.928520492330303e-07,  6.143787969680235e-09, -8.701985959824049e-11,  1.139792347703202e-12, -1.399972628333544e-14,
  1.628597387762721e-16, -1.807672618809274e-18,  1.925360733296942e-20, -1.976551623494791e-22,  2.264938671061540e-02, -9.066938861554215e-04,  2.452489184401914e-05,
 -5.286136374512826e-07,  9.794960625654863e-09, -1.622274979775348e-10,  2.459398941524501e-12, -3.467415365039006e-14,  4.597781984760095e-16, -5.782211018627727e-18,
  6.941320735137291e-20, -7.993845710638043e-22,  1.423650474519488e-02, -7.410480411973728e-04,  2.447530719575080e-05, -6.287342591064138e-07,  1.365725827395254e-08,
 -2.619756734370689e-10,  4.556390872257350e-12, -7.312773154242984e-14,  1.096644426243034e-15, -1.550959488231775e-17,  2.083460774946656e-19, -2.673056935534987e-21,
  8.435009851676603e-03, -5.547927709151803e-04,  2.207940674758247e-05, -6.687014347758711e-07,  1.687146425076827e-08, -3.717480723867454e-10,  7.361826853597039e-12,
 -1.335593262398129e-13,  2.250170017726103e-15, -3.556270043587804e-17,  5.313587320531016e-19, -7.550710658918100e-21,  4.725543635465894e-03, -3.835363518021388e-04,
  1.816580232026696e-05, -6.423324620934052e-07,  1.866900286915067e-08, -4.690746381760309e-10,  1.050666016574799e-11, -2.141400983297315e-13,  4.029716135450174e-15,
 -7.077912684370682e-17,  1.170088856710813e-18, -1.832294431259583e-20,  2.512314453437131e-03, -2.466460606495497e-04,  1.374341616472809e-05, -5.622845710592524e-07,
  1.868434835364834e-08, -5.317831687713629e-10,  1.339134407495205e-11, -3.049169609774389e-13,  6.375662283759154e-15, -1.238399168881863e-16,  2.254484614252817e-18,
 -3.872872816905597e-20,  1.272812191569313e-03, -1.485880490494727e-04,  9.636190234706264e-06, -4.523583742501394e-07,  1.706501702754052e-08, -5.467801830366000e-10,
  1.539364645109681e-11, -3.895703980924965e-13,  9.007543470284373e-15, -1.926070040103252e-16,  3.844609615784905e-18, -7.215142137910855e-20,  6.174346435988018e-04,
 -8.443992720380646e-05,  6.309802186720513e-06, -3.371919017366734e-07,  1.434528401626369e-08, -5.144242604177234e-10,  1.610622217460023e-11, -4.508304172362091e-13,
  1.147466831939368e-14, -2.689544823473029e-16,  5.862555770245796e-18, -1.197277236429362e-19,  2.883318767451007e-04, -4.558541412852629e-05,  3.888321528066129e-06,
 -2.347693381537482e-07,  1.119196290217814e-08, -4.466622589921623e-10,  1.547339168940009e-11, -4.768126938285009e-13,  1.330107251621490e-14, -3.403405813508922e-16,
  8.069664306160891e-18, -1.786718632105079e-19,  1.304034005701452e-04, -2.354985885480988e-05,  2.272721720718965e-06, -1.539235418597736e-07,  8.171664460615070e-09,
 -3.609601573763191e-10,  1.376698900817501e-11, -4.648942498688374e-13,  1.415302231711941e-14, -3.937467160130225e-16,  1.011656982974816e-17, -2.419578048568769e-19,
  5.750219465065619e-05, -1.173164555885531e-05,  1.270214642735446e-06, -9.582330972534324e-08,  5.630874847443353e-09, -2.738068648010933e-10,  1.144073871375814e-11,
 -4.214471917363053e-13,  1.394267243473967e-14, -4.200611134683664e-16,  1.165063586996031e-17, -2.999020269447588e-19,  2.490365927039784e-05, -5.681189943808868e-06,
  6.845367903630765e-07, -5.712727077710424e-08,  3.693413758833662e-09, -1.966349883554266e-10,  8.956663935701289e-12, -3.582721923308616e-13,  1.282493549146315e-14,
 -4.167319061318555e-16,  1.242908314109364e-17, -3.430747631941403e-19,  1.067746966753527e-05, -2.697191732763217e-06,  3.588281095306546e-07, -3.290289607290053e-08,
  2.326343077217464e-09, -1.348622511451834e-10,  6.662863932151615e-12, -2.880493517877665e-13,  1.110795858909989e-14, -3.876689019637817e-16,  1.238416398680058e-17,
 -3.651637891261167e-19,  4.570478375006480e-06, -1.266536730362815e-06,  1.846070481796116e-07, -1.847342058517023e-08,  1.419668162489390e-09, -8.911635704975632e-11,
  4.750752966049114e-12, -2.209038958295380e-13,  9.135110315871535e-15, -3.409469215823345e-16,  1.161784887848952e-17, -3.645044273145875e-19,  1.970396820953335e-06,
 -5.936128334323865e-07,  9.407099014926403e-08, -1.020309053010193e-08,  8.469574444097461e-10, -5.723803634803528e-11,  3.274856481736044e-12, -1.629586195693734e-13,
  7.192165295511421e-15, -2.857660744459467e-16,  1.034199301910225e-17, -3.438238273674943e-19,  8.631642424097340e-07, -2.802342645258127e-07,  4.791379794929126e-08,
 -5.593587857862652e-09,  4.983396020811752e-10, -3.604194456999439e-11,  2.200826119436816e-12, -1.165785693247534e-13,  5.463795662134049e-15, -2.300106270762441e-16,
  8.800582618893078e-18, -3.086690766320172e-19,  3.875234680160240e-07, -1.344223331742647e-07,  2.460585314519838e-08, -3.069939662716727e-09,  2.916020927940280e-10,
 -2.243012636630617e-11,  1.453214807839191e-12, -8.148795103281570e-14,  4.034236566741921e-15, -1.790273227407106e-16,  7.206881576101056e-18, -2.654342775139069e-19,
  1.796758513389723e-07, -6.603061181384254e-08,  1.283922655484049e-08, -1.699473526799141e-09,  1.709281187067883e-10, -1.389279916518482e-11,  9.491389222942614e-13,
 -5.601103858186829e-14,  2.912718314172731e-15, -1.355281381366503e-16,  5.710643761323862e-18, -2.197722185732158e-19,  8.653147766074395e-08, -3.341254172440775e-08,
  6.846599924718129e-09, -9.542482536936581e-10,  1.009005648005857e-10, -8.607002412214751e-12,  6.160535409946706e-13, -3.802350972842179e-14,  2.064703960079688e-15,
 -1.001591005669008e-16,  4.393379814461516e-18, -1.757442759174467e-19,  4.338165955864601e-08, -1.745721171339031e-08,  3.739366344459336e-09, -5.445295866686584e-10,
  6.008424233118612e-11, -5.340914449950094e-12,  3.977909149155467e-13, -2.551214671058475e-14,  1.437525350938140e-15, -7.226663876644768e-17,  3.280846244468064e-18,
 -1.356581151880469e-19,  2.253372998130860e-08, -9.374333039908907e-09,  2.081838155257473e-09, -3.142206428873480e-10,  3.590349661606234e-11, -3.301226028003537e-12,
  2.540389005435866e-13, -1.681449316337785e-14,  9.767010640615414e-16, -5.056235205844846e-17,  2.361400586704372e-18, -1.003371763143265e-19,  1.188990189483282e-08,
 -5.073129855297947e-09,  1.158340467135867e-09, -1.797317426933631e-10,  2.109786146570366e-11, -1.991274276844836e-12,  1.571571500256418e-13, -1.065907710221850e-14,
  6.339145236828599e-16, -3.357157404202540e-17,  1.602669124195929e-18, -6.955173841828392e-20,  5.996364735414250e-09, -2.603559357346784e-09,  6.060452099497226e-10,
 -9.586382097655714e-11,  1.146670763073140e-11, -1.102196584194921e-12,  8.853843785309362e-14, -6.108400748292590e-15,  3.693120802359692e-16, -1.987196977254778e-17,
  9.633385230678450e-19, -4.242860070666224e-20,  2.259584821769872e-09, -9.906317682766142e-10,  2.330869378713643e-10, -3.726785001896644e-11,  4.504871616296877e-12,
 -4.374552949454240e-13,  3.548909329983682e-14, -2.471923791317580e-15,  1.508355233419656e-16, -8.188704524282664e-18,  4.003899733800865e-19, -1.778086985070441e-20,
  9.289380921085359e-02, -3.652557210400192e-04,  1.514692323018724e-06, -6.536952835403648e-09,  2.895448326687785e-11, -1.301875007569718e-13,  5.894114995326055e-16,
 -2.673959490594900e-18,  1.211562803789039e-20, -5.474872841313930e-23,  2.464443375721357e-25, -1.105009819355481e-27,  8.611905602548391e-02, -4.768302091563913e-04,
  3.167915813145696e-06, -2.122911923399788e-08,  1.380200933961638e-10, -8.693564835421197e-13,  5.329792256457185e-15, -3.194379068266633e-17,  1.877873510695868e-19,
 -1.085515118490962e-21,  6.181872864463645e-24, -3.473497582301660e-26,  7.403946858807588e-02, -6.478609675757819e-04,  6.316669941528461e-06, -5.661219630507021e-08,
  4.734006951508893e-10, -3.758533683730548e-12,  2.863737750269469e-14, -2.108699863637909e-16,  1.508104710485385e-18, -1.051523492014139e-20,  7.168944402653947e-23,
 -4.790109867156016e-25,  5.906901664818933e-02, -8.020780525688075e-04,  1.046158166957864e-05, -1.190446811717493e-07,  1.236610790589968e-09, -1.200326515301878e-11,
  1.103831165430953e-13, -9.707050557463585e-16,  8.218076279038360e-18, -6.731993128142892e-20,  5.356842873489174e-22, -4.153319148720702e-24,  4.377406072022041e-02,
 -8.768474769047114e-04,  1.467093121507811e-05, -2.071956716326378e-07,  2.618468467932840e-09, -3.045456868100503e-11,  3.316284653985151e-13, -3.420426850088441e-15,
  3.369313780605663e-17, -3.189535786503984e-19,  2.915535501243188e-21, -2.583049800124195e-23,  3.017300129268735e-02, -8.484018299878431e-04,  1.781307173338198e-05,
 -3.071117334644955e-07,  4.647996001551256e-09, -6.383505928843791e-11,  8.119468171865061e-13, -9.696281500946734e-15,  1.097789031420898e-16, -1.186907268758193e-18,
  1.232325988915205e-20, -1.234035293314950e-22,  1.937829534369919e-02, -7.334312518537598e-04,  1.902432780786874e-05, -3.949460852733204e-07,  7.069866235302144e-09,
 -1.133646368757673e-10,  1.666665919997484e-12, -2.281790299349523e-14,  2.941417304423125e-16, -3.599638515703102e-18,  4.208516987885698e-20, -4.723797091449600e-22,
  1.162089781117510e-02, -5.720728429954299e-04,  1.808619131647651e-05, -4.468236179553887e-07,  9.363922203019459e-09, -1.736913730459308e-10,  2.926432979510522e-12,
 -4.556515492641813e-14,  6.637144629407407e-16, -9.127202606106582e-18,  1.193286311964184e-19, -1.491243186307223e-21,  6.524093145354325e-03, -4.061746017633875e-04,
  1.545724059618389e-05, -4.497768013657447e-07,  1.093794655979938e-08, -2.328544721419859e-10,  4.463644621425521e-12, -7.850827630888705e-14,  1.283982321922829e-15,
 -1.972100972719122e-17,  2.866433888629793e-19, -3.965953861354118e-21,  3.439563611175059e-03, -2.645970558916605e-04,  1.197982885215038e-05, -4.067833945736582e-07,
  1.138981696802363e-08, -2.763610348368713e-10,  5.989280871781146e-12, -1.182974608893178e-13,  2.160270728738574e-15, -3.686433688660099e-17,  5.927049038342754e-19,
 -9.035267691723547e-21,  1.709127488980218e-03, -1.593140002019306e-04,  8.488249944335654e-06, -3.334932670676507e-07,  1.067474986085044e-08, -2.933594380981571e-10,
  7.146858890537964e-12, -1.576888007129746e-13,  3.199447662913793e-15, -6.037631144780133e-17,  1.068994111792132e-18, -1.787749652920858e-20,  8.038613846360372e-04,
 -8.928702432861790e-05,  5.541396236719980e-06, -2.499250623386140e-07,  9.084909809440294e-09, -2.811387120776007e-10,  7.658995086425090e-12, -1.878621724070315e-13,
  4.215880580838617e-15, -8.760208892764873e-17,  1.701095605829418e-18, -3.108767874004547e-20,  3.596319659697692e-04, -4.690890738524700e-05,  3.359007899188170e-06,
 -1.726186305524859e-07,  7.081447355279234e-09, -2.454132778868058e-10,  7.439389900691806e-12, -2.019347812277696e-13,  4.991042627481878e-15, -1.137399029876819e-16,
  2.413115671328765e-18, -4.801523132251220e-20,  1.539048137067517e-04, -2.327085818325684e-05,  1.905483250476422e-06, -1.107863245345526e-07,  5.098484364074280e-09,
 -1.968369655624069e-10,  6.608027748418290e-12, -1.976316467614596e-13,  5.357978863623015e-15, -1.333991938732007e-16,  3.080971225439455e-18, -6.651414124934233e-20,
  6.340786291696679e-05, -1.098448997201128e-05,  1.019843131109057e-06, -6.662734777098435e-08,  3.419794746967602e-09, -1.463270602095503e-10,  5.415017073050940e-12,
 -1.776809681080343e-13,  5.262851705419168e-15, -1.426184695155510e-16,  3.573000902166543e-18, -8.340729853706171e-20,  2.533158502557590e-05, -4.973882525970842e-06,
  5.193976891521677e-07, -3.787659434734587e-08,  2.155876546028894e-09, -1.017182280472525e-10,  4.130284869684198e-12, -1.480574093565205e-13,  4.772236420563871e-15,
 -1.402343052488039e-16,  3.797445070843660e-18, -9.552773038709304e-20,  9.892383338534216e-06, -2.179472793600069e-06,  2.539912325623233e-07, -2.054001719286104e-08,
  1.289084366487200e-09, -6.672497189532719e-11,  2.959052512591377e-12, -1.153826757864742e-13,  4.030824143718175e-15, -1.279535940986405e-16,  3.731644601820493e-18,
 -1.008096895832844e-19,  3.809814107548907e-06, -9.328485566006966e-07,  1.204012499694492e-07, -1.072744351829210e-08,  7.380835563326894e-10, -4.169537790287388e-11,
  2.009852674021568e-12, -8.487232011985701e-14,  3.200193133272319e-15, -1.093088204135543e-16,  3.420506941490148e-18, -9.887838228287565e-20,  1.460974385848676e-06,
 -3.939132012098839e-07,  5.588561031461151e-08, -5.450053486644084e-09,  4.086861265869094e-10, -2.506248054019419e-11,  1.306669744309657e-12, -5.948095595075798e-14,
  2.410233499165248e-15, -8.822092696442594e-17,  2.950473307377466e-18, -9.092408510438321e-20,  5.635817604154309e-07, -1.658306015130719e-07,  2.566674852679007e-08,
 -2.721504896665647e-09,  2.210808484642499e-10, -1.463592146405738e-11,  8.210680188054646e-13, -4.009520183388675e-14,  1.738010405215576e-15, -6.787435342770825e-17,
  2.416039467305634e-18, -7.905589815825632e-20,  2.210290234372055e-07, -7.035195943816226e-08,  1.178917941827653e-08, -1.349840540083738e-09,  1.180446231049167e-10,
 -8.387154441646663e-12,  5.035202968697909e-13, -2.624177448766572e-14,  1.210904704969716e-15, -5.022072336955890e-17,  1.894204277068355e-18, -6.553062387645750e-20,
  8.906619818634409e-08, -3.040005473376349e-08,  5.472898887998983e-09, -6.718868925056205e-10,  6.283810828551082e-11, -4.762283540974037e-12,  3.041862816575234e-13,
 -1.682637527608392e-14,  8.222275264387203e-16, -3.603421097692843e-17,  1.433263536428448e-18, -5.218358146585615e-20,  3.724396297283440e-08, -1.351446264139103e-08,
  2.593168666995945e-09, -3.388319522710899e-10,  3.365654235011463e-11, -2.703031451373808e-12,  1.825625473228796e-13, -1.065570813201032e-14,  5.483145877802996e-16,
 -2.525624195566884e-17,  1.053919575969761e-18, -4.018396434450441e-20,  1.629496538703334e-08, -6.232306123736762e-09,  1.264233645092736e-09, -1.744666206266312e-10,
  1.827220983625357e-11, -1.544390212523002e-12,  1.095700244569325e-13, -6.705775410960405e-15,  3.611824142373100e-16, -1.738491182880484e-17,  7.568820719760126e-19,
 -3.006025148854964e-20,  7.495031495078388e-09, -2.995806883860253e-09,  6.370801897002723e-10, -9.211321940233690e-11,  1.009402260580907e-11, -8.913202449828274e-13,
  6.596293396475696e-14, -4.204640379921446e-15,  2.355264820302639e-16, -1.177349578437012e-17,  5.316098557139433e-19, -2.186702689161559e-20,  3.616301872083553e-09,
 -1.497835421545262e-09,  3.310544279557851e-10, -4.973227991704265e-11,  5.656555318846150e-12, -5.178125157919735e-13,  3.967816994244154e-14, -2.615533594945729e-15,
  1.513324209044704e-16, -7.804719825371605e-18,  3.631804838063565e-19, -1.537806459554914e-20,  1.798765059055698e-09, -7.655411764869965e-10,  1.743084571040946e-10,
 -2.697147983123645e-11,  3.157536276595340e-12, -2.972417162974991e-13,  2.340032994858327e-14, -1.583276166357622e-15,  9.394117631709975e-17, -4.963897437537631e-18,
  2.364595363557612e-19, -1.024046852609872e-20,  8.696088566616233e-10, -3.771105542591490e-10,  8.766254271105694e-11, -1.384753318894201e-11,  1.654163192390897e-12,
 -1.587952687610248e-13,  1.273993497951985e-14, -8.778852596648687e-16,  5.301469714478244e-17, -2.849399459628962e-18,  1.379804293589929e-19, -6.070725179338960e-21,
  3.199143100590854e-10, -1.401854698989029e-10,  3.296615033916687e-11, -5.267953940481503e-12,  6.364297480772490e-13, -6.176848097502413e-14,  5.008396370993744e-15,
 -3.486702846743467e-16,  2.126498505015910e-17, -1.153888012270478e-18,  5.639283926141615e-20, -2.503178453631371e-21,  9.145653545921197e-02, -3.534442735872870e-04,
  1.438945017603958e-06, -6.093767201232686e-09,  2.648634640060420e-11, -1.168980204672954e-13,  5.196851683128640e-16, -2.315983203007593e-18,  1.031100187587980e-20,
 -4.579755840265415e-23,  2.026534190955921e-25, -8.934807716888530e-28,  8.426085974142826e-02, -4.524696166386397e-04,  2.925864246577753e-06, -1.915323706236201e-08,
  1.218430274766549e-10, -7.515300174482908e-13,  4.513943746206182e-15, -2.651496224423178e-17,  1.528148469411728e-19, -8.662684442174573e-22,  4.839071537847798e-24,
 -2.667683302232328e-26,  7.154496345760612e-02, -5.999217084155296e-04,  5.680405126285880e-06, -4.960372109580142e-08,  4.046515070308451e-10, -3.136966598249690e-12,
  2.335545977712633e-14, -1.681526837837687e-16,  1.176471289676699e-18, -8.028300727487965e-21,  5.358998887422083e-23, -3.507099072473994e-25,  5.601949427739941e-02,
 -7.237805393740480e-04,  9.144280211949177e-06, -1.010442251334951e-07,  1.020980464549690e-09, -9.652610552449837e-12,  8.654827484723164e-14, -7.426999464298591e-16,
  6.139957093912415e-18, -4.914310271091808e-20,  3.822727208138574e-22, -2.898694255658536e-24,  4.048660665402877e-02, -7.687568305968829e-04,  1.241717293481502e-05,
 -1.697709625266249e-07,  2.081797796002933e-09, -2.353277127674699e-11,  2.493733243196917e-13, -2.505504075815854e-15,  2.406233422866623e-17, -2.222370971136604e-19,
  1.983221423613026e-21, -1.716289682821597e-23,  2.704272767262294e-02, -7.194649458305115e-04,  1.453500100495358e-05, -2.419842692955106e-07,  3.546066485842188e-09,
 -4.724565119548794e-11,  5.838297236328135e-13, -6.781568711638942e-15,  7.475410381565864e-17, -7.875661943306445e-19,  7.973816488307900e-21, -7.791486335844664e-23,
  1.672144788296610e-02, -5.984302378688730e-04,  1.489535067470544e-05, -2.979927526843788e-07,  5.155850402931784e-09, -8.007690867731448e-11,  1.142159386805789e-12,
 -1.519057177033266e-14,  1.904376355065769e-16, -2.268619204256994e-18,  2.584016061044660e-20, -2.827739363509769e-22,  9.591303372913402e-03, -4.465250682421063e-04,
  1.351988020384340e-05, -3.213696037401443e-07,  6.500322489095194e-09, -1.166404736751302e-10,  1.904448867466129e-12, -2.877700130082291e-14,  4.072844597644049e-16,
 -5.447615238669094e-18,  6.933584566630792e-20, -8.442232206434400e-22,  5.116304565896508e-03, -3.014503631399116e-04,  1.097327437267736e-05, -3.068773337376688e-07,
  7.195549485329129e-09, -1.480474865549550e-10,  2.747904774644076e-12, -4.686882067924499e-14,  7.442888600794487e-16, -1.111235810782958e-17,  1.571576546148952e-19,
 -2.117566068481601e-21,  2.545814694446312e-03, -1.855603958433981e-04,  8.031980850029488e-06, -2.619539578102928e-07,  7.067431777313343e-09, -1.656347572580244e-10,
  3.473852971072644e-12, -6.650611563742614e-14,  1.178764692653746e-15, -1.954626186185302e-17,  3.056888143941148e-19, -4.536989491854246e-21,  1.185917305408252e-03,
 -1.049041925660301e-04,  5.344026278139007e-06, -2.016314280645271e-07,  6.217401380680835e-09, -1.649964661317051e-10,  3.889146697238140e-12, -8.315836527158641e-14,
  1.637365845849275e-15, -3.002102007303739e-17,  5.169929530305351e-19, -8.417550755109190e-21,  5.193786251254775e-04, -5.485148785924184e-05,  3.256947401935629e-06,
 -1.411087325615280e-07,  4.942162355555631e-09, -1.477031181648646e-10,  3.893572622221699e-12, -9.256074734699805e-14,  2.016011585310551e-15, -4.070687882322410e-17,
  7.689587621458037e-19, -1.368404205806161e-20,  2.149180637492867e-04, -2.671476230935781e-05,  1.832289477257946e-06, -9.052099561368174e-08,  3.579997502210035e-09,
 -1.198776505081212e-10,  3.517804321214811e-12, -9.258357224561406e-14,  2.221803904251408e-15, -4.922108045205607e-17,  1.016285551546185e-18, -1.969936515728297e-20,
  8.451332089343698e-05, -1.220925682508556e-05,  9.590910018471407e-07, -5.366998304897817e-08,  2.383437767858589e-09, -8.898432099802776e-11,  2.894044196529474e-12,
 -8.398286222504264e-14,  2.212213981953384e-15, -5.357921530057692e-17,  1.205089804269316e-18, -2.536121021057770e-20,  3.179266430871708e-05, -5.277406815801928e-06,
  4.709993767831340e-07, -2.966323609091110e-08,  1.471189897446080e-09, -6.094780028842442e-11,  2.187446654021490e-12, -6.971525819370707e-14,  2.008296161926863e-15,
 -5.299224902646715e-17,  1.294078315405531e-18, -2.947481210738911e-20,  1.152864588071054e-05, -2.175915898147656e-06,  2.189388061171692e-07, -1.542149653861119e-08,
  8.496252329332752e-10, -3.887222397725624e-11,  1.533012846799044e-12, -5.344762607292839e-14,  1.677624049076731e-15, -4.806064932345138e-17,  1.270085923752080e-18,
 -3.120994231789009e-20,  4.064608868089511e-06, -8.637366271296422e-07,  9.725224724060955e-08, -7.614141298491879e-09,  4.634950040164302e-10, -2.330807605066233e-11,
  1.005668407263022e-12, -3.820228235801618e-14,  1.301654204909540e-15, -4.034288582901018e-17,  1.149866505840551e-18, -3.038636602281380e-20,  1.406824101888128e-06,
 -3.334498728875653e-07,  4.170644497975558e-08, -3.607040160522018e-09,  2.412888503084949e-10, -1.327167047333651e-11,  6.236978947947850e-13, -2.570752998097410e-14,
  9.471522272883881e-16, -3.164267618173681e-17,  9.693342306938309e-19, -2.745500248456306e-20,  4.831438250629462e-07, -1.265773365722437e-07,  1.745884252836609e-08,
 -1.657524917151880e-09,  1.211659514486431e-10, -7.252573838013785e-12,  3.694971278899236e-13, -1.645345581558116e-14,  6.528164316101688e-16, -2.341757016235059e-17,
  7.681684491265098e-19, -2.323701717826763e-20,  1.665580243711843e-07, -4.780476637439429e-08,  7.218128141041728e-09, -7.474158557863855e-10,  5.935941405368466e-11,
 -3.845985287384324e-12,  2.113718388079888e-13, -1.012137941617832e-14,  4.305740389719257e-16, -1.651547928699330e-17,  5.778262118098107e-19, -1.859699933015804e-20,
  5.835179055800402e-08, -1.818692546446664e-08,  2.983665511930704e-09, -3.347105372655682e-10,  2.870414560888725e-11, -2.001744403871162e-12,  1.180509815428822e-13,
 -6.048447666022036e-15,  2.745840873500190e-16, -1.121136145967109e-17,  4.165701668633178e-19, -1.420564925136241e-20,  2.103935408305086e-08, -7.058588079120385e-09,
  1.248513629567008e-09, -1.506758440234181e-10,  1.386268040372989e-11, -1.034247796151651e-12,  6.507747518396738e-14, -3.548489828264123e-15,  1.710292255479979e-16,
 -7.397175644430065e-18,  2.905238640488695e-19, -1.045016539876422e-20,  7.904074704727986e-09, -2.829357081597279e-09,  5.352687856484858e-10, -6.898230744592070e-11,
  6.761825398937995e-12, -5.361984780223972e-13,  3.577662874234192e-14, -2.063982545799884e-15,  1.050268739642509e-16, -4.786141283899414e-18,  1.976780288035018e-19,
 -7.463189443915815e-21,  3.127886010527882e-09, -1.184109348996369e-09,  2.376112431996319e-10, -3.244500783046084e-11,  3.363458946831481e-12, -2.815062714784648e-13,
  1.978489363309293e-14, -1.199970617918967e-15,  6.407502512088594e-17, -3.058637861486958e-18,  1.321058338185762e-19, -5.206782993236366e-21,  1.313850404563374e-09,
 -5.213444684801846e-10,  1.100074092700136e-10, -1.578419508657395e-11,  1.716908576065827e-12, -1.505294474746422e-13,  1.106408829685620e-14, -7.006358781571870e-16,
  3.900014225943966e-17, -1.937780644912054e-18,  8.699002044057270e-20, -3.558350121712217e-21,  5.862028062532646e-10, -2.416478910925630e-10,  5.313521378017914e-11,
 -7.941685167392979e-12,  8.988452934062526e-13, -8.189204681350265e-14,  6.246494739261217e-15, -4.099571198723607e-16,  2.361993219126898e-17, -1.213233924040338e-18,
  5.623660297845998e-20, -2.372342705888522e-21,  2.737808038461204e-10, -1.161991150811236e-10,  2.637820702323686e-11, -4.069437492613036e-12,  4.750252445240526e-13,
 -4.459229336104517e-14,  3.501049458343512e-15, -2.362670736347448e-16,  1.398348945202780e-17, -7.371172454246563e-19,  3.503194647632102e-20, -1.513774890584510e-21,
  1.264952481841778e-10, -5.478262456701431e-11,  1.271601676220168e-11, -2.005736398277855e-12,  2.392539373992519e-13, -2.293592984636464e-14,  1.837654463834572e-15,
 -1.264654944325440e-16,  7.627594261755850e-18, -4.094683919887037e-19,  1.980515850430434e-20, -8.703899911204186e-22,  4.534940511912138e-11, -1.986159099978232e-11,
  4.667936133402843e-12, -7.454905703687686e-13,  9.001142659285906e-14, -8.731046755674614e-15,  7.075483762398352e-16, -4.923074846933924e-17,  3.000935216551338e-18,
 -1.627537883408948e-19,  7.950108051804428e-21, -3.527188566970699e-22,  9.006532830074636e-02, -3.422181833749163e-04,  1.368287484230199e-06, -5.688033068981163e-09,
  2.426804420689825e-11, -1.051679315218836e-13,  4.592198354984385e-16, -2.010919759138504e-18,  8.799207665103072e-21, -3.842531731774893e-23,  1.671846846468856e-25,
 -7.249983959460008e-28,  8.249638478514999e-02, -4.299500220391019e-04,  2.707244722999133e-06, -1.731835008015345e-08,  1.078383759047461e-10, -6.515793509624627e-13,
  3.835551233736536e-15, -2.208867891190646e-17,  1.248481035625044e-19, -6.942655446903108e-22,  3.805358587618207e-24, -2.058854803617435e-26,  6.923254256277456e-02,
 -5.567539587778761e-04,  5.122031076394037e-06, -4.360228367704748e-08,  3.471570193374563e-10, -2.628933720995671e-12,  1.913357829734017e-14, -1.347445698614376e-16,
  9.225898777984170e-19, -6.163950540264366e-21,  4.029872560535586e-23, -2.583887439851835e-25,  5.326337483754276e-02, -6.552126860799192e-04,  8.023740090661125e-06,
 -8.614678744703195e-08,  8.471235679515614e-10, -7.804332097527718e-12,  6.825709439712545e-14, -5.718090365318188e-16,  4.617867010112895e-18, -3.612637823239850e-20,
  2.748123394046430e-22, -2.038720967129113e-24,  3.759810628024964e-02, -6.770359738162837e-04,  1.056523409568202e-05, -1.399246349539848e-07,  1.665729673797204e-09,
 -1.830953101626277e-11,  1.888975534714733e-13, -1.849570920117823e-15,  1.732479769145953e-17, -1.561723894549581e-19,  1.361067544767668e-21, -1.150943935505098e-23,
  2.438030997219328e-02, -6.139028216927797e-04,  1.194273073698322e-05, -1.921052082240663e-07,  2.727185344729360e-09, -3.526618608036000e-11,  4.235762249229670e-13,
 -4.787648030033570e-15,  5.140295508161253e-17, -5.279038377437485e-19,  5.213828518627662e-21, -4.972878631606630e-23,  1.454523583541383e-02, -4.922814046228745e-04,
  1.176600571326377e-05, -2.269552018123363e-07,  3.797241095045768e-09, -5.714938346231746e-11,  7.911544256467744e-13, -1.022583397176651e-14,  1.247195344440260e-16,
 -1.446771368060513e-18,  1.605974268034859e-20, -1.713952221470348e-22,  7.999378254808938e-03, -3.521860989311390e-04,  1.021784812321926e-05, -2.337931252317612e-07,
  4.566221191532100e-09, -7.929376134565907e-11,  1.255106845321136e-12, -1.841153798297560e-14,  2.532723290690429e-16, -3.295954465126271e-18,  4.085090452226682e-20,
 -4.847456594675690e-22,  4.065246070630958e-03, -2.266408764356599e-04,  7.894302802220710e-06, -2.122549838418096e-07,  4.800283693577193e-09, -9.548473297697171e-11,
  1.716576795457999e-12, -2.840053909691794e-14,  4.380405139722680e-16, -6.358903336994400e-18,  8.752447151946458e-20, -1.148738395149041e-21,  1.914591845456223e-03,
 -1.321811904052694e-04,  5.470799434584110e-06, -1.714107275944586e-07,  4.457173967108227e-09, -1.009204967898094e-10,  2.048788277898851e-12, -3.802652782830628e-14,
  6.542881317309155e-16, -1.054440431775509e-17,  1.604330521451337e-19, -2.318644393664274e-21,  8.385749763778459e-04, -7.036054176811636e-05,  3.426917741052555e-06,
 -1.241776582152914e-07,  3.689092825246498e-09, -9.454946590433632e-11,  2.156522084392197e-12, -4.469099628871627e-14,  8.540253285030339e-16, -1.521528660610853e-17,
  2.548749982873700e-19, -4.040463394053351e-21,  3.429981499596340e-04, -3.442027861186518e-05,  1.954926585260667e-06, -8.135490649285228e-08,  2.745247342984363e-09,
 -7.923565563882442e-11,  2.021091137490717e-12, -4.656681244704452e-14,  9.843756367463344e-16, -1.931452549109525e-17,  3.549263273266625e-19, -6.150306332337795e-21,
  1.316633634738578e-04, -1.558396022796285e-05,  1.023356142619082e-06, -4.858960994328300e-08,  1.852212236294390e-09, -5.991814759391668e-11,  1.701880055069700e-12,
 -4.342387301092775e-14,  1.011682569590080e-15, -2.178549993048606e-17,  4.377096407638415e-19, -8.264421426815962e-21,  4.770640506591640e-05, -6.578585970918789e-06,
  4.954739610600626e-07, -2.667417637937686e-08,  1.142685211684142e-09, -4.124291558660722e-11,  1.299126538138010e-12, -3.657057951556809e-14,  9.357527931188085e-16,
 -2.204210180881321e-17,  4.826959666942112e-19, -9.900552144682405e-21,  1.642729627015197e-05, -2.610025401939025e-06,  2.237470547455328e-07, -1.357596060926758e-08,
  6.502814674620089e-10, -2.607119024183676e-11,  9.071292779937750e-13, -2.807031649036111e-14,  7.861685595997884e-16, -2.019234635440823e-17,  4.804945660381148e-19,
 -1.067494462393509e-20,  5.418060836130465e-06, -9.817820847820135e-07,  9.509848247890500e-08, -6.465175430827929e-09,  3.445429676972606e-10, -1.527698229306376e-11,
  5.848397296374263e-13, -1.982151450793789e-14,  6.055858570409938e-16, -1.690605737804266e-17,  4.358225608631405e-19, -1.045721639976119e-20,  1.727176294117114e-06,
 -3.535481252572692e-07,  3.842074954175165e-08, -2.909642523788490e-09,  1.716585642061857e-10, -8.380542796413286e-12,  3.515772547766447e-13, -1.300282810055833e-14,
  4.318662239892934e-16, -1.306166557623385e-17,  3.636537936553137e-19, -9.395816229143807e-21,  5.376768613773573e-07, -1.231993317392097e-07,  1.491563994533236e-08,
 -1.250953219661449e-09,  8.128624462005458e-11, -4.349684168994050e-12,  1.991369603745527e-13, -8.006026318346153e-15,  2.880306593213840e-16, -9.405780211618361e-18,
  2.819042984534602e-19, -7.818788911877513e-21,  1.653637556218701e-07, -4.203857481429448e-08,  5.630572703769368e-09, -5.198530994163655e-10,  3.700955027927500e-11,
 -2.160315661658162e-12,  1.074619983678353e-13, -4.677344941251078e-15,  1.815808346594150e-16, -6.379104167281636e-18,  2.051087818792086e-19, -6.086577431925661e-21,
  5.089604253050859e-08, -1.423009822109120e-08,  2.093579480401357e-09, -2.114729823067541e-10,  1.640340101358429e-11, -1.039199660971113e-12,  5.590409845199209e-14,
 -2.622787739700181e-15,  1.094175445917101e-16, -4.119128498268198e-18,  1.415532070146434e-19, -4.478115799563820e-21,  1.589719730882226e-08, -4.845724644568332e-09,
  7.773745838423773e-10, -8.535059390032688e-11,  7.170733256929242e-12, -4.903682822141313e-13,  2.838352705474046e-14, -1.428516339260253e-15,  6.375250531145596e-17,
 -2.560787833746933e-18,  9.366738679505183e-20, -3.146517715781886e-21,  5.113797814353881e-09, -1.684464420886022e-09,  2.924177968135023e-10, -3.465699364685229e-11,
  3.133752976231441e-12, -2.299569245618094e-13,  1.424216652853192e-14, -7.649144979007824e-16,  3.633668184989563e-17, -1.549923489275098e-18,  6.006794851193965e-20,
 -2.133258575318156e-21,  1.719459066847673e-09, -6.065987656654245e-10,  1.130388038721424e-10, -1.435549757457287e-11,  1.387462452480656e-12, -1.085475048500350e-13,
  7.149626271504153e-15, -4.073990894135414e-16,  2.048668607067556e-17, -9.230559922968913e-19,  3.771149882055782e-20, -1.409003950617650e-21,  6.127200620577309e-10,
 -2.294082252063375e-10,  4.550309673883084e-11, -6.143186490750179e-12,  6.299192158048095e-13, -5.217145877635204e-14,  3.630073983856598e-15, -2.180582395370618e-16,
  1.153679568569469e-17, -5.458637477804197e-19,  2.337729900014542e-20, -9.139320466356101e-22,  2.339107072824809e-10, -9.209022091748190e-11,  1.926935367729011e-11,
 -2.742140575075112e-12,  2.959092586437754e-13, -2.574611258080249e-14,  1.878536287449418e-15, -1.181247854831657e-16,  6.531079719717151e-18, -3.224133392581194e-19,
  1.438404119186069e-20, -5.848941981007740e-22,  9.605173203040698e-11, -3.939167681923072e-11,  8.613669392889722e-12, -1.280369474877372e-12,  1.441450153356285e-13,
 -1.306574738986800e-14,  9.917312600050469e-16, -6.478083563121465e-17,  3.715519494395024e-18, -1.900189752213323e-19,  8.771182098672090e-21, -3.685353133715975e-22,
  4.194388131038275e-11, -1.774901482652658e-11,  4.016082081945860e-12, -6.175758877756361e-13,  7.186401900875508e-14, -6.725755763126307e-15,  5.265202924324628e-16,
 -3.543269054147062e-17,  2.091450246560405e-18, -1.099625382835066e-19,  5.213049818285075e-21, -2.247255344828278e-22,  1.846027700388387e-11, -7.983348525171669e-12,
  1.850149265648119e-12, -2.913703503007051e-13,  3.470268770714068e-14, -3.321801444398823e-15,  2.657640995781747e-16, -1.826423287002583e-17,  1.100107610442572e-18,
 -5.898026428970852e-20,  2.849201439063398e-21, -1.250655327504381e-22,  6.436853752797291e-12, -2.817574645026500e-12,  6.617848300724895e-13, -1.056239877002379e-13,
  1.274531163719401e-14, -1.235541352166107e-15,  1.000671746435462e-16, -6.958618013035570e-18,  4.239364231709764e-19, -2.297942371965503e-20,  1.121892292846818e-21,
 -4.974890982707538e-23,  8.871792498944119e-02, -3.315384642378816e-04,  1.302293297591217e-06, -5.315990995491731e-09,  2.227049674981021e-11, -9.479174010709989e-14,
  4.066570224858112e-16, -1.750247280134909e-18,  7.528966182947275e-21, -3.233410035691796e-23,  1.383563243608877e-25, -5.903094956368449e-28,  8.081862456182497e-02,
 -4.090949719385422e-04,  2.509362609477133e-06, -1.569238965090973e-08,  9.567946290806692e-11, -5.665185526830168e-13,  3.269442432502273e-15, -1.846574229882116e-17,
  1.023894813746810e-19, -5.587160616289522e-22,  3.005747831963051e-24, -1.596502735443327e-26,  6.708429368794640e-02, -5.177800330871429e-04,  4.630473104095731e-06,
 -3.844467584604816e-08,  2.988812131109215e-10, -2.211860373513488e-12,  1.574278699388693e-14, -1.084819580611871e-16,  7.271591100788050e-19, -4.758139942194078e-21,
  3.047795712698038e-23, -1.915252578498268e-25,  5.076466713127555e-02, -5.949387037094157e-04,  7.066425779754374e-06, -7.375765412450013e-08,  7.062032278918838e-10,
 -6.342721443512380e-12,  5.413389740642664e-14, -4.428882516979902e-16,  3.495330667604494e-18, -2.673715411802116e-20,  1.989665221601569e-22, -1.444575951501155e-24,
  3.504897672066999e-02, -5.988037182653364e-04,  9.034716601775786e-06, -1.159727065854534e-07,  1.340982653824855e-09, -1.433964147521125e-11,  1.440954180006408e-13,
 -1.375541164518781e-15,  1.257172844262597e-17, -1.106495777703815e-19,  9.421067084178401e-22, -7.787126905395157e-24,  2.210216320692163e-02, -5.268904608849414e-04,
  9.877674584575381e-06, -1.536029349758119e-07,  2.113552552258731e-09, -2.653935370180675e-11,  3.099575512225216e-13, -3.410495935836535e-15,  3.567895385435833e-17,
 -3.573158443911910e-19,  3.443719098559164e-21, -3.207150887127231e-23,  1.274846921697083e-02, -4.080949758045235e-04,  9.372453955127040e-06, -1.744013919878839e-07,
  2.823079876561084e-09, -4.119060393713667e-11,  5.536807867657576e-13, -6.957550533007616e-15,  8.258633688799517e-17, -9.332114619293080e-19,  1.009869920269060e-20,
 -1.051418427225849e-22,  6.737958083548891e-03, -2.805340728883802e-04,  7.803213431822962e-06, -1.719440306414616e-07,  3.244120118616837e-09, -5.454095552135215e-11,
  8.372400053269223e-13, -1.192739379682285e-14,  1.595261696494463e-16, -2.020434648009310e-18,  2.439275803252404e-20, -2.821662050084096e-22,  3.270528798622185e-03,
 -1.725008453528101e-04,  5.751625505709096e-06, -1.487339515736381e-07,  3.245524247102832e-09, -6.243512216070428e-11,  1.087488928463584e-12, -1.745814870941606e-14,
  2.615993644529900e-16, -3.693351351502271e-18,  4.948702397977302e-20, -6.328075969570105e-22,  1.461901831777650e-03, -9.556783914072701e-05,  3.782910284442467e-06,
 -1.138951441351853e-07,  2.855114669756387e-09, -6.247153889213162e-11,  1.227894936616619e-12, -2.209976143642761e-14,  3.692136289950285e-16, -5.784046343362255e-18,
  8.563238592296908e-20, -1.205321477833367e-21,  6.037738090243788e-04, -4.802964652248321e-05,  2.236603629955204e-06, -7.784373505785182e-08,  2.228352914316424e-09,
 -5.516447714720799e-11,  1.217673708264845e-12, -2.446077046595831e-14,  4.537185137919681e-16, -7.855539098911032e-18,  1.280138645406086e-19, -1.976082419230099e-21,
  2.313274394098476e-04, -2.204447642381495e-05,  1.197379678563777e-06, -4.785978810121317e-08,  1.555970934012516e-09, -4.337261938786246e-11,  1.070533027477858e-12,
 -2.390651080249336e-14,  4.904913573789913e-16, -9.352199821028732e-18,  1.671842316048971e-19, -2.821021998588474e-21,  8.261552822625461e-05, -9.304081934789366e-06,
  5.847467581928070e-07, -2.667766568612092e-08,  9.800355994094169e-10, -3.062462450272880e-11,  8.418538455842609e-13, -2.082269158492150e-14,  4.709363481198920e-16,
 -9.856665318027240e-18,  1.926944698857216e-19, -3.543653050179318e-21,  2.766056447718917e-05, -3.637537665583967e-06,  2.625259462930603e-07, -1.359152537617989e-08,
  5.614761614365795e-10, -1.958635088877687e-11,  5.974015333285314e-13, -1.630988591766569e-14,  4.053109678170811e-16, -9.283723021872286e-18,  1.979075426888363e-19,
 -3.955546804337245e-21,  8.741115531270870e-06, -1.327906862841789e-06,  1.092637827453540e-07, -6.383495015981593e-09,  2.951655232165391e-10, -1.144768926877210e-11,
  3.860076217742944e-13, -1.159352611569552e-14,  3.155844376145025e-16, -7.887574685638217e-18,  1.828412891305630e-19, -3.961115523062454e-21,  2.628108277431846e-06,
 -4.566718841932816e-07,  4.254566963379996e-08, -2.789653987965146e-09,  1.437161254789480e-10, -6.172233113151018e-12,  2.292540205388101e-13, -7.549761171715524e-15,
  2.244173401499839e-16, -6.102619664766406e-18,  1.534042125705452e-19, -3.592743591061507e-21,  7.588241675608248e-07, -1.494308613341424e-07,  1.565715173183101e-08,
 -1.145943951148464e-09,  6.547281943163809e-11, -3.101102945412161e-12,  1.264134124736242e-13, -4.549255338423669e-15,  1.472041203779939e-16, -4.342333134560474e-18,
  1.180343116823208e-19, -2.980333940751298e-21,  2.126949218214056e-07, -4.704873317526901e-08,  5.507478905331072e-09, -4.474842246120735e-10,  2.822040300306341e-11,
 -1.467946711018128e-12,  6.542306645763119e-14, -2.563762559985287e-15,  9.000826211745239e-17, -2.871288345654576e-18,  8.414700877783077e-20, -2.284155934206736e-21,
  5.859720616477708e-08, -1.443468367901596e-08,  1.875156911988386e-09, -1.681852481478863e-10,  1.164973570309011e-11, -6.625642340577098e-13,  3.215355318094138e-14,
 -1.366908615051700e-15,  5.188405150530577e-17, -1.783883153156031e-18,  5.618487068134293e-20, -1.634573817898291e-21,  1.609121429549064e-08, -4.376558469053514e-09,
  6.266314395990986e-10, -6.167740196676571e-11,  4.667861407391480e-12, -2.888845707885024e-13,  1.519833535135232e-14, -6.980521468788855e-16,  2.853600328591406e-17,
 -1.053586323049927e-18,  3.553792830232708e-20, -1.104360991643304e-21,  4.473465977264620e-09, -1.331821812135933e-09,  2.086787827593126e-10, -2.239928848618599e-11,
  1.841755147039063e-12, -1.233886029197053e-13,  7.003546171006926e-15, -3.459555631019440e-16,  1.516603873073607e-17, -5.988513567833065e-19,  2.154825679223310e-20,
 -7.125753373736388e-22,  1.280355623527454e-09, -4.135831956374409e-10,  7.038549865432805e-11, -8.183766405698853e-12,  7.265650812806623e-13, -5.239200408115894e-14,
  3.191145423928698e-15, -1.686775888171233e-16,  7.891590922806405e-18, -3.317305378102084e-19,  1.267759411536882e-20, -4.442358986379296e-22,  3.838894828098351e-10,
 -1.333334742825227e-10,  2.444961097279108e-11, -3.056878865469613e-12,  2.910541866684250e-13, -2.244648960967227e-14,  1.458349238410896e-15, -8.201764746911248e-17,
  4.072981322442376e-18, -1.813226139686771e-19,  7.323133735603270e-21, -2.706124197779919e-22,  1.226322773244194e-10, -4.537233275841849e-11,  8.888231537674101e-12,
 -1.185477766924551e-12,  1.201462621744689e-13, -9.840015982062366e-15,  6.773662084082922e-16, -4.027400931053442e-17,  2.109943522036289e-18, -9.889670417043607e-20,
  4.197325069786273e-21, -1.626824478563899e-22,  4.233895340231062e-11, -1.652766343820622e-11,  3.427199255829934e-12, -4.834072170493984e-13,  5.172124291663091e-14,
 -4.463313634896061e-15,  3.231086577802385e-16, -2.016491521099840e-17,  1.106887455820430e-18, -5.426559820787096e-20,  2.404965994537761e-21, -9.717293371498777e-23,
  1.592154081764118e-11, -6.493221913073113e-12,  1.411340310339106e-12, -2.085477598018633e-13,  2.334427971151365e-14, -2.104363068736089e-15,  1.588846953334928e-16,
 -1.032595069776746e-17,  5.893708898813138e-19, -3.000114972734621e-20,  1.378646372313217e-21, -5.767804013742121e-23,  6.471351466244829e-12, -2.729582512301274e-12,
  6.154504716104382e-13, -9.431160751112647e-14,  1.093743986885442e-14, -1.020298991161066e-15,  7.962288902167518e-17, -5.342159211524948e-18,  3.144139423200587e-19,
 -1.648504613555545e-20,  7.794276910151469e-22, -3.351375889525487e-23,  2.703492503565985e-12, -1.167346793394384e-12,  2.700725747928109e-13, -4.246014041859652e-14,
  5.048708344290321e-15, -4.824974395281735e-16,  3.854304059754980e-17, -2.644864484659477e-18,  1.590790132167715e-19, -8.516923314745966e-21,  4.108839264442532e-22,
 -1.801258041500627e-23,  9.149003387962922e-13, -4.002394623789408e-13,  9.394535139279594e-14, -1.498418777441686e-14,  1.806914743151646e-15, -1.750521191433651e-16,
  1.416875134848406e-17, -9.846908738504986e-19,  5.995448629775879e-20, -3.247962730492987e-21,  1.584822871626660e-22, -7.023894455722910e-24,  8.741221217608486e-02,
 -3.213693685688473e-04,  1.240578484126432e-06, -4.974315631113389e-09,  2.046842634453514e-11, -8.559386850588589e-14,  3.608554142952118e-16, -1.526925456542025e-18,
  6.458603926995976e-21, -2.728579056334970e-23,  1.148455188512331e-25, -4.822555326108491e-28,  7.922123749367813e-02, -3.897481152080556e-04,  2.329878605186082e-06,
 -1.424806722282380e-08,  8.509371523863235e-11, -4.939039716314578e-13,  2.795406177133292e-15, -1.548920130604791e-17,  8.428076121302390e-20, -4.514276984527649e-22,
  2.384338612432495e-24, -1.243649300722640e-26,  6.508444982969278e-02, -4.825035306018560e-04,  4.196433547870909e-06, -3.399693289146783e-08,  2.581891843209941e-10,
 -1.868004269281134e-12,  1.300689512088461e-14, -8.773380088909091e-17,  5.759221039624647e-19, -3.692103636538862e-21,  2.317818820537487e-23, -1.427953101734762e-25,
  4.849262857167486e-02, -5.417647799527031e-04,  6.245160908741685e-06, -6.340664708514201e-08,  5.913982010034943e-10, -5.180516636869420e-12,  4.316450443783498e-14,
 -3.450184184410328e-16,  2.661958347124867e-18, -1.991711396412295e-20,  1.450416263919154e-22, -1.030943467104892e-24,  3.278999105052025e-02, -5.317485654122203e-04,
  7.762889043489460e-06, -9.663574832984557e-08,  1.085873215141327e-09, -1.130151019134638e-11,  1.106617811581818e-13, -1.030327684302961e-15,  9.191518632001689e-18,
 -7.901672250594918e-20,  6.574996573369121e-22, -5.313984397894237e-24,  2.014173187494916e-02, -4.547049849184945e-04,  8.221050256587279e-06, -1.236584962743458e-07,
  1.650039870634058e-09, -2.012828336195681e-11,  2.286887231149111e-13, -2.450531289774794e-15,  2.498900718120589e-17, -2.441289689130377e-19,  2.296768744691911e-21,
 -2.089254995332725e-23,  1.125380112031853e-02, -3.407769605096314e-04,  7.525637006789142e-06, -1.351618458460942e-07,  2.117792581626643e-09, -2.996983349766411e-11,
  3.913250085294953e-13, -4.782583492980200e-15,  5.526992347289484e-17, -6.085783832205965e-19,  6.422289741918206e-21, -6.525051812637544e-23,  5.728750197177055e-03,
 -2.255556117741333e-04,  6.018573040886979e-06, -1.277768703800234e-07,  2.329906024641496e-09, -3.793898400899441e-11,  5.650200545167936e-13, -7.819880579463318e-15,
  1.017231770297067e-16, -1.254261667858698e-18,  1.475461533779908e-20, -1.664272490055320e-22,  2.662379482209322e-03, -1.328307376726209e-04,  4.241358452387033e-06,
 -1.055277297753298e-07,  2.222637222709943e-09, -4.136581624712806e-11,  6.983066508203523e-13, -1.088083968702743e-14,  1.584440758225508e-16, -2.176167342496002e-18,
  2.839196366237858e-20, -3.538070405284789e-22,  1.132484117242000e-03, -7.008044147895105e-05,  2.653692993617398e-06, -7.679620156771828e-08,  1.856418310833545e-09,
 -3.926360606574882e-11,  7.473795077860717e-13, -1.304692850053115e-14,  2.116914529627917e-16, -3.224400136548467e-18,  4.645943495496000e-20, -6.370028101645812e-22,
  4.422816106294444e-04, -3.334178552886851e-05,  1.484563708846051e-06, -4.963493784943440e-08,  1.369314590110209e-09, -3.274825394652199e-11,  6.996932093610097e-13,
 -1.362660924811897e-14,  2.453766673372490e-16, -4.129158609019706e-18,  6.546819791671437e-20, -9.841729643813534e-22,  1.591910253215226e-04, -1.439735445121971e-05,
  7.477785295085396e-07, -2.870715213200188e-08,  8.992232412675306e-10, -2.420912118368198e-11,  5.782396554361286e-13, -1.251626531154262e-14,  2.492553179265122e-16,
 -4.618568023390457e-18,  8.032201785754670e-20, -1.319815875657937e-21,  5.305052492553152e-05, -5.680356256025535e-06,  3.415658257342270e-07, -1.497058421392382e-08,
  5.299435930442130e-10, -1.599502914459128e-11,  4.255194154727566e-13, -1.020227729237157e-14,  2.239807909496187e-16, -4.556192138794052e-18,  8.666429765951784e-20,
 -1.552224628219665e-21,  1.645977746247204e-05, -2.062387909561142e-06,  1.425573452694112e-07, -7.095091958051590e-09,  2.825735000801485e-10, -9.524819007915706e-12,
  2.812526700360628e-13, -7.445774736795842e-15,  1.796739042061747e-16, -4.001229751140737e-18,  8.302096780574042e-20, -1.616686291809465e-21,  4.786503872467133e-06,
 -6.945244660168025e-07,  5.481415997703262e-08, -3.081886762597226e-09,  1.375035642887756e-10, -5.157019401761588e-12,  1.684627015871256e-13, -4.909465576425534e-15,
  1.298505386671188e-16, -3.157275826838267e-18,  7.127891763389766e-20, -1.505435783806626e-21,  1.315028409050060e-06, -2.188641315925509e-07,  1.959508964933130e-08,
 -1.238317516179296e-09,  6.163474991634496e-11, -2.562604589039272e-12,  9.230589869687469e-14, -2.952402713910422e-15,  8.535100641854146e-17, -2.259938643036934e-18,
  5.537496123951651e-20, -1.265414398266611e-21,  3.445770414254905e-07, -6.519474420085050e-08,  6.579700122002332e-09, -4.650185280880545e-10,  2.571124781644762e-11,
 -1.180710106411638e-12,  4.674011219700094e-14, -1.635788436619525e-15,  5.154068064520637e-17, -1.482157819438639e-18,  3.931628286266395e-20, -9.697165965907175e-22,
  8.708020196844790e-08, -1.857024619499475e-08,  2.099463665890157e-09, -1.650975136465656e-10,  1.009633969250290e-11, -5.101298739494563e-13,  2.211658801670152e-14,
 -8.442258601347532e-16,  2.890517172106784e-17, -9.002278306812005e-19,  2.578254976646001e-20, -6.845879712557738e-22,  2.150268279661357e-08, -5.125421802561634e-09,
  6.450058837276463e-10, -5.614045076058722e-11,  3.779934710582616e-12, -2.092788192455780e-13,  9.900073963176636e-15, -4.107590781756601e-16,  1.523340949266924e-17,
 -5.122487427535560e-19,  1.579374594086809e-20, -4.501963160510721e-22,  5.266543417447612e-09, -1.391469873322251e-09,  1.936471234644490e-10, -1.855189070812308e-11,
  1.368517697694227e-12, -8.265899047637888e-14,  4.249221333905798e-15, -1.909054068048606e-16,  7.641354561689816e-18, -2.764962940759510e-19,  9.147830716704663e-21,
 -2.790575072351618e-22,  1.301368075617164e-09, -3.778965273024338e-10,  5.776021949282859e-11, -6.054447115399223e-12,  4.867001014791607e-13, -3.191317319106191e-14,
  1.774682210750279e-15, -8.596843132500232e-17,  3.698998714227191e-18, -1.434741408833835e-19,  5.074971208305940e-21, -1.650945073055258e-22,  3.305760978915869e-10,
 -1.045852840020399e-10,  1.742845570900393e-11, -1.985818444130501e-12,  1.729296229319850e-13, -1.224218612512724e-14,  7.326701936514283e-16, -3.808306032994480e-17,
  1.753365893545253e-18, -7.258153475077767e-20,  2.733314043342036e-21, -9.443884865281930e-23,  8.807057578637900e-11, -3.008204597844806e-11,  5.422332515411434e-12,
 -6.667703160602898e-13,  6.248278411223714e-14, -4.746044825497203e-15,  3.039051125430109e-16, -1.685608066654532e-17,  8.260328468333870e-19, -3.630938997697372e-20,
  1.448696173967889e-21, -5.291378865924612e-23,  2.510835658004469e-11, -9.171673850178271e-12,  1.772860408729277e-12, -2.334037076615847e-13,  2.336154463697668e-14,
 -1.890584088525424e-15,  1.286646093915929e-16, -7.566796352313604e-18,  3.922963615811370e-19, -1.820432831263702e-20,  7.652386983138994e-22, -2.938847083288798e-23,
  7.800070779239281e-12, -3.017007895738872e-12,  6.195450139658879e-13, -8.655759851720148e-14,  9.176365932481508e-15, -7.849326033305633e-16,  5.634546505259386e-17,
 -3.488177773887744e-18,  1.899969589353060e-19, -9.245922451907409e-21,  4.068656765124122e-22, -1.632817855752057e-23,  2.672169735936222e-12, -1.083199114771586e-12,
  2.339120733722154e-13, -3.434357879645066e-14,  3.820617206672589e-15, -3.423669827992764e-16,  2.570261727897636e-17, -1.661316998224612e-18,  9.432726772850426e-20,
 -4.777568407296583e-21,  2.184902319217003e-22, -9.098923736983296e-24,  1.006066548813696e-12, -4.228650669861925e-13,  9.498128712408812e-14, -1.450002270797630e-14,
  1.675438115488909e-15, -1.557428257410632e-16,  1.211285305100354e-17, -8.100507473702601e-19,  4.752706569394915e-20, -2.484435374305830e-21,  1.171288108453765e-22,
 -5.022433508246111e-24,  3.974250661517251e-13, -1.713176289602595e-13,  3.956228557270479e-14, -6.208486193451261e-15,  7.369008732470471e-16, -7.030301594494605e-17,
  5.606628788586873e-18, -3.841162353418977e-19,  2.306754224457028e-20, -1.233176411521549e-21,  5.940725300891909e-23, -2.600749643897252e-24,  1.302294195871153e-13,
 -5.693549730894709e-14,  1.335471113881432e-14, -2.128564131221438e-15,  2.565018346056207e-16, -2.483284345200076e-17,  2.008651344782779e-18, -1.395065429503081e-19,
  8.488788883613759e-21, -4.595914968551956e-22,  2.241227134049614e-23, -9.927389949930693e-25,  8.614621360167816e-02, -3.116780675501782e-04,  1.182796659050532e-06,
 -4.660059400581416e-09,  1.883980816597093e-11, -7.742390813780853e-14,  3.208533741803191e-16, -1.335120002353982e-18,  5.554138457182015e-21, -2.308938611481426e-23,
  9.560770089167459e-26, -3.952766865028133e-28,  7.769847195258875e-02, -3.717705758645351e-04,  2.166756236236419e-06, -1.296208936508966e-08,  7.585291741126633e-11,
 -4.317282195174676e-13,  2.397148485684785e-15, -1.303485071775155e-17,  6.962203238828652e-20, -3.661498135089252e-22,  1.899239460395870e-24, -9.730736196884727e-27,
  6.321909041224631e-02, -4.504964207113759e-04,  3.812076377927554e-06, -3.014862490512820e-08,  2.237620375298611e-10, -1.583351517271006e-12,  1.078958811233212e-14,
 -7.126360545900487e-17,  4.582850248995804e-19, -2.879315891623605e-21,  1.772101621305237e-23, -1.070656371681064e-25,  4.642089027795191e-02, -4.946936757597169e-04,
  5.537809981412184e-06, -5.471999152453312e-08,  4.974119218454969e-10, -4.251493658053966e-12,  3.459625208901672e-14, -2.702713065022284e-16,  2.039299341041116e-18,
 -1.492983365992968e-20,  1.064308572837415e-22, -7.408516985982562e-25,  3.078025414814810e-02, -4.740048986190506e-04,  6.700486899375264e-06, -8.093495827671855e-08,
  8.842262992660366e-10, -8.961038656420585e-12,  8.553647154184247e-14, -7.770611045882344e-16,  6.768937095597760e-18, -5.685705272970251e-20,  4.625252402481431e-22,
 -3.656369091361407e-24,  1.844564627869574e-02, -3.944521469445064e-04,  6.883173398240611e-06, -1.002019750700296e-07,  1.297236399482624e-09, -1.538030086128049e-11,
  1.700644130223276e-13, -1.775423798125557e-15,  1.765420137458524e-17, -1.683073735041749e-19,  1.546217868801898e-21, -1.374255958264071e-23,  1.000158825990051e-02,
 -2.865260446061098e-04,  6.088759529703657e-06, -1.056042275337524e-07,  1.602420029314015e-09, -2.200372613966329e-11,  2.792034016337479e-13, -3.320024263033858e-15,
  3.736797107891149e-17, -4.010805567157910e-19,  4.128893897791879e-21, -4.094918085271246e-23,  4.913938139968781e-03, -1.829598076552076e-04,  4.686079919484901e-06,
 -9.590014980423824e-08,  1.690733390153938e-09, -2.667612935561588e-11,  3.855833820906690e-13, -5.186216566175155e-15,  6.563712383948915e-17, -7.881522475742533e-19,
  9.036549148056903e-21, -9.941992195937208e-23,  2.191675626481912e-03, -1.034180791536462e-04,  3.163786979753177e-06, -7.576760647122694e-08,  1.540916862645098e-09,
 -2.775472958326604e-11,  4.542510955745249e-13, -6.872129085019702e-15,  9.727639219007173e-17, -1.300096222072085e-18,  1.652049598587304e-20, -2.006734053653776e-22,
  8.894263938243670e-04, -5.208608343828390e-05,  1.887288696985456e-06, -5.251279529996112e-08,  1.224470462224338e-09, -2.504046074168137e-11,  4.617239562821017e-13,
 -7.819879495568938e-15,  1.232544751544431e-16, -1.825726480215113e-18,  2.560759383941778e-20, -3.420753642522005e-22,  3.293621743119663e-04, -2.351973367698984e-05,
  1.001420774518254e-06, -3.216858407875571e-08,  8.554331148842337e-10, -1.976805511939803e-11,  4.088954775149450e-13, -7.721644747073398e-15,  1.350068606138773e-16,
 -2.208458601967169e-18,  3.407274071922212e-20, -4.988810786355338e-22,  1.116866278378366e-04, -9.580911750321206e-06,  4.757921684000263e-07, -1.754372462921948e-08,
  5.295101211388240e-10, -1.376951196754298e-11,  3.182944403661129e-13, -6.678563392850289e-15,  1.291044800239775e-16, -2.324961688097495e-18,  3.933838356831762e-20,
 -6.294869593322449e-22,  3.483184951173573e-05, -3.543409589783744e-06,  2.037999633219234e-07, -8.580098283739784e-09,  2.926490638203677e-10, -8.531190533065484e-12,
  2.196340768192782e-13, -5.104407310751651e-15,  1.087773276373050e-16, -2.150521341337946e-18,  3.979883206166491e-20, -6.942318107769078e-22,  1.004395957406027e-05,
 -1.198038266972601e-06,  7.927607479559849e-08, -3.791832502107576e-09,  1.455572567432469e-10, -4.740049838436383e-12,  1.354821912481171e-13, -3.477469807210551e-15,
  8.147410911872681e-17, -1.763797123630532e-18,  3.561591770757028e-20, -6.756520131429699e-22,  2.695226760740352e-06, -3.731541114232536e-07,  2.822985662585238e-08,
 -1.526742524499693e-09,  6.570305912931614e-11, -2.382102194271853e-12,  7.536436500682788e-14, -2.130551639975747e-15,  5.473984427727250e-17, -1.294526889152836e-18,
  2.845634995612951e-20, -5.857906939294528e-22,  6.783518128342385e-07, -1.080110755773767e-07,  9.285531104292901e-09, -5.651971884371924e-10,  2.716412340658565e-11,
 -1.092858659593551e-12,  3.815916505902745e-14, -1.184959771635533e-15,  3.330323040816428e-17, -8.583231805624382e-19,  2.049360914112682e-20, -4.568021901419147e-22,
  1.616573491777157e-07, -2.934887359929716e-08,  2.850250427999306e-09, -1.943619412939479e-10,  1.039243392623218e-11, -4.624165188423468e-13,  1.776660587615721e-14,
 -6.043737960268356e-16,  1.853360614745147e-17, -5.193316440915994e-19,  1.343768548097633e-20, -3.236152063850911e-22,  3.689304170027298e-08, -7.574449426435577e-09,
  8.261285842244594e-10, -6.281705941624405e-11,  3.722011160618864e-12, -1.825316579880124e-13,  7.692957050441799e-15, -2.858575735640760e-16,  9.539341628126462e-18,
 -2.898887903048067e-19,  8.109275368053912e-21, -2.105122736327889e-22,  8.172531751366542e-09, -1.882239006710856e-09,  2.291867845679286e-10, -1.933776233475411e-11,
  1.264400702955537e-12, -6.808961793971429e-14,  3.137336597347983e-15, -1.269481444661760e-16,  4.596736505875485e-18, -1.510771921993540e-19,  4.557039912834904e-21,
 -1.271955429355693e-22,  1.785281565838512e-09, -4.575375749031113e-10,  6.181209415012506e-11, -5.757372880777077e-12,  4.135352200951795e-13, -2.435436936250229e-14,
  1.222262682143650e-15, -5.367053272271695e-17,  2.101847926707344e-18, -7.448121949842539e-20,  2.415365168585332e-21, -7.228187929295775e-23,  3.916874513156612e-10,
 -1.107813929530511e-10,  1.649658954437044e-11, -1.686662126794222e-12,  1.324170981439748e-13, -8.489691884220332e-15,  4.621180942804000e-16, -2.193385764301465e-17,
  9.255558668063671e-19, -3.523730777676444e-20,  1.224374849617977e-21, -3.915560268780688e-23,  8.811172642929476e-11, -2.726616001556029e-11,  4.443734816548308e-12,
 -4.956202646116594e-13,  4.228957550467075e-14, -2.936290673272192e-15,  1.725125547343735e-16, -8.810174378451955e-18,  3.988483373603038e-19, -1.624657978601284e-20,
  6.024515638254313e-22, -2.051011114781661e-23,  2.078778675590612e-11, -6.974567274867539e-12,  1.234398018746952e-12, -1.491333343354563e-13,  1.374115073076401e-14,
 -1.027056429424303e-15,  6.476205111707868e-17, -3.539653542864710e-18,  1.710430160616961e-19, -7.418139769927882e-21,  2.921923067619816e-22, -1.054188280655385e-23,
  5.265773856361579e-12, -1.897187708884746e-12,  3.615096424901859e-13, -4.693679420876971e-14,  4.635675861752909e-15, -3.703969865826659e-16,  2.490217479779648e-17,
 -1.447543755603744e-18,  7.421591227472605e-20, -3.407447313590650e-21,  1.417814809027042e-22, -5.392146617834051e-24,  1.464323945260840e-12, -5.607810574510635e-13,
  1.139533729275271e-13, -1.575803476459718e-14,  1.654163613151694e-15, -1.401623094910725e-16,  9.970729666155536e-18, -6.119370225894980e-19,  3.305655429626342e-20,
 -1.595945340013055e-21,  6.969815116737208e-23, -2.776868978394713e-24,  4.545152640670120e-13, -1.830351769282152e-13,  3.924791683270319e-14, -5.722715125095054e-15,
  6.323941461397194e-16, -5.630674977429106e-17,  4.201236037575389e-18, -2.699583801048148e-19,  1.524174634850282e-20, -7.678226375049399e-22,  3.493338353443523e-23,
 -1.447610493472120e-24,  1.576999013599459e-13, -6.603067066994396e-14,  1.476994483990564e-14, -2.245586498971071e-15,  2.584441073273943e-16, -2.393253811419576e-17,
  1.854539797916631e-18, -1.235879387013940e-19,  7.226729347690765e-21, -3.765524220716990e-22,  1.769765097416510e-23, -7.566204776260453e-25,  5.866254804852597e-14,
 -2.524166266191293e-14,  5.817406783421942e-15, -9.111126665136594e-16,  1.079338092653657e-16, -1.027810505200108e-17,  8.182032788878780e-19, -5.595923064578191e-20,
  3.354969119118122e-21, -1.790679739396085e-22,  8.613187412810257e-24, -3.765143302484626e-25,  1.856607601473727e-14, -8.111552961854927e-15,  1.901216828657054e-15,
 -3.028019896640663e-16,  3.646220095577959e-17, -3.527499763427404e-18,  2.851291581436144e-19, -1.978958538528682e-20,  1.203375895308794e-21, -6.511022762901105e-23,
  3.173165268387392e-24, -1.404688135777331e-25,  8.491807899618556e-02, -3.024343677289203e-04,  1.128634789452495e-06, -4.370604261023902e-09,  1.736540739084981e-11,
 -7.015268618816560e-14,  2.858383801341176e-16, -1.169981661635335e-18,  4.787766723576266e-21, -1.959115963220455e-23,  7.981479788586248e-26, -3.250389716492221e-28,
  7.624510091730805e-02, -3.550387107870940e-04,  2.018217900367652e-06, -1.181451303344738e-08,  6.776535687283090e-11, -3.783362878286300e-13,  2.061481613902778e-15,
 -1.100398344378220e-17,  5.771092426045944e-20, -2.980903552913407e-22,  1.518897883857450e-24, -7.646302483221213e-27,  6.147588951871979e-02, -4.213883989453430e-04,
  3.470772813366570e-06, -2.680834872016126e-08,  1.945310575780104e-10, -1.346779920408159e-12,  8.984860513923798e-15, -5.812886813992942e-17,  3.663304504797597e-19,
 -2.256355420052460e-21,  1.361863751363740e-23, -8.071448390667778e-26,  4.452674465569675e-02, -4.528886408862923e-04,  4.926255052121829e-06, -4.739897264546105e-08,
  4.201082789709279e-10, -3.505089414277988e-12,  2.786696992410460e-14, -2.128514028716648e-16,  1.571205304937430e-18, -1.125907470654754e-20,  7.859648838129084e-23,
 -5.359507292626775e-25,  2.898561374230898e-02, -4.240583030007025e-04,  5.808580942040558e-06, -6.811654440305265e-08,  7.238908179525847e-10, -7.146550400925917e-12,
  6.652727927012993e-14, -5.899264757089680e-16,  5.019681147235278e-18, -4.121204355578522e-20,  3.278652042982816e-22, -2.535942190418366e-24,  1.697082214972513e-02,
 -3.438656230188044e-04,  5.795808179290313e-06, -8.170109807375854e-08,  1.026726809344179e-09, -1.183665910076431e-11,  1.274294646234723e-13, -1.296587215283265e-15,
  1.257667180068488e-17, -1.170463622961585e-19,  1.050364749418011e-21, -9.124273453114803e-24,  8.945452345906699e-03, -2.424803409000778e-04,  4.961917158136717e-06,
 -8.315135795647675e-08,  1.222470111651206e-09, -1.629553352192995e-11,  2.010212866503190e-13, -2.326614671672329e-15,  2.551355940204769e-17, -2.670270495862011e-19,
  2.682415615856782e-21, -2.597693327965731e-23,  4.250387394761198e-03, -1.496520059366401e-04,  3.681485675233597e-06, -7.265921106325012e-08,  1.239112295575400e-09,
 -1.895127258973802e-11,  2.659611312813352e-13, -3.477783665896116e-15,  4.283776870929174e-17, -5.010919281721502e-19,  5.601347646866279e-21, -6.012571549194174e-23,
  1.823406135270935e-03, -8.136413871119589e-05,  2.385939708094796e-06, -5.502095646532330e-08,  1.080906257726590e-09, -1.884906767152049e-11,  2.991933661310724e-13,
 -4.396077630225063e-15,  6.050818931056867e-17, -7.871472127954301e-19,  9.744567627728381e-21, -1.154071185768241e-22,  7.077122350481307e-04, -3.920982138320049e-05,
  1.359922260079166e-06, -3.639279411731845e-08,  8.188087537170861e-10, -1.619520642609798e-11,  2.893599768072046e-13, -4.755779985696533e-15,  7.283491568926454e-17,
 -1.049447277514467e-18,  1.433163312789706e-20, -1.865614101122771e-22,  2.491539884156798e-04, -1.684669728258924e-05,  6.860180088354067e-07, -2.117692663973248e-08,
  5.429366237328744e-10, -1.212587320781075e-11,  2.428731589406090e-13, -4.448142317824479e-15,  7.552732118943462e-17, -1.201201664055627e-18,  1.803642998625579e-20,
 -2.572479072898289e-22,  7.982111912302990e-05, -6.491164185531236e-06,  3.082015734310986e-07, -1.091570311235326e-08,  3.174837064087512e-10, -7.975286800924781e-12,
  1.784378351518176e-13, -3.629734011868899e-15,  6.811856047316234e-17, -1.192317196461893e-18,  1.962919262338122e-20, -3.059119694943771e-22,  2.336428443503585e-05,
 -2.256576121133434e-06,  1.241127002584649e-07, -5.018637166707168e-09,  1.649256197075303e-10, -4.643583345701149e-12,  1.156911231848030e-13, -2.606252272185356e-15,
  5.391280245042299e-17, -1.035889080822258e-18,  1.865212292607432e-20, -3.168690855999746e-22,  6.279707698116960e-06, -7.124483012454097e-07,  4.511226427157465e-08,
 -2.073125864099752e-09,  7.669035931916437e-11, -2.412408785106256e-12,  6.673556396826262e-14, -1.660581234936105e-15,  3.777065709178703e-17, -7.948089057021967e-19,
  1.561775603341887e-20, -2.886006219960919e-22,  1.559408555274690e-06, -2.057979155068792e-07,  1.491467970347525e-08, -7.755596868076931e-10,  3.218166282360841e-11,
 -1.127582165640728e-12,  3.454177793387419e-14, -9.470360219829321e-16,  2.363126388224701e-17, -5.434315335509230e-19,  1.162913096128824e-20, -2.332863042444216e-22,
  3.605100644807217e-07, -5.485383689407349e-08,  4.524511746609326e-09, -2.651002337174493e-10,  1.229672288732588e-11, -4.784983254188711e-13,  1.618946232472701e-14,
 -4.879102401401443e-16,  1.332682954688343e-17, -3.342181043590012e-19,  7.773497769349277e-21, -1.689619713648246e-22,  7.831818439007317e-08, -1.362619446272619e-08,
  1.272195094598256e-09, -8.363952219917257e-11,  4.321995169398757e-12, -1.862270026856954e-13,  6.940783059608539e-15, -2.293829607755577e-16,  6.843025624128372e-18,
 -1.867608329625390e-19,  4.711813674962244e-21, -1.107522202158510e-22,  1.617085503378406e-08, -3.191886644268615e-09,  3.354882532245541e-10, -2.464371253799953e-11,
  1.413622190159110e-12, -6.723937976966643e-14,  2.753020619906087e-15, -9.952118991099402e-17,  3.235091901062072e-18, -9.587382203675906e-20,  2.618204328110960e-21,
 -6.641650240219856e-23,  3.217360131362287e-09, -7.149335221134921e-10,  8.412771231028419e-11, -6.873964657324497e-12,  4.360660120669451e-13, -2.282112225306312e-14,
  1.023403060694252e-15, -4.035657577567295e-17,  1.425791467005046e-18, -4.577118652113067e-20,  1.349866971253768e-21, -3.687222360454314e-23,  6.270586602563587e-10,
 -1.556512111564834e-10,  2.038701955248519e-11, -1.844108789598527e-12,  1.288415718347539e-13, -7.391587500240668e-15,  3.618399902952500e-16, -1.551665778728431e-17,
  5.940811355976546e-19, -2.060178566191604e-20,  6.544115946482777e-22, -1.919930082819631e-23,  1.220635194727966e-10, -3.357596249476446e-11,  4.864750804059640e-12,
 -4.845865395233683e-13,  3.711493931290705e-14, -2.324364502097653e-15,  1.237297288196135e-16, -5.749150365914469e-18,  2.377276725479208e-19, -8.876786781326887e-21,
  3.027621782190887e-22, -9.511726437660167e-24,  2.427005461484499e-11, -7.335803129842238e-12,  1.167761401026987e-12, -1.273408821241532e-13,  1.063501395310887e-14,
 -7.235101972109298e-16,  4.168998999126803e-17, -2.090038940910310e-18,  9.296094090360551e-20, -3.723188797855493e-21,  1.358467882847161e-22, -4.553793291451471e-24,
  5.054561960357921e-12, -1.663724794253236e-12,  2.887787369241189e-13, -3.424024957941425e-14,  3.098884113316346e-15, -2.276990929112296e-16,  1.412598206431625e-17,
 -7.601764331454797e-19,  3.619241598521610e-20, -1.547564047980100e-21,  6.013510555342425e-23, -2.141614789728034e-24,  1.132699936137677e-12, -4.020886535113000e-13,
  7.545156252837498e-14, -9.651651396068957e-15,  9.397510966742436e-16, -7.407252344411117e-17,  4.915704061530206e-18, -2.822238412743938e-19,  1.429922226901698e-20,
 -6.491173421004704e-22,  2.671799419891620e-23, -1.005645112869016e-24,  2.804771388236642e-13, -1.062611116613480e-13,  2.134947863678275e-14, -2.919871050695501e-15,
  3.032698296741483e-16, -2.543723678661330e-17,  1.792044790727603e-18, -1.089679909738390e-19,  5.834417953908653e-21, -2.793015611327689e-22,  1.209902048412365e-23,
 -4.783161240781822e-25,  7.842902593036745e-14, -3.135846532203866e-14,  6.672940050956371e-15, -9.657129736463683e-16,  1.059490160958041e-16, -9.368326128452683e-18,
  6.943847250998553e-19, -4.433699994245124e-20,  2.488111969925000e-21, -1.246163744063667e-22,  5.638209855729522e-24, -2.324053463794804e-25,  2.494032642709496e-14,
 -1.039935537047021e-14,  2.315683977170397e-15, -3.505081631242419e-16,  4.016677005240295e-17, -3.704194440028798e-18,  2.859036800844435e-19, -1.898061776764740e-20,
  1.105849499610376e-21, -5.742034873135822e-23,  2.689707768852094e-24, -1.146252064855761e-25,  8.697378939284219e-15, -3.734968638839517e-15,  8.589281043337944e-16,
 -1.342349934785359e-16,  1.586880677362023e-17, -1.508081627069565e-18,  1.198204651777595e-19, -8.179599336848596e-21,  4.895204355323103e-22, -2.608269433087464e-23,
  1.252505245260886e-24, -5.466480006901981e-26,  2.651253556817131e-15, -1.157511197022804e-15,  2.710862250894460e-16, -4.314078012167074e-17,  5.190771696907588e-18,
 -5.017927350306112e-19,  4.052999723237646e-20, -2.810985132048912e-21,  1.708123537893631e-22, -9.235751824338117e-24,  4.498103690472288e-25, -1.989938068195606e-26,
  8.372607404669224e-02, -2.936104592915407e-04,  1.077809494336615e-06, -4.103620274200091e-09,  1.602838814634138e-11, -6.366899666232541e-14,  2.551220220160158e-16,
 -1.027468366860388e-18,  4.136666880963973e-21, -1.666698854892016e-23,  6.680777084596364e-26, -2.681528625190604e-28,  7.485636494266976e-02, -3.394421901442469e-04,
  1.882707946507755e-06, -1.078821408398651e-08,  6.066946756963198e-11, -3.323588969999387e-13,  1.777691247400684e-15, -9.317835283550071e-18,  4.799684725187727e-20,
 -2.435584599812424e-22,  1.219431836467466e-24, -6.033330575631801e-27,  5.984390294707667e-02, -3.948580783688984e-04,  3.166895230851874e-06, -2.390015080851872e-08,
  1.696265300615277e-10, -1.149421378361877e-12,  7.509868057833212e-15, -4.760738701969027e-17,  2.941081927605392e-19, -1.776462740134276e-21,  1.051813488547929e-23,
 -6.117004926634829e-26,  4.279056243404971e-02, -4.156445830124596e-04,  4.395596825543443e-06, -4.120364468053202e-08,  3.562396653658240e-10, -2.902472646447857e-12,
  2.255416943233233e-14, -1.684945657963922e-16,  1.217214873457299e-18, -8.540359197582050e-21,  5.839862552578157e-23, -3.902254886166106e-25,  2.737740529788392e-02,
 -3.806726770451117e-04,  5.056225620045663e-06, -5.759629405627409e-08,  5.956767071748892e-10, -5.731245331835468e-12,  5.205197217887318e-14, -4.507067963097489e-16,
  3.747498589587499e-18, -3.008309806370154e-20,  2.341296744071018e-22, -1.772420677710377e-24,  1.568225513646341e-02, -3.011585108631017e-04,  4.906654982583260e-06,
 -6.701273904279791e-08,  8.178555465844449e-10, -9.172149839283466e-12,  9.617948069154106e-14, -9.541683233987461e-16,  9.031607949665833e-18, -8.208134487421704e-20,
  7.197544278121788e-22, -6.112801214861182e-24,  8.049040944710078e-03, -2.064669267031697e-04,  4.071495296521511e-06, -6.595758623683868e-08,  9.399694213211385e-10,
 -1.216870195125528e-11,  1.459966343843863e-13, -1.645325722927941e-15,  1.758497906295284e-17, -1.795249073066096e-19,  1.760366930505732e-21, -1.665127167578358e-23,
  3.705601533119594e-03, -1.233774305862418e-04,  2.917061310342153e-06, -5.554932552109257e-08,  9.167649662428766e-10, -1.359708075086840e-11,  1.853433208949567e-13,
 -2.357054144449370e-15,  2.826609214048553e-17, -3.221990985682474e-19,  3.512468054626255e-21, -3.679597073553301e-23,  1.532323274938908e-03, -6.464992914932687e-05,
  1.818173082683173e-06, -4.039038399833267e-08,  7.667897331800489e-10, -1.295043237305701e-11,  1.994346516239627e-13, -2.846907328531210e-15,  3.811422384902264e-17,
 -4.827550230816097e-19,  5.823836424284360e-21, -6.726547903366472e-23,  5.701506558859688e-04, -2.987695367047879e-05,  9.922345876554864e-07, -2.554670950827104e-08,
  5.547911370533635e-10, -1.061645530891911e-11,  1.838532078453411e-13, -2.933187760921743e-15,  4.366012386433388e-17, -6.120666436518868e-19,  8.140175387035303e-21,
 -1.032819666111805e-22,  1.913205858475505e-04, -1.224393255539598e-05,  4.769347223085128e-07, -1.415127342863952e-08,  3.498787393885293e-10, -7.553863204235080e-12,
  1.465381837220575e-13, -2.603412785096874e-15,  4.293716440747575e-17, -6.640538367830398e-19,  9.705742596643111e-21, -1.348682266034891e-22,  5.806574002830603e-05,
 -4.473915662448139e-06,  2.030968451444321e-07, -6.909909777409467e-09,  1.936933306458758e-10, -4.700883727178177e-12,  1.018144117449954e-13, -2.008109585659487e-15,
  3.659007970974450e-17, -6.225731957357053e-19,  9.973684289239694e-21, -1.513957296658039e-22,  1.599749221047888e-05, -1.465897775074782e-06,  7.708560706664240e-08,
 -2.993639145482573e-09,  9.478692712726494e-11, -2.577661602080864e-12,  6.215032363193644e-14, -1.357205588318743e-15,  2.725321578431175e-17, -5.089411715569134e-19,
  8.916229006713296e-21, -1.475222338047814e-22,  4.019394928103440e-06, -4.333714934833948e-07,  2.624878787268438e-08, -1.158694538053384e-09,  4.130011093413069e-11,
 -1.254804425063348e-12,  3.359327932122885e-14, -8.102976108314226e-16,  1.789152214456213e-17, -3.659364594646952e-19,  6.996694619732689e-21, -1.259334587697342e-22,
  9.263279599000080e-07, -1.164144520349395e-07,  8.077721530021549e-09, -4.037056943603383e-10,  1.614734829592834e-11, -5.466360432408352e-13,  1.621033925253391e-14,
 -4.309483645959318e-16,  1.044181595557885e-17, -2.334583829593602e-19,  4.862658954339668e-21, -9.504368424136917e-23,  1.972506528421641e-07, -2.864798245548033e-08,
  2.265492263614249e-09, -1.277031020422551e-10,  5.714314918823760e-12, -2.149838790285879e-13,  7.045661534297878e-15, -2.060116978667987e-16,  5.467039077049792e-18,
 -1.333736661359915e-19,  3.021042142361812e-21, -6.401428815988115e-23,  3.916109300954202e-08, -6.521286224961922e-09,  5.847943729577086e-10, -3.704012303793947e-11,
  1.848596036187773e-12, -7.709129399025403e-14,  2.785809932378652e-15, -8.940427783488197e-17,  2.593543440515270e-18, -6.891432413055998e-20,  1.694603054440935e-21,
 -3.886260908680874e-23,  7.330799814121483e-09, -1.389225750779384e-09,  1.405634173741697e-10, -9.965824623056452e-12,  5.530079472353196e-13, -2.549476663743682e-14,
  1.013429448146810e-15, -3.562015519607283e-17,  1.127280245001142e-18, -3.256277981865736e-20,  8.676896323608774e-22, -2.149856006477492e-23,  1.311940341522054e-09,
 -2.808587437014739e-10,  3.190072529282967e-11, -2.521587342327455e-12,  1.550564968858329e-13, -7.879627151151721e-15,  3.436500705675532e-16, -1.319718296953716e-17,
  4.546270300167931e-19, -1.424649361867649e-20,  4.105488118488466e-22, -1.096849322155709e-23,  2.282801705837540e-10, -5.479932184300094e-11,  6.949784015510096e-12,
 -6.098087528743416e-13,  4.140012775229534e-14, -2.311513085956963e-15,  1.102789986504176e-16, -4.614625344368612e-18,  1.725993647280992e-19, -5.853329537135246e-21,
  1.819977050211799e-22, -5.231286178586659e-24,  3.941219948253341e-11, -1.052756404350960e-11,  1.482126724371771e-12, -1.436657159365097e-13,  1.072306076632237e-14,
 -6.553091776369551e-16,  3.408163241511722e-17, -1.548957061966903e-18,  6.271165865347807e-20, -2.294902851793973e-21,  7.677601120660975e-23, -2.367871479946104e-24,
  6.915400982624250e-12, -2.038673573726279e-12,  3.165645685634730e-13, -3.371050578592907e-14,  2.752578845186431e-15, -1.832908827212085e-16,  1.034849571277312e-17,
 -5.088249757582244e-19,  2.221621380445266e-20, -8.741738429121682e-22,  3.136007476550196e-23, -1.034347112952579e-24,  1.267653078740591e-12, -4.087994919800258e-13,
  6.950237969515936e-14, -8.078369882477005e-15,  7.173783973213436e-16, -5.176743364434260e-17,  3.156751159067414e-18, -1.671134848289222e-19,  7.832761488448289e-21,
 -3.299503641559459e-22,  1.263900024166226e-23, -4.440023462428670e-25,  2.502483529895117e-13, -8.742656445328141e-14,  1.613800571047404e-14, -2.031777320368309e-15,
  1.948412327158519e-16, -1.513643234722298e-17,  9.907024235198493e-19, -5.613305725733152e-20,  2.808434685328090e-21, -1.259636178504110e-22,  5.125351242712491e-24,
 -1.908034065124807e-25,  5.488464021091800e-14, -2.055223871694346e-14,  4.079092274113517e-15, -5.512820031125307e-16,  5.660859435558005e-17, -4.696620663306022e-18,
  3.274470950309939e-19, -1.971390015691368e-20,  1.045552941463771e-21, -4.959971887976024e-23,  2.130027935107712e-24, -8.351210937853883e-26,  1.374426587409267e-14,
 -5.452759937040346e-15,  1.150740764253248e-15, -1.651899824848739e-16,  1.798208790887308e-17, -1.578179329380621e-18,  1.161417431115894e-19, -7.365223056519728e-21,
  4.106313017940761e-22, -2.043826677970809e-23,  9.192096785018112e-25, -3.767394849913934e-26,  3.982536488986681e-15, -1.653059767528287e-15,  3.662919745008700e-16,
 -5.517548893637356e-17,  6.293424845473037e-18, -5.777863553917116e-19,  4.440467160218817e-20, -2.935854686347106e-21,  1.703774709417409e-22, -8.813469623626247e-24,
  4.113585052068874e-25, -1.747026679963382e-26,  1.295684733736052e-15, -5.552172503009252e-16,  1.273823520080860e-16, -1.986116170616055e-17,  2.342609817177502e-18,
 -2.221432057227240e-19,  1.761279949251157e-20, -1.199926760903460e-21,  7.167269767520386e-23, -3.811790560660948e-24,  1.827181516752023e-25, -7.961005216169217e-27,
  3.792724658570748e-16, -1.654601677660916e-16,  3.871742751017520e-17, -6.156261221770780e-18,  7.401131314423966e-19, -7.148866400010787e-20,  5.769606691970312e-21,
 -3.998483257507519e-22,  2.427913485040796e-23, -1.311816791815667e-24,  6.384499529372218e-26, -2.822561257047802e-27,  8.256857131626773e-02, -2.851806920514082e-04,
  1.030063806312077e-06, -3.857029943515266e-09,  1.481398221886930e-11, -5.787687584425815e-14,  2.281194804879051e-16, -9.042016649829722e-19,  3.582044822619669e-21,
 -1.421635790566941e-23,  5.605995593984672e-26, -2.219604204768513e-28,  7.352792225444406e-02, -3.248823493060274e-04,  1.758861563403614e-06, -9.868447600865188e-09,
  5.442866644958186e-11, -2.926593206852748e-13,  1.537040536834276e-15, -7.913307171595017e-18,  4.004636623996809e-20, -1.996986523461839e-22,  9.826788936696058e-25,
 -4.779782297479447e-27,  5.831338745647164e-02, -3.706256710165592e-04,  2.895649477708910e-06, -2.136067569821562e-08,  1.483377529781544e-10, -9.841734460567765e-13,
  6.299557293715487e-15, -3.914295038137857e-17,  2.371223995188281e-19, -1.404967030929665e-21,  8.162656465133225e-24, -4.659470668368673e-26,  4.119531338504569e-02,
 -3.823649144975839e-04,  3.933527534229526e-06, -3.594032338858596e-08,  3.032426653486308e-10, -2.413654066680193e-12,  1.833844326793693e-14, -1.340436434238143e-16,
  9.479783046762576e-19, -6.514577184938026e-21,  4.364894487614528e-23, -2.858960584737859e-25,  2.593145466636940e-02, -3.428337609983930e-04,  4.418681137231529e-06,
 -4.891864936386896e-08,  4.925880814375624e-10, -4.620824173524261e-12,  4.096030593736348e-14, -3.464493826073007e-16,  2.815847805563560e-18, -2.210900135337269e-20,
  1.683858309248466e-22, -1.248005289082735e-24,  1.455133125425126e-02, -2.649125954302763e-04,  4.175345411808625e-06, -5.527770546557292e-08,  6.554894515300826e-10,
 -7.154328542859605e-12,  7.310146894484361e-14, -7.073655692943116e-16,  6.536054114689675e-18, -5.802697228097337e-20,  4.973570681862807e-22, -4.131013236673127e-24,
  7.283642416759942e-03, -1.768225897014550e-04,  3.362786470575153e-06, -5.268927966273221e-08,  7.282079246298229e-10, -9.159543972426043e-12,  1.069231779658791e-13,
 -1.173736515049293e-15,  1.223087478441206e-17, -1.218384147296906e-19,  1.166563128327979e-21, -1.078117136596512e-23,  3.254869682710144e-03, -1.024771493765226e-04,
  2.330230491293450e-06, -4.283565989123636e-08,  6.844459998275374e-10, -9.848422202815678e-12,  1.304416903863864e-13, -1.613887737322872e-15,  1.884898539430475e-17,
 -2.094365950021449e-19,  2.227327380999483e-21, -2.277800067614684e-23,  1.300015128576611e-03, -5.185283631403225e-05,  1.399326911941789e-06, -2.995856859578024e-08,
  5.498381751644531e-10, -8.997324016380819e-12,  1.344736218826392e-13, -1.865572783692714e-15,  2.430104409893245e-17, -2.997702021770965e-19,  3.525048255179469e-21,
 -3.971666247595572e-23,  4.647706148919884e-04, -2.302912318523975e-05,  7.326337699990875e-07, -1.815426348120747e-08,  3.806713808607829e-10, -7.049969441483867e-12,
  1.183725060990736e-13, -1.833701411101014e-15,  2.653485826150608e-17, -3.620192761610806e-19,  4.689951015452729e-21, -5.801211007572973e-23,  1.490209561589207e-04,
 -9.022901896001356e-06,  3.362796637551228e-07, -9.592995780956786e-09,  2.287836791087623e-10, -4.776104727979634e-12,  8.975834469312511e-14, -1.547241351500433e-15,
  2.479162104998875e-17, -3.729223295784642e-19,  5.306573909728075e-21, -7.185357643774236e-23,  4.296041278044894e-05, -3.134500844951993e-06,  1.360529349991952e-07,
 -4.447169226763086e-09,  1.201617151709060e-10, -2.818000944114710e-12,  5.909200747752839e-14, -1.130219093253983e-15,  1.999793604852266e-17, -3.308032546162426e-19,
  5.157530237524338e-21, -7.626253508104261e-23,  1.117157961553793e-05, -9.705746931870813e-07,  4.879128435246288e-08, -1.819772676979439e-09,  5.551714413448401e-11,
 -1.458277465242198e-12,  3.402943128153905e-14, -7.203925292380384e-16,  1.404309763078444e-17, -2.548964594735935e-19,  4.345060068522471e-21, -7.001854887721871e-23,
  2.631490254272806e-06, -2.694216581548961e-07,  1.560441004134290e-08, -6.615447711645137e-10,  2.271761372644991e-11, -6.666097077725040e-13,  1.727011644739719e-14,
 -4.037923062008916e-16,  8.654697682486564e-18, -1.720455568600961e-19,  3.200694737013242e-21, -5.611031566342941e-23,  5.644882696294136e-07, -6.748994579484237e-08,
  4.481323565069702e-09, -2.151826493579077e-10,  8.294207438361624e-12, -2.712308013747781e-13,  7.784896355588448e-15, -2.006447899360265e-16,  4.720027781868088e-18,
 -1.025869360176204e-19,  2.079498079124740e-21, -3.959644417304420e-23,  1.110294659501321e-07, -1.537505169571489e-08,  1.164888882140967e-09, -6.313910237325058e-11,
  2.724351968551815e-12, -9.906070003310456e-14,  3.143725877176840e-15, -8.915649488385394e-17,  2.298109736986994e-18, -5.452474116897108e-20,  1.202472204087257e-21,
 -2.483363455792290e-23,  2.019826720493795e-08, -3.215246301967658e-09,  2.766898028104951e-10, -1.687224528811426e-11,  8.128062304605294e-13, -3.278950908175070e-14,
  1.148320882531442e-15, -3.577191688148584e-17,  1.008685373648310e-18, -2.608491131074659e-20,  6.249576766582959e-22, -1.397868392278306e-23,  3.435840344580800e-09,
 -6.242536860225185e-10,  6.074032081030118e-11, -4.152953703846667e-12,  2.227637549677427e-13, -9.947356088908432e-15,  3.836605514522407e-16, -1.310405685099491e-17,
  4.035362442252776e-19, -1.135628737788041e-20,  2.951324735001904e-22, -7.139057784213893e-24,  5.540558731697205e-10, -1.141011539762441e-10,  1.249473219030796e-11,
 -9.544819991569803e-13,  5.684199421355097e-14, -2.802650146606755e-15,  1.187853557110001e-16, -4.439459962880615e-18,  1.490254176641654e-19, -4.555844832183165e-21,
  1.282141492573151e-22, -3.348536266318413e-24,  8.615594652900737e-11, -1.997011768152604e-11,  2.449114776813974e-12, -2.082237335008506e-13,  1.372264414594355e-14,
 -7.449823680327545e-16,  3.460923045840734e-17, -1.412065848206346e-18,  5.155744765862910e-20, -1.708662762196094e-21,  5.196943594451811e-23, -1.462594473967113e-24,
  1.319262194886858e-11, -3.416657154074943e-12,  4.667598754374275e-13, -4.397361075917391e-14,  3.194986308675849e-15, -1.903403147848335e-16,  9.662815663658279e-18,
 -4.291740516307049e-19,  1.699884904029587e-20, -6.091715776684094e-22,  1.997550390113079e-23, -6.043687407512329e-25,  2.040259392079237e-12, -5.857433690635211e-13,
  8.860054966903891e-14, -9.202168371389136e-15,  7.337963241696963e-16, -4.777658091776527e-17,  2.640439323966302e-18, -1.272151015086673e-19,  5.447811380267418e-21,
 -2.104311740531675e-22,  7.416513956568420e-24, -2.405118561569164e-25,  3.283198656045509e-13, -1.035876050949646e-13,  1.722803614569654e-14, -1.960604790272085e-15,
  1.706427169069729e-16, -1.208090100480951e-17,  7.234187408094790e-19, -3.763939064318936e-20,  1.735303732365550e-21, -7.195511791413526e-23,  2.715055975367514e-24,
 -9.401474164739876e-26,  5.686435183081726e-14, -1.952753173148399e-14,  3.541652258978197e-15, -4.383800458592876e-16,  4.136250253410760e-17, -3.163984947690029e-18,
  2.040599101431431e-19, -1.140082743872646e-20,  5.628148946255680e-22, -2.492252481970242e-23,  1.001754630505701e-24, -3.685993638474683e-26,  1.098748376955268e-14,
 -4.062696273040811e-15,  7.957770020514231e-16, -1.061792450797332e-16,  1.077009095429300e-17, -8.831526207548447e-19,  6.088915862136294e-20, -3.626967807452552e-21,
  1.904147525080309e-22, -8.945729503093577e-24,  3.806190275102377e-25, -1.479133800752067e-26,  2.449013227072230e-15, -9.633853313895246e-16,  2.014890661543022e-16,
 -2.867070429897314e-17,  3.094737878209893e-18, -2.694193908247784e-19,  1.967466712175917e-20, -1.238520503594945e-21,  6.856646763601835e-23, -3.389866662519091e-24,
  1.514819101937532e-25, -6.170537951994453e-27,  6.426224777396284e-16, -2.654149495833385e-16,  5.849759573203200e-17, -8.765391806582133e-18,  9.947367945898883e-19,
 -9.088145456544383e-20,  6.952080762518958e-21, -4.576015569980026e-22,  2.644336553370442e-23, -1.362334543059957e-24,  6.333826024139862e-26, -2.679974419636139e-27,
  1.940317639564046e-16, -8.294995276617983e-17,  1.898225371672349e-17, -2.952167263411154e-18,  3.473509128388717e-19, -3.286046676246830e-20,  2.599454679287785e-21,
 -1.767103336267515e-22,  1.053302346321472e-23, -5.590587867444318e-25,  2.674696988033876e-26, -1.163217761009822e-27,  5.435931841675723e-17, -2.369519101520179e-17,
  5.539591692047448e-18, -8.800198315479812e-19,  1.057026247617674e-19, -1.020111514776149e-20,  8.226038896501115e-22, -5.696200123025398e-23,  3.456047271029614e-24,
 -1.865893798925012e-25,  9.074406515284061e-27, -4.008881695161215e-28,  8.144404200965479e-02, -2.771213757170701e-04,  9.851643311494990e-07, -3.628977441220143e-09,
  1.370920763732047e-11, -5.269332527768715e-14,  2.043326294077859e-16, -7.973504657124748e-19,  3.108372326631525e-21, -1.215765842423517e-23,  4.714858269644129e-26,
 -1.843741595771308e-28,  7.225580497029491e-02, -3.112707698704468e-04,  1.645478481730168e-06, -9.042482940036525e-09,  4.892714353786788e-11, -2.582907927379657e-13,
  1.332379735105144e-15, -6.739656324509056e-18,  3.351687285703442e-20, -1.642921818684746e-22,  7.947625469503845e-25, -3.801492523032212e-27,  5.687564680715457e-02,
 -3.484468841227942e-04,  2.652937866157676e-06, -1.913688257103345e-08,  1.300816425166126e-10, -8.453232449673309e-13,  5.302608924592580e-15, -3.230507828653135e-17,
  1.919583918427173e-19, -1.116019682022462e-21,  6.364188175981041e-24, -3.566749059367186e-26,  3.972617049951659e-02, -3.525428672265706e-04,  3.529836055231346e-06,
 -3.145192914903905e-08,  2.590836376561479e-10, -2.015347438173013e-12,  1.497692582627026e-14, -1.071469023533151e-16,  7.420701626800034e-19, -4.996295458673536e-21,
  3.281168548862942e-23, -2.107227155556205e-25,  2.462728101492326e-02, -3.097051154108469e-04,  3.876060482531655e-06, -4.172628368233887e-08,  4.092659870232524e-10,
 -3.744693201326995e-12,  3.241025048616675e-14, -2.678773371409191e-16,  2.129006610538506e-18, -1.635530094316494e-20,  1.219367059415953e-22, -8.850695311822818e-25,
  1.355452340551249e-02, -2.339951559189869e-04,  3.570509429586472e-06, -4.584557484134528e-08,  5.284573560560966e-10, -5.615734992859146e-12,  5.593478901779956e-14,
 -5.281249913285094e-16,  4.765330264195593e-18, -4.134161342358096e-20,  3.464678510406979e-22, -2.815244747541280e-24,  6.626414609434992e-03, -1.522643798738060e-04,
  2.794800696866276e-06, -4.237447927459353e-08,  5.682290486029127e-10, -6.947288736088802e-12,  7.893780647114658e-14, -8.443738366483485e-16,  8.581644554558153e-18,
 -8.344202768581929e-20,  7.803526634728443e-22, -7.048425220509936e-24,  2.879233658591148e-03, -8.571918389976493e-05,  1.875921203861421e-06, -3.330439700088067e-08,
  5.154480428272129e-10, -7.198327176229613e-12,  9.267581437079155e-14, -1.115946186245123e-15,  1.269762674133422e-17, -1.375723129099268e-19,  1.427698002145883e-21,
 -1.425722857922828e-23,  1.112910604666559e-03, -4.195929516922319e-05,  1.087193354181944e-06, -2.244167413574024e-08,  3.983493575795370e-10, -6.317993970938152e-12,
  9.167796746449994e-14, -1.236479477028510e-15,  1.567595583743633e-17, -1.883859965551765e-19,  2.159928329471841e-21, -2.374568176430980e-23,  3.831297534747528e-04,
 -1.794570831489875e-05,  5.471302310958564e-07, -1.305303176024685e-08,  2.643716860868705e-10, -4.740064362425119e-12,  7.718907299605257e-14, -1.161368374790057e-15,
  1.634256918452785e-17, -2.170441316699357e-19,  2.739623621030579e-21, -3.304448406120757e-23,  1.176599130675209e-04, -6.737465558648834e-06,  2.403171736083657e-07,
 -6.592851293233309e-09,  1.517099894243334e-10, -3.063211068931619e-12,  5.578375055752380e-14, -9.332235980142633e-16,  1.453068886417983e-17, -2.126345642822877e-19,
  2.946351676267320e-21, -3.888218067354702e-23,  3.230233758230114e-05, -2.230688820210649e-06,  9.258560393326595e-08, -2.907992788748759e-09,  7.575217338570817e-11,
 -1.716961382996558e-12,  3.486452848748824e-14, -6.467660249468802e-16,  1.111438405964222e-17, -1.787687917929045e-19,  2.712875016681575e-21, -3.908093251016658e-23,
  7.950360523871953e-06, -6.544518104564151e-07,  3.144818039724382e-08, -1.126490828168756e-09,  3.311519672505650e-11, -8.402568310780038e-13,  1.897848773102166e-14,
 -3.895162403314261e-16,  7.371839556843803e-18, -1.300648290817801e-19,  2.157441129850434e-21, -3.386275948376764e-23,  1.760747945747664e-06, -1.710452988121721e-07,
  9.470458137064845e-09, -3.855468134266279e-10,  1.275477077446152e-11, -3.614517549978815e-13,  9.061760657737332e-15, -2.053715144197735e-16,  4.272874612987134e-18,
 -8.255421835453747e-20,  1.494330592836485e-21, -2.551445973824749e-23,  3.525900534198721e-07, -4.006678960717709e-08,  2.544681633632558e-09, -1.173624949255418e-10,
  4.358478832017677e-12, -1.376552893085325e-13,  3.823535908609916e-15, -9.552729575514300e-17,  2.181520830117837e-18, -4.608636563178222e-20,  9.090621645596023e-22,
 -1.686133294778071e-23,  6.424559346922564e-08, -8.473210889382014e-09,  6.146524138250943e-10, -3.201937186167796e-11,  1.331733637938577e-12, -4.678597739250186e-14,
  1.437363861470045e-15, -3.952798225397200e-17,  9.894157840906513e-19, -2.282499911272620e-20,  4.899984657158644e-22, -9.860866002983444e-24,  1.073890635882403e-08,
 -1.632082052023815e-09,  1.346679265697005e-10, -7.900811860903554e-12,  3.671946633189204e-13, -1.432273820071513e-14,  4.859092822934927e-16, -1.468723645727880e-17,
  4.024175135533552e-19, -1.012468692517870e-20,  2.362683291226771e-22, -5.152732233206348e-24,  1.664102013781515e-09, -2.894781472558641e-10,  2.705871280561656e-11,
 -1.782659193654480e-12,  9.236753909399783e-14, -3.992600588901879e-15,  1.493302718595632e-16, -4.953788767895110e-18,  1.483694253215860e-19, -4.065965135578290e-21,
  1.030131268105058e-22, -2.431719694969897e-24,  2.422890395428066e-10, -4.792735611035552e-11,  5.054011154386916e-12, -3.727491657548489e-13,  2.147979917744610e-14,
 -1.026783301065323e-15,  4.226202653553622e-17, -1.536161772085124e-18,  5.021788886645054e-20, -1.496831191386447e-21,  4.111614703522956e-23, -1.049158140316072e-24,
  3.371451835408798e-11, -7.533817714161048e-12,  8.923036193864543e-13, -7.342523113063302e-14,  4.692661508197363e-15, -2.474846685080401e-16,  1.118620627690327e-17,
 -4.446618047307790e-19,  1.583746488054020e-20, -5.125722731644971e-22,  1.524031325008409e-23, -4.196957101079597e-25,  4.580433090465095e-12, -1.148282300035958e-12,
  1.520111429183040e-13, -1.390189910685504e-14,  9.821629642383511e-16, -5.698253827482832e-17,  2.821036655220551e-18, -1.223409810889356e-19,  4.736756523168031e-21,
 -1.661005510258491e-22,  5.334689903356492e-24, -1.582280427774566e-25,  6.238199474892951e-13, -1.741338140491177e-13,  2.562208425877513e-14, -2.592192597796222e-15,
  2.016322012413687e-16, -1.282253041358822e-17,  6.929924945470795e-19, -3.268581550478541e-20,  1.371657980007005e-21, -5.196808589207482e-23,  1.798035830874077e-24,
 -5.728762215397633e-26,  8.792286478013997e-14, -2.709985463256809e-14,  4.402913126496212e-15, -4.899828179301516e-16,  4.174941292441127e-17, -2.896677550220515e-18,
  1.701624091857961e-19, -8.693443075553952e-21,  3.938873502712066e-22, -1.606386106398706e-23,  5.965934690408574e-25, -2.034774942177936e-26,  1.330886246690519e-14,
 -4.486572512053561e-15,  7.985192120538417e-16, -9.706146324136571e-17,  9.000928754163647e-18, -6.772741316131894e-19,  4.300153034962457e-20, -2.366918496506506e-21,
  1.151956216401878e-22, -5.032318999430960e-24,  1.996671895277744e-25, -7.256482467382240e-27,  2.253563124981796e-15, -8.219263958782459e-16,  1.587195678172205e-16,
 -2.088771152859956e-17,  2.090946247332708e-18, -1.693162893192504e-19,  1.153455069147971e-20, -6.792768661800521e-22,  3.527575363617870e-23, -1.640136714293321e-24,
  6.909490250202946e-26, -2.659827561434053e-27,  4.442546169869176e-16, -1.731495939972633e-16,  3.586127327064672e-17, -5.054423387773655e-18,  5.406086531829330e-19,
 -4.665427542464319e-20,  3.378688412493580e-21, -2.110033873209130e-22,  1.159316759309653e-23, -5.690190561742185e-25,  2.525224355300840e-26, -1.021873472483727e-27,
  1.048759386161986e-16, -4.308057925051991e-17,  9.439633499643273e-18, -1.406365350029115e-18,  1.587218922986380e-19, -1.442472306879212e-20,  1.097873585424577e-21,
 -7.191654284688000e-23,  4.136717270780322e-24, -2.121826730370095e-25,  9.823444192064196e-27, -4.139846126710254e-28,  2.922183582404763e-17, -1.246048900522205e-17,
  2.843481672604572e-18, -4.410042697329041e-19,  5.174977611252207e-20, -4.883114739338702e-21,  3.853314173772626e-22, -2.613291670523782e-23,  1.554160451165186e-24,
 -8.231107654159778e-26,  3.929818751653158e-27, -1.705672312280983e-28,  7.806900360275741e-18, -3.400025375346238e-18,  7.940999105776071e-19, -1.260275455439739e-19,
  1.512319641902440e-20, -1.458149519996262e-21,  1.174773813152566e-22, -8.127750068909261e-24,  4.927182126695430e-25, -2.657978948367648e-26,  1.291635291435399e-27,
 -5.701824372847627e-29,  8.035104849467332e-02, -2.694106014802060e-04,  9.428987510294482e-07, -3.417801994931302e-09,  1.270262899126317e-11, -4.804640383520369e-14,
  1.833360759169801e-16, -7.045366675674603e-19,  2.702775558958470e-21, -1.042449446608006e-23,  3.973247327018461e-26, -1.537555512628687e-28,  7.103638060206675e-02,
 -2.985280546386928e-04,  1.541500678066715e-06, -8.299299796045873e-09,  4.406641722507205e-11, -2.284622600919436e-13,  1.157837688594327e-15, -5.755925709060988e-18,
  2.813647490214422e-20, -1.356078192758410e-22,  6.450330990933924e-25, -3.034941444575731e-27,  5.552290018555570e-02, -3.281078107955557e-04,  2.435246786603947e-06,
 -1.718420892298620e-08,  1.143779717882127e-10, -7.282564552994831e-13,  4.478357482932418e-15, -2.675901668241000e-17,  1.560095972413402e-19, -8.902470438413684e-22,
  4.984336655192258e-24, -2.743328355897015e-26,  3.837018166412332e-02, -3.257463419532743e-04,  3.176015392520149e-06, -2.761049043069968e-08,  2.221413360601138e-10,
 -1.689376821535637e-12,  1.228392621025764e-14, -8.604229093209279e-17,  5.837534229888340e-19, -3.851951502141570e-21,  2.480179362995790e-23, -1.562205313202195e-25,
  2.344745630830146e-02, -2.805936022945608e-04,  3.412293367311320e-06, -3.573733417439797e-08,  3.415806323064522e-10, -3.049667667095127e-12,  2.578126002485415e-14,
 -2.082996122478242e-16,  1.619375626277771e-18, -1.217559918172836e-20,  8.888735791341136e-23, -6.320388652859791e-25,  1.267237891064485e-02, -2.074960134721295e-04,
  3.067611293200222e-06, -3.822057023302736e-08,  4.284527668621204e-10, -4.434803849036711e-12,  4.307616976518627e-14, -3.969971732364089e-16,  3.499278739047315e-18,
 -2.967535219318420e-20,  2.432455706148952e-22, -1.934165107442613e-24,  6.059058514578176e-03, -1.317953198789971e-04,  2.336584463544819e-06, -3.429895949119735e-08,
  4.464626416791077e-10, -5.308034107764751e-12,  5.872800479584282e-14, -6.123576934938942e-16,  6.072114153670681e-18, -5.764796770387848e-20,  5.267532975842887e-22,
 -4.651367325425819e-24,  2.564024963176025e-03, -7.218042934658880e-05,  1.521364858698821e-06, -2.609796411711154e-08,  3.914119460209898e-10, -5.307361451486134e-12,
  6.644532201624099e-14, -7.789618326698322e-16,  8.637852504581413e-18, -9.128419137297171e-20,  9.247083981658225e-22, -9.019742646761899e-24,  9.609041670689741e-04,
 -3.423947888513163e-05,  8.523223022250402e-07, -1.697024162584434e-08,  2.914562341867431e-10, -4.482212861173745e-12,  6.316783678325688e-14, -8.285338266061198e-16,
  1.022652621327703e-17, -1.197628296896466e-19,  1.339207386164040e-21, -1.436960763316185e-23,  3.192017547588446e-04, -1.412990471685453e-05,  4.130432980720752e-07,
 -9.490919132318252e-09,  1.857391089382909e-10, -3.225180141489548e-12,  5.095336340443754e-14, -7.448240334115842e-16,  1.019502189767637e-17, -1.318387342396483e-19,
  1.621808190993946e-21, -1.907945880357254e-23,  9.410673264443280e-05, -5.094343956172225e-06,  1.739588462097954e-07, -4.590885410489777e-09,  1.019615673233197e-10,
 -1.991756881272514e-12,  3.515710564904735e-14, -5.709458218408240e-16,  8.640741756016722e-18, -1.230348697529610e-19,  1.660438811366475e-21, -2.136012166779131e-23,
  2.466593056787831e-05, -1.611325336346206e-06,  6.396073677050966e-08, -1.930712058558959e-09,  4.849851967789366e-11, -1.062609883075883e-12,  2.089868237402171e-14,
 -3.760912462979716e-16,  6.278028951448786e-18, -9.820243498402555e-20,  1.450748497866421e-21, -2.036354562625704e-23,  5.761325429338064e-06, -4.490636365304451e-07,
  2.062585724250649e-08, -7.096195228464224e-10,  2.010283701380470e-11, -4.927900197351046e-13,  1.077445790753900e-14, -2.144154800118731e-16,  3.940101801844720e-18,
 -6.757958091860083e-20,  1.090884734428342e-21, -1.667867080248685e-23,  1.203052091111750e-06, -1.107999071215988e-07,  5.863330807744818e-09, -2.291948971726982e-10,
  7.304318073340124e-12, -1.999058158337385e-13,  4.849880573007957e-15, -1.065442788469628e-16,  2.151803903259128e-18, -4.040682028831088e-20,  7.116592907382536e-22,
 -1.183460853912108e-23,  2.255519599391300e-07, -2.433807308174840e-08,  1.477862210699363e-09, -6.545071429242582e-11,  2.341438790982877e-12, -7.141313720228600e-14,
  1.919387708564858e-15, -4.648062585114593e-17,  1.030343020893909e-18, -2.115556828537617e-20,  4.060364002672922e-22, -7.335467004199155e-24,  3.818468032128877e-08,
 -4.791264177619209e-09,  3.325669846380207e-10, -1.664355124923427e-11,  6.670327194192394e-13, -2.263535393100701e-14,  6.730435210062346e-16, -1.794393804502817e-17,
  4.360758288352738e-19, -9.779599037885056e-21,  2.043282444194250e-22, -4.006141292280628e-24,  5.881553507430099e-09, -8.523556901509530e-10,  6.738105498915229e-11,
 -3.801102591371342e-12,  1.703450715009784e-13, -6.421793964729437e-15,  2.109706211977259e-16, -6.185327849596067e-18,  1.646201341903772e-19, -4.028343571539166e-21,
  9.153485634298803e-23, -1.945863756970455e-24,  8.324633553341649e-10, -1.384559400001025e-10,  1.242083319197901e-11, -7.878648192493556e-13,  3.940739576533404e-14,
 -1.647912771130782e-15,  5.973794709978313e-17, -1.923804292864199e-18,  5.601468698430353e-20, -1.494174809812255e-21,  3.688944952583352e-23, -8.494747785271734e-25,
  1.096814643637432e-10, -2.080864212107786e-11,  2.110629407841859e-12, -1.501469840526853e-13,  8.365307472053117e-15, -3.873988079560203e-16,  1.547444218965397e-17,
 -5.467023441770502e-19,  1.739446990252431e-20, -5.052345742325882e-22,  1.353875242238238e-23, -3.373647968622583e-25,  1.367978392533958e-11, -2.942284265738206e-12,
  3.361158783310127e-13, -2.673941309483990e-14,  1.655643152347110e-15, -8.474864474214568e-17,  3.723950653124944e-18, -1.441147502065171e-19,  5.003546556563708e-21,
 -1.580387157694519e-22,  4.590665824248161e-24, -1.236288290720457e-25,  1.650196985375792e-12, -3.997883534799192e-13,  5.121345763773170e-14, -4.540983015400667e-15,
  3.116115611816287e-16, -1.758864295370265e-17,  8.483816878360486e-19, -3.589333535311448e-20,  1.357360268665665e-21, -4.653975670232168e-23,  1.462946646862511e-24,
 -4.250833486769642e-26,  1.978297812300878e-13, -5.360436547776360e-14,  7.661341022002898e-15, -7.540382440852235e-16,  5.714541273353209e-17, -3.545677020808598e-18,
  1.872025129657984e-19, -8.635825815816769e-21,  3.548227942524330e-22, -1.317482811851957e-23,  4.471335119209053e-25, -1.398624901809351e-26,  2.437402973787455e-14,
 -7.327661641072983e-15,  1.161352988321848e-15, -1.262196324624672e-16,  1.051597947116719e-17, -7.142627464450958e-19,  4.111951454917014e-20, -2.060790017713672e-21,
  9.167874627668986e-23, -3.674243914098328e-24,  1.342015691983913e-25, -4.504887352685573e-27,  3.212920279498580e-15, -1.061772483632105e-15,  1.852001809518960e-16,
 -2.207950716998158e-17,  2.010124419301697e-18, -1.486251866253754e-19,  9.280701942116156e-21, -5.028060174438699e-22,  2.410460180031929e-23, -1.037964896458760e-24,
  4.062137000590942e-26, -1.457076436435047e-27,  4.742670429497826e-16, -1.704247391272112e-16,  3.240882519167408e-17, -4.202217534791119e-18,  4.147396635153174e-19,
 -3.313381276357548e-20,  2.228418408527121e-21, -1.296384250923524e-22,  6.654339444760522e-24, -3.059745216355333e-25,  1.275403637626343e-26, -4.860344619039017e-28,
  8.215424245868109e-17, -3.169807393170579e-17,  6.495617179355669e-18, -9.060965512746428e-19,  9.595810502018197e-20, -8.203207049811993e-21,  5.887451928929881e-22,
 -3.645359203028651e-23,  1.986548984714898e-24, -9.674637012798832e-26,  4.261605448195019e-27, -1.712334624278839e-28,  1.732773521127539e-17, -7.075480804745752e-18,
  1.540474842049691e-18, -2.280766867442969e-19,  2.558628086934405e-20, -2.311955604141968e-21,  1.750006098806990e-22, -1.140356866630209e-23,  6.526748885551108e-25,
 -3.331799647187638e-26,  1.535514803405637e-27, -6.443008081938661e-29,  4.428167451113322e-18, -1.882907419963822e-18,  4.283655490940925e-19, -6.623631020415480e-20,
  7.749888275440872e-21, -7.292360953515241e-22,  5.739066116634410e-23, -3.882221572418474e-24,  2.303148527489347e-25, -1.216924940959083e-26,  5.796967847208573e-28,
 -2.510675346543225e-29,  1.123649508321411e-18, -4.889021646192714e-19,  1.140665139452497e-19, -1.808391859963785e-20,  2.167829568471040e-21, -2.088099849720845e-22,
  1.680679941097117e-23, -1.161706767807536e-24,  7.036128048460104e-26, -3.792352018156092e-27,  1.841329551134603e-28, -8.121812780805179e-30,  7.928823749925869e-02,
 -2.620280823625522e-04,  9.030736253458766e-07, -3.222014821134743e-09,  1.178415276051579e-11, -4.387362520991099e-14,  1.647655878587587e-16, -6.237583875106594e-19,
  2.354541632694402e-21, -8.962786784991813e-24,  3.353437677549391e-26, -1.288247033595689e-28,  6.986631812327575e-02, -2.865827672571277e-04,  1.445993416743123e-06,
 -7.629334283750592e-09,  3.976250592974739e-11, -2.025107441889995e-13,  1.008577046355107e-15, -4.928938700332415e-18,  2.368856541931911e-20, -1.122892783281496e-22,
  5.252813206815777e-25, -2.431978049306625e-27,  5.424816939909474e-02, -3.094206379566631e-04,  2.239554159716846e-06, -1.546508759173046e-08,  1.008297537003756e-10,
 -6.292310682969570e-13,  3.794440554063883e-15, -2.224325391424296e-17,  1.272766106876905e-19, -7.130538220386305e-22,  3.920682931321446e-24, -2.119758361488025e-26,
  3.711599618839241e-02, -3.016055676116894e-04,  2.864949824053662e-06, -2.431129382761757e-08,  1.911171873623434e-10, -1.421483554162216e-12,  1.011670787878901e-14,
 -6.940210749867346e-17,  4.614003988850622e-19, -2.984743652974311e-21,  1.884765736175778e-23, -1.164675964239124e-25,  2.237708787465432e-02, -2.549221639749846e-04,
  3.014328041766720e-06, -3.072825473954056e-08,  2.863309872840723e-10, -2.495432191014961e-12,  2.061305142430657e-14, -1.628574278824635e-16,  1.238876901846219e-18,
 -9.119450340608913e-21,  6.521141566253376e-23, -4.543748868647638e-25,  1.188872795050712e-02, -1.846795651867493e-04,  2.647341094229869e-06, -3.202228703145122e-08,
  3.492560185827824e-10, -3.522637316282202e-12,  3.337980554016458e-14, -3.003900229482408e-16,  2.587373260787502e-18, -2.145554829584781e-20,  1.720665181203636e-22,
 -1.339271669035472e-24,  5.566817263181990e-03, -1.146351544751233e-04,  1.964587099269851e-06, -2.793371918636537e-08,  3.531136910137826e-10, -4.084138952235392e-12,
  4.401713482112682e-14, -4.475577476884049e-16,  4.331427947857508e-18, -4.016477482313077e-20,  3.586901122667843e-22, -3.097364516239785e-24,  2.297801971271421e-03,
 -6.116328763233110e-05,  1.242523652912091e-06, -2.060479641088725e-08,  2.995943189531322e-10, -3.945969650164781e-12,  4.805684774704716e-14, -5.487014014013936e-16,
  5.931723042256385e-18, -6.116299270416169e-20,  6.049666767072627e-22, -5.765465353261319e-24,  8.363972362402330e-04, -2.816251039985822e-05,  6.739477069319797e-07,
 -1.294899504076478e-08,  2.152686050053656e-10, -3.211235642283355e-12,  4.396933572964398e-14, -5.610512846294046e-16,  6.744166437181958e-18, -7.698932107314789e-20,
  8.398718988837059e-22, -8.797856740171994e-24,  2.686348832066106e-04, -1.123510470206578e-05,  3.150519390417507e-07, -6.975158573311106e-09,  1.319484755549100e-10,
 -2.219670484713606e-12,  3.403272694950882e-14, -4.834783223396577e-16,  6.439023053883662e-18, -8.109958973918592e-20,  9.725196535952052e-22, -1.116160110792309e-23,
  7.619929764167541e-05, -3.898056630730679e-06,  1.274768716440602e-07, -3.237258089386389e-09,  6.941487452296036e-11, -1.312255290215825e-12,  2.245755227058614e-14,
 -3.541291315026838e-16,  5.210504616978729e-18, -7.220811399360826e-20,  9.493310250819986e-22, -1.190694153775314e-23,  1.911396402982501e-05, -1.180576388017342e-06,
  4.482611980362983e-08, -1.300711629087258e-09,  3.151382270599516e-11, -6.676124944801779e-13,  1.271993986496445e-14, -2.221051878353349e-16,  3.602163586050891e-18,
 -5.480650713694987e-20,  7.883252274802369e-22, -1.078348164470887e-23,  4.247989213707158e-06, -3.133174884139895e-07,  1.375554754041834e-08, -4.545816400957041e-10,
  1.241169772567845e-11, -2.939781947208157e-13,  6.222885611534583e-15, -1.200897597471104e-16,  2.142947271971250e-18, -3.573492020274950e-20,  5.614169972425066e-22,
 -8.361958037014237e-24,  8.386974210901838e-07, -7.317513142740986e-08,  3.700286172963940e-09, -1.388762750415891e-10,  4.263681750928465e-12, -1.126968938023979e-13,
  2.645930593897097e-15, -5.634656243043267e-17,  1.104714697051173e-18, -2.016279066930784e-20,  3.455344432918309e-22, -5.596614963521257e-24,  1.476453052557776e-07,
 -1.511417812542770e-08,  8.771412311278782e-10, -3.729440364116631e-11,  1.285042788257991e-12, -3.784513051838721e-14,  9.841828567094399e-16, -2.309965983408779e-17,
  4.970146597513560e-19, -9.917865618357939e-21,  1.852054237420377e-22, -3.258785651727675e-24,  2.329283537898406e-08, -2.777635404944650e-09,  1.843765579412380e-10,
 -8.861165701862828e-12,  3.421090769779396e-13, -1.121104440306126e-14,  3.225674051997099e-16, -8.335935640429586e-18,  1.966513092441399e-19, -4.286616718814544e-21,
  8.715237165211391e-23, -1.664520936921651e-24,  3.315827663679568e-09, -4.576542306508831e-10,  3.463529445906142e-11, -1.877634868361439e-12,  8.110183847193205e-14,
 -2.953849091236217e-15,  9.393845077871214e-17, -2.670583577860763e-18,  6.902164647612313e-20, -1.642290004670068e-21,  3.632728960238263e-23, -7.525634952653131e-25,
  4.298672205471601e-10, -6.826476886599361e-11,  5.871794858628618e-12, -3.583339848203739e-13,  1.729093481825308e-14, -6.991319999513802e-16,  2.455204781643774e-17,
 -7.672292771739768e-19,  2.170797292074477e-20, -5.634145858333580e-22,  1.354994898109119e-23, -3.042680455353706e-25,  5.138007300437542e-11, -9.334937891871041e-12,
  9.097140715145356e-13, -6.236371516710020e-14,  3.356632734238071e-15, -1.504879982865628e-16,  5.829968008056311e-18, -2.000761824074603e-19,  6.192347048441880e-21,
 -1.751777853632569e-22,  4.577159575076482e-24, -1.113279285825540e-25,  5.755011109223261e-12, -1.189473025338832e-12,  1.308901394622877e-13, -1.005602752851934e-14,
  6.026522401293050e-16, -2.991551066458986e-17,  1.276917865232956e-18, -4.807385979177835e-20,  1.625910259865495e-21, -5.008635773160653e-23,  1.420497363160593e-24,
 -3.738825948613592e-26,  6.170991522903543e-13, -1.442330619664883e-13,  1.785390657140165e-14, -1.532967900498400e-15,  1.020646592276776e-16, -5.599159397834481e-18,
  2.628914894232501e-19, -1.084149565699998e-20,  4.001261451732974e-22, -1.340413641578210e-23,  4.120979464841002e-25, -1.172257616835897e-26,  6.511774113432710e-14,
 -1.709813157257020e-14,  2.370185790417239e-15, -2.266386244859321e-16,  1.671472265246235e-17, -1.010756089603648e-18,  5.208080620003862e-20, -2.347590183454265e-21,
  9.435555218006331e-23, -3.430692983415391e-24,  1.141201625268294e-25, -3.501891563542094e-27,  7.002710570267684e-15, -2.050029312971340e-15,  3.164753524118391e-16,
 -3.354597837871258e-17,  2.729494486830702e-18, -1.812825424657484e-19,  1.021679066429709e-20, -5.017991908203694e-22,  2.189867872054849e-23, -8.617078222736291e-25,
  3.092805411709380e-26, -1.021005010235809e-27,  8.012084089173715e-16, -2.591697372117159e-16,  4.424123623113569e-17, -5.166584012452681e-18,  4.612266475633146e-19,
 -3.347321468769786e-20,  2.053564774203607e-21, -1.094032834277094e-22,  5.161596114850368e-24, -2.189007231819848e-25,  8.443116603898942e-27, -2.986812915249687e-28,
  1.025749599155185e-16, -3.627055072487888e-17,  6.784115660430250e-18, -8.657114040346721e-19,  8.415085359700544e-20, -6.626255972688795e-21,  4.395601517786032e-22,
 -2.523901373098655e-23,  1.279481168946178e-24, -5.813794528679484e-26,  2.396105341136425e-27, -9.033208603815018e-29,  1.551001835187991e-17, -5.918667803183247e-18,
  1.198921157927076e-18, -1.653751432581038e-19,  1.732663553915088e-20, -1.466133010419475e-21,  1.042049979890152e-22, -6.392589912507072e-24,  3.453053747310855e-25,
 -1.667580810169400e-26,  7.286905899955558e-28, -2.905649734659110e-29,  2.901458064749907e-18, -1.177023136784368e-18,  2.544760882386556e-19, -3.742019006471339e-20,
  4.170453946797283e-21, -3.744853589603496e-22,  2.817740406678759e-23, -1.825703539490898e-24,  1.039274656356241e-25, -5.277956472879549e-27,  2.420459002204678e-28,
 -1.010861712601749e-29,  6.755664211883808e-19, -2.863717764954875e-19,  6.493202761065031e-20, -1.000707162386437e-20,  1.167141153453988e-21, -1.094889501243647e-22,
  8.591622445891060e-24, -5.795649588676106e-25,  3.429140124124301e-26, -1.807255515996893e-27,  8.588107388937298e-29, -3.710875767069377e-30,  1.621076683660906e-19,
 -7.046104372844675e-20,  1.642073745547672e-20, -2.600375194985929e-21,  3.113791158985160e-22, -2.996065241184002e-23,  2.408996504955159e-24, -1.663467110840117e-25,
  1.006544447037003e-26, -5.420056477039461e-28,  2.629277700042144e-29, -1.158729217315488e-30,  7.825433391360267e-02, -2.549550101025373e-04,  8.655124496698573e-07,
 -3.040279091405701e-09,  1.094485208274871e-11, -4.012060904677831e-14,  1.483084644559885e-16, -5.533274409567126e-19,  2.054717634356901e-21, -7.728510310237735e-24,
  2.832669569850773e-26, -1.085958634980801e-28,  6.874255799296707e-02, -2.753705120657207e-04,  1.358129084442318e-06, -7.024266152341314e-09,  3.594359805753288e-11,
 -1.798789558502624e-13,  8.805992743123581e-16, -4.231728328207562e-18,  1.999993024054760e-20, -9.326989543315554e-23,  4.291516744461463e-25, -1.955950342922050e-27,
  5.304518186406420e-02, -2.922200284937481e-04,  2.063252940882013e-06, -1.394774432212285e-08,  8.910763206150931e-11, -5.452006764469551e-13,  3.224995996914649e-15,
 -1.855258695274287e-17,  1.042185306314535e-19, -5.733897999306852e-22,  3.097034525623904e-24, -1.645262247494195e-26,  3.595363610125259e-02, -2.798030053568523e-04,
  2.590664366233303e-06, -2.146829592493480e-08,  1.649663417033209e-10, -1.200427569383802e-12,  8.364984933895716e-15, -5.622046066902385e-17,  3.663702516140869e-19,
 -2.324089919721754e-21,  1.439710371224120e-23, -8.730366475776561e-26,  2.140339828128709e-02, -2.322082396458992e-04,  2.671512793589573e-06, -2.652082219637943e-08,
  2.410220425912996e-10, -2.051245546446216e-12,  1.656208077617911e-14, -1.279993778947177e-16,  9.530819615189460e-19, -6.870715190342416e-21,  4.813835900466825e-23,
 -3.287699054175485e-25,  1.119006084809566e-02, -1.649479937327581e-04,  2.294410855717096e-06, -2.695698552257973e-08,  2.861786294732870e-10, -2.813765998521956e-12,
  2.602075345756059e-14, -2.287313449548579e-16,  1.925868841459653e-18, -1.562097431594135e-20,  1.226039591787316e-22, -9.343866267623490e-25,  5.137714932509063e-03,
 -1.001690843215215e-04,  1.660760781029925e-06, -2.288395917103852e-08,  2.810555799909150e-10, -3.163687933860181e-12,  3.322692543632653e-14, -3.295640226979020e-16,
  3.113976944000057e-18, -2.821229393556076e-20,  2.463175117157556e-22, -2.080623986416488e-24,  2.071570854163405e-03, -5.213625417055924e-05,  1.021612405161413e-06,
 -1.638483857360917e-08,  2.310669039586934e-10, -2.957398921551460e-12,  3.505023584541484e-14, -3.899004585994477e-16,  4.110528569843507e-18, -4.136752483203101e-20,
  3.996360455455059e-22, -3.722233010088388e-24,  7.336229010598727e-04, -2.333846085871501e-05,  5.372782583483975e-07, -9.966092170845150e-09,  1.604400235316673e-10,
 -2.322444524257433e-12,  3.090680366442660e-14, -3.837881917556141e-16,  4.494305306021550e-18, -5.002676990723182e-20,  5.325544247176565e-22, -5.447662056734073e-24,
  2.282517405945764e-04, -9.016713652029744e-06,  2.426842232833351e-07, -5.178967472197672e-09,  9.473618244026167e-11, -1.544501520284365e-12,  2.298954057488187e-14,
 -3.175008075285882e-16,  4.115500156428084e-18, -5.049910834868184e-20,  5.904705927622580e-22, -6.612914777991417e-24,  6.242491578342560e-05, -3.016569028014766e-06,
  9.451391683866721e-08, -2.310357005429528e-09,  4.784447626128770e-11, -8.755834579192063e-13,  1.453231268205790e-14, -2.225713151622352e-16,  3.184634144252428e-18,
 -4.296333331596643e-20,  5.503808098874839e-22, -6.731903925964685e-24,  1.502090971568935e-05, -8.767464565322635e-07,  3.185075177870626e-08, -8.886231422748834e-10,
  2.077092909282778e-11, -4.255623181187068e-13,  7.856697600858439e-15, -1.331397629422324e-16,  2.098339913616889e-18, -3.105968354926922e-20,  4.350616244937258e-22,
 -5.800535039392012e-24,  3.184496882646714e-06, -2.221163299101912e-07,  9.321532129707213e-09, -2.959340193522905e-10,  7.788777881950746e-12, -1.782800643958290e-13,
  3.654192358432294e-15, -6.839502011615824e-17,  1.185347147111323e-18, -1.922016445720158e-20,  2.939216788159021e-22, -4.265221731053283e-24,  5.960835921627828e-07,
 -4.923046325651853e-08,  2.378571081968835e-09, -8.571086684553609e-11,  2.535084500372056e-12, -6.471839133106232e-14,  1.470566742375848e-15, -3.035939983766793e-17,
  5.778484802918300e-19, -1.025152465801121e-20,  1.709522941797584e-22, -2.696996766411784e-24,  9.881540529344882e-08, -9.587808356807790e-09,  5.316205627315836e-10,
 -2.169691348996553e-11,  7.200083095425637e-13, -2.047399567226966e-14,  5.151490653888799e-16, -1.171845091679866e-17,  2.447235845246928e-19, -4.745906198973302e-21,
  8.622575722219633e-23, -1.477623561537276e-24,  1.457079026672909e-08, -1.649560945000075e-09,  1.046586823383664e-10, -4.828739666797569e-12,  1.795458065254133e-13,
 -5.680874893517672e-15,  1.581387246519887e-16, -3.960674406293887e-18,  9.068851028718917e-20, -1.921205933567156e-21,  3.800512127154325e-23, -7.069863687846183e-25,
  1.922766576648892e-09, -2.524427991564000e-10,  1.827670050104588e-11, -9.516717700842612e-13,  3.960320320980095e-14, -1.393063959936256e-15,  4.287321638462088e-17,
 -1.181553546554696e-18,  2.964710361235921e-20, -6.857477388946685e-22,  1.476288914605353e-23, -2.979675743139537e-25,  2.289859096052360e-10, -3.467324348268607e-11,
  2.856981622769854e-12, -1.676239094641331e-13,  7.798648817376814e-15, -3.047381667438416e-16,  1.036271695238173e-17, -3.140944349362040e-19,  8.632605582094318e-21,
 -2.179233116302876e-22,  5.103555250330576e-24, -1.117166467311984e-25,  2.489584310635947e-11, -4.325075967712068e-12,  4.045143553527921e-13, -2.669913942284215e-14,
  1.387225101917634e-15, -6.016956876293677e-17,  2.259368116911334e-18, -7.527809062685598e-20,  2.265183122943440e-21, -6.238165153907100e-23,  1.588559746714736e-24,
 -3.769684645394718e-26,  2.509864194918215e-12, -4.976797895722697e-13,  5.268617962059082e-14, -3.904896035346888e-15,  2.262932587319416e-16, -1.088438684357226e-17,
  4.509589548971583e-19, -1.650519134867215e-20,  5.434281159798782e-22, -1.631678065278798e-23,  4.515542870562358e-25, -1.160947380668473e-26,  2.395827849573422e-13,
 -5.392977271384721e-14,  6.441628876542651e-15, -5.349323269410397e-16,  3.451828322768615e-17, -1.838652629209172e-18,  8.395713991388159e-20, -3.372082543745813e-21,
  1.213649645160269e-22, -3.969434929664613e-24,  1.192737038278953e-25, -3.319371181592667e-27,  2.226173343287089e-14, -5.654312415865398e-15,  7.590759442029666e-16,
 -7.042382691985631e-17,  5.048240496966646e-18, -2.971940221751595e-19,  1.492968124517030e-20, -6.569591414160780e-22,  2.580701273565048e-23, -9.180617636163043e-25,
  2.990878706132633e-26, -8.996850456573720e-28,  2.087300498497415e-15, -5.939940250867454e-16,  8.918136645878153e-17, -9.206839681476751e-18,  7.306725388862932e-19,
 -4.739772381004550e-20,  2.612262373792233e-21, -1.256104009429180e-22,  5.372264290398695e-24, -2.073752062569054e-25,  7.307820786834723e-27, -2.370645311982670e-28,
  2.066821380809722e-16, -6.533642112107412e-17,  1.089912056562290e-17, -1.245116178590375e-18,  1.088575452002285e-19, -7.745608587162038e-21,  4.663630639195312e-22,
 -2.440696230358495e-23,  1.132175132144436e-24, -4.724687711025046e-26,  1.794525296797511e-27, -6.255889819042884e-29,  2.283660302178313e-17, -7.935207608052079e-18,
  1.457948075291151e-18, -1.828783058257183e-19,  1.748835014913066e-20, -1.355872662710205e-21,  8.862788394120256e-23, -5.018165545068781e-24,  2.510293365540978e-25,
 -1.126277046676734e-26,  4.586111908361680e-28, -1.709170454692287e-29,  2.993974314067421e-18, -1.128815281444605e-18,  2.258014203948016e-19, -3.076911576949593e-20,
  3.186440066529015e-21, -2.666595728453144e-22,  1.875436014767135e-23, -1.139057255117596e-24,  6.094508198401426e-26, -2.916669332720979e-27,  1.263555417049059e-28,
 -4.997210439970212e-30,  4.929534659487423e-19, -1.985389334003643e-19,  4.259713533679784e-20, -6.217199046377731e-21,  6.879580182006742e-22, -6.135463114108898e-23,
  4.586583967814817e-24, -2.953456080653350e-25,  1.671365282159214e-26, -8.440519267162817e-28,  3.850151469392004e-29, -1.599785479716857e-30,  1.038277164505133e-19,
 -4.386291172910145e-20,  9.908933028928571e-21, -1.521612207160653e-21,  1.768508876177544e-22, -1.653505505932971e-23,  1.293382217625659e-24, -8.698272644349263e-26,
  5.131630121088066e-27, -2.697030343692022e-28,  1.278243992303574e-29, -5.509301814197191e-31,  2.344648956222209e-20, -1.017983367696949e-20,  2.369472420100196e-21,
 -3.747701256830635e-22,  4.482310772752475e-23, -4.307883098270539e-24,  3.459921852632216e-25, -2.386596304890561e-26,  1.442610086468522e-27, -7.760452856253027e-29,
  3.760990557678989e-30, -1.655945358039394e-31,  7.724813513514929e-02, -2.481739266542766e-04,  8.300539391475140e-07, -2.871392498514465e-09,  1.017681632202920e-11,
 -3.673994354949478e-14,  1.336954893999192e-16, -4.918184549636257e-19,  1.795781433034688e-21, -6.685953118758661e-24,  2.391952805573885e-26, -9.233660019319840e-29,
  6.766228561685192e-02, -2.648331336572572e-04,  1.277173368540223e-06, -6.476839938443552e-09,  3.254812621794869e-11, -1.600971023528198e-13,  7.705887540278802e-16,
 -3.642302154684741e-18,  1.693154262385045e-20, -7.770769904492251e-23,  3.517021792135969e-25, -1.578856451322289e-27,  5.190828692670321e-02, -2.763600616512517e-04,
  1.904087664845990e-06, -1.260521899931820e-08,  7.893741000708111e-11, -4.736758397268996e-13,  2.749272881591258e-15, -1.552530382531926e-17,  8.564239344327524e-20,
 -4.628484279745541e-22,  2.456422298210731e-24, -1.282518387302495e-26,  3.487430414675551e-02, -2.600650541319179e-04,  2.348123228323392e-06, -1.901050726510315e-08,
  1.428444112583338e-10, -1.017306724000313e-12,  6.943118893248151e-15, -4.573123948685184e-17,  2.922060205156375e-19, -1.818225597309442e-21,  1.105258259760390e-23,
 -6.578748996958686e-26,  2.051538255634465e-02, -2.120465621540291e-04,  2.375113993096207e-06, -2.297223120120812e-08,  2.036986160397840e-10, -1.693532983206758e-12,
  1.337038892205199e-14, -1.011132028576861e-16,  7.371732929315536e-19, -5.205982342909072e-21,  3.574811769564965e-23, -2.393779220479428e-25,  1.056503523485475e-02,
 -1.478128684054313e-04,  1.996647341944918e-06, -2.279645751873674e-08,  2.356634304123843e-10, -2.259645370411229e-12,  2.040083392437844e-14, -1.752296365807835e-16,
  1.442707929309017e-18, -1.144974378327212e-20,  8.797545688234931e-23, -6.566852031785267e-25,  4.761973508672611e-03, -8.790952309642413e-05,  1.411178813262230e-06,
 -1.885287830086174e-08,  2.250632779322286e-10, -2.466589744486223e-12,  2.525409636042539e-14, -2.444310901549417e-16,  2.255640744510417e-18, -1.997277346901033e-20,
  1.705330047625275e-22, -1.409471895853951e-24,  1.878209544107127e-03, -4.469119268393352e-05,  8.453633992301240e-07, -1.311870746718701e-08,  1.795180437752653e-10,
 -2.233609330032401e-12,  2.577092959478020e-14, -2.794001269825104e-16,  2.873508463869809e-18, -2.823340577019990e-20,  2.664764492723740e-22, -2.426360995695601e-24,
  6.481653505954969e-04, -1.947825282470856e-05,  4.316758084935268e-07, -7.733721683324380e-09,  1.206157625280111e-10, -1.694910585648491e-12,  2.193024203565974e-14,
 -2.651015538211231e-16,  3.025282905123047e-18, -3.284528984444891e-20,  3.412998135536283e-22, -3.410204561189522e-24,  1.957077438033725e-04, -7.300228926822882e-06,
  1.887013657176745e-07, -3.883105322499578e-09,  6.871388332678123e-11, -1.086081054434406e-12,  1.569943731971712e-14, -2.108479735455660e-16,  2.660786028599740e-18,
 -3.181658824686294e-20,  3.628408251626769e-22, -3.966285155660232e-24,  5.171203601232818e-05, -2.359558638610191e-06,  7.086087398072479e-08, -1.667917219132126e-09,
  3.336973068074921e-11, -5.913667066815484e-13,  9.521752687380354e-15, -1.416798013933125e-16,  1.971896454319777e-18, -2.590365997853596e-20,  3.234147685723439e-22,
 -3.858513390177272e-24,  1.196320055303353e-05, -6.595307341084813e-07,  2.293043754078374e-08, -6.152762382844127e-10,  1.387855929953056e-11, -2.750733275230419e-13,
  4.922079850621782e-15, -8.096755474809863e-17,  1.240327822203430e-18, -1.786479327921066e-20,  2.437328713235506e-22, -3.167898114558826e-24,  2.425354107157387e-06,
 -1.598733312212554e-07,  6.414207195977590e-09, -1.956547810524049e-10,  4.964770215280354e-12, -1.098404220139855e-13,  2.180420926020870e-15, -3.958821389543256e-17,
  6.664559743072292e-19, -1.050938406336640e-20,  1.564561918790774e-22, -2.212302699689815e-24,  4.315627371381522e-07, -3.371368263707943e-08,  1.556198439257749e-09,
 -5.384221299265472e-11,  1.534304346889172e-12, -3.783504493772726e-14,  8.321141060406991e-16, -1.665523941541215e-17,  3.077850288297584e-19, -5.307996377230849e-21,
  8.613786724742725e-23, -1.323727129495360e-24,  6.756148059144323e-08, -6.207705144948604e-09,  3.287710725344062e-10, -1.287831516260197e-11,  4.115677262723272e-13,
 -1.129977748092464e-14,  2.750818597252572e-16, -6.064661196661452e-18,  1.229290125930698e-19, -2.316815315946908e-21,  4.095335514415637e-23, -6.834968366658897e-25,
  9.339147234893124e-09, -1.002695503319366e-09,  6.077838298869861e-11, -2.691265855680959e-12,  9.635624827838080e-14, -2.943153012639960e-15,  7.925569806023037e-17,
 -1.923583623428100e-18,  4.274556963054131e-20, -8.799838524988299e-22,  1.693578442148405e-23, -3.068255101418535e-25,  1.145909177518346e-09, -1.429405207852953e-10,
  9.893564045486702e-12, -4.945803732695972e-13,  1.982200448818380e-14, -6.731974830307398e-16,  2.004496463714672e-17, -5.353970921908969e-19,  1.303949172369432e-20,
 -2.931374483721355e-22,  6.140678110596347e-24, -1.207306576375372e-25,  1.257440813066196e-10, -1.813036407083279e-11,  1.429813751416742e-12, -8.059990806198101e-14,
  3.613592050283678e-15, -1.364001513190428e-16,  4.489557278427916e-18, -1.319405812131831e-19,  3.521258263945349e-21, -8.643132852348749e-23,  1.970446564920492e-24,
 -4.203445251498591e-26,  1.247114049172185e-11, -2.068551114528490e-12,  1.854761845201536e-13, -1.177656603364919e-14,  5.902490597004250e-16, -2.475283656915382e-17,
  9.004008649834585e-19, -2.911018489727174e-20,  8.512258943216690e-22, -2.281026797431855e-23,  5.658722857639860e-25, -1.309581121277272e-26,  1.134443994162290e-12,
 -2.154547361705385e-13,  2.191548183651794e-14, -1.565329495993267e-15,  8.763950272436747e-17, -4.081203193502435e-18,  1.640109433476114e-19, -5.831809626059132e-21,
  1.868045926760075e-22, -5.463786401761790e-24,  1.474622661498729e-25, -3.701340181277789e-27,  9.657920356683218e-14, -2.090031878073538e-14,  2.405482249659736e-15,
 -1.929668868622243e-16,  1.205529612118556e-17, -6.228942042828731e-19,  2.763725012811809e-20, -1.080214047054535e-21,  3.788452962900054e-23, -1.208869390188554e-24,
  3.547763958683864e-26, -9.653239090388067e-28,  7.908676697196696e-15, -1.939556392509600e-15,  2.517741194166211e-16, -2.263306676671665e-17,  1.575053850184090e-18,
 -9.017208322161682e-20,  4.411877252188342e-21, -1.893421472255324e-22,  7.263061863249129e-24, -2.525891893804099e-25,  8.052826356018925e-27, -2.372840497076635e-28,
  6.461285969831137e-16, -1.784150377523603e-16,  2.601023946229409e-17, -2.611551376574574e-18,  2.018926888503265e-19, -1.277621230447083e-20,  6.878387981153721e-22,
 -3.234788088212319e-23,  1.354585402876760e-24, -5.124747788127142e-26,  1.771628976763915e-27, -5.642931692703772e-29,  5.523175693806640e-17, -1.703400684665746e-17,
  2.772506933882635e-18, -3.093997066117405e-19,  2.645719606757634e-20, -1.843467113768501e-21,  1.088125931785341e-22, -5.588380889412052e-24,  2.546301688286411e-25,
 -1.044644107331520e-26,  3.903828021402715e-28, -1.340015322595178e-29,  5.242271427722257e-18, -1.787403291811777e-18,  3.221412964680455e-19, -3.966861680927328e-20,
  3.727492456965196e-21, -2.842274046736165e-22,  1.828816972696960e-23, -1.020107482286403e-24,  5.030949700248811e-26, -2.226874249774529e-27,  8.951575318113386e-29,
 -3.295457199620533e-30,  5.919010908163921e-19, -2.202401140075846e-19,  4.345646930399217e-20, -5.843834280962425e-21,  5.976019246837799e-22, -4.941520501494884e-23,
  3.436103954310054e-24, -2.064518652222720e-25,  1.093337145044748e-26, -5.181585215684984e-28,  2.223992947556649e-29, -8.718256386219827e-31,  8.508736924115308e-20,
 -3.399844761330363e-20,  7.233419576009458e-21, -1.047143547631867e-21,  1.149673584176065e-22, -1.017708456760865e-23,  7.554188822827544e-25, -4.831737185733142e-26,
  2.716826717471899e-27, -1.363680051588847e-28,  6.184444456699160e-30, -2.555578492577330e-31,  1.608664016618511e-20, -6.770471118887868e-21,  1.523311913413874e-21,
 -2.329919538389692e-22,  2.697648877692923e-23, -2.513033598150053e-24,  1.958876958753719e-25, -1.313020670704825e-26,  7.721816339433021e-28, -4.046124459948415e-29,
  1.912126356217016e-30, -8.218805705177732e-32,  3.400511410332886e-21, -1.474629189109366e-21,  3.427807651565929e-22, -5.414471975554955e-23,  6.467478990553707e-24,
 -6.208084839309590e-25,  4.980123462262905e-26, -3.431247338817294e-27,  2.071761690761790e-28, -1.113303142314640e-29,  5.389904890021229e-31, -2.370798875606960e-32,
  7.626850590139829e-02, -2.416686086218122e-04,  7.965505073812238e-07, -2.714272057482001e-09,  9.473021563463710e-12, -3.369022525088650e-14,  1.206941700746365e-16,
 -4.380276019298977e-19,  1.571366924184203e-21, -5.806425054602648e-24,  2.014995559514308e-26, -7.955280775934582e-29,  6.662290780194910e-02, -2.549180189226054e-04,
  1.202473408112849e-06, -5.980714212992043e-09,  2.952317052133277e-11, -1.427680523771659e-13,  6.757876694265456e-16, -3.142667489912748e-18,  1.437140651831019e-20,
 -6.493581419344399e-23,  2.890723555539980e-25, -1.279243065807583e-27,  5.083238347728254e-02, -2.617116372761902e-04,  1.760101624240090e-06, -1.141456594179144e-08,
  7.009004485031298e-11, -4.126148542939692e-13,  2.350556303032025e-15, -1.303343480405265e-17,  7.062052484547161e-20, -3.750044648031474e-22,  1.956041190858393e-24,
 -1.003953420961468e-26,  3.387022198845050e-02, -2.421552085451472e-04,  2.133066964488124e-06, -1.687912903110443e-08,  1.240661216294390e-10, -8.650385153470820e-13,
  5.784289315587756e-15, -3.734797196115703e-17,  2.340567074514654e-19, -1.428971871652482e-21,  8.526179316200921e-24, -4.982681147637353e-26,  1.970352720556015e-02,
 -1.940953767712112e-04,  2.117938511214147e-06, -1.996750039964020e-08,  1.728206007706410e-10, -1.404115858370341e-12,  1.084315254862174e-14, -8.026567763320643e-17,
  5.731467893765146e-19, -3.966314584313213e-21,  2.670076682658349e-23, -1.753481396881795e-25,  1.000408376241480e-02, -1.328730889199031e-04,  1.744304005900138e-06,
 -1.936236218311062e-08,  1.949947315878873e-10, -1.824043593060087e-12,  1.608330484865763e-14, -1.350315887420819e-16,  1.087466694786242e-18, -8.446982050358069e-21,
  6.355715598325096e-23, -4.647880750087232e-25,  4.431563195902905e-03, -7.746735978589075e-05,  1.205023049835789e-06, -1.561577718139870e-08,  1.812775928261835e-10,
 -1.935084023436702e-12,  1.932118804258504e-14, -1.825507634636218e-16,  1.645800907797578e-18, -1.424707871794532e-20,  1.189974787256263e-22, -9.626267880009536e-25,
  1.712038284550339e-03, -3.851234378148920e-05,  7.038004734683246e-07, -1.057267526184087e-08,  1.404471677254060e-10, -1.699465318233924e-12,  1.909579922322861e-14,
 -2.018451444968821e-16,  2.025758768340036e-18, -1.943843033109129e-20,  1.792975248070747e-22, -1.596428078555967e-24,  5.766145288962710e-04, -1.636565975758353e-05,
  3.494178030410442e-07, -6.048798216558860e-09,  9.143177982720906e-11, -1.247724626141995e-12,  1.570217900002918e-14, -1.848444195019557e-16,  2.056270226571677e-18,
 -2.178130763667570e-20,  2.209890647237572e-22, -2.157393562048581e-24,  1.692552997462135e-04, -5.959844024607151e-06,  1.480450399821889e-07, -2.938830897879233e-09,
  5.032749693297488e-11, -7.714841206865608e-13,  1.083368889127117e-14, -1.415371055588454e-16,  1.739413051380671e-18, -2.027450859202647e-20,  2.255668358412750e-22,
 -2.407265885163033e-24,  4.329253664007845e-05, -1.864479526807974e-06,  5.369588036360953e-08, -1.217434563261647e-09,  2.353978222484448e-11, -4.040986556107982e-13,
  6.313983369188950e-15, -9.130099707629495e-17,  1.236385775391506e-18, -1.581899243451575e-20,  1.925366557438811e-22, -2.241069241597029e-24,  9.650029966619578e-06,
 -5.022254603762549e-07,  1.671677959006669e-08, -4.315097497538377e-10,  9.395639934415452e-12, -1.801966506481073e-13,  3.125956351453402e-15, -4.992816582407232e-17,
  7.435794350693217e-19, -1.042369315622540e-20,  1.385435772384824e-22, -1.755754224907851e-24,  1.875325866403049e-06, -1.167508799198376e-07,  4.478748806676730e-09,
 -1.312872666065953e-10,  3.212591326646875e-12, -6.871274383019266e-14,  1.321267450994471e-15, -2.327500728445440e-17,  3.806761947120342e-19, -5.838837315665295e-21,
  8.463466452937325e-23, -1.166278094432904e-24,  3.180365337257120e-07, -2.348236323091591e-08,  1.035539283713590e-09, -3.440245675210524e-11,  9.446176853136491e-13,
 -2.250285284288818e-14,  4.790817752106039e-16, -9.297948807648614e-18,  1.668424216981664e-19, -2.797316138592022e-21,  4.417957359634575e-23, -6.613936689944756e-25,
  4.715026365092986e-08, -4.098851717626262e-09,  2.073054326619121e-10, -7.793114003077166e-12,  2.398443577889947e-13, -6.358094859354815e-15,  1.497584520719357e-16,
 -3.200039100990068e-18,  6.295887945731679e-20, -1.153181897242417e-21,  1.983280093564664e-23, -3.223713964866913e-25,  6.128132893634565e-09, -6.233232362711351e-10,
  3.608161125670890e-11, -1.532986262040779e-12,  5.284161539815223e-14, -1.557950080729338e-15,  4.058144124595578e-17, -9.543875303220393e-19,  2.058123516694796e-20,
 -4.117064880233567e-22,  7.708172673865180e-24, -1.359954923120990e-25,  7.013052841669923e-10, -8.301596808248025e-11,  5.489744498195496e-12, -2.633600140104758e-13,
  1.016230462773733e-14, -3.331432347868711e-16,  9.595040620326886e-18, -2.483338060950824e-19,  5.869450597609682e-21, -1.282217638115240e-22,  2.613198714304424e-24,
 -5.003869991095108e-26,  7.112960898238976e-11, -9.752464299576475e-12,  7.355081183543379e-13, -3.981118396269088e-14,  1.719172701607579e-15, -6.265912016726185e-17,
  1.995522583157482e-18, -5.684286364025475e-20,  1.472649997499181e-21, -3.513645642357822e-23,  7.795693421905678e-25, -1.620219401428221e-26,  6.454751402732454e-12,
 -1.020645741770172e-12,  8.764533403736900e-14, -5.349042584264335e-15,  2.584448332859731e-16, -1.047281874030553e-17,  3.688485583925391e-19, -1.156582029561283e-20,
  3.285092098565623e-22, -8.562137622027039e-24,  2.068413239439193e-25, -4.666552391731312e-27,  5.312473225574988e-13, -9.647597340943131e-14,  9.417289042571021e-15,
 -6.475683240845751e-16,  3.499754462516910e-17, -1.576706737801191e-18,  6.141685373215357e-20, -2.120260632390399e-21,  6.603571157081806e-23, -1.880426547322339e-24,
  4.946806700918336e-26, -1.211596743191094e-27,  4.042392358199204e-14, -8.395066778769741e-15,  9.296953620355983e-16, -7.195819970280535e-17,  4.347770519089834e-18,
 -2.177120393062057e-19,  9.378097933426938e-21, -3.564194370535347e-22,  1.217167073408926e-23, -3.786589687176517e-25,  1.084668501859556e-26, -2.883699242199969e-28,
  2.920924713969838e-15, -6.903667593785089e-16,  8.651963863417900e-17, -7.525889238005558e-18,  5.078307042894660e-19, -2.824223111908986e-20,  1.344487105447788e-21,
 -5.622293653635601e-23,  2.104176388511393e-24, -7.147978564616108e-26,  2.228372267640737e-27, -6.427132375484981e-29,  2.079057400248770e-16, -5.559963195817812e-17,
  7.857664031655706e-18, -7.661845933183950e-19,  5.762285644589979e-20, -3.553053485117142e-21,  1.866510068808503e-22, -8.576148863777216e-24,  3.512875570956010e-25,
 -1.301371865694275e-26,  4.409593074976231e-28, -1.377941487455468e-29,  1.531103955910971e-17, -4.598591574880432e-18,  7.291112639958908e-19, -7.936523872196261e-20,
  6.628958783214792e-21, -4.517452415535654e-22,  2.611042507555259e-23, -1.314538450876568e-24,  5.877408556066803e-26, -2.368285859601743e-27,  8.699937523442772e-29,
 -2.937985616189805e-30,  1.242929823837792e-18, -4.151802534178756e-19,  7.329152368351210e-20, -8.847877516751552e-21,  8.159097957353188e-22, -6.111687826131095e-23,
  3.866736117450820e-24, -2.122652759262911e-25,  1.031081770426711e-26, -4.498568740257665e-28,  1.783674550003495e-29, -6.481287423916531e-31,  1.200521700856302e-19,
 -4.403010573054297e-20,  8.559233979489234e-21, -1.134593810249888e-21,  1.144508563894454e-22, -9.341952215273403e-24,  6.416606471562167e-25, -3.810609914125789e-26,
  1.995826485274205e-27, -9.359732924752623e-29,  3.977309813158242e-30, -1.544394827609436e-31,  1.494169914611975e-20, -5.918256470985760e-21,  1.247582587497914e-21,
 -1.789945193813135e-22,  1.948454381197643e-23, -1.710819576022997e-24,  1.260120769437152e-25, -8.000936351135618e-27,  4.467581547880088e-28, -2.227645626606771e-29,
  1.003917474715116e-30, -4.123713304701627e-32,  2.514581808836710e-21, -1.053940423557645e-21,  2.360728869487419e-22, -3.595010257078552e-23,  4.144981739270012e-24,
 -3.845888526774052e-25,  2.986410108596257e-26, -1.994515155573991e-27,  1.168918819360847e-28, -6.104844988544144e-30,  2.876006009339159e-31, -1.232498729820681e-32,
  4.946570573395291e-22, -2.142257586213404e-22,  4.972533372043430e-23, -7.843229124079798e-24,  9.355547564810338e-25, -8.968265185179665e-26,  7.185042733842519e-27,
 -4.944258629577086e-28,  2.981738586725229e-29, -1.600455529964324e-30,  7.739814293593622e-32, -3.400812084728471e-33,  7.531437356174113e-02, -2.354239631665738e-04,
  7.648669158718652e-07, -2.567940833525125e-09,  8.827218778474805e-12, -3.093524812996540e-14,  1.091030155514229e-16, -3.909394636015994e-19,  1.376028126156863e-21,
 -5.067390973214684e-24,  1.687126866008156e-26, -7.000903382117327e-29,  6.562203182433392e-02, -2.455774870645424e-04,  1.133447609984319e-06, -5.530334156058786e-09,
  2.682313063338841e-11, -1.275552004621910e-13,  5.938952323851696e-16, -2.718059450062057e-18,  1.222896685594387e-20, -5.442447490741554e-23,  2.382308474035251e-25,
 -1.040659297066247e-27,  4.981285715920671e-02, -2.481602668138338e-04,  1.629592751885989e-06, -1.035619811408064e-08,  6.237359016878596e-11, -3.603373281919395e-13,
  2.015331458509163e-15, -1.097530290468380e-17,  5.842845531011394e-20, -3.049247573193933e-22,  1.563575582505405e-24, -7.890940106707113e-27,  3.293449337939772e-02,
 -2.258683925971146e-04,  1.941880335085514e-06, -1.502527544657191e-08,  1.080730561425883e-10, -7.379634232169414e-13,  4.836115490114401e-15, -3.061948138990361e-17,
  1.882588763631992e-19, -1.128015814704565e-21,  6.608189615960389e-24, -3.792437023272564e-26,  1.895957884515302e-02, -1.780653475380837e-04,  1.894036367443987e-06,
 -1.741361831648440e-08,  1.471687744410586e-10, -1.168901888808245e-12,  8.832404301935686e-15, -6.401763809526310e-17,  4.478603143838486e-19, -3.037910876804941e-21,
  2.005494978489903e-23, -1.291983654676523e-25,  9.499100118084523e-03, -1.197976540857995e-04,  1.529535871387961e-06, -1.651453901126989e-08,  1.620867923231669e-10,
 -1.479746990282044e-12,  1.274716991948620e-14, -1.046448221187109e-16,  8.246043339221987e-19, -6.270885378695397e-21,  4.621839548206052e-23, -3.312214827854106e-25,
  4.139853255347727e-03, -6.853021103864044e-05,  1.033836326424106e-06, -1.300139088707001e-08,  1.468278313576892e-10, -1.527204360838369e-12,  1.487607968896750e-14,
 -1.372496581611887e-16,  1.209275687332328e-18, -1.023732305881676e-20,  8.366952011557611e-23, -6.626440420941843e-25,  1.568496912427193e-03, -3.335365721647806e-05,
  5.893653616879221e-07, -8.574331705491360e-09,  1.106183517782308e-10, -1.302261273377353e-12,  1.425560070874234e-14, -1.469598009741308e-16,  1.439765466005596e-18,
 -1.349647388206344e-20,  1.216961949762511e-22, -1.059864363398800e-24,  5.163156329456628e-04, -1.383756193978663e-05,  2.848479978049982e-07, -4.766684698685869e-09,
  6.986214433564295e-11, -9.262124200446301e-13,  1.134103049918602e-14, -1.300535650691774e-16,  1.410760330896323e-18, -1.458420580487080e-20,  1.445159542876140e-22,
 -1.378810209607743e-24,  1.475791808183440e-04, -4.903945639797569e-06,  1.171436639499893e-07, -2.244143613872636e-09,  3.720674924881872e-11, -5.533592595430408e-13,
  7.551491847654694e-15, -9.600062322675553e-17,  1.149286885677025e-18, -1.306177883294070e-20,  1.418093853157270e-22, -1.477895450057922e-24,  3.660951953893041e-05,
 -1.487511270546694e-06,  4.110425483622870e-08, -8.980154019938927e-10,  1.678714630681991e-11, -2.792468928412698e-13,  4.235419857749344e-15, -5.953559560163588e-17,
  7.846509180250802e-19, -9.780491536585376e-21,  1.160742823434090e-22, -1.318432870031410e-24,  7.879079369146580e-06, -3.868976710799868e-07,  1.233372701029785e-08,
 -3.063657623173740e-10,  6.441252120930921e-12, -1.195727078522074e-13,  2.011509521171906e-15, -3.120293580228662e-17,  4.518941530254736e-19, -6.166805031309683e-21,
  7.986636480579347e-23, -9.870648974930649e-25,  1.471113299705910e-06, -8.644311049363791e-08,  3.171390184841250e-09, -8.935600065705535e-11,  2.109020523552628e-12,
 -4.361933119845514e-14,  8.126452783760770e-16, -1.389189507806027e-17,  2.207851903219855e-19, -3.294443407147567e-21,  4.650305977614233e-23, -6.246017354373809e-25,
  2.383833850460218e-07, -1.662297560788166e-08,  7.003467510563430e-10, -2.234305218574641e-11,  5.912158617590749e-13, -1.360783018429889e-14,  2.804828383209923e-16,
 -5.279009668692967e-18,  9.199198253754342e-20, -1.499644549821844e-21,  2.305323454950966e-23, -3.362382836200847e-25,  3.356025743347441e-08, -2.757771781498626e-09,
  1.331750074076100e-10, -4.804425437596373e-12,  1.423985263702083e-13, -3.644947976249723e-15,  8.307132528192712e-17, -1.720513590691727e-18,  3.285762057403029e-20,
 -5.849261074485438e-22,  9.787977951048786e-24, -1.549548665003730e-25,  4.113191732403056e-09, -3.959452669656727e-10,  2.187979323200904e-11, -8.917776471560563e-13,
  2.959102414953085e-14, -8.420734051764402e-16,  2.121567598751009e-17, -4.834503262636918e-19,  1.011690996468054e-20, -1.966435766220023e-22,  3.581449282839320e-24,
 -6.153177559061673e-26,  4.403864021009774e-10, -4.941059108211300e-11,  3.120013671221553e-12, -1.435847208696028e-13,  5.332937840657369e-15, -1.687164451009833e-16,
  4.699466492322589e-18, -1.178383689542858e-19,  2.702472436622986e-21, -5.736120623674120e-23,  1.137196102463620e-24, -2.120520595908012e-26,  4.141525451830182e-11,
 -5.392400738190599e-12,  3.886117225455222e-13, -2.018615763433804e-14,  8.392425012281463e-16, -2.952444708891667e-17,  9.094901317837412e-19, -2.510354392408722e-20,
  6.311681691263160e-22, -1.463448065807398e-23,  3.159152823883289e-25, -6.395348103488518e-27,  3.449581898416710e-12, -5.192049173694054e-13,  4.265711821991624e-14,
 -2.500489503336876e-15,  1.163912648768461e-16, -4.554995688877946e-18,  1.552520026517299e-19, -4.719478752848101e-21,  1.301543917473640e-22, -3.298185080871117e-24,
  7.755992547042454e-26, -1.705246069013207e-27,  2.576353775345526e-13, -4.466306590809089e-14,  4.178709426664555e-15, -2.763669064925423e-16,  1.440585829297652e-17,
 -6.274280678242655e-19,  2.367390191893320e-20, -7.930176935816071e-22,  2.400135335514427e-23, -6.650532167103117e-25,  1.704470318056992e-26, -4.071644006680618e-28,
  1.756601354855320e-14, -3.494486978702738e-15,  3.718403031105605e-16, -2.773616882397671e-17,  1.619133413066168e-18, -7.850263593540756e-20,  3.280275651743255e-21,
 -1.211318149923591e-22,  4.025088901404787e-24, -1.220011231149034e-25,  3.408872955746414e-27, -8.849844770823455e-29,  1.121878505362639e-15, -2.550513387718391e-16,
  3.081097243971763e-17, -2.589839443879233e-18,  1.692483790035950e-19, -9.133559373725962e-21,  4.226449099359083e-22, -1.720556189970079e-23,  6.277157964843862e-25,
 -2.081237015181792e-26,  6.339674674926004e-28, -1.788512048304181e-29,  6.959590642045494e-17, -1.798977669155497e-17,  2.460509488050255e-18, -2.326522901422982e-19,
  1.699927341031246e-20, -1.020085599488591e-21,  5.223057760644745e-23, -2.342285133987054e-24,  9.375609060444390e-26, -3.397935629115061e-27,  1.127548924289167e-28,
 -3.453930147648677e-30,  4.408896784002789e-18, -1.287102003029928e-18,  1.984523485458676e-19, -2.103863963935895e-20,  1.714034398402809e-21, -1.140958594229478e-22,
  6.449912928684615e-24, -3.179715565879997e-25,  1.393615293521187e-26, -5.510121221824192e-28,  1.987957024580704e-29, -6.599038604759676e-31,  3.049044657135105e-19,
 -9.960873922208894e-20,  1.719560125594133e-20, -2.032146493871642e-21,  1.836580822706730e-22, -1.349776252194617e-23,  8.387365764097918e-25, -4.526409246039729e-26,
  2.163430781141712e-27, -9.295041065283104e-29,  3.631996770607236e-30, -1.301541415890890e-31,  2.502689206472387e-20, -9.034936913965527e-21,  1.728076333578379e-21,
 -2.255253995168763e-22,  2.241518391596283e-23, -1.804138378842000e-24,  1.222842116385272e-25, -7.171256933098099e-27,  3.711432013940527e-28, -1.720927273360728e-29,
  7.234574913907317e-31, -2.780633389627543e-32,  2.673452557312822e-21, -1.048743428576680e-21,  2.188449970820719e-22, -3.109122586040068e-23,  3.352880237348885e-24,
 -2.917885643109661e-25,  2.131143744139406e-26, -1.342355884075191e-27,  7.438816982465597e-29, -3.682552008698615e-30,  1.648269700039129e-31, -6.726653604924680e-33,
  3.969144514498001e-22, -1.655953694242979e-22,  3.690920578737661e-23, -5.593657710983810e-24,  6.419675296878799e-25, -5.930298973705647e-26,  4.585772400422434e-27,
 -3.050516719149657e-28,  1.781060099051067e-29, -9.268452559673561e-31,  4.351471566963112e-32, -1.858750807612364e-33,  7.218911448610955e-23, -3.121872374973523e-23,
  7.234973668076701e-24, -1.139401526003082e-24,  1.357045229376156e-25, -1.298975200951593e-26,  1.039234882306046e-27, -7.141700000710830e-29,  4.301394253999672e-30,
 -2.305922399290553e-31,  1.113817496206838e-32, -4.888435487130227e-34,  7.438472374502544e-02, -2.294259341114779e-04,  7.348790725014278e-07, -2.431516336777008e-09,
  8.233836905310831e-12, -2.844331975064788e-14,  9.874664078970513e-17, -3.497010305268142e-19,  1.205026373932987e-21, -4.452067842673025e-24,  1.394012086333020e-26,
 -6.380794791782073e-29,  6.465744678308634e-02, -2.367682553103645e-04,  1.069576873997239e-06, -5.120823561530183e-09,  2.440861800619645e-11, -1.141725096887637e-13,
  5.229862109402467e-16, -2.356327828417235e-18,  1.043072085454428e-20, -4.575190411788512e-23,  1.967813273107770e-25, -8.505368851959201e-28,  4.884552575516049e-02,
 -2.356041878342839e-04,  1.511076652682301e-06, -9.413347461221223e-09,  5.562668155627570e-11, -3.154555253506798e-13,  1.732630955138392e-15, -9.269805537872221e-18,
  4.849806037902706e-20, -2.488050872499547e-22,  1.254516392670670e-24, -6.226645004638936e-27,  3.206098804451533e-02, -2.110262493985015e-04,  1.771484647003992e-06,
 -1.340815411474635e-08,  9.440837575932595e-11, -6.315398291170264e-13,  4.057350827319620e-15, -2.519701107829485e-17,  1.520320054666569e-19, -8.942492054222725e-22,
  5.145033005317955e-24, -2.900242458829844e-26,  1.827635286292368e-02, -1.637105851855481e-04,  1.698465385014726e-06, -1.523500632624674e-08,  1.257732817961705e-10,
 -9.769104299560330e-13,  7.225153329885134e-15, -5.129158787230907e-17,  3.516632966393163e-19, -2.338777790578771e-21,  1.514502034039890e-23, -9.573423861648515e-26,
  9.043186376890101e-03, -1.083121233380944e-04,  1.345996347878964e-06, -1.414223266773416e-08,  1.353284081597728e-10, -1.206190312652022e-12,  1.015498748638793e-14,
 -8.153937104855027e-17,  6.288947892982976e-19, -4.683655858351780e-21,  3.382353099537724e-23, -2.376020055820864e-25,  3.881339159289566e-03, -6.084585152211858e-05,
  8.909665994358511e-07, -1.087833196633021e-08,  1.195639547022738e-10, -1.212240369953451e-12,  1.152373523661839e-14, -1.038565976471719e-16,  8.945546031985285e-19,
 -7.408164586437268e-21,  5.926332823782433e-23, -4.596320029276866e-25,  1.443900491951333e-03, -2.902207930134666e-05,  4.962898570557098e-07, -6.995521406120289e-09,
  8.768628231933137e-11, -1.004716641851353e-12,  1.071890302796815e-14, -1.078059580806254e-16,  1.031332182777180e-18, -9.447418728408221e-21,  8.329872994240370e-23,
 -7.097875603818195e-25,  4.651857700043859e-04, -1.176989387584034e-05,  2.337879767651643e-07, -3.783447847565250e-09,  5.378922375696687e-11, -6.930723697981855e-13,
  8.259937753117358e-15, -9.230279941264058e-17,  9.766511417591484e-19, -9.856515000502152e-21,  9.541673186037649e-23, -8.899362562539122e-25,  1.296803958246575e-04,
 -4.065176367633247e-06,  9.345014030833166e-08, -1.728370323523686e-09,  2.775395984735697e-11, -4.006221225068739e-13,  5.314790316936103e-15, -6.576792201531689e-17,
  7.672223293706636e-19, -8.504412305460416e-21,  9.012406415847970e-23, -9.174429544182729e-25,  3.125482201727296e-05, -1.197607060297902e-06,  3.177178926689098e-08,
 -6.690971818804532e-10,  1.209707370440107e-11, -1.950593801979853e-13,  2.872801469813652e-15, -3.926660126947523e-17,  5.038085033798027e-19, -6.119594711633019e-21,
  7.083461399164836e-23, -7.853227382381997e-25,  6.507798136947349e-06, -3.013474639032419e-07,  9.204530488581478e-09, -2.200844329199104e-10,  4.469440506417731e-12,
 -8.033164007801616e-14,  1.310849507924397e-15, -1.975382884237066e-17,  2.782653256987453e-19, -3.697532309491002e-21,  4.667113439336318e-23, -5.626292106261032e-25,
  1.170022431496122e-06, -6.484744288476026e-08,  2.275898395927742e-09, -6.165025046320940e-11,  1.403865745432621e-12, -2.808312917843768e-14,  5.070329759603307e-16,
 -8.413024746279057e-18,  1.299544530793026e-19, -1.886804060432429e-21,  2.594061357679280e-23, -3.396569691457982e-25,  1.816014310899077e-07, -1.195039228511031e-08,
  4.810662501347781e-10, -1.473995475692986e-11,  3.759308677721794e-13, -8.361517509411188e-15,  1.668857060640589e-16, -3.046503510589378e-18,  5.156331167526269e-20,
 -8.174124949150615e-22,  1.223214362708245e-23, -1.738377417486197e-25,  2.434300744299095e-08, -1.889161712641150e-09,  8.709728523680624e-11, -3.015382437562756e-12,
  8.607490936861221e-14, -2.127568207157553e-15,  4.692172246120468e-17, -9.420167156953252e-19,  1.746407407691973e-20, -3.021790727408842e-22,  4.920267946172751e-24,
 -7.586890363734589e-26,  2.821589118473702e-09, -2.567841426447945e-10,  1.354189020181539e-11, -5.294070549856787e-13,  1.690937930556421e-14, -4.644234331939378e-16,
  1.131736457365666e-17, -2.498804943681846e-19,  5.074262136225172e-21, -9.583297977051892e-23,  1.697862811598687e-24, -2.840546663608135e-26,  2.835056802974754e-10,
 -3.011355616745443e-11,  1.814767039037443e-12, -8.009192884328569e-14,  2.862643235185137e-15, -8.738496741884714e-17,  2.353652264517645e-18, -5.717102436642380e-20,
  1.272078620117753e-21, -2.623108838318650e-23,  5.058169227734275e-25, -9.183905178619128e-27,  2.480082852572011e-11, -3.062379558167441e-12,  2.107344529337173e-13,
 -1.049961332267078e-14,  4.201044885948313e-16, -1.426071882624256e-17,  4.247956786977107e-19, -1.135861433955537e-20,  2.770896241422845e-22, -6.242090376132476e-24,
  1.310772424160636e-25, -2.584073501668194e-27,  1.902225704206705e-12, -2.721143235167648e-13,  2.136922224531543e-14, -1.202262470675038e-15,  5.388249600689758e-17,
 -2.035509252389255e-18,  6.711154099311405e-20, -1.977012972393396e-21,  5.291845498104449e-23, -1.303326002434490e-24,  2.982480818284415e-26, -6.388194021399177e-28,
  1.293265510020712e-13, -2.136573322302025e-14,  1.913759213550975e-15, -1.216221581205131e-16,  6.109832074638116e-18, -2.570814245746647e-19,  9.390334147695517e-21,
 -3.050440987927052e-22,  8.967112601976453e-24, -2.416592231576205e-25,  6.031123570143925e-27, -1.404530896264097e-28,  7.923099073002772e-15, -1.507047458438701e-15,
  1.538694503062999e-16, -1.104832985022737e-17,  6.225234154630594e-19, -2.919875509149399e-20,  1.182608294299166e-21, -4.240078225514177e-23,  1.370013113068431e-24,
 -4.043205601575010e-26,  1.101305360121550e-27, -2.790313589968884e-29,  4.481941767830200e-16, -9.781627355346313e-17,  1.137222291686936e-17, -9.224741013861227e-19,
  5.831556963743543e-20, -3.050533445274751e-21,  1.370785660710701e-22, -5.427640250102503e-24,  1.928717508594710e-25, -6.236541175805739e-27,  1.854845290935504e-28,
 -5.114711058000062e-30,  2.425379132972028e-17, -6.047406689217751e-18,  7.990960844444515e-19, -7.315966037091643e-20,  5.186499330652425e-21, -3.025183824066350e-22,
  1.508045935158770e-23, -6.593754418201909e-25,  2.576687088033477e-26, -9.127661264656807e-28,  2.963670626448682e-29, -8.892015321946046e-31,  1.320429162674556e-18,
 -3.739257577465717e-19,  5.596714443388178e-20, -5.769420357563295e-21,  4.578243262948126e-22, -2.972912339208524e-23,  1.641740038697149e-24, -7.916363403840941e-26,
  3.397552325384065e-27, -1.316818645804824e-28,  4.661564305852636e-30, -1.519719926899332e-31,  7.752205830844234e-20, -2.472306422267013e-20,  4.166682737022973e-21,
 -4.812950044909151e-22,  4.257020911405262e-23, -3.065673107190373e-24,  1.868732660542377e-25, -9.903357329680048e-27,  4.652556378793952e-28, -1.966528069190143e-29,
  7.565637150888243e-31, -2.671445637260483e-32,  5.372741386927135e-21, -1.906338603137441e-21,  3.582326883555549e-22, -4.596691034760457e-23,  4.495982406469066e-24,
 -3.564221357826331e-25,  2.381423672493735e-26, -1.377740353619906e-27,  7.039302865735143e-29, -3.224440847096086e-30,  1.339910514966555e-31, -5.093731153534654e-33,
  4.882070270127928e-22, -1.894781666742496e-22,  3.909979866684423e-23, -5.495267020318776e-24,  5.865557382733527e-25, -5.055141276054685e-26,  3.658277176941453e-27,
 -2.284245438344381e-28,  1.255420112359162e-29, -6.166374630812825e-31,  2.739544720361144e-32, -1.110164696047875e-33,  6.332675966112910e-23, -2.628554529840246e-23,
  5.826793679398371e-24, -8.783717667911168e-25,  1.002961028489395e-25, -9.220284000385247e-27,  7.097139224889846e-28, -4.700553929216021e-29,  2.733097046179552e-30,
 -1.416689992904763e-31,  6.626428706497810e-33, -2.820484664947577e-34,  1.057244026933893e-23, -4.564934667552447e-24,  1.056107590535746e-24, -1.660384816101966e-25,
  1.974289283561861e-26, -1.886814801575662e-27,  1.507238462170004e-28, -1.034277060996161e-29,  6.220677090295504e-31, -3.330358805295347e-32,  1.606578038819728e-33,
 -7.042435708645190e-35,  7.347859638432497e-02, -2.236614171254744e-04,  7.064729604060175e-07, -2.304200364452039e-09,  7.687898486825158e-12, -2.618668692331561e-14,
  8.947150494238292e-17, -3.136023868062684e-19,  1.054121683386132e-21, -3.949633131022677e-24,  1.119800792826485e-26, -6.158072506978925e-29,  6.372710695879449e-02,
 -2.284509699253975e-04,  1.010397014124081e-06, -4.747893073593207e-09,  2.224552901480860e-11, -1.023763186271983e-13,  4.614448064099223e-16, -2.047449040134343e-18,
  8.916748787087422e-21, -3.858207909095773e-23,  1.628097583125711e-25, -6.994222707445039e-28,  4.792659156230333e-02, -2.239527500728019e-04,  1.403255528807827e-06,
 -8.571619285763886e-09,  4.971325099059097e-11, -2.768196109068076e-13,  1.493523064706049e-15, -7.852005672244870e-18,  4.038202893495976e-20, -2.036992805476500e-22,
  1.010192427453749e-24, -4.932129401609485e-27,  3.124424281066543e-02, -1.974732112604585e-04,  1.619249691243240e-06, -1.199360604221016e-08,  8.269691647961754e-11,
 -5.421082428779365e-13,  3.415374544358492e-15, -2.080972141536240e-17,  1.232554406942179e-19, -7.118536162814951e-22,  4.023637864148151e-24, -2.228070761985659e-26,
  1.764757452133029e-02, -1.508213581034650e-04,  1.527104021098103e-06, -1.336998426130480e-08,  1.078590370185082e-10, -8.195429211903047e-13,  5.934664769697761e-15,
 -4.127634342399685e-17,  2.774280775581570e-19, -1.809480369629454e-21,  1.149733332341228e-23, -7.132586104569453e-26,  8.630448668189383e-03, -9.818792146668753e-05,
  1.188525865421394e-06, -1.215746373238563e-08,  1.134679917086849e-10, -9.877407017369991e-13,  8.130031648593688e-15, -6.387055722412706e-17,  4.823119574480149e-19,
 -3.518688404671277e-21,  2.490506471099978e-23, -1.715358068331714e-25,  3.651428066056741e-03, -5.420950692442583e-05,  7.711507851040179e-07, -9.145173720907755e-09,
  9.786502529231048e-11, -9.675628277484368e-13,  8.979464324659519e-15, -7.907725055868224e-17,  6.660695769061119e-19, -5.397510108603866e-21,  4.227542735895197e-23,
 -3.211728222906686e-25,  1.335252919400375e-03, -2.536513599851809e-05,  4.201409958646068e-07, -5.740281130817967e-09,  6.993800138416291e-11, -7.802491677485714e-13,
  8.115497443279936e-15, -7.965844149169870e-17,  7.443679275724230e-19, -6.665265960452070e-21,  5.748243731749560e-23, -4.793566903189153e-25,  4.215786093594359e-04,
 -1.006755249973432e-05,  1.931255735901962e-07, -3.023760027979730e-09,  4.171776917105907e-11, -5.226193437046072e-13,  6.064494925113895e-15, -6.606100408528972e-17,
  6.820232546517209e-19, -6.721486557417228e-21,  6.358521599918625e-23, -5.798974402721765e-25,  1.147934442849938e-04, -3.393554779959314e-06,  7.513051760137761e-08,
 -1.342055610468444e-09,  2.088112750758477e-11, -2.926507400223285e-13,  3.775516120956982e-15, -4.549154114146069e-17,  5.172751317661076e-19, -5.593931724868788e-21,
  5.787939630087728e-23, -5.756678562357369e-25,  2.692617393995748e-05, -9.725328900139550e-07,  2.478638985438927e-08, -5.033508400489124e-10,  8.804919325173650e-12,
 -1.376695144817354e-13,  1.969463028048518e-15, -2.618388716591139e-17,  3.271459355956125e-19, -3.873351653992399e-21,  4.373869698558789e-23, -4.734250480510815e-25,
  5.434522565315208e-06, -2.371714487646709e-07,  6.944628270795630e-09, -1.598885106426789e-10,  3.137331523152759e-12, -5.461354898919155e-14,  8.647072747192265e-16,
 -1.266224369573391e-17,  1.735383310621628e-19, -2.245851446764060e-21,  2.763420289790684e-23, -3.250152085743097e-25,  9.428493851659179e-07, -4.925637291864993e-08,
  1.654273233852591e-09, -4.309290469298278e-11,  9.469965138972831e-13, -1.832746427258152e-14,  3.207510877140755e-16, -5.167010169677007e-18,  7.758935159429597e-20,
 -1.096347679562466e-21,  1.468374513312954e-23, -1.874610948375040e-25,  1.405059067080620e-07, -8.718554049022292e-09,  3.353906113978666e-10, -9.871250704557538e-12,
  2.427030505571456e-13, -5.217583837300191e-15,  1.008556141127424e-16, -1.786054181441239e-18,  2.936608860382013e-20, -4.527666448580020e-22,  6.596510497806734e-24,
 -9.135613235437905e-26,  1.797998868275750e-08, -1.316586114064810e-09,  5.794786463696779e-11, -1.925357301440751e-12,  5.293645024090732e-14, -1.263653931192200e-15,
  2.697091992719515e-17, -5.249320980925061e-19,  9.448030639080832e-21, -1.589106122203294e-22,  2.517936955712040e-24, -3.781933586194267e-26,  1.976558175242830e-09,
 -1.698818500056787e-10,  8.547805174190028e-12, -3.204923040418391e-13,  9.853179908367562e-15, -2.611913435669064e-16,  6.156295222188523e-18, -1.317060539941569e-19,
  2.595361537287512e-21, -4.762729745226692e-23,  8.208350507340819e-25, -1.337257576682563e-26,  1.869470596691199e-10, -1.877647952909266e-11,  1.079435589483955e-12,
 -4.567352513668351e-14,  1.570678349440900e-15, -4.625724827370913e-17,  1.204634498544446e-18, -2.834301090459591e-20,  6.118035082341878e-22, -1.225534453684799e-23,
  2.298415458926272e-25, -4.063073017750792e-27,  1.526178886449293e-11, -1.784766278208395e-12,  1.171941597096863e-13, -5.598173701040215e-15,  2.154928560452199e-16,
 -7.056459914133975e-18,  2.032099403473883e-19, -5.262667678224894e-21,  1.245374619157815e-22, -2.725247974273757e-24,  5.565813203473169e-26, -1.068348674693168e-27,
  1.081532657239898e-12, -1.468196780654237e-13,  1.101062978069740e-14, -5.941730577978429e-16,  2.562629730861277e-17, -9.340619678710685e-19,  2.977859928002018e-20,
 -8.498009512027897e-22,  2.207007706208813e-23, -5.281333269408194e-25,  1.175710501457347e-26, -2.452594057128263e-28,  6.715655273910625e-14, -1.055521941012671e-14,
  9.041020717402688e-16, -5.516222594806720e-17,  2.668730547691755e-18, -1.084146340772487e-19,  3.831394732177845e-21, -1.206374529682142e-22,  3.442707019967901e-24,
 -9.019525333554463e-26,  2.191051449350847e-27, -4.972306398534998e-29,  3.708229414695306e-15, -6.731422672260956e-16,  6.585517463518316e-17, -4.546813398331247e-18,
  2.470465802459897e-19, -1.120037868004095e-20,  4.393725717714511e-22, -1.528447382907385e-23,  4.799047249144550e-25, -1.378178214240427e-26,  3.657397667950173e-28,
 -9.038549791382696e-30,  1.862580354798032e-16, -3.894436432529944e-17,  4.350591802589316e-18, -3.401122149040597e-19,  2.077442213073802e-20, -1.052317886640273e-21,
  4.587648704300493e-23, -1.765235891139060e-24,  6.104806743667870e-26, -1.923680679968495e-27,  5.582158888685184e-29, -1.503508531746214e-30,  8.804642036402755e-18,
 -2.113137600834751e-18,  2.692944924325273e-19, -2.383599072704768e-20,  1.637314885350125e-21, -9.271579729535569e-23,  4.494778321461751e-24, -1.914180073015603e-25,
  7.295645983132762e-27, -2.523782117206389e-28,  8.011286406882984e-30, -2.352411850229528e-31,  4.117886382690874e-19, -1.128781589691119e-19,  1.637054473209445e-20,
 -1.638294542350453e-21,  1.264404525765677e-22, -7.998727943662516e-24,  4.309693310617977e-25, -2.030289891722197e-26,  8.523552713382618e-28, -3.235093909399924e-29,
  1.122644673634966e-30, -3.591240979065939e-32,  2.046356426828439e-20, -6.358318888773843e-21,  1.044285703624369e-21, -1.177113493022987e-22,  1.017440854354503e-23,
 -7.169797782057904e-25,  4.281931620086680e-26, -2.225740359434573e-27,  1.026667453575122e-28, -4.264756739906713e-30,  1.613886677001355e-31, -5.610072260487531e-33,
  1.190172545194435e-21, -4.143656905647159e-22,  7.638308129092874e-23, -9.622738649557783e-24,  9.249825664951412e-25, -7.213616388330298e-26,  4.745719867245159e-27,
 -2.705693221763625e-28,  1.363412924091843e-29, -6.163876406732216e-31,  2.529699635518863e-32, -9.503956869143943e-34,  9.115473682588688e-23, -3.496184881916563e-23,
  7.126300062229487e-24, -9.897575621000430e-25,  1.044623261579280e-25, -8.907549876792853e-27,  6.381595071338490e-28, -3.946943869166941e-29,  2.149783976369936e-30,
 -1.046959604370297e-31,  4.613867882382060e-33, -1.855444976250784e-34,  1.022392265776070e-23, -4.219608354737623e-24,  9.297151223937254e-25, -1.393278940279053e-25,
  1.581976409371433e-26, -1.446572871119651e-27,  1.107848900011283e-28, -7.302351454476826e-30,  4.226625869366197e-31, -2.181425680559907e-32,  1.016171969694275e-33,
 -4.308508785889829e-35,  1.554390592726424e-24, -6.699879375797672e-25,  1.547104767860543e-25, -2.427789328537071e-26,  2.881583813528625e-27, -2.749155674868123e-28,
  2.192468193946093e-29, -1.502104950798108e-30,  9.020747171138428e-32, -4.822422508661188e-33,  2.323121007251270e-34, -1.016986544982277e-35,  7.259508206457387e-02,
 -2.181181830116424e-04,  6.795436810056416e-07, -2.185270106299145e-09,  7.184945812075959e-12, -2.414105792405492e-14,  8.114209476272823e-17, -2.820643535816845e-19,
  9.193407941871391e-22, -3.556394390220004e-24,  8.440197887254618e-27, -6.488872398987299e-29,  6.282911693337558e-02, -2.205897936931596e-04,  9.554921969021414e-07,
 -4.407762023942230e-09,  2.030426713046712e-11, -9.195858309298843e-14,  4.079107541283913e-16, -1.783137394136210e-18,  7.637942481781648e-21, -3.264802784012878e-23,
  1.347581722914063e-25, -5.805405546973258e-28,  4.705259975804794e-02, -2.131250300372084e-04,  1.304991979065753e-06, -7.818623061703241e-09,  4.451822284773215e-11,
 -2.434738170265655e-13,  1.290708871905707e-15, -6.669718068990030e-18,  3.372680070197355e-20, -1.673161718554518e-22,  8.163189435817850e-25, -3.921131449162685e-27,
  3.047937715114250e-02, -1.850732092807374e-04,  1.482921435180355e-06, -1.075292943174330e-08,  7.262945187672477e-11, -4.667082427337034e-13,  2.884279068730189e-15,
 -1.724633221905853e-17,  1.003042283341604e-19, -5.689144743397241e-22,  3.160341797591778e-24, -1.719096441852611e-26,  1.706774647099660e-02, -1.392181448280827e-04,
  1.376501815357835e-06, -1.176800337681216e-08,  9.280382363583977e-11, -6.900338008868455e-13,  4.894021003109700e-15, -3.335793719935244e-17,  2.198609175671708e-19,
 -1.406681318012845e-21,  8.772825954312552e-24, -5.342014208993563e-26,  8.255831104430900e-03, -8.923384489331468e-05,  1.052910071219912e-06, -1.048999092072834e-08,
  9.552806751484867e-11, -8.124469293692250e-13,  6.539978483013092e-15, -5.028491509294244e-17,  3.718903875938609e-19, -2.658460071157351e-21,  1.844750271597042e-23,
 -1.246057581763313e-25,  3.446269150363948e-03, -4.845404788596422e-05,  6.702011232298487e-07, -7.723145820763632e-09,  8.050121898160443e-11, -7.763856561604448e-13,
  7.036665226556529e-15, -6.057138127195894e-17,  4.990751981666987e-19, -3.958530738890889e-21,  3.036492575380992e-23, -2.260269223948285e-25,  1.240103744788436e-03,
 -2.226163919145342e-05,  3.574890244397753e-07, -4.736242980957318e-09,  5.611309663378422e-11, -6.097576430296760e-13,  6.185405543753531e-15, -5.927229196098985e-17,
  5.411825035124055e-19, -4.738228088679237e-21,  3.998060402840836e-23, -3.263782764778716e-25,  3.841836361867066e-04, -8.657087113692023e-06,  1.605244292671739e-07,
 -2.432573946246498e-09,  3.258289174894855e-11, -3.970089608016471e-13,  4.487187113321608e-15, -4.766285300299928e-17,  4.802844685919986e-19, -4.623530840593254e-21,
  4.275385903436515e-23, -3.813687991750977e-25,  1.023267869254555e-04, -2.851664505983317e-06,  6.085212959004205e-08, -1.050260078702924e-09,  1.583999344631738e-11,
 -2.156242913345685e-13,  2.706137970134247e-15, -3.175924988770665e-17,  3.521083511105953e-19, -3.715931883468265e-21,  3.754929723304107e-23, -3.649806262499954e-25,
  2.339749475877069e-05, -7.962014023235233e-07,  1.950827592356219e-08, -3.821606002128197e-10,  6.470422988719570e-12, -9.813493620255680e-14,  1.364103346399688e-15,
 -1.764552998905731e-17,  2.147492170005505e-19, -2.479030106164232e-21,  2.731659961672280e-23, -2.887342167484583e-25,  4.585903134910730e-06, -1.885119594543008e-07,
  5.294453411117595e-09, -1.174119376564310e-10,  2.226824091707038e-12, -3.755529188982002e-14,  5.771280812304221e-16, -8.214440746673617e-18,  1.095602538758309e-19,
 -1.381266503539939e-21,  1.657190764045130e-23, -1.901977676884160e-25,  7.693472708182247e-07, -3.785842898574876e-08,  1.217205571323360e-09, -3.049966781822645e-11,
  6.470175139625253e-13, -1.211777305904514e-14,  2.056248536774610e-16, -3.216672269526857e-18,  4.696684704183379e-20, -6.460105463210052e-22,  8.430409044763961e-24,
 -1.049582365247815e-25,  1.103314490863671e-07, -6.450387516907459e-09,  2.371752571272303e-10, -6.706568814361111e-12,  1.589968873537118e-13, -3.304393059426108e-15,
  6.187382447590522e-17, -1.063154633919787e-18,  1.698391408507062e-20, -2.547217603054845e-22,  3.613692816361665e-24, -4.877734754871803e-26,  1.351253844079014e-08,
 -9.327364192914592e-10,  3.919307983230946e-11, -1.249832809265059e-12,  3.310227395745159e-14, -7.632288931707496e-16,  1.576727699073768e-17, -2.975373396720214e-19,
  5.199745474238807e-21, -8.502248150573179e-23,  1.311102012064275e-24, -1.918396311854930e-26,  1.412757287336260e-09, -1.145534324451226e-10,  5.498361035409095e-12,
 -1.977075004046794e-13,  5.850675666424429e-15, -1.496919582679337e-16,  3.412770965124410e-18, -7.074765882845358e-20,  1.352926383219512e-21, -2.412484849909183e-23,
  4.044740880143448e-25, -6.416828120766466e-27,  1.261627596935684e-10, -1.196739922124497e-11,  6.560453014046411e-13, -2.660767200484602e-14,  8.802731248121794e-16,
 -2.500891936603490e-17,  6.296682307245420e-19, -1.434946260649995e-20,  3.004746240619889e-22, -5.846704837096013e-24,  1.066395178089692e-25, -1.835324571939856e-27,
  9.642877517373679e-12, -1.066534952250915e-12,  6.678483560791874e-14, -3.057360875549481e-15,  1.131903880238292e-16, -3.574648257342054e-18,  9.950064278343503e-20,
 -2.495324018658884e-21,  5.727302525494128e-23, -1.217266581087909e-24,  2.417513464018428e-26, -4.517477319616752e-28,  6.335104579550163e-13, -8.148711168885438e-14,
  5.830899119709329e-15, -3.016220555687833e-16,  1.251279923661817e-17, -4.398823530166009e-19,  1.355560128622208e-20, -3.746242224481454e-22,  9.437234954665161e-24,
 -2.193605230959756e-25,  4.749332736370213e-27, -9.646527512088462e-29,  3.605139020646713e-14, -5.381535202757573e-15,  4.403114941943746e-16, -2.577046758300300e-17,
  1.199876178074220e-18, -4.703352767234147e-20,  1.607345584710266e-21, -4.903114278386542e-23,  1.357769730188248e-24, -3.456701121940999e-26,  8.170195452815680e-28,
 -1.806109322285873e-29,  1.800143939071441e-15, -3.112667955609682e-16,  2.914005528324981e-17, -1.932487871252715e-18,  1.011602171824630e-19, -4.429612866215992e-21,
  1.681825442530750e-22, -5.672830398139681e-24,  1.729793679036070e-25, -4.831095969913909e-27,  1.248422527510823e-28, -3.007764092474930e-30,  8.051424910037553e-17,
 -1.609497833124764e-17,  1.724960455338463e-18, -1.297930810538551e-19,  7.651469863673502e-21, -3.749332953068030e-22,  1.584350805113584e-23, -5.919307225759373e-25,
  1.990729830059516e-26, -6.108579452979845e-28,  1.728274068448968e-29, -4.543794053827175e-31,  3.331054995138936e-18, -7.678438975055230e-19,  9.420443471156693e-20,
 -8.049164876595149e-21,  5.350138690331452e-22, -2.937701761610919e-23,  1.383490676411562e-24, -5.732783819441482e-26,  2.129055014777803e-27, -7.185857580548265e-29,
  2.228146357515617e-30, -6.398068307097749e-32,  1.338684430478740e-19, -3.544141556010382e-20,  4.970999222208936e-21, -4.821441390706894e-22,  3.613670429703654e-23,
 -2.224050867432190e-24,  1.167699434990136e-25, -5.368225856898185e-27,  2.202150372430477e-28, -8.176738087693089e-30,  2.778887585026749e-31, -8.714686162598610e-33,
  5.617840352161238e-21, -1.697047657168191e-21,  2.711041133131641e-22, -2.976959037220674e-23,  2.510661192243951e-24, -1.728813606490961e-25,  1.010240716547579e-26,
 -5.144372156531873e-28,  2.327246805930684e-29, -9.490796136992146e-31,  3.529247897545865e-32, -1.206603290941172e-33,  2.726177345907400e-22, -9.296361711132883e-23,
  1.678180164399077e-23, -2.072462771255683e-24,  1.955049867625992e-25, -1.497911096571590e-26,  9.691343165976401e-28, -5.438954916054490e-29,  2.700184322081507e-30,
 -1.203632409735611e-31,  4.874178527789631e-33, -1.808155223295475e-34,  1.743608891220893e-23, -6.600326341430409e-24,  1.327213435010399e-24, -1.819466174304496e-25,
  1.896753929933469e-26, -1.598618646237193e-27,  1.132755058016556e-28, -6.933530027808189e-30,  3.739580192787961e-31, -1.804357983770020e-32,  7.882000440125009e-34,
 -3.143438996355912e-35,  1.672351500533459e-24, -6.858313787720706e-25,  1.500941573553758e-25, -2.234656067068519e-26,  2.521545302345364e-27, -2.292151485053366e-28,
  1.745653042378638e-29, -1.144578388256050e-30,  6.591815034515412e-32, -3.386062692994498e-33,  1.570263311426454e-34, -6.629608547553479e-36,  2.295046815515790e-25,
 -9.873420759899127e-26,  2.275185206165029e-26, -3.563026991195352e-27,  4.220680527698634e-28, -4.019107862976207e-29,  3.199476052600634e-30, -2.188245382979705e-31,
  1.311963431482691e-32, -7.002602182138948e-34,  3.368299664713953e-35, -1.472409194725190e-36,  7.173331866238579e-02, -2.127848082435047e-04,  6.539945969776454e-07,
 -2.074070360219485e-09,  6.720975721049249e-12, -2.228521304753571e-14,  7.363734180998127e-17, -2.546345087709954e-19,  7.966756247147100e-22, -3.278651397453169e-24,
  5.359459804379824e-27, -7.699808815871243e-29,  6.196171826064594e-02, -2.131520423379659e-04,  9.044892473931024e-07, -4.097091699652734e-09,  1.855908815496116e-11,
 -8.274129037240951e-14,  3.612351505751607e-16, -1.556536374769982e-18,  6.553747959483007e-21, -2.773989417556620e-23,  1.113098076741411e-25, -4.897239843294078e-28,
  4.622040191468792e-02, -2.030486386069131e-04,  1.215286842591703e-06, -7.143665593209054e-09,  3.994399717911123e-11, -2.146212216303908e-13,  1.118203907661913e-15,
 -5.680854966768782e-18,  2.825186589430188e-20, -1.378667007650748e-22,  6.619229777995290e-25, -3.128352011254219e-27,  2.976202081858955e-02, -1.737069089514692e-04,
  1.360562431718865e-06, -9.661928314413051e-09,  6.395019655960173e-11, -4.029356999594662e-13,  2.443404839230090e-15, -1.434129896807262e-17,  8.192768105582633e-20,
 -4.564119882684858e-22,  2.492965302151723e-24, -1.331662806848369e-26,  1.653203785668730e-02, -1.287467607370587e-04,  1.243759357405112e-06, -1.038746964402670e-08,
  8.010597552225075e-11, -5.830350261720135e-13,  4.051340987089869e-15, -2.706925159907495e-17,  1.750089507296699e-19, -1.098598523946931e-21,  6.727382810673232e-24,
 -4.020965165121968e-26,  7.914980168330780e-03, -8.128928204821345e-05,  9.356910324036033e-07, -9.083460820475892e-09,  8.074126992972674e-11, -6.711220142376642e-13,
  5.285176654140182e-15, -3.978334860356276e-17,  2.882455736672612e-19, -2.019521167178141e-21,  1.374335542750734e-23, -9.105444587283675e-26,  3.262618646055639e-03,
 -4.344237679612545e-05,  5.847672977990489e-07, -6.550717990007376e-09,  6.653372660917128e-11, -6.261767718516142e-13,  5.544393730687046e-15, -4.666482306464251e-17,
  3.762298307840148e-19, -2.921694610106452e-21,  2.195550586207653e-23, -1.601659440272083e-25,  1.156437446179108e-03, -1.961468099074822e-05,  3.056631918199396e-07,
 -3.928459869324502e-09,  4.527749439448069e-11, -4.794137188592534e-13,  4.744635805339768e-15, -4.440106705327624e-17,  3.962385824408063e-19, -3.393093489923968e-21,
  2.802000557875728e-23, -2.239748673491580e-25,  3.519505644887033e-04, -7.481360252931455e-06,  1.342172588183168e-07, -1.969342184855532e-09,  2.561990150631435e-11,
 -3.037372409857850e-13,  3.344948018960699e-15, -3.465707904640803e-17,  3.409646262817742e-19, -3.207148512403348e-21,  2.899694231152070e-23, -2.530518122031912e-25,
  9.181962080967728e-05, -2.411257710584776e-06,  4.963799247191849e-08, -8.280721946236724e-10,  1.211104181421234e-11, -1.601888346485703e-13,  1.956410942671078e-15,
 -2.237101568622287e-17,  2.419013374614917e-19, -2.492003735309383e-21,  2.459954574925059e-23, -2.337358166080108e-25,  2.049807894295967e-05, -6.568573378243028e-07,
  1.548407471440641e-08, -2.927116327755311e-10,  4.798777911021246e-12, -7.062431609275033e-14,  9.541905491201603e-16, -1.201316103216752e-17,  1.424521590144752e-19,
 -1.603768336192428e-21,  1.724897997496217e-23, -1.780843520916146e-25,  3.908428801988791e-06, -1.512389648490528e-07,  4.076738853142764e-09, -8.711064431856631e-11,
  1.597466571141020e-12, -2.610984752107355e-14,  3.895566617596593e-16, -5.390939658416218e-18,  6.999155771361299e-20, -8.598396077137444e-22,  1.006105487938109e-23,
 -1.127063112252572e-25,  6.352970627521626e-07, -2.942559718194115e-08,  9.061171936835832e-10, -2.184591772693939e-11,  4.475109397125838e-13, -8.113113976417728e-15,
  1.335194261277513e-16, -2.028827133963617e-18,  2.881068828684257e-20, -3.858329606020052e-22,  4.907023298213052e-24, -5.958855107301301e-26,  8.787004068500829e-08,
 -4.836198202630291e-09,  1.700153746920323e-10, -4.619753847913649e-12,  1.056322732672151e-13, -2.122797974979830e-15,  3.851269742021337e-17, -6.422112695536930e-19,
  9.969946961209285e-21, -1.454785500823778e-22,  2.010026885274448e-24, -2.644716976420090e-26,  1.032502913111136e-08, -6.712192692295681e-10,  2.692877666757094e-11,
 -8.242797655881523e-13,  2.103339669036618e-14, -4.684878940384473e-16,  9.369181079986589e-18, -1.714460782117843e-19,  2.909579440522104e-21, -4.625696534541951e-23,
  6.942904950674347e-25, -9.897415356526798e-27,  1.029470972083012e-09, -7.866675815524252e-11,  3.601505932177194e-12, -1.241919317521445e-13,  3.537690505657570e-15,
 -8.736764231629501e-17,  1.926808261066420e-18, -3.870731030108373e-20,  7.183798576473087e-22, -1.244810758085669e-23,  2.030387267541750e-25, -3.136886633185150e-27,
  8.706158973762904e-11, -7.790056453374590e-12,  4.070821815959134e-13, -1.582293082629592e-14,  5.035563329480319e-16, -1.380032685561258e-17,  3.359188552001708e-19,
 -7.414496573191425e-21,  1.506091282032181e-22, -2.846658223240948e-24,  5.049355031076545e-26, -8.460319156727989e-28,  6.250171346056714e-12, -6.529167263394839e-13,
  3.896685368662597e-14, -1.708999005872825e-15,  6.083820226282125e-17, -1.852632518405308e-18,  4.983670672724192e-20, -1.210127906798655e-21,  2.693573655070077e-23,
 -5.559576026414065e-25,  1.073579537597977e-26, -1.952776935235956e-28,  3.819822165145181e-13, -4.648357618878094e-14,  3.171152167603431e-15, -1.571564487306859e-16,
  6.268434519845266e-18, -2.124626220817797e-19,  6.326848893992856e-21, -1.692818907358669e-22,  4.135348281323400e-24, -9.334605596564350e-26,  1.965113067232631e-27,
 -3.885452489723573e-29,  1.999287710296726e-14, -2.829536697787834e-15,  2.209103515889376e-16, -1.239306182788145e-17,  5.549729735642829e-19, -2.097968763519349e-20,
  6.929918272752042e-22, -2.047111195262625e-23,  5.498675029365454e-25, -1.359821689928645e-26,  3.126063805868345e-28, -6.729218943457098e-30,  9.059321538390404e-16,
 -1.489270160188351e-16,  1.332407486933292e-17, -8.478687383236218e-19,  4.272404116825525e-20, -1.805543331808799e-21,  6.630538350888685e-23, -2.167226055345197e-24,
  6.414198020684610e-26, -1.741256632634470e-27,  4.379327131330331e-29, -1.028096259475574e-30,  3.619654361484681e-17, -6.903331597958378e-18,  7.086858338398644e-19,
 -5.125910099458194e-20,  2.913241806759145e-21, -1.379612727704575e-22,  5.645847055306296e-24, -2.046475503338410e-25,  6.687984753543420e-27, -1.997029407851030e-28,
  5.505167368191757e-30, -1.411895912267947e-31,  1.313811994906200e-18, -2.902141560660150e-19,  3.421664589824806e-20, -2.817948047723218e-21,  1.810034697650991e-22,
 -9.625763170808275e-24,  4.398940225593202e-25, -1.771817207419312e-26,  6.405851891585458e-28, -2.107624157453628e-29,  6.378445129988522e-31, -1.789673446749512e-32,
  4.540947435455395e-20, -1.158412264239363e-20,  1.568284799249846e-21, -1.471711427108537e-22,  1.069579805554544e-23, -6.395499962015817e-25,  3.267951302147860e-26,
 -1.464394592386612e-27,  5.863502153482350e-29, -2.127725595997889e-30,  7.074991906613612e-32, -2.173159770982908e-33,  1.606592004798594e-21, -4.707721305184198e-22,
  7.300459993644827e-23, -7.795624210839826e-24,  6.404593870608250e-25, -4.303046718117781e-26,  2.457024833545403e-27, -1.224181513399100e-28,  5.425050635616585e-30,
 -2.169627925497117e-31,  7.919898848358128e-33, -2.660533751624662e-34,  6.470830613322687e-23, -2.156977971385462e-23,  3.806167587815363e-24, -4.599999353347061e-25,
  4.252090184994658e-26, -3.196174664796659e-27,  2.031024098541829e-28, -1.120676076800285e-29,  5.475220051153996e-31, -2.403932867450000e-32,  9.596157058673742e-34,
 -3.511814849474400e-35,  3.423995949914647e-24, -1.277391880916842e-24,  2.530437329317917e-25, -3.419568670151934e-26,  3.516835192149553e-27, -2.926433036503953e-28,
  2.048816721873378e-29, -1.239919761101852e-30,  6.616235131506229e-32, -3.160210071010487e-33,  1.367326629923610e-34, -5.403966136501658e-36,  2.775388444567250e-25,
 -1.130100575604373e-25,  2.454680625253045e-26, -3.628126921948096e-27,  4.065711635200474e-28, -3.671762041303282e-29,  2.779127913066858e-30, -1.811610041008021e-31,
  1.037605661150770e-32, -5.302254456230735e-34,  2.446794321240175e-35, -1.028229977328691e-36,  3.404533216652832e-26, -1.461547993539278e-26,  3.360190171224182e-27,
 -5.250328858378771e-28,  6.205939733885979e-29, -5.897308910877809e-30,  4.685366627675168e-31, -3.198461080136763e-32,  1.914189516873328e-33, -1.019944382350524e-34,
  4.897959110190745e-36, -2.137734524289702e-37,  7.089248825058257e-02, -2.076506120010756e-04,  6.297365626259443e-07, -1.970006733352103e-09,  6.292381341379302e-12,
 -2.060070101252216e-14,  6.684699699422589e-17, -2.309950146728925e-19,  6.816286165829146e-22, -3.138640408820787e-24,  1.444298398470998e-27, -1.041901491422378e-28,
  6.112327750492692e-02, -2.061078634666801e-04,  8.570526965783248e-07, -3.812928248385929e-09,  1.698754722853901e-11, -7.457183766495500e-14,  3.204439715903806e-16,
 -1.361976172186415e-18,  5.630254708255252e-21, -2.369765325641774e-23,  9.126845425501812e-26, -4.257491666015118e-28,  4.542712395116539e-02, -1.936586920594880e-04,
  1.133260409018836e-06, -6.537495196683334e-09,  3.590756665996765e-11, -1.895953461159000e-13,  9.710856013347863e-16, -4.851353811483796e-18,  2.373386733785233e-20,
 -1.139481867485703e-22,  5.385451552721916e-25, -2.504075459040334e-27,  2.908825164980617e-02, -1.632693800219196e-04,  1.250502533569253e-06, -8.700140068715422e-09,
  5.644684271257869e-11, -3.488309311052288e-13,  2.076212823199706e-15, -1.196435003728975e-17,  6.715915168813509e-20, -3.674816133559509e-22,  1.975135290377516e-24,
 -1.034982275100363e-26,  1.603619114978616e-02, -1.192743487204000e-04,  1.126431527370593e-06, -9.194023455532493e-09,  6.935932576322847e-11, -4.943000477722452e-13,
  3.366211506379761e-15, -2.205309349471824e-17,  1.399053288409837e-19, -8.617904234680244e-22,  5.184319196534525e-24, -3.040605460754796e-26,  7.604133467551187e-03,
 -7.421877541943034e-05,  8.340190570198410e-07, -7.892448963449085e-09,  6.850215828850584e-11, -5.566662529852071e-13,  4.290160639824441e-15, -3.162400087541245e-17,
  2.245434922497975e-19, -1.542233767529350e-21,  1.029651029304273e-23, -6.691579923361276e-26,  3.097731911755445e-03, -3.906148263051301e-05,  5.121549049972144e-07,
 -5.579557719178319e-09,  5.524164943668510e-11, -5.075217075434077e-13,  4.391650511390899e-15, -3.615174744836873e-17,  2.852946150830290e-19, -2.169704617930999e-21,
  1.597769118080609e-23, -1.142514599383899e-25,  1.082587244342886e-03, -1.734631656241626e-05,  2.625708452225117e-07, -3.274937442540634e-09,  3.673418364493943e-11,
 -3.791340050102214e-13,  3.661994780514924e-15, -3.347744045391269e-17,  2.920934210285148e-19, -2.447080164794082e-21,  1.978267444070019e-23, -1.548740640464069e-25,
  3.240321927667460e-04, -6.495616888714789e-06,  1.128574746930677e-07, -1.603968952425025e-09,  2.027528869721288e-11, -2.339695259254004e-13,  2.511423064452771e-15,
 -2.538976798626715e-17,  2.439545065821319e-19, -2.242727871601142e-21,  1.983181829214879e-23, -1.693623683916005e-25,  8.291021364331267e-05, -2.050834942016113e-06,
  4.076577917899765e-08, -6.575728128768483e-10,  9.330258389722260e-12, -1.199534890089930e-13,  1.426153351391232e-15, -1.589409652489833e-17,  1.676741937197121e-19,
 -1.686623545092228e-21,  1.626890479300527e-23, -1.511457992859865e-25,  1.809785943558406e-05, -5.458294283383717e-07,  1.238934467354533e-08, -2.260925495214057e-10,
  3.590503427952049e-12, -5.129399853321670e-14,  6.738284648105429e-16, -8.259249545971425e-18,  9.545385679597010e-20, -1.048350898218291e-21,  1.100822808724769e-23,
 -1.110390204553626e-25,  3.362645325590749e-06, -1.224084781863574e-07,  3.169050884478684e-09, -6.526788208484728e-11,  1.157732590342001e-12, -1.834480121019385e-14,
  2.658153541518592e-16, -3.577568517424428e-18,  4.522654176890367e-20, -5.415305863052198e-22,  6.181361096913044e-24, -6.760178992833532e-26,  5.305891613328586e-07,
 -2.311483027551719e-08,  6.820879664796598e-10, -1.582732372909421e-11,  3.131804468343017e-13, -5.497751145117230e-15,  8.777435285533810e-17, -1.295838751253704e-18,
  1.790150475582796e-20, -2.334703415000132e-22,  2.894362741045320e-24, -3.428949265073907e-26,  7.093107818177235e-08, -3.672019703825670e-09,  1.234653888483109e-10,
 -3.224586782227773e-12,  7.113046211154256e-14, -1.382560887693571e-15,  2.430869846153342e-17, -3.934738323578284e-19,  5.937364418624790e-21, -8.430646486170987e-23,
  1.134642183436865e-24, -1.455520767748124e-26,  8.015596141966576e-09, -4.902735242258568e-10,  1.878295548028772e-11, -5.519469288314150e-13,  1.357188292280668e-14,
 -2.920786226335705e-16,  5.655626688822599e-18, -1.003736964349768e-19,  1.654443751399774e-21, -2.557741055306846e-23,  3.737141615339653e-25, -5.191004446194813e-27,
  7.641913743442487e-10, -5.497180302807924e-11,  2.400392328341621e-12, -7.938170840849688e-14,  2.176835897557591e-15, -5.189630290838768e-17,  1.107252534794536e-18,
 -2.155721115317278e-20,  3.883219760335206e-22, -6.539367742075900e-24,  1.037750517307624e-25, -1.561461789158003e-27,  6.138104637537728e-11, -5.174377425416400e-12,
  2.576874507218408e-13, -9.597920449861864e-15,  2.938125072603264e-16, -7.767310635915548e-18,  1.827870472498792e-19, -3.907688374126550e-21,  7.700001618522595e-23,
 -1.413702706419670e-24,  2.438669112210862e-26, -3.977936592521057e-28,  4.152209089468460e-12, -4.091104635836244e-13,  2.325938249030948e-14, -9.770007207573167e-16,
  3.343627864715890e-17, -9.816542821941396e-19,  2.551740804783161e-20, -5.998687984891028e-22,  1.294757592265624e-23, -2.595016734470666e-25,  4.871962556220019e-27,
 -8.625310784505825e-29,  2.368826804619162e-13, -2.722922811223032e-14,  1.769710886853366e-15, -8.398286812462418e-17,  3.219537622032634e-18, -1.051789745629443e-19,
  3.025835410205277e-21, -7.836361084434595e-23,  1.855992069781130e-24, -4.067637783037401e-26,  8.324657609893539e-28, -1.601963809552872e-29,  1.144485749208751e-14,
 -1.533026377433723e-15,  1.140941128005542e-16, -6.130742479081975e-18,  2.638987678294175e-19, -9.616374641110014e-21,  3.068906414996021e-22, -8.775669987097902e-24,
  2.285620352525561e-25, -5.488700128227920e-27,  1.226846695537100e-28, -2.570848393132021e-30,  4.723592294977170e-16, -7.368160459771202e-17,  6.291836098421794e-18,
 -3.838063500556871e-19,  1.860196264512737e-20, -7.581817696986642e-22,  2.691358849748065e-23, -8.519583719344612e-25,  2.446088720187406e-26, -6.451295651162036e-28,
  1.578395682040227e-29, -3.609027660650200e-31,  1.691897176181603e-17, -3.071910575791922e-18,  3.016060378053293e-19, -2.094423413621340e-20,  1.146373291772211e-21,
 -5.241759316900819e-23,  2.075687350258421e-24, -7.293993051898321e-26,  2.314688105559227e-27, -6.721288214344725e-29,  1.804167774067598e-30, -4.510993468448691e-32,
  5.403166645798151e-19, -1.141087337303523e-19,  1.290554427473344e-20, -1.022906076482817e-21,  6.341078414992158e-23, -3.262212368212119e-24,  1.445143541288290e-25,
 -5.652506451992366e-27,  1.987662048860076e-28, -6.369630729388363e-30,  1.879938223960736e-31, -5.150206847614026e-33,  1.608576009333676e-20, -3.944427060266659e-21,
  5.144030996593765e-22, -4.662464148402059e-23,  3.280659146778436e-24, -1.903221081542875e-25,  9.452752872347913e-27, -4.124001231731317e-28,  1.610016831958479e-29,
 -5.703923482969536e-31,  1.853907918582139e-32, -5.572443898189588e-34,  4.793738120243093e-22, -1.359292363948774e-22,  2.041924967428222e-23, -2.116408075456214e-24,
  1.690994864028856e-25, -1.106861743277419e-26,  6.167082070290068e-28, -3.002521085166761e-29,  1.301882874849765e-30, -5.100210550389951e-32,  1.825661282818025e-33,
 -6.020123316886922e-35,  1.595063350205330e-23, -5.186252016980381e-24,  8.928019963195523e-25, -1.054073008187983e-25,  9.531970895177835e-27, -7.018812517359684e-28,
  4.374604505202274e-29, -2.370202305717280e-30,  1.138248582032692e-31, -4.916986745740251e-33,  1.932826342392076e-34, -6.971179869797814e-36,  6.918654395316045e-25,
 -2.539713144775374e-25,  4.948524304294125e-26, -6.582626249193603e-27,  6.669893999136731e-28, -5.473043372837455e-29,  3.781620194931498e-30, -2.260412078871829e-31,
  1.192156491103714e-32, -5.631859648142269e-34,  2.411488656630664e-35, -9.437482139059804e-37,  4.680452376105888e-26, -1.890619122401368e-26,  4.072200052711588e-27,
 -5.970298794125080e-28,  6.639160418988575e-29, -5.952542179669889e-30,  4.474751025327246e-31, -2.898195252355184e-32,  1.649895812481434e-33, -8.382885015622108e-35,
  3.847478022001670e-36, -1.608598112209002e-37,  5.076607321991787e-27, -2.174226478537832e-27,  4.985955576562567e-28, -7.771187187719090e-29,  9.163651178261847e-30,
 -8.688063134948766e-31,  6.887606064039662e-32, -4.692097181031349e-33,  2.802561757795083e-34, -1.490498809088907e-35,  7.144851889122696e-37, -3.113095711177115e-38,
  7.007181424275948e-02, -2.027055990530241e-04,  6.066872304287311e-07, -1.872539731631461e-09,  5.895898999649141e-12, -1.907162688120201e-14,  6.066754379147655e-17,
 -2.109893262127367e-19,  5.684555188811028e-22, -3.185851217354830e-24, -4.190883963590828e-27, -1.574610390433589e-28,  6.031227548877776e-02, -1.994299525344410e-04,
  8.128804637065833e-07, -3.552653737403023e-09,  1.557003002846113e-11, -6.731921131983111e-14,  2.847075563159542e-16, -1.194789127231145e-18,  4.838455754510544e-21,
 -2.040905624596089e-23,  7.341550276085662e-26, -3.909597754353669e-28,  4.467013791848443e-02, -1.848969218797232e-04,  1.058136439415564e-06, -5.992087777859769e-09,
  3.233814539023131e-11, -1.678371717917573e-13,  8.452922191622384e-16, -4.153552786333853e-18,  1.999434701249434e-20, -9.445623314825040e-23,  4.396465236439639e-25,
 -2.010153018422374e-27,  2.845454195762915e-02, -1.536681261170524e-04,  1.151297990123332e-06, -7.850205835640419e-09,  4.994258513687925e-11, -3.027906974644243e-13,
  1.769413280024254e-15, -1.001252555949982e-17,  5.524876340014103e-20, -2.968675992540330e-22,  1.572219731977754e-24, -8.060440376380369e-27,  1.557644359165954e-02,
 -1.106860677148073e-04,  1.022449169514777e-06, -8.159173908499203e-09,  6.023369706739373e-11, -4.204422112065834e-13,  2.807009353137454e-15, -1.803496683783502e-17,
  1.123124721148122e-19, -6.788653945048198e-22,  4.015184611980234e-24, -2.308398063516878e-26,  7.320028077964357e-03, -6.790763915047412e-05,  7.455358097479491e-07,
 -6.880173744600840e-09,  5.833073703084037e-11, -4.635647078383907e-13,  3.497472579871993e-15, -2.525286513171589e-17,  1.757783092664929e-19, -1.183706074508714e-21,
  7.756949745058753e-24, -4.943822741481317e-26,  2.949276653916999e-03, -3.521777229572067e-05,  4.501860990846363e-07, -4.771494576488688e-09,  4.606825987531576e-11,
 -4.133054517870842e-13,  3.496296728463251e-15, -2.815792070082843e-17,  2.175731142191366e-19, -1.620824081218730e-21,  1.170061174280195e-23, -8.201919523384843e-26,
  1.017167599752469e-03, -1.539350186775978e-05,  2.265624901219654e-07, -2.743377397980663e-09,  2.995958755224687e-11, -3.015145925326860e-13,  2.843256962992245e-15,
 -2.539964269452885e-17,  2.167401397893456e-19, -1.776916011404163e-21,  1.406697025182431e-23, -1.078807526130433e-25,  2.997408854142632e-04, -5.664568217990821e-06,
  9.541183912762208e-08, -1.313951306011971e-09,  1.614531700041429e-11, -1.814136635114206e-13,  1.898676130580849e-15, -1.873540504845582e-17,  1.758652274971259e-19,
 -1.580614173774295e-21,  1.367376648213409e-23, -1.142992244552731e-25,  7.531250759467109e-05, -1.753905329536016e-06,  3.369707633710574e-08, -5.257626133341800e-10,
  7.240328395437372e-12, -9.051183077053013e-14,  1.047934053514277e-15, -1.138636629866720e-17,  1.172262414812670e-19, -1.151700337391299e-21,  1.085824811578632e-23,
 -9.866076751780904e-26,  1.609687090681571e-05, -4.566631212071986e-07,  9.989713812203930e-09, -1.760456988676916e-10,  2.709256520900665e-12, -3.758411689552686e-14,
  4.802138479656485e-16, -5.732308023426679e-18,  6.458782797398831e-20, -6.921860483016805e-22,  7.097993657486488e-24, -6.996725385025107e-26,  2.919166318242492e-06,
 -9.989981618982371e-08,  2.485907414823657e-09, -4.936403681960805e-11,  8.472928587503789e-13, -1.302019763731270e-14,  1.832834212117940e-16, -2.399788327945349e-18,
  2.954762446911481e-20, -3.449229245172414e-22,  3.841705707246606e-24, -4.102669956242961e-26,  4.479504821907529e-07, -1.834032279819261e-08,  5.189365416417040e-10,
 -1.159288294789488e-11,  2.216565844415581e-13, -3.768871374767635e-15,  5.839090364208315e-17, -8.377764011230161e-19,  1.126175385821928e-20, -1.430694070839808e-22,
  1.729283638820785e-24, -1.999066238541394e-26,  5.799815891627972e-08, -2.821641966526856e-09,  9.077968376929140e-11, -2.279403265816984e-12,  4.852103859383707e-14,
 -9.124094671352777e-16,  1.555097803653000e-17, -2.443954741150165e-19,  3.585323955806969e-21, -4.955010977014922e-23,  6.497104373673847e-25, -8.127137996720503e-27,
  6.317762695366625e-09, -3.632121677565081e-10,  1.329123686003015e-11, -3.750123349146996e-13,  8.887664079175495e-15, -1.848444113720577e-16,  3.466170484321422e-18,
 -5.967359658123119e-20,  9.554726629498396e-22, -1.436645500530264e-23,  2.043691804731807e-25, -2.766413948788802e-27,  5.774200204294013e-10, -3.905731394065489e-11,
  1.626708058348060e-12, -5.159437597470742e-14,  1.362187110701939e-15, -3.135318491859019e-17,  6.472450774869190e-19, -1.221400540164723e-20,  2.135720343002460e-22,
 -3.495646291518498e-24,  5.397677258568411e-26, -7.910427954750364e-28,  4.417609973118025e-11, -3.504084994750963e-12,  1.662732929001227e-13, -5.934069892573529e-15,
  1.747340102142119e-16, -4.456027906293623e-18,  1.013836912194155e-19, -2.099357981345426e-21,  4.013048394242697e-23, -7.157125572407981e-25,  1.200711801306910e-26,
 -1.906803294977494e-28,  2.824779012754187e-12, -2.621379800240752e-13,  1.419135707690065e-14, -5.707773466665487e-16,  1.877656723688650e-17, -5.314248712713301e-19,
  1.334766418153791e-20, -3.037632574852680e-22,  6.357358499058303e-24, -1.237207113724966e-25,  2.258145853708986e-27, -3.890884021868126e-29,  1.509522641338650e-13,
 -1.636450898079859e-14,  1.012573628360690e-15, -4.599380644929704e-17,  1.694111729439517e-18, -5.333121370929155e-20,  1.481895711416986e-21, -3.714078467079710e-23,
  8.527014921898672e-25, -1.814150150583040e-26,  3.608774011060671e-28, -6.757853510772362e-30,  6.757220099787668e-15, -8.551471574033112e-16,  6.061199988853236e-17,
 -3.117516220193379e-18,  1.289261411322194e-19, -4.526637979260902e-21,  1.395174307271809e-22, -3.860655976602299e-24,  9.746649271251447e-26, -2.272128473812489e-27,
  4.936674821964273e-29, -1.006744930512948e-30,  2.550014971489070e-16, -3.766895393315707e-17,  3.066377262443648e-18, -1.791454622673814e-19,  8.345107213344828e-21,
 -3.278296276085680e-22,  1.124235944105958e-23, -3.444854666231425e-25,  9.590287511574669e-27, -2.456200863285063e-28,  5.843453719938484e-30, -1.300802383290466e-31,
  8.219001738659022e-18, -1.417583708141240e-18,  1.329104516642645e-19, -8.850593066969243e-21,  4.660737927926250e-22, -2.055870103863773e-23,  7.871396876127565e-25,
 -2.679588628135930e-26,  8.251683181521014e-28, -2.328625335803442e-29,  6.082786003600137e-31, -1.481877849355081e-32,  2.317113933202909e-19, -4.667309446939782e-20,
  5.054533528779667e-21, -3.850008462444392e-22,  2.300430927016895e-23, -1.143585028081404e-24,  4.905787894548966e-26, -1.861613426318104e-27,  6.361424335469532e-29,
 -1.983922208297960e-30,  5.705900042869254e-32, -1.525127754969897e-33,  5.954737496073852e-21, -1.400002144098096e-21,  1.755163656069666e-22, -1.533865038023984e-23,
  1.043333399807349e-24, -5.864372500517337e-26,  2.827580538990939e-27, -1.199643457117167e-28,  4.561525874537289e-30, -1.576163067553412e-31,  5.002738749930922e-33,
 -1.470168308698943e-34,  1.494576046968900e-22, -4.090516870342361e-23,  5.939396402714287e-24, -5.963866617954452e-25,  4.626246561269035e-26, -2.945589275132969e-27,
  1.599167079862388e-28, -7.598009460817288e-30,  3.219460413319343e-31, -1.234064794653248e-32,  4.327148482645693e-34, -1.399212933465313e-35,  4.092297733904442e-24,
 -1.294830537547638e-24,  2.169967346205821e-25, -2.497968915869669e-26,  2.206057752057782e-27, -1.588789736562655e-28,  9.698468661020226e-30, -5.152878545058820e-31,
  2.429359008253414e-32, -1.031314227268427e-33,  3.987788362995277e-35, -1.416063190696948e-36,  1.442030089327424e-25, -5.199031419146533e-26,  9.946801925578370e-27,
 -1.300368075728200e-27,  1.296266873718263e-28, -1.047486847424882e-29,  7.134251209803607e-31, -4.207110551477662e-32,  2.190787637190863e-33, -1.022602460756287e-34,
  4.329329113474233e-36, -1.676301188887753e-37,  8.034998470175379e-27, -3.216526247381498e-27,  6.863105575935782e-28, -9.971415394724224e-29,  1.099404486580046e-29,
 -9.777956143155508e-31,  7.294971435071755e-32, -4.691222328147027e-33,  2.652768031670001e-34, -1.339331552697376e-35,  6.110513128767031e-37, -2.540422038219842e-38,
  7.613545801198986e-28, -3.252172807725868e-28,  7.436772401519767e-29, -1.155899804565761e-29,  1.359407530303803e-30, -1.285606667826871e-31,  1.016745679561248e-32,
 -6.910703938685193e-34,  4.118803690016632e-35, -2.186021447392497e-36,  1.045842250742633e-37, -4.548395901593856e-39,  6.927055875565577e-02, -1.979404079169089e-04,
  5.847704235368634e-07, -1.781179670469260e-09,  5.528558316971195e-12, -1.768455020030943e-14,  5.499695296943713e-17, -1.946811019566148e-19,  4.488612471977138e-22,
 -3.516517543193978e-24, -1.303779014255284e-26, -2.532351149585158e-28,  5.952729761133013e-02, -1.930933011243964e-04,  7.717000833260269e-07, -3.313944140229184e-09,
  1.428935344516646e-11, -6.087084271132761e-14,  2.533144821425277e-16, -1.051180825772487e-18,  4.152472530036663e-21, -1.781378825021678e-23,  5.634579813946094e-26,
 -3.913725373268134e-28,  4.394703710561493e-02, -1.767109027445421e-04,  9.892285410232452e-07, -5.500467418199272e-09,  2.917521257910504e-11, -1.488764775006219e-13,
  7.374622443472343e-16, -3.564911961833170e-18,  1.689027669054539e-20, -7.851713416728981e-23,  3.601694283635471e-25, -1.616969585567061e-27,  2.785771219484258e-02,
 -1.448214134034709e-04,  1.061697388349089e-06, -7.097355517444375e-09,  4.428971407798031e-11, -2.634986654058981e-13,  1.512290047838304e-15, -8.404083058322322e-18,
  4.561318731550244e-20, -2.405147281576252e-22,  1.258418530307824e-24, -6.274173640344820e-27,  1.514946072642024e-02, -1.028823472555743e-04,  9.300554303329450e-07,
 -7.259209833994506e-09,  5.245963873614352e-11, -3.587491344587459e-13,  2.348882263118267e-15, -1.480287757216829e-17,  9.053547224387936e-20, -5.368371188125097e-22,
  3.126309750073405e-24, -1.757324606315279e-26,  7.059824707056224e-03, -6.225841118832411e-05,  6.682816657758700e-07, -6.016721057002744e-09,  4.984468812433808e-11,
 -3.875120487863276e-13,  2.863138345763140e-15, -2.025389737839499e-17,  1.382629870764937e-19, -9.128925435320602e-22,  5.876355991232711e-24, -3.669904806583680e-26,
  2.815262806434822e-03, -3.183338455536390e-05,  3.970920040584472e-07, -4.096226688898177e-09,  3.858124833035982e-11, -3.381194993334913e-13,  2.797181135013275e-15,
 -2.204545861981929e-17,  1.668454985913199e-19, -1.217697381402134e-21,  8.621336659510615e-24, -5.923541519867455e-26,  9.590210246322132e-04, -1.370497041392012e-05,
  1.963304637069123e-07, -2.308787149811672e-09,  2.455788403482910e-11, -2.410824157167135e-13,  2.220273511091469e-15, -1.938751138630393e-17,  1.618514021045018e-19,
 -1.298810994431051e-21,  1.007227368276364e-23, -7.567833963339261e-26,  2.785151971534987e-04, -4.960212145892709e-06,  8.108219967591411e-08, -1.082344104587818e-09,
  1.293331055926704e-11, -1.415536371760820e-13,  1.445017378426473e-15, -1.392169614213682e-17,  1.277060571259932e-19, -1.122405055591033e-21,  9.502076976391327e-24,
 -7.776149843199091e-26,  6.879869100204152e-05, -1.507725163651670e-06,  2.802740633024315e-08, -4.231339806428865e-10,  5.657810103376041e-12, -6.879885316153134e-14,
  7.759519830495759e-16, -8.222491059714312e-18,  8.263892590653471e-20, -7.931961685059839e-22,  7.311423139646989e-24, -6.498845928497849e-26,  1.441764421947511e-05,
 -3.845120008025812e-07,  8.114337357287703e-09, -1.381355008788748e-10,  2.060940626090587e-12, -2.777269558381756e-14,  3.452568323461683e-16, -4.014902657870324e-18,
  4.411563041734234e-20, -4.614678430887500e-22,  4.622434857752774e-24, -4.453845053460663e-26,  2.555890999736815e-06, -8.216991100122630e-08,  1.967001849356456e-09,
 -3.767264203349270e-11,  6.259413032454739e-13, -9.331374653075074e-15,  1.276525817077244e-16, -1.626485855131012e-18,  1.951038598390430e-20, -2.220998863324077e-22,
  2.414342950226193e-24, -2.518313512558273e-26,  3.820892580473463e-07, -1.469026907171128e-08,  3.988400137291718e-10, -8.580554842690817e-12,  1.585847719496292e-13,
 -2.612581203500447e-15,  3.929020320450245e-17, -5.480076722078110e-19,  7.169951823715907e-21, -8.874833764700583e-23,  1.046107868787096e-24, -1.180272148057374e-26,
  4.800778787582247e-08, -2.192883917234905e-09,  6.754252288628060e-11, -1.630886561358997e-12,  3.351140469146866e-14, -6.098231662952390e-16,  1.007804428144392e-17,
 -1.538151297212819e-19,  2.194273744153227e-21, -2.952217360354504e-23,  3.772132584250675e-25, -4.601963446047253e-27,  5.052149140912221e-09, -2.727196060778405e-10,
  9.535533469261072e-12, -2.583764721479556e-13,  5.903332956143687e-15, -1.186785194658215e-16,  2.155615110573644e-18, -3.600672059919117e-20,  5.601504925225355e-22,
 -8.192909188833903e-24,  1.134897185457986e-25, -1.497312527088052e-27,  4.437634342007092e-10, -2.819236362034207e-11,  1.120099128721234e-12, -3.407562257805673e-14,
  8.663079578222934e-16, -1.925384182251313e-17,  3.846328326540932e-19, -7.036242111146630e-21,  1.194459460983069e-22, -1.900407671245331e-24,  2.855596523527808e-26,
 -4.076507401006105e-28,  3.242828357591508e-11, -2.417210184080111e-12,  1.092772563822810e-13, -3.736736322697846e-15,  1.058440054618734e-16, -2.603950767514453e-18,
  5.728324374069273e-20, -1.148996768603484e-21,  2.130839544569930e-23, -3.691783657409703e-25,  6.023693236086470e-27, -9.313427977398896e-29,  1.966181699339578e-12,
 -1.716047375238169e-13,  8.843209804019530e-15, -3.405003209211720e-16,  1.076594552659669e-17, -2.937233408993592e-19,  7.128057103630044e-21, -1.570358842592890e-22,
  3.186678071370282e-24, -6.021518421687155e-26,  1.068435208639824e-27, -1.791655995453635e-29,  9.875745439950779e-14, -1.008088736216489e-14,  5.934959488264835e-16,
 -2.579358114291854e-17,  9.126028878352276e-19, -2.767823899377758e-20,  7.427148513079709e-22, -1.801174440480327e-23,  4.007989949896294e-25, -8.276676922651469e-27,
  1.600107041976412e-28, -2.915446001799876e-30,  4.111222076568923e-15, -4.906822376799571e-16,  3.309342464956230e-17, -1.628291323735583e-18,  6.466582420076865e-20,
 -2.186793684062903e-21,  6.507285604931589e-23, -1.741972083979648e-24,  4.261747134284346e-26, -9.641960669493295e-28,  2.035823078085553e-29, -4.039414766317998e-31,
  1.424229795830359e-16, -1.988417291809690e-17,  1.541223237971591e-18, -8.616279122867767e-20,  3.855030745893336e-21, -1.458790782360823e-22,  4.830473407236130e-24,
 -1.432077039492301e-25,  3.864070274454506e-27, -9.606307083372925e-29,  2.221410123032276e-30, -4.812530841546286e-32,  4.147442198650004e-18, -6.780155535293376e-19,
  6.061602708900656e-20, -3.866280005451435e-21,  1.956971571476399e-22, -8.320664527324243e-24,  3.077978335776701e-25, -1.014383625383487e-26,  3.029367741004748e-28,
 -8.303290129217284e-30,  2.109543922356200e-31, -5.004723784511654e-33,  1.036067064544137e-19, -1.985602995486801e-20,  2.055354689827241e-21, -1.502309405109459e-22,
  8.641525357045172e-24, -4.146546558948149e-25,  1.720842795493015e-26, -6.329660207020297e-28,  2.100119369254695e-29, -6.368987569774665e-31,  1.783676558852664e-32,
 -4.648260223334220e-34,  2.304836619393796e-21, -5.181854042950398e-22,  6.232204041836720e-23, -5.242163979069859e-24,  3.441722124841257e-25, -1.871776594631158e-26,
  8.750545971857504e-28, -3.606243467600347e-29,  1.334135666004194e-30, -4.491675029367842e-32,  1.390917542202748e-33, -3.992800753027899e-35,  4.875586661584832e-23,
 -1.284492719691123e-23,  1.798645246752571e-24, -1.746224154902090e-25,  1.312797535758810e-26, -8.117955014383228e-28,  4.288210703069236e-29, -1.985651788819637e-30,
  8.211946291744406e-32, -3.076359353059738e-33,  1.055505475312885e-34, -3.343444752630058e-36,  1.095179139373670e-24, -3.363514696849664e-25,  5.475043449552557e-26,
 -6.132839280823337e-27,  5.279804441292342e-28, -3.712922705712122e-29,  2.216429426544649e-30, -1.153164673476015e-31,  5.330374721816137e-33, -2.221096420983030e-34,
  8.438451263476059e-36, -2.947053841139271e-37,  3.108276642747223e-26, -1.098428779973410e-26,  2.059556995587912e-27, -2.641552767871666e-28,  2.586458476335855e-29,
 -2.055284259470179e-30,  1.377975777776843e-31, -8.006945136969508e-33,  4.112041856990325e-34, -1.894484317908759e-35,  7.922381353018252e-37, -3.032127630491076e-38,
  1.406948472737536e-27, -5.575193735446228e-28,  1.177065788877768e-28, -1.692931266792489e-29,  1.848815903024738e-30, -1.629633545971860e-31,  1.205619609122868e-32,
 -7.692018313016509e-34,  4.317449840979976e-35, -2.164612951932904e-36,  9.810921852519786e-38, -4.053658683778025e-39,  1.149167311135752e-28, -4.894239095902652e-29,
  1.115623540012575e-29, -1.728669502882265e-30,  2.027033908931022e-31, -1.911630957457639e-32,  1.507844200740335e-33, -1.022292169642763e-34,  6.078398640894685e-36,
 -3.218776657605644e-37,  1.536633763525450e-38, -6.669275894093746e-40,  6.848802016921215e-02, -1.933462638086045e-04,  5.639155645965599e-07, -1.695482375103997e-09,
  5.187632921911403e-12, -1.642853425154772e-14,  4.972708522670936e-17, -1.824678666289315e-19,  3.098290893550588e-22, -4.301873244513294e-24, -2.736050828154623e-26,
 -4.084833237788917e-28,  5.876702511618172e-02, -1.870749734985945e-04,  7.332654001089246e-07, -3.094733242396480e-09,  1.313042312935197e-11, -5.513005440530379e-14,
  2.256482223221346e-16, -9.281616355289922e-19,  3.547516046420340e-21, -1.591365466532615e-23,  3.835250133622029e-26, -4.336884718517042e-28,  4.325561402837246e-02,
 -1.690533814032163e-04,  9.259285188214023e-07, -5.056555474213978e-09,  2.636689366099732e-11, -1.323166345342140e-13,  6.448056657544722e-16, -3.067001675426967e-18,
  1.430673570448981e-20, -6.543541940554072e-23,  2.962139084856415e-25, -1.301219106235326e-27,  2.729489079529062e-02, -1.366568486506409e-04,  9.806132018046992e-07,
 -6.428984991050294e-09,  3.936444961345790e-11, -2.298702049001032e-13,  1.296175032525619e-15, -7.073795748965529e-18,  3.779823424370165e-20, -1.952594713205394e-22,
  1.014641897729484e-24, -4.858817712805105e-27,  1.475227997414567e-02, -9.577660293865129e-05,  8.477538135372010e-07, -6.474327787285013e-09,  4.581643403920216e-11,
 -3.070393811547330e-13,  1.972219929591911e-15, -1.219225759450262e-17,  7.328605707752937e-20, -4.259342845536787e-22,  2.449286137456496e-24, -1.338639523304310e-26,
  6.821044691371267e-03, -5.718796840154178e-05,  6.006219330869461e-07, -5.277658638248031e-09,  4.273812517563749e-11, -3.251308984012882e-13,  2.353336501531942e-15,
 -1.631291942097478e-17,  1.092680284074615e-19, -7.071717899126955e-22,  4.477688584789650e-24, -2.734679824321776e-26,  2.693985593289335e-03, -2.884326454794387e-05,
  3.514291916510406e-07, -3.529577826108682e-09,  3.244313711616832e-11, -2.778293590902199e-13,  2.248511461960949e-15, -1.734601998837685e-17,  1.286354638637740e-19,
 -9.197982976845063e-22,  6.391505081360156e-24, -4.301860861760189e-26,  9.071759322969899e-04, -1.223881725352200e-05,  1.708323587019898e-07, -1.951713522036887e-09,
  2.022798146048978e-11, -1.937653772779154e-13,  1.743422286029036e-15, -1.488469733649701e-17,  1.216098839232226e-19, -9.553759380766866e-22,  7.261035459605756e-24,
 -5.344674340487786e-26,  2.598941029877994e-04, -4.360192750213115e-06,  6.924800346213903e-08, -8.963000950761890e-10,  1.041970476063927e-11, -1.111239945043383e-13,
  1.106834393318916e-15, -1.041445619486811e-17,  9.338972609873364e-20, -8.028439133063651e-22,  6.653559447414403e-24, -5.331555481520850e-26,  6.318611322415644e-05,
 -1.302375788033211e-06,  2.345061706959343e-08, -3.426782151971922e-10,  4.450852225562015e-12, -5.266443733106910e-14,  5.788238984221284e-16, -5.983636055597524e-18,
  5.872493545130291e-20, -5.508239666492736e-22,  4.965497110090018e-24, -4.318562964617113e-26,  1.299966652695610e-05, -3.257066983683165e-07,  6.637592100734863e-09,
 -1.091894039031889e-10,  1.580006207371977e-12, -2.069018005468439e-14,  2.503397203332655e-16, -2.836832130256587e-18,  3.040723797752035e-20, -3.105407368200958e-22,
  3.039359479227297e-24, -2.863204473131006e-26,  2.256043200261335e-06, -6.808510123529557e-08,  1.569361560589345e-09, -2.899844550988023e-11,  4.665970840516649e-13,
 -6.750433909089016e-15,  8.977093430460847e-17, -1.113415102073201e-18,  1.301553890708210e-20, -1.445243348268438e-22,  1.533734072538135e-24, -1.562892685845193e-26,
  3.291135505863125e-07, -1.187194292296833e-08,  3.095259429010140e-10, -6.414762802637419e-12,  1.146423559073346e-13, -1.830507042469451e-15,  2.673000611473367e-17,
 -3.625292899690083e-19,  4.617846960344011e-21, -5.570490833650830e-23,  6.404832211576259e-25, -7.054267752095230e-27,  4.020473081916970e-08, -1.722559467949809e-09,
  5.082538244970891e-11, -1.180467219293620e-12,  2.342200849333478e-14, -4.125844342003888e-16,  6.613154421500044e-18, -9.804583437989835e-20,  1.360444257268402e-21,
 -1.782278528196056e-23,  2.219563935393976e-25, -2.641471233361606e-27,  4.096252781001388e-09, -2.073953964697080e-10,  6.931657339001198e-12, -1.804103347979606e-13,
  3.974863160917740e-15, -7.726063498186317e-17,  1.359606042161436e-18, -2.203935514273243e-20,  3.331902922852831e-22, -4.741422977694826e-24,  6.396683532024697e-26,
 -8.226864761803781e-28,  3.466236298551570e-10, -2.065787553446649e-11,  7.831084319624965e-13, -2.285370162434250e-14,  5.595748942439050e-16, -1.201103756250267e-17,
  2.322342509725945e-19, -4.119042173458718e-21,  6.789486764916979e-23, -1.050183482326083e-24,  1.535824441982176e-26, -2.135904751300241e-28,  2.425986398797970e-11,
 -1.697087785084591e-12,  7.309393828554421e-14, -2.394861607585770e-15,  6.525861613616052e-17, -1.548961466441939e-18,  3.294974303648189e-20, -6.402601759568102e-22,
  1.152046965387694e-23, -1.939148972160104e-25,  3.077476491880044e-27, -4.632841605001986e-29,  1.398989511247265e-12, -1.146674690774837e-13,  5.623351810474262e-15,
 -2.072566416185621e-16,  6.298070710167115e-18, -1.656332647887073e-19,  3.883732736566351e-21, -8.282791985372044e-23,  1.629730315862258e-24, -2.990103543012796e-26,
  5.157740266864753e-28, -8.417280019618576e-30,  6.627150163755013e-14, -6.359318778528947e-15,  3.560397845333479e-16, -1.480048720519925e-17,  5.029037559044094e-19,
 -1.469240085454725e-20,  3.806891427360263e-22, -8.932183683148347e-24,  1.926238428718807e-25, -3.860563116312102e-27,  7.252847062988673e-29, -1.285667669755972e-30,
  2.575293099093186e-15, -2.893486964041039e-16,  1.855399714122405e-17, -8.728428691308548e-19,  3.327497543266416e-20, -1.083452968314901e-21,  3.111874339261698e-23,
 -8.056839429635776e-25,  1.909693945847147e-26, -4.192246617161084e-28,  8.600088099059218e-30, -1.659910747744220e-31,  8.222984341342269e-17, -1.082831842521370e-17,
  7.982779122935881e-19, -4.267159596869410e-20,  1.832561749029497e-21, -6.676443594404683e-23,  2.133679609535892e-24, -6.117690505660050e-26,  1.599246154032383e-27,
 -3.857860561905014e-29,  8.668276998236179e-31, -1.826976062271999e-32,  2.172655147036015e-18, -3.358890399075993e-19,  2.859296695617687e-20, -1.744964757840014e-21,
  8.482049132464709e-23, -3.473555005946208e-24,  1.240614035689975e-25, -3.955697459102388e-27,  1.144976778437042e-28, -3.046486118566795e-30,  7.523981281474299e-32,
 -1.737419103516227e-33,  4.829090992112516e-20, -8.783449227198518e-21,  8.675028235293346e-22, -6.076087849756985e-23,  3.360642000702454e-24, -1.554900359123538e-25,
  6.236835391766697e-27, -2.221716515926824e-28,  7.151613041188264e-30, -2.107466575606232e-31,  5.743067792939481e-33, -1.458196524716790e-34,  9.331085223810008e-22,
 -2.000641558774406e-22,  2.303473445501524e-23, -1.861644653659990e-24,  1.177981472154495e-25, -6.190364477087172e-27,  2.802588203021214e-28, -1.120672217582202e-29,
  4.029596096138993e-31, -1.320585129752321e-32,  3.986106402142970e-34, -1.116774657022567e-35,  1.666204671235674e-23, -4.213426955812597e-24,  5.676466533322785e-25,
 -5.317712622773506e-26,  3.867642891979792e-27, -2.319027355562526e-28,  1.190172840819951e-29, -5.363829968124146e-31,  2.162402330892464e-32, -7.907837273251936e-34,
  2.651950933524555e-35, -8.220579383493286e-37,  3.063894698833601e-25, -9.108467578822016e-26,  1.436629415998612e-26, -1.562542249137794e-27,  1.308830219381431e-28,
 -8.971735249892331e-30,  5.229094228771159e-31, -2.660231864994913e-32,  1.203987188152016e-33, -4.918057464931388e-35,  1.833708796051797e-36, -6.291433986507493e-38,
  6.947844934912621e-27, -2.401163066084441e-27,  4.403009757755707e-28, -5.529788040714325e-29,  5.309085370403684e-30, -4.142009891377306e-31,  2.729735421772114e-32,
 -1.560828536818776e-33,  7.895571443999103e-35, -3.586296045230293e-36,  1.479784815781228e-37, -5.592668094371802e-39,  2.518433987219684e-28, -9.865295397025444e-29,
  2.058185342784684e-29, -2.926808732200167e-30,  3.162386087018212e-31, -2.759750921557856e-32,  2.022667687244769e-33, -1.279217194277066e-34,  7.121254133218831e-36,
 -3.542838704416056e-37,  1.594125424402720e-38, -6.541730238708368e-40,  1.747001816766234e-29, -7.415599943864676e-30,  1.684343579616558e-30, -2.600897839266685e-31,
  3.039786298650448e-32, -2.857808154218043e-33,  2.247535338688015e-34, -1.519554033385091e-35,  9.011286892851764e-37, -4.759989064303263e-38,  2.267042254492196e-39,
 -9.817419126218389e-41,  };
  int offset = -29;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 29;
    if (std::isnan(t)) {
      fill_n(rr+offset, 29, 0.5);
      fill_n(ww+offset, 29, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 29; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=29; ++j) {
        const int boxof = it*348+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
