// StringTokenizer.C  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (c) 2005 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include "StringTokenizer.H"
#include <string>
#include <cstring>

StringTokenizer::StringTokenizer(std::string s)
  : st(s), pos(0)
{ }

bool
StringTokenizer::more_tokens_p ()
{
  if (pos == st.length())
    return false;

  for (std::string::size_type i = pos; i < st.length(); i++)
    if (st[i] != ' ' && st[i] != '\t')
      return true;

  return false;
}

bool
StringTokenizer::more_tokens_p (char c)
{
  if (pos == st.length())
    return false;

  for (std::string::size_type i = pos; i < st.length(); i++)
    if (st[i] != c)
      return true;

  return false;
}

unsigned int
StringTokenizer::count_tokens ()
{
  unsigned int i = 0;
  StringTokenizer s (st);
  
  while (s.more_tokens_p ())
    {
      s.next_token ();
      i++;
    }
  
  return i;
}

unsigned int
StringTokenizer::count_tokens (char c)
{
  unsigned int i = 0;
  StringTokenizer s(st);
  
  while (s.more_tokens_p (c))
    {
      s.next_token (c);
      i++;
    }
  
  return i;
}

std::string
StringTokenizer::next_token()
{
  std::string::size_type i = pos;
  
  while (i < st.length() && (st[i] == ' ' || st[i] == '\t'))
    i++;
  
  for (std::string::size_type j = i; j < st.length(); j++)
    if (st[j] == ' ' || st[j] == '\t') 
      {
	pos = j + 1;
	return st.substr (i, j - i);
      }

  pos = st.length();
  return st.substr (i, st.length() - i);
}

std::string
StringTokenizer::next_token (char c, bool empty)
{
  std::string::size_type i = pos;
  std::string::size_type j = 0;

  while (i < st.length() && (st[i] == c))
    {
      i++;
    }

  for (j = i; j < st.length(); j++)
    {
      if (st[j] == c)
	{
	  pos = j + 1;
	  return st.substr (i, j - i);
	}
    }

  if (empty)
    return "";
  
  pos = st.length();
  return st.substr (i, st.length() - i);
}

std::string
StringTokenizer::rest()
{
  if (pos == st.length())
    return "";

  // Skip whitespace
  while (pos < st.length() && (std::isspace (st[pos])))
    pos++;

  return st.substr (pos, st.length() - pos);
}
