//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Fit/FitParameterWidget.h
//! @brief     Defines class FitParameterWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_FIT_FITPARAMETERWIDGET_H
#define BORNAGAIN_GUI_VIEW_FIT_FITPARAMETERWIDGET_H

#include "GUI/View/Common/DataAccessWidget.h"

class ParameterTuningWidget;
class QTreeView;
class FitParameterModel;
class FitParameterItem;
class DeleteEventFilter;
class OverlayLabelController;
class QItemSelection;

//! The FitParametersWidget class contains a tree view to set fit parameters (fix/release,
//! starting value, min/max bounds). It occupies bottom right corner of JobView.

class FitParameterWidget : public DataAccessWidget {
    Q_OBJECT
public:
    FitParameterWidget(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_item) override;

    void setParameterTuningWidget(ParameterTuningWidget* tuningWidget);

public slots:
    void onTuningWidgetContextMenu(const QPoint& point);
    void onFitParameterTreeContextMenu(const QPoint& point);
    void onFitParametersSelectionChanged(const QItemSelection& selection);

private slots:
    void onCreateFitParAction();
    void onRemoveFromFitParAction();
    void onRemoveFitParAction();
    void onAddToFitParAction(int ipar);
    void onFitParameterModelChange();

private:
    void init_actions();
    void init_fit_model();
    FitParameterContainerItem* fitContainerItem() const;

    bool canCreateFitParameter();
    bool canRemoveFromFitParameters();

    void setActionsEnabled(bool value);
    void connectFitParametersSelection(bool active);

    QVector<FitParameterItem*> selectedFitParameterItems();
    QVector<FitParameterItem*> emptyFitParameterItems();
    QStringList selectedFitParameterLinks();

    void spanParameters();
    void updateInfoLabel();

    QTreeView* m_treeView;
    ParameterTuningWidget* m_tuningWidget;
    QAction* m_createFitParAction;
    QAction* m_removeFromFitParAction;
    QAction* m_removeFitParAction;
    std::unique_ptr<FitParameterModel> m_fitParameterModel;
    DeleteEventFilter* m_keyboardFilter;
    OverlayLabelController* m_infoLabel;
};

#endif // BORNAGAIN_GUI_VIEW_FIT_FITPARAMETERWIDGET_H
