//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/LatticeTypeSelectionForm.h
//! @brief     Defines class LatticeTypeSelectionForm
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_LATTICETYPESELECTIONFORM_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_LATTICETYPESELECTIONFORM_H

#include "GUI/Model/Sample/InterferenceItems.h"
#include "GUI/View/SampleDesigner/SelectionContainerForm.h"

class SampleEditorController;
class Interference2DAbstractLatticeItem;
class QCheckBox;

//! Form for editing lattice type values
class LatticeTypeSelectionForm : public ISelectionContainerForm {
public:
    LatticeTypeSelectionForm(QWidget* parent, Interference2DAbstractLatticeItem* interferenceItem,
                             SampleEditorController* ec);

    virtual void createContent() override;
    void onIntegrateOverXiChanged();
    void updateXiVisibility();

    Interference2DAbstractLatticeItem* interferenceItem() const;

private:
    Interference2DAbstractLatticeItem* m_interferenceItem;
    QLabel* m_xiLabel;
    QCheckBox* m_integrateOverXiCheckBox;
};


#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_LATTICETYPESELECTIONFORM_H
