/*
 * buffy - Mailbox watcher
 *
 * Copyright (C) 2003--2008  Enrico Zini <enrico@enricozini.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#define APPNAME PACKAGE_NAME
#else
#warning No config.h found: using fallback values
#define APPNAME __FILE__
#define PACKAGE_VERSION "unknown"
#endif

//#include "Environment.h"
#include <buffy/mailfolder.h>
#include <wibble/exception.h>
#include <wibble/commandline/parser.h>

#include <vector>
#include <iostream>
#include <unistd.h>

using namespace std;
using namespace buffy;
using namespace wibble;
using namespace wibble::commandline;

static vector<MailFolder> folders;

static void printStats(const MailFolder& f)
{
	cout << f.name() << ": path " << f.path()
		 << ", new " << f.getMsgNew()
		 << " unread " << f.getMsgUnread()
		 << ", total " << f.getMsgTotal()
		 << ", flagged " << f.getMsgFlagged()
		 << endl;
}

class StatsPrinter : public MailFolderConsumer
{
public:
	void consume(MailFolder& f)
	{
		f.updateStatistics();
		folders.push_back(f);
		printStats(f);
	}
};

struct Options : public StandardParserWithManpage
{
	BoolOption* verbose;
	BoolOption* debug;
	BoolOption* loop;

	Options() : StandardParserWithManpage("blist", PACKAGE_VERSION, 1, PACKAGE_BUGREPORT)
	{
		usage = "";
		description =
			"Mail folder monitor.\n"
			"Monitor new and unread messages in a collection of mail folders.";
		verbose = add<BoolOption>("verbose", 0, "verbose", "", "enable verbose output");
		debug = add<BoolOption>("debug", 0, "debug", "", "enable debugging output (includes verbose output)");
		loop = add<BoolOption>("loop", 'l', "loop", "", "continuously loop checking for new changes");
	}
};

int main(int argc, char* argv[])
{
	Options opts;
	try {
		// Process the commandline
		if (opts.parse(argc, (const char**)argv))
			return 0;

//		Environment::init();
		
//		if (opts.get("verbose").defined())
//			Environment::get().verbose(true);
//		if (opts.get("debug").defined())
//			Environment::get().debug(true);

		//MaildirMailFolder f("Test", "/home/enrico/Maildir/.0-other");
		//MaildirMailFolder f("/home/enrico/Maildir/.0-other");

		/*
		// Read the full collection
		TagcollDocument<std::string> document;

		if (argc > 1)
			document.load(argv[1]);
		else
			document.loadDebtags();
		*/

		StatsPrinter printer;
		while (opts.hasNext())
		{
			string path = opts.next();
			while (path.size() > 1 && path[path.size() - 1] == '/')
				path.resize(path.size() - 1);
			MailFolder::enumerateFolders(path, printer);
		}
//		Environment::enumerateFolders(printer);
		//MaildirMailFolder::enumerateFolders("/home/enrico/Maildir", buffyWindow);

		if (opts.loop->boolValue())
		{
			while (true)
			{
				sleep(1);
				for (vector<MailFolder>::iterator i = folders.begin();
						i != folders.end(); i++)
					if (i->changed())
					{
						cout << i->name() << " changed" << endl;
						i->updateStatistics();
						printStats(*i);
					}
			}
		}
		
		return 0;
	} catch (wibble::exception::BadOption& e) {
		cerr << e.desc() << endl;
		opts.outputHelp(cerr);
		return 1;
	} catch (std::exception& e) {
		cerr << e.what() << endl;
		return 1;
	}
}

// vim:set ts=4 sw=4:
