#!/usr/bin/perl

#
# Layout of events: N x y [z] spec reac time
#

sub numerically { $a <=> $b; }

%SUM = ();

$reacold=-10;

$strttime=.001;
$strttime=0;

while (<>)
{
    ($a,$b,$c,$d,$e,$f,$g) = split(' ', $_);
    #
    # The 2-D case.
    #
    $spec = $d;
    $reac = $e;
    $time = $f;

    if ($g ne "")
    {
        #
        # The 3-D case -- $g is not NULL.
        #
        $spec = $e;
        $reac = $f;
        $time = $g;
    }

    if ($reac == -1 && $time != $strttime)
    {
        if ($reac == $reacold)
        {
            #
            # -1 -> non-event.
            #
            $SUM{-1}++;
        }
        else
        {
            $SUM{$spec}++;
        }
    }

    $reacold=$reac;

    if (eof)
    {
        printf STDERR "Finished processing $ARGV ...\n"
    }
}

foreach $key (sort numerically keys %SUM)
{
    print $key, ": ", $SUM{$key}, "\n";
}
