from __future__ import absolute_import, division, print_function
import time
import mmtbx.refinement.real_space.fit_residues
import mmtbx.refinement.real_space

pdb_str_answer_1="""\n
CRYST1   41.392   28.519   38.664  90.00  90.00  90.00 P 1
ATOM      1  N   TRP A   2      29.941  24.684  29.674  1.00 20.00           N
ATOM      2  CA  TRP A   2      28.492  24.830  29.738  1.00 20.00           C
ATOM      3  C   TRP A   2      28.020  25.942  28.807  1.00 20.00           C
ATOM      4  O   TRP A   2      27.970  27.109  29.195  1.00 20.00           O
ATOM      5  CB  TRP A   2      28.046  25.121  31.172  1.00 20.00           C
ATOM      6  CG  TRP A   2      28.260  23.972  32.110  1.00 20.00           C
ATOM      7  CD1 TRP A   2      29.313  23.792  32.959  1.00 20.00           C
ATOM      8  CD2 TRP A   2      27.400  22.841  32.294  1.00 20.00           C
ATOM      9  NE1 TRP A   2      29.162  22.621  33.660  1.00 20.00           N
ATOM     10  CE2 TRP A   2      27.995  22.018  33.270  1.00 20.00           C
ATOM     11  CE3 TRP A   2      26.184  22.446  31.728  1.00 20.00           C
ATOM     12  CZ2 TRP A   2      27.416  20.823  33.692  1.00 20.00           C
ATOM     13  CZ3 TRP A   2      25.611  21.259  32.149  1.00 20.00           C
ATOM     14  CH2 TRP A   2      26.227  20.462  33.121  1.00 20.00           C
ATOM     15  HA  TRP A   2      28.024  23.899  29.419  1.00 20.00           H
ATOM     16  HB2 TRP A   2      28.612  25.972  31.552  1.00 20.00           H
ATOM     17  HB3 TRP A   2      26.981  25.355  31.170  1.00 20.00           H
ATOM     18  HD1 TRP A   2      30.145  24.473  33.064  1.00 20.00           H
ATOM     19  HE1 TRP A   2      29.813  22.258  34.357  1.00 20.00           H
ATOM     20  HE3 TRP A   2      25.702  23.054  30.977  1.00 20.00           H
ATOM     21  HZ2 TRP A   2      27.889  20.206  34.442  1.00 20.00           H
ATOM     22  HZ3 TRP A   2      24.672  20.941  31.720  1.00 20.00           H
ATOM     23  HH2 TRP A   2      25.753  19.541  33.427  1.00 20.00           H
ATOM     24  N   ILE A   3      27.674  25.570  27.579  1.00 20.00           N
ATOM     25  CA  ILE A   3      27.205  26.516  26.579  1.00 20.00           C
ATOM     26  C   ILE A   3      25.724  26.260  26.313  1.00 20.00           C
ATOM     27  O   ILE A   3      25.144  25.277  26.774  1.00 20.00           O
ATOM     28  CB  ILE A   3      28.028  26.434  25.277  1.00 20.00           C
ATOM     29  CG1 ILE A   3      27.986  25.016  24.703  1.00 20.00           C
ATOM     30  CG2 ILE A   3      29.465  26.862  25.533  1.00 20.00           C
ATOM     31  CD1 ILE A   3      28.591  24.900  23.320  1.00 20.00           C
ATOM     32  H   ILE A   3      27.708  24.606  27.246  1.00 20.00           H
ATOM     33  HA  ILE A   3      27.304  27.528  26.971  1.00 20.00           H
ATOM     34  HB  ILE A   3      27.589  27.115  24.548  1.00 20.00           H
ATOM     35 HG12 ILE A   3      28.542  24.352  25.365  1.00 20.00           H
ATOM     36 HG13 ILE A   3      26.949  24.686  24.636  1.00 20.00           H
ATOM     37 HG21 ILE A   3      29.996  26.912  24.582  1.00 20.00           H
ATOM     38 HG22 ILE A   3      29.462  27.843  26.008  1.00 20.00           H
ATOM     39 HG23 ILE A   3      29.940  26.133  26.188  1.00 20.00           H
ATOM     40 HD11 ILE A   3      28.431  23.888  22.947  1.00 20.00           H
ATOM     41 HD12 ILE A   3      28.107  25.620  22.660  1.00 20.00           H
ATOM     42 HD13 ILE A   3      29.659  25.109  23.380  1.00 20.00           H
ATOM     43  N   SER A   4      25.113  27.166  25.555  1.00 20.00           N
ATOM     44  CA  SER A   4      23.704  27.047  25.222  1.00 20.00           C
ATOM     45  C   SER A   4      23.503  26.043  24.090  1.00 20.00           C
ATOM     46  O   SER A   4      24.433  25.694  23.357  1.00 20.00           O
ATOM     47  CB  SER A   4      23.130  28.407  24.823  1.00 20.00           C
ATOM     48  OG  SER A   4      23.712  28.872  23.618  1.00 20.00           O
ATOM     49  H   SER A   4      25.567  27.989  25.160  1.00 20.00           H
ATOM     50  HA  SER A   4      23.158  26.689  26.095  1.00 20.00           H
ATOM     51  HB2 SER A   4      22.053  28.309  24.682  1.00 20.00           H
ATOM     52  HB3 SER A   4      23.337  29.125  25.617  1.00 20.00           H
ATOM     53  HG  SER A   4      23.333  29.743  23.378  1.00 20.00           H
ATOM     54  N   LYS A   5      22.264  25.579  23.955  1.00 20.00           N
ATOM     55  CA  LYS A   5      21.908  24.615  22.925  1.00 20.00           C
ATOM     56  C   LYS A   5      21.557  25.335  21.630  1.00 20.00           C
ATOM     57  O   LYS A   5      20.907  26.384  21.643  1.00 20.00           O
ATOM     58  CB  LYS A   5      20.730  23.752  23.378  1.00 20.00           C
ATOM     59  CG  LYS A   5      21.056  22.819  24.533  1.00 20.00           C
ATOM     60  CD  LYS A   5      19.855  21.970  24.919  1.00 20.00           C
ATOM     61  CE  LYS A   5      20.175  21.054  26.089  1.00 20.00           C
ATOM     62  NZ  LYS A   5      19.004  20.225  26.486  1.00 20.00           N
ATOM     63  H   LYS A   5      21.482  25.854  24.549  1.00 20.00           H
ATOM     64  HA  LYS A   5      22.759  23.960  22.733  1.00 20.00           H
ATOM     65  HB2 LYS A   5      19.919  24.406  23.699  1.00 20.00           H
ATOM     66  HB3 LYS A   5      20.400  23.140  22.539  1.00 20.00           H
ATOM     67  HG2 LYS A   5      21.865  22.151  24.238  1.00 20.00           H
ATOM     68  HG3 LYS A   5      21.350  23.409  25.401  1.00 20.00           H
ATOM     69  HD2 LYS A   5      19.032  22.623  25.211  1.00 20.00           H
ATOM     70  HD3 LYS A   5      19.564  21.352  24.070  1.00 20.00           H
ATOM     71  HE2 LYS A   5      20.986  20.383  25.806  1.00 20.00           H
ATOM     72  HE3 LYS A   5      20.469  21.659  26.947  1.00 20.00           H
ATOM     73  HZ1 LYS A   5      19.258  19.611  27.286  1.00 20.00           H
ATOM     74  HZ2 LYS A   5      18.213  20.839  26.769  1.00 20.00           H
ATOM     75  HZ3 LYS A   5      18.702  19.631  25.688  1.00 20.00           H
ATOM     76  N   GLY A   6      21.990  24.766  20.516  1.00 20.00           N
ATOM     77  CA  GLY A   6      21.723  25.351  19.220  1.00 20.00           C
ATOM     78  C   GLY A   6      22.652  24.781  18.170  1.00 20.00           C
ATOM     79  O   GLY A   6      23.528  23.964  18.453  1.00 20.00           O
ATOM     80  H   GLY A   6      22.529  23.900  20.482  1.00 20.00           H
ATOM     81  HA2 GLY A   6      20.693  25.144  18.927  1.00 20.00           H
ATOM     82  HA3 GLY A   6      21.865  26.431  19.266  1.00 20.00           H
ATOM     83  N   CYS A   7      22.436  25.239  16.940  1.00 20.00           N
ATOM     84  CA  CYS A   7      23.239  24.795  15.814  1.00 20.00           C
ATOM     85  C   CYS A   7      24.608  25.471  15.834  1.00 20.00           C
ATOM     86  O   CYS A   7      24.859  26.415  16.588  1.00 20.00           O
ATOM     87  CB  CYS A   7      22.520  25.089  14.498  1.00 20.00           C
ATOM     88  SG  CYS A   7      20.985  24.162  14.267  1.00 20.00           S
ATOM     89  H   CYS A   7      21.713  25.916  16.696  1.00 20.00           H
ATOM     90  HA  CYS A   7      23.390  23.718  15.885  1.00 20.00           H
ATOM     91  HB2 CYS A   7      22.275  26.151  14.463  1.00 20.00           H
ATOM     92  HB3 CYS A   7      23.186  24.839  13.672  1.00 20.00           H
ATOM     93  HG  CYS A   7      20.462  24.488  13.122  1.00 20.00           H
ATOM     94  N   GLY A   8      25.501  24.973  14.988  1.00 20.00           N
ATOM     95  CA  GLY A   8      26.842  25.520  14.903  1.00 20.00           C
ATOM     96  C   GLY A   8      27.774  24.534  14.219  1.00 20.00           C
ATOM     97  O   GLY A   8      27.338  23.669  13.463  1.00 20.00           O
ATOM     98  H   GLY A   8      25.325  24.194  14.354  1.00 20.00           H
ATOM     99  HA2 GLY A   8      26.828  26.447  14.330  1.00 20.00           H
ATOM    100  HA3 GLY A   8      27.221  25.728  15.903  1.00 20.00           H
ATOM    101  N   TYR A   9      29.064  24.694  14.508  1.00 20.00           N
ATOM    102  CA  TYR A   9      30.099  23.839  13.943  1.00 20.00           C
ATOM    103  C   TYR A   9      31.151  23.568  15.006  1.00 20.00           C
ATOM    104  O   TYR A   9      31.586  24.491  15.701  1.00 20.00           O
ATOM    105  CB  TYR A   9      30.744  24.487  12.712  1.00 20.00           C
ATOM    106  CG  TYR A   9      29.807  24.624  11.533  1.00 20.00           C
ATOM    107  CD1 TYR A   9      29.553  23.547  10.694  1.00 20.00           C
ATOM    108  CD2 TYR A   9      29.177  25.830  11.258  1.00 20.00           C
ATOM    109  CE1 TYR A   9      28.698  23.667   9.615  1.00 20.00           C
ATOM    110  CE2 TYR A   9      28.321  25.960  10.181  1.00 20.00           C
ATOM    111  CZ  TYR A   9      28.085  24.876   9.363  1.00 20.00           C
ATOM    112  OH  TYR A   9      27.232  25.000   8.290  1.00 20.00           O
ATOM    113  H   TYR A   9      29.423  25.414  15.135  1.00 20.00           H
ATOM    114  HA  TYR A   9      29.661  22.888  13.642  1.00 20.00           H
ATOM    115  HB2 TYR A   9      31.089  25.486  12.981  1.00 20.00           H
ATOM    116  HB3 TYR A   9      31.590  23.877  12.396  1.00 20.00           H
ATOM    117  HD1 TYR A   9      30.032  22.598  10.889  1.00 20.00           H
ATOM    118  HD2 TYR A   9      29.360  26.682  11.896  1.00 20.00           H
ATOM    119  HE1 TYR A   9      28.511  22.819   8.973  1.00 20.00           H
ATOM    120  HE2 TYR A   9      27.839  26.906   9.981  1.00 20.00           H
ATOM    121  HH  TYR A   9      27.170  24.148   7.811  1.00 20.00           H
ATOM    122  N   CYS A  10      31.557  22.306  15.127  1.00 20.00           N
ATOM    123  CA  CYS A  10      32.560  21.900  16.106  1.00 20.00           C
ATOM    124  C   CYS A  10      33.411  20.798  15.497  1.00 20.00           C
ATOM    125  O   CYS A  10      32.883  19.764  15.078  1.00 20.00           O
ATOM    126  CB  CYS A  10      31.904  21.418  17.404  1.00 20.00           C
ATOM    127  SG  CYS A  10      31.011  22.705  18.306  1.00 20.00           S
ATOM    128  H   CYS A  10      31.205  21.537  14.557  1.00 20.00           H
ATOM    129  HA  CYS A  10      33.205  22.746  16.338  1.00 20.00           H
ATOM    130  HB2 CYS A  10      31.193  20.627  17.164  1.00 20.00           H
ATOM    131  HB3 CYS A  10      32.679  21.028  18.063  1.00 20.00           H
ATOM    132  HG  CYS A  10      30.498  22.189  19.383  1.00 20.00           H
ATOM    133  N   SER A  11      34.725  21.019  15.450  1.00 20.00           N
ATOM    134  CA  SER A  11      35.665  20.047  14.894  1.00 20.00           C
ATOM    135  C   SER A  11      35.354  19.739  13.432  1.00 20.00           C
ATOM    136  O   SER A  11      35.598  18.629  12.954  1.00 20.00           O
ATOM    137  CB  SER A  11      35.674  18.756  15.717  1.00 20.00           C
ATOM    138  OG  SER A  11      34.438  18.071  15.613  1.00 20.00           O
ATOM    139  H   SER A  11      35.172  21.870  15.792  1.00 20.00           H
ATOM    140  HA  SER A  11      36.668  20.471  14.935  1.00 20.00           H
ATOM    141  HB2 SER A  11      36.469  18.107  15.348  1.00 20.00           H
ATOM    142  HB3 SER A  11      35.853  19.005  16.763  1.00 20.00           H
ATOM    143  HG  SER A  11      34.287  17.789  14.687  1.00 20.00           H
ATOM    144  N   GLY A  12      34.815  20.720  12.711  1.00 20.00           N
ATOM    145  CA  GLY A  12      34.483  20.536  11.312  1.00 20.00           C
ATOM    146  C   GLY A  12      33.445  19.456  11.092  1.00 20.00           C
ATOM    147  O   GLY A  12      33.673  18.512  10.330  1.00 20.00           O
ATOM    148  H   GLY A  12      34.600  21.649  13.072  1.00 20.00           H
ATOM    149  HA2 GLY A  12      34.097  21.471  10.907  1.00 20.00           H
ATOM    150  HA3 GLY A  12      35.382  20.267  10.759  1.00 20.00           H
ATOM    151  N   SER A  13      32.298  19.583  11.755  1.00 20.00           N
ATOM    152  CA  SER A  13      31.226  18.608  11.625  1.00 20.00           C
ATOM    153  C   SER A  13      29.894  19.302  11.866  1.00 20.00           C
ATOM    154  O   SER A  13      29.820  20.336  12.535  1.00 20.00           O
ATOM    155  CB  SER A  13      31.406  17.440  12.602  1.00 20.00           C
ATOM    156  OG  SER A  13      31.276  17.874  13.945  1.00 20.00           O
ATOM    157  H   SER A  13      32.083  20.353  12.390  1.00 20.00           H
ATOM    158  HA  SER A  13      31.225  18.208  10.611  1.00 20.00           H
ATOM    159  HB2 SER A  13      30.645  16.688  12.398  1.00 20.00           H
ATOM    160  HB3 SER A  13      32.399  17.012  12.463  1.00 20.00           H
ATOM    161  HG  SER A  13      31.955  18.552  14.145  1.00 20.00           H
ATOM    162  N   TRP A  14      28.838  18.717  11.308  1.00 20.00           N
ATOM    163  CA  TRP A  14      27.503  19.277  11.460  1.00 20.00           C
ATOM    164  C   TRP A  14      27.025  19.139  12.901  1.00 20.00           C
ATOM    165  O   TRP A  14      27.332  18.165  13.594  1.00 20.00           O
ATOM    166  CB  TRP A  14      26.523  18.581  10.516  1.00 20.00           C
ATOM    167  CG  TRP A  14      26.787  18.859   9.068  1.00 20.00           C
ATOM    168  CD1 TRP A  14      27.479  18.071   8.195  1.00 20.00           C
ATOM    169  CD2 TRP A  14      26.364  20.008   8.323  1.00 20.00           C
ATOM    170  NE1 TRP A  14      27.513  18.657   6.952  1.00 20.00           N
ATOM    171  CE2 TRP A  14      26.835  19.847   7.004  1.00 20.00           C
ATOM    172  CE3 TRP A  14      25.633  21.156   8.642  1.00 20.00           C
ATOM    173  CZ2 TRP A  14      26.599  20.790   6.007  1.00 20.00           C
ATOM    174  CZ3 TRP A  14      25.399  22.092   7.650  1.00 20.00           C
ATOM    175  CH2 TRP A  14      25.881  21.903   6.349  1.00 20.00           C
ATOM    176  H   TRP A  14      28.875  17.864  10.751  1.00 20.00           H
ATOM    177  HA  TRP A  14      27.527  20.337  11.208  1.00 20.00           H
ATOM    178  HB2 TRP A  14      26.592  17.504  10.667  1.00 20.00           H
ATOM    179  HB3 TRP A  14      25.513  18.923  10.743  1.00 20.00           H
ATOM    180  HD1 TRP A  14      27.934  17.124   8.444  1.00 20.00           H
ATOM    181  HE1 TRP A  14      27.968  18.269   6.126  1.00 20.00           H
ATOM    182  HE3 TRP A  14      25.258  21.309   9.643  1.00 20.00           H
ATOM    183  HZ2 TRP A  14      26.969  20.649   5.002  1.00 20.00           H
ATOM    184  HZ3 TRP A  14      24.836  22.983   7.883  1.00 20.00           H
ATOM    185  HH2 TRP A  14      25.681  22.653   5.598  1.00 20.00           H
ATOM    186  N   CYS A  15      26.262  20.134  13.350  1.00 20.00           N
ATOM    187  CA  CYS A  15      25.724  20.153  14.703  1.00 20.00           C
ATOM    188  C   CYS A  15      24.343  20.785  14.679  1.00 20.00           C
ATOM    189  O   CYS A  15      24.171  21.884  14.142  1.00 20.00           O
ATOM    190  CB  CYS A  15      26.644  20.926  15.656  1.00 20.00           C
ATOM    191  SG  CYS A  15      28.261  20.157  15.913  1.00 20.00           S
ATOM    192  H   CYS A  15      25.999  20.947  12.793  1.00 20.00           H
ATOM    193  HA  CYS A  15      25.629  19.131  15.070  1.00 20.00           H
ATOM    194  HB2 CYS A  15      26.812  21.922  15.247  1.00 20.00           H
ATOM    195  HB3 CYS A  15      26.156  21.004  16.627  1.00 20.00           H
ATOM    196  HG  CYS A  15      28.090  18.971  16.418  1.00 20.00           H
ATOM    197  N   SER A  16      23.365  20.092  15.258  1.00 20.00           N
ATOM    198  CA  SER A  16      21.997  20.584  15.304  1.00 20.00           C
ATOM    199  C   SER A  16      21.307  20.011  16.532  1.00 20.00           C
ATOM    200  O   SER A  16      21.477  18.832  16.855  1.00 20.00           O
ATOM    201  CB  SER A  16      21.223  20.204  14.036  1.00 20.00           C
ATOM    202  OG  SER A  16      19.882  20.658  14.102  1.00 20.00           O
ATOM    203  H   SER A  16      23.494  19.184  15.705  1.00 20.00           H
ATOM    204  HA  SER A  16      22.005  21.670  15.390  1.00 20.00           H
ATOM    205  HB2 SER A  16      21.709  20.661  13.174  1.00 20.00           H
ATOM    206  HB3 SER A  16      21.224  19.119  13.932  1.00 20.00           H
ATOM    207  HG  SER A  16      19.863  21.634  14.196  1.00 20.00           H
ATOM    208  N   TRP A  17      20.530  20.852  17.211  1.00 20.00           N
ATOM    209  CA  TRP A  17      19.805  20.447  18.405  1.00 20.00           C
ATOM    210  C   TRP A  17      18.444  21.126  18.420  1.00 20.00           C
ATOM    211  O   TRP A  17      18.291  22.255  17.947  1.00 20.00           O
ATOM    212  CB  TRP A  17      20.580  20.799  19.683  1.00 20.00           C
ATOM    213  CG  TRP A  17      21.854  20.026  19.842  1.00 20.00           C
ATOM    214  CD1 TRP A  17      23.112  20.445  19.519  1.00 20.00           C
ATOM    215  CD2 TRP A  17      21.994  18.699  20.362  1.00 20.00           C
ATOM    216  NE1 TRP A  17      24.027  19.461  19.807  1.00 20.00           N
ATOM    217  CE2 TRP A  17      23.366  18.379  20.325  1.00 20.00           C
ATOM    218  CE3 TRP A  17      21.094  17.750  20.856  1.00 20.00           C
ATOM    219  CZ2 TRP A  17      23.858  17.151  20.763  1.00 20.00           C
ATOM    220  CZ3 TRP A  17      21.584  16.531  21.290  1.00 20.00           C
ATOM    221  CH2 TRP A  17      22.954  16.243  21.240  1.00 20.00           C
ATOM    222  H   TRP A  17      20.384  21.828  16.954  1.00 20.00           H
ATOM    223  HA  TRP A  17      19.650  19.369  18.385  1.00 20.00           H
ATOM    224  HB2 TRP A  17      20.833  21.859  19.662  1.00 20.00           H
ATOM    225  HB3 TRP A  17      19.951  20.585  20.547  1.00 20.00           H
ATOM    226  HD1 TRP A  17      23.354  21.410  19.099  1.00 20.00           H
ATOM    227  HE1 TRP A  17      25.034  19.526  19.659  1.00 20.00           H
ATOM    228  HE3 TRP A  17      20.036  17.964  20.897  1.00 20.00           H
ATOM    229  HZ2 TRP A  17      24.914  16.925  20.727  1.00 20.00           H
ATOM    230  HZ3 TRP A  17      20.900  15.789  21.673  1.00 20.00           H
ATOM    231  HH2 TRP A  17      23.304  15.282  21.587  1.00 20.00           H
ATOM    232  N   TRP A  18      17.455  20.423  18.969  1.00 20.00           N
ATOM    233  CA  TRP A  18      16.094  20.946  19.049  1.00 20.00           C
ATOM    234  C   TRP A  18      15.412  20.298  20.245  1.00 20.00           C
ATOM    235  O   TRP A  18      15.208  19.080  20.259  1.00 20.00           O
ATOM    236  CB  TRP A  18      15.322  20.671  17.761  1.00 20.00           C
ATOM    237  CG  TRP A  18      13.923  21.207  17.776  1.00 20.00           C
ATOM    238  CD1 TRP A  18      13.548  22.518  17.835  1.00 20.00           C
ATOM    239  CD2 TRP A  18      12.711  20.445  17.732  1.00 20.00           C
ATOM    240  NE1 TRP A  18      12.178  22.619  17.830  1.00 20.00           N
ATOM    241  CE2 TRP A  18      11.640  21.360  17.767  1.00 20.00           C
ATOM    242  CE3 TRP A  18      12.427  19.077  17.665  1.00 20.00           C
ATOM    243  CZ2 TRP A  18      10.308  20.953  17.738  1.00 20.00           C
ATOM    244  CZ3 TRP A  18      11.103  18.675  17.637  1.00 20.00           C
ATOM    245  CH2 TRP A  18      10.061  19.609  17.673  1.00 20.00           C
ATOM    246  H   TRP A  18      17.566  19.490  19.365  1.00 20.00           H
ATOM    247  HA  TRP A  18      16.126  22.023  19.211  1.00 20.00           H
ATOM    248  HB2 TRP A  18      15.849  21.136  16.929  1.00 20.00           H
ATOM    249  HB3 TRP A  18      15.265  19.593  17.608  1.00 20.00           H
ATOM    250  HD1 TRP A  18      14.230  23.354  17.879  1.00 20.00           H
ATOM    251  HE1 TRP A  18      11.647  23.489  17.867  1.00 20.00           H
ATOM    252  HE3 TRP A  18      13.224  18.350  17.637  1.00 20.00           H
ATOM    253  HZ2 TRP A  18       9.502  21.671  17.766  1.00 20.00           H
ATOM    254  HZ3 TRP A  18      10.870  17.622  17.586  1.00 20.00           H
ATOM    255  HH2 TRP A  18       9.039  19.261  17.649  1.00 20.00           H
ATOM    256  N   MET A  19      15.062  21.106  21.239  1.00 20.00           N
ATOM    257  CA  MET A  19      14.397  20.628  22.441  1.00 20.00           C
ATOM    258  C   MET A  19      12.894  20.867  22.346  1.00 20.00           C
ATOM    259  O   MET A  19      12.401  21.573  21.463  1.00 20.00           O
ATOM    260  CB  MET A  19      14.971  21.320  23.682  1.00 20.00           C
ATOM    261  CG  MET A  19      16.431  20.995  23.957  1.00 20.00           C
ATOM    262  SD  MET A  19      16.715  19.245  24.291  1.00 20.00           S
ATOM    263  CE  MET A  19      15.934  19.073  25.894  1.00 20.00           C
ATOM    264  H   MET A  19      15.230  22.112  21.239  1.00 20.00           H
ATOM    265  HA  MET A  19      14.576  19.557  22.542  1.00 20.00           H
ATOM    266  HB2 MET A  19      14.891  22.399  23.547  1.00 20.00           H
ATOM    267  HB3 MET A  19      14.391  21.015  24.553  1.00 20.00           H
ATOM    268  HG2 MET A  19      17.025  21.271  23.086  1.00 20.00           H
ATOM    269  HG3 MET A  19      16.762  21.561  24.827  1.00 20.00           H
ATOM    270  HE1 MET A  19      16.099  18.060  26.261  1.00 20.00           H
ATOM    271  HE2 MET A  19      16.374  19.795  26.582  1.00 20.00           H
ATOM    272  HE3 MET A  19      14.865  19.261  25.791  1.00 20.00           H
ATOM    273  N   MSE A  20      12.164  20.264  23.279  1.00 20.00           N
ATOM    274  CA  MSE A  20      10.713  20.398  23.320  1.00 20.00           C
ATOM    275  C   MSE A  20      10.310  21.728  23.947  1.00 20.00           C
ATOM    276  O   MSE A  20       9.520  22.480  23.377  1.00 20.00           O
ATOM    277  CB  MSE A  20      10.091  19.239  24.103  1.00 20.00           C
ATOM    278  CG  MSE A  20      10.285  17.875  23.458  1.00 20.00           C
ATOM    279 SE   MSE A  20       9.426  17.722  21.712  1.00 20.00          Se
ATOM    280  CE  MSE A  20       7.564  17.822  22.280  1.00 20.00           C
ATOM    281  H   MSE A  20      12.548  19.676  24.018  1.00 20.00           H
ATOM    282  HA  MSE A  20      10.328  20.362  22.301  1.00 20.00           H
ATOM    283  HB2 MSE A  20      10.543  19.204  25.094  1.00 20.00           H
ATOM    284  HB3 MSE A  20       9.019  19.414  24.194  1.00 20.00           H
ATOM    285  HG2 MSE A  20      11.351  17.695  23.324  1.00 20.00           H
ATOM    286  HG3 MSE A  20       9.858  17.112  24.109  1.00 20.00           H
ATOM    287  HE1 MSE A  20       6.921  17.734  21.405  1.00 20.00           H
ATOM    288  HE2 MSE A  20       7.361  17.007  22.975  1.00 20.00           H
ATOM    289  HE3 MSE A  20       7.394  18.781  22.771  1.00 20.00           H
ATOM    290  N   GLY A  21      10.860  22.012  25.125  1.00 20.00           N
ATOM    291  CA  GLY A  21      10.558  23.246  25.823  1.00 20.00           C
ATOM    292  C   GLY A  21      10.794  23.148  27.316  1.00 20.00           C
ATOM    293  O   GLY A  21      11.205  24.122  27.952  1.00 20.00           O
ATOM    294  H   GLY A  21      11.517  21.406  25.616  1.00 20.00           H
ATOM    295  HA2 GLY A  21      11.182  24.047  25.428  1.00 20.00           H
ATOM    296  HA3 GLY A  21       9.513  23.509  25.657  1.00 20.00           H
ATOM    297  N   MSE A  22      10.537  21.975  27.885  1.00 20.00           N
ATOM    298  CA  MSE A  22      10.726  21.759  29.315  1.00 20.00           C
ATOM    299  C   MSE A  22      12.209  21.661  29.655  1.00 20.00           C
ATOM    300  O   MSE A  22      12.986  21.053  28.919  1.00 20.00           O
ATOM    301  CB  MSE A  22       9.999  20.490  29.765  1.00 20.00           C
ATOM    302  CG  MSE A  22       8.485  20.556  29.628  1.00 20.00           C
ATOM    303 SE   MSE A  22       7.672  21.934  30.744  1.00 20.00          Se
ATOM    304  CE  MSE A  22       8.049  21.167  32.497  1.00 20.00           C
ATOM    305  H   MSE A  22      10.197  21.154  27.384  1.00 20.00           H
ATOM    306  HA  MSE A  22      10.299  22.603  29.856  1.00 20.00           H
ATOM    307  HB2 MSE A  22      10.350  19.653  29.161  1.00 20.00           H
ATOM    308  HB3 MSE A  22      10.230  20.309  30.815  1.00 20.00           H
ATOM    309  HG2 MSE A  22       8.233  20.773  28.590  1.00 20.00           H
ATOM    310  HG3 MSE A  22       8.061  19.595  29.920  1.00 20.00           H
ATOM    311  HE1 MSE A  22       7.637  21.820  33.266  1.00 20.00           H
ATOM    312  HE2 MSE A  22       7.588  20.181  32.558  1.00 20.00           H
ATOM    313  HE3 MSE A  22       9.129  21.081  32.621  1.00 20.00           H
ATOM    314  N   GLY A  23      12.595  22.265  30.778  1.00 20.00           N
ATOM    315  CA  GLY A  23      13.970  22.254  31.225  1.00 20.00           C
ATOM    316  C   GLY A  23      14.298  21.022  32.047  1.00 20.00           C
ATOM    317  O   GLY A  23      13.564  20.032  32.071  1.00 20.00           O
ATOM    318  H   GLY A  23      11.965  22.772  31.399  1.00 20.00           H
ATOM    319  HA2 GLY A  23      14.634  22.281  30.361  1.00 20.00           H
ATOM    320  HA3 GLY A  23      14.161  23.137  31.836  1.00 20.00           H
ATOM    321  N   GLY A  24      15.435  21.095  32.734  1.00 20.00           N
ATOM    322  CA  GLY A  24      15.881  19.996  33.565  1.00 20.00           C
ATOM    323  C   GLY A  24      16.563  18.874  32.819  1.00 20.00           C
ATOM    324  O   GLY A  24      16.588  17.743  33.313  1.00 20.00           O
ATOM    325  H   GLY A  24      16.062  21.900  32.732  1.00 20.00           H
ATOM    326  HA2 GLY A  24      16.579  20.376  34.311  1.00 20.00           H
ATOM    327  HA3 GLY A  24      15.022  19.577  34.089  1.00 20.00           H
ATOM    328  N   ILE A  25      17.119  19.149  31.641  1.00 20.00           N
ATOM    329  CA  ILE A  25      17.807  18.148  30.830  1.00 20.00           C
ATOM    330  C   ILE A  25      19.181  18.719  30.504  1.00 20.00           C
ATOM    331  O   ILE A  25      19.335  19.470  29.534  1.00 20.00           O
ATOM    332  CB  ILE A  25      17.035  17.796  29.554  1.00 20.00           C
ATOM    333  CG1 ILE A  25      15.678  17.182  29.907  1.00 20.00           C
ATOM    334  CG2 ILE A  25      17.845  16.836  28.691  1.00 20.00           C
ATOM    335  CD1 ILE A  25      14.723  17.089  28.735  1.00 20.00           C
ATOM    336  H   ILE A  25      17.109  20.076  31.215  1.00 20.00           H
ATOM    337  HA  ILE A  25      17.942  17.236  31.412  1.00 20.00           H
ATOM    338  HB  ILE A  25      16.865  18.712  28.988  1.00 20.00           H
ATOM    339 HG12 ILE A  25      15.838  16.173  30.287  1.00 20.00           H
ATOM    340 HG13 ILE A  25      15.202  17.794  30.673  1.00 20.00           H
ATOM    341 HG21 ILE A  25      17.221  16.480  27.872  1.00 20.00           H
ATOM    342 HG22 ILE A  25      18.713  17.359  28.291  1.00 20.00           H
ATOM    343 HG23 ILE A  25      18.166  15.994  29.305  1.00 20.00           H
ATOM    344 HD11 ILE A  25      13.735  16.813  29.104  1.00 20.00           H
ATOM    345 HD12 ILE A  25      14.676  18.058  28.238  1.00 20.00           H
ATOM    346 HD13 ILE A  25      15.085  16.332  28.039  1.00 20.00           H
ATOM    347  N   LYS A  26      20.180  18.367  31.306  1.00 20.00           N
ATOM    348  CA  LYS A  26      21.539  18.844  31.101  1.00 20.00           C
ATOM    349  C   LYS A  26      22.269  17.958  30.100  1.00 20.00           C
ATOM    350  O   LYS A  26      22.061  16.743  30.046  1.00 20.00           O
ATOM    351  CB  LYS A  26      22.305  18.875  32.424  1.00 20.00           C
ATOM    352  CG  LYS A  26      21.795  19.914  33.410  1.00 20.00           C
ATOM    353  CD  LYS A  26      22.615  19.915  34.690  1.00 20.00           C
ATOM    354  CE  LYS A  26      22.091  20.938  35.685  1.00 20.00           C
ATOM    355  NZ  LYS A  26      22.877  20.943  36.949  1.00 20.00           N
ATOM    356  H   LYS A  26      20.078  17.749  32.111  1.00 20.00           H
ATOM    357  HA  LYS A  26      21.507  19.858  30.701  1.00 20.00           H
ATOM    358  HB2 LYS A  26      22.224  17.898  32.899  1.00 20.00           H
ATOM    359  HB3 LYS A  26      23.352  19.099  32.217  1.00 20.00           H
ATOM    360  HG2 LYS A  26      21.865  20.903  32.958  1.00 20.00           H
ATOM    361  HG3 LYS A  26      20.760  19.688  33.667  1.00 20.00           H
ATOM    362  HD2 LYS A  26      22.561  18.930  35.153  1.00 20.00           H
ATOM    363  HD3 LYS A  26      23.649  20.166  34.455  1.00 20.00           H
ATOM    364  HE2 LYS A  26      22.154  21.932  35.242  1.00 20.00           H
ATOM    365  HE3 LYS A  26      21.056  20.701  35.929  1.00 20.00           H
ATOM    366  HZ1 LYS A  26      22.492  21.652  37.604  1.00 20.00           H
ATOM    367  HZ2 LYS A  26      22.831  20.006  37.399  1.00 20.00           H
ATOM    368  HZ3 LYS A  26      23.872  21.173  36.748  1.00 20.00           H
ATOM    369  N   LYS A  27      23.132  18.583  29.303  1.00 20.00           N
ATOM    370  CA  LYS A  27      23.908  17.877  28.295  1.00 20.00           C
ATOM    371  C   LYS A  27      25.290  18.506  28.197  1.00 20.00           C
ATOM    372  O   LYS A  27      25.494  19.669  28.555  1.00 20.00           O
ATOM    373  CB  LYS A  27      23.215  17.905  26.926  1.00 20.00           C
ATOM    374  CG  LYS A  27      21.922  17.106  26.872  1.00 20.00           C
ATOM    375  CD  LYS A  27      21.303  17.144  25.484  1.00 20.00           C
ATOM    376  CE  LYS A  27      19.997  16.368  25.437  1.00 20.00           C
ATOM    377  NZ  LYS A  27      19.371  16.406  24.087  1.00 20.00           N
ATOM    378  H   LYS A  27      23.315  19.587  29.333  1.00 20.00           H
ATOM    379  HA  LYS A  27      24.027  16.836  28.597  1.00 20.00           H
ATOM    380  HB2 LYS A  27      22.978  18.938  26.674  1.00 20.00           H
ATOM    381  HB3 LYS A  27      23.894  17.489  26.181  1.00 20.00           H
ATOM    382  HG2 LYS A  27      22.130  16.067  27.125  1.00 20.00           H
ATOM    383  HG3 LYS A  27      21.207  17.531  27.576  1.00 20.00           H
ATOM    384  HD2 LYS A  27      21.096  18.179  25.210  1.00 20.00           H
ATOM    385  HD3 LYS A  27      21.993  16.695  24.770  1.00 20.00           H
ATOM    386  HE2 LYS A  27      20.191  15.326  25.693  1.00 20.00           H
ATOM    387  HE3 LYS A  27      19.296  16.804  26.149  1.00 20.00           H
ATOM    388  HZ1 LYS A  27      18.478  15.873  24.094  1.00 20.00           H
ATOM    389  HZ2 LYS A  27      19.176  17.390  23.813  1.00 20.00           H
ATOM    390  HZ3 LYS A  27      20.012  15.981  23.386  1.00 20.00           H
ATOM    391  N   MET A  28      26.243  17.716  27.705  1.00 20.00           N
ATOM    392  CA  MET A  28      27.621  18.159  27.547  1.00 20.00           C
ATOM    393  C   MET A  28      28.151  17.636  26.219  1.00 20.00           C
ATOM    394  O   MET A  28      27.450  16.946  25.472  1.00 20.00           O
ATOM    395  CB  MET A  28      28.492  17.684  28.716  1.00 20.00           C
ATOM    396  CG  MET A  28      28.104  18.277  30.062  1.00 20.00           C
ATOM    397  SD  MET A  28      28.267  20.072  30.118  1.00 20.00           S
ATOM    398  CE  MET A  28      30.048  20.255  30.079  1.00 20.00           C
ATOM    399  H   MET A  28      26.087  16.754  27.405  1.00 20.00           H
ATOM    400  HA  MET A  28      27.644  19.249  27.530  1.00 20.00           H
ATOM    401  HB2 MET A  28      28.409  16.600  28.796  1.00 20.00           H
ATOM    402  HB3 MET A  28      29.527  17.960  28.517  1.00 20.00           H
ATOM    403  HG2 MET A  28      27.064  18.027  30.273  1.00 20.00           H
ATOM    404  HG3 MET A  28      28.750  17.858  30.833  1.00 20.00           H
ATOM    405  HE1 MET A  28      30.298  21.312  30.179  1.00 20.00           H
ATOM    406  HE2 MET A  28      30.480  19.691  30.906  1.00 20.00           H
ATOM    407  HE3 MET A  28      30.424  19.872  29.131  1.00 20.00           H
ATOM    408  N   LYS A  29      29.407  17.972  25.924  1.00 20.00           N
ATOM    409  CA  LYS A  29      30.063  17.547  24.686  1.00 20.00           C
ATOM    410  C   LYS A  29      31.474  17.091  25.043  1.00 20.00           C
ATOM    411  O   LYS A  29      32.372  17.918  25.228  1.00 20.00           O
ATOM    412  CB  LYS A  29      30.085  18.673  23.658  1.00 20.00           C
ATOM    413  CG  LYS A  29      28.714  19.047  23.121  1.00 20.00           C
ATOM    414  CD  LYS A  29      28.806  20.154  22.083  1.00 20.00           C
ATOM    415  CE  LYS A  29      27.432  20.544  21.562  1.00 20.00           C
ATOM    416  NZ  LYS A  29      27.506  21.636  20.553  1.00 20.00           N
ATOM    417  H   LYS A  29      30.001  18.541  26.527  1.00 20.00           H
ATOM    418  HA  LYS A  29      29.524  16.701  24.259  1.00 20.00           H
ATOM    419  HB2 LYS A  29      30.515  19.561  24.121  1.00 20.00           H
ATOM    420  HB3 LYS A  29      30.700  18.363  22.813  1.00 20.00           H
ATOM    421  HG2 LYS A  29      28.261  18.174  22.651  1.00 20.00           H
ATOM    422  HG3 LYS A  29      28.090  19.400  23.942  1.00 20.00           H
ATOM    423  HD2 LYS A  29      29.263  21.034  22.535  1.00 20.00           H
ATOM    424  HD3 LYS A  29      29.405  19.808  21.241  1.00 20.00           H
ATOM    425  HE2 LYS A  29      26.969  19.677  21.091  1.00 20.00           H
ATOM    426  HE3 LYS A  29      26.820  20.891  22.394  1.00 20.00           H
ATOM    427  HZ1 LYS A  29      26.551  21.877  20.220  1.00 20.00           H
ATOM    428  HZ2 LYS A  29      27.940  22.482  20.976  1.00 20.00           H
ATOM    429  HZ3 LYS A  29      28.081  21.332  19.742  1.00 20.00           H
ATOM    430  N   GLY A  30      31.663  15.779  25.137  1.00 20.00           N
ATOM    431  CA  GLY A  30      32.961  15.234  25.472  1.00 20.00           C
ATOM    432  C   GLY A  30      33.959  15.381  24.338  1.00 20.00           C
ATOM    433  O   GLY A  30      33.640  15.794  23.222  1.00 20.00           O
ATOM    434  H   GLY A  30      30.939  15.077  24.987  1.00 20.00           H
ATOM    435  HA2 GLY A  30      33.356  15.748  26.348  1.00 20.00           H
ATOM    436  HA3 GLY A  30      32.860  14.175  25.708  1.00 20.00           H
ATOM    437  N   TRP A  31      35.204  15.028  24.644  1.00 20.00           N
ATOM    438  CA  TRP A  31      36.278  15.111  23.666  1.00 20.00           C
ATOM    439  C   TRP A  31      36.183  13.959  22.673  1.00 20.00           C
ATOM    440  O   TRP A  31      35.806  12.840  23.031  1.00 20.00           O
ATOM    441  CB  TRP A  31      37.638  15.087  24.364  1.00 20.00           C
ATOM    442  CG  TRP A  31      37.908  16.308  25.190  1.00 20.00           C
ATOM    443  CD1 TRP A  31      37.729  16.442  26.535  1.00 20.00           C
ATOM    444  CD2 TRP A  31      38.405  17.568  24.723  1.00 20.00           C
ATOM    445  NE1 TRP A  31      38.084  17.708  26.936  1.00 20.00           N
ATOM    446  CE2 TRP A  31      38.503  18.418  25.842  1.00 20.00           C
ATOM    447  CE3 TRP A  31      38.778  18.059  23.468  1.00 20.00           C
ATOM    448  CZ2 TRP A  31      38.957  19.732  25.744  1.00 20.00           C
ATOM    449  CZ3 TRP A  31      39.228  19.364  23.373  1.00 20.00           C
ATOM    450  CH2 TRP A  31      39.314  20.185  24.504  1.00 20.00           C
ATOM    451  H   TRP A  31      35.498  14.683  25.558  1.00 20.00           H
ATOM    452  HA  TRP A  31      36.192  16.047  23.114  1.00 20.00           H
ATOM    453  HB2 TRP A  31      37.680  14.221  25.024  1.00 20.00           H
ATOM    454  HB3 TRP A  31      38.421  15.016  23.608  1.00 20.00           H
ATOM    455  HD1 TRP A  31      37.362  15.667  27.191  1.00 20.00           H
ATOM    456  HE1 TRP A  31      38.043  18.060  27.892  1.00 20.00           H
ATOM    457  HE3 TRP A  31      38.715  17.433  22.590  1.00 20.00           H
ATOM    458  HZ2 TRP A  31      39.025  20.368  26.614  1.00 20.00           H
ATOM    459  HZ3 TRP A  31      39.519  19.756  22.409  1.00 20.00           H
ATOM    460  HH2 TRP A  31      39.670  21.198  24.394  1.00 20.00           H
ATOM    461  N   GLY A  32      36.527  14.242  21.422  1.00 20.00           N
ATOM    462  CA  GLY A  32      36.470  13.212  20.397  1.00 20.00           C
ATOM    463  C   GLY A  32      35.033  12.832  20.097  1.00 20.00           C
ATOM    464  O   GLY A  32      34.158  13.692  19.945  1.00 20.00           O
ATOM    465  H   GLY A  32      36.844  15.154  21.093  1.00 20.00           H
ATOM    466  HA2 GLY A  32      36.936  13.575  19.481  1.00 20.00           H
ATOM    467  HA3 GLY A  32      37.004  12.324  20.735  1.00 20.00           H
ATOM    468  N   GLY A  33      34.781  11.528  20.010  1.00 20.00           N
ATOM    469  CA  GLY A  33      33.449  11.031  19.728  1.00 20.00           C
ATOM    470  C   GLY A  33      32.681  10.661  20.979  1.00 20.00           C
ATOM    471  O   GLY A  33      31.733   9.872  20.923  1.00 20.00           O
ATOM    472  H   GLY A  33      35.481  10.797  20.131  1.00 20.00           H
ATOM    473  HA2 GLY A  33      32.884  11.792  19.190  1.00 20.00           H
ATOM    474  HA3 GLY A  33      33.521  10.146  19.096  1.00 20.00           H
ATOM    475  N   MSE A  34      33.080  11.225  22.115  1.00 20.00           N
ATOM    476  CA  MSE A  34      32.417  10.946  23.383  1.00 20.00           C
ATOM    477  C   MSE A  34      31.285  11.937  23.631  1.00 20.00           C
ATOM    478  O   MSE A  34      31.515  13.142  23.733  1.00 20.00           O
ATOM    479  CB  MSE A  34      33.423  10.999  24.536  1.00 20.00           C
ATOM    480  CG  MSE A  34      34.502   9.928  24.471  1.00 20.00           C
ATOM    481 SE   MSE A  34      33.793   8.115  24.602  1.00 20.00          Se
ATOM    482  CE  MSE A  34      33.156   8.170  26.444  1.00 20.00           C
ATOM    483  H   MSE A  34      33.858  11.879  22.191  1.00 20.00           H
ATOM    484  HA  MSE A  34      31.998   9.940  23.348  1.00 20.00           H
ATOM    485  HB2 MSE A  34      33.917  11.970  24.524  1.00 20.00           H
ATOM    486  HB3 MSE A  34      32.885  10.872  25.475  1.00 20.00           H
ATOM    487  HG2 MSE A  34      35.030  10.015  23.522  1.00 20.00           H
ATOM    488  HG3 MSE A  34      35.197  10.077  25.298  1.00 20.00           H
ATOM    489  HE1 MSE A  34      32.729   7.201  26.700  1.00 20.00           H
ATOM    490  HE2 MSE A  34      33.995   8.393  27.103  1.00 20.00           H
ATOM    491  HE3 MSE A  34      32.396   8.947  26.533  1.00 20.00           H
ATOM    492  N   ILE A  35      30.062  11.421  23.725  1.00 20.00           N
ATOM    493  CA  ILE A  35      28.875  12.234  23.958  1.00 20.00           C
ATOM    494  C   ILE A  35      28.143  11.659  25.162  1.00 20.00           C
ATOM    495  O   ILE A  35      27.606  10.546  25.092  1.00 20.00           O
ATOM    496  CB  ILE A  35      27.950  12.273  22.730  1.00 20.00           C
ATOM    497  CG1 ILE A  35      28.670  12.920  21.544  1.00 20.00           C
ATOM    498  CG2 ILE A  35      26.668  13.030  23.053  1.00 20.00           C
ATOM    499  CD1 ILE A  35      27.968  12.721  20.216  1.00 20.00           C
ATOM    500  H   ILE A  35      29.861  10.424  23.643  1.00 20.00           H
ATOM    501  HA  ILE A  35      29.173  13.256  24.195  1.00 20.00           H
ATOM    502  HB  ILE A  35      27.689  11.249  22.460  1.00 20.00           H
ATOM    503 HG12 ILE A  35      28.746  13.993  21.723  1.00 20.00           H
ATOM    504 HG13 ILE A  35      29.668  12.489  21.458  1.00 20.00           H
ATOM    505 HG21 ILE A  35      26.114  13.203  22.130  1.00 20.00           H
ATOM    506 HG22 ILE A  35      26.064  12.436  23.738  1.00 20.00           H
ATOM    507 HG23 ILE A  35      26.927  13.984  23.513  1.00 20.00           H
ATOM    508 HD11 ILE A  35      28.630  13.047  19.414  1.00 20.00           H
ATOM    509 HD12 ILE A  35      27.730  11.664  20.097  1.00 20.00           H
ATOM    510 HD13 ILE A  35      27.053  13.312  20.205  1.00 20.00           H
ATOM    511  N   SER A  36      28.121  12.410  26.259  1.00 20.00           N
ATOM    512  CA  SER A  36      27.448  11.965  27.467  1.00 20.00           C
ATOM    513  C   SER A  36      25.941  12.179  27.351  1.00 20.00           C
ATOM    514  O   SER A  36      25.454  12.930  26.502  1.00 20.00           O
ATOM    515  CB  SER A  36      27.990  12.708  28.688  1.00 20.00           C
ATOM    516  OG  SER A  36      27.677  14.089  28.626  1.00 20.00           O
ATOM    517  H   SER A  36      28.560  13.327  26.339  1.00 20.00           H
ATOM    518  HA  SER A  36      27.631  10.900  27.608  1.00 20.00           H
ATOM    519  HB2 SER A  36      27.543  12.284  29.588  1.00 20.00           H
ATOM    520  HB3 SER A  36      29.074  12.592  28.721  1.00 20.00           H
ATOM    521  HG  SER A  36      28.038  14.550  29.411  1.00 20.00           H
ATOM    522  N   TRP A  37      25.202  11.502  28.227  1.00 20.00           N
ATOM    523  CA  TRP A  37      23.750  11.593  28.250  1.00 20.00           C
ATOM    524  C   TRP A  37      23.265  11.515  29.690  1.00 20.00           C
ATOM    525  O   TRP A  37      23.849  10.817  30.522  1.00 20.00           O
ATOM    526  CB  TRP A  37      23.101  10.479  27.418  1.00 20.00           C
ATOM    527  CG  TRP A  37      23.344  10.612  25.946  1.00 20.00           C
ATOM    528  CD1 TRP A  37      24.302   9.975  25.212  1.00 20.00           C
ATOM    529  CD2 TRP A  37      22.617  11.436  25.026  1.00 20.00           C
ATOM    530  NE1 TRP A  37      24.216  10.351  23.893  1.00 20.00           N
ATOM    531  CE2 TRP A  37      23.190  11.247  23.753  1.00 20.00           C
ATOM    532  CE3 TRP A  37      21.537  12.315  25.156  1.00 20.00           C
ATOM    533  CZ2 TRP A  37      22.719  11.904  22.618  1.00 20.00           C
ATOM    534  CZ3 TRP A  37      21.071  12.966  24.028  1.00 20.00           C
ATOM    535  CH2 TRP A  37      21.662  12.757  22.776  1.00 20.00           C
ATOM    536  H   TRP A  37      25.585  10.878  28.937  1.00 20.00           H
ATOM    537  HA  TRP A  37      23.442  12.553  27.837  1.00 20.00           H
ATOM    538  HB2 TRP A  37      23.506   9.519  27.737  1.00 20.00           H
ATOM    539  HB3 TRP A  37      22.023  10.499  27.581  1.00 20.00           H
ATOM    540  HD1 TRP A  37      25.024   9.277  25.610  1.00 20.00           H
ATOM    541  HE1 TRP A  37      24.819  10.017  23.141  1.00 20.00           H
ATOM    542  HE3 TRP A  37      21.075  12.481  26.118  1.00 20.00           H
ATOM    543  HZ2 TRP A  37      23.172  11.745  21.650  1.00 20.00           H
ATOM    544  HZ3 TRP A  37      20.237  13.647  24.114  1.00 20.00           H
ATOM    545  HH2 TRP A  37      21.274  13.281  21.915  1.00 20.00           H
ATOM    546  N   SER A  38      22.186  12.244  29.974  1.00 20.00           N
ATOM    547  CA  SER A  38      21.610  12.264  31.313  1.00 20.00           C
ATOM    548  C   SER A  38      20.202  12.845  31.281  1.00 20.00           C
ATOM    549  O   SER A  38      19.971  13.896  30.674  1.00 20.00           O
ATOM    550  CB  SER A  38      22.497  13.069  32.265  1.00 20.00           C
ATOM    551  OG  SER A  38      22.538  14.436  31.893  1.00 20.00           O
ATOM    552  H   SER A  38      21.692  12.828  29.300  1.00 20.00           H
ATOM    553  HA  SER A  38      21.547  11.243  31.690  1.00 20.00           H
ATOM    554  HB2 SER A  38      22.096  12.989  33.275  1.00 20.00           H
ATOM    555  HB3 SER A  38      23.509  12.664  32.234  1.00 20.00           H
ATOM    556  HG  SER A  38      21.645  14.832  31.968  1.00 20.00           H
ATOM    557  N   TRP A  39      19.257  12.170  31.931  1.00 20.00           N
ATOM    558  CA  TRP A  39      17.876  12.624  31.967  1.00 20.00           C
ATOM    559  C   TRP A  39      17.248  12.183  33.281  1.00 20.00           C
ATOM    560  O   TRP A  39      17.810  11.375  34.024  1.00 20.00           O
ATOM    561  CB  TRP A  39      17.079  12.086  30.774  1.00 20.00           C
ATOM    562  CG  TRP A  39      17.026  10.590  30.714  1.00 20.00           C
ATOM    563  CD1 TRP A  39      16.105   9.777  31.309  1.00 20.00           C
ATOM    564  CD2 TRP A  39      17.934   9.725  30.019  1.00 20.00           C
ATOM    565  NE1 TRP A  39      16.383   8.461  31.028  1.00 20.00           N
ATOM    566  CE2 TRP A  39      17.501   8.403  30.238  1.00 20.00           C
ATOM    567  CE3 TRP A  39      19.071   9.942  29.234  1.00 20.00           C
ATOM    568  CZ2 TRP A  39      18.164   7.301  29.701  1.00 20.00           C
ATOM    569  CZ3 TRP A  39      19.728   8.847  28.702  1.00 20.00           C
ATOM    570  CH2 TRP A  39      19.272   7.544  28.937  1.00 20.00           C
ATOM    571  H   TRP A  39      19.421  11.302  32.442  1.00 20.00           H
ATOM    572  HA  TRP A  39      17.855  13.714  31.928  1.00 20.00           H
ATOM    573  HB2 TRP A  39      16.055  12.454  30.839  1.00 20.00           H
ATOM    574  HB3 TRP A  39      17.541  12.441  29.853  1.00 20.00           H
ATOM    575  HD1 TRP A  39      15.278  10.119  31.913  1.00 20.00           H
ATOM    576  HE1 TRP A  39      15.845   7.659  31.355  1.00 20.00           H
ATOM    577  HE3 TRP A  39      19.429  10.944  29.048  1.00 20.00           H
ATOM    578  HZ2 TRP A  39      17.816   6.295  29.880  1.00 20.00           H
ATOM    579  HZ3 TRP A  39      20.607   9.000  28.093  1.00 20.00           H
ATOM    580  HH2 TRP A  39      19.809   6.712  28.506  1.00 20.00           H
ATOM    581  N   SER A  40      16.065  12.728  33.560  1.00 20.00           N
ATOM    582  CA  SER A  40      15.343  12.397  34.787  1.00 20.00           C
ATOM    583  C   SER A  40      13.867  12.690  34.557  1.00 20.00           C
ATOM    584  O   SER A  40      13.468  13.858  34.519  1.00 20.00           O
ATOM    585  CB  SER A  40      15.886  13.193  35.968  1.00 20.00           C
ATOM    586  OG  SER A  40      17.231  12.842  36.244  1.00 20.00           O
ATOM    587  H   SER A  40      15.583  13.398  32.961  1.00 20.00           H
ATOM    588  HA  SER A  40      15.457  11.335  35.003  1.00 20.00           H
ATOM    589  HB2 SER A  40      15.839  14.256  35.731  1.00 20.00           H
ATOM    590  HB3 SER A  40      15.278  12.980  36.848  1.00 20.00           H
ATOM    591  HG  SER A  40      17.561  13.354  37.012  1.00 20.00           H
ATOM    592  N   SER A  41      13.066  11.636  34.406  1.00 20.00           N
ATOM    593  CA  SER A  41      11.629  11.765  34.175  1.00 20.00           C
ATOM    594  C   SER A  41      11.356  12.569  32.902  1.00 20.00           C
ATOM    595  O   SER A  41      10.655  13.583  32.906  1.00 20.00           O
ATOM    596  CB  SER A  41      10.939  12.400  35.388  1.00 20.00           C
ATOM    597  OG  SER A  41      11.340  13.748  35.559  1.00 20.00           O
ATOM    598  H   SER A  41      13.388  10.668  34.438  1.00 20.00           H
ATOM    599  HA  SER A  41      11.206  10.770  34.036  1.00 20.00           H
ATOM    600  HB2 SER A  41       9.860  12.368  35.238  1.00 20.00           H
ATOM    601  HB3 SER A  41      11.206  11.836  36.282  1.00 20.00           H
ATOM    602  HG  SER A  41      11.063  14.282  34.785  1.00 20.00           H
ATOM    603  N   SER A  42      11.930  12.091  31.803  1.00 20.00           N
ATOM    604  CA  SER A  42      11.785  12.719  30.500  1.00 20.00           C
ATOM    605  C   SER A  42      10.970  11.825  29.573  1.00 20.00           C
ATOM    606  O   SER A  42      10.866  10.612  29.773  1.00 20.00           O
ATOM    607  CB  SER A  42      13.155  13.008  29.876  1.00 20.00           C
ATOM    608  OG  SER A  42      13.844  11.806  29.580  1.00 20.00           O
ATOM    609  H   SER A  42      12.512  11.253  31.786  1.00 20.00           H
ATOM    610  HA  SER A  42      11.256  13.665  30.611  1.00 20.00           H
ATOM    611  HB2 SER A  42      13.012  13.571  28.953  1.00 20.00           H
ATOM    612  HB3 SER A  42      13.748  13.593  30.579  1.00 20.00           H
ATOM    613  HG  SER A  42      13.983  11.289  30.401  1.00 20.00           H
ATOM    614  N   GLY A  43      10.393  12.444  28.553  1.00 20.00           N
ATOM    615  CA  GLY A  43       9.582  11.747  27.573  1.00 20.00           C
ATOM    616  C   GLY A  43      10.398  11.216  26.416  1.00 20.00           C
ATOM    617  O   GLY A  43      11.558  10.820  26.569  1.00 20.00           O
ATOM    618  H   GLY A  43      10.472  13.445  28.377  1.00 20.00           H
ATOM    619  HA2 GLY A  43       9.075  10.909  28.052  1.00 20.00           H
ATOM    620  HA3 GLY A  43       8.826  12.427  27.179  1.00 20.00           H
ATOM    621  N   LYS A  44       9.781  11.206  25.238  1.00 20.00           N
ATOM    622  CA  LYS A  44      10.456  10.720  24.044  1.00 20.00           C
ATOM    623  C   LYS A  44      11.490  11.732  23.568  1.00 20.00           C
ATOM    624  O   LYS A  44      11.233  12.939  23.529  1.00 20.00           O
ATOM    625  CB  LYS A  44       9.441  10.447  22.935  1.00 20.00           C
ATOM    626  CG  LYS A  44       8.511   9.279  23.222  1.00 20.00           C
ATOM    627  CD  LYS A  44       7.548   9.038  22.070  1.00 20.00           C
ATOM    628  CE  LYS A  44       6.605   7.883  22.366  1.00 20.00           C
ATOM    629  NZ  LYS A  44       5.648   7.642  21.251  1.00 20.00           N
ATOM    630  H   LYS A  44       8.825  11.525  25.081  1.00 20.00           H
ATOM    631  HA  LYS A  44      10.970   9.787  24.275  1.00 20.00           H
ATOM    632  HB2 LYS A  44       8.825  11.335  22.796  1.00 20.00           H
ATOM    633  HB3 LYS A  44       9.979  10.224  22.014  1.00 20.00           H
ATOM    634  HG2 LYS A  44       9.103   8.375  23.368  1.00 20.00           H
ATOM    635  HG3 LYS A  44       7.926   9.496  24.116  1.00 20.00           H
ATOM    636  HD2 LYS A  44       6.951   9.935  21.907  1.00 20.00           H
ATOM    637  HD3 LYS A  44       8.116   8.794  21.172  1.00 20.00           H
ATOM    638  HE2 LYS A  44       7.188   6.975  22.516  1.00 20.00           H
ATOM    639  HE3 LYS A  44       6.030   8.113  23.263  1.00 20.00           H
ATOM    640  HZ1 LYS A  44       5.020   6.848  21.488  1.00 20.00           H
ATOM    641  HZ2 LYS A  44       5.072   8.492  21.087  1.00 20.00           H
ATOM    642  HZ3 LYS A  44       6.169   7.413  20.380  1.00 20.00           H
ATOM    643  N   MSE A  45      12.667  11.232  23.205  1.00 20.00           N
ATOM    644  CA  MSE A  45      13.750  12.084  22.728  1.00 20.00           C
ATOM    645  C   MSE A  45      14.469  11.434  21.550  1.00 20.00           C
ATOM    646  O   MSE A  45      14.707  10.226  21.546  1.00 20.00           O
ATOM    647  CB  MSE A  45      14.744  12.369  23.856  1.00 20.00           C
ATOM    648  CG  MSE A  45      14.167  13.178  25.008  1.00 20.00           C
ATOM    649 SE   MSE A  45      13.587  14.964  24.478  1.00 20.00          Se
ATOM    650  CE  MSE A  45      15.328  15.736  24.058  1.00 20.00           C
ATOM    651  H   MSE A  45      12.902  10.240  23.230  1.00 20.00           H
ATOM    652  HA  MSE A  45      13.333  13.034  22.397  1.00 20.00           H
ATOM    653  HB2 MSE A  45      15.095  11.420  24.260  1.00 20.00           H
ATOM    654  HB3 MSE A  45      15.586  12.928  23.447  1.00 20.00           H
ATOM    655  HG2 MSE A  45      13.304  12.651  25.413  1.00 20.00           H
ATOM    656  HG3 MSE A  45      14.930  13.289  25.779  1.00 20.00           H
ATOM    657  HE1 MSE A  45      15.191  16.772  23.748  1.00 20.00           H
ATOM    658  HE2 MSE A  45      15.958  15.694  24.947  1.00 20.00           H
ATOM    659  HE3 MSE A  45      15.785  15.164  23.251  1.00 20.00           H
ATOM    660  N   TRP A  46      14.811  12.244  20.551  1.00 20.00           N
ATOM    661  CA  TRP A  46      15.502  11.764  19.364  1.00 20.00           C
ATOM    662  C   TRP A  46      16.489  12.822  18.896  1.00 20.00           C
ATOM    663  O   TRP A  46      16.250  14.024  19.038  1.00 20.00           O
ATOM    664  CB  TRP A  46      14.519  11.428  18.235  1.00 20.00           C
ATOM    665  CG  TRP A  46      13.649  10.245  18.531  1.00 20.00           C
ATOM    666  CD1 TRP A  46      12.374  10.266  19.017  1.00 20.00           C
ATOM    667  CD2 TRP A  46      13.990   8.864  18.360  1.00 20.00           C
ATOM    668  NE1 TRP A  46      11.901   8.984  19.159  1.00 20.00           N
ATOM    669  CE2 TRP A  46      12.874   8.105  18.762  1.00 20.00           C
ATOM    670  CE3 TRP A  46      15.132   8.196  17.905  1.00 20.00           C
ATOM    671  CZ2 TRP A  46      12.865   6.712  18.724  1.00 20.00           C
ATOM    672  CZ3 TRP A  46      15.121   6.813  17.868  1.00 20.00           C
ATOM    673  CH2 TRP A  46      13.995   6.086  18.275  1.00 20.00           C
ATOM    674  H   TRP A  46      14.620  13.246  20.538  1.00 20.00           H
ATOM    675  HA  TRP A  46      16.061  10.862  19.612  1.00 20.00           H
ATOM    676  HB2 TRP A  46      13.869  12.287  18.067  1.00 20.00           H
ATOM    677  HB3 TRP A  46      15.084  11.209  17.329  1.00 20.00           H
ATOM    678  HD1 TRP A  46      11.818  11.160  19.255  1.00 20.00           H
ATOM    679  HE1 TRP A  46      10.975   8.728  19.504  1.00 20.00           H
ATOM    680  HE3 TRP A  46      16.004   8.749  17.590  1.00 20.00           H
ATOM    681  HZ2 TRP A  46      11.999   6.148  19.037  1.00 20.00           H
ATOM    682  HZ3 TRP A  46      15.996   6.285  17.519  1.00 20.00           H
ATOM    683  HH2 TRP A  46      14.020   5.008  18.234  1.00 20.00           H
ATOM    684  N   GLY A  47      17.599  12.364  18.338  1.00 20.00           N
ATOM    685  CA  GLY A  47      18.624  13.262  17.848  1.00 20.00           C
ATOM    686  C   GLY A  47      19.960  12.565  17.762  1.00 20.00           C
ATOM    687  O   GLY A  47      20.127  11.422  18.188  1.00 20.00           O
ATOM    688  H   GLY A  47      17.815  11.375  18.212  1.00 20.00           H
ATOM    689  HA2 GLY A  47      18.353  13.624  16.856  1.00 20.00           H
ATOM    690  HA3 GLY A  47      18.717  14.116  18.519  1.00 20.00           H
ATOM    691  N   GLY A  48      20.923  13.285  17.193  1.00 20.00           N
ATOM    692  CA  GLY A  48      22.265  12.761  17.033  1.00 20.00           C
ATOM    693  C   GLY A  48      23.140  13.642  16.167  1.00 20.00           C
ATOM    694  O   GLY A  48      23.042  14.872  16.221  1.00 20.00           O
ATOM    695  H   GLY A  48      20.801  14.232  16.835  1.00 20.00           H
ATOM    696  HA2 GLY A  48      22.735  12.665  18.012  1.00 20.00           H
ATOM    697  HA3 GLY A  48      22.215  11.772  16.577  1.00 20.00           H
ATOM    698  N   LYS A  49      24.001  13.024  15.362  1.00 20.00           N
ATOM    699  CA  LYS A  49      24.899  13.751  14.478  1.00 20.00           C
ATOM    700  C   LYS A  49      25.048  12.977  13.176  1.00 20.00           C
ATOM    701  O   LYS A  49      24.644  11.816  13.066  1.00 20.00           O
ATOM    702  CB  LYS A  49      26.269  13.976  15.130  1.00 20.00           C
ATOM    703  CG  LYS A  49      26.242  14.927  16.315  1.00 20.00           C
ATOM    704  CD  LYS A  49      27.632  15.134  16.894  1.00 20.00           C
ATOM    705  CE  LYS A  49      27.602  16.069  18.092  1.00 20.00           C
ATOM    706  NZ  LYS A  49      28.956  16.272  18.678  1.00 20.00           N
ATOM    707  H   LYS A  49      24.099  12.010  15.302  1.00 20.00           H
ATOM    708  HA  LYS A  49      24.467  14.725  14.248  1.00 20.00           H
ATOM    709  HB2 LYS A  49      26.651  13.017  15.482  1.00 20.00           H
ATOM    710  HB3 LYS A  49      26.948  14.392  14.385  1.00 20.00           H
ATOM    711  HG2 LYS A  49      25.859  15.895  15.991  1.00 20.00           H
ATOM    712  HG3 LYS A  49      25.605  14.512  17.096  1.00 20.00           H
ATOM    713  HD2 LYS A  49      28.033  14.174  17.219  1.00 20.00           H
ATOM    714  HD3 LYS A  49      28.277  15.575  16.133  1.00 20.00           H
ATOM    715  HE2 LYS A  49      27.218  17.040  17.779  1.00 20.00           H
ATOM    716  HE3 LYS A  49      26.960  15.642  18.862  1.00 20.00           H
ATOM    717  HZ1 LYS A  49      28.898  16.915  19.493  1.00 20.00           H
ATOM    718  HZ2 LYS A  49      29.347  15.361  18.992  1.00 20.00           H
ATOM    719  HZ3 LYS A  49      29.592  16.685  17.966  1.00 20.00           H
ATOM    720  N   GLY A  50      25.635  13.636  12.182  1.00 20.00           N
ATOM    721  CA  GLY A  50      25.845  13.027  10.883  1.00 20.00           C
ATOM    722  C   GLY A  50      26.940  13.709  10.086  1.00 20.00           C
ATOM    723  O   GLY A  50      28.030  13.960  10.599  1.00 20.00           O
ATOM    724  H   GLY A  50      25.976  14.595  12.251  1.00 20.00           H
ATOM    725  HA2 GLY A  50      26.117  11.979  11.013  1.00 20.00           H
ATOM    726  HA3 GLY A  50      24.921  13.073  10.307  1.00 20.00           H
TER
END
"""

pdb_str_poor_1="""\n
CRYST1   41.392   28.519   38.664  90.00  90.00  90.00 P 1
SCALE1      0.024159  0.000000  0.000000        0.00000
SCALE2      0.000000  0.035064  0.000000        0.00000
SCALE3      0.000000  0.000000  0.025864        0.00000
ATOM      1  N   TRP A   2      29.941  24.684  29.674  1.00 20.00           N
ATOM      2  CA  TRP A   2      28.492  24.830  29.738  1.00 20.00           C
ATOM      3  C   TRP A   2      28.020  25.942  28.807  1.00 20.00           C
ATOM      4  O   TRP A   2      27.970  27.109  29.195  1.00 20.00           O
ATOM      5  CB  TRP A   2      28.046  25.121  31.172  1.00 20.00           C
ATOM      6  CG  TRP A   2      28.600  26.400  31.723  1.00 20.00           C
ATOM      7  CD1 TRP A   2      29.777  26.561  32.395  1.00 20.00           C
ATOM      8  CD2 TRP A   2      27.999  27.698  31.652  1.00 20.00           C
ATOM      9  NE1 TRP A   2      29.947  27.877  32.745  1.00 20.00           N
ATOM     10  CE2 TRP A   2      28.869  28.597  32.300  1.00 20.00           C
ATOM     11  CE3 TRP A   2      26.811  28.187  31.102  1.00 20.00           C
ATOM     12  CZ2 TRP A   2      28.587  29.957  32.414  1.00 20.00           C
ATOM     13  CZ3 TRP A   2      26.533  29.538  31.216  1.00 20.00           C
ATOM     14  CH2 TRP A   2      27.417  30.406  31.867  1.00 20.00           C
ATOM     15  HA  TRP A   2      28.024  23.899  29.419  1.00 20.00           H
ATOM     16  HB2 TRP A   2      26.958  25.191  31.196  1.00 20.00           H
ATOM     17  HB3 TRP A   2      28.380  24.308  31.817  1.00 20.00           H
ATOM     18  HD1 TRP A   2      30.475  25.766  32.618  1.00 20.00           H
ATOM     19  HE1 TRP A   2      30.745  28.258  33.254  1.00 20.00           H
ATOM     20  HE3 TRP A   2      26.122  27.524  30.599  1.00 20.00           H
ATOM     21  HZ2 TRP A   2      29.267  30.629  32.916  1.00 20.00           H
ATOM     22  HZ3 TRP A   2      25.618  29.929  30.796  1.00 20.00           H
ATOM     23  HH2 TRP A   2      27.170  31.455  31.938  1.00 20.00           H
ATOM     24  N   ILE A   3      27.674  25.570  27.579  1.00 20.00           N
ATOM     25  CA  ILE A   3      27.205  26.516  26.579  1.00 20.00           C
ATOM     26  C   ILE A   3      25.724  26.260  26.313  1.00 20.00           C
ATOM     27  O   ILE A   3      25.144  25.277  26.774  1.00 20.00           O
ATOM     28  CB  ILE A   3      28.028  26.434  25.277  1.00 20.00           C
ATOM     29  CG1 ILE A   3      27.727  27.633  24.375  1.00 20.00           C
ATOM     30  CG2 ILE A   3      27.734  25.132  24.548  1.00 20.00           C
ATOM     31  CD1 ILE A   3      28.177  28.958  24.952  1.00 20.00           C
ATOM     32  H   ILE A   3      27.708  24.606  27.246  1.00 20.00           H
ATOM     33  HA  ILE A   3      27.304  27.528  26.971  1.00 20.00           H
ATOM     34  HB  ILE A   3      29.086  26.454  25.536  1.00 20.00           H
ATOM     35 HG12 ILE A   3      28.240  27.494  23.423  1.00 20.00           H
ATOM     36 HG13 ILE A   3      26.652  27.696  24.207  1.00 20.00           H
ATOM     37 HG21 ILE A   3      28.327  25.094  23.634  1.00 20.00           H
ATOM     38 HG22 ILE A   3      27.998  24.297  25.196  1.00 20.00           H
ATOM     39 HG23 ILE A   3      26.673  25.094  24.306  1.00 20.00           H
ATOM     40 HD11 ILE A   3      27.926  29.754  24.249  1.00 20.00           H
ATOM     41 HD12 ILE A   3      27.664  29.124  25.899  1.00 20.00           H
ATOM     42 HD13 ILE A   3      29.254  28.930  25.111  1.00 20.00           H
ATOM     43  N   SER A   4      25.113  27.166  25.555  1.00 20.00           N
ATOM     44  CA  SER A   4      23.704  27.047  25.222  1.00 20.00           C
ATOM     45  C   SER A   4      23.503  26.043  24.090  1.00 20.00           C
ATOM     46  O   SER A   4      24.433  25.694  23.357  1.00 20.00           O
ATOM     47  CB  SER A   4      23.130  28.407  24.823  1.00 20.00           C
ATOM     48  OG  SER A   4      23.172  29.316  25.909  1.00 20.00           O
ATOM     49  H   SER A   4      25.567  27.989  25.160  1.00 20.00           H
ATOM     50  HA  SER A   4      23.158  26.689  26.095  1.00 20.00           H
ATOM     51  HB2 SER A   4      23.719  28.812  23.999  1.00 20.00           H
ATOM     52  HB3 SER A   4      22.094  28.276  24.510  1.00 20.00           H
ATOM     53  HG  SER A   4      22.801  30.181  25.635  1.00 20.00           H
ATOM     54  N   LYS A   5      22.264  25.579  23.955  1.00 20.00           N
ATOM     55  CA  LYS A   5      21.908  24.615  22.925  1.00 20.00           C
ATOM     56  C   LYS A   5      21.557  25.335  21.630  1.00 20.00           C
ATOM     57  O   LYS A   5      20.907  26.384  21.643  1.00 20.00           O
ATOM     58  CB  LYS A   5      20.730  23.752  23.378  1.00 20.00           C
ATOM     59  CG  LYS A   5      19.440  24.529  23.588  1.00 20.00           C
ATOM     60  CD  LYS A   5      18.614  24.591  22.313  1.00 20.00           C
ATOM     61  CE  LYS A   5      17.277  25.274  22.551  1.00 20.00           C
ATOM     62  NZ  LYS A   5      16.465  25.361  21.306  1.00 20.00           N
ATOM     63  H   LYS A   5      21.482  25.854  24.549  1.00 20.00           H
ATOM     64  HA  LYS A   5      22.759  23.960  22.733  1.00 20.00           H
ATOM     65  HB2 LYS A   5      20.540  22.992  22.620  1.00 20.00           H
ATOM     66  HB3 LYS A   5      20.988  23.274  24.322  1.00 20.00           H
ATOM     67  HG2 LYS A   5      18.845  24.036  24.357  1.00 20.00           H
ATOM     68  HG3 LYS A   5      19.679  25.548  23.891  1.00 20.00           H
ATOM     69  HD2 LYS A   5      19.159  25.159  21.559  1.00 20.00           H
ATOM     70  HD3 LYS A   5      18.423  23.578  21.959  1.00 20.00           H
ATOM     71  HE2 LYS A   5      16.710  24.703  23.287  1.00 20.00           H
ATOM     72  HE3 LYS A   5      17.452  26.287  22.914  1.00 20.00           H
ATOM     73  HZ1 LYS A   5      15.559  25.832  21.504  1.00 20.00           H
ATOM     74  HZ2 LYS A   5      16.978  25.907  20.584  1.00 20.00           H
ATOM     75  HZ3 LYS A   5      16.276  24.407  20.937  1.00 20.00           H
ATOM     76  N   GLY A   6      21.990  24.766  20.516  1.00 20.00           N
ATOM     77  CA  GLY A   6      21.723  25.351  19.220  1.00 20.00           C
ATOM     78  C   GLY A   6      22.652  24.781  18.170  1.00 20.00           C
ATOM     79  O   GLY A   6      23.528  23.964  18.453  1.00 20.00           O
ATOM     80  H   GLY A   6      22.529  23.900  20.482  1.00 20.00           H
ATOM     81  HA2 GLY A   6      20.693  25.144  18.927  1.00 20.00           H
ATOM     82  HA3 GLY A   6      21.865  26.431  19.266  1.00 20.00           H
ATOM     83  N   CYS A   7      22.436  25.239  16.940  1.00 20.00           N
ATOM     84  CA  CYS A   7      23.239  24.795  15.814  1.00 20.00           C
ATOM     85  C   CYS A   7      24.608  25.471  15.834  1.00 20.00           C
ATOM     86  O   CYS A   7      24.859  26.415  16.588  1.00 20.00           O
ATOM     87  CB  CYS A   7      22.520  25.089  14.498  1.00 20.00           C
ATOM     88  SG  CYS A   7      22.282  26.849  14.158  1.00 20.00           S
ATOM     89  H   CYS A   7      21.713  25.916  16.696  1.00 20.00           H
ATOM     90  HA  CYS A   7      23.390  23.718  15.885  1.00 20.00           H
ATOM     91  HB2 CYS A   7      23.104  24.669  13.679  1.00 20.00           H
ATOM     92  HB3 CYS A   7      21.536  24.620  14.525  1.00 20.00           H
ATOM     93  HG  CYS A   7      21.665  26.981  13.022  1.00 20.00           H
ATOM     94  N   GLY A   8      25.501  24.973  14.988  1.00 20.00           N
ATOM     95  CA  GLY A   8      26.842  25.520  14.903  1.00 20.00           C
ATOM     96  C   GLY A   8      27.774  24.534  14.219  1.00 20.00           C
ATOM     97  O   GLY A   8      27.338  23.669  13.463  1.00 20.00           O
ATOM     98  H   GLY A   8      25.325  24.194  14.354  1.00 20.00           H
ATOM     99  HA2 GLY A   8      26.828  26.447  14.330  1.00 20.00           H
ATOM    100  HA3 GLY A   8      27.221  25.728  15.903  1.00 20.00           H
ATOM    101  N   TYR A   9      29.064  24.694  14.508  1.00 20.00           N
ATOM    102  CA  TYR A   9      30.099  23.839  13.943  1.00 20.00           C
ATOM    103  C   TYR A   9      31.151  23.568  15.006  1.00 20.00           C
ATOM    104  O   TYR A   9      31.586  24.491  15.701  1.00 20.00           O
ATOM    105  CB  TYR A   9      30.744  24.487  12.712  1.00 20.00           C
ATOM    106  CG  TYR A   9      31.477  25.775  13.014  1.00 20.00           C
ATOM    107  CD1 TYR A   9      30.821  26.998  12.962  1.00 20.00           C
ATOM    108  CD2 TYR A   9      32.824  25.768  13.349  1.00 20.00           C
ATOM    109  CE1 TYR A   9      31.487  28.178  13.237  1.00 20.00           C
ATOM    110  CE2 TYR A   9      33.498  26.943  13.624  1.00 20.00           C
ATOM    111  CZ  TYR A   9      32.825  28.144  13.567  1.00 20.00           C
ATOM    112  OH  TYR A   9      33.491  29.317  13.842  1.00 20.00           O
ATOM    113  H   TYR A   9      29.423  25.414  15.135  1.00 20.00           H
ATOM    114  HA  TYR A   9      29.661  22.888  13.642  1.00 20.00           H
ATOM    115  HB2 TYR A   9      31.462  23.788  12.283  1.00 20.00           H
ATOM    116  HB3 TYR A   9      29.965  24.710  11.983  1.00 20.00           H
ATOM    117  HD1 TYR A   9      29.772  27.028  12.704  1.00 20.00           H
ATOM    118  HD2 TYR A   9      33.355  24.829  13.394  1.00 20.00           H
ATOM    119  HE1 TYR A   9      30.961  29.121  13.193  1.00 20.00           H
ATOM    120  HE2 TYR A   9      34.546  26.920  13.883  1.00 20.00           H
ATOM    121  HH  TYR A   9      34.428  29.128  14.057  1.00 20.00           H
ATOM    122  N   CYS A  10      31.557  22.306  15.127  1.00 20.00           N
ATOM    123  CA  CYS A  10      32.560  21.900  16.106  1.00 20.00           C
ATOM    124  C   CYS A  10      33.411  20.798  15.497  1.00 20.00           C
ATOM    125  O   CYS A  10      32.883  19.764  15.078  1.00 20.00           O
ATOM    126  CB  CYS A  10      31.904  21.418  17.404  1.00 20.00           C
ATOM    127  SG  CYS A  10      30.906  19.922  17.220  1.00 20.00           S
ATOM    128  H   CYS A  10      31.205  21.537  14.557  1.00 20.00           H
ATOM    129  HA  CYS A  10      33.205  22.746  16.338  1.00 20.00           H
ATOM    130  HB2 CYS A  10      32.686  21.207  18.134  1.00 20.00           H
ATOM    131  HB3 CYS A  10      31.253  22.207  17.780  1.00 20.00           H
ATOM    132  HG  CYS A  10      30.401  19.605  18.374  1.00 20.00           H
ATOM    133  N   SER A  11      34.725  21.019  15.450  1.00 20.00           N
ATOM    134  CA  SER A  11      35.665  20.047  14.894  1.00 20.00           C
ATOM    135  C   SER A  11      35.354  19.739  13.432  1.00 20.00           C
ATOM    136  O   SER A  11      35.598  18.629  12.954  1.00 20.00           O
ATOM    137  CB  SER A  11      35.674  18.756  15.717  1.00 20.00           C
ATOM    138  OG  SER A  11      36.142  18.989  17.034  1.00 20.00           O
ATOM    139  H   SER A  11      35.172  21.870  15.792  1.00 20.00           H
ATOM    140  HA  SER A  11      36.668  20.471  14.935  1.00 20.00           H
ATOM    141  HB2 SER A  11      34.658  18.362  15.768  1.00 20.00           H
ATOM    142  HB3 SER A  11      36.329  18.032  15.232  1.00 20.00           H
ATOM    143  HG  SER A  11      36.140  18.152  17.544  1.00 20.00           H
ATOM    144  N   GLY A  12      34.815  20.720  12.711  1.00 20.00           N
ATOM    145  CA  GLY A  12      34.483  20.536  11.312  1.00 20.00           C
ATOM    146  C   GLY A  12      33.445  19.456  11.092  1.00 20.00           C
ATOM    147  O   GLY A  12      33.673  18.512  10.330  1.00 20.00           O
ATOM    148  H   GLY A  12      34.600  21.649  13.072  1.00 20.00           H
ATOM    149  HA2 GLY A  12      34.097  21.471  10.907  1.00 20.00           H
ATOM    150  HA3 GLY A  12      35.382  20.267  10.759  1.00 20.00           H
ATOM    151  N   SER A  13      32.298  19.583  11.755  1.00 20.00           N
ATOM    152  CA  SER A  13      31.226  18.608  11.625  1.00 20.00           C
ATOM    153  C   SER A  13      29.894  19.302  11.866  1.00 20.00           C
ATOM    154  O   SER A  13      29.820  20.336  12.535  1.00 20.00           O
ATOM    155  CB  SER A  13      31.406  17.440  12.602  1.00 20.00           C
ATOM    156  OG  SER A  13      30.340  16.512  12.490  1.00 20.00           O
ATOM    157  H   SER A  13      32.083  20.353  12.390  1.00 20.00           H
ATOM    158  HA  SER A  13      31.225  18.208  10.611  1.00 20.00           H
ATOM    159  HB2 SER A  13      32.343  16.932  12.377  1.00 20.00           H
ATOM    160  HB3 SER A  13      31.430  17.830  13.620  1.00 20.00           H
ATOM    161  HG  SER A  13      30.471  15.774  13.120  1.00 20.00           H
ATOM    162  N   TRP A  14      28.838  18.717  11.308  1.00 20.00           N
ATOM    163  CA  TRP A  14      27.503  19.277  11.460  1.00 20.00           C
ATOM    164  C   TRP A  14      27.025  19.139  12.901  1.00 20.00           C
ATOM    165  O   TRP A  14      27.332  18.165  13.594  1.00 20.00           O
ATOM    166  CB  TRP A  14      26.523  18.581  10.516  1.00 20.00           C
ATOM    167  CG  TRP A  14      26.374  17.115  10.783  1.00 20.00           C
ATOM    168  CD1 TRP A  14      27.116  16.104  10.244  1.00 20.00           C
ATOM    169  CD2 TRP A  14      25.421  16.493  11.654  1.00 20.00           C
ATOM    170  NE1 TRP A  14      26.686  14.891  10.726  1.00 20.00           N
ATOM    171  CE2 TRP A  14      25.646  15.102  11.595  1.00 20.00           C
ATOM    172  CE3 TRP A  14      24.401  16.975  12.479  1.00 20.00           C
ATOM    173  CZ2 TRP A  14      24.889  14.191  12.327  1.00 20.00           C
ATOM    174  CZ3 TRP A  14      23.650  16.069  13.207  1.00 20.00           C
ATOM    175  CH2 TRP A  14      23.898  14.693  13.125  1.00 20.00           C
ATOM    176  H   TRP A  14      28.875  17.864  10.751  1.00 20.00           H
ATOM    177  HA  TRP A  14      27.527  20.337  11.208  1.00 20.00           H
ATOM    178  HB2 TRP A  14      25.541  19.041  10.624  1.00 20.00           H
ATOM    179  HB3 TRP A  14      26.877  18.700   9.492  1.00 20.00           H
ATOM    180  HD1 TRP A  14      27.925  16.238   9.541  1.00 20.00           H
ATOM    181  HE1 TRP A  14      27.077  13.982  10.479  1.00 20.00           H
ATOM    182  HE3 TRP A  14      24.204  18.035  12.548  1.00 20.00           H
ATOM    183  HZ2 TRP A  14      25.077  13.129  12.267  1.00 20.00           H
ATOM    184  HZ3 TRP A  14      22.859  16.428  13.848  1.00 20.00           H
ATOM    185  HH2 TRP A  14      23.294  14.013  13.706  1.00 20.00           H
ATOM    186  N   CYS A  15      26.262  20.134  13.350  1.00 20.00           N
ATOM    187  CA  CYS A  15      25.724  20.153  14.703  1.00 20.00           C
ATOM    188  C   CYS A  15      24.343  20.785  14.679  1.00 20.00           C
ATOM    189  O   CYS A  15      24.171  21.884  14.142  1.00 20.00           O
ATOM    190  CB  CYS A  15      26.644  20.926  15.656  1.00 20.00           C
ATOM    191  SG  CYS A  15      26.801  22.686  15.271  1.00 20.00           S
ATOM    192  H   CYS A  15      25.999  20.947  12.793  1.00 20.00           H
ATOM    193  HA  CYS A  15      25.629  19.131  15.070  1.00 20.00           H
ATOM    194  HB2 CYS A  15      26.248  20.842  16.668  1.00 20.00           H
ATOM    195  HB3 CYS A  15      27.640  20.487  15.613  1.00 20.00           H
ATOM    196  HG  CYS A  15      27.599  23.239  16.136  1.00 20.00           H
ATOM    197  N   SER A  16      23.365  20.092  15.258  1.00 20.00           N
ATOM    198  CA  SER A  16      21.997  20.584  15.304  1.00 20.00           C
ATOM    199  C   SER A  16      21.307  20.011  16.532  1.00 20.00           C
ATOM    200  O   SER A  16      21.477  18.832  16.855  1.00 20.00           O
ATOM    201  CB  SER A  16      21.223  20.204  14.036  1.00 20.00           C
ATOM    202  OG  SER A  16      21.052  18.800  13.945  1.00 20.00           O
ATOM    203  H   SER A  16      23.494  19.184  15.705  1.00 20.00           H
ATOM    204  HA  SER A  16      22.005  21.670  15.390  1.00 20.00           H
ATOM    205  HB2 SER A  16      20.242  20.679  14.064  1.00 20.00           H
ATOM    206  HB3 SER A  16      21.779  20.550  13.165  1.00 20.00           H
ATOM    207  HG  SER A  16      20.556  18.575  13.129  1.00 20.00           H
ATOM    208  N   TRP A  17      20.530  20.852  17.211  1.00 20.00           N
ATOM    209  CA  TRP A  17      19.805  20.447  18.405  1.00 20.00           C
ATOM    210  C   TRP A  17      18.444  21.126  18.420  1.00 20.00           C
ATOM    211  O   TRP A  17      18.291  22.255  17.947  1.00 20.00           O
ATOM    212  CB  TRP A  17      20.580  20.799  19.683  1.00 20.00           C
ATOM    213  CG  TRP A  17      20.813  22.269  19.856  1.00 20.00           C
ATOM    214  CD1 TRP A  17      21.875  22.990  19.393  1.00 20.00           C
ATOM    215  CD2 TRP A  17      19.965  23.198  20.541  1.00 20.00           C
ATOM    216  NE1 TRP A  17      21.740  24.311  19.747  1.00 20.00           N
ATOM    217  CE2 TRP A  17      20.577  24.465  20.452  1.00 20.00           C
ATOM    218  CE3 TRP A  17      18.748  23.084  21.220  1.00 20.00           C
ATOM    219  CZ2 TRP A  17      20.012  25.607  21.017  1.00 20.00           C
ATOM    220  CZ3 TRP A  17      18.190  24.219  21.780  1.00 20.00           C
ATOM    221  CH2 TRP A  17      18.823  25.464  21.675  1.00 20.00           C
ATOM    222  H   TRP A  17      20.384  21.828  16.954  1.00 20.00           H
ATOM    223  HA  TRP A  17      19.650  19.369  18.385  1.00 20.00           H
ATOM    224  HB2 TRP A  17      20.016  20.447  20.547  1.00 20.00           H
ATOM    225  HB3 TRP A  17      21.553  20.310  19.651  1.00 20.00           H
ATOM    226  HD1 TRP A  17      22.701  22.583  18.830  1.00 20.00           H
ATOM    227  HE1 TRP A  17      22.400  25.056  19.521  1.00 20.00           H
ATOM    228  HE3 TRP A  17      18.254  22.127  21.306  1.00 20.00           H
ATOM    229  HZ2 TRP A  17      20.497  26.570  20.938  1.00 20.00           H
ATOM    230  HZ3 TRP A  17      17.251  24.144  22.308  1.00 20.00           H
ATOM    231  HH2 TRP A  17      18.360  26.330  22.124  1.00 20.00           H
ATOM    232  N   TRP A  18      17.455  20.423  18.969  1.00 20.00           N
ATOM    233  CA  TRP A  18      16.094  20.946  19.049  1.00 20.00           C
ATOM    234  C   TRP A  18      15.412  20.298  20.245  1.00 20.00           C
ATOM    235  O   TRP A  18      15.208  19.080  20.259  1.00 20.00           O
ATOM    236  CB  TRP A  18      15.322  20.671  17.761  1.00 20.00           C
ATOM    237  CG  TRP A  18      15.835  21.438  16.581  1.00 20.00           C
ATOM    238  CD1 TRP A  18      15.443  22.681  16.177  1.00 20.00           C
ATOM    239  CD2 TRP A  18      16.836  21.012  15.649  1.00 20.00           C
ATOM    240  NE1 TRP A  18      16.137  23.055  15.053  1.00 20.00           N
ATOM    241  CE2 TRP A  18      17.000  22.047  14.708  1.00 20.00           C
ATOM    242  CE3 TRP A  18      17.612  19.855  15.520  1.00 20.00           C
ATOM    243  CZ2 TRP A  18      17.906  21.962  13.653  1.00 20.00           C
ATOM    244  CZ3 TRP A  18      18.510  19.772  14.470  1.00 20.00           C
ATOM    245  CH2 TRP A  18      18.650  20.818  13.552  1.00 20.00           C
ATOM    246  H   TRP A  18      17.566  19.490  19.365  1.00 20.00           H
ATOM    247  HA  TRP A  18      16.126  22.023  19.211  1.00 20.00           H
ATOM    248  HB2 TRP A  18      15.395  19.610  17.527  1.00 20.00           H
ATOM    249  HB3 TRP A  18      14.278  20.947  17.910  1.00 20.00           H
ATOM    250  HD1 TRP A  18      14.694  23.283  16.671  1.00 20.00           H
ATOM    251  HE1 TRP A  18      16.030  23.939  14.555  1.00 20.00           H
ATOM    252  HE3 TRP A  18      17.511  19.043  16.224  1.00 20.00           H
ATOM    253  HZ2 TRP A  18      18.015  22.767  12.942  1.00 20.00           H
ATOM    254  HZ3 TRP A  18      19.114  18.884  14.359  1.00 20.00           H
ATOM    255  HH2 TRP A  18      19.360  20.721  12.745  1.00 20.00           H
ATOM    256  N   MET A  19      15.062  21.106  21.239  1.00 20.00           N
ATOM    257  CA  MET A  19      14.397  20.628  22.441  1.00 20.00           C
ATOM    258  C   MET A  19      12.894  20.867  22.346  1.00 20.00           C
ATOM    259  O   MET A  19      12.401  21.573  21.463  1.00 20.00           O
ATOM    260  CB  MET A  19      14.971  21.320  23.682  1.00 20.00           C
ATOM    261  CG  MET A  19      14.587  22.786  23.811  1.00 20.00           C
ATOM    262  SD  MET A  19      15.481  23.855  22.666  1.00 20.00           S
ATOM    263  CE  MET A  19      15.221  25.458  23.422  1.00 20.00           C
ATOM    264  H   MET A  19      15.230  22.112  21.239  1.00 20.00           H
ATOM    265  HA  MET A  19      14.576  19.557  22.542  1.00 20.00           H
ATOM    266  HB2 MET A  19      14.606  20.802  24.569  1.00 20.00           H
ATOM    267  HB3 MET A  19      16.059  21.262  23.644  1.00 20.00           H
ATOM    268  HG2 MET A  19      13.522  22.892  23.607  1.00 20.00           H
ATOM    269  HG3 MET A  19      14.806  23.121  24.825  1.00 20.00           H
ATOM    270  HE1 MET A  19      15.720  26.218  22.821  1.00 20.00           H
ATOM    271  HE2 MET A  19      14.151  25.660  23.466  1.00 20.00           H
ATOM    272  HE3 MET A  19      15.639  25.448  24.429  1.00 20.00           H
ATOM    273  N   MSE A  20      12.164  20.264  23.279  1.00 20.00           N
ATOM    274  CA  MSE A  20      10.713  20.398  23.320  1.00 20.00           C
ATOM    275  C   MSE A  20      10.310  21.728  23.947  1.00 20.00           C
ATOM    276  O   MSE A  20       9.520  22.480  23.377  1.00 20.00           O
ATOM    277  CB  MSE A  20      10.091  19.239  24.103  1.00 20.00           C
ATOM    278  CG  MSE A  20      10.405  19.252  25.592  1.00 20.00           C
ATOM    279 SE   MSE A  20       9.952  17.578  26.487  1.00 20.00          Se
ATOM    280  CE  MSE A  20      11.625  16.619  26.201  1.00 20.00           C
ATOM    281  H   MSE A  20      12.548  19.676  24.018  1.00 20.00           H
ATOM    282  HA  MSE A  20      10.328  20.362  22.301  1.00 20.00           H
ATOM    283  HB2 MSE A  20       9.008  19.284  23.992  1.00 20.00           H
ATOM    284  HB3 MSE A  20      10.464  18.300  23.693  1.00 20.00           H
ATOM    285  HG2 MSE A  20      11.471  19.427  25.727  1.00 20.00           H
ATOM    286  HG3 MSE A  20       9.834  20.050  26.066  1.00 20.00           H
ATOM    287  HE1 MSE A  20      12.429  17.149  26.711  1.00 20.00           H
ATOM    288  HE2 MSE A  20      11.529  15.611  26.605  1.00 20.00           H
ATOM    289  HE3 MSE A  20      11.830  16.574  25.131  1.00 20.00           H
ATOM    290  N   GLY A  21      10.860  22.012  25.125  1.00 20.00           N
ATOM    291  CA  GLY A  21      10.558  23.246  25.823  1.00 20.00           C
ATOM    292  C   GLY A  21      10.794  23.148  27.316  1.00 20.00           C
ATOM    293  O   GLY A  21      11.205  24.122  27.952  1.00 20.00           O
ATOM    294  H   GLY A  21      11.517  21.406  25.616  1.00 20.00           H
ATOM    295  HA2 GLY A  21      11.182  24.047  25.428  1.00 20.00           H
ATOM    296  HA3 GLY A  21       9.513  23.509  25.657  1.00 20.00           H
ATOM    297  N   MSE A  22      10.537  21.975  27.885  1.00 20.00           N
ATOM    298  CA  MSE A  22      10.726  21.759  29.315  1.00 20.00           C
ATOM    299  C   MSE A  22      12.209  21.661  29.655  1.00 20.00           C
ATOM    300  O   MSE A  22      12.986  21.053  28.919  1.00 20.00           O
ATOM    301  CB  MSE A  22       9.999  20.490  29.765  1.00 20.00           C
ATOM    302  CG  MSE A  22      10.595  19.202  29.217  1.00 20.00           C
ATOM    303 SE   MSE A  22       9.436  17.652  29.466  1.00 20.00          Se
ATOM    304  CE  MSE A  22       8.385  17.794  27.829  1.00 20.00           C
ATOM    305  H   MSE A  22      10.197  21.154  27.384  1.00 20.00           H
ATOM    306  HA  MSE A  22      10.299  22.603  29.856  1.00 20.00           H
ATOM    307  HB2 MSE A  22      10.033  20.435  30.853  1.00 20.00           H
ATOM    308  HB3 MSE A  22       8.962  20.545  29.431  1.00 20.00           H
ATOM    309  HG2 MSE A  22      10.772  19.320  28.149  1.00 20.00           H
ATOM    310  HG3 MSE A  22      11.536  19.001  29.730  1.00 20.00           H
ATOM    311  HE1 MSE A  22       9.047  17.673  26.971  1.00 20.00           H
ATOM    312  HE2 MSE A  22       7.626  17.011  27.827  1.00 20.00           H
ATOM    313  HE3 MSE A  22       7.909  18.774  27.797  1.00 20.00           H
ATOM    314  N   GLY A  23      12.595  22.265  30.778  1.00 20.00           N
ATOM    315  CA  GLY A  23      13.970  22.254  31.225  1.00 20.00           C
ATOM    316  C   GLY A  23      14.298  21.022  32.047  1.00 20.00           C
ATOM    317  O   GLY A  23      13.564  20.032  32.071  1.00 20.00           O
ATOM    318  H   GLY A  23      11.965  22.772  31.399  1.00 20.00           H
ATOM    319  HA2 GLY A  23      14.634  22.281  30.361  1.00 20.00           H
ATOM    320  HA3 GLY A  23      14.161  23.137  31.836  1.00 20.00           H
ATOM    321  N   GLY A  24      15.435  21.095  32.734  1.00 20.00           N
ATOM    322  CA  GLY A  24      15.881  19.996  33.565  1.00 20.00           C
ATOM    323  C   GLY A  24      16.563  18.874  32.819  1.00 20.00           C
ATOM    324  O   GLY A  24      16.588  17.743  33.313  1.00 20.00           O
ATOM    325  H   GLY A  24      16.062  21.900  32.732  1.00 20.00           H
ATOM    326  HA2 GLY A  24      16.579  20.376  34.311  1.00 20.00           H
ATOM    327  HA3 GLY A  24      15.022  19.577  34.089  1.00 20.00           H
ATOM    328  N   ILE A  25      17.119  19.149  31.641  1.00 20.00           N
ATOM    329  CA  ILE A  25      17.807  18.148  30.830  1.00 20.00           C
ATOM    330  C   ILE A  25      19.181  18.719  30.504  1.00 20.00           C
ATOM    331  O   ILE A  25      19.335  19.470  29.534  1.00 20.00           O
ATOM    332  CB  ILE A  25      17.035  17.796  29.554  1.00 20.00           C
ATOM    333  CG1 ILE A  25      16.803  19.052  28.711  1.00 20.00           C
ATOM    334  CG2 ILE A  25      15.706  17.136  29.902  1.00 20.00           C
ATOM    335  CD1 ILE A  25      17.966  19.409  27.808  1.00 20.00           C
ATOM    336  H   ILE A  25      17.109  20.076  31.215  1.00 20.00           H
ATOM    337  HA  ILE A  25      17.942  17.236  31.412  1.00 20.00           H
ATOM    338  HB  ILE A  25      17.630  17.092  28.972  1.00 20.00           H
ATOM    339 HG12 ILE A  25      15.928  18.894  28.080  1.00 20.00           H
ATOM    340 HG13 ILE A  25      16.630  19.898  29.376  1.00 20.00           H
ATOM    341 HG21 ILE A  25      15.175  16.897  28.982  1.00 20.00           H
ATOM    342 HG22 ILE A  25      15.896  16.222  30.465  1.00 20.00           H
ATOM    343 HG23 ILE A  25      15.114  17.828  30.502  1.00 20.00           H
ATOM    344 HD11 ILE A  25      17.716  20.311  27.248  1.00 20.00           H
ATOM    345 HD12 ILE A  25      18.850  19.585  28.421  1.00 20.00           H
ATOM    346 HD13 ILE A  25      18.150  18.583  27.120  1.00 20.00           H
ATOM    347  N   LYS A  26      20.180  18.367  31.306  1.00 20.00           N
ATOM    348  CA  LYS A  26      21.539  18.844  31.101  1.00 20.00           C
ATOM    349  C   LYS A  26      22.269  17.958  30.100  1.00 20.00           C
ATOM    350  O   LYS A  26      22.061  16.743  30.046  1.00 20.00           O
ATOM    351  CB  LYS A  26      22.305  18.875  32.424  1.00 20.00           C
ATOM    352  CG  LYS A  26      22.509  17.506  33.053  1.00 20.00           C
ATOM    353  CD  LYS A  26      23.801  16.863  32.578  1.00 20.00           C
ATOM    354  CE  LYS A  26      24.059  15.543  33.288  1.00 20.00           C
ATOM    355  NZ  LYS A  26      25.311  14.890  32.818  1.00 20.00           N
ATOM    356  H   LYS A  26      20.078  17.749  32.111  1.00 20.00           H
ATOM    357  HA  LYS A  26      21.507  19.858  30.701  1.00 20.00           H
ATOM    358  HB2 LYS A  26      23.288  19.310  32.250  1.00 20.00           H
ATOM    359  HB3 LYS A  26      21.751  19.489  33.135  1.00 20.00           H
ATOM    360  HG2 LYS A  26      22.557  17.612  34.137  1.00 20.00           H
ATOM    361  HG3 LYS A  26      21.680  16.855  32.774  1.00 20.00           H
ATOM    362  HD2 LYS A  26      23.735  16.667  31.508  1.00 20.00           H
ATOM    363  HD3 LYS A  26      24.635  17.532  32.789  1.00 20.00           H
ATOM    364  HE2 LYS A  26      24.152  15.725  34.359  1.00 20.00           H
ATOM    365  HE3 LYS A  26      23.229  14.865  33.094  1.00 20.00           H
ATOM    366  HZ1 LYS A  26      25.455  13.993  33.323  1.00 20.00           H
ATOM    367  HZ2 LYS A  26      25.250  14.698  31.797  1.00 20.00           H
ATOM    368  HZ3 LYS A  26      26.126  15.513  32.997  1.00 20.00           H
ATOM    369  N   LYS A  27      23.132  18.583  29.303  1.00 20.00           N
ATOM    370  CA  LYS A  27      23.908  17.877  28.295  1.00 20.00           C
ATOM    371  C   LYS A  27      25.290  18.506  28.197  1.00 20.00           C
ATOM    372  O   LYS A  27      25.494  19.669  28.555  1.00 20.00           O
ATOM    373  CB  LYS A  27      23.215  17.905  26.926  1.00 20.00           C
ATOM    374  CG  LYS A  27      23.081  19.298  26.330  1.00 20.00           C
ATOM    375  CD  LYS A  27      24.287  19.656  25.477  1.00 20.00           C
ATOM    376  CE  LYS A  27      24.105  21.002  24.795  1.00 20.00           C
ATOM    377  NZ  LYS A  27      25.287  21.378  23.972  1.00 20.00           N
ATOM    378  H   LYS A  27      23.315  19.587  29.333  1.00 20.00           H
ATOM    379  HA  LYS A  27      24.027  16.836  28.597  1.00 20.00           H
ATOM    380  HB2 LYS A  27      23.792  17.300  26.228  1.00 20.00           H
ATOM    381  HB3 LYS A  27      22.212  17.491  27.033  1.00 20.00           H
ATOM    382  HG2 LYS A  27      22.193  19.336  25.700  1.00 20.00           H
ATOM    383  HG3 LYS A  27      23.004  20.028  27.136  1.00 20.00           H
ATOM    384  HD2 LYS A  27      25.173  19.710  26.110  1.00 20.00           H
ATOM    385  HD3 LYS A  27      24.419  18.898  24.705  1.00 20.00           H
ATOM    386  HE2 LYS A  27      23.234  20.956  24.140  1.00 20.00           H
ATOM    387  HE3 LYS A  27      23.961  21.771  25.555  1.00 20.00           H
ATOM    388  HZ1 LYS A  27      25.127  22.301  23.521  1.00 20.00           H
ATOM    389  HZ2 LYS A  27      26.134  21.436  24.572  1.00 20.00           H
ATOM    390  HZ3 LYS A  27      25.445  20.664  23.232  1.00 20.00           H
ATOM    391  N   MET A  28      26.243  17.716  27.705  1.00 20.00           N
ATOM    392  CA  MET A  28      27.621  18.159  27.547  1.00 20.00           C
ATOM    393  C   MET A  28      28.151  17.636  26.219  1.00 20.00           C
ATOM    394  O   MET A  28      27.450  16.946  25.472  1.00 20.00           O
ATOM    395  CB  MET A  28      28.492  17.684  28.716  1.00 20.00           C
ATOM    396  CG  MET A  28      28.771  16.189  28.716  1.00 20.00           C
ATOM    397  SD  MET A  28      27.351  15.204  29.230  1.00 20.00           S
ATOM    398  CE  MET A  28      28.141  13.648  29.633  1.00 20.00           C
ATOM    399  H   MET A  28      26.087  16.754  27.405  1.00 20.00           H
ATOM    400  HA  MET A  28      27.644  19.249  27.530  1.00 20.00           H
ATOM    401  HB2 MET A  28      29.451  18.199  28.669  1.00 20.00           H
ATOM    402  HB3 MET A  28      27.988  17.928  29.651  1.00 20.00           H
ATOM    403  HG2 MET A  28      29.048  15.879  27.708  1.00 20.00           H
ATOM    404  HG3 MET A  28      29.589  15.981  29.406  1.00 20.00           H
ATOM    405  HE1 MET A  28      27.381  12.940  29.966  1.00 20.00           H
ATOM    406  HE2 MET A  28      28.642  13.264  28.743  1.00 20.00           H
ATOM    407  HE3 MET A  28      28.869  13.814  30.426  1.00 20.00           H
ATOM    408  N   LYS A  29      29.407  17.972  25.924  1.00 20.00           N
ATOM    409  CA  LYS A  29      30.063  17.547  24.686  1.00 20.00           C
ATOM    410  C   LYS A  29      31.474  17.091  25.043  1.00 20.00           C
ATOM    411  O   LYS A  29      32.372  17.918  25.228  1.00 20.00           O
ATOM    412  CB  LYS A  29      30.085  18.673  23.658  1.00 20.00           C
ATOM    413  CG  LYS A  29      30.906  19.880  24.080  1.00 20.00           C
ATOM    414  CD  LYS A  29      32.354  19.750  23.636  1.00 20.00           C
ATOM    415  CE  LYS A  29      33.151  21.003  23.963  1.00 20.00           C
ATOM    416  NZ  LYS A  29      34.577  20.881  23.553  1.00 20.00           N
ATOM    417  H   LYS A  29      30.001  18.541  26.527  1.00 20.00           H
ATOM    418  HA  LYS A  29      29.524  16.701  24.259  1.00 20.00           H
ATOM    419  HB2 LYS A  29      30.508  18.290  22.729  1.00 20.00           H
ATOM    420  HB3 LYS A  29      29.063  19.010  23.487  1.00 20.00           H
ATOM    421  HG2 LYS A  29      30.488  20.777  23.624  1.00 20.00           H
ATOM    422  HG3 LYS A  29      30.889  19.965  25.166  1.00 20.00           H
ATOM    423  HD2 LYS A  29      32.815  18.907  24.152  1.00 20.00           H
ATOM    424  HD3 LYS A  29      32.387  19.596  22.558  1.00 20.00           H
ATOM    425  HE2 LYS A  29      32.717  21.851  23.434  1.00 20.00           H
ATOM    426  HE3 LYS A  29      33.120  21.175  25.038  1.00 20.00           H
ATOM    427  HZ1 LYS A  29      35.091  21.753  23.792  1.00 20.00           H
ATOM    428  HZ2 LYS A  29      35.022  20.080  24.047  1.00 20.00           H
ATOM    429  HZ3 LYS A  29      34.640  20.721  22.527  1.00 20.00           H
ATOM    430  N   GLY A  30      31.663  15.779  25.137  1.00 20.00           N
ATOM    431  CA  GLY A  30      32.961  15.234  25.472  1.00 20.00           C
ATOM    432  C   GLY A  30      33.959  15.381  24.338  1.00 20.00           C
ATOM    433  O   GLY A  30      33.640  15.794  23.222  1.00 20.00           O
ATOM    434  H   GLY A  30      30.939  15.077  24.987  1.00 20.00           H
ATOM    435  HA2 GLY A  30      33.356  15.748  26.348  1.00 20.00           H
ATOM    436  HA3 GLY A  30      32.860  14.175  25.708  1.00 20.00           H
ATOM    437  N   TRP A  31      35.204  15.028  24.644  1.00 20.00           N
ATOM    438  CA  TRP A  31      36.278  15.111  23.666  1.00 20.00           C
ATOM    439  C   TRP A  31      36.183  13.959  22.673  1.00 20.00           C
ATOM    440  O   TRP A  31      35.806  12.840  23.031  1.00 20.00           O
ATOM    441  CB  TRP A  31      37.638  15.087  24.364  1.00 20.00           C
ATOM    442  CG  TRP A  31      37.894  13.826  25.133  1.00 20.00           C
ATOM    443  CD1 TRP A  31      37.576  13.584  26.436  1.00 20.00           C
ATOM    444  CD2 TRP A  31      38.522  12.635  24.644  1.00 20.00           C
ATOM    445  NE1 TRP A  31      37.967  12.315  26.791  1.00 20.00           N
ATOM    446  CE2 TRP A  31      38.550  11.712  25.707  1.00 20.00           C
ATOM    447  CE3 TRP A  31      39.062  12.259  23.410  1.00 20.00           C
ATOM    448  CZ2 TRP A  31      39.098  10.437  25.576  1.00 20.00           C
ATOM    449  CZ3 TRP A  31      39.606  10.993  23.282  1.00 20.00           C
ATOM    450  CH2 TRP A  31      39.619  10.098  24.358  1.00 20.00           C
ATOM    451  H   TRP A  31      35.498  14.683  25.558  1.00 20.00           H
ATOM    452  HA  TRP A  31      36.192  16.047  23.114  1.00 20.00           H
ATOM    453  HB2 TRP A  31      38.421  15.185  23.613  1.00 20.00           H
ATOM    454  HB3 TRP A  31      37.689  15.921  25.065  1.00 20.00           H
ATOM    455  HD1 TRP A  31      37.087  14.286  27.095  1.00 20.00           H
ATOM    456  HE1 TRP A  31      37.842  11.891  27.710  1.00 20.00           H
ATOM    457  HE3 TRP A  31      39.057  12.943  22.574  1.00 20.00           H
ATOM    458  HZ2 TRP A  31      39.109   9.744  26.403  1.00 20.00           H
ATOM    459  HZ3 TRP A  31      40.028  10.691  22.334  1.00 20.00           H
ATOM    460  HH2 TRP A  31      40.051   9.118  24.223  1.00 20.00           H
ATOM    461  N   GLY A  32      36.527  14.242  21.422  1.00 20.00           N
ATOM    462  CA  GLY A  32      36.470  13.212  20.397  1.00 20.00           C
ATOM    463  C   GLY A  32      35.033  12.832  20.097  1.00 20.00           C
ATOM    464  O   GLY A  32      34.158  13.692  19.945  1.00 20.00           O
ATOM    465  H   GLY A  32      36.844  15.154  21.093  1.00 20.00           H
ATOM    466  HA2 GLY A  32      36.936  13.575  19.481  1.00 20.00           H
ATOM    467  HA3 GLY A  32      37.004  12.324  20.735  1.00 20.00           H
ATOM    468  N   GLY A  33      34.781  11.528  20.010  1.00 20.00           N
ATOM    469  CA  GLY A  33      33.449  11.031  19.728  1.00 20.00           C
ATOM    470  C   GLY A  33      32.681  10.661  20.979  1.00 20.00           C
ATOM    471  O   GLY A  33      31.733   9.872  20.923  1.00 20.00           O
ATOM    472  H   GLY A  33      35.481  10.797  20.131  1.00 20.00           H
ATOM    473  HA2 GLY A  33      32.884  11.792  19.190  1.00 20.00           H
ATOM    474  HA3 GLY A  33      33.521  10.146  19.096  1.00 20.00           H
ATOM    475  N   MSE A  34      33.080  11.225  22.115  1.00 20.00           N
ATOM    476  CA  MSE A  34      32.417  10.946  23.383  1.00 20.00           C
ATOM    477  C   MSE A  34      31.285  11.937  23.631  1.00 20.00           C
ATOM    478  O   MSE A  34      31.515  13.142  23.733  1.00 20.00           O
ATOM    479  CB  MSE A  34      33.423  10.999  24.536  1.00 20.00           C
ATOM    480  CG  MSE A  34      33.973  12.389  24.820  1.00 20.00           C
ATOM    481 SE   MSE A  34      35.527  12.374  25.999  1.00 20.00          Se
ATOM    482  CE  MSE A  34      36.925  12.158  24.657  1.00 20.00           C
ATOM    483  H   MSE A  34      33.858  11.879  22.191  1.00 20.00           H
ATOM    484  HA  MSE A  34      31.998   9.940  23.348  1.00 20.00           H
ATOM    485  HB2 MSE A  34      32.934  10.643  25.442  1.00 20.00           H
ATOM    486  HB3 MSE A  34      34.265  10.351  24.295  1.00 20.00           H
ATOM    487  HG2 MSE A  34      34.269  12.851  23.878  1.00 20.00           H
ATOM    488  HG3 MSE A  34      33.195  12.985  25.297  1.00 20.00           H
ATOM    489  HE1 MSE A  34      36.922  13.027  23.999  1.00 20.00           H
ATOM    490  HE2 MSE A  34      37.889  12.075  25.159  1.00 20.00           H
ATOM    491  HE3 MSE A  34      36.726  11.254  24.081  1.00 20.00           H
ATOM    492  N   ILE A  35      30.062  11.421  23.725  1.00 20.00           N
ATOM    493  CA  ILE A  35      28.875  12.234  23.958  1.00 20.00           C
ATOM    494  C   ILE A  35      28.143  11.659  25.162  1.00 20.00           C
ATOM    495  O   ILE A  35      27.606  10.546  25.092  1.00 20.00           O
ATOM    496  CB  ILE A  35      27.950  12.273  22.730  1.00 20.00           C
ATOM    497  CG1 ILE A  35      27.525  10.855  22.341  1.00 20.00           C
ATOM    498  CG2 ILE A  35      28.645  12.961  21.562  1.00 20.00           C
ATOM    499  CD1 ILE A  35      26.332  10.335  23.118  1.00 20.00           C
ATOM    500  H   ILE A  35      29.861  10.424  23.643  1.00 20.00           H
ATOM    501  HA  ILE A  35      29.173  13.256  24.195  1.00 20.00           H
ATOM    502  HB  ILE A  35      27.057  12.844  22.987  1.00 20.00           H
ATOM    503 HG12 ILE A  35      27.263  10.845  21.282  1.00 20.00           H
ATOM    504 HG13 ILE A  35      28.358  10.174  22.520  1.00 20.00           H
ATOM    505 HG21 ILE A  35      27.972  12.974  20.704  1.00 20.00           H
ATOM    506 HG22 ILE A  35      28.897  13.982  21.846  1.00 20.00           H
ATOM    507 HG23 ILE A  35      29.550  12.407  21.313  1.00 20.00           H
ATOM    508 HD11 ILE A  35      26.101   9.326  22.777  1.00 20.00           H
ATOM    509 HD12 ILE A  35      26.580  10.323  24.179  1.00 20.00           H
ATOM    510 HD13 ILE A  35      25.480  10.991  22.942  1.00 20.00           H
ATOM    511  N   SER A  36      28.121  12.410  26.259  1.00 20.00           N
ATOM    512  CA  SER A  36      27.448  11.965  27.467  1.00 20.00           C
ATOM    513  C   SER A  36      25.941  12.179  27.351  1.00 20.00           C
ATOM    514  O   SER A  36      25.454  12.930  26.502  1.00 20.00           O
ATOM    515  CB  SER A  36      27.990  12.708  28.688  1.00 20.00           C
ATOM    516  OG  SER A  36      29.358  12.408  28.903  1.00 20.00           O
ATOM    517  H   SER A  36      28.560  13.327  26.339  1.00 20.00           H
ATOM    518  HA  SER A  36      27.631  10.900  27.608  1.00 20.00           H
ATOM    519  HB2 SER A  36      27.885  13.781  28.525  1.00 20.00           H
ATOM    520  HB3 SER A  36      27.420  12.408  29.568  1.00 20.00           H
ATOM    521  HG  SER A  36      29.689  12.891  29.688  1.00 20.00           H
ATOM    522  N   TRP A  37      25.202  11.502  28.227  1.00 20.00           N
ATOM    523  CA  TRP A  37      23.750  11.593  28.250  1.00 20.00           C
ATOM    524  C   TRP A  37      23.265  11.515  29.690  1.00 20.00           C
ATOM    525  O   TRP A  37      23.849  10.817  30.522  1.00 20.00           O
ATOM    526  CB  TRP A  37      23.101  10.479  27.418  1.00 20.00           C
ATOM    527  CG  TRP A  37      23.406   9.101  27.920  1.00 20.00           C
ATOM    528  CD1 TRP A  37      24.463   8.314  27.565  1.00 20.00           C
ATOM    529  CD2 TRP A  37      22.645   8.345  28.870  1.00 20.00           C
ATOM    530  NE1 TRP A  37      24.407   7.115  28.235  1.00 20.00           N
ATOM    531  CE2 TRP A  37      23.300   7.109  29.042  1.00 20.00           C
ATOM    532  CE3 TRP A  37      21.473   8.593  29.592  1.00 20.00           C
ATOM    533  CZ2 TRP A  37      22.823   6.126  29.905  1.00 20.00           C
ATOM    534  CZ3 TRP A  37      21.002   7.615  30.449  1.00 20.00           C
ATOM    535  CH2 TRP A  37      21.676   6.397  30.598  1.00 20.00           C
ATOM    536  H   TRP A  37      25.585  10.878  28.937  1.00 20.00           H
ATOM    537  HA  TRP A  37      23.442  12.553  27.837  1.00 20.00           H
ATOM    538  HB2 TRP A  37      22.019  10.609  27.438  1.00 20.00           H
ATOM    539  HB3 TRP A  37      23.464  10.548  26.392  1.00 20.00           H
ATOM    540  HD1 TRP A  37      25.231   8.592  26.859  1.00 20.00           H
ATOM    541  HE1 TRP A  37      25.079   6.354  28.144  1.00 20.00           H
ATOM    542  HE3 TRP A  37      20.948   9.530  29.484  1.00 20.00           H
ATOM    543  HZ2 TRP A  37      23.341   5.184  30.023  1.00 20.00           H
ATOM    544  HZ3 TRP A  37      20.098   7.794  31.013  1.00 20.00           H
ATOM    545  HH2 TRP A  37      21.281   5.654  31.275  1.00 20.00           H
ATOM    546  N   SER A  38      22.186  12.244  29.974  1.00 20.00           N
ATOM    547  CA  SER A  38      21.610  12.264  31.313  1.00 20.00           C
ATOM    548  C   SER A  38      20.202  12.845  31.281  1.00 20.00           C
ATOM    549  O   SER A  38      19.971  13.896  30.674  1.00 20.00           O
ATOM    550  CB  SER A  38      22.497  13.069  32.265  1.00 20.00           C
ATOM    551  OG  SER A  38      23.765  12.456  32.423  1.00 20.00           O
ATOM    552  H   SER A  38      21.692  12.828  29.300  1.00 20.00           H
ATOM    553  HA  SER A  38      21.547  11.243  31.690  1.00 20.00           H
ATOM    554  HB2 SER A  38      22.636  14.070  31.858  1.00 20.00           H
ATOM    555  HB3 SER A  38      22.009  13.128  33.239  1.00 20.00           H
ATOM    556  HG  SER A  38      24.320  12.984  33.035  1.00 20.00           H
ATOM    557  N   TRP A  39      19.257  12.170  31.931  1.00 20.00           N
ATOM    558  CA  TRP A  39      17.876  12.624  31.967  1.00 20.00           C
ATOM    559  C   TRP A  39      17.248  12.183  33.281  1.00 20.00           C
ATOM    560  O   TRP A  39      17.810  11.375  34.024  1.00 20.00           O
ATOM    561  CB  TRP A  39      17.079  12.086  30.774  1.00 20.00           C
ATOM    562  CG  TRP A  39      15.666  12.580  30.725  1.00 20.00           C
ATOM    563  CD1 TRP A  39      14.543  11.892  31.084  1.00 20.00           C
ATOM    564  CD2 TRP A  39      15.221  13.873  30.292  1.00 20.00           C
ATOM    565  NE1 TRP A  39      13.428  12.675  30.901  1.00 20.00           N
ATOM    566  CE2 TRP A  39      13.819  13.895  30.415  1.00 20.00           C
ATOM    567  CE3 TRP A  39      15.875  15.012  29.811  1.00 20.00           C
ATOM    568  CZ2 TRP A  39      13.057  15.011  30.076  1.00 20.00           C
ATOM    569  CZ3 TRP A  39      15.117  16.119  29.474  1.00 20.00           C
ATOM    570  CH2 TRP A  39      13.723  16.111  29.610  1.00 20.00           C
ATOM    571  H   TRP A  39      19.421  11.302  32.442  1.00 20.00           H
ATOM    572  HA  TRP A  39      17.855  13.714  31.928  1.00 20.00           H
ATOM    573  HB2 TRP A  39      17.572  12.394  29.852  1.00 20.00           H
ATOM    574  HB3 TRP A  39      17.051  10.998  30.831  1.00 20.00           H
ATOM    575  HD1 TRP A  39      14.532  10.879  31.457  1.00 20.00           H
ATOM    576  HE1 TRP A  39      12.468  12.393  31.094  1.00 20.00           H
ATOM    577  HE3 TRP A  39      16.950  15.026  29.704  1.00 20.00           H
ATOM    578  HZ2 TRP A  39      11.982  15.009  30.178  1.00 20.00           H
ATOM    579  HZ3 TRP A  39      15.609  17.006  29.103  1.00 20.00           H
ATOM    580  HH2 TRP A  39      13.162  16.992  29.337  1.00 20.00           H
ATOM    581  N   SER A  40      16.065  12.728  33.560  1.00 20.00           N
ATOM    582  CA  SER A  40      15.343  12.397  34.787  1.00 20.00           C
ATOM    583  C   SER A  40      13.867  12.690  34.557  1.00 20.00           C
ATOM    584  O   SER A  40      13.468  13.858  34.519  1.00 20.00           O
ATOM    585  CB  SER A  40      15.886  13.193  35.968  1.00 20.00           C
ATOM    586  OG  SER A  40      15.633  14.578  35.808  1.00 20.00           O
ATOM    587  H   SER A  40      15.583  13.398  32.961  1.00 20.00           H
ATOM    588  HA  SER A  40      15.457  11.335  35.003  1.00 20.00           H
ATOM    589  HB2 SER A  40      15.401  12.848  36.881  1.00 20.00           H
ATOM    590  HB3 SER A  40      16.963  13.036  36.035  1.00 20.00           H
ATOM    591  HG  SER A  40      15.988  15.075  36.575  1.00 20.00           H
ATOM    592  N   SER A  41      13.066  11.636  34.406  1.00 20.00           N
ATOM    593  CA  SER A  41      11.629  11.765  34.175  1.00 20.00           C
ATOM    594  C   SER A  41      11.356  12.569  32.902  1.00 20.00           C
ATOM    595  O   SER A  41      10.655  13.583  32.906  1.00 20.00           O
ATOM    596  CB  SER A  41      10.939  12.400  35.388  1.00 20.00           C
ATOM    597  OG  SER A  41      11.046  11.571  36.532  1.00 20.00           O
ATOM    598  H   SER A  41      13.388  10.668  34.438  1.00 20.00           H
ATOM    599  HA  SER A  41      11.206  10.770  34.036  1.00 20.00           H
ATOM    600  HB2 SER A  41      11.410  13.359  35.601  1.00 20.00           H
ATOM    601  HB3 SER A  41       9.884  12.548  35.157  1.00 20.00           H
ATOM    602  HG  SER A  41      10.600  11.993  37.296  1.00 20.00           H
ATOM    603  N   SER A  42      11.930  12.091  31.803  1.00 20.00           N
ATOM    604  CA  SER A  42      11.785  12.719  30.500  1.00 20.00           C
ATOM    605  C   SER A  42      10.970  11.825  29.573  1.00 20.00           C
ATOM    606  O   SER A  42      10.866  10.612  29.773  1.00 20.00           O
ATOM    607  CB  SER A  42      13.155  13.008  29.876  1.00 20.00           C
ATOM    608  OG  SER A  42      13.018  13.591  28.592  1.00 20.00           O
ATOM    609  H   SER A  42      12.512  11.253  31.786  1.00 20.00           H
ATOM    610  HA  SER A  42      11.256  13.665  30.611  1.00 20.00           H
ATOM    611  HB2 SER A  42      13.700  13.698  30.522  1.00 20.00           H
ATOM    612  HB3 SER A  42      13.707  12.072  29.784  1.00 20.00           H
ATOM    613  HG  SER A  42      13.902  13.769  28.209  1.00 20.00           H
ATOM    614  N   GLY A  43      10.393  12.444  28.553  1.00 20.00           N
ATOM    615  CA  GLY A  43       9.582  11.747  27.573  1.00 20.00           C
ATOM    616  C   GLY A  43      10.398  11.216  26.416  1.00 20.00           C
ATOM    617  O   GLY A  43      11.558  10.820  26.569  1.00 20.00           O
ATOM    618  H   GLY A  43      10.472  13.445  28.377  1.00 20.00           H
ATOM    619  HA2 GLY A  43       9.075  10.909  28.052  1.00 20.00           H
ATOM    620  HA3 GLY A  43       8.826  12.427  27.179  1.00 20.00           H
ATOM    621  N   LYS A  44       9.781  11.206  25.238  1.00 20.00           N
ATOM    622  CA  LYS A  44      10.456  10.720  24.044  1.00 20.00           C
ATOM    623  C   LYS A  44      11.490  11.732  23.568  1.00 20.00           C
ATOM    624  O   LYS A  44      11.233  12.939  23.529  1.00 20.00           O
ATOM    625  CB  LYS A  44       9.441  10.447  22.935  1.00 20.00           C
ATOM    626  CG  LYS A  44       8.710  11.688  22.447  1.00 20.00           C
ATOM    627  CD  LYS A  44       9.451  12.353  21.297  1.00 20.00           C
ATOM    628  CE  LYS A  44       8.667  13.530  20.738  1.00 20.00           C
ATOM    629  NZ  LYS A  44       9.389  14.205  19.625  1.00 20.00           N
ATOM    630  H   LYS A  44       8.825  11.525  25.081  1.00 20.00           H
ATOM    631  HA  LYS A  44      10.970   9.787  24.275  1.00 20.00           H
ATOM    632  HB2 LYS A  44       9.961  10.011  22.082  1.00 20.00           H
ATOM    633  HB3 LYS A  44       8.694   9.747  23.308  1.00 20.00           H
ATOM    634  HG2 LYS A  44       7.717  11.406  22.097  1.00 20.00           H
ATOM    635  HG3 LYS A  44       8.634  12.405  23.264  1.00 20.00           H
ATOM    636  HD2 LYS A  44      10.413  12.720  21.653  1.00 20.00           H
ATOM    637  HD3 LYS A  44       9.596  11.628  20.496  1.00 20.00           H
ATOM    638  HE2 LYS A  44       7.711  13.174  20.356  1.00 20.00           H
ATOM    639  HE3 LYS A  44       8.507  14.260  21.531  1.00 20.00           H
ATOM    640  HZ1 LYS A  44       8.825  15.002  19.268  1.00 20.00           H
ATOM    641  HZ2 LYS A  44      10.306  14.563  19.961  1.00 20.00           H
ATOM    642  HZ3 LYS A  44       9.553  13.532  18.848  1.00 20.00           H
ATOM    643  N   MSE A  45      12.667  11.232  23.205  1.00 20.00           N
ATOM    644  CA  MSE A  45      13.750  12.084  22.728  1.00 20.00           C
ATOM    645  C   MSE A  45      14.469  11.434  21.550  1.00 20.00           C
ATOM    646  O   MSE A  45      14.707  10.226  21.546  1.00 20.00           O
ATOM    647  CB  MSE A  45      14.744  12.369  23.856  1.00 20.00           C
ATOM    648  CG  MSE A  45      15.539  11.154  24.310  1.00 20.00           C
ATOM    649 SE   MSE A  45      16.489  11.442  25.990  1.00 20.00          Se
ATOM    650  CE  MSE A  45      15.080  10.911  27.230  1.00 20.00           C
ATOM    651  H   MSE A  45      12.902  10.240  23.230  1.00 20.00           H
ATOM    652  HA  MSE A  45      13.333  13.034  22.397  1.00 20.00           H
ATOM    653  HB2 MSE A  45      15.454  13.121  23.514  1.00 20.00           H
ATOM    654  HB3 MSE A  45      14.195  12.748  24.718  1.00 20.00           H
ATOM    655  HG2 MSE A  45      14.857  10.317  24.449  1.00 20.00           H
ATOM    656  HG3 MSE A  45      16.277  10.909  23.546  1.00 20.00           H
ATOM    657  HE1 MSE A  45      14.845   9.859  27.070  1.00 20.00           H
ATOM    658  HE2 MSE A  45      15.431  11.063  28.251  1.00 20.00           H
ATOM    659  HE3 MSE A  45      14.197  11.521  27.046  1.00 20.00           H
ATOM    660  N   TRP A  46      14.811  12.244  20.551  1.00 20.00           N
ATOM    661  CA  TRP A  46      15.502  11.764  19.364  1.00 20.00           C
ATOM    662  C   TRP A  46      16.489  12.822  18.896  1.00 20.00           C
ATOM    663  O   TRP A  46      16.250  14.024  19.038  1.00 20.00           O
ATOM    664  CB  TRP A  46      14.519  11.428  18.235  1.00 20.00           C
ATOM    665  CG  TRP A  46      13.723  12.606  17.764  1.00 20.00           C
ATOM    666  CD1 TRP A  46      12.521  13.032  18.252  1.00 20.00           C
ATOM    667  CD2 TRP A  46      14.071  13.512  16.710  1.00 20.00           C
ATOM    668  NE1 TRP A  46      12.101  14.146  17.567  1.00 20.00           N
ATOM    669  CE2 TRP A  46      13.035  14.461  16.616  1.00 20.00           C
ATOM    670  CE3 TRP A  46      15.160  13.612  15.837  1.00 20.00           C
ATOM    671  CZ2 TRP A  46      13.053  15.497  15.684  1.00 20.00           C
ATOM    672  CZ3 TRP A  46      15.176  14.642  14.913  1.00 20.00           C
ATOM    673  CH2 TRP A  46      14.130  15.570  14.843  1.00 20.00           C
ATOM    674  H   TRP A  46      14.620  13.246  20.538  1.00 20.00           H
ATOM    675  HA  TRP A  46      16.061  10.862  19.612  1.00 20.00           H
ATOM    676  HB2 TRP A  46      15.080  11.042  17.383  1.00 20.00           H
ATOM    677  HB3 TRP A  46      13.819  10.672  18.590  1.00 20.00           H
ATOM    678  HD1 TRP A  46      11.981  12.562  19.059  1.00 20.00           H
ATOM    679  HE1 TRP A  46      11.234  14.656  17.740  1.00 20.00           H
ATOM    680  HE3 TRP A  46      15.970  12.900  15.884  1.00 20.00           H
ATOM    681  HZ2 TRP A  46      12.249  16.215  15.627  1.00 20.00           H
ATOM    682  HZ3 TRP A  46      16.011  14.730  14.233  1.00 20.00           H
ATOM    683  HH2 TRP A  46      14.174  16.361  14.110  1.00 20.00           H
ATOM    684  N   GLY A  47      17.599  12.364  18.338  1.00 20.00           N
ATOM    685  CA  GLY A  47      18.624  13.262  17.848  1.00 20.00           C
ATOM    686  C   GLY A  47      19.960  12.565  17.762  1.00 20.00           C
ATOM    687  O   GLY A  47      20.127  11.422  18.188  1.00 20.00           O
ATOM    688  H   GLY A  47      17.815  11.375  18.212  1.00 20.00           H
ATOM    689  HA2 GLY A  47      18.353  13.624  16.856  1.00 20.00           H
ATOM    690  HA3 GLY A  47      18.717  14.116  18.519  1.00 20.00           H
ATOM    691  N   GLY A  48      20.923  13.285  17.193  1.00 20.00           N
ATOM    692  CA  GLY A  48      22.265  12.761  17.033  1.00 20.00           C
ATOM    693  C   GLY A  48      23.140  13.642  16.167  1.00 20.00           C
ATOM    694  O   GLY A  48      23.042  14.872  16.221  1.00 20.00           O
ATOM    695  H   GLY A  48      20.801  14.232  16.835  1.00 20.00           H
ATOM    696  HA2 GLY A  48      22.735  12.665  18.012  1.00 20.00           H
ATOM    697  HA3 GLY A  48      22.215  11.772  16.577  1.00 20.00           H
ATOM    698  N   LYS A  49      24.001  13.024  15.362  1.00 20.00           N
ATOM    699  CA  LYS A  49      24.899  13.751  14.478  1.00 20.00           C
ATOM    700  C   LYS A  49      25.048  12.977  13.176  1.00 20.00           C
ATOM    701  O   LYS A  49      24.644  11.816  13.066  1.00 20.00           O
ATOM    702  CB  LYS A  49      26.269  13.976  15.130  1.00 20.00           C
ATOM    703  CG  LYS A  49      27.039  12.696  15.411  1.00 20.00           C
ATOM    704  CD  LYS A  49      27.915  12.304  14.233  1.00 20.00           C
ATOM    705  CE  LYS A  49      28.765  11.085  14.553  1.00 20.00           C
ATOM    706  NZ  LYS A  49      29.614  10.676  13.400  1.00 20.00           N
ATOM    707  H   LYS A  49      24.099  12.010  15.302  1.00 20.00           H
ATOM    708  HA  LYS A  49      24.467  14.725  14.248  1.00 20.00           H
ATOM    709  HB2 LYS A  49      26.877  14.590  14.465  1.00 20.00           H
ATOM    710  HB3 LYS A  49      26.125  14.493  16.079  1.00 20.00           H
ATOM    711  HG2 LYS A  49      27.680  12.845  16.280  1.00 20.00           H
ATOM    712  HG3 LYS A  49      26.334  11.885  15.598  1.00 20.00           H
ATOM    713  HD2 LYS A  49      27.283  12.065  13.378  1.00 20.00           H
ATOM    714  HD3 LYS A  49      28.583  13.131  13.989  1.00 20.00           H
ATOM    715  HE2 LYS A  49      29.421  11.317  15.393  1.00 20.00           H
ATOM    716  HE3 LYS A  49      28.112  10.251  14.806  1.00 20.00           H
ATOM    717  HZ1 LYS A  49      30.181   9.842  13.654  1.00 20.00           H
ATOM    718  HZ2 LYS A  49      29.014  10.443  12.583  1.00 20.00           H
ATOM    719  HZ3 LYS A  49      30.254  11.453  13.138  1.00 20.00           H
ATOM    720  N   GLY A  50      25.635  13.636  12.182  1.00 20.00           N
ATOM    721  CA  GLY A  50      25.845  13.027  10.883  1.00 20.00           C
ATOM    722  C   GLY A  50      26.940  13.709  10.086  1.00 20.00           C
ATOM    723  O   GLY A  50      28.030  13.960  10.599  1.00 20.00           O
ATOM    724  H   GLY A  50      25.976  14.595  12.251  1.00 20.00           H
ATOM    725  HA2 GLY A  50      26.117  11.979  11.013  1.00 20.00           H
ATOM    726  HA3 GLY A  50      24.921  13.073  10.307  1.00 20.00           H
TER
END
"""

def exercise(pdb_answer, pdb_poor, i_pdb=0, d_min=1., resolution_factor = 0.25):
  t = mmtbx.refinement.real_space.setup_test(
    pdb_answer        = pdb_answer,
    pdb_poor          = pdb_poor,
    i_pdb             = i_pdb,
    d_min             = d_min,
    resolution_factor = resolution_factor)
  #
  ph = t.ph_poor
  for i in [1,2,3]:
    result = mmtbx.refinement.real_space.fit_residues.run(
      pdb_hierarchy     = ph,
      vdw_radii         = t.vdw,
      crystal_symmetry  = t.crystal_symmetry,
      map_data          = t.target_map,
      backbone_sample   = True,
      rotatable_hd      = t.rotatable_hd,
      rotamer_manager   = t.rotamer_manager,
      sin_cos_table     = t.sin_cos_table,
      mon_lib_srv       = t.mon_lib_srv)
    ph = result.pdb_hierarchy
  result.pdb_hierarchy.write_pdb_file(file_name = "refined_%s.pdb"%str(i_pdb),
    crystal_symmetry = t.crystal_symmetry)
  #
  mmtbx.refinement.real_space.check_sites_match(
    ph_answer  = t.ph_answer,
    ph_refined = result.pdb_hierarchy,
    exclude_atom_names = ["CE1","CE2","CD1","CD2"],
    tol        = 0.3)

if(__name__ == "__main__"):
  t0 = time.time()
  inputs = [(pdb_str_answer_1,pdb_str_poor_1), ]
  for i_test, inp in enumerate(inputs):
    exercise(
      pdb_answer = inp[0],
      pdb_poor   = inp[1])
  print("Time: %6.4f"%(time.time()-t0))
