/*
  This file is part of CDO. CDO is a collection of Operators to manipulate and analyse Climate model Data.

  Author: Uwe Schulzweida

*/

#ifndef CDO_TASK_H
#define CDO_TASK_H

#include <thread>
#include <mutex>
#include <condition_variable>

namespace cdo
{

enum class TaskState
{
  SETUP,
  IDLE,
  JOB,
  DIE
};

class Task
{
public:
  void *(*routine)(void *) = nullptr;
  void *arg = nullptr;
  void *result = nullptr;
  TaskState state{ TaskState::SETUP };
  std::thread thread;
  std::mutex workMutex;
  std::mutex bossMutex;
  std::condition_variable workCond;
  std::condition_variable_any bossCond;

  Task();
  ~Task();
  void start(void *(*task_routine)(void *), void *task_arg);
  void *wait();
};

}  // namespace cdo

#endif /* CDO_TASK_H */
