/*-------------------------------------------------------------------------
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
ported to C++ by Csaba Balazs, University of Szeged
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than
Coco/R itself) does not fall under the GNU General Public License.
-------------------------------------------------------------------------*/

#if !defined(COCO_SYMBOL_H__)
#define COCO_SYMBOL_H__

#include "Position.h"
#include "Scanner.h"

namespace Coco {

class Node;
class BitArray;

class Symbol {
public:
	// token kinds
	static int fixedToken;    // e.g. 'a' ('b' | 'c') (structure of literals)
	static int classToken;    // e.g. digit {digit}   (at least one char class)
	static int litToken;      // e.g. "while"
	static int classLitToken; // e.g. letter {letter} but without literals that have the same structure*/

	int      n;           // symbol number
	int      typ;         // t, nt, pr, unknown, rslv /* ML 29_11_2002 slv added */ /* AW slv --> rslv */
	wchar_t  *name;       // symbol name
	Node     *graph;      // nt: to first node of syntax graph
	int      tokenKind;   // t:  token kind (fixedToken, classToken, ...)
	bool     deletable;   // nt: true if nonterminal is deletable
	bool     firstReady;  // nt: true if terminal start symbols have already been computed
	BitArray *first;      // nt: terminal start symbols
	BitArray *follow;     // nt: terminal followers
	BitArray *nts;        // nt: nonterminals whose followers have to be added to this sym
	int      line;        // source text line number of item in this node
	Position *attrPos;    // nt: position of attributes in source text (or null)
	Position *semPos;     // pr: pos of semantic action in source text (or null)
	                      // nt: pos of local declarations in source text (or null)


	Symbol(int typ, const wchar_t* name, int line);
	virtual ~Symbol();
};

}; // namespace

#endif // !defined(COCO_SYMBOL_H__)
