DACSRLINK(1)                 DACS Commands Manual                 DACSRLINK(1)



[1mNAME[0m
       dacsrlink - create and administer rule links

[1mSYNOPSIS[0m
       [1mdacsrlink [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [4mop[24m [[4marg[24m...]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacsrlink [22mcommand is used to create and manage specially
       constructed URLs called Rlinks ([4mrule[24m [4mlinks[24m). Briefly, an Rlink is a URL
       that includes a special component called an Rname. The Rname identifies
       a specific [1mDACS [22maccess control rule that is to be used with the URL,
       disabling the usual ACL searching algorithm for the request. Although
       no searching for the rule is done, the named ACL must still exist and
       match the request, such as through a suitable url_pattern. As with any
       access control rule, arbitrary expressions can be evaluated before
       access to the URL is allowed (or denied), including client redirection.

       An Rlink is handled by [34m[1mdacs_acs(8)[0m[1m[22m[2] during authorization checking.
       Because ACL searching is not performed for the request, Rlink
       processing can be more efficient. While the syntax of these rules is
       identical to that of normal access rules ([34m[1macl.dtd[0m[1m[22m[3]), not administered
       by [34m[1mdacsacl(1)[0m[1m[22m[4] and they are not indexed.

       A given resource may be referenced by Rlinks with different Rnames.
       Each instance of an Rlink for the resource may therefore have different
       access rights or cause different side effects. Depending on the
       application, the creator of an Rlink may expect it to be kept secret by
       everyone that receives it, resulting in a weak (though often
       sufficient) method of access control.

       There are many applications of Rlinks. They can be used to provide:

       +o   identity-restricted access to a resource without having to create
           per-identity accounts; when the Rlink is invoked (optionally
           accompanied by a password bound to the URL), the identity is
           available to the access control rule and an invoked web service
           just as if "real" [1mDACS [22mcredentials had been used;

       +o   a convenient, user-friendly acknowledgement mechanism that has a
           weak degree of security; e.g., by creating a link that a user can
           click on to continue an account registration step or confirm
           reading a licensing agreement;

       +o   a link that can be used for user tracking;

       +o   a way to override or customize another rule without modifying the
           original rule;

       +o   access to a resource with per-user constraints; e.g., to restrict
           access to a file or application for a particular user to a given
           time, date, or duration;

       +o   a simple front end for creating ordinary access control rules.


       A [1mDACS [22midentity may be attached to an Rlink through the command's rlink
       and rname operations. When an Rlink with an attached identity is used,
       that identity is available to [34m[1mdacs_acs[0m[1m[22m[2] for access control purposes.
       There are two modes of attachment: [4mdirect[24m and [4mindirect[24m. Identities for
       use with the direct mode are encrypted using the jurisdiction_keys item
       type (see [34m[1mdacskey(1)[0m[1m[22m[5]); the program's user must therefore be able to
       read these keys. Changing these keys will invalidate all existing
       encrypted identities. Refer to the [34m[1mimode[0m[1m[22m[6] flag for details.

       The identity associated with an Rlink need not exist outside of its use
       by the Rlink.

       The special, temporary credentials associated with an Rlink have the
       authentication style "rlink" (refer to [34m[1muser()[0m[1m[22m[7] with the style
       keyword), but not passwd, even if a password is required to gain access
       to a resource.

       For additional information, refer to the description of the [34m[1mRLINK[0m[1m[22m[8]
       configuration directive and [34m[1mdacs_acs(8)[0m[1m[22m[9].

[1mOPTIONS[0m
       [1mdacsrlink [22mrecognizes the standard [34m[4mdacsoptions[0m[4m[24m[1], which are immediately
       followed by an operation name ([4mop[24m), various operation-dependent flags,
       and finally non-flag arguments. The [1m-- [22mflag can be used to terminate
       the operation-dependent list of flags. Flags that are not recognized by
       the selected operation are ignored. A rule is always syntax checked (as
       by [34m[1mdacsacl(1)[0m[1m[22m[4]) before being written; if an error is found, the
       operation is aborted. Several flags are recognized by more than one
       operation.

       By default, the virtual filestore item type rlinks specifies where
       Rlinks are stored. This can be overridden for most operations by giving
       the [1m-vfs [22mflag, which can specify a [1mDACS [22mURI, alternate item type, or
       absolute pathname.

           [1mSecurity[0m
           Access to the rules and to listings of their names must be
           restricted, otherwise Rnames could be revealed. Only a [1mDACS[0m
           administrator should be permitted to list, create, modify, delete,
           etc. rules.  [1mdacs_acs [22mmust be able to access the rules if Rlinks
           are enabled. Ensure that file permissions are set appropriately.

       The optional [1m-out [22mflag is followed by a filename to which the rule
       should be written instead of a filestore. If "-" is given as the
       filename, the standard output is used.

       The default alphabet used to generate Rnames can be overridden using
       the [1m-ralpha [22mflag; [4malpha[24m, which follows the flag, is a character
       specification in the syntax of [34m[1mstrtr()[0m[1m[22m[10] (e.g., "a-zA-Z0-9", which is
       the default). The default length of an Rname can be overridden using
       the [1m-rlen [22mflag. Alternatively, some operations take a [1m-rname [22mflag that
       specifies the Rname to use.

       The following [4mop[24m arguments are understood:

           Perform a syntax check on the rule identified by [4mrname[24m to the
           standard output. If no error is found, an exit status of 0 is
           returned, otherwise an error message is produced and 1 is returned.

           Create a new Rname that is virtually identical to that of [4mrname[0m
           (only the name differs). If the [1m-rname [22mflag is given, use [4mrname[24m as
           the Rname instead of generating one.

       [{[1m-a [22m| [1m-allow[22m}[4mname[24m] [{[1m-p [4m[22mpassword[24m} | {[1m-pf [4m[22mfile[24m}]...
       [[1m-palg [4m[22malg-name[24m] [[1m-r [4m[22mredirect-URL[24m] [[1m-rname [4m[22mrname[24m] [[1m-ralpha [4m[22malpha[24m]
       [[1m-rlen [4m[22mlen[24m]
       [[1m-expires [22m{[4mseconds[24m | [4mdate[24m}] [4mpath[24m... .fam
           Create a new, enabled Rlink and write it to either the filestore, a
           specified file, or the standard output. The optional [1m-a [22m(or [1m-allow[22m)
           flag is followed by [4mname[24m, which is a string that will become the
           argument to the [34m[1muser()[0m[1m[22m[11] function that will be called from the
           allow clause of the ACL that is created. Each [4mname[24m will therefore
           be granted access to each of the named [4mpath[24m arguments, which are
           URI path components relative to the current jurisdiction.

           A password that applies only to this user can optionally follow as
           the next argument using a [1m-p [22mor [1m-pf [22mflag; its hashed value will be
           embedded in the Rlink and compared against a hash of an argument
           named [4mPASSWORD[24m that must be submitted with the Rlink. If a [1m-p [22mor
           [1m-pf [22mflag [4mprecedes[24m any [1m-a [22m([1m-allow[22m) flag, however, it establishes a
           default password for all users specified [4mlater[24m on the command line.
           The [1m-pf [22mflag is followed by a filename from which the password is
           read; if [4mfile[24m is "-", the password is read from the standard input.
           A password may be specified even if no [1m-a [22mflag is present; the
           request will not have an identity bound to it but a valid [4mPASSWORD[0m
           argument must be provided. The [1m-palg [22mflag overrides the default
           password hashing algorithm (see [34m[1mpassword()[0m[1m[22m[12]).

           If the [1m-rname [22mflag is given, [4mrname[24m is used as the Rname instead of
           generating one. The [1m-expires [22mflag assigns an expires_expr attribute
           to the Rlink, which will render the Rlink invalid after the
           specified date. The flag is followed either by an unsigned integer,
           which is interpreted as a number of seconds in the future, or a
           date in one of the [34m[1mrecognized formats[0m[1m[22m[13].

           If the [1m-r [22mflag appears, no usernames can be specified. An attempt
           to access any of the resources associated with the Rlink will cause
           the client to be redirected to [4mredirect-URL[24m, which may contain a
           properly encoded query component. This lets an Rlink serve as a
           "short link", akin to the services provided by [34m[1mbitly.com[0m[1m[22m[14],
           [34m[1mTinyURL.com[0m[1m[22m[15], and many others. Refer to the [34m[1mredirect()[0m[1m[22m[16]
           function for additional information.

               [1mNote[0m
               Administrators should review the rule that is created. The
               [34m[1mshow[0m[1m[22m[17] operation can be used to display the rule and the
               [34m[1medit[0m[1m[22m[18] operation can be used to modify it.

           Delete the Rname named [4mrname[24m in the selected filestore. This will
           effectively nullify all Rlinks that reference [4mrname[24m. To temporarily
           disable all Rlinks that reference an Rname, edit the rule and
           change its status attribute to disabled.

           Interactively edit a copy of the rule named [4mrname[24m in the selected
           filestore. If the environment variable [1mEDITOR [22mis set, it is used as
           the name of the editor to use, otherwise the compile time symbol
           DEFAULT_EDITOR is used. When editing is completed, the rule is
           replaced with the edited copy, provided the new version is
           syntactically correct.

           Decode and print [4mrname-ident[24m, an Rname with an identity component
           produced by the [1mrlink [22mor [1mrname [22moperations.

           Print a listing of all Rnames in the selected filestore.

           Emit an Rlink to the standard output that integrates [4mrname[24m into the
           [4muri[24m according to [4mlink-mode[24m. The [4mlink-mode[24m is one of dacs_acs (or
           just acs), query, or path, representing the three general forms of
           an Rlink. If [4mident[24m is specified, it describes a user in the [34m[1mconcise[0m
           [1m[34muser syntax[0m[1m[22m[19] that is associated with the link. The [4mident[24m may
           include an expiry date.

           The [1m-imode [22mspecifies whether a direct or indirect identity should
           be associated with the Rname, or whether there is none (the
           default). For direct, [4mident[24m (specified by [1m-i [22mor [1m-ident[22m) is used; it
           describes an identity in the [34m[1mconcise user syntax[0m[1m[22m[19] that is
           associated with the link. For the indirect mode, a random
           identifier is generated (using the same algorithm selected for
           Rnames); if the [1m-iptr [22mflag is given, however, [4miptr[24m is used as the
           identifier string.

           If [4muri[24m is a URI path component (i.e., it begins with a '/'), the
           configuration variable [4mrlink_base_prefix[24m must be defined; its value
           is prepended to the URI path.

           Additional query arguments can be attached to the emitted link. If
           a password is required by the ACL for the resource, for example, a
           [4mPASSWORD[24m argument is required.

           Implementation of query and path modes is incomplete, so URLs for
           those Rlinks must be generated manually.

       [[1m-rname [4m[22mrname[24m] .fam
           This operation emits an Rname that satisfies the given constraints
           and prints it to the standard output. The Rname is suitable for use
           with the [1m-rname [22mflag. It does not create an ACL. This operation
           might be useful when Rlinks are created manually or using another
           program.

           The [1m-imode[22m, [1m-i[22m, and [1m-iptr [22mflags are as described for the [1mrlink[0m
           operation.

           Print the rule identified by [4mrname[24m to the standard output.

[1mEXAMPLES[0m
       The following examples assume that the jurisdiction EXAMPLE includes
       the following configuration:

           RLINK '"${Args::RNAME:?}" /usr/local/dacs/rlinks'
           EVAL   ${Conf::rlink_base_prefix} = "https://www.example.com"
           VFS    "[rlinks]file:///usr/local/dacs/rlinks"

       These directives enable Rlink processing by [34m[1mdacs_acs(8)[0m[1m[22m[2] and cause
       URLs generated by [1mdacsrlink [22mto be prefixed by https://www.example.com.
       ACLs that it creates will be stored as files in the
       /usr/local/dacs/rlinks directory.

       This command creates an Rname called IRCl7p4Q, and associates it with
       the relative URL /cgi-bin/dacs/dacs_prenv. The Rname will expire in 300
       seconds (relative to this jurisdiction's clock):

           % dacsrlink -uj EXAMPLE create -expires 300 /cgi-bin/dacs/dacs_prenv
           IRCl7p4Q

       Once an Rname has been created, a URL can be generated that
       incorporates the Rname:

           % dacsrlink -uj EXAMPLE rlink -lmode acs IRCl7p4Q /cgi-bin/dacs/dacs_prenv
           https://www.example.com/cgi-bin/dacs/dacs_prenv?DACS_ACS=-rname+IRCl7p4Q

       In this example, the Rname has been incorporated into the URL through
       the [34m[1mDACS_ACS argument[0m[1m[22m[20].

       To display the ACL for Rname IRCl7p4Q:

           % dacsrlink -uj EXAMPLE show IRCl7p4Q
           <acl_rule status="enabled" name="IRCl7p4Q" expires_expr='time(now) ge 1178917167'>
             <services>
               <service url_pattern="/cgi-bin/dacs/dacs_prenv"/>
             </services>

             <rule order="allow,deny">
              <allow>
              </allow>
             </rule>
           </acl_rule>

       Or, since the access control rule created by [1mdacsrlink [22mcan be found in
       /usr/local/dacs/rlinks:

           % cat /usr/local/dacs/rlinks/IRCl7p4Q

       The default rule for [34m[1mdacs_prenv(8)[0m[1m[22m[21] restricts access to a [1mDACS[0m
       administrator, but anyone who uses this Rlink before it expires will be
       granted access to [1mdacs_prenv[22m. This rule can be manually customized at
       anytime. Note that unlike ordinary access control rules, there is no
       index file for Rlinks.

       Suppose Rname 8D8m5CTj is this ACL:

           <acl_rule status="enabled" name="8D8m5CTj">
             <services>
               <service url_pattern="/cgi-bin/dacs/special"/>
             </services>

             <rule order="allow,deny">
             <deny>
               if (${Args::EMAIL} == "bob@example.com") {
                 redirect(BY_SIMPLE_REDIRECT, "http://dss.ca")
               }
               else {
                 redirect(BY_SIMPLE_REDIRECT, "http://metalogicsoftware.ca")
               }
             </deny>
             </rule>
           </acl_rule>

       While it is not required to use [1mdacsrlink[22m, a command like the following
       might be used to conveniently construct a URL:

           % dacsrlink -uj EXAMPLE rlink -lmode acs 8D8m5CTj '/cgi-bin/dacs/special?EMAIL=bob@example.com'
           http://www.example.com/cgi-bin/dacs/special?DACS_ACS=-rname+8D8m5CTj&EMAIL=bob@example.com

       In this example, a user who submits the link would be redirected to
       http://dss.ca. As usual, a resource corresponding to the path
       /cgi-bin/dacs/special does not need to actually exist at the
       jurisdiction. This ACL can be generalized to examine the request and
       other context and perform arbitrary actions, perhaps by using an
       external program - see [34m[1mexec()[0m[1m[22m[22]. A [34m[1mlinkback[0m[1m[22m[23] can be implemented in
       this way, for instance.

       This command creates a rule that applies to two resources and grants
       access to two users:

           % dacsrlink -uj EXAMPLE create -a :auggie -a :harley /private/a.html /private/b.html
           7tW3SJou
           % dacsrlink -uj EXAMPLE show 7tW3SJou
           <acl_rule status="enabled" name="7tW3SJou">
             <services>
                 <service url_pattern="/private/a.html"/>
                 <service url_pattern="/private/b.html"/>
             </services>
             <rule order="allow,deny">
              <allow>
                  user(":auggie")
              </allow>
              <allow>
                  user(":harley")
              </allow>
             </rule>
           </acl_rule>

       To generate URLs to give to these two users so that they can access
       these resource, commands like the following would be used:

           % dacsrlink -uj EXAMPLE rlink -imode direct -i ":auggie" -lmode acs 7tW3SJou /private/a.html
           https://www.example.com/private/a.html?DACS_ACS=-rname+7tW3SJou:HMGxWlccUihTtgbtJg
           % dacsrlink -uj EXAMPLE rlink -imode direct -i ":harley" -lmode acs 7tW3SJou /private/b.html
           https://www.example.com/private/b.html?DACS_ACS=-rname+7tW3SJou:qouYfT7pdwuLXHxodxE2

       When the first of these links is invoked, it will appear as if
       EXAMPLE:auggie is accessing a.html. Since no expiration was specified
       for the identities or the resources, the two links will be valid
       indefinitely. The rule can be deleted at any time:

           % dacsrlink -uj EXAMPLE delete 7tW3SJou

       This demonstrates how to create a password-controlled link:

           % dacsrlink -uj EXAMPLE create -a :auggie -p abracadabra /private/c.txt
           rIPZaJeN
           % dacsrlink -uj EXAMPLE show rIPZaJeN
           <acl_rule status="enabled" name="rIPZaJeN">
             <services>
                 <service url_pattern="/private/c.html"/>
             </services>
             <rule order="allow,deny">
              <allow>
                  user(":auggie")
                  and password(check, ${Args::PASSWORD}, "2|XYZZYnahdnl3VtLqGtpbW|2GoDncq34p2EMO4PA5Uj6iWkFb9")
              </allow>
             </rule>
           </acl_rule>
           % dacsrlink -uj EXAMPLE rlink -imode direct -i :auggie -lmode acs rIPZaJeN /private/c.txt
           https://www.example.com/private/c.txt?DACS_ACS=-rname+rIPZaJeN:r6RdcTcmUyhTtgbtJg
           % dacshttp "https://www.example.com/private/c.txt?DACS_ACS=-rname+rIPZaJeN:r6RdcTcmUyhTtgbtJg&PASSWORD=abracadabra"
           Hello, world


[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacs.acls(5)[0m[1m[22m[24], [34m[1mdacs_acs(8)[0m[1m[22m[2]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[25])

[1mCOPYING[0m
       Copyright (C) 2003-2014 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[26] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        3. acl.dtd
           http://dacs.dss.ca/man/../dtd-xsd/acl.dtd

        4. dacsacl(1)
           http://dacs.dss.ca/man/dacsacl.1.html

        5. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

        6. imode
           http://dacs.dss.ca/man/#imode

        7. user()
           http://dacs.dss.ca/man/dacs.exprs.5.html#user.style

        8. RLINK
           http://dacs.dss.ca/man/dacs.conf.5.html#RLINK

        9. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html#rlinks

       10. strtr()
           http://dacs.dss.ca/man/dacs.exprs.5.html#strtr

       11. user()
           http://dacs.dss.ca/man/dacs.exprs.5.html#user

       12. password()
           http://dacs.dss.ca/man/dacs.exprs.5.html#password

       13. recognized formats
           http://dacs.dss.ca/man/dacs.1.html#date_formats

       14. bitly.com
           https://bitly.com

       15. TinyURL.com
           http://tinyurl.com

       16. redirect()
           http://dacs.dss.ca/man/dacs.exprs.5.html#redirect

       17. show
           http://dacs.dss.ca/man/#show_op

       18. edit
           http://dacs.dss.ca/man/#edit_op

       19. concise user syntax
           http://dacs.dss.ca/man/dacs.1.html#concise_user_syntax

       20. DACS_ACS argument
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_acs_argument

       21. dacs_prenv(8)
           http://dacs.dss.ca/man/dacs_prenv.8.html

       22. exec()
           http://dacs.dss.ca/man/dacs.exprs.5.html#exec

       23. linkback
           http://en.wikipedia.org/wiki/Linkback

       24. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

       25. www.dss.ca
           http://www.dss.ca

       26. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.38a                      11/23/2016                      DACSRLINK(1)
