# debos-docker

Docker container for ['debos' tool](https://github.com/go-debos/debos).

## Installation
```
docker pull debos/debos-docker
```

Debos needs virtualization to be enabled on the host and shared with the container.

Check that `kvm` is enabled by running ```ls /dev/kvm```

## Usage
To build `recipe.yaml`:
```
cd <PATH_TO_RECIPE_DIR>
docker run --rm --device /dev/kvm --group-add $(getent group kvm | cut -d: -f3) -w /recipes -u $(id -u) -i -v $(pwd):/recipes -t debos/debos-docker debos <RECIPE.yaml>
```

## Container build
To build the debos-docker container image from current git branch:
```
docker build -f docker/Dockerfile -t debos/debos-docker .
```

## Tests

### unit tests
Run unit test with debos-docker:
```
cd docker
docker-compose -f unit-tests.test.yml up --build
```
