#!/bin/sh
# Copyright 2025 Helmut Grohne <helmut@subdivi.de>
# SPDX-License-Identifier: MIT
#
# This is a mmdebstrap customize hook that deletes the password for the root
# account effectively enabling login without being asked for a password.

set -eu

TARGET=$1

# In future, we should use passwd --prefix "$1" --delete root here, but the
# --prefix option was added in trixie and the --root option uses chroot() and
# attempts to load shared libraries from a potentially foreign chroot.

PWFILE=passwd
if grep -q '^root:x:' "$TARGET/etc/passwd"; then
	PWFILE=shadow
fi
sed -i -e "s/^root:[^:]*:/root::/" "$TARGET/etc/$PWFILE"
