#!/usr/bin/python3
"""
Test Driver for dh_fortran_lib

Copyright (C) 2025 Alastair McKinstry <mckinstry@debian.org>
Released under the GPL-3 Gnu Public License.
"""

from click.testing import CliRunner
from dhfortran.lib import dh_fortran_lib, get_soname
from dhfortran.compilers import multiarch
import dhfortran.debhelper as dh
import dhfortran.tests.helpers as helpers
import pytest
import os


@pytest.fixture()
def set_env():
    os.environ["NO_ACT"] = "1"

def test_get_soname():
    """ soname helper """
    libdir= f"/usr/lib/{multiarch}"
    (major, soname,ext ) = get_soname(f"{libdir}/libm.so.6")
    assert soname == "libm.so.6"
    assert major == "6"
    assert ext == ".6"
    (major, soname, ext) = get_soname(f"{libdir}/libgccpp.so.1.5.0")
    assert major == "1"
    assert soname == "libgccpp.so.1"
    assert ext == ".1.5.0"
    

def test_dh_fortran_lib():
    """Install libs in appropriate directory"""
    # helpers.chdir_to_test('tests/pkg')
    runner = CliRunner()
    result = runner.invoke(dh_fortran_lib, [])
    assert result.exit_code == 0
    # assert result.output == 'Hello Peter!\n'


def test_dh_fortran_lib_files_nopkg():
    """Install libs in appropriate directory"""
    # helpers.chdir_to_test('tests/pkg')
    runner = CliRunner()
    result = runner.invoke(dh_fortran_lib, ["debian/tmp/foo"])
    print (result.output)
    assert result.exit_code == 0
    # assert result.output == 'Hello Peter!\n'



if __name__ == "__main__":
    import pytest

    pytest.main()
