/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * @file diagnostics/basic_exceptions/parse_error.cpp
 *
 * @brief Interface @ref ::diagnostics::Parse_Error.
 *
 * $Id: parse_error.cpp 296 2007-11-27 00:21:41Z tautschn $
 *
 * @author Christian Schallhart <schallha@in.tum.de>
 * @date   Thu Nov 23 08:19:41 CET 2006
*/

#include <diagnostics/basic_exceptions/parse_error.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;


Parse_Error::~Parse_Error() DIAGNOSTICS_EXCEPTIONS_THROW_DECL
{
}

Parse_Error::Parse_Error(::std::string const & what)
	: Low_Level_Exception(what)
{
}

Parse_Error::Parse_Error(Self const & other)
	: Low_Level_Exception(other)
{
}


char const * Parse_Error::name() const
{
	return "Parse_Error";
}



DIAGNOSTICS_NAMESPACE_END;

