/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/test_data_adaptor.ts.cpp
 *
 * @brief [LEVEL: beta] Implementation of the compliance test for
 * @ref diagnostics::unittest::Test_Data_Adaptor
 *
 * $Id: test_data_adaptor.ts.cpp,v 1.11 2005/06/23 09:54:26 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#include <diagnostics/unittest/test_system/test_data_adaptor.ts.hpp>

// used components
#include <diagnostics/unittest/test_system/test_data_adaptor.hpp>
#include <diagnostics/unittest/test_system_exception.hpp>

// test support
#include <diagnostics/util/dummy_test_data_source.ts.hpp>


DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

Test_Data_Adaptor_Compliance::Test_Data_Adaptor_Compliance(Test_Data_Adaptor * const adaptor)
    : m_adaptor(adaptor)
{
}


Test_Data_Adaptor_Compliance::Test_Data_Adaptor_Compliance(Self const & other)
    : m_adaptor(other.m_adaptor)
{
}

Test_Data_Adaptor_Compliance & Test_Data_Adaptor_Compliance::operator=(Self const & other)
{
    m_adaptor=other.m_adaptor;
    return *this;
}


void Test_Data_Adaptor_Compliance::operator()(Test_Data & test_data) const
{
    Dummy_Test_Data_Source source;
    
    // copy for later comparision
    Dummy_Test_Data_Source::Data_t const data(source.data());

    // backend()==NULL after construction
    TEST_ASSERT(m_adaptor->backend()==NULL);

    // get() throws if backend()==NULL
    TEST_THROWING_BLOCK_ENTER;
    m_adaptor->get("1");
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);
    
    // attach(NULL) throws and does not change backend()
    TEST_THROWING_BLOCK_ENTER;
    m_adaptor->attach(NULL);
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);
    TEST_ASSERT(m_adaptor->backend()==NULL);
    
    // attach(&source) --> backend()==&source and get does not throw
    m_adaptor->attach(&source);
    TEST_ASSERT(m_adaptor->backend()==&source);

    // attach(NULL) throws and does not change backend()
    TEST_THROWING_BLOCK_ENTER;
    m_adaptor->attach(NULL);
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);
    TEST_ASSERT(m_adaptor->backend()==&source);


    // we can access the 1
    TEST_ASSERT(m_adaptor->get("1")=="A");

    // compare data of Test_Data_Source
    TEST_ASSERT(data==source.data());
}



TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
// vim:ts=4:sw=4
