/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __STRENGTH_EDITOR
#define __STRENGTH_EDITOR

#include "curve_editor.h"
#include <string>
using namespace std;

struct note_marker {

  string note_name;
  int x;
  static int ybot, ytop;
  static int clearance;

};

struct din;

struct strength_editor : curve_editor {

  din* d;

  vector<note_marker> note_markers;

  int selected_resonator;

  help helptext;

  void build_note_markers ();
  void draw_note_markers ();

  strength_editor (din* dd, string settings_file, string help_file);

  bool handle_input ();

  void select_curve (int i);
  void draw_selected_resonator ();
  void draw ();

};

#endif
