/*
FatRat download manager
http://fatrat.dolezel.info

Copyright (C) 2006-2008 Lubos Dolezel <lubos a dolezel.info>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2 as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "SettingsCzshare.h"
#include <fatrat/fatrat.h>
#include <fatrat/Settings.h>
#include <QFileDialog>

SettingsCzshare::SettingsCzshare(QWidget* me, QObject* p)
	: QObject(p)
{
	setupUi(me);
	
	connect(toolDownload, SIGNAL(clicked()), this, SLOT(browseDownload()));
	connect(toolKill, SIGNAL(clicked()), this, SLOT(browseKill()));
}

void SettingsCzshare::load()
{
	lineUsername->setText( getSettingsValue("czshare/username").toString() );
	linePassword->setText( getSettingsValue("czshare/password").toString() );
	linePartnerID->setText( getSettingsValue("czshare/partnerid").toString() );
	
	lineLinksDownload->setText( getSettingsValue("czshare/down_links").toString() );
	lineLinksKill->setText( getSettingsValue("czshare/kill_links").toString() );
}

void SettingsCzshare::accepted()
{
	setSettingsValue("czshare/username", lineUsername->text());
	setSettingsValue("czshare/password", linePassword->text());
	setSettingsValue("czshare/partnerid", linePartnerID->text());
	
	setSettingsValue("czshare/down_links", lineLinksDownload->text());
	setSettingsValue("czshare/kill_links", lineLinksKill->text());
}

void SettingsCzshare::browse(QLineEdit* target)
{
	QString _new = QFileDialog::getSaveFileName(getMainWindow(), "FatRat", target->text());
	if(!_new.isEmpty())
		target->setText(_new);
}

void SettingsCzshare::browseDownload()
{
	browse(lineLinksDownload);
}

void SettingsCzshare::browseKill()
{
	browse(lineLinksKill);
}
