/* $Id: CompileError.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __COMPILE_ERROR_HPP_INCLUDED
#define __COMPILE_ERROR_HPP_INCLUDED

#include <string>
#include <iostream>
#include "frontend/ast/AstNode.hpp"

namespace ast {

//! base class for all Compile errors/warnings.
class CompileError {
public:
	//! c'tor
	/** @param node AstNode which contains the error.
	 *  @param msg error message.
	 */
	CompileError(
		const AstNode &node,
		std::string msg
		) :	location(node.location),
			message(msg) {}

	//! alternate c'tor
	/** @param loc location of the error
	 *  @param msg error message
	 */
	CompileError(
		Location loc,
		std::string msg
		) : 	location(loc), message(msg) {}

	//! dummy d'tor
	virtual ~CompileError() {}

	//! write error to stream.
	/** @param stream write the compile error to this stream.
	 */
	virtual void put(std::ostream &stream) const;
	
protected:
	/** location of the error */
	Location location;
	/** error message */
	std::string message;
};

/** overload << operator for convenience.
 *  @param stream stream where the error should be written to.
 *  @param err CompileError that should be put to stream
 *  @return stream to which the error was written to.
 */
std::ostream& 
operator<<(std::ostream& stream, const CompileError& err);

}; /* namespace ast */

#endif /* __COMPILE_ERROR_HPP_INCLUDED */
