/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.util.List;
import thredds.catalog.ServiceType;
import thredds.catalog2.Property;
import thredds.catalog2.Service;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.simpleImpl.GlobalServiceContainer;
import thredds.catalog2.simpleImpl.PropertyContainer;
import thredds.catalog2.simpleImpl.ServiceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceImpl
implements Service,
ServiceBuilder {
    private String name;
    private String description;
    private ServiceType type;
    private URI baseUri;
    private String suffix;
    private PropertyContainer propertyContainer;
    private ServiceContainer serviceContainer;
    private final GlobalServiceContainer globalServiceContainer;
    private final boolean isRootContainer;
    private boolean isBuilt = false;

    ServiceImpl(String name, ServiceType type, URI baseUri, GlobalServiceContainer globalServiceContainer) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Service type must not be null.");
        }
        if (baseUri == null) {
            throw new IllegalArgumentException("Base URI must not be null.");
        }
        this.name = name;
        this.description = "";
        this.type = type;
        this.baseUri = baseUri;
        this.suffix = "";
        this.propertyContainer = new PropertyContainer();
        if (globalServiceContainer == null) {
            this.isRootContainer = true;
            this.globalServiceContainer = new GlobalServiceContainer();
        } else {
            this.isRootContainer = false;
            this.globalServiceContainer = globalServiceContainer;
        }
        this.serviceContainer = new ServiceContainer(this.globalServiceContainer);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String description) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        this.description = description != null ? description : "";
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setType(ServiceType type) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Service type must not be null.");
        }
        this.type = type;
    }

    @Override
    public ServiceType getType() {
        return this.type;
    }

    @Override
    public void setBaseUri(URI baseUri) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        if (baseUri == null) {
            throw new IllegalArgumentException("Base URI must not be null.");
        }
        this.baseUri = baseUri;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public void setSuffix(String suffix) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        this.suffix = suffix != null ? suffix : "";
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void addProperty(String name, String value) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        this.propertyContainer.addProperty(name, value);
    }

    @Override
    public boolean removeProperty(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        return this.propertyContainer.removeProperty(name);
    }

    @Override
    public List<String> getPropertyNames() {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        return this.propertyContainer.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        return this.propertyContainer.getPropertyValue(name);
    }

    @Override
    public List<Property> getProperties() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped from its ServiceBuilder before build() was called.");
        }
        return this.propertyContainer.getProperties();
    }

    @Override
    public Property getPropertyByName(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped from its ServiceBuilder before build() was called.");
        }
        return this.propertyContainer.getPropertyByName(name);
    }

    @Override
    public ServiceBuilder addService(String name, ServiceType type, URI baseUri) {
        return this.serviceContainer.addService(name, type, baseUri);
    }

    @Override
    public boolean removeService(ServiceBuilder serviceBuilder) {
        if (serviceBuilder == null) {
            return false;
        }
        return this.serviceContainer.removeService((ServiceImpl)serviceBuilder);
    }

    @Override
    public List<Service> getServices() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped from its ServiceBuilder without being built.");
        }
        return this.serviceContainer.getServices();
    }

    @Override
    public Service getServiceByName(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped from its ServiceBuilder without being built.");
        }
        return this.serviceContainer.getServiceByName(name);
    }

    @Override
    public Service findServiceByNameGlobally(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped its Builder before being built.");
        }
        return this.globalServiceContainer.getServiceByGloballyUniqueName(name);
    }

    @Override
    public List<ServiceBuilder> getServiceBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        return this.serviceContainer.getServiceBuilders();
    }

    @Override
    public ServiceBuilder getServiceBuilderByName(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        return this.serviceContainer.getServiceBuilderByName(name);
    }

    @Override
    public ServiceBuilder findServiceBuilderByNameGlobally(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been built.");
        }
        return this.globalServiceContainer.getServiceByGloballyUniqueName(name);
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public BuilderIssues getIssues() {
        BuilderIssues issues = this.serviceContainer.getIssues();
        if (this.isRootContainer) {
            issues.addAllIssues(this.globalServiceContainer.getIssues(this));
        }
        issues.addAllIssues(this.propertyContainer.getIssues());
        if (this.serviceContainer.isEmpty() && this.baseUri == null) {
            issues.addIssue(BuilderIssue.Severity.WARNING, "Non-compound services must have base URI.", this, null);
        }
        return issues;
    }

    @Override
    public Service build() throws BuilderException {
        if (this.isBuilt) {
            return this;
        }
        this.propertyContainer.build();
        this.serviceContainer.build();
        this.isBuilt = true;
        return this;
    }
}

