/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.icc;

import java.io.IOException;
import ucar.jpeg.colorspace.ColorSpace;
import ucar.jpeg.colorspace.ColorSpaceException;
import ucar.jpeg.colorspace.ColorSpaceMapper;
import ucar.jpeg.icc.ICCMatrixBasedInputProfile;
import ucar.jpeg.icc.ICCMonochromeInputProfile;
import ucar.jpeg.icc.ICCProfile;
import ucar.jpeg.icc.ICCProfileException;
import ucar.jpeg.icc.RestrictedICCProfile;
import ucar.jpeg.icc.lut.MatrixBasedTransformException;
import ucar.jpeg.icc.lut.MatrixBasedTransformTosRGB;
import ucar.jpeg.icc.lut.MonochromeTransformException;
import ucar.jpeg.icc.lut.MonochromeTransformTosRGB;
import ucar.jpeg.jj2000.j2k.image.BlkImgDataSrc;
import ucar.jpeg.jj2000.j2k.image.DataBlk;
import ucar.jpeg.jj2000.j2k.image.DataBlkFloat;
import ucar.jpeg.jj2000.j2k.image.DataBlkInt;
import ucar.jpeg.jj2000.j2k.util.FacilityManager;

public class ICCProfiler
extends ColorSpaceMapper {
    public static final char OPT_PREFIX = 'I';
    protected static final String eol = System.getProperty("line.separator");
    private static final int GRAY = 0;
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    RestrictedICCProfile ricc = null;
    ICCProfile icc = null;
    private DataBlkInt[] tempInt;
    private DataBlkFloat[] tempFloat;
    private Object xform = null;
    private RestrictedICCProfile iccp = null;

    public static BlkImgDataSrc createInstance(BlkImgDataSrc src, ColorSpace csMap) throws IOException, ICCProfileException, ColorSpaceException {
        return new ICCProfiler(src, csMap);
    }

    protected ICCProfiler(BlkImgDataSrc src, ColorSpace csMap) throws ColorSpaceException, IOException, ICCProfileException, IllegalArgumentException {
        super(src, csMap);
        this.initialize();
        this.iccp = this.getICCProfile(csMap);
        this.xform = this.ncomps == 1 ? new MonochromeTransformTosRGB(this.iccp, this.maxValueArray[0], this.shiftValueArray[0]) : new MatrixBasedTransformTosRGB(this.iccp, this.maxValueArray, this.shiftValueArray);
    }

    private void initialize() {
        this.tempInt = new DataBlkInt[this.ncomps];
        this.tempFloat = new DataBlkFloat[this.ncomps];
        for (int i = 0; i < this.ncomps; ++i) {
            this.tempInt[i] = new DataBlkInt();
            this.tempFloat[i] = new DataBlkFloat();
        }
    }

    private RestrictedICCProfile getICCProfile(ColorSpace csm) throws ColorSpaceException, ICCProfileException, IllegalArgumentException {
        switch (this.ncomps) {
            case 1: {
                this.icc = ICCMonochromeInputProfile.createInstance(csm);
                this.ricc = this.icc.parse();
                if (this.ricc.getType() == 0) break;
                throw new IllegalArgumentException("wrong ICCProfile type for image");
            }
            case 3: {
                this.icc = ICCMatrixBasedInputProfile.createInstance(csm);
                this.ricc = this.icc.parse();
                if (this.ricc.getType() == 1) break;
                throw new IllegalArgumentException("wrong ICCProfile type for image");
            }
            default: {
                throw new IllegalArgumentException("illegal number of components (" + this.ncomps + ") in image");
            }
        }
        return this.ricc;
    }

    public DataBlk getCompData(DataBlk outblk, int c) {
        try {
            if (this.ncomps != 1 && this.ncomps != 3) {
                String msg = "ICCProfiler: icc profile _not_ applied to " + this.ncomps + " component image";
                FacilityManager.getMsgLogger().printmsg(2, msg);
                return this.src.getCompData(outblk, c);
            }
            int type = outblk.getDataType();
            int leftedgeOut = -1;
            int rightedgeOut = -1;
            int leftedgeIn = -1;
            int rightedgeIn = -1;
            block11: for (int i = 0; i < this.ncomps; ++i) {
                int fixedPtBits = this.src.getFixedPoint(i);
                int shiftVal = this.shiftValueArray[i];
                int maxVal = this.maxValueArray[i];
                int kOut = -1;
                int kIn = -1;
                switch (type) {
                    case 3: {
                        int row;
                        ICCProfiler.copyGeometry(this.workInt[i], outblk);
                        ICCProfiler.copyGeometry(this.tempInt[i], outblk);
                        ICCProfiler.copyGeometry(this.inInt[i], outblk);
                        ICCProfiler.setInternalBuffer(outblk);
                        this.workDataInt[i] = (int[])this.workInt[i].getData();
                        this.inInt[i] = (DataBlkInt)this.src.getInternCompData(this.inInt[i], i);
                        this.dataInt[i] = this.inInt[i].getDataInt();
                        for (row = 0; row < outblk.h; ++row) {
                            leftedgeIn = this.inInt[i].offset + row * this.inInt[i].scanw;
                            rightedgeIn = leftedgeIn + this.inInt[i].w;
                            leftedgeOut = outblk.offset + row * outblk.scanw;
                            rightedgeOut = leftedgeOut + outblk.w;
                            kOut = leftedgeOut;
                            kIn = leftedgeIn;
                            while (kIn < rightedgeIn) {
                                int tmpInt = (this.dataInt[i][kIn] >> fixedPtBits) + shiftVal;
                                this.workDataInt[i][kOut] = tmpInt < 0 ? 0 : (tmpInt > maxVal ? maxVal : tmpInt);
                                ++kIn;
                                ++kOut;
                            }
                        }
                        continue block11;
                    }
                    case 4: {
                        int row;
                        ICCProfiler.copyGeometry(this.workFloat[i], outblk);
                        ICCProfiler.copyGeometry(this.tempFloat[i], outblk);
                        ICCProfiler.copyGeometry(this.inFloat[i], outblk);
                        ICCProfiler.setInternalBuffer(outblk);
                        this.workDataFloat[i] = (float[])this.workFloat[i].getData();
                        this.inFloat[i] = (DataBlkFloat)this.src.getInternCompData(this.inFloat[i], i);
                        this.dataFloat[i] = this.inFloat[i].getDataFloat();
                        for (row = 0; row < outblk.h; ++row) {
                            leftedgeIn = this.inFloat[i].offset + row * this.inFloat[i].scanw;
                            rightedgeIn = leftedgeIn + this.inFloat[i].w;
                            leftedgeOut = outblk.offset + row * outblk.scanw;
                            rightedgeOut = leftedgeOut + outblk.w;
                            kOut = leftedgeOut;
                            kIn = leftedgeIn;
                            while (kIn < rightedgeIn) {
                                float tmpFloat = this.dataFloat[i][kIn] / (float)(1 << fixedPtBits) + (float)shiftVal;
                                this.workDataFloat[i][kOut] = tmpFloat < 0.0f ? 0.0f : (tmpFloat > (float)maxVal ? (float)maxVal : tmpFloat);
                                ++kIn;
                                ++kOut;
                            }
                        }
                        continue block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid source datablock type");
                    }
                }
            }
            switch (type) {
                case 3: {
                    if (this.ncomps == 1) {
                        ((MonochromeTransformTosRGB)this.xform).apply(this.workInt[c], this.tempInt[c]);
                    } else {
                        ((MatrixBasedTransformTosRGB)this.xform).apply(this.workInt, this.tempInt);
                    }
                    outblk.progressive = this.inInt[c].progressive;
                    outblk.setData(this.tempInt[c].getData());
                    break;
                }
                case 4: {
                    if (this.ncomps == 1) {
                        ((MonochromeTransformTosRGB)this.xform).apply(this.workFloat[c], this.tempFloat[c]);
                    } else {
                        ((MatrixBasedTransformTosRGB)this.xform).apply(this.workFloat, this.tempFloat);
                    }
                    outblk.progressive = this.inFloat[c].progressive;
                    outblk.setData(this.tempFloat[c].getData());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid source datablock type");
                }
            }
            outblk.offset = 0;
            outblk.scanw = outblk.w;
        }
        catch (MatrixBasedTransformException e) {
            FacilityManager.getMsgLogger().printmsg(3, "matrix transform problem:\n" + e.getMessage());
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                FacilityManager.getMsgLogger().printmsg(3, "Use '-debug' option for more details");
            }
            return null;
        }
        catch (MonochromeTransformException e) {
            FacilityManager.getMsgLogger().printmsg(3, "monochrome transform problem:\n" + e.getMessage());
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                FacilityManager.getMsgLogger().printmsg(3, "Use '-debug' option for more details");
            }
            return null;
        }
        return outblk;
    }

    public DataBlk getInternCompData(DataBlk out, int c) {
        return this.getCompData(out, c);
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("[ICCProfiler:");
        StringBuffer body = new StringBuffer();
        if (this.icc != null) {
            body.append(eol).append(ColorSpace.indent("  ", this.icc.toString()));
        }
        if (this.xform != null) {
            body.append(eol).append(ColorSpace.indent("  ", this.xform.toString()));
        }
        rep.append(ColorSpace.indent("  ", body));
        return rep.append("]").toString();
    }
}

