

	SUBROUTINE LINE_FACTS( lun, idim, grid, orient )

*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
* print basic facts about an axis defined in memory

* programmer - steve hankin
* NOAA/PMEL, Seattle, WA - Tropical Modeling and Analysis Program
* written for VAX computer under VMS operating system
*
* revision 0.0 - 8/1/88 - extracted from SHOW_GRID - axis limits --> box_middle
* revision 0.1 - 8/16/88 - elimiinated units, expanded title field
* revision 0.2 - 2/6/89 - added modulo axis indicator 
* V200:  9/22/89 - added "orient" for axes without particular orientations
* SUN port 3/92 *sh* - "T" format specifiers cannot move to left
*                    - changed format 3020
* V230:  6/22/92 - allow for long axis names by truncating the title field
*        1/93 - corrected left-over bug in format 3020 from SUN port A15->A14
* V320: 12/20/94 - Put "(-)" along with "m" and "r" so it doesn't get
*		truncated now that DEPTH(units) is the label
*       12/29/94 - use SPLIT_LIST to redirect tty output for GUI
* V510 *sh* 12/99 - show units even if line has no orientation
* V68  *acm 12/11 - if npts > 1.e7 the format overflowed. Up the size.

	include 'tmap_dims.parm'
	include 'xtm_grid.cmn_text'
	external xgt_grid_data
	include	'ferret.parm'
	include 'xtext_info.cmn'
	include 'xrisc.cmn'          ! 12/94 SPLIT_LIST buffer

* calling argument declarations
	INTEGER	  lun, idim, grid, orient

* local variable declarations:
	LOGICAL	BKWD_AXIS, GEOG_LABEL, calendar
	INTEGER TM_LENSTR1, lo, hi, i, line, dlen, ndec, status,
     .          nlen, naxlen, int1
	CHARACTER AX_TITLE*32, 	lo_str*20, hi_str*20, direction*1,
     .		  title*32, reg*1, modflag*1, truncated*1, frmt*50
	REAL*8	TM_WORLD, lo_val8, hi_val8, pts


* local parameter declarations:
	INTEGER		sig_figs
	PARAMETER     ( sig_figs = 5 )

* pull line from grid table
	line = grid_line( idim, grid )

* line ok ?
	risc_buff = ' '
	IF ( line .EQ. munknown ) THEN
	   title = 'unknown'
	   WRITE ( risc_buff, 3010 ) title, ww_dim_name( idim )
	   CALL SPLIT_LIST(pttmode_explct, lun, risc_buff, 0)
	ELSEIF ( line .EQ. mnormal ) THEN
	   title = 'normal'
	   WRITE ( risc_buff, 3010 ) title, ww_dim_name( idim )
	   CALL SPLIT_LIST(pttmode_explct, lun, risc_buff, 0)
	ELSE

* get nicely formatted limits (end box outer edges)
	   calendar = idim .EQ. t_dim .AND. GEOG_LABEL( idim, grid )	
	   lo_val8 = TM_WORLD( 1, grid, idim, box_middle )
	   IF ( calendar ) THEN
	      ndec = 5 		! accurate to minutes
	   ELSE
	      ndec = -sig_figs	! 5 sig places w/out extra zeros
	   ENDIF
	   CALL TRANSLATE_TO_WORLD( lo_val8, idim, grid, ndec, lo_str )
	   hi_val8 = TM_WORLD( line_dim(line), grid, idim, box_middle )
	   IF ( calendar ) THEN
	      ndec = 5 
	   ELSE
	      ndec = -sig_figs
	   ENDIF
	   CALL TRANSLATE_TO_WORLD( hi_val8, idim, grid, ndec, hi_str )

* axis oriented backwards ?
	   IF ( BKWD_AXIS(idim, grid) ) THEN
	      direction = '-'
	   ELSE
	      direction = ' '
	   ENDIF

* axis title
	   IF ( orient .EQ. 0 ) THEN
	      title = line_units(line)
	      IF (title .EQ. ' ') THEN
	         dlen = 1
	      ELSE
	         dlen = TM_LENSTR1(title)
	         title = '('//line_units(line)(:dlen)//')'
	         dlen = dlen + 2
	      ENDIF
	   ELSE
	      title = AX_TITLE( idim, grid, dlen )
	   ENDIF
!	   title = title(:dlen)//direction	! 12/94 removed

* regularly spaced ?
	   IF ( line_regular( line ) ) THEN
	     reg = 'r'
	   ELSE
	     reg = 'i'
	   ENDIF

* modulo ?
	   IF ( line_modulo( line ) ) THEN
	     modflag = 'm'
	   ELSE
	     modflag = ' '
	   ENDIF

* allow for long axis names (6/92)
           nlen = MAX( TM_LENSTR1(line_name(line)), 9 )

	   naxlen = INT(0.5+DLOG10(DFLOAT(line_dim(line))) ) 

* write info
	   int1 = 34 - (naxlen+1)
	   naxlen = naxlen + 1
	   IF (naxlen .LT. 10) THEN
	      WRITE (frmt, 3020) int1, naxlen
	   ELSE
	      WRITE (frmt, 3030) int1, naxlen
	   ENDIF

           WRITE ( risc_buff, frmt )	line_name ( line )(:nlen),
     .				title (:41-nlen),
     .				line_dim  ( line ),
     .				modflag,
     .				reg,
     .				direction,
     .				lo_str,
     .				hi_str


	   CALL SPLIT_LIST(pttmode_explct, lun, risc_buff, 0)
	ENDIF
	RETURN

 3010	FORMAT ( T2,A8,T12,A1 )
c 3020	FORMAT ( T2,A,1X,A,T27,I7,3A1,T39,A20,T60,A20 )
c 3030	FORMAT ( T2,A,1X,A,T22,I12,3A1,T39,A20,T60,A20 )

 3020   FORMAT ('(T2,A,1X,A,T',I2,',I',I1',3A1,T39,A20,T60,A20 )')
 3030   FORMAT ('(T2,A,1X,A,T',I2,',I',I2',3A1,T39,A20,T60,A20 )')

	END
