/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVCODEC_INTRAX8HUF_H
#define AVCODEC_INTRAX8HUF_H

#include <inttypes.h>

static const uint16_t x8_orient_lowquant_table[4][12][2] = {
    { // 0
        { 0x0000, 1 }, { 0x0004, 3 }, { 0x0005, 3 }, { 0x000C, 4 },
        { 0x000D, 4 }, { 0x0038, 6 }, { 0x001D, 5 }, { 0x0039, 6 },
        { 0x003C, 6 }, { 0x003D, 6 }, { 0x003E, 6 }, { 0x003F, 6 },
    },
    { // 1
        { 0x0000, 5 }, { 0x0001, 5 }, { 0x0002, 5 }, { 0x0001, 2 },
        { 0x0002, 2 }, { 0x0002, 4 }, { 0x0003, 5 }, { 0x0006, 3 },
        { 0x0003, 4 }, { 0x000E, 4 }, { 0x001E, 5 }, { 0x001F, 5 },
    },
    { // 2
        { 0x0000, 2 }, { 0x0001, 2 }, { 0x0004, 3 }, { 0x0005, 3 },
        { 0x0006, 3 }, { 0x0038, 6 }, { 0x0039, 6 }, { 0x001D, 5 },
        { 0x003C, 6 }, { 0x003D, 6 }, { 0x003E, 6 }, { 0x003F, 6 },
    },
    { // 3
        { 0x0000, 3 }, { 0x0002, 4 }, { 0x0003, 4 }, { 0x0001, 2 },
        { 0x0002, 2 }, { 0x0018, 5 }, { 0x0019, 5 }, { 0x000D, 4 },
        { 0x001C, 5 }, { 0x001D, 5 }, { 0x001E, 5 }, { 0x001F, 5 },
    },
};

static const uint16_t x8_orient_highquant_table[2][12][2] = {
    { // 0
        { 0x0000, 2 }, { 0x0001, 2 }, { 0x0004, 3 }, { 0x0005, 3 },
        { 0x0006, 3 }, { 0x0038, 6 }, { 0x001D, 5 }, { 0x0039, 6 },
        { 0x003C, 6 }, { 0x003D, 6 }, { 0x003E, 6 }, { 0x003F, 6 },
    },
    { // 1
        { 0x0000, 1 }, { 0x0002, 2 }, { 0x0006, 3 }, { 0x001C, 5 },
        { 0x001D, 5 }, { 0x0078, 7 }, { 0x003D, 6 }, { 0x0079, 7 },
        { 0x007C, 7 }, { 0x007D, 7 }, { 0x007E, 7 }, { 0x007F, 7 },
    },
};
#define MAX_OR_VLC_BITS 7

static const uint16_t x8_dc_lowquant_table[8][34][2] = {
    { // 0
        { 0x0000,  5 }, { 0x0001,  4 }, { 0x0001,  5 }, { 0x0004,  5 },
        { 0x0005,  5 }, { 0x0006,  5 }, { 0x000E,  6 }, { 0x000F,  6 },
        { 0x0040,  8 }, { 0x0041,  8 }, { 0x0840, 13 }, { 0x0841, 13 },
        { 0x0842, 13 }, { 0x0843, 13 }, { 0x0844, 13 }, { 0x0845, 13 },
        { 0x0846, 13 }, { 0x0002,  2 }, { 0x0003,  2 }, { 0x0003,  3 },
        { 0x0005,  4 }, { 0x0009,  5 }, { 0x0011,  6 }, { 0x0043,  8 },
        { 0x0085,  9 }, { 0x0847, 13 }, { 0x0848, 13 }, { 0x0849, 13 },
        { 0x084A, 13 }, { 0x084B, 13 }, { 0x084C, 13 }, { 0x084D, 13 },
        { 0x084E, 13 }, { 0x084F, 13 },
    },
    { // 1
        { 0x0000,  4 }, { 0x0001,  3 }, { 0x0002,  3 }, { 0x0001,  4 },
        { 0x0006,  4 }, { 0x0004,  3 }, { 0x0007,  4 }, { 0x0005,  3 },
        { 0x000C,  4 }, { 0x000D,  4 }, { 0x001C,  5 }, { 0x003A,  6 },
        { 0x01D8,  9 }, { 0x01D9,  9 }, { 0x1DA0, 13 }, { 0x1DA1, 13 },
        { 0x1DA2, 13 }, { 0x003C,  6 }, { 0x003D,  6 }, { 0x003E,  6 },
        { 0x0077,  7 }, { 0x01DB,  9 }, { 0x007E,  7 }, { 0x00FE,  8 },
        { 0x01FE,  9 }, { 0x1DA3, 13 }, { 0x1DA4, 13 }, { 0x1DA5, 13 },
        { 0x0ED3, 12 }, { 0x0ED4, 12 }, { 0x01FF,  9 }, { 0x0ED5, 12 },
        { 0x0ED6, 12 }, { 0x0ED7, 12 },
    },
    { // 2
        { 0x0000,  4 }, { 0x0001,  3 }, { 0x0002,  3 }, { 0x0001,  4 },
        { 0x0006,  4 }, { 0x0007,  4 }, { 0x0008,  4 }, { 0x0009,  4 },
        { 0x0028,  6 }, { 0x0029,  6 }, { 0x0054,  7 }, { 0x0055,  7 },
        { 0x0AC0, 12 }, { 0x0AC1, 12 }, { 0x0AC2, 12 }, { 0x0AC3, 12 },
        { 0x0AC4, 12 }, { 0x000B,  4 }, { 0x0006,  3 }, { 0x000E,  4 },
        { 0x001E,  5 }, { 0x003E,  6 }, { 0x003F,  6 }, { 0x0057,  7 },
        { 0x00AD,  8 }, { 0x0AC5, 12 }, { 0x0AC6, 12 }, { 0x0AC7, 12 },
        { 0x0AC8, 12 }, { 0x0AC9, 12 }, { 0x0ACA, 12 }, { 0x0ACB, 12 },
        { 0x0566, 11 }, { 0x0567, 11 },
    },
    { // 3
        { 0x0000,  4 }, { 0x0001,  2 }, { 0x0001,  3 }, { 0x0004,  3 },
        { 0x0005,  3 }, { 0x0006,  3 }, { 0x0001,  4 }, { 0x000E,  4 },
        { 0x003C,  6 }, { 0x003D,  6 }, { 0x007C,  7 }, { 0x00FA,  8 },
        { 0x3EC0, 14 }, { 0x3EC1, 14 }, { 0x3EC2, 14 }, { 0x3EC3, 14 },
        { 0x1F62, 13 }, { 0x01F7,  9 }, { 0x007E,  7 }, { 0x00FE,  8 },
        { 0x00FF,  8 }, { 0x1F63, 13 }, { 0x1F64, 13 }, { 0x1F65, 13 },
        { 0x1F66, 13 }, { 0x1F67, 13 }, { 0x1F68, 13 }, { 0x1F69, 13 },
        { 0x1F6A, 13 }, { 0x1F6B, 13 }, { 0x1F6C, 13 }, { 0x1F6D, 13 },
        { 0x1F6E, 13 }, { 0x1F6F, 13 },
    },
    { // 4
        { 0x0000,  7 }, { 0x0001,  7 }, { 0x0002,  7 }, { 0x0003,  7 },
        { 0x0004,  7 }, { 0x0005,  7 }, { 0x0006,  7 }, { 0x0007,  7 },
        { 0x0008,  7 }, { 0x0009,  7 }, { 0x000A,  7 }, { 0x000B,  7 },
        { 0x000C,  7 }, { 0x000D,  7 }, { 0x000E,  7 }, { 0x000F,  7 },
        { 0x0010,  7 }, { 0x0001,  1 }, { 0x0001,  2 }, { 0x0011,  7 },
        { 0x0012,  7 }, { 0x0013,  7 }, { 0x0014,  7 }, { 0x0015,  7 },
        { 0x0016,  7 }, { 0x0017,  7 }, { 0x0018,  7 }, { 0x0019,  7 },
        { 0x001A,  7 }, { 0x001B,  7 }, { 0x001C,  7 }, { 0x001D,  7 },
        { 0x001E,  7 }, { 0x001F,  7 },
    },
    { // 5
        { 0x0000,  5 }, { 0x0001,  4 }, { 0x0001,  5 }, { 0x0008,  6 },
        { 0x0009,  6 }, { 0x000A,  6 }, { 0x0016,  7 }, { 0x000C,  6 },
        { 0x0017,  7 }, { 0x000D,  6 }, { 0x0038,  8 }, { 0x001D,  7 },
        { 0x0039,  8 }, { 0x0780, 13 }, { 0x0781, 13 }, { 0x0782, 13 },
        { 0x0783, 13 }, { 0x0002,  3 }, { 0x0001,  1 }, { 0x0003,  3 },
        { 0x001F,  7 }, { 0x003D,  8 }, { 0x0079,  9 }, { 0x0784, 13 },
        { 0x0785, 13 }, { 0x0786, 13 }, { 0x0787, 13 }, { 0x0788, 13 },
        { 0x0789, 13 }, { 0x078A, 13 }, { 0x078B, 13 }, { 0x078C, 13 },
        { 0x078D, 13 }, { 0x03C7, 12 },
    },
    { // 6
        { 0x0000,  4 }, { 0x0001,  2 }, { 0x0001,  3 }, { 0x0004,  3 },
        { 0x0001,  4 }, { 0x000A,  4 }, { 0x0016,  5 }, { 0x002E,  6 },
        { 0x005E,  7 }, { 0x005F,  7 }, { 0x00C0,  8 }, { 0x3040, 14 },
        { 0x3041, 14 }, { 0x0305, 10 }, { 0x0183,  9 }, { 0x3042, 14 },
        { 0x3043, 14 }, { 0x000D,  4 }, { 0x0007,  3 }, { 0x0019,  5 },
        { 0x0031,  6 }, { 0x00C2,  8 }, { 0x00C3,  8 }, { 0x3044, 14 },
        { 0x3045, 14 }, { 0x3046, 14 }, { 0x3047, 14 }, { 0x3048, 14 },
        { 0x3049, 14 }, { 0x304A, 14 }, { 0x304B, 14 }, { 0x304C, 14 },
        { 0x304D, 14 }, { 0x1827, 13 },
    },
    { // 7
        { 0x0000,  6 }, { 0x0001,  6 }, { 0x0002,  6 }, { 0x0006,  7 },
        { 0x0007,  7 }, { 0x0004,  6 }, { 0x0005,  6 }, { 0x0006,  6 },
        { 0x000E,  7 }, { 0x001E,  8 }, { 0x001F,  8 }, { 0x0040,  9 },
        { 0x0082, 10 }, { 0x0830, 14 }, { 0x0831, 14 }, { 0x0832, 14 },
        { 0x0833, 14 }, { 0x0001,  1 }, { 0x0001,  2 }, { 0x0003,  4 },
        { 0x0005,  5 }, { 0x0009,  6 }, { 0x0011,  7 }, { 0x0021,  8 },
        { 0x0834, 14 }, { 0x0835, 14 }, { 0x0836, 14 }, { 0x0837, 14 },
        { 0x0838, 14 }, { 0x0839, 14 }, { 0x083A, 14 }, { 0x083B, 14 },
        { 0x041E, 13 }, { 0x041F, 13 },
    },
};

static const uint16_t x8_dc_highquant_table[8][34][2] = {
    { // 0
        { 0x0000,  5 }, { 0x0001,  4 }, { 0x0002,  4 }, { 0x0001,  5 },
        { 0x0006,  5 }, { 0x0004,  4 }, { 0x0007,  5 }, { 0x000A,  5 },
        { 0x002C,  7 }, { 0x002D,  7 }, { 0x05C0, 12 }, { 0x05C1, 12 },
        { 0x05C2, 12 }, { 0x05C3, 12 }, { 0x05C4, 12 }, { 0x05C5, 12 },
        { 0x05C6, 12 }, { 0x0003,  3 }, { 0x0002,  2 }, { 0x0006,  3 },
        { 0x000E,  4 }, { 0x001E,  5 }, { 0x001F,  5 }, { 0x002F,  7 },
        { 0x005D,  8 }, { 0x05C7, 12 }, { 0x05C8, 12 }, { 0x05C9, 12 },
        { 0x05CA, 12 }, { 0x05CB, 12 }, { 0x05CC, 12 }, { 0x05CD, 12 },
        { 0x05CE, 12 }, { 0x05CF, 12 },
    },
    { // 1
        { 0x0000,  3 }, { 0x0001,  3 }, { 0x0002,  3 }, { 0x0006,  4 },
        { 0x0007,  4 }, { 0x0004,  3 }, { 0x000A,  4 }, { 0x000B,  4 },
        { 0x0030,  6 }, { 0x0062,  7 }, { 0x0063,  7 }, { 0x0640, 11 },
        { 0x0641, 11 }, { 0x0642, 11 }, { 0x0643, 11 }, { 0x0644, 11 },
        { 0x0645, 11 }, { 0x0033,  6 }, { 0x000D,  4 }, { 0x001C,  5 },
        { 0x001D,  5 }, { 0x003C,  6 }, { 0x001F,  5 }, { 0x0065,  7 },
        { 0x007A,  7 }, { 0x0646, 11 }, { 0x007B,  7 }, { 0x0647, 11 },
        { 0x0648, 11 }, { 0x0649, 11 }, { 0x064A, 11 }, { 0x064B, 11 },
        { 0x0326, 10 }, { 0x0327, 10 },
    },
    { // 2
        { 0x0000,  7 }, { 0x0001,  7 }, { 0x0001,  6 }, { 0x0004,  7 },
        { 0x0003,  6 }, { 0x0005,  7 }, { 0x0010,  8 }, { 0x0011,  8 },
        { 0x0240, 13 }, { 0x0241, 13 }, { 0x0242, 13 }, { 0x0243, 13 },
        { 0x0244, 13 }, { 0x0245, 13 }, { 0x0246, 13 }, { 0x0247, 13 },
        { 0x0124, 12 }, { 0x0001,  1 }, { 0x0001,  2 }, { 0x0001,  3 },
        { 0x0003,  5 }, { 0x0005,  6 }, { 0x0013,  8 }, { 0x0125, 12 },
        { 0x0126, 12 }, { 0x0127, 12 }, { 0x0128, 12 }, { 0x0129, 12 },
        { 0x012A, 12 }, { 0x012B, 12 }, { 0x012C, 12 }, { 0x012D, 12 },
        { 0x012E, 12 }, { 0x012F, 12 },
    },
    { // 3
        { 0x0000,  4 }, { 0x0001,  3 }, { 0x0002,  3 }, { 0x0001,  4 },
        { 0x0006,  4 }, { 0x0004,  3 }, { 0x0005,  3 }, { 0x0006,  3 },
        { 0x000E,  5 }, { 0x000F,  5 }, { 0x0070,  7 }, { 0x0710, 11 },
        { 0x0711, 11 }, { 0x0712, 11 }, { 0x0713, 11 }, { 0x0714, 11 },
        { 0x0715, 11 }, { 0x001D,  5 }, { 0x0072,  7 }, { 0x003C,  6 },
        { 0x003D,  6 }, { 0x0073,  7 }, { 0x007C,  7 }, { 0x007D,  7 },
        { 0x007E,  7 }, { 0x0716, 11 }, { 0x0717, 11 }, { 0x0718, 11 },
        { 0x007F,  7 }, { 0x0719, 11 }, { 0x071A, 11 }, { 0x071B, 11 },
        { 0x038E, 10 }, { 0x038F, 10 },
    },
    { // 4
        { 0x0000,  8 }, { 0x0001,  7 }, { 0x0002,  7 }, { 0x0003,  7 },
        { 0x0002,  9 }, { 0x0008,  8 }, { 0x0003,  9 }, { 0x0240, 14 },
        { 0x0241, 14 }, { 0x0242, 14 }, { 0x0243, 14 }, { 0x0244, 14 },
        { 0x0245, 14 }, { 0x0246, 14 }, { 0x0247, 14 }, { 0x0124, 13 },
        { 0x0125, 13 }, { 0x0001,  2 }, { 0x0001,  1 }, { 0x0001,  3 },
        { 0x0001,  4 }, { 0x0003,  6 }, { 0x0005,  7 }, { 0x0013,  9 },
        { 0x0126, 13 }, { 0x0127, 13 }, { 0x0128, 13 }, { 0x0129, 13 },
        { 0x012A, 13 }, { 0x012B, 13 }, { 0x012C, 13 }, { 0x012D, 13 },
        { 0x012E, 13 }, { 0x012F, 13 },
    },
    { // 5
        { 0x0000,  7 }, { 0x0001,  7 }, { 0x0001,  6 }, { 0x0002,  6 },
        { 0x0003,  6 }, { 0x0004,  6 }, { 0x0005,  6 }, { 0x0006,  6 },
        { 0x0007,  6 }, { 0x0008,  6 }, { 0x0009,  6 }, { 0x000A,  6 },
        { 0x000B,  6 }, { 0x000C,  6 }, { 0x000D,  6 }, { 0x000E,  6 },
        { 0x000F,  6 }, { 0x0010,  6 }, { 0x0011,  6 }, { 0x0012,  6 },
        { 0x0013,  6 }, { 0x0014,  6 }, { 0x0015,  6 }, { 0x0016,  6 },
        { 0x0017,  6 }, { 0x0018,  6 }, { 0x0019,  6 }, { 0x0001,  1 },
        { 0x001A,  6 }, { 0x001B,  6 }, { 0x001C,  6 }, { 0x001D,  6 },
        { 0x001E,  6 }, { 0x001F,  6 },
    },
    { // 6
        { 0x0000,  5 }, { 0x0001,  4 }, { 0x0001,  5 }, { 0x0004,  5 },
        { 0x000A,  6 }, { 0x0006,  5 }, { 0x000B,  6 }, { 0x000E,  6 },
        { 0x003C,  8 }, { 0x003D,  8 }, { 0x07C0, 13 }, { 0x07C1, 13 },
        { 0x07C2, 13 }, { 0x07C3, 13 }, { 0x07C4, 13 }, { 0x07C5, 13 },
        { 0x07C6, 13 }, { 0x0001,  2 }, { 0x0002,  2 }, { 0x0006,  3 },
        { 0x000E,  4 }, { 0x001E,  5 }, { 0x001F,  5 }, { 0x003F,  8 },
        { 0x007D,  9 }, { 0x07C7, 13 }, { 0x07C8, 13 }, { 0x07C9, 13 },
        { 0x07CA, 13 }, { 0x07CB, 13 }, { 0x07CC, 13 }, { 0x07CD, 13 },
        { 0x07CE, 13 }, { 0x07CF, 13 },
    },
    { // 7
        { 0x0000,  7 }, { 0x0001,  7 }, { 0x0002,  7 }, { 0x0003,  7 },
        { 0x0004,  7 }, { 0x0005,  7 }, { 0x0006,  7 }, { 0x0007,  7 },
        { 0x0008,  7 }, { 0x0009,  7 }, { 0x000A,  7 }, { 0x000B,  7 },
        { 0x000C,  7 }, { 0x000D,  7 }, { 0x000E,  7 }, { 0x000F,  7 },
        { 0x0010,  7 }, { 0x0001,  1 }, { 0x0001,  2 }, { 0x0011,  7 },
        { 0x0012,  7 }, { 0x0013,  7 }, { 0x0014,  7 }, { 0x0015,  7 },
        { 0x0016,  7 }, { 0x0017,  7 }, { 0x0018,  7 }, { 0x0019,  7 },
        { 0x001A,  7 }, { 0x001B,  7 }, { 0x001C,  7 }, { 0x001D,  7 },
        { 0x001E,  7 }, { 0x001F,  7 },
    },
};
#define MAX_DC_VLC_BITS 14

static const uint16_t x8_ac0_lowquant_table[8][77][2] = {
    { // 0
        { 0x0000,  2 }, { 0x0002,  3 }, { 0x0006,  4 }, { 0x000E,  5 },
        { 0x001E,  6 }, { 0x003E,  7 }, { 0x003F,  7 }, { 0x0040,  7 },
        { 0x0104,  9 }, { 0x0083,  8 }, { 0x0084,  8 }, { 0x0085,  8 },
        { 0x020A, 10 }, { 0x020B, 10 }, { 0x0218, 10 }, { 0x0219, 10 },
        { 0x0009,  4 }, { 0x0044,  7 }, { 0x010D,  9 }, { 0x021C, 10 },
        { 0x0023,  6 }, { 0x0045,  7 }, { 0x0050,  7 }, { 0x000B,  4 },
        { 0x000C,  4 }, { 0x0015,  5 }, { 0x001A,  5 }, { 0x001B,  5 },
        { 0x0029,  6 }, { 0x0038,  6 }, { 0x0039,  6 }, { 0x003A,  6 },
        { 0x0051,  7 }, { 0x0076,  7 }, { 0x0077,  7 }, { 0x0078,  7 },
        { 0x0079,  7 }, { 0x007A,  7 }, { 0x007B,  7 }, { 0x00F8,  8 },
        { 0x010F,  9 }, { 0x021D, 10 }, { 0x3E40, 14 }, { 0x3E41, 14 },
        { 0x3E42, 14 }, { 0x3E43, 14 }, { 0x03E5, 10 }, { 0x3E44, 14 },
        { 0x01F3,  9 }, { 0x3E45, 14 }, { 0x3E46, 14 }, { 0x3E47, 14 },
        { 0x00FA,  8 }, { 0x3E48, 14 }, { 0x3E49, 14 }, { 0x3E4A, 14 },
        { 0x3E4B, 14 }, { 0x03EC, 10 }, { 0x3E4C, 14 }, { 0x007E,  7 },
        { 0x00FE,  8 }, { 0x00FF,  8 }, { 0x01F7,  9 }, { 0x3E4D, 14 },
        { 0x3E4E, 14 }, { 0x3E4F, 14 }, { 0x3ED0, 14 }, { 0x3ED1, 14 },
        { 0x3ED2, 14 }, { 0x3ED3, 14 }, { 0x3ED4, 14 }, { 0x3ED5, 14 },
        { 0x1F6B, 13 }, { 0x1F6C, 13 }, { 0x1F6D, 13 }, { 0x1F6E, 13 },
        { 0x1F6F, 13 },
    },
    { // 1
        { 0x0000,  3 }, { 0x0004,  5 }, { 0x0014,  7 }, { 0x000B,  6 },
        { 0x000C,  6 }, { 0x002A,  8 }, { 0x002B,  8 }, { 0x0034,  8 },
        { 0x0D40, 14 }, { 0x0D41, 14 }, { 0x001B,  7 }, { 0x0D42, 14 },
        { 0x0D43, 14 }, { 0x0D44, 14 }, { 0x0D45, 14 }, { 0x0D46, 14 },
        { 0x000E,  6 }, { 0x003C,  8 }, { 0x0D47, 14 }, { 0x003D,  8 },
        { 0x0D48, 14 }, { 0x0D49, 14 }, { 0x0D4A, 14 }, { 0x0001,  2 },
        { 0x0004,  3 }, { 0x0014,  5 }, { 0x000B,  4 }, { 0x000C,  4 },
        { 0x000D,  4 }, { 0x002A,  6 }, { 0x001F,  7 }, { 0x0056,  7 },
        { 0x0057,  7 }, { 0x0070,  7 }, { 0x00E2,  8 }, { 0x0072,  7 },
        { 0x003A,  6 }, { 0x003B,  6 }, { 0x003C,  6 }, { 0x003D,  6 },
        { 0x00E3,  8 }, { 0x0D4B, 14 }, { 0x00E6,  8 }, { 0x00E7,  8 },
        { 0x00F8,  8 }, { 0x0D4C, 14 }, { 0x0D4D, 14 }, { 0x0D4E, 14 },
        { 0x00F9,  8 }, { 0x0D4F, 14 }, { 0x0D50, 14 }, { 0x0D51, 14 },
        { 0x06A9, 13 }, { 0x06AA, 13 }, { 0x06AB, 13 }, { 0x06AC, 13 },
        { 0x06AD, 13 }, { 0x06AE, 13 }, { 0x06AF, 13 }, { 0x003F,  6 },
        { 0x06B0, 13 }, { 0x06B1, 13 }, { 0x06B2, 13 }, { 0x06B3, 13 },
        { 0x06B4, 13 }, { 0x007D,  7 }, { 0x06B5, 13 }, { 0x06B6, 13 },
        { 0x06B7, 13 }, { 0x06B8, 13 }, { 0x06B9, 13 }, { 0x06BA, 13 },
        { 0x06BB, 13 }, { 0x06BC, 13 }, { 0x06BD, 13 }, { 0x06BE, 13 },
        { 0x06BF, 13 },
    },
    { // 2
        { 0x0000,  2 }, { 0x0002,  3 }, { 0x0003,  3 }, { 0x0008,  4 },
        { 0x0012,  5 }, { 0x0013,  5 }, { 0x0028,  6 }, { 0x0029,  6 },
        { 0x0054,  7 }, { 0x0055,  7 }, { 0x0056,  7 }, { 0x00AE,  8 },
        { 0x00AF,  8 }, { 0x00B0,  8 }, { 0x0162,  9 }, { 0x02C6, 10 },
        { 0x000C,  4 }, { 0x002D,  6 }, { 0x00B2,  8 }, { 0x0166,  9 },
        { 0x002E,  6 }, { 0x0167,  9 }, { 0x00BC,  8 }, { 0x001A,  5 },
        { 0x0036,  6 }, { 0x0037,  6 }, { 0x0038,  6 }, { 0x005F,  7 },
        { 0x0072,  7 }, { 0x0073,  7 }, { 0x0074,  7 }, { 0x0075,  7 },
        { 0x0076,  7 }, { 0x0077,  7 }, { 0x0078,  7 }, { 0x0079,  7 },
        { 0x007A,  7 }, { 0x007B,  7 }, { 0x00BD,  8 }, { 0xB1C0, 16 },
        { 0xB1C1, 16 }, { 0x58E1, 15 }, { 0x0B1D, 12 }, { 0x58E2, 15 },
        { 0x58E3, 15 }, { 0x58E4, 15 }, { 0x00F8,  8 }, { 0x03E4, 10 },
        { 0x01F3,  9 }, { 0x0B1E, 12 }, { 0x58E5, 15 }, { 0x58E6, 15 },
        { 0x00FA,  8 }, { 0x58E7, 15 }, { 0x58F8, 15 }, { 0x58F9, 15 },
        { 0x58FA, 15 }, { 0x01F6,  9 }, { 0x58FB, 15 }, { 0x007E,  7 },
        { 0x00FE,  8 }, { 0x00FF,  8 }, { 0x07CA, 11 }, { 0x0F96, 12 },
        { 0x58FC, 15 }, { 0x58FD, 15 }, { 0x58FE, 15 }, { 0x58FF, 15 },
        { 0x7CB8, 15 }, { 0x7CB9, 15 }, { 0x7CBA, 15 }, { 0x7CBB, 15 },
        { 0x7CBC, 15 }, { 0x01F7,  9 }, { 0x7CBD, 15 }, { 0x7CBE, 15 },
        { 0x7CBF, 15 },
    },
    { // 3
        { 0x0000,  2 }, { 0x0002,  3 }, { 0x0006,  4 }, { 0x000E,  5 },
        { 0x000F,  5 }, { 0x0020,  6 }, { 0x0021,  6 }, { 0x0044,  7 },
        { 0x0045,  7 }, { 0x008C,  8 }, { 0x008D,  8 }, { 0x011C,  9 },
        { 0x011D,  9 }, { 0x011E,  9 }, { 0x023E, 10 }, { 0x023F, 10 },
        { 0x0005,  3 }, { 0x0012,  5 }, { 0x004C,  7 }, { 0x004D,  7 },
        { 0x000C,  4 }, { 0x004E,  7 }, { 0x001A,  5 }, { 0x0036,  6 },
        { 0x004F,  7 }, { 0x006E,  7 }, { 0x006F,  7 }, { 0x00E0,  8 },
        { 0x00E1,  8 }, { 0x00E2,  8 }, { 0x00E3,  8 }, { 0x00E4,  8 },
        { 0x00E5,  8 }, { 0x01CC,  9 }, { 0x00E7,  8 }, { 0x00E8,  8 },
        { 0x00E9,  8 }, { 0x01CD,  9 }, { 0x0750, 11 }, { 0x03A9, 10 },
        { 0x0751, 11 }, { 0x7540, 15 }, { 0x03AB, 10 }, { 0x7541, 15 },
        { 0x7542, 15 }, { 0x7543, 15 }, { 0x01D6,  9 }, { 0x0755, 11 },
        { 0x0076,  7 }, { 0x0EA9, 12 }, { 0x7544, 15 }, { 0x7545, 15 },
        { 0x001E,  5 }, { 0x0077,  7 }, { 0x00F8,  8 }, { 0x03AE, 10 },
        { 0x075E, 11 }, { 0x007D,  7 }, { 0x03E4, 10 }, { 0x00FC,  8 },
        { 0x00FD,  8 }, { 0x03E5, 10 }, { 0x03E6, 10 }, { 0x0EBE, 12 },
        { 0x7546, 15 }, { 0x07CE, 11 }, { 0x7547, 15 }, { 0x75F8, 15 },
        { 0x75F9, 15 }, { 0x75FA, 15 }, { 0x75FB, 15 }, { 0x75FC, 15 },
        { 0x75FD, 15 }, { 0x007F,  7 }, { 0x3AFF, 14 }, { 0x0F9E, 12 },
        { 0x0F9F, 12 },
    },
    { // 4
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x0003,  4 }, { 0x0008,  5 },
        { 0x0012,  6 }, { 0x0013,  6 }, { 0x0014,  6 }, { 0x002A,  7 },
        { 0x0016,  6 }, { 0x002B,  7 }, { 0x005C,  8 }, { 0x005D,  8 },
        { 0x005E,  8 }, { 0x00BE,  9 }, { 0x00BF,  9 }, { 0x0060,  8 },
        { 0x0007,  4 }, { 0x000D,  5 }, { 0x0019,  6 }, { 0x0020,  6 },
        { 0x0009,  4 }, { 0x0021,  6 }, { 0x0011,  5 }, { 0x0014,  5 },
        { 0x002A,  6 }, { 0x002B,  6 }, { 0x002C,  6 }, { 0x002D,  6 },
        { 0x002E,  6 }, { 0x002F,  6 }, { 0x0030,  6 }, { 0x0031,  7 },
        { 0x0062,  7 }, { 0x0063,  7 }, { 0x0064,  7 }, { 0x0065,  7 },
        { 0x0066,  7 }, { 0x0061,  8 }, { 0x0670, 11 }, { 0x0068,  7 },
        { 0x0069,  7 }, { 0x00CF,  8 }, { 0x019D,  9 }, { 0x01A8,  9 },
        { 0x01A9,  9 }, { 0x0339, 10 }, { 0x01AA,  9 }, { 0x0356, 10 },
        { 0x0036,  6 }, { 0x00D6,  8 }, { 0x6710, 15 }, { 0x6711, 15 },
        { 0x000E,  4 }, { 0x006E,  7 }, { 0x01AE,  9 }, { 0x6712, 15 },
        { 0x6713, 15 }, { 0x003C,  6 }, { 0x0357, 10 }, { 0x006F,  7 },
        { 0x00F4,  8 }, { 0x00F5,  8 }, { 0x035E, 10 }, { 0x01EC,  9 },
        { 0x6714, 15 }, { 0x01ED,  9 }, { 0x035F, 10 }, { 0x03DC, 10 },
        { 0x03DD, 10 }, { 0x6715, 15 }, { 0x338B, 14 }, { 0x338C, 14 },
        { 0x338D, 14 }, { 0x001F,  5 }, { 0x01EF,  9 }, { 0x338E, 14 },
        { 0x338F, 14 },
    },
    { // 5
        { 0x0000,  2 }, { 0x0004,  4 }, { 0x000A,  5 }, { 0x000B,  5 },
        { 0x0018,  6 }, { 0x0019,  6 }, { 0x0034,  7 }, { 0x006A,  8 },
        { 0x006B,  8 }, { 0x006C,  8 }, { 0x00DA,  9 }, { 0x036C, 11 },
        { 0x006E,  8 }, { 0x01B7, 10 }, { 0x036D, 11 }, { 0x3780, 15 },
        { 0x0004,  3 }, { 0x000E,  5 }, { 0x001E,  6 }, { 0x003E,  7 },
        { 0x000A,  4 }, { 0x002C,  6 }, { 0x0017,  5 }, { 0x002D,  6 },
        { 0x003F,  7 }, { 0x00C0,  8 }, { 0x0061,  7 }, { 0x00C1,  8 },
        { 0x0062,  7 }, { 0x00C6,  8 }, { 0x0064,  7 }, { 0x00C7,  8 },
        { 0x00CA,  8 }, { 0x00DF,  9 }, { 0x0196,  9 }, { 0x0197,  9 },
        { 0x0198,  9 }, { 0x0199,  9 }, { 0x0379, 11 }, { 0x019A,  9 },
        { 0x01BD, 10 }, { 0x066C, 11 }, { 0x3781, 15 }, { 0x0337, 10 },
        { 0x066D, 11 }, { 0x0670, 11 }, { 0x0339, 10 }, { 0x0671, 11 },
        { 0x0034,  6 }, { 0x00CF,  8 }, { 0x3782, 15 }, { 0x3783, 15 },
        { 0x000E,  4 }, { 0x001B,  5 }, { 0x006A,  7 }, { 0x006B,  7 },
        { 0x019D,  9 }, { 0x003C,  6 }, { 0x00F4,  8 }, { 0x00F5,  8 },
        { 0x03D8, 10 }, { 0x07B2, 11 }, { 0x3784, 15 }, { 0x03DA, 10 },
        { 0x3785, 15 }, { 0x03DB, 10 }, { 0x03DC, 10 }, { 0x3786, 15 },
        { 0x3787, 15 }, { 0x1BC4, 14 }, { 0x1BC5, 14 }, { 0x1BC6, 14 },
        { 0x1BC7, 14 }, { 0x001F,  5 }, { 0x03DD, 10 }, { 0x07B3, 11 },
        { 0x01EF,  9 },
    },
    { // 6
        { 0x0000,  2 }, { 0x0004,  4 }, { 0x000A,  5 }, { 0x0016,  6 },
        { 0x0017,  6 }, { 0x0060,  8 }, { 0x00C2,  9 }, { 0x0186, 10 },
        { 0x0187, 10 }, { 0x00C4,  9 }, { 0x3140, 15 }, { 0x3141, 15 },
        { 0x018B, 10 }, { 0x3142, 15 }, { 0x018C, 10 }, { 0x3143, 15 },
        { 0x0007,  4 }, { 0x000D,  5 }, { 0x0064,  8 }, { 0x0065,  8 },
        { 0x0010,  5 }, { 0x00C7,  9 }, { 0x0066,  8 }, { 0x0005,  3 },
        { 0x0006,  3 }, { 0x0009,  4 }, { 0x0011,  5 }, { 0x0038,  6 },
        { 0x0039,  6 }, { 0x0074,  7 }, { 0x0075,  7 }, { 0x0076,  7 },
        { 0x0067,  8 }, { 0x00EE,  8 }, { 0x01DE,  9 }, { 0x00F0,  8 },
        { 0x018D, 10 }, { 0x3144, 15 }, { 0x01DF,  9 }, { 0x003D,  6 },
        { 0x003E,  6 }, { 0x01E2,  9 }, { 0x03C6, 10 }, { 0x00F2,  8 },
        { 0x00F3,  8 }, { 0x03C7, 10 }, { 0x3145, 15 }, { 0x3146, 15 },
        { 0x01F8,  9 }, { 0x3147, 15 }, { 0x3148, 15 }, { 0x3149, 15 },
        { 0x00FD,  8 }, { 0x314A, 15 }, { 0x314B, 15 }, { 0x314C, 15 },
        { 0x314D, 15 }, { 0x01F9,  9 }, { 0x314E, 15 }, { 0x01FC,  9 },
        { 0x314F, 15 }, { 0x3150, 15 }, { 0x3151, 15 }, { 0x3152, 15 },
        { 0x3153, 15 }, { 0x03FA, 10 }, { 0x03FB, 10 }, { 0x3154, 15 },
        { 0x3155, 15 }, { 0x3156, 15 }, { 0x3157, 15 }, { 0x3158, 15 },
        { 0x3159, 15 }, { 0x00FF,  8 }, { 0x18AD, 14 }, { 0x18AE, 14 },
        { 0x18AF, 14 },
    },
    { // 7
        { 0x0000,  4 }, { 0x0080, 11 }, { 0x0081, 11 }, { 0x0082, 11 },
        { 0x0083, 11 }, { 0x0084, 11 }, { 0x0085, 11 }, { 0x0086, 11 },
        { 0x0087, 11 }, { 0x0088, 11 }, { 0x0089, 11 }, { 0x008A, 11 },
        { 0x008B, 11 }, { 0x008C, 11 }, { 0x008D, 11 }, { 0x008E, 11 },
        { 0x008F, 11 }, { 0x0048, 10 }, { 0x0049, 10 }, { 0x004A, 10 },
        { 0x004B, 10 }, { 0x004C, 10 }, { 0x004D, 10 }, { 0x0001,  1 },
        { 0x0001,  2 }, { 0x004E, 10 }, { 0x0002,  4 }, { 0x0003,  4 },
        { 0x004F, 10 }, { 0x0050, 10 }, { 0x0051, 10 }, { 0x0052, 10 },
        { 0x0053, 10 }, { 0x0054, 10 }, { 0x0055, 10 }, { 0x0056, 10 },
        { 0x0057, 10 }, { 0x0058, 10 }, { 0x0059, 10 }, { 0x005A, 10 },
        { 0x005B, 10 }, { 0x005C, 10 }, { 0x005D, 10 }, { 0x005E, 10 },
        { 0x005F, 10 }, { 0x0060, 10 }, { 0x0061, 10 }, { 0x0062, 10 },
        { 0x0063, 10 }, { 0x0064, 10 }, { 0x0065, 10 }, { 0x0066, 10 },
        { 0x0067, 10 }, { 0x0068, 10 }, { 0x0069, 10 }, { 0x006A, 10 },
        { 0x006B, 10 }, { 0x006C, 10 }, { 0x006D, 10 }, { 0x006E, 10 },
        { 0x006F, 10 }, { 0x0070, 10 }, { 0x0071, 10 }, { 0x0072, 10 },
        { 0x0073, 10 }, { 0x0074, 10 }, { 0x0075, 10 }, { 0x0076, 10 },
        { 0x0077, 10 }, { 0x0078, 10 }, { 0x0079, 10 }, { 0x007A, 10 },
        { 0x007B, 10 }, { 0x007C, 10 }, { 0x007D, 10 }, { 0x007E, 10 },
        { 0x007F, 10 },
    },
};

static const uint16_t x8_ac0_highquant_table[8][77][2] = {
    { // 0
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x000C,  6 }, { 0x000D,  6 },
        { 0x001C,  7 }, { 0x000F,  6 }, { 0x1D00, 15 }, { 0x003B,  8 },
        { 0x1D01, 15 }, { 0x0075,  9 }, { 0x1D02, 15 }, { 0x0080,  9 },
        { 0x1D03, 15 }, { 0x1D04, 15 }, { 0x1D05, 15 }, { 0x0E83, 14 },
        { 0x0009,  5 }, { 0x0011,  6 }, { 0x0081,  9 }, { 0x0082,  9 },
        { 0x0021,  7 }, { 0x0028,  7 }, { 0x0083,  9 }, { 0x0002,  2 },
        { 0x0003,  3 }, { 0x000C,  4 }, { 0x000D,  4 }, { 0x000B,  5 },
        { 0x0015,  6 }, { 0x0052,  8 }, { 0x0070,  7 }, { 0x0039,  6 },
        { 0x0071,  7 }, { 0x0053,  8 }, { 0x0E84, 14 }, { 0x0074,  7 },
        { 0x0075,  7 }, { 0x0076,  7 }, { 0x01DC,  9 }, { 0x001E,  5 },
        { 0x003E,  6 }, { 0x01DD,  9 }, { 0x00EF,  8 }, { 0x01F8,  9 },
        { 0x01F9,  9 }, { 0x0E85, 14 }, { 0x0E86, 14 }, { 0x0E87, 14 },
        { 0x00FD,  8 }, { 0x0E88, 14 }, { 0x0E89, 14 }, { 0x0E8A, 14 },
        { 0x0E8B, 14 }, { 0x0E8C, 14 }, { 0x0E8D, 14 }, { 0x0E8E, 14 },
        { 0x0E8F, 14 }, { 0x0E90, 14 }, { 0x0E91, 14 }, { 0x01FC,  9 },
        { 0x0E92, 14 }, { 0x0E93, 14 }, { 0x0E94, 14 }, { 0x0E95, 14 },
        { 0x0E96, 14 }, { 0x0E97, 14 }, { 0x01FD,  9 }, { 0x0E98, 14 },
        { 0x01FE,  9 }, { 0x0E99, 14 }, { 0x0E9A, 14 }, { 0x0E9B, 14 },
        { 0x0E9C, 14 }, { 0x01FF,  9 }, { 0x0E9D, 14 }, { 0x0E9E, 14 },
        { 0x0E9F, 14 },
    },
    { // 1
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x0003,  4 }, { 0x0008,  5 },
        { 0x0012,  6 }, { 0x0013,  6 }, { 0x0014,  6 }, { 0x0015,  6 },
        { 0x002C,  7 }, { 0x005A,  8 }, { 0x005B,  8 }, { 0x005C,  8 },
        { 0x005D,  8 }, { 0x1780, 14 }, { 0x0179, 10 }, { 0x017A, 10 },
        { 0x0006,  4 }, { 0x000E,  5 }, { 0x001E,  6 }, { 0x003E,  7 },
        { 0x0010,  5 }, { 0x0022,  6 }, { 0x0012,  5 }, { 0x000A,  4 },
        { 0x0013,  5 }, { 0x0016,  5 }, { 0x0023,  6 }, { 0x002E,  6 },
        { 0x002F,  6 }, { 0x0030,  6 }, { 0x0031,  6 }, { 0x003F,  7 },
        { 0x005F,  8 }, { 0x00C8,  8 }, { 0x0065,  7 }, { 0x0066,  7 },
        { 0x0067,  7 }, { 0x0068,  7 }, { 0x00C9,  8 }, { 0x0069,  7 },
        { 0x006A,  7 }, { 0x00D6,  8 }, { 0x00D7,  8 }, { 0x00D8,  8 },
        { 0x1781, 14 }, { 0x017B, 10 }, { 0x01B2,  9 }, { 0x1782, 14 },
        { 0x001C,  5 }, { 0x01B3,  9 }, { 0x1783, 14 }, { 0x1784, 14 },
        { 0x001D,  5 }, { 0x00DA,  8 }, { 0x1785, 14 }, { 0x1786, 14 },
        { 0x1787, 14 }, { 0x0037,  6 }, { 0x00DB,  8 }, { 0x0078,  7 },
        { 0x00F2,  8 }, { 0x01E6,  9 }, { 0x00F4,  8 }, { 0x1788, 14 },
        { 0x1789, 14 }, { 0x00F5,  8 }, { 0x01E7,  9 }, { 0x178A, 14 },
        { 0x178B, 14 }, { 0x178C, 14 }, { 0x178D, 14 }, { 0x01EC,  9 },
        { 0x178E, 14 }, { 0x001F,  5 }, { 0x00F7,  8 }, { 0x01ED,  9 },
        { 0x178F, 14 },
    },
    { // 2
        { 0x0000,  4 }, { 0x0002,  5 }, { 0x0180, 12 }, { 0x0181, 12 },
        { 0x0182, 12 }, { 0x0183, 12 }, { 0x0184, 12 }, { 0x0185, 12 },
        { 0x0186, 12 }, { 0x0187, 12 }, { 0x0188, 12 }, { 0x0189, 12 },
        { 0x00C5, 11 }, { 0x00C6, 11 }, { 0x00C7, 11 }, { 0x00C8, 11 },
        { 0x00C9, 11 }, { 0x00CA, 11 }, { 0x00CB, 11 }, { 0x00CC, 11 },
        { 0x00CD, 11 }, { 0x00CE, 11 }, { 0x00CF, 11 }, { 0x0001,  1 },
        { 0x0001,  2 }, { 0x0004,  5 }, { 0x0005,  5 }, { 0x0006,  5 },
        { 0x00D0, 11 }, { 0x00D1, 11 }, { 0x00D2, 11 }, { 0x00D3, 11 },
        { 0x00D4, 11 }, { 0x00D5, 11 }, { 0x00D6, 11 }, { 0x00D7, 11 },
        { 0x00D8, 11 }, { 0x00D9, 11 }, { 0x00DA, 11 }, { 0x0007,  5 },
        { 0x00DB, 11 }, { 0x00DC, 11 }, { 0x00DD, 11 }, { 0x00DE, 11 },
        { 0x00DF, 11 }, { 0x00E0, 11 }, { 0x00E1, 11 }, { 0x00E2, 11 },
        { 0x00E3, 11 }, { 0x00E4, 11 }, { 0x00E5, 11 }, { 0x00E6, 11 },
        { 0x00E7, 11 }, { 0x00E8, 11 }, { 0x00E9, 11 }, { 0x00EA, 11 },
        { 0x00EB, 11 }, { 0x00EC, 11 }, { 0x00ED, 11 }, { 0x00EE, 11 },
        { 0x00EF, 11 }, { 0x00F0, 11 }, { 0x00F1, 11 }, { 0x00F2, 11 },
        { 0x00F3, 11 }, { 0x00F4, 11 }, { 0x00F5, 11 }, { 0x00F6, 11 },
        { 0x00F7, 11 }, { 0x00F8, 11 }, { 0x00F9, 11 }, { 0x00FA, 11 },
        { 0x00FB, 11 }, { 0x00FC, 11 }, { 0x00FD, 11 }, { 0x00FE, 11 },
        { 0x00FF, 11 },
    },
    { // 3
        { 0x0000,  8 }, { 0x0001,  8 }, { 0x0002,  8 }, { 0x0003,  8 },
        { 0x0004,  8 }, { 0x0005,  8 }, { 0x0006,  8 }, { 0x0007,  8 },
        { 0x0008,  8 }, { 0x0009,  8 }, { 0x000A,  8 }, { 0x000B,  8 },
        { 0x000C,  8 }, { 0x000D,  8 }, { 0x000E,  8 }, { 0x000F,  8 },
        { 0x0010,  8 }, { 0x0011,  8 }, { 0x0012,  8 }, { 0x0013,  8 },
        { 0x0014,  8 }, { 0x0015,  8 }, { 0x0016,  8 }, { 0x0001,  1 },
        { 0x0017,  8 }, { 0x000C,  7 }, { 0x000D,  7 }, { 0x000E,  7 },
        { 0x000F,  7 }, { 0x0010,  7 }, { 0x0011,  7 }, { 0x0012,  7 },
        { 0x0013,  7 }, { 0x0014,  7 }, { 0x0015,  7 }, { 0x0016,  7 },
        { 0x0017,  7 }, { 0x0018,  7 }, { 0x0019,  7 }, { 0x001A,  7 },
        { 0x001B,  7 }, { 0x001C,  7 }, { 0x001D,  7 }, { 0x001E,  7 },
        { 0x001F,  7 }, { 0x0020,  7 }, { 0x0021,  7 }, { 0x0022,  7 },
        { 0x0023,  7 }, { 0x0024,  7 }, { 0x0025,  7 }, { 0x0026,  7 },
        { 0x0027,  7 }, { 0x0028,  7 }, { 0x0029,  7 }, { 0x002A,  7 },
        { 0x002B,  7 }, { 0x002C,  7 }, { 0x002D,  7 }, { 0x002E,  7 },
        { 0x002F,  7 }, { 0x0030,  7 }, { 0x0031,  7 }, { 0x0032,  7 },
        { 0x0033,  7 }, { 0x0034,  7 }, { 0x0035,  7 }, { 0x0036,  7 },
        { 0x0037,  7 }, { 0x0038,  7 }, { 0x0039,  7 }, { 0x003A,  7 },
        { 0x003B,  7 }, { 0x003C,  7 }, { 0x003D,  7 }, { 0x003E,  7 },
        { 0x003F,  7 },
    },
    { // 4
        { 0x0000,  9 }, { 0x0001,  9 }, { 0x0002,  9 }, { 0x0003,  9 },
        { 0x0004,  9 }, { 0x0005,  9 }, { 0x0006,  9 }, { 0x0007,  9 },
        { 0x0008,  9 }, { 0x0009,  9 }, { 0x000A,  9 }, { 0x000B,  9 },
        { 0x000C,  9 }, { 0x000D,  9 }, { 0x000E,  9 }, { 0x000F,  9 },
        { 0x0010,  9 }, { 0x0011,  9 }, { 0x0012,  9 }, { 0x0013,  9 },
        { 0x0014,  9 }, { 0x0015,  9 }, { 0x000B,  8 }, { 0x0001,  2 },
        { 0x0001,  1 }, { 0x000C,  8 }, { 0x000D,  8 }, { 0x000E,  8 },
        { 0x000F,  8 }, { 0x0010,  8 }, { 0x0011,  8 }, { 0x0012,  8 },
        { 0x0013,  8 }, { 0x0014,  8 }, { 0x0015,  8 }, { 0x0016,  8 },
        { 0x0017,  8 }, { 0x0018,  8 }, { 0x0019,  8 }, { 0x001A,  8 },
        { 0x001B,  8 }, { 0x001C,  8 }, { 0x001D,  8 }, { 0x001E,  8 },
        { 0x001F,  8 }, { 0x0020,  8 }, { 0x0021,  8 }, { 0x0022,  8 },
        { 0x0023,  8 }, { 0x0024,  8 }, { 0x0025,  8 }, { 0x0026,  8 },
        { 0x0027,  8 }, { 0x0028,  8 }, { 0x0029,  8 }, { 0x002A,  8 },
        { 0x002B,  8 }, { 0x002C,  8 }, { 0x002D,  8 }, { 0x002E,  8 },
        { 0x002F,  8 }, { 0x0030,  8 }, { 0x0031,  8 }, { 0x0032,  8 },
        { 0x0033,  8 }, { 0x0034,  8 }, { 0x0035,  8 }, { 0x0036,  8 },
        { 0x0037,  8 }, { 0x0038,  8 }, { 0x0039,  8 }, { 0x003A,  8 },
        { 0x003B,  8 }, { 0x003C,  8 }, { 0x003D,  8 }, { 0x003E,  8 },
        { 0x003F,  8 },
    },
    { // 5
        { 0x0000, 10 }, { 0x0001, 10 }, { 0x0002, 10 }, { 0x0003, 10 },
        { 0x0004, 10 }, { 0x0005, 10 }, { 0x0006, 10 }, { 0x0007, 10 },
        { 0x0008, 10 }, { 0x0009, 10 }, { 0x000A, 10 }, { 0x000B, 10 },
        { 0x000C, 10 }, { 0x000D, 10 }, { 0x000E, 10 }, { 0x000F, 10 },
        { 0x0010, 10 }, { 0x0011, 10 }, { 0x0012, 10 }, { 0x0013, 10 },
        { 0x000A,  9 }, { 0x000B,  9 }, { 0x000C,  9 }, { 0x0001,  1 },
        { 0x0001,  3 }, { 0x000D,  9 }, { 0x000E,  9 }, { 0x0001,  2 },
        { 0x000F,  9 }, { 0x0010,  9 }, { 0x0011,  9 }, { 0x0012,  9 },
        { 0x0013,  9 }, { 0x0014,  9 }, { 0x0015,  9 }, { 0x0016,  9 },
        { 0x0017,  9 }, { 0x0018,  9 }, { 0x0019,  9 }, { 0x001A,  9 },
        { 0x001B,  9 }, { 0x001C,  9 }, { 0x001D,  9 }, { 0x001E,  9 },
        { 0x001F,  9 }, { 0x0020,  9 }, { 0x0021,  9 }, { 0x0022,  9 },
        { 0x0023,  9 }, { 0x0024,  9 }, { 0x0025,  9 }, { 0x0026,  9 },
        { 0x0027,  9 }, { 0x0028,  9 }, { 0x0029,  9 }, { 0x002A,  9 },
        { 0x002B,  9 }, { 0x002C,  9 }, { 0x002D,  9 }, { 0x002E,  9 },
        { 0x002F,  9 }, { 0x0030,  9 }, { 0x0031,  9 }, { 0x0032,  9 },
        { 0x0033,  9 }, { 0x0034,  9 }, { 0x0035,  9 }, { 0x0036,  9 },
        { 0x0037,  9 }, { 0x0038,  9 }, { 0x0039,  9 }, { 0x003A,  9 },
        { 0x003B,  9 }, { 0x003C,  9 }, { 0x003D,  9 }, { 0x003E,  9 },
        { 0x003F,  9 },
    },
    { // 6
        { 0x0000,  2 }, { 0x0004,  4 }, { 0x000A,  5 }, { 0x000B,  5 },
        { 0x0018,  6 }, { 0x0019,  6 }, { 0x0034,  7 }, { 0x006A,  8 },
        { 0x006B,  8 }, { 0x006C,  8 }, { 0x00DA,  9 }, { 0x00DB,  9 },
        { 0x01B8, 10 }, { 0x00DD,  9 }, { 0x01B9, 10 }, { 0x3780, 15 },
        { 0x0004,  3 }, { 0x000E,  5 }, { 0x001E,  6 }, { 0x001F,  6 },
        { 0x000A,  4 }, { 0x0058,  7 }, { 0x0017,  5 }, { 0x0018,  5 },
        { 0x0059,  7 }, { 0x005A,  7 }, { 0x005B,  7 }, { 0x00C8,  8 },
        { 0x0065,  7 }, { 0x0066,  7 }, { 0x00C9,  8 }, { 0x00CE,  8 },
        { 0x00CF,  8 }, { 0x00D0,  8 }, { 0x00D1,  8 }, { 0x00D2,  8 },
        { 0x00D3,  8 }, { 0x00DF,  9 }, { 0x00D4,  8 }, { 0x00D5,  8 },
        { 0x00D6,  8 }, { 0x01AE,  9 }, { 0x3781, 15 }, { 0x01BD, 10 },
        { 0x035E, 10 }, { 0x035F, 10 }, { 0x3782, 15 }, { 0x0360, 10 },
        { 0x0037,  6 }, { 0x01B1,  9 }, { 0x3783, 15 }, { 0x3784, 15 },
        { 0x000E,  4 }, { 0x003C,  6 }, { 0x0361, 10 }, { 0x3785, 15 },
        { 0x1BC3, 14 }, { 0x003D,  6 }, { 0x00D9,  8 }, { 0x1BC4, 14 },
        { 0x0368, 10 }, { 0x1BC5, 14 }, { 0x1BC6, 14 }, { 0x1BC7, 14 },
        { 0x1BC8, 14 }, { 0x00DB,  8 }, { 0x0369, 10 }, { 0x036A, 10 },
        { 0x1BC9, 14 }, { 0x1BCA, 14 }, { 0x1BCB, 14 }, { 0x1BCC, 14 },
        { 0x1BCD, 14 }, { 0x001F,  5 }, { 0x036B, 10 }, { 0x1BCE, 14 },
        { 0x1BCF, 14 },
    },
    { // 7
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x0006,  5 }, { 0x0007,  5 },
        { 0x0010,  6 }, { 0x0044,  8 }, { 0x0023,  7 }, { 0x0012,  6 },
        { 0x0026,  7 }, { 0x08A0, 13 }, { 0x004E,  8 }, { 0x004F,  8 },
        { 0x08A1, 13 }, { 0x08A2, 13 }, { 0x08A3, 13 }, { 0x0050,  8 },
        { 0x0006,  4 }, { 0x000B,  5 }, { 0x0029,  7 }, { 0x0015,  6 },
        { 0x001C,  6 }, { 0x003A,  7 }, { 0x001E,  6 }, { 0x0004,  3 },
        { 0x0014,  5 }, { 0x0015,  5 }, { 0x000B,  4 }, { 0x001F,  6 },
        { 0x0030,  6 }, { 0x0031,  6 }, { 0x0019,  5 }, { 0x0051,  8 },
        { 0x0034,  6 }, { 0x0035,  6 }, { 0x0036,  6 }, { 0x0037,  6 },
        { 0x0076,  8 }, { 0x0077,  8 }, { 0x0070,  7 }, { 0x001D,  5 },
        { 0x0071,  7 }, { 0x0072,  7 }, { 0x08A4, 13 }, { 0x0073,  7 },
        { 0x00F0,  8 }, { 0x08A5, 13 }, { 0x08A6, 13 }, { 0x08A7, 13 },
        { 0x0079,  7 }, { 0x007A,  7 }, { 0x08A8, 13 }, { 0x08A9, 13 },
        { 0x00F1,  8 }, { 0x08AA, 13 }, { 0x08AB, 13 }, { 0x08AC, 13 },
        { 0x08AD, 13 }, { 0x00F6,  8 }, { 0x08AE, 13 }, { 0x007C,  7 },
        { 0x00F7,  8 }, { 0x08AF, 13 }, { 0x08B0, 13 }, { 0x08B1, 13 },
        { 0x08B2, 13 }, { 0x00FA,  8 }, { 0x08B3, 13 }, { 0x08B4, 13 },
        { 0x08B5, 13 }, { 0x08B6, 13 }, { 0x08B7, 13 }, { 0x00FB,  8 },
        { 0x045C, 12 }, { 0x003F,  6 }, { 0x045D, 12 }, { 0x045E, 12 },
        { 0x045F, 12 },
    },
};

static const uint16_t x8_ac1_lowquant_table[8][77][2] = {
    { // 0
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x0003,  4 }, { 0x0008,  5 },
        { 0x0012,  6 }, { 0x0026,  7 }, { 0x0014,  6 }, { 0x004E,  8 },
        { 0x004F,  8 }, { 0x00A8,  9 }, { 0x0152, 10 }, { 0x00AA,  9 },
        { 0x00AB,  9 }, { 0x00AC,  9 }, { 0x2A60, 15 }, { 0x02A7, 11 },
        { 0x0006,  4 }, { 0x000B,  5 }, { 0x001C,  6 }, { 0x003A,  7 },
        { 0x000F,  5 }, { 0x003B,  7 }, { 0x0010,  5 }, { 0x0005,  3 },
        { 0x0009,  4 }, { 0x0011,  5 }, { 0x0018,  5 }, { 0x0019,  5 },
        { 0x001A,  5 }, { 0x0036,  6 }, { 0x0037,  6 }, { 0x0070,  7 },
        { 0x0057,  8 }, { 0x00E2,  8 }, { 0x00E3,  8 }, { 0x00E4,  8 },
        { 0x00E5,  8 }, { 0x00AD,  9 }, { 0x0398, 10 }, { 0x003A,  6 },
        { 0x0076,  7 }, { 0x00E7,  8 }, { 0x00EE,  8 }, { 0x00EF,  8 },
        { 0x0732, 11 }, { 0x039A, 10 }, { 0x0733, 11 }, { 0x2A61, 15 },
        { 0x0078,  7 }, { 0x1531, 14 }, { 0x1532, 14 }, { 0x1533, 14 },
        { 0x003D,  6 }, { 0x039B, 10 }, { 0x1534, 14 }, { 0x1535, 14 },
        { 0x1536, 14 }, { 0x0079,  7 }, { 0x1537, 14 }, { 0x00F8,  8 },
        { 0x01F2,  9 }, { 0x07CC, 11 }, { 0x03E7, 10 }, { 0x07CD, 11 },
        { 0x3E80, 14 }, { 0x00FB,  8 }, { 0x03E9, 10 }, { 0x3E81, 14 },
        { 0x3E82, 14 }, { 0x3E83, 14 }, { 0x3E84, 14 }, { 0x3E85, 14 },
        { 0x3E86, 14 }, { 0x003F,  6 }, { 0x01F5,  9 }, { 0x07D1, 11 },
        { 0x3E87, 14 },
    },
    { // 1
        { 0x0000,  2 }, { 0x0002,  3 }, { 0x0006,  4 }, { 0x000E,  5 },
        { 0x001E,  6 }, { 0x001F,  6 }, { 0x0040,  7 }, { 0x0082,  8 },
        { 0x0083,  8 }, { 0x0084,  8 }, { 0x010A,  9 }, { 0x010B,  9 },
        { 0x0430, 11 }, { 0x0431, 11 }, { 0x0432, 11 }, { 0x0433, 11 },
        { 0x0005,  3 }, { 0x0011,  5 }, { 0x0024,  6 }, { 0x004A,  7 },
        { 0x000C,  4 }, { 0x0026,  6 }, { 0x000D,  4 }, { 0x0087,  8 },
        { 0x010D,  9 }, { 0x0258, 10 }, { 0x012D,  9 }, { 0x0259, 10 },
        { 0x025C, 10 }, { 0x0974, 12 }, { 0x025E, 10 }, { 0x025F, 10 },
        { 0x0270, 10 }, { 0x0271, 10 }, { 0x04BB, 11 }, { 0x0975, 12 },
        { 0x0272, 10 }, { 0x09CC, 12 }, { 0x09CD, 12 }, { 0x4E70, 15 },
        { 0x4E71, 15 }, { 0x4E72, 15 }, { 0x4E73, 15 }, { 0x273A, 14 },
        { 0x273B, 14 }, { 0x273C, 14 }, { 0x04E8, 11 }, { 0x04E9, 11 },
        { 0x009E,  8 }, { 0x0275, 10 }, { 0x09D8, 12 }, { 0x273D, 14 },
        { 0x000E,  4 }, { 0x003C,  6 }, { 0x007A,  7 }, { 0x009F,  8 },
        { 0x0277, 10 }, { 0x003E,  6 }, { 0x00F6,  8 }, { 0x04ED, 11 },
        { 0x03DC, 10 }, { 0x273E, 14 }, { 0x07BA, 11 }, { 0x09D9, 12 },
        { 0x273F, 14 }, { 0x3DD8, 14 }, { 0x3DD9, 14 }, { 0x3DDA, 14 },
        { 0x3DDB, 14 }, { 0x3DDC, 14 }, { 0x3DDD, 14 }, { 0x3DDE, 14 },
        { 0x3DDF, 14 }, { 0x003F,  6 }, { 0x07BC, 11 }, { 0x07BD, 11 },
        { 0x03DF, 10 },
    },
    { // 2
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x0006,  5 }, { 0x000E,  6 },
        { 0x001E,  7 }, { 0x003E,  8 }, { 0x003F,  8 }, { 0x0040,  8 },
        { 0x0104, 10 }, { 0x0083,  9 }, { 0x0105, 10 }, { 0x0108, 10 },
        { 0x4240, 16 }, { 0x010A, 10 }, { 0x010B, 10 }, { 0x4241, 16 },
        { 0x0003,  3 }, { 0x0009,  5 }, { 0x0011,  6 }, { 0x0043,  8 },
        { 0x0004,  3 }, { 0x000A,  5 }, { 0x000A,  4 }, { 0x002C,  7 },
        { 0x00B4,  9 }, { 0x00B5,  9 }, { 0x00B6,  9 }, { 0x00B7,  9 },
        { 0x00B8,  9 }, { 0x0172, 10 }, { 0x0173, 10 }, { 0x0174, 10 },
        { 0x0175, 10 }, { 0x0176, 10 }, { 0x0177, 10 }, { 0x00BC,  9 },
        { 0x017A, 10 }, { 0x0213, 11 }, { 0x4242, 16 }, { 0x017B, 10 },
        { 0x02F8, 11 }, { 0x017D, 10 }, { 0x02F9, 11 }, { 0x017E, 10 },
        { 0x4243, 16 }, { 0x02FE, 11 }, { 0x2122, 15 }, { 0x2123, 15 },
        { 0x0058,  7 }, { 0x0164,  9 }, { 0x2124, 15 }, { 0x2125, 15 },
        { 0x0006,  3 }, { 0x000E,  4 }, { 0x002D,  6 }, { 0x002E,  6 },
        { 0x00B3,  8 }, { 0x001E,  5 }, { 0x005E,  7 }, { 0x2126, 15 },
        { 0x2127, 15 }, { 0x2128, 15 }, { 0x2129, 15 }, { 0x02FF, 11 },
        { 0x212A, 15 }, { 0x0594, 11 }, { 0x0595, 11 }, { 0x0596, 11 },
        { 0x212B, 15 }, { 0x212C, 15 }, { 0x212D, 15 }, { 0x212E, 15 },
        { 0x212F, 15 }, { 0x001F,  5 }, { 0x0597, 11 }, { 0x00BE,  8 },
        { 0x00BF,  8 },
    },
    { // 3
        { 0x0000,  2 }, { 0x0002,  3 }, { 0x0006,  4 }, { 0x0007,  4 },
        { 0x0010,  5 }, { 0x0011,  5 }, { 0x0024,  6 }, { 0x0025,  6 },
        { 0x0026,  6 }, { 0x0027,  6 }, { 0x0050,  7 }, { 0x0051,  7 },
        { 0x00A4,  8 }, { 0x00A5,  8 }, { 0x00A6,  8 }, { 0x014E,  9 },
        { 0x000B,  4 }, { 0x002A,  6 }, { 0x0056,  7 }, { 0x014F,  9 },
        { 0x0030,  6 }, { 0x00AE,  8 }, { 0x0062,  7 }, { 0x0032,  6 },
        { 0x0033,  6 }, { 0x0034,  6 }, { 0x0035,  6 }, { 0x0036,  6 },
        { 0x0063,  7 }, { 0x006E,  7 }, { 0x006F,  7 }, { 0x0070,  7 },
        { 0x0071,  7 }, { 0x0072,  7 }, { 0x0073,  7 }, { 0x0074,  7 },
        { 0x00AF,  8 }, { 0x00EA,  8 }, { 0x01D6,  9 }, { 0x075C, 11 },
        { 0x03AF, 10 }, { 0x75D0, 15 }, { 0x75D1, 15 }, { 0x75D2, 15 },
        { 0x75D3, 15 }, { 0x75D4, 15 }, { 0x0076,  7 }, { 0x00EE,  8 },
        { 0x00EF,  8 }, { 0x0EBB, 12 }, { 0x01E0,  9 }, { 0x75D5, 15 },
        { 0x0079,  7 }, { 0x01E1,  9 }, { 0x75D6, 15 }, { 0x75D7, 15 },
        { 0x7880, 15 }, { 0x00F4,  8 }, { 0x0789, 11 }, { 0x003E,  6 },
        { 0x007B,  7 }, { 0x00F5,  8 }, { 0x00FC,  8 }, { 0x007F,  7 },
        { 0x01E3,  9 }, { 0x078A, 11 }, { 0x078B, 11 }, { 0x7881, 15 },
        { 0x7882, 15 }, { 0x7883, 15 }, { 0x3C42, 14 }, { 0x3C43, 14 },
        { 0x3C44, 14 }, { 0x00FD,  8 }, { 0x3C45, 14 }, { 0x3C46, 14 },
        { 0x3C47, 14 },
    },
    { // 4
        { 0x0000,  2 }, { 0x0004,  4 }, { 0x000A,  5 }, { 0x0016,  6 },
        { 0x0017,  6 }, { 0x0030,  7 }, { 0x0031,  7 }, { 0x0064,  8 },
        { 0x0065,  8 }, { 0x0066,  8 }, { 0x00CE,  9 }, { 0x00CF,  9 },
        { 0x01A0, 10 }, { 0x01A1, 10 }, { 0x1A20, 14 }, { 0x0689, 12 },
        { 0x0004,  3 }, { 0x000E,  5 }, { 0x001B,  6 }, { 0x0035,  7 },
        { 0x000A,  4 }, { 0x001E,  6 }, { 0x0016,  5 }, { 0x0017,  5 },
        { 0x001F,  6 }, { 0x0030,  6 }, { 0x0031,  6 }, { 0x0064,  7 },
        { 0x0065,  7 }, { 0x0069,  8 }, { 0x0066,  7 }, { 0x00CE,  8 },
        { 0x00CF,  8 }, { 0x00D0,  8 }, { 0x00D1,  8 }, { 0x00D2,  8 },
        { 0x01A6,  9 }, { 0x01A3, 10 }, { 0x034E, 10 }, { 0x006A,  7 },
        { 0x00D6,  8 }, { 0x01AE,  9 }, { 0x01AF,  9 }, { 0x034F, 10 },
        { 0x0345, 11 }, { 0x01B0,  9 }, { 0x01B1,  9 }, { 0x0364, 10 },
        { 0x006D,  7 }, { 0x00DC,  8 }, { 0x0D94, 12 }, { 0x0D95, 12 },
        { 0x000E,  4 }, { 0x003C,  6 }, { 0x00DD,  8 }, { 0x00DE,  8 },
        { 0x01B3,  9 }, { 0x003D,  6 }, { 0x00DF,  8 }, { 0x01F0,  9 },
        { 0x03E2, 10 }, { 0x03E3, 10 }, { 0x06CB, 11 }, { 0x03E4, 10 },
        { 0x07CA, 11 }, { 0x01F3,  9 }, { 0x01F4,  9 }, { 0x07CB, 11 },
        { 0x07D4, 11 }, { 0x1A21, 14 }, { 0x1A22, 14 }, { 0x07D5, 11 },
        { 0x1A23, 14 }, { 0x003F,  6 }, { 0x01F6,  9 }, { 0x01F7,  9 },
        { 0x03EB, 10 },
    },
    { // 5
        { 0x0000,  2 }, { 0x0002,  3 }, { 0x0006,  4 }, { 0x000E,  5 },
        { 0x000F,  5 }, { 0x0020,  6 }, { 0x0021,  6 }, { 0x0044,  7 },
        { 0x0045,  7 }, { 0x0046,  7 }, { 0x008E,  8 }, { 0x008F,  8 },
        { 0x0090,  8 }, { 0x0122,  9 }, { 0x0246, 10 }, { 0x0124,  9 },
        { 0x0005,  3 }, { 0x0013,  5 }, { 0x004A,  7 }, { 0x0093,  8 },
        { 0x0018,  5 }, { 0x004B,  7 }, { 0x0032,  6 }, { 0x001A,  5 },
        { 0x0033,  6 }, { 0x006C,  7 }, { 0x006D,  7 }, { 0x006E,  7 },
        { 0x00DE,  8 }, { 0x00DF,  8 }, { 0x0070,  7 }, { 0x00E2,  8 },
        { 0x00E3,  8 }, { 0x00E4,  8 }, { 0x00E5,  8 }, { 0x00E6,  8 },
        { 0x00E7,  8 }, { 0x0125,  9 }, { 0x01D0,  9 }, { 0x048E, 11 },
        { 0x091E, 12 }, { 0x091F, 12 }, { 0x7440, 15 }, { 0x1D11, 13 },
        { 0x7441, 15 }, { 0x7442, 15 }, { 0x00E9,  8 }, { 0x01D4,  9 },
        { 0x00EB,  8 }, { 0x03A3, 10 }, { 0x01D5,  9 }, { 0x1D12, 13 },
        { 0x001E,  5 }, { 0x0076,  7 }, { 0x01DC,  9 }, { 0x01DD,  9 },
        { 0x7443, 15 }, { 0x007C,  7 }, { 0x0745, 11 }, { 0x00EF,  8 },
        { 0x00FA,  8 }, { 0x00FB,  8 }, { 0x01F8,  9 }, { 0x00FD,  8 },
        { 0x07E4, 11 }, { 0x0FCA, 12 }, { 0x1D13, 13 }, { 0x7E58, 15 },
        { 0x7E59, 15 }, { 0x7E5A, 15 }, { 0x7E5B, 15 }, { 0x7E5C, 15 },
        { 0x7E5D, 15 }, { 0x007F,  7 }, { 0x3F2F, 14 }, { 0x07E6, 11 },
        { 0x07E7, 11 },
    },
    { // 6
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x0003,  4 }, { 0x0008,  5 },
        { 0x0009,  5 }, { 0x0014,  6 }, { 0x0015,  6 }, { 0x002C,  7 },
        { 0x005A,  8 }, { 0x005B,  8 }, { 0x005C,  8 }, { 0x00BA,  9 },
        { 0x00BB,  9 }, { 0x00BC,  9 }, { 0x02F4, 11 }, { 0x05EA, 12 },
        { 0x0003,  3 }, { 0x0010,  5 }, { 0x0022,  6 }, { 0x0046,  7 },
        { 0x0009,  4 }, { 0x0028,  6 }, { 0x0015,  5 }, { 0x000B,  4 },
        { 0x0018,  5 }, { 0x0029,  6 }, { 0x0032,  6 }, { 0x0047,  7 },
        { 0x0066,  7 }, { 0x0067,  7 }, { 0x0068,  7 }, { 0x0069,  7 },
        { 0x006A,  7 }, { 0x005F,  8 }, { 0x00D6,  8 }, { 0x00D7,  8 },
        { 0x01B0,  9 }, { 0x00D9,  8 }, { 0x017B, 10 }, { 0x006D,  7 },
        { 0x00DC,  8 }, { 0x01B1,  9 }, { 0x06E8, 11 }, { 0x01BB,  9 },
        { 0x0375, 10 }, { 0x05EB, 12 }, { 0x01BC,  9 }, { 0x6E90, 15 },
        { 0x0038,  6 }, { 0x0072,  7 }, { 0x6E91, 15 }, { 0x6E92, 15 },
        { 0x001D,  5 }, { 0x0073,  7 }, { 0x01BD,  9 }, { 0x06F8, 11 },
        { 0x6E93, 15 }, { 0x003C,  6 }, { 0x01BF,  9 }, { 0x00F4,  8 },
        { 0x01EA,  9 }, { 0x037D, 10 }, { 0x03D6, 10 }, { 0x06F9, 11 },
        { 0x6E94, 15 }, { 0x00F6,  8 }, { 0x01EE,  9 }, { 0x6E95, 15 },
        { 0x6E96, 15 }, { 0x6E97, 15 }, { 0x374C, 14 }, { 0x374D, 14 },
        { 0x374E, 14 }, { 0x001F,  5 }, { 0x03D7, 10 }, { 0x01EF,  9 },
        { 0x374F, 14 },
    },
    { // 7
        { 0x0000,  2 }, { 0x0004,  4 }, { 0x000A,  5 }, { 0x0016,  6 },
        { 0x002E,  7 }, { 0x002F,  7 }, { 0x0060,  8 }, { 0x0061,  8 },
        { 0x00C4,  9 }, { 0x00C5,  9 }, { 0x00C6,  9 }, { 0x018E, 10 },
        { 0x31E0, 15 }, { 0x31E1, 15 }, { 0x31E2, 15 }, { 0x31E3, 15 },
        { 0x0004,  3 }, { 0x000D,  5 }, { 0x0019,  6 }, { 0x0038,  7 },
        { 0x000A,  4 }, { 0x001D,  6 }, { 0x000B,  4 }, { 0x0072,  8 },
        { 0x0073,  8 }, { 0x00F0,  9 }, { 0x01E2, 10 }, { 0x00F2,  9 },
        { 0x01E3, 10 }, { 0x00F3,  9 }, { 0x01E8, 10 }, { 0x01E9, 10 },
        { 0x31E4, 15 }, { 0x01EA, 10 }, { 0x031F, 11 }, { 0x03D6, 11 },
        { 0x31E5, 15 }, { 0x01EC, 10 }, { 0x31E6, 15 }, { 0x00F7,  9 },
        { 0x03D7, 11 }, { 0x31E7, 15 }, { 0x31E8, 15 }, { 0x03DA, 11 },
        { 0x03DB, 11 }, { 0x31E9, 15 }, { 0x03E0, 11 }, { 0x31EA, 15 },
        { 0x003F,  7 }, { 0x01F1, 10 }, { 0x31EB, 15 }, { 0x31EC, 15 },
        { 0x0006,  3 }, { 0x001C,  5 }, { 0x0074,  7 }, { 0x0075,  7 },
        { 0x00F9,  9 }, { 0x001E,  5 }, { 0x0076,  7 }, { 0x00FA,  9 },
        { 0x03E1, 11 }, { 0x31ED, 15 }, { 0x18F7, 14 }, { 0x1F60, 14 },
        { 0x1F61, 14 }, { 0x01DC,  9 }, { 0x01DD,  9 }, { 0x1F62, 14 },
        { 0x1F63, 14 }, { 0x1F64, 14 }, { 0x1F65, 14 }, { 0x1F66, 14 },
        { 0x1F67, 14 }, { 0x001F,  5 }, { 0x03ED, 11 }, { 0x00EF,  8 },
        { 0x01F7, 10 },
    },
};

static const uint16_t x8_ac1_highquant_table[8][77][2] = {
    { // 0
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x0006,  5 }, { 0x0007,  5 },
        { 0x0008,  5 }, { 0x0009,  5 }, { 0x0014,  6 }, { 0x002A,  7 },
        { 0x0016,  6 }, { 0x002B,  7 }, { 0x005C,  8 }, { 0x002F,  7 },
        { 0x0030,  7 }, { 0x005D,  8 }, { 0x0062,  8 }, { 0x00C6,  9 },
        { 0x0007,  4 }, { 0x0019,  6 }, { 0x001A,  6 }, { 0x0036,  7 },
        { 0x0010,  5 }, { 0x006E,  8 }, { 0x0022,  6 }, { 0x0009,  4 },
        { 0x000A,  4 }, { 0x0016,  5 }, { 0x0023,  6 }, { 0x002E,  6 },
        { 0x002F,  6 }, { 0x0030,  6 }, { 0x0062,  7 }, { 0x0063,  7 },
        { 0x0064,  7 }, { 0x0065,  7 }, { 0x0066,  7 }, { 0x0067,  7 },
        { 0x0068,  7 }, { 0x0069,  7 }, { 0x006A,  7 }, { 0x006B,  7 },
        { 0x006C,  7 }, { 0x00C7,  9 }, { 0x00DE,  9 }, { 0x00DF,  9 },
        { 0x06D0, 11 }, { 0x01B5,  9 }, { 0x0037,  6 }, { 0x00DB,  8 },
        { 0x001C,  5 }, { 0x0074,  7 }, { 0x01D4,  9 }, { 0x01D5,  9 },
        { 0x0076,  7 }, { 0x0369, 10 }, { 0x3688, 14 }, { 0x3689, 14 },
        { 0x368A, 14 }, { 0x0077,  7 }, { 0x03AC, 10 }, { 0x0078,  7 },
        { 0x00F2,  8 }, { 0x01D7,  9 }, { 0x00F3,  8 }, { 0x007A,  7 },
        { 0x368B, 14 }, { 0x007B,  7 }, { 0x007C,  7 }, { 0x03AD, 10 },
        { 0x03E8, 10 }, { 0x368C, 14 }, { 0x368D, 14 }, { 0x03E9, 10 },
        { 0x368E, 14 }, { 0x003F,  6 }, { 0x01F5,  9 }, { 0x00FB,  8 },
        { 0x368F, 14 },
    },
    { // 1
        { 0x0000,  2 }, { 0x0004,  4 }, { 0x000A,  5 }, { 0x000B,  5 },
        { 0x0018,  6 }, { 0x0032,  7 }, { 0x0033,  7 }, { 0x0034,  7 },
        { 0x006A,  8 }, { 0x00D6,  9 }, { 0x00D7,  9 }, { 0x00D8,  9 },
        { 0x00D9,  9 }, { 0x3680, 15 }, { 0x01B5, 10 }, { 0x0369, 11 },
        { 0x0004,  3 }, { 0x000E,  5 }, { 0x001E,  6 }, { 0x0037,  7 },
        { 0x000A,  4 }, { 0x0016,  5 }, { 0x000C,  4 }, { 0x001F,  6 },
        { 0x005C,  7 }, { 0x005D,  7 }, { 0x00BC,  8 }, { 0x00BD,  8 },
        { 0x005F,  7 }, { 0x00D0,  8 }, { 0x00DB,  9 }, { 0x00D1,  8 },
        { 0x01A4,  9 }, { 0x01A5,  9 }, { 0x01A6,  9 }, { 0x01A7,  9 },
        { 0x0350, 10 }, { 0x06A2, 11 }, { 0x06A3, 11 }, { 0x01A9,  9 },
        { 0x01AA,  9 }, { 0x06AC, 11 }, { 0x3681, 15 }, { 0x0357, 10 },
        { 0x3682, 15 }, { 0x3683, 15 }, { 0x3684, 15 }, { 0x3685, 15 },
        { 0x0036,  6 }, { 0x00D6,  8 }, { 0x3686, 15 }, { 0x3687, 15 },
        { 0x000E,  4 }, { 0x006E,  7 }, { 0x00D7,  8 }, { 0x06AD, 11 },
        { 0x3688, 15 }, { 0x001E,  5 }, { 0x00DE,  8 }, { 0x06F8, 11 },
        { 0x037D, 10 }, { 0x3689, 15 }, { 0x368A, 15 }, { 0x368B, 15 },
        { 0x368C, 15 }, { 0x01BF,  9 }, { 0x368D, 15 }, { 0x1B47, 14 },
        { 0x37C8, 14 }, { 0x37C9, 14 }, { 0x37CA, 14 }, { 0x37CB, 14 },
        { 0x37CC, 14 }, { 0x001F,  5 }, { 0x37CD, 14 }, { 0x37CE, 14 },
        { 0x37CF, 14 },
    },
    { // 2
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x0003,  4 }, { 0x0008,  5 },
        { 0x0012,  6 }, { 0x0026,  7 }, { 0x0014,  6 }, { 0x0027,  7 },
        { 0x00A8,  9 }, { 0x00A9,  9 }, { 0x0055,  8 }, { 0x2B00, 15 },
        { 0x00AD,  9 }, { 0x2B01, 15 }, { 0x2B02, 15 }, { 0x2B03, 15 },
        { 0x0003,  3 }, { 0x000B,  5 }, { 0x0040,  7 }, { 0x0041,  7 },
        { 0x0009,  4 }, { 0x0021,  6 }, { 0x0011,  5 }, { 0x000A,  4 },
        { 0x000B,  4 }, { 0x0018,  5 }, { 0x0032,  6 }, { 0x0033,  6 },
        { 0x0034,  6 }, { 0x0035,  6 }, { 0x006C,  7 }, { 0x0057,  8 },
        { 0x006D,  7 }, { 0x00DC,  8 }, { 0x0159, 10 }, { 0x00DD,  8 },
        { 0x01BC,  9 }, { 0x037A, 10 }, { 0x037B, 10 }, { 0x0038,  6 },
        { 0x0072,  7 }, { 0x01BE,  9 }, { 0x01BF,  9 }, { 0x00E6,  8 },
        { 0x039C, 10 }, { 0x01CF,  9 }, { 0x2B04, 15 }, { 0x2B05, 15 },
        { 0x0074,  7 }, { 0x01D4,  9 }, { 0x2B06, 15 }, { 0x2B07, 15 },
        { 0x001E,  5 }, { 0x00EB,  8 }, { 0x1584, 14 }, { 0x1585, 14 },
        { 0x1586, 14 }, { 0x003B,  6 }, { 0x01D5,  9 }, { 0x01F0,  9 },
        { 0x039D, 10 }, { 0x03E2, 10 }, { 0x1587, 14 }, { 0x1588, 14 },
        { 0x1589, 14 }, { 0x00F9,  8 }, { 0x158A, 14 }, { 0x158B, 14 },
        { 0x03E3, 10 }, { 0x158C, 14 }, { 0x158D, 14 }, { 0x01F4,  9 },
        { 0x158E, 14 }, { 0x003F,  6 }, { 0x00FB,  8 }, { 0x01F5,  9 },
        { 0x158F, 14 },
    },
    { // 3
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x0006,  5 }, { 0x0007,  5 },
        { 0x0010,  6 }, { 0x0011,  6 }, { 0x0024,  7 }, { 0x0025,  7 },
        { 0x0013,  6 }, { 0x0014,  6 }, { 0x002A,  7 }, { 0x002B,  7 },
        { 0x00B0,  9 }, { 0x00B1,  9 }, { 0x002D,  7 }, { 0x0059,  8 },
        { 0x000C,  5 }, { 0x0017,  6 }, { 0x00D0,  9 }, { 0x0035,  7 },
        { 0x001B,  6 }, { 0x0038,  7 }, { 0x0039,  7 }, { 0x0004,  3 },
        { 0x0005,  3 }, { 0x000F,  5 }, { 0x0018,  5 }, { 0x001D,  6 },
        { 0x0032,  6 }, { 0x0033,  6 }, { 0x0068,  7 }, { 0x0069,  7 },
        { 0x0069,  8 }, { 0x00D4,  8 }, { 0x00D5,  8 }, { 0x00D6,  8 },
        { 0x006C,  7 }, { 0x0037,  6 }, { 0x006D,  7 }, { 0x0070,  7 },
        { 0x0039,  6 }, { 0x00D7,  8 }, { 0x00D1,  9 }, { 0x3880, 14 },
        { 0x3881, 14 }, { 0x3882, 14 }, { 0x0074,  7 }, { 0x01C5,  9 },
        { 0x0075,  7 }, { 0x00E3,  8 }, { 0x3883, 14 }, { 0x3884, 14 },
        { 0x00EC,  8 }, { 0x3885, 14 }, { 0x1C43, 13 }, { 0x1C44, 13 },
        { 0x1C45, 13 }, { 0x00ED,  8 }, { 0x1C46, 13 }, { 0x003C,  6 },
        { 0x0077,  7 }, { 0x01E8,  9 }, { 0x003E,  6 }, { 0x007B,  7 },
        { 0x1C47, 13 }, { 0x007E,  7 }, { 0x007F,  7 }, { 0x1C48, 13 },
        { 0x1C49, 13 }, { 0x1C4A, 13 }, { 0x1C4B, 13 }, { 0x1C4C, 13 },
        { 0x1C4D, 13 }, { 0x00F5,  8 }, { 0x1C4E, 13 }, { 0x01E9,  9 },
        { 0x1C4F, 13 },
    },
    { // 4
        { 0x0000,  2 }, { 0x0004,  4 }, { 0x000A,  5 }, { 0x000B,  5 },
        { 0x0018,  6 }, { 0x0019,  6 }, { 0x0034,  7 }, { 0x0035,  7 },
        { 0x0036,  7 }, { 0x006E,  8 }, { 0x00DE,  9 }, { 0x00DF,  9 },
        { 0x01C0, 10 }, { 0x01C1, 10 }, { 0x01C2, 10 }, { 0x3860, 15 },
        { 0x0004,  3 }, { 0x000F,  5 }, { 0x001D,  6 }, { 0x0039,  7 },
        { 0x000A,  4 }, { 0x002C,  6 }, { 0x002D,  6 }, { 0x000C,  4 },
        { 0x0017,  5 }, { 0x0034,  6 }, { 0x0035,  6 }, { 0x0036,  6 },
        { 0x006E,  7 }, { 0x006F,  7 }, { 0x0070,  7 }, { 0x0071,  7 },
        { 0x0071,  8 }, { 0x00E4,  8 }, { 0x00E5,  8 }, { 0x00E6,  8 },
        { 0x00E7,  8 }, { 0x00E8,  8 }, { 0x03A4, 10 }, { 0x0075,  7 },
        { 0x00EC,  8 }, { 0x01D3,  9 }, { 0x01DA,  9 }, { 0x03A5, 10 },
        { 0x03B6, 10 }, { 0x070D, 12 }, { 0x03B7, 10 }, { 0x070E, 12 },
        { 0x003C,  6 }, { 0x00EE,  8 }, { 0x3861, 15 }, { 0x3862, 15 },
        { 0x003D,  6 }, { 0x01DE,  9 }, { 0x3863, 15 }, { 0x3864, 15 },
        { 0x3865, 15 }, { 0x007C,  7 }, { 0x070F, 12 }, { 0x03BE, 10 },
        { 0x03BF, 10 }, { 0x3866, 15 }, { 0x0FA0, 12 }, { 0x07D1, 11 },
        { 0x3867, 15 }, { 0x00FB,  8 }, { 0x01F5,  9 }, { 0x7D08, 15 },
        { 0x0FA4, 12 }, { 0x7D09, 15 }, { 0x7D0A, 15 }, { 0x7D0B, 15 },
        { 0x3E86, 14 }, { 0x003F,  6 }, { 0x0FA5, 12 }, { 0x07D3, 11 },
        { 0x3E87, 14 },
    },
    { // 5
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x0003,  4 }, { 0x0008,  5 },
        { 0x0009,  5 }, { 0x0014,  6 }, { 0x002A,  7 }, { 0x0056,  8 },
        { 0x02B8, 11 }, { 0x00AF,  9 }, { 0x02B9, 11 }, { 0x015D, 10 },
        { 0x02C0, 11 }, { 0x2C10, 15 }, { 0x2C11, 15 }, { 0x2C12, 15 },
        { 0x0006,  4 }, { 0x000E,  5 }, { 0x0017,  6 }, { 0x002D,  7 },
        { 0x000F,  5 }, { 0x0040,  7 }, { 0x0021,  6 }, { 0x0005,  3 },
        { 0x0009,  4 }, { 0x0011,  5 }, { 0x0018,  5 }, { 0x0019,  5 },
        { 0x001A,  5 }, { 0x0036,  6 }, { 0x0037,  6 }, { 0x0041,  7 },
        { 0x0059,  8 }, { 0x00E0,  8 }, { 0x00E1,  8 }, { 0x0071,  7 },
        { 0x00E4,  8 }, { 0x00B1,  9 }, { 0x02C2, 11 }, { 0x001D,  5 },
        { 0x0073,  7 }, { 0x00E5,  8 }, { 0x00F0,  8 }, { 0x0079,  7 },
        { 0x03C4, 10 }, { 0x01E3,  9 }, { 0x01E8,  9 }, { 0x2C13, 15 },
        { 0x007B,  7 }, { 0x2C14, 15 }, { 0x2C15, 15 }, { 0x2C16, 15 },
        { 0x007C,  7 }, { 0x02C3, 11 }, { 0x2C17, 15 }, { 0x160C, 14 },
        { 0x160D, 14 }, { 0x007D,  7 }, { 0x160E, 14 }, { 0x01E9,  9 },
        { 0x03C5, 10 }, { 0x03D4, 10 }, { 0x01EB,  9 }, { 0x160F, 14 },
        { 0x3D50, 14 }, { 0x00FC,  8 }, { 0x07AB, 11 }, { 0x3D51, 14 },
        { 0x3D52, 14 }, { 0x3D53, 14 }, { 0x3D54, 14 }, { 0x01FA,  9 },
        { 0x3D55, 14 }, { 0x007F,  7 }, { 0x01FB,  9 }, { 0x3D56, 14 },
        { 0x3D57, 14 },
    },
    { // 6
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x0003,  4 }, { 0x0008,  5 },
        { 0x0009,  5 }, { 0x000A,  5 }, { 0x000B,  5 }, { 0x0018,  6 },
        { 0x0032,  7 }, { 0x000D,  5 }, { 0x0033,  7 }, { 0x0E00, 13 },
        { 0x0039,  7 }, { 0x0E01, 13 }, { 0x003A,  7 }, { 0x0E02, 13 },
        { 0x0008,  4 }, { 0x001E,  6 }, { 0x003B,  7 }, { 0x003E,  7 },
        { 0x0012,  5 }, { 0x003F,  7 }, { 0x0013,  5 }, { 0x0028,  6 },
        { 0x0029,  6 }, { 0x0054,  7 }, { 0x002B,  6 }, { 0x0055,  7 },
        { 0x0058,  7 }, { 0x0E03, 13 }, { 0x0059,  7 }, { 0x005A,  7 },
        { 0x0E04, 13 }, { 0x0E05, 13 }, { 0x0703, 12 }, { 0x005B,  7 },
        { 0x005C,  7 }, { 0x0704, 12 }, { 0x0705, 12 }, { 0x005D,  7 },
        { 0x0706, 12 }, { 0x0707, 12 }, { 0x0708, 12 }, { 0x0709, 12 },
        { 0x070A, 12 }, { 0x070B, 12 }, { 0x0018,  5 }, { 0x002F,  6 },
        { 0x000D,  4 }, { 0x0019,  5 }, { 0x070C, 12 }, { 0x0070,  7 },
        { 0x001D,  5 }, { 0x070D, 12 }, { 0x070E, 12 }, { 0x070F, 12 },
        { 0x0710, 12 }, { 0x0039,  6 }, { 0x0711, 12 }, { 0x003C,  6 },
        { 0x0712, 12 }, { 0x0713, 12 }, { 0x0714, 12 }, { 0x0715, 12 },
        { 0x0716, 12 }, { 0x003D,  6 }, { 0x0717, 12 }, { 0x0718, 12 },
        { 0x0719, 12 }, { 0x071A, 12 }, { 0x071B, 12 }, { 0x071C, 12 },
        { 0x071D, 12 }, { 0x001F,  5 }, { 0x071E, 12 }, { 0x0071,  7 },
        { 0x071F, 12 },
    },
    { // 7
        { 0x0000,  3 }, { 0x0002,  4 }, { 0x0006,  5 }, { 0x000E,  6 },
        { 0x000F,  6 }, { 0x0040,  8 }, { 0x0041,  8 }, { 0x0042,  8 },
        { 0x0218, 11 }, { 0x2190, 15 }, { 0x2191, 15 }, { 0x2192, 15 },
        { 0x2193, 15 }, { 0x2194, 15 }, { 0x2195, 15 }, { 0x2196, 15 },
        { 0x0005,  4 }, { 0x0011,  6 }, { 0x0024,  7 }, { 0x0087,  9 },
        { 0x000C,  5 }, { 0x004A,  8 }, { 0x004B,  8 }, { 0x0002,  2 },
        { 0x0006,  3 }, { 0x000D,  5 }, { 0x000E,  5 }, { 0x000F,  5 },
        { 0x0013,  6 }, { 0x0038,  6 }, { 0x00E4,  8 }, { 0x00E5,  8 },
        { 0x01CC,  9 }, { 0x00E7,  8 }, { 0x0074,  7 }, { 0x00EA,  8 },
        { 0x01CD,  9 }, { 0x021A, 11 }, { 0x2197, 15 }, { 0x001E,  5 },
        { 0x0076,  7 }, { 0x00EB,  8 }, { 0x01DC,  9 }, { 0x00EF,  8 },
        { 0x01DD,  9 }, { 0x01F0,  9 }, { 0x2198, 15 }, { 0x2199, 15 },
        { 0x00F9,  8 }, { 0x03E2, 10 }, { 0x219A, 15 }, { 0x219B, 15 },
        { 0x00FA,  8 }, { 0x219C, 15 }, { 0x219D, 15 }, { 0x219E, 15 },
        { 0x219F, 15 }, { 0x01F6,  9 }, { 0x21B0, 15 }, { 0x00FC,  8 },
        { 0x01F7,  9 }, { 0x21B1, 15 }, { 0x21B2, 15 }, { 0x21B3, 15 },
        { 0x21B4, 15 }, { 0x01FA,  9 }, { 0x21B5, 15 }, { 0x21B6, 15 },
        { 0x21B7, 15 }, { 0x21B8, 15 }, { 0x21B9, 15 }, { 0x03E3, 10 },
        { 0x10DD, 14 }, { 0x007F,  7 }, { 0x01FB,  9 }, { 0x10DE, 14 },
        { 0x10DF, 14 },
    },
};
#define MAX_AC_VLC_BITS 16

#endif /* AVCODEC_INTRAX8HUF_H */
