// Generated by Bisonc++ V6.04.04 on Fri, 17 Mar 2023 09:12:30 +0100

#ifndef Parser_h_included
#define Parser_h_included

#include <string>
#include <fstream>
#include <unordered_map>

#include "parserbase.h"
#include "../scanner/scanner.h"

#include "../enums/enums.h"

class Filter;

class Parser: public ParserBase
{
    Scanner d_scanner;
    Filter &d_filter;

    std::string d_expect;               // syntax error messages
    bool d_onlyParse;
    bool d_received;                    // show received info at errors
    bool d_syntax;                      // only syntax check

    static std::unordered_map<int, eMatchMode> s_matchMode;

    public:
        Parser(Filter &filter, bool syntax);
        int parse();

    private:
                                            // syntax error: continue, or
        void action();                      // perform action and ACCEPT()
        void matchMode();                   // matchMode letter received
        void condTerm();                    // maybe stop file switching
        void date();                        // fwd the rule's DATE idx
        void expression(eTruth truth);       //   calls d_filter
        void hdr();                         // activate the header to use
        void addRule();                     // handles the rule's NR data
        void regex();                       // calls d_filter

                                            // currently: always to EOF
        void endRule();          // set Rule::matched

        void beginRules();                  // start processing a Rules file
        void startIf();                     // reset all at an if-stmnt

        std::string const &matched() const; // d_scanner.matched()

        void error();                   // called on (syntax) errors
        int lex();                      // returns the next token from the
                                        // lexical scanner. 
        void print();                   // use, e.g., d_token, d_loc
        void exceptionHandler(std::exception const &exc);

    // support functions for parse():
        void executeAction_(int ruleNr);
        void errorRecovery_();
        void nextCycle_();
        void nextToken_();
        void print_();
};

#endif
