/*
 * Copyright (C) 1999-2016  Andrej N. Gritsenko <andrej@rep.kiev.ua>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc.,
 *     51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * This file is part of FoxEye's source: variables and functions API.
 */

#ifndef INIT_C

WHERE const char *_VERSION	INITVAL("0.12.0");

	/* public part */
typedef char bool;
#define ASK		(1<<1)			/* ask-yes, ask-no */
#define CAN_ASK		(1<<2)			/* allow above two */

WHERE bool O_MAKEFILES		INITVAL(FALSE);
WHERE bool O_TESTCONF		INITVAL(FALSE);
WHERE bool O_DEFAULTCONF	INITVAL(FALSE);
WHERE bool O_GENERATECONF	INITVAL(FALSE);
WHERE bool O_WAIT		INITVAL(FALSE);
WHERE bool O_DDLOG		INITVAL(FALSE);
WHERE bool O_QUIET		INITVAL(FALSE);

WHERE short O_DLEVEL		INITVAL(0);
WHERE char *Config		INITVAL(NULL);
WHERE char *RunPath		INITVAL(NULL);
WHERE char *BindResult		INITVAL(NULL);
WHERE char *ShutdownR		INITVAL(NULL);
WHERE char *ReportFormat	INITVAL(NULL);
WHERE modeflag ReportMask	INITVAL(0);

WHERE time_t StartTime;

WHERE char TimeString[24]	INITVAL("");	/* "%H:%M" "%e %b" */
#define DateString (TimeString+6)
WHERE time_t Time;

#define ScriptFunction(a) int a (const char *args)
int RegisterFunction (const char *, int (*)(const char *), const char *);
int UnregisterFunction (const char *);
int RegisterInteger (const char *, long int *);
int RegisterBoolean (const char *, bool *);
int RegisterString (const char *, char *, size_t, int);
int UnregisterVariable (const char *);

typedef enum {
  VARIABLE_INTEGER = 0,
  VARIABLE_BOOLEAN,
  VARIABLE_CONSTANT,
  VARIABLE_STRING
} VariableType;

int GetVariable (const char *, VariableType, void **);

char *SetFormat (const char *, char *);		/* name, new value */
int Save_Formats (void);
short *FloodType (const char *);

int Config_Exec (const char *, const char *);
bool Confirm (char *, bool);

	/* core internal part */
INTERFACE *init (void);				/* [re]init functions */
char *IFInit_DCC (void);
char *IFInit_Users (void);
char *IFInit_Sheduler (void);

void Status_Interfaces (INTERFACE *);		/* for .status (dispatcher.c) */
void Status_Sheduler (INTERFACE *);		/* the same (sheduler.c) */
void Status_Clients (INTERFACE *);		/* the same (list.c) */
#ifdef HAVE_ICONV
void Status_Encodings (INTERFACE *);		/* the same (conversion.c) */
#endif
void Status_Connchains (INTERFACE *);		/* the same (connchain.c) */

#ifndef DISPATCHER_C
# define Command(a,b,c)		int b(const char *);
#ifdef __INIT_C
# define Bool(a,b,c)		bool b = c;
# define Integer(a,b,c)		long int b = c;
# define String(a,b,c)		char b[STRING] = c;
# define Const(a,b)
# define Flood(a,b,c)
# define Format(a,b)		char format_##a[FORMATMAX] = b;
#else /* __INIT_C */
# define Bool(a,b,c)		extern bool b;
# define Integer(a,b,c)		extern long int b;
# define String(a,b,c)		extern char b[STRING];
# define Const(a,b)
# define Flood(a,b,c)
# define Format(a,b)		extern char format_##a[FORMATMAX];
#endif /* __INIT_C */
#endif /* ifndef DISPATCHER_C */
#else /* ifndef INIT_C */
# define Command(a,b,c)		RegisterFunction (a, &b, c);
# define Bool(a,b,c)		RegisterBoolean (a, &b);
# define Integer(a,b,c)		RegisterInteger (a, &b);
# define String(a,b,c)		RegisterString (a, b, STRING, 0);
# define Const(a,b)		RegisterString (a, b, strlen(b), 1);
# define Flood(a,b,c)		_add_fl (#a, b, c);
# define Format(a,b)		_add_fmt (#a, format_##a);
#endif /* ifndef INIT_C */
#ifndef DISPATCHER_C
String  ("nick", Nick, "")			/* default nick and botnetnick */
Const   ("version", "0.12.0")
String  ("my-hostname", hostname, "")
String  ("locale", locale, "")
String	("charset", Charset, "")		/* used by couple of modules */
String  ("listfile", Listfile, "listfile")
String	("dcc-port-range", dcc_port_range, "")
Integer	("connection-timeout", dcc_timeout, 120)
Integer ("ident-timeout", ident_timeout, 60)
Flood   (dcc, 20, 5)
Bool    ("protect-telnet", drop_unknown, TRUE)
Command ("port", FE_port, "[-b] port")
String  ("motd", motd, "/home/andrej/foxeye/motd")
Integer ("cache-time", cache_time, 300)
String  ("wtmpfile", Wtmp, "Wtmp")
Integer ("wtmps", wtmps, 4)
String	("formatsfile", FormatsFile, "")
String	("replace-unknown-char", text_replace_char, "?")
Command ("module", FE_module, "name")		/* must be last :) */
#include "formats.default"
#undef Command
#undef Bool
#undef Integer
#undef String
#undef Const
#undef Flood
#undef Format
#endif /* ifndef DISPATCHER_C */
/* Integer	("dcc-blocksize", dcc_blksize, 4096) */
/* Integer ("max-dcc", max_dcc, 50) */
/* Integer ("reserved-port", port_files, 0) */
/* Bool    ("show-motd", motdon, TRUE) */
