Creating Subtitles from Scratch
===============================

Gaupol's built-in video player should allow you create subtitles from
scratch for a given video and the various tools provided should help if
some batch processing is needed. There are many possible work-flows for
subtitling – here's one simple approach that can get you started. All
the keys referred to below correspond to actions that you can find via
the menubar as well, but using the keyboard is necessary to be
productive.

1.  Open Gaupol and create a blank document: <kbd>File</kbd> ·
    <kbd>New</kbd>.

1.  Load the video file you wish to subtitle: <kbd>Video</kbd> ·
    <kbd>Load Video</kbd>.

1.  Play the video from start to finish (or maybe a scene at a time,
    whatever feels more comfortable). Press <kbd>J</kbd> whenever
    someone starts speaking a new subtitle length piece. A new subtitle
    will be inserted with a three second duration and a placeholder
    text.

1.  To correct for your reaction speed, hit <kbd>H</kbd>. If your
    reaction speed earlier has been e.g. half a second, shift all
    subtitles -0.5 seconds. If you're working a scene at a time, select
    the new subtitles and shift only those.

1.  Go over the video one subtitle at a time. Press <kbd>O</kbd> over
    and over again to play video of the selected subtitle as you make
    changes to the subtitle in question. Note that you don't need to
    wait for the subtitle playback to finish – whenever you hit
    <kbd>O</kbd> again, playback will resume from right before the
    subtitle start.

    1.  Write down what is said. Hit <kbd>S</kbd> and <kbd>M</kbd> to
        split and merge subtitles where needed to avoid too long or
        short subtitles, or too long pauses within a subtitle.

    1.  Use keys <kbd>Q</kbd> and <kbd>W</kbd> to adjust the subtitle
        start time so that it matches the video. Keep your right hand on
        <kbd>O</kbd> and alternate between adjustment and play until the
        match looks good.

    1.  Play the subtitle with <kbd>O</kbd>. Hit <kbd>K</kbd> during
        playback to set the end time of the subtitle. Adjust if needed
        with keys <kbd>E</kbd> and <kbd>R</kbd>, similar to the start
        time. Note that the end time doesn't need to match when speaking
        ends, but should instead be visible long enough to be read,
        although limited by the next subtitle or scene change.

1.  Once a scene or the whole video is subtitled, if you were not
    careful to avoid it, you'll notice that short subtitles disappear
    too fast. You can batch-fix that with <kbd>Tools</kbd> · <kbd>Adjust
    Durations</kbd>. Set a minimum duration and gap and possibly
    lengthening to match reading speed to ensure that subtitles remain
    on screen long enough to be read. Note that automatic lengthening
    can have adverse effects such as pushing subtitles across a scene
    change, but for some videos, such as conference presentations, there
    should be no harm.

1.  Done! Save your file! Share your work! The SubRip format is the most
    common and compatible subtitle file format and thus recommended for
    most uses, especially if you share your work for a wide audience.
