#! /usr/bin/env python

# Genetic
# Copyright (C) 2001 Jean-Baptiste LAMY
#
# This program is free software. See README or LICENSE for the license terms.

import random, string, math
from genetic import organism, lifecycle


# Set the function to minimize.

FUNC = lambda x, y: x ** 2 + y ** 2

class FUNCMinimizer(organism.Organism):
  characteristics = [
    organism.Characteristic("FUNC", FUNC, organism.RECESSIVE_PHENOTYPE)
    ]
  
  def __cmp__(self, other):
    return cmp(self.FUNC, other.FUNC)


# Create an initial set of organisms.
#
# This time, the organisms are already "perfect" : they minimize FUNC !
#
# As organisms don't need to evoluate, you will see __mutation__ and __mutampl__ falling
# down ! ANY mutation is bad here !

organismA = FUNCMinimizer([
  organism.Chromosom(x = 0.0, y = -0.0),
  ])

organismB = FUNCMinimizer([
  organism.Chromosom(x = -0.0, y = 0.0),
  ])

organisms = [organismA, organismB]


# Define some parameters

# True for elitism (= always keep the best organism) -- We MUST disable it here ! (Else we'll get the first organism at the end !)
ELITISM = 0

# Number of generation to run
NB_GENERATION = 10

# Number of children each generation made
NB_CHILDREN  = 100

# Number of organisms kept per generation (other children doesn't survive)
NB_ORGANISMS = 10


# Ready !

lifecycle.run(organisms, ELITISM, NB_GENERATION, NB_CHILDREN, NB_ORGANISMS)

